/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.resource.EnterpriseResource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.server.data.DataObject;
import com.projity.server.data.SerializedDataObject;
import com.projity.server.data.SerializedDataObjectFactory;
import com.projity.session.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class SerializeUtil {
    public static final boolean ZIP = true;

    public static byte[] serializeToByteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeFromByteArray(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static SerializedDataObject serialize(DataObject dataObject, SerializedDataObjectFactory serializedDataObjectFactory) throws IOException {
        ObjectOutputStream objectOutputStream;
        SerializedDataObject serializedDataObject = serializedDataObjectFactory.createSerializedDataObject();
        serializedDataObject.setUniqueId(dataObject.getUniqueId());
        serializedDataObject.setName(dataObject.getName());
        serializedDataObject.setDirty(dataObject.isDirty());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (dataObject instanceof WorkCalendar || dataObject instanceof EnterpriseResource || dataObject instanceof ResourceImpl) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("Serialized"));
            objectOutputStream = new ObjectOutputStream(zipOutputStream);
        } else {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        objectOutputStream.writeObject(dataObject);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        serializedDataObject.setSerialized(byteArrayOutputStream.toByteArray());
        return serializedDataObject;
    }

    public static DataObject deserialize(SerializedDataObject serializedDataObject, Session session) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream;
        ZipInputStream zipInputStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serializedDataObject.getSerialized());
        if (serializedDataObject.getType() == 1 || serializedDataObject.getType() == 3 || serializedDataObject.getType() == 4) {
            zipInputStream = new ZipInputStream(byteArrayInputStream);
            zipInputStream.getNextEntry();
            objectInputStream = new ObjectInputStream(zipInputStream);
        } else {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
        }
        zipInputStream = (DataObject)objectInputStream.readObject();
        zipInputStream.setUniqueId(session == null ? serializedDataObject.getUniqueId() : session.getId());
        zipInputStream.setName(serializedDataObject.getName());
        return zipInputStream;
    }
}

