/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data.mspdi;

import com.projity.association.AssociationList;
import com.projity.configuration.Settings;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.exchange.ImportedCalendarService;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.TaskSnapshot;
import com.projity.server.data.MPXConverter;
import com.projity.server.data.mspdi.TimephasedConsumer;
import com.projity.server.data.mspdi.TimephasedService;
import com.projity.util.DateTime;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.ProjectType;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;

public class ModifiedMSPDIWriter
extends MSPDIWriter {
    static Log log = LogFactory.getLog(ModifiedMSPDIWriter.class);
    protected com.projity.pm.task.Project projityProject;
    protected Map projityTaskMap = new HashMap();
    protected Map projityAssignmentMap = new HashMap();
    protected Map projitySnapshotIdMap = new HashMap();
    protected Map timephasedMap = new HashMap();
    private static Resource UNASSIGNED = null;

    protected Boolean formatOutput() {
        return Boolean.FALSE;
    }

    public void setProjectFile(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
    }

    private Resource unassignedResource() {
        if (UNASSIGNED == null) {
            UNASSIGNED = this.m_projectFile.addResource();
            UNASSIGNED.setUniqueID(-65535);
        }
        return UNASSIGNED;
    }

    protected void writeProjectCalendar(Project project) {
        int n = 1;
        ProjectCalendar projectCalendar = ImportedCalendarService.getInstance().findExportedCalendar(CalendarService.findBaseCalendar((String)this.m_projectFile.getProjectHeader().getCalendarName()));
        if (projectCalendar != null) {
            n = projectCalendar.getUniqueID();
        } else {
            log.warn("EXPORT: Could not export project calendar: Project: " + this.m_projectFile.getProjectHeader().getName() + " calendar " + this.m_projectFile.getProjectHeader().getCalendarName());
        }
        project.setCalendarUID(BigInteger.valueOf(n));
    }

    protected void writeResources(ObjectFactory objectFactory, Project project) throws JAXBException {
        ProjectType.Resources resources = objectFactory.createProjectTypeResources();
        project.setResources(resources);
        List list = resources.getResource();
        for (Resource resource : this.m_projectFile.getAllResources()) {
            if (resource.getUniqueID() == -65535) continue;
            list.add(this.writeResource(objectFactory, resource));
        }
    }

    protected ProjectType.TasksType.TaskType writeTask(ObjectFactory objectFactory, Task task) throws JAXBException {
        ProjectType.TasksType.TaskType taskType = super.writeTask(objectFactory, task);
        if (!task.getNull()) {
            this.writeTaskBaselinesAndTimephased(objectFactory, taskType, task);
        }
        return taskType;
    }

    protected ProjectType.AssignmentsType.AssignmentType writeAssignment(ObjectFactory objectFactory, ResourceAssignment resourceAssignment, int n) throws JAXBException {
        ProjectType.AssignmentsType.AssignmentType assignmentType = super.writeAssignment(objectFactory, resourceAssignment, n);
        if (resourceAssignment.getResourceID() == 0) {
            assignmentType.setResourceUID(BigInteger.valueOf(-65535L));
        }
        Assignment assignment = (Assignment)this.projityAssignmentMap.get(resourceAssignment);
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(assignment.getStop());
        assignmentType.setStop(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = DateTime.calendarInstance();
        gregorianCalendar2.setTimeInMillis(assignment.getResume());
        assignmentType.setResume(gregorianCalendar2);
        this.writeAssigmentBaselinesAndTimephased(objectFactory, assignmentType, resourceAssignment, n);
        return assignmentType;
    }

    public void setProjityProject(com.projity.pm.task.Project project) {
        this.projityProject = project;
    }

    public void putProjityTaskMap(Object object, Object object2) {
        this.projityTaskMap.put(object, object2);
    }

    public void putProjityAssignmentMap(Object object, Object object2) {
        this.projityAssignmentMap.put(object, object2);
    }

    public void putProjitySnapshotIdMap(Object object, Object object2) {
        this.projitySnapshotIdMap.put(object, object2);
    }

    public void putTimephasedList(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.timephasedMap.put(object, object2);
    }

    public List getTimephasedList(Object object) {
        return (List)this.timephasedMap.get(object);
    }

    public Resource getResourceByUniqueID(int n) {
        Resource resource = n == -65535 ? this.unassignedResource() : this.m_projectFile.getResourceByUniqueID(n);
        return resource;
    }

    private void writeTaskBaselinesAndTimephased(ObjectFactory objectFactory, ProjectType.TasksType.TaskType taskType, Task task) throws JAXBException {
        List list = taskType.getBaseline();
        NormalTask normalTask = (NormalTask)this.projityTaskMap.get(task);
        if (normalTask == null) {
            return;
        }
        for (int i = 0; i < Settings.numBaselines(); ++i) {
            AssociationList associationList;
            TaskSnapshot taskSnapshot;
            if (i == Snapshottable.CURRENT || (taskSnapshot = (TaskSnapshot)normalTask.getSnapshot((Object)new Integer(i))) == null || (associationList = taskSnapshot.getHasAssignments().getAssignments()).size() <= 0) continue;
            for (Assignment assignment : associationList) {
                ResourceImpl resourceImpl = (ResourceImpl)assignment.getResource();
                if (resourceImpl.isDefault()) continue;
                ProjectType.AssignmentsType.AssignmentType.BaselineType baselineType = objectFactory.createProjectTypeAssignmentsTypeAssignmentTypeBaselineType();
                baselineType.setNumber(i + "");
                baselineType.setStart(MPXConverter.dateToXMLString(DateTime.fromGmt((long)normalTask.getBaselineStart(i))));
                baselineType.setFinish(MPXConverter.dateToXMLString(DateTime.fromGmt((long)normalTask.getBaselineFinish(i))));
                baselineType.setWork(DatatypeConverter.printDuration(this, MPXConverter.toMPXDuration((long)normalTask.getBaselineWork(i))));
                list.add(baselineType);
            }
        }
    }

    private void writeAssigmentBaselinesAndTimephased(ObjectFactory objectFactory, final ProjectType.AssignmentsType.AssignmentType assignmentType, ResourceAssignment resourceAssignment, int n) throws JAXBException {
        int n2 = (Integer)this.projitySnapshotIdMap.get(resourceAssignment);
        Assignment assignment = (Assignment)this.projityAssignmentMap.get(resourceAssignment);
        final List list = assignmentType.getTimephasedData();
        TimephasedService.getInstance().consumeTimephased((Schedule)assignment, new TimephasedConsumer(){

            public void consumeTimephased(Object object) {
                TimephasedDataType timephasedDataType = (TimephasedDataType)object;
                ((TimephasedDataType)object).setUID(assignmentType.getUID());
                list.add(object);
            }

            public boolean acceptValue(double d) {
                return d != 0.0;
            }
        }, objectFactory);
    }

    public ProjectFile getProjectFile() {
        return this.m_projectFile;
    }
}

