/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SingleByteEncoder(Charset cs, short[] index1, String index2, int mask1, int mask2, int shift) {
        super(cs, 1.0f, 1.0f);
        this.index1 = index1;
        this.index2 = index2;
        this.mask1 = mask1;
        this.mask2 = mask2;
        this.shift = shift;
    }

    public boolean canEncode(char c) {
        char testEncode = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
        return testEncode != '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
        CoderResult coderResult;
        int sp;
        int dp;
        block13: {
            CoderResult coderResult2;
            block12: {
                CoderResult coderResult3;
                block11: {
                    CoderResult coderResult4;
                    block10: {
                        CoderResult coderResult5;
                        block9: {
                            CoderResult coderResult6;
                            block8: {
                                char[] sa = src.array();
                                byte[] da = dst.array();
                                dp = dst.arrayOffset() + dst.position();
                                int dl = dst.arrayOffset() + dst.limit();
                                dp = dp <= dl ? dp : dl;
                                try {
                                    int sl;
                                    for (sp = (sp = src.arrayOffset() + src.position()) <= (sl = src.arrayOffset() + src.limit()) ? sp : sl; sp < sl; ++sp) {
                                        char c = sa[sp];
                                        if (Surrogate.is(c)) {
                                            if (this.sgp.parse(c, sa, sp, sl) < 0) {
                                                coderResult6 = this.sgp.error();
                                                Object var13_16 = null;
                                                src.position(sp - src.arrayOffset());
                                                break block8;
                                            }
                                            coderResult5 = this.sgp.unmappableResult();
                                            break block9;
                                        }
                                        if (c >= '\ufffe') {
                                            coderResult4 = CoderResult.unmappableForLength(1);
                                            break block10;
                                        }
                                        if (dl - dp < 1) {
                                            coderResult3 = CoderResult.OVERFLOW;
                                            break block11;
                                        }
                                        char e = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                                        if (e == '\u0000' && c != '\u0000') {
                                            coderResult2 = CoderResult.unmappableForLength(1);
                                            break block12;
                                        }
                                        da[dp++] = (byte)e;
                                    }
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var13_22 = null;
                                    src.position(sp - src.arrayOffset());
                                    dst.position(dp - dst.arrayOffset());
                                    throw throwable;
                                }
                            }
                            dst.position(dp - dst.arrayOffset());
                            return coderResult6;
                        }
                        Object var13_17 = null;
                        src.position(sp - src.arrayOffset());
                        dst.position(dp - dst.arrayOffset());
                        return coderResult5;
                    }
                    Object var13_18 = null;
                    src.position(sp - src.arrayOffset());
                    dst.position(dp - dst.arrayOffset());
                    return coderResult4;
                }
                Object var13_19 = null;
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
                return coderResult3;
            }
            Object var13_20 = null;
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
            return coderResult2;
        }
        Object var13_21 = null;
        src.position(sp - src.arrayOffset());
        dst.position(dp - dst.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
        int mark = src.position();
        try {
            while (src.hasRemaining()) {
                char c = src.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, src) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char e = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                if (e == '\u0000' && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++mark;
                dst.put((byte)e);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.encodeArrayLoop(src, dst);
        }
        return this.encodeBufferLoop(src, dst);
    }

    public byte encode(char inputChar) {
        return (byte)this.index2.charAt(this.index1[(inputChar & this.mask1) >> this.shift] + (inputChar & this.mask2));
    }
}

