/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

public final class ProjectCalendar
extends ProjectEntity {
    private Integer m_uniqueID = NumberUtility.INTEGER_ZERO;
    private String m_name;
    private boolean m_baseCalendarFlag;
    private ProjectCalendar m_baseCalendar;
    private int[] m_days = new int[7];
    private LinkedList m_exceptions = new LinkedList();
    private ProjectCalendarHours[] m_hours = new ProjectCalendarHours[7];
    private Resource m_resource;
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    public static final int NON_WORKING = 0;
    public static final int WORKING = 1;
    public static final int DEFAULT = 2;

    ProjectCalendar(ProjectFile file, boolean baseCalendar) {
        super(file);
        this.m_baseCalendarFlag = baseCalendar;
        Arrays.fill(this.m_days, baseCalendar ? 1 : 2);
        if (file.getAutoCalendarUniqueID()) {
            this.setUniqueID(new Integer(file.getCalendarUniqueID()));
        }
    }

    public ProjectCalendarException addCalendarException() {
        ProjectCalendarException bce = new ProjectCalendarException();
        this.m_exceptions.add(bce);
        return bce;
    }

    public List getCalendarExceptions() {
        return this.m_exceptions;
    }

    public ProjectCalendarHours addCalendarHours(Day day) {
        ProjectCalendarHours bch = new ProjectCalendarHours(this);
        bch.setDay(day);
        this.m_hours[day.getValue() - 1] = bch;
        return bch;
    }

    public ProjectCalendarHours addCalendarHours() {
        return new ProjectCalendarHours(this);
    }

    public void attachHoursToDay(ProjectCalendarHours hours) {
        if (hours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[hours.getDay().getValue() - 1] = hours;
    }

    public void removeHoursFromDay(ProjectCalendarHours hours) {
        if (hours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[hours.getDay().getValue() - 1] = null;
    }

    public ProjectCalendarHours getCalendarHours(Day day) {
        return this.m_hours[day.getValue() - 1];
    }

    public ProjectCalendarHours[] getHours() {
        return this.m_hours;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setBaseCalendar(ProjectCalendar calendar) {
        this.m_baseCalendar = calendar;
    }

    public ProjectCalendar getBaseCalendar() {
        return this.m_baseCalendar;
    }

    public boolean isWorkingDay(Day day) {
        ProjectCalendar cal;
        int value = this.m_days[day.getValue() - 1];
        boolean result = value == 2 ? ((cal = this.getBaseCalendar()) != null ? cal.isWorkingDay(day) : day != Day.SATURDAY && day != Day.SUNDAY) : value == 1;
        return result;
    }

    public int[] getDays() {
        return this.m_days;
    }

    public int getWorkingDay(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public void setWorkingDay(Day day, int working) {
        this.m_days[day.getValue() - 1] = working;
    }

    public void setWorkingDay(Day day, boolean working) {
        this.setWorkingDay(day, working ? 1 : 0);
    }

    public void setWorkingDay(Day day, Integer working) {
        int value = working == null ? (!this.m_baseCalendarFlag ? 2 : 1) : working;
        this.setWorkingDay(day, value);
    }

    public void addDefaultCalendarHours() throws MPXJException {
        try {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            Date from1 = df.parse("08:00");
            Date to1 = df.parse("12:00");
            Date from2 = df.parse("13:00");
            Date to2 = df.parse("17:00");
            ProjectCalendarHours hours = this.addCalendarHours(Day.SUNDAY);
            hours = this.addCalendarHours(Day.MONDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.TUESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.WEDNESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.THURSDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.FRIDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = this.addCalendarHours(Day.SATURDAY);
        }
        catch (ParseException ex) {
            throw new MPXJException("Invalid time", ex);
        }
    }

    public Duration getDuration(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dayIndex = cal.get(7);
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), Day.getInstance(dayIndex))) {
                ++duration;
            }
            --days;
            if (++dayIndex > 7) {
                dayIndex = 1;
            }
            cal.set(6, cal.get(6) + 1);
        }
        return Duration.getInstance(duration, TimeUnit.DAYS);
    }

    public Date getDate(Date startDate, Duration duration) {
        boolean negative;
        Duration dur = duration.convertUnits(TimeUnit.DAYS, this.getParentFile().getProjectHeader());
        int days = (int)dur.getDuration();
        if (days < 0) {
            negative = true;
            days = -days;
        } else {
            negative = false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dayIndex = cal.get(7);
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), Day.getInstance(dayIndex))) {
                --days;
            }
            if (!negative) {
                if (++dayIndex > 7) {
                    dayIndex = 1;
                }
                cal.set(6, cal.get(6) + 1);
                continue;
            }
            if (--dayIndex < 1) {
                dayIndex = 7;
            }
            cal.set(6, cal.get(6) - 1);
        }
        return cal.getTime();
    }

    public boolean isWorkingDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Day day = Day.getInstance(cal.get(7));
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        ProjectCalendarException exception = this.getException(date);
        boolean result = exception != null ? exception.getWorking() : this.isWorkingDay(day);
        return result;
    }

    private int getDaysInRange(Date startDate, Date endDate) {
        int result;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        int endDateYear = cal.get(1);
        int endDateDayOfYear = cal.get(6);
        cal.setTime(startDate);
        if (endDateYear == cal.get(1)) {
            result = endDateDayOfYear - cal.get(6) + 1;
        } else {
            result = 0;
            do {
                result += cal.getActualMaximum(6) - cal.get(6) + 1;
                cal.roll(1, 1);
                cal.set(6, 1);
            } while (cal.get(1) < endDateYear);
            result += endDateDayOfYear;
        }
        return result;
    }

    public boolean isBaseCalendar() {
        return this.m_baseCalendarFlag;
    }

    public void setUniqueID(Integer uniqueID) {
        ProjectFile parent = this.getParentFile();
        if (this.m_uniqueID != null) {
            parent.unmapTaskUniqueID(this.m_uniqueID);
        }
        parent.mapCalendarUniqueID(uniqueID, this);
        this.m_uniqueID = uniqueID;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void setResource(Resource resource) {
        this.m_resource = resource;
        this.m_name = this.m_resource.getName();
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(Date date) {
        Iterator iter = this.m_exceptions.iterator();
        ProjectCalendarException exception = null;
        while (iter.hasNext()) {
            exception = (ProjectCalendarException)iter.next();
            if (exception.contains(date)) break;
            exception = null;
        }
        return exception;
    }

    public Duration getWork(Date startDate, Date endDate, TimeUnit format) {
        boolean invert = false;
        if (startDate.getTime() > endDate.getTime()) {
            invert = true;
            Date temp = startDate;
            startDate = endDate;
            endDate = temp;
        }
        Date canonicalStartDate = DateUtility.getDayStartDate(startDate);
        Date canonicalEndDate = DateUtility.getDayStartDate(endDate);
        long totalTime = 0L;
        if (canonicalStartDate.getTime() == canonicalEndDate.getTime()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            Day day = Day.getInstance(cal.get(7));
            if (this.isWorkingDate(startDate, day)) {
                ProjectCalendarException exception = this.getException(startDate);
                totalTime = exception == null ? this.getTotalTime(this.getCalendarHours(day), startDate, endDate) : this.getTotalTime(exception, startDate, endDate);
            }
        } else {
            ProjectCalendarException exception;
            Date currentDate = startDate;
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            Day day = Day.getInstance(cal.get(7));
            while (!this.isWorkingDate(currentDate, day) && currentDate.getTime() < canonicalEndDate.getTime()) {
                cal.add(6, 1);
                currentDate = cal.getTime();
                day = day.getNextDay();
            }
            if (currentDate.getTime() < canonicalEndDate.getTime()) {
                exception = this.getException(currentDate);
                totalTime = exception == null ? (totalTime += this.getTotalTime(this.getCalendarHours(day), currentDate, true)) : (totalTime += this.getTotalTime(exception, currentDate, true));
                while (true) {
                    cal.add(6, 1);
                    currentDate = cal.getTime();
                    day = day.getNextDay();
                    if (currentDate.getTime() > canonicalEndDate.getTime()) break;
                    if (!this.isWorkingDate(currentDate, day)) continue;
                    exception = this.getException(currentDate);
                    if (exception == null) {
                        totalTime += this.getTotalTime(this.getCalendarHours(day));
                        continue;
                    }
                    totalTime += this.getTotalTime(exception);
                }
            }
            if (this.isWorkingDate(endDate, day)) {
                exception = this.getException(endDate);
                totalTime = exception == null ? (totalTime += this.getTotalTime(this.getCalendarHours(day), endDate, false)) : (totalTime += this.getTotalTime(exception, endDate, false));
            }
        }
        double duration = 0.0;
        switch (format.getValue()) {
            case 0: {
                duration = totalTime;
                duration /= 60000.0;
                break;
            }
            case 1: {
                duration = totalTime;
                duration /= 3600000.0;
                break;
            }
            case 2: {
                duration = totalTime;
                duration /= this.getParentFile().getProjectHeader().getMinutesPerDay().doubleValue() * 60.0 * 1000.0;
                break;
            }
            case 3: {
                duration = totalTime;
                duration /= this.getParentFile().getProjectHeader().getMinutesPerWeek().doubleValue() * 60.0 * 1000.0;
                break;
            }
            case 4: {
                ProjectHeader header = this.getParentFile().getProjectHeader();
                duration = totalTime;
                duration /= header.getDaysPerMonth().doubleValue() * header.getMinutesPerDay().doubleValue() * 60.0 * 1000.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + format + " not supported");
            }
        }
        if (invert) {
            duration = -duration;
        }
        return Duration.getInstance(duration, format);
    }

    private long getTotalTime(ProjectCalendarException exception, Date date, boolean after) {
        long currentTime = DateUtility.getCanonicalTime(date).getTime();
        long total = this.getTime(exception.getFromTime1(), exception.getToTime1(), currentTime, after);
        total += this.getTime(exception.getFromTime2(), exception.getToTime2(), currentTime, after);
        total += this.getTime(exception.getFromTime3(), exception.getToTime3(), currentTime, after);
        total += this.getTime(exception.getFromTime4(), exception.getToTime4(), currentTime, after);
        return total += this.getTime(exception.getFromTime5(), exception.getToTime5(), currentTime, after);
    }

    private long getTotalTime(ProjectCalendarException exception) {
        long total = this.getTime(exception.getFromTime1(), exception.getToTime1());
        total += this.getTime(exception.getFromTime2(), exception.getToTime2());
        total += this.getTime(exception.getFromTime3(), exception.getToTime3());
        total += this.getTime(exception.getFromTime4(), exception.getToTime4());
        return total += this.getTime(exception.getFromTime5(), exception.getToTime5());
    }

    private long getTotalTime(ProjectCalendarException exception, Date startDate, Date endDate) {
        Date start = DateUtility.getCanonicalTime(startDate);
        Date end = DateUtility.getCanonicalTime(endDate);
        long total = this.getTime(DateUtility.getCanonicalTime(exception.getFromTime1()), DateUtility.getCanonicalTime(exception.getToTime1()), start, end);
        total += this.getTime(DateUtility.getCanonicalTime(exception.getFromTime2()), DateUtility.getCanonicalTime(exception.getToTime2()), start, end);
        total += this.getTime(DateUtility.getCanonicalTime(exception.getFromTime3()), DateUtility.getCanonicalTime(exception.getToTime3()), start, end);
        total += this.getTime(DateUtility.getCanonicalTime(exception.getFromTime4()), DateUtility.getCanonicalTime(exception.getToTime4()), start, end);
        return total += this.getTime(DateUtility.getCanonicalTime(exception.getFromTime5()), DateUtility.getCanonicalTime(exception.getToTime5()), start, end);
    }

    private long getTotalTime(ProjectCalendarHours hours, Date date, boolean after) {
        long total = 0L;
        long currentTime = DateUtility.getCanonicalTime(date).getTime();
        Iterator iter = hours.iterator();
        while (iter.hasNext()) {
            DateRange range = (DateRange)iter.next();
            total += this.getTime(range.getStartDate(), range.getEndDate(), currentTime, after);
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours hours, Date startDate, Date endDate) {
        long total = 0L;
        Date start = DateUtility.getCanonicalTime(startDate);
        Date end = DateUtility.getCanonicalTime(endDate);
        Iterator iter = hours.iterator();
        while (iter.hasNext()) {
            DateRange range = (DateRange)iter.next();
            total += this.getTime(start, end, DateUtility.getCanonicalTime(range.getStartDate()), DateUtility.getCanonicalTime(range.getEndDate()));
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours hours) {
        long total = 0L;
        Iterator iter = hours.iterator();
        while (iter.hasNext()) {
            DateRange range = (DateRange)iter.next();
            total += this.getTime(range.getStartDate(), range.getEndDate());
        }
        return total;
    }

    private long getTime(Date start, Date end, long target, boolean after) {
        long total = 0L;
        if (start != null && end != null) {
            Date endTime;
            Date startTime = DateUtility.getCanonicalTime(start);
            int diff = DateUtility.compare(startTime, endTime = DateUtility.getCanonicalTime(end), target);
            if (diff == 0) {
                total = after ? endTime.getTime() - target : target - startTime.getTime();
            } else if (after && diff < 0 || !after && diff > 0) {
                total = endTime.getTime() - startTime.getTime();
            }
        }
        return total;
    }

    private long getTime(Date start, Date end) {
        long total = 0L;
        if (start != null && end != null) {
            Date startTime = DateUtility.getCanonicalTime(start);
            Date endTime = DateUtility.getCanonicalTime(end);
            total = endTime.getTime() - startTime.getTime();
        }
        return total;
    }

    private long getTime(Date start1, Date end1, Date start2, Date end2) {
        long end;
        long start;
        long total = 0L;
        if (start1 != null && end1 != null && start2 != null && end2 != null && (start = start1.getTime() < start2.getTime() ? start2.getTime() : start1.getTime()) < (end = end1.getTime() < end2.getTime() ? end1.getTime() : end2.getTime())) {
            total = end - start;
        }
        return total;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendar");
        pw.println("   ID=" + this.m_uniqueID);
        pw.println("   name=" + this.m_name);
        pw.println("   baseCalendarFlag=" + this.m_baseCalendarFlag);
        pw.println("   baseCalendarName=" + (this.m_baseCalendar == null ? "" : this.m_baseCalendar.getName()));
        pw.println("   resource=" + (this.m_resource == null ? "" : this.m_resource.getName()));
        String[] dayType = new String[]{"Non-working", "Working", "Default"};
        String[] dayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        int loop = 0;
        while (loop < 7) {
            pw.println("   [Day " + dayName[loop]);
            pw.println("      type=" + dayType[this.m_days[loop]]);
            pw.println("      hours=" + this.m_hours[loop]);
            pw.println("   ]");
            ++loop;
        }
        if (!this.m_exceptions.isEmpty()) {
            pw.println("   [Exceptions=");
            Iterator iter = this.m_exceptions.iterator();
            while (iter.hasNext()) {
                pw.println("      " + iter.next().toString());
            }
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

