/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.mpxj.Duration;

final class XsdDuration {
    private boolean m_hasTime;
    private int m_years;
    private int m_months;
    private int m_days;
    private int m_hours;
    private int m_minutes;
    private double m_seconds;
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols();
    private static final DecimalFormat FORMAT;

    static {
        SYMBOLS.setDecimalSeparator('.');
        FORMAT = new DecimalFormat("#", SYMBOLS);
    }

    XsdDuration(String duration) {
        int length;
        if (duration != null && (length = duration.length()) > 0) {
            boolean negative;
            int index;
            if (duration.charAt(0) != 'P' && (length < 2 || duration.charAt(0) != '-' && duration.charAt(1) != 'P')) {
                throw new IllegalArgumentException(duration);
            }
            if (duration.charAt(0) == '-') {
                index = 2;
                negative = true;
            } else {
                index = 1;
                negative = false;
            }
            while (index < length) {
                index = this.readComponent(duration, index, length);
            }
            if (negative) {
                this.m_years = -this.m_years;
                this.m_months = -this.m_months;
                this.m_days = -this.m_days;
                this.m_hours = -this.m_hours;
                this.m_minutes = -this.m_minutes;
                this.m_seconds = -this.m_seconds;
            }
        }
    }

    XsdDuration(Duration duration) {
        double amount;
        if (duration != null && (amount = duration.getDuration()) != 0.0) {
            switch (duration.getUnits().getValue()) {
                case 0: 
                case 7: {
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case 1: 
                case 8: {
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case 2: 
                case 9: {
                    this.m_days = (int)amount;
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case 3: 
                case 10: {
                    this.m_days = (int)(amount *= 7.0);
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case 4: 
                case 11: {
                    this.m_months = (int)amount;
                    amount = amount * 28.0 - (double)(this.m_months * 28);
                    this.m_days = (int)amount;
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case 5: 
                case 12: {
                    this.m_years = (int)amount;
                    amount = amount * 12.0 - (double)(this.m_years * 12);
                    this.m_months = (int)amount;
                    amount = amount * 28.0 - (double)(this.m_months * 28);
                    this.m_days = (int)amount;
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                }
            }
        }
    }

    private int readComponent(String duration, int index, int length) {
        char c = '\u0000';
        StringBuffer number = new StringBuffer();
        while (index < length) {
            c = duration.charAt(index);
            if (!Character.isDigit(c) && c != 46) break;
            number.append(c);
            ++index;
        }
        switch (c) {
            case 'Y': {
                this.m_years = (int)Math.floor(Double.parseDouble(number.toString()));
                break;
            }
            case 'M': {
                if (!this.m_hasTime) {
                    this.m_months = (int)Math.floor(Double.parseDouble(number.toString()));
                    break;
                }
                this.m_minutes = (int)((double)this.m_minutes + Math.floor(Double.parseDouble(number.toString())));
                break;
            }
            case 'D': {
                this.m_days = (int)Math.floor(Double.parseDouble(number.toString()));
                break;
            }
            case 'T': {
                this.m_hasTime = true;
                break;
            }
            case 'H': {
                double h = Double.parseDouble(number.toString());
                if ((double)Math.round(h) != h) {
                    this.m_hours = (int)Math.floor(h);
                    double min = (h - (double)this.m_hours) * 60.0;
                    this.m_minutes += (int)Math.floor(min);
                    double sec = (min - (double)this.m_minutes) * 60.0;
                    this.m_seconds += (double)Math.round(sec);
                    break;
                }
                this.m_hours = (int)h;
                break;
            }
            case 'S': {
                this.m_seconds += Double.parseDouble(number.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException(duration);
            }
        }
        return ++index;
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public int getMonths() {
        return this.m_months;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    public int getYears() {
        return this.m_years;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("P");
        boolean negative = false;
        if (this.m_years != 0 || this.m_months != 0 || this.m_days != 0) {
            if (this.m_years < 0) {
                negative = true;
                buffer.append(-this.m_years);
            } else {
                buffer.append(this.m_years);
            }
            buffer.append("Y");
            if (this.m_months < 0) {
                negative = true;
                buffer.append(-this.m_months);
            } else {
                buffer.append(this.m_months);
            }
            buffer.append("M");
            if (this.m_days < 0) {
                negative = true;
                buffer.append(-this.m_days);
            } else {
                buffer.append(this.m_days);
            }
            buffer.append("D");
        }
        buffer.append("T");
        if (this.m_hours < 0) {
            negative = true;
            buffer.append(-this.m_hours);
        } else {
            buffer.append(this.m_hours);
        }
        buffer.append("H");
        if (this.m_minutes < 0) {
            negative = true;
            buffer.append(-this.m_minutes);
        } else {
            buffer.append(this.m_minutes);
        }
        buffer.append("M");
        if (this.m_seconds < 0.0) {
            negative = true;
            buffer.append(FORMAT.format(-this.m_seconds));
        } else {
            buffer.append(FORMAT.format(this.m_seconds));
        }
        buffer.append("S");
        if (negative) {
            buffer.insert(0, '-');
        }
        return buffer.toString();
    }
}

