/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.HeaderBlockReader;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;

public class POIFSFileSystem {
    private PropertyTable _property_table = new PropertyTable();
    private List _documents = new ArrayList();
    private DirectoryNode _root = null;

    public POIFSFileSystem() {
    }

    public POIFSFileSystem(InputStream stream) throws IOException {
        this();
        HeaderBlockReader header_block_reader = new HeaderBlockReader(stream);
        RawDataBlockList data_blocks = new RawDataBlockList(stream);
        new BlockAllocationTableReader(header_block_reader.getBATCount(), header_block_reader.getBATArray(), header_block_reader.getXBATCount(), header_block_reader.getXBATIndex(), data_blocks);
        PropertyTable properties = new PropertyTable(header_block_reader.getPropertyStart(), data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(data_blocks, properties.getRoot(), header_block_reader.getSBATStart()), data_blocks, properties.getRoot().getChildren(), null);
    }

    public DirectoryEntry getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    void addDocument(POIFSDocument document) {
        this._documents.add(document);
        this._property_table.addProperty(document.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, DirectoryNode dir) throws IOException {
        while (properties.hasNext()) {
            DirectoryNode parent;
            Property property = (Property)properties.next();
            String name = property.getName();
            DirectoryNode directoryNode = parent = dir == null ? (DirectoryNode)this.getRoot() : dir;
            if (property.isDirectory()) {
                DirectoryNode new_dir = (DirectoryNode)parent.createDirectory(name);
                new_dir.setStorageClsid(property.getStorageClsid());
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_dir);
                continue;
            }
            int startBlock = property.getStartBlock();
            int size = property.getSize();
            POIFSDocument document = null;
            document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock), size) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock), size);
            parent.createDocument(document);
        }
    }
}

