/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyFactory;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.RawDataBlockList;

public class PropertyTable
implements BlockWritable {
    private int _start_block = -2;
    private List _properties;
    private BlockWritable[] _blocks;

    public PropertyTable() {
        this._properties = new ArrayList();
        this.addProperty(new RootProperty());
        this._blocks = null;
    }

    public PropertyTable(int startBlock, RawDataBlockList blockList) throws IOException {
        this._blocks = null;
        this._properties = PropertyFactory.convertToProperties(blockList.fetchBlocks(startBlock));
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    private void populatePropertyTree(DirectoryProperty root) throws IOException {
        int index = root.getChildIndex();
        if (!Property.isValidIndex(index)) {
            return;
        }
        Stack children = new Stack();
        children.push(this._properties.get(index));
        while (!children.empty()) {
            Property property = (Property)children.pop();
            root.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (Property.isValidIndex(index = property.getPreviousChildIndex())) {
                children.push(this._properties.get(index));
            }
            if (!Property.isValidIndex(index = property.getNextChildIndex())) continue;
            children.push(this._properties.get(index));
        }
    }
}

