/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.ListManagedBlock;

public class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private byte[] _data = new byte[64];

    private SmallDocumentBlock(byte[] data, int index) {
        this();
        System.arraycopy(data, index * 64, this._data, 0, 64);
    }

    private SmallDocumentBlock() {
    }

    public static SmallDocumentBlock[] convert(byte[] array, int size) {
        SmallDocumentBlock[] rval = new SmallDocumentBlock[(size + 64 - 1) / 64];
        int offset = 0;
        for (int k = 0; k < rval.length; ++k) {
            rval[k] = new SmallDocumentBlock();
            if (offset < array.length) {
                int length = Math.min(64, array.length - offset);
                System.arraycopy(array, offset, rval[k]._data, 0, length);
                if (length != 64) {
                    Arrays.fill(rval[k]._data, length, 64, (byte)-1);
                }
            } else {
                Arrays.fill(rval[k]._data, (byte)-1);
            }
            offset += 64;
        }
        return rval;
    }

    public static List extract(ListManagedBlock[] blocks) throws IOException {
        ArrayList<SmallDocumentBlock> sdbs = new ArrayList<SmallDocumentBlock>();
        for (int j = 0; j < blocks.length; ++j) {
            byte[] data = blocks[j].getData();
            for (int k = 0; k < 8; ++k) {
                sdbs.add(new SmallDocumentBlock(data, k));
            }
        }
        return sdbs;
    }

    public static void read(BlockWritable[] blocks, byte[] buffer, int offset) {
        int firstBlockIndex = offset / 64;
        int firstBlockOffset = offset % 64;
        int lastBlockIndex = (offset + buffer.length - 1) / 64;
        if (firstBlockIndex == lastBlockIndex) {
            System.arraycopy(((SmallDocumentBlock)blocks[firstBlockIndex])._data, firstBlockOffset, buffer, 0, buffer.length);
        } else {
            int buffer_offset = 0;
            System.arraycopy(((SmallDocumentBlock)blocks[firstBlockIndex])._data, firstBlockOffset, buffer, buffer_offset, 64 - firstBlockOffset);
            buffer_offset += 64 - firstBlockOffset;
            for (int j = firstBlockIndex + 1; j < lastBlockIndex; ++j) {
                System.arraycopy(((SmallDocumentBlock)blocks[j])._data, 0, buffer, buffer_offset, 64);
                buffer_offset += 64;
            }
            System.arraycopy(((SmallDocumentBlock)blocks[lastBlockIndex])._data, 0, buffer, buffer_offset, buffer.length - buffer_offset);
        }
    }

    public static int calcSize(int size) {
        return size * 64;
    }

    public byte[] getData() throws IOException {
        return this._data;
    }
}

