/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.datatype.DurationFormat;
import com.projity.options.CalendarOption;
import com.projity.options.ScheduleOption;
import com.projity.util.MathUtils;

public class Duration
extends Number
implements Comparable {
    private static final long serialVersionUID = 1489291902577173002L;
    private long encodedMillis;
    protected boolean work = false;
    public static final long MAX_DURATION = 105120000000L;
    public static final Duration ZERO = new Duration(0L);
    private static int SHIFT = 57;
    private static long ESTIMATED_BIT = 32L << SHIFT;
    private static long ELAPSED_BIT = 16L << SHIFT;
    private static long PERCENT_BIT = 15L << SHIFT;
    private static long YEARS_BIT = 14L << SHIFT;
    private static long MONTHS_BIT = 13L << SHIFT;
    private static long WEEKS_BIT = 12L << SHIFT;
    private static long DAYS_BIT = 11L << SHIFT;
    private static long HOURS_BIT = 10L << SHIFT;
    private static long MINUTES_BIT = 9L << SHIFT;
    private static long SECONDS_BIT = 8L << SHIFT;
    private static long NON_TEMPORAL_BIT = 7L << SHIFT;
    private static long UNITS_MASK = 15L << SHIFT;
    private static long ELAPSED_AND_UNITS_MASK = 31L << SHIFT;
    private static long MILLIS_MASK = 63L << SHIFT ^ 0xFFFFFFFFFFFFFFFFL;

    private Duration(Double d2) {
        this(d2 == null ? 0L : d2.longValue());
    }

    public Duration(long l2) {
        this.encodedMillis = l2;
    }

    public String toString() {
        return DurationFormat.getInstance().format(this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Duration) {
            return this.encodedMillis == ((Duration)object).encodedMillis;
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Duration)) {
            throw new ClassCastException();
        }
        return MathUtils.signum(Duration.getValue(this.encodedMillis) - Duration.getValue(((Duration)object).getEncodedMillis()));
    }

    public long getEncodedMillis() {
        return this.encodedMillis;
    }

    public void setEncodedMillis(long l2) {
        this.encodedMillis = l2;
    }

    public void setWork(boolean bl) {
        this.work = bl;
    }

    public boolean isWork() {
        return this.work;
    }

    public static long clear(long l2) {
        return l2 & ELAPSED_AND_UNITS_MASK;
    }

    public static boolean isZero(long l2) {
        return Duration.millis(l2) == 0L;
    }

    private static long getBits(long l2, long l3) {
        if (l3 < 0L) {
            l3 = -l3;
        }
        return l3 & l2;
    }

    private static long setBits(long l2, long l3) {
        boolean bl;
        boolean bl2 = bl = l3 < 0L;
        if (bl) {
            l3 = -l3;
        }
        l3 |= l2;
        if (bl) {
            l3 = -l3;
        }
        return l3;
    }

    private static long clearBits(long l2, long l3) {
        boolean bl;
        boolean bl2 = bl = l3 < 0L;
        if (bl) {
            l3 = -l3;
        }
        l3 &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l3 = -l3;
        }
        return l3;
    }

    private static long setBits(long l2, long l3, long l4) {
        boolean bl;
        boolean bl2 = bl = l2 < 0L;
        if (bl) {
            l2 = -l2;
        }
        long l5 = l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
        l2 = l5 | l4;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    public static boolean isElapsed(long l2) {
        return Duration.getBits(ELAPSED_BIT, l2) == ELAPSED_BIT;
    }

    public static long setAsElapsed(long l2) {
        return Duration.setBits(l2, ELAPSED_BIT, ELAPSED_BIT);
    }

    public static boolean isEstimated(long l2) {
        return Duration.getBits(ESTIMATED_BIT, l2) == ESTIMATED_BIT;
    }

    public static long setAsEstimated(long l2, boolean bl) {
        if (bl) {
            return Duration.setBits(ESTIMATED_BIT, l2);
        }
        return Duration.clearBits(ESTIMATED_BIT, l2);
    }

    public static boolean hasUnits(long l2) {
        return Duration.getBits(UNITS_MASK, l2) != 0L;
    }

    public static long millis(long l2) {
        boolean bl;
        boolean bl2 = bl = l2 < 0L;
        if (bl) {
            l2 = -l2;
        }
        l2 &= MILLIS_MASK;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    public static float getPercentAsDecimal(long l2) {
        int n2 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        return Float.intBitsToFloat(n2);
    }

    public static long setPercentAsDecimal(long l2, float f2) {
        l2 &= 0xFFFFFFFF00000000L;
        return l2 |= (long)Float.floatToIntBits(f2);
    }

    public static boolean isPercent(long l2) {
        return Duration.getBits(UNITS_MASK, l2) == PERCENT_BIT;
    }

    public static long setAsPercent(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, PERCENT_BIT);
    }

    public static long setAsElapsedPercent(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | PERCENT_BIT);
    }

    public static long setAsNonTemporal(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, NON_TEMPORAL_BIT);
    }

    public static long setAsSeconds(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, SECONDS_BIT);
    }

    public static long setAsElapsedSeconds(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | SECONDS_BIT);
    }

    public static long setAsMinutes(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, MINUTES_BIT);
    }

    public static long setAsElapsedMinutes(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | MINUTES_BIT);
    }

    public static long setAsHours(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, HOURS_BIT);
    }

    public static long setAsElapsedHours(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | SECONDS_BIT);
    }

    public static long setAsDays(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, DAYS_BIT);
    }

    public static long setAsElapsedDays(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | DAYS_BIT);
    }

    public static long setAsWeeks(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, WEEKS_BIT);
    }

    public static long setAsElapsedWeeks(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | WEEKS_BIT);
    }

    public static long setAsMonths(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, MONTHS_BIT);
    }

    public static long setAsElapsedMonths(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | MONTHS_BIT);
    }

    public static long setAsYears(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, YEARS_BIT);
    }

    public static long setAsElapsedYears(long l2) {
        return Duration.setBits(l2, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | YEARS_BIT);
    }

    public static long useTimeUnitOfInNone(long l2, long l3) {
        if (Duration.getType(l2) == -1) {
            return Duration.setAsTimeUnit(l2, Duration.getType(l3));
        }
        return l2;
    }

    public static long setAsTimeUnit(long l2, int n2) {
        switch (n2) {
            case 6: {
                return Duration.setAsPercent(l2);
            }
            case 13: {
                return Duration.setAsElapsedPercent(l2);
            }
            case -2: {
                return Duration.setAsNonTemporal(l2);
            }
            case 0: {
                return Duration.setAsMinutes(l2);
            }
            case 7: {
                return Duration.setAsElapsedMinutes(l2);
            }
            case 1: {
                return Duration.setAsHours(l2);
            }
            case 8: {
                return Duration.setAsElapsedHours(l2);
            }
            case 2: {
                return Duration.setAsDays(l2);
            }
            case 9: {
                long l3 = Duration.setAsDays(l2);
                long l4 = Duration.setAsElapsedDays(l2);
                return Duration.setAsElapsedDays(l2);
            }
            case 3: {
                return Duration.setAsWeeks(l2);
            }
            case 10: {
                return Duration.setAsElapsedWeeks(l2);
            }
            case 4: {
                return Duration.setAsMonths(l2);
            }
            case 11: {
                return Duration.setAsElapsedMonths(l2);
            }
            case 5: {
                return Duration.setAsYears(l2);
            }
            case 12: {
                return Duration.setAsElapsedYears(l2);
            }
        }
        return l2;
    }

    public static double timeUnitFactor(int n2) {
        double d2 = 1.0;
        if (n2 == -1) {
            n2 = ScheduleOption.getInstance().getDurationEnteredIn();
        }
        switch (n2) {
            case -2: {
                return 1.0;
            }
            case 0: 
            case 7: {
                return 60000.0;
            }
            case 1: 
            case 8: {
                return 3600000.0;
            }
            case 2: {
                return CalendarOption.getInstance().getHoursPerDay() * 60.0 * 60.0 * 1000.0;
            }
            case 9: {
                return 8.64E7;
            }
            case 3: {
                return CalendarOption.getInstance().getHoursPerWeek() * 60.0 * 60.0 * 1000.0;
            }
            case 10: {
                return 6.048E8;
            }
            case 4: {
                return CalendarOption.getInstance().hoursPerMonth() * 60.0 * 60.0 * 1000.0;
            }
            case 11: {
                return 2.592E9;
            }
            case 5: {
                return 365.0 * CalendarOption.getInstance().getHoursPerDay() * 60.0 * 60.0 * 1000.0;
            }
            case 12: {
                return 1.471228928E9;
            }
        }
        return d2;
    }

    public static long getInstance(double d2, int n2) {
        long l2 = 0L;
        l2 = n2 == 6 || n2 == 13 ? Duration.setPercentAsDecimal(l2, (float)d2) : Math.round(d2 * Duration.timeUnitFactor(n2));
        l2 = Duration.setAsTimeUnit(l2, n2);
        return l2;
    }

    public static double getValue(long l2) {
        int n2 = Duration.getEffectiveType(l2);
        if (n2 == 6 || n2 == 13) {
            return Duration.getPercentAsDecimal(l2);
        }
        return (double)Duration.millis(l2) / Duration.timeUnitFactor(n2);
    }

    public static int getType(long l2) {
        long l3 = Duration.getBits(ELAPSED_AND_UNITS_MASK, l2);
        if (l3 == PERCENT_BIT) {
            return 6;
        }
        if (l3 == (ELAPSED_BIT | PERCENT_BIT)) {
            return 13;
        }
        if (l3 == YEARS_BIT) {
            return 5;
        }
        if (l3 == (ELAPSED_BIT | YEARS_BIT)) {
            return 12;
        }
        if (l3 == MONTHS_BIT) {
            return 4;
        }
        if (l3 == (ELAPSED_BIT | MONTHS_BIT)) {
            return 11;
        }
        if (l3 == WEEKS_BIT) {
            return 3;
        }
        if (l3 == (ELAPSED_BIT | WEEKS_BIT)) {
            return 10;
        }
        if (l3 == DAYS_BIT) {
            return 2;
        }
        if (l3 == (ELAPSED_BIT | DAYS_BIT)) {
            return 9;
        }
        if (l3 == HOURS_BIT) {
            return 1;
        }
        if (l3 == (ELAPSED_BIT | HOURS_BIT)) {
            return 8;
        }
        if (l3 == MINUTES_BIT) {
            return 0;
        }
        if (l3 == (ELAPSED_BIT | MINUTES_BIT)) {
            return 7;
        }
        if (l3 == NON_TEMPORAL_BIT) {
            return -2;
        }
        return -1;
    }

    public static int getEffectiveType(long l2) {
        int n2 = Duration.getType(l2);
        if (n2 == -1) {
            n2 = ScheduleOption.getInstance().getDurationEnteredIn();
        }
        return n2;
    }

    public static Duration getInstanceFromDouble(Double d2) {
        return new Duration(d2);
    }

    public double doubleValue() {
        return Duration.millis(this.encodedMillis);
    }

    public float floatValue() {
        return Duration.millis(this.encodedMillis);
    }

    public int intValue() {
        return (int)Duration.millis(this.encodedMillis);
    }

    public long longValue() {
        return Duration.millis(this.encodedMillis);
    }

    public double getAsHours() {
        return this.doubleValue() / Duration.timeUnitFactor(1);
    }

    public double getAsDays() {
        return this.doubleValue() / Duration.timeUnitFactor(2);
    }
}

