/*
 * Decompiled with CFR 0.152.
 */
package com.projity.functor;

import com.projity.configuration.Settings;
import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.StringValueTransformer;

public class StringList
implements Closure {
    private StringBuffer buffer = new StringBuffer();
    private String separator = Settings.LIST_SEPARATOR;
    private Transformer transformer = null;

    private StringList() {
        this(StringValueTransformer.INSTANCE);
    }

    private StringList(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void execute(Object object) {
        if (object != null) {
            if (this.buffer.length() > 0) {
                this.buffer.append(this.separator);
            }
            this.buffer.append(this.transformer.transform(object));
        }
    }

    public String toString() {
        return this.buffer.toString();
    }

    public static String list(Collection collection) {
        return StringList.list(collection, StringValueTransformer.INSTANCE);
    }

    public static String commaSeparatedList(Collection collection) {
        StringList stringList = StringList.getInstance(StringValueTransformer.INSTANCE);
        stringList.setSeparator(",");
        CollectionUtils.forAllDo(collection, stringList);
        return stringList.toString();
    }

    public static String brSeparatedList(Collection collection) {
        StringList stringList = StringList.getInstance(StringValueTransformer.INSTANCE);
        stringList.setSeparator("<br>");
        CollectionUtils.forAllDo(collection, stringList);
        return stringList.toString();
    }

    public static String commaQuestionMarkString(Collection collection) {
        return StringList.list(collection, ",", new Transformer(){

            public Object transform(Object object) {
                return "?";
            }
        });
    }

    public static String list(Collection collection, Transformer transformer) {
        StringList stringList = StringList.getInstance(transformer);
        CollectionUtils.forAllDo(collection, stringList);
        return stringList.toString();
    }

    public static String list(Collection collection, String string, Transformer transformer) {
        StringList stringList = StringList.getInstance(transformer);
        stringList.setSeparator(string);
        CollectionUtils.forAllDo(collection, stringList);
        return stringList.toString();
    }

    public static String listWithMaxAndMessage(Collection collection, int n2, String string, Transformer transformer) {
        if (collection.size() > n2) {
            return MessageFormat.format(string, new Integer(collection.size()));
        }
        return StringList.list(collection, transformer);
    }

    public static String rows(Collection collection) {
        StringList stringList = StringList.getInstance();
        stringList.setSeparator("\n");
        CollectionUtils.forAllDo(collection, stringList);
        return stringList.toString();
    }

    public static StringList getInstance() {
        return new StringList();
    }

    public static StringList getInstance(Transformer transformer) {
        return new StringList(transformer);
    }

    public static String repeat(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

