/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.functor;

import com.projity.algorithm.CollectionIntervalGenerator;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.ContourBucketIntervalGenerator;
import com.projity.pm.assignment.functor.AssignmentFieldOvertimeFunctor;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.costing.CostRate;
import com.projity.pm.time.HasStartAndEnd;

public class CostFunctor
extends AssignmentFieldOvertimeFunctor {
    CollectionIntervalGenerator costRateGenerator;
    long fixedCostDate;
    boolean proratedCost;
    double fixedValue = 0.0;
    double regularWork = 0.0;
    double overtimeWork = 0.0;
    double work = 0.0;

    public static CostFunctor getInstance(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator, double d2, CollectionIntervalGenerator collectionIntervalGenerator, long l2, boolean bl) {
        return new CostFunctor(assignment, workCalendar, contourBucketIntervalGenerator, d2, collectionIntervalGenerator, l2, bl);
    }

    private CostFunctor(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator, double d2, CollectionIntervalGenerator collectionIntervalGenerator, long l2, boolean bl) {
        super(assignment, workCalendar, contourBucketIntervalGenerator, d2);
        this.costRateGenerator = collectionIntervalGenerator;
        this.fixedCostDate = l2;
        this.proratedCost = bl;
    }

    public void execute(Object object) {
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        AbstractContourBucket abstractContourBucket = (AbstractContourBucket)this.contourBucketIntervalGenerator.current();
        if (abstractContourBucket != null) {
            CostRate costRate = (CostRate)this.costRateGenerator.current();
            double d2 = abstractContourBucket.getEffectiveUnits(this.assignment.getUnits());
            if (d2 != 0.0) {
                long l2 = this.workCalendar.compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
                this.regularWork += d2 * (double)l2;
                this.overtimeWork += this.overtimeUnits * (double)l2;
                this.work = this.regularWork + this.overtimeWork;
                double d3 = costRate.getOvertimeRate().getValue() * this.overtimeUnits;
                double d4 = costRate.getStandardRate().getValue() * d2;
                if (this.assignment.isTemporal()) {
                    d4 *= (double)l2;
                    d3 *= (double)l2;
                }
                this.overtimeValue += d3;
                this.regularValue += d4;
                this.value += d3 + d4;
                double d5 = costRate.getCostPerUse();
                if (d5 != 0.0) {
                    double d6 = 1.0;
                    if (this.proratedCost) {
                        long l3 = this.assignment.getDuration();
                        if (l3 != 0L) {
                            d6 = (double)l2 / (double)this.assignment.getDuration();
                        }
                    } else if (hasStartAndEnd.getStart() > this.fixedCostDate || hasStartAndEnd.getEnd() < this.fixedCostDate) {
                        return;
                    }
                    double d7 = d6 * d5 * this.assignment.getUnits();
                    this.fixedValue += d7;
                    this.value += d7;
                }
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.fixedValue = 0.0;
        this.regularWork = 0.0;
        this.overtimeWork = 0.0;
        this.work = 0.0;
    }

    public double getFixedValue() {
        return this.fixedValue;
    }

    public String toString() {
        return " total " + this.value + "  regular " + this.regularValue + "  overtime " + this.overtimeValue + "  fixed " + this.fixedValue;
    }

    public final double getOvertimeWork() {
        return this.overtimeWork;
    }

    public final double getRegularWork() {
        return this.regularWork;
    }

    public final double getWork() {
        return this.work;
    }
}

