/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.calendar;

import com.projity.datatype.Duration;
import com.projity.pm.calendar.InvalidCalendarIntersectionException;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkDay;
import com.projity.pm.calendar.WorkWeek;
import com.projity.pm.calendar.WorkingHours;
import com.projity.pm.criticalpath.CriticalPath;
import com.projity.server.access.ErrorLogger;
import com.projity.util.DateTime;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class CalendarDefinition
implements WorkCalendar,
Cloneable {
    static final long serialVersionUID = 73883742020831L;
    TreeSet dayExceptions = null;
    WorkDay[] exceptions = null;
    WorkWeek week = new WorkWeek();
    protected long id = -1L;
    transient boolean newId = true;
    private transient boolean dirty;

    public CalendarDefinition() {
        this.dayExceptions = new TreeSet();
    }

    public CalendarDefinition(CalendarDefinition calendarDefinition, CalendarDefinition calendarDefinition2) {
        this.week = calendarDefinition == null ? new WorkWeek() : (WorkWeek)calendarDefinition.week.clone();
        this.week.addDaysFrom(calendarDefinition2.week);
        this.dayExceptions = (TreeSet)calendarDefinition2.dayExceptions.clone();
        if (calendarDefinition != null) {
            this.dayExceptions.addAll(calendarDefinition.dayExceptions);
        }
        this.addSentinelsAndMakeArray();
        if (!this.testValid()) {
            System.out.println("calendar is invalid " + this.getName());
        }
    }

    public boolean testValid() {
        if (this.week == null) {
            return false;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.week.getWeekDay(i2) != null) continue;
            return false;
        }
        return true;
    }

    void addSentinelsAndMakeArray() {
        this.dayExceptions.add(WorkDay.MINIMUM);
        this.dayExceptions.add(WorkDay.MAXIMUM);
        this.exceptions = new WorkDay[this.dayExceptions.size()];
        this.dayExceptions.toArray(this.exceptions);
    }

    public WorkDay[] getExceptions() {
        return this.exceptions;
    }

    public WorkDay getWeekDay(int n2) {
        return this.week.getWeekDay(n2);
    }

    void addOrReplaceException(WorkDay workDay) {
        this.dayExceptions.remove(workDay);
        this.dayExceptions.add(workDay);
        this.exceptions = new WorkDay[this.dayExceptions.size()];
        this.dayExceptions.toArray(this.exceptions);
    }

    public Object clone() throws CloneNotSupportedException {
        CalendarDefinition calendarDefinition = (CalendarDefinition)super.clone();
        calendarDefinition.week = (WorkWeek)this.week.clone();
        calendarDefinition.dayExceptions = new TreeSet();
        Iterator iterator = this.dayExceptions.iterator();
        while (iterator.hasNext()) {
            calendarDefinition.dayExceptions.add(((WorkDay)iterator.next()).clone());
        }
        return calendarDefinition;
    }

    public long adjustInsideCalendar(long l2, boolean bl) {
        long l3;
        if (l2 < 0L) {
            l2 = -l2;
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            long l4 = this.add(l2, -60000L, bl);
            l3 = this.add(l4, 60000L, bl);
        } else {
            long l5 = this.add(l2, 60000L, bl);
            l3 = this.add(l5, -60000L, bl);
        }
        return l3;
    }

    public long add(long l2, long l3, boolean bl) {
        if (l2 == 0L) {
            return 0L;
        }
        long l4 = l2;
        boolean bl2 = true;
        boolean bl3 = l2 < 0L;
        boolean bl4 = Duration.isElapsed(l3);
        l3 = Duration.millis(l3);
        if (bl3) {
            l2 = -l2;
            l3 = -l3;
            boolean bl5 = bl = !bl;
            if (l3 == 0L) {
                bl2 = false;
            }
        }
        if (bl4) {
            l4 = this.adjustInsideCalendar(l2 + l3, bl);
        } else {
            long l5;
            if (l3 < 0L) {
                bl2 = false;
                l3 = -l3;
            }
            CalendarIterator calendarIterator = CalendarIteratorFactory.getInstance();
            long l6 = calendarIterator.dayOf(l2);
            calendarIterator.initialize(this, bl2, l6);
            WorkingHours workingHours = calendarIterator.getNext(l6);
            l3 -= workingHours.calcWorkTime(calendarIterator.timeOf(l2), bl2);
            int n2 = 0;
            long l7 = this.week.getDuration();
            while ((l5 = l3 / l7) != 0L && n2++ != 4) {
                l6 = calendarIterator.nextDay(l6);
                l6 = calendarIterator.moveNumberOfDays((int)(7L * (bl2 ? l5 : -l5)), l6);
                l3 -= l5 * l7;
                if ((l3 -= calendarIterator.exceptionDurationDifference(l6)) <= 0L) {
                    calendarIterator.reverseDirection();
                    l3 = -l3;
                    bl2 = !bl2;
                    continue;
                }
                l6 = calendarIterator.prevDay(l6);
            }
            while (l3 >= 0L && (l3 != 0L || bl2 != bl)) {
                l6 = calendarIterator.nextDay(l6);
                workingHours = calendarIterator.getNext(l6);
                l3 -= workingHours.getDuration();
            }
            long l8 = -1L;
            while ((l8 = bl2 ? workingHours.calcTimeAtRemainingWork(-l3) : workingHours.calcTimeAtWork(-l3)) == -1L) {
                l6 = calendarIterator.nextDay(l6);
                workingHours = calendarIterator.getNext(l6);
            }
            l4 = l6 + l8;
            CalendarIteratorFactory.recycle(calendarIterator);
        }
        if (bl3) {
            l4 = -l4;
        }
        return l4;
    }

    public long compare(long l2, long l3, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2;
            l3 = -l3;
        }
        if (bl) {
            return l2 - l3;
        }
        long l4 = 0L;
        if (l2 < l3) {
            l4 = l3;
            l3 = l2;
            l2 = l4;
        }
        if (l3 == 0L) {
            return l2;
        }
        CalendarIterator calendarIterator = CalendarIteratorFactory.getInstance();
        long l5 = calendarIterator.dayOf(l3);
        long l6 = calendarIterator.dayOf(l2);
        calendarIterator.initialize(this, true, l5);
        WorkingHours workingHours = calendarIterator.getNext(l5);
        long l7 = 0L;
        l7 += workingHours.calcWorkTimeAfter(calendarIterator.timeOf(l3));
        long l8 = calendarIterator.nextDay(l5);
        long l9 = (calendarIterator.dayOf(l2) - l8) / 604800000L;
        if (l9 != 0L) {
            l8 = calendarIterator.moveNumberOfDays((int)(7L * l9), l8);
            l7 += l9 * this.week.getDuration();
            l7 += calendarIterator.exceptionDurationDifference(l8);
        }
        while (l8 <= l6) {
            workingHours = calendarIterator.getNext(l8);
            l7 += workingHours.getDuration();
            l8 = calendarIterator.nextDay(l8);
        }
        l7 -= workingHours.calcWorkTimeAfter(calendarIterator.timeOf(l2));
        CalendarIteratorFactory.recycle(calendarIterator);
        if (bl2) {
            l7 = -l7;
        }
        return l4 == 0L ? l7 : -l7;
    }

    public String getName() {
        return null;
    }

    public String getCategory() {
        return null;
    }

    public void setName(String string) {
    }

    public CalendarDefinition getConcreteInstance() {
        return this;
    }

    public static final int getDayOfWeek(long l2) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        return gregorianCalendar.get(7) - 1;
    }

    public final WorkDay getWorkDay(long l2) {
        WorkDay workDay = null;
        int n2 = Arrays.binarySearch(this.getConcreteInstance().exceptions, new Date(l2));
        workDay = n2 >= 0 ? this.exceptions[n2] : this.week.getWeekDay(CalendarDefinition.getDayOfWeek(l2));
        return workDay;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public long getUniqueId() {
        return this.id;
    }

    public void setUniqueId(long l2) {
        this.id = l2;
    }

    public boolean isNew() {
        return this.newId;
    }

    public void setNew(boolean bl) {
        this.newId = bl;
    }

    public WorkCalendar getBaseCalendar() {
        return null;
    }

    public boolean dependsOn(WorkCalendar workCalendar) {
        return false;
    }

    public void invalidate() {
    }

    public boolean isInvalid() {
        return false;
    }

    CalendarDefinition intersectWith(CalendarDefinition calendarDefinition) throws InvalidCalendarIntersectionException {
        WorkDay workDay;
        int n2;
        CalendarDefinition calendarDefinition2 = new CalendarDefinition();
        calendarDefinition2.week = this.week.intersectWith(calendarDefinition.week);
        for (n2 = 0; n2 < this.exceptions.length; ++n2) {
            workDay = this.exceptions[n2];
            calendarDefinition2.dayExceptions.add(workDay.intersectWith(calendarDefinition.getWorkDay(workDay.getStart())));
        }
        for (n2 = 0; n2 < calendarDefinition.exceptions.length; ++n2) {
            workDay = calendarDefinition.exceptions[n2];
            calendarDefinition2.dayExceptions.add(workDay.intersectWith(this.getWorkDay(workDay.getStart())));
        }
        calendarDefinition2.addSentinelsAndMakeArray();
        return calendarDefinition2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public String dump() {
        int n2;
        String string = "Calendar " + this.getName() + "\n";
        string = string + "weekdays\n";
        for (n2 = 0; n2 < 7; ++n2) {
            string = string + "day[" + n2 + "]" + this.getWeekDay(n2) + "\n";
        }
        string = string + "There are " + this.exceptions.length + " exceptions\n";
        for (n2 = 0; n2 < this.exceptions.length; ++n2) {
            string = string + "exception" + this.exceptions[n2].toString();
        }
        return string;
    }

    private static class CalendarIterator {
        WorkDay[] exceptions;
        WorkWeek week;
        Calendar scratchDate = DateTime.calendarInstance();
        long exceptionDay;
        int i;
        boolean forward;
        int step;
        private static SimpleDateFormat f = DateTime.dateFormatInstance();

        private CalendarIterator() {
        }

        private void reverseDirection() {
            this.i = this.forward ? --this.i : ++this.i;
            this.step = -this.step;
            this.exceptionDay = this.exceptions[this.i].getStart();
            this.forward = !this.forward;
        }

        public long dayOf(long l2) {
            this.scratchDate.setTimeInMillis(l2);
            this.scratchDate.set(11, 0);
            this.scratchDate.set(12, 0);
            this.scratchDate.set(13, 0);
            return this.scratchDate.getTimeInMillis();
        }

        public long timeOf(long l2) {
            return l2 - this.dayOf(l2);
        }

        private void initialize(CalendarDefinition calendarDefinition, boolean bl, long l2) {
            this.exceptions = calendarDefinition.exceptions;
            this.week = calendarDefinition.week;
            this.forward = bl;
            this.scratchDate.setTimeInMillis(l2);
            try {
                DateUtils.truncate(this.scratchDate, 5);
            }
            catch (Exception exception) {
                ErrorLogger.logOnce("hugedate", "date value is garbage " + this.scratchDate + "\n" + CriticalPath.getTrace(), exception);
            }
            this.step = bl ? 1 : -1;
            this.i = Arrays.binarySearch(this.exceptions, this.scratchDate);
            if (this.i < 0) {
                this.i = -this.i - 1;
                if (!bl) {
                    --this.i;
                }
            }
            this.exceptionDay = this.exceptions[this.i].getStart();
        }

        public String dump() {
            int n2;
            String string = "CalendarIterator ";
            string = string + "weekdays\n";
            for (n2 = 0; n2 < 7; ++n2) {
                string = string + "day[" + n2 + "]" + this.week.getWeekDay(n2) + "\n";
            }
            string = string + "There are " + this.exceptions.length + " exceptions\n";
            for (n2 = 0; n2 < this.exceptions.length; ++n2) {
                string = string + "exception" + this.exceptions[n2].toString();
            }
            return string;
        }

        private WorkingHours getNext(long l2) {
            WorkDay workDay;
            if (l2 == this.exceptionDay) {
                workDay = this.exceptions[this.i];
                this.i += this.step;
                if (this.i < 0 || this.i == this.exceptions.length) {
                    System.out.println("invalid calendar iterator - index is negative or past bounds. avoiding");
                    ErrorLogger.logOnce("CalendarIterator", "invalid calendar iterator i=" + this.i + "\n" + CriticalPath.getTrace(), null);
                } else {
                    this.exceptionDay = this.exceptions[this.i].getStart();
                }
            } else {
                workDay = this.week.getWeekDay(this.dayOfWeek(l2));
            }
            return workDay.getWorkingHours();
        }

        private long exceptionDurationDifference(long l2) {
            long l3 = 0L;
            if (this.exceptions.length == 2) {
                return 0L;
            }
            while (this.forward && this.exceptionDay < l2 || !this.forward && this.exceptionDay > l2) {
                l3 -= this.week.getWeekDay(this.dayOfWeek(this.exceptionDay)).getDuration();
                l3 += this.exceptions[this.i].getDuration();
                this.i += this.step;
                if (this.i < 0 || this.i >= this.exceptions.length) break;
                this.exceptionDay = this.exceptions[this.i].getStart();
            }
            return l3;
        }

        private int dayOfWeek(long l2) {
            this.scratchDate.setTimeInMillis(l2);
            return this.scratchDate.get(7) - 1;
        }

        private long moveNumberOfDays(int n2, long l2) {
            this.scratchDate.setTimeInMillis(l2);
            this.scratchDate.add(5, n2);
            return this.scratchDate.getTimeInMillis();
        }

        private long nextDay(long l2) {
            this.scratchDate.setTimeInMillis(l2);
            this.scratchDate.add(5, this.forward ? 1 : -1);
            return this.scratchDate.getTimeInMillis();
        }

        private long prevDay(long l2) {
            this.scratchDate.setTimeInMillis(l2);
            this.scratchDate.add(5, this.forward ? -1 : 1);
            return this.scratchDate.getTimeInMillis();
        }
    }

    private static class CalendarIteratorFactory
    extends BasePoolableObjectFactory {
        private static GenericObjectPool pool = new GenericObjectPool(new CalendarIteratorFactory());

        private CalendarIteratorFactory() {
        }

        public Object makeObject() throws Exception {
            return new CalendarIterator();
        }

        public static CalendarIterator getInstance() {
            try {
                return (CalendarIterator)pool.borrowObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static void recycle(CalendarIterator calendarIterator) {
            try {
                pool.returnObject(calendarIterator);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

