/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.frames.workspace;

import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.frames.workspace.FrameManager;
import com.projity.pm.graphic.frames.workspace.NamedFrame;
import com.projity.pm.graphic.frames.workspace.NamedFrameEvent;
import com.projity.pm.graphic.frames.workspace.Workspace;
import com.projity.pm.task.Project;
import com.projity.pm.task.ProjectFactory;
import com.projity.session.LoadOptions;
import com.projity.strings.Messages;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DefaultFrameManager
implements FrameManager {
    private static final long serialVersionUID = -1835326043838730651L;
    public static final int SPLIT_EAST_WEST_SOUTH_NORTH = 0;
    Container container;
    Container emptyPanel;
    JComboBox projectComboBox;
    JPanel projectComboPanel;
    NamedFrame previous = null;
    GraphicManager graphicManager;
    private FrameWorkspace workspace;

    public DefaultFrameManager(Container container, Container container2, GraphicManager graphicManager) {
        this.container = container;
        this.emptyPanel = container2;
        this.graphicManager = graphicManager;
        this.projectComboPanel = new JPanel();
        this.projectComboPanel.setVisible(false);
        GraphicManager.getInstance().getLafManager().setColorScheme(this.projectComboPanel);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void cleanUp() {
        Iterator iterator = this.getAllFrames().iterator();
        while (iterator.hasNext()) {
            ((DocumentFrame)iterator.next()).cleanUp();
        }
        this.projectComboBox.removeAll();
        this.container = null;
        this.emptyPanel = null;
        this.previous = null;
        this.workspace = null;
        Object var2_2 = null;
        this.graphicManager = null;
    }

    private final JComboBox getProjectComboBox() {
        if (this.projectComboBox == null) {
            this.projectComboBox = new JComboBox(new FrameComboBoxModel());
            this.projectComboBox.setToolTipText(Messages.getString("DefaultFrameManager.Project"));
            this.projectComboBox.setMinimumSize(new Dimension(100, 28));
            this.projectComboBox.setMaximumSize(new Dimension(300, 28));
            this.projectComboBox.setPreferredSize(new Dimension(140, 28));
            this.projectComboPanel.setVisible(false);
            this.projectComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NamedFrame namedFrame = (NamedFrame)DefaultFrameManager.this.projectComboBox.getSelectedItem();
                    if (namedFrame == null || namedFrame == DefaultFrameManager.this.previous) {
                        return;
                    }
                    DefaultFrameManager.this.activateFrame(namedFrame);
                    namedFrame.fireNamedFrameActivated(new NamedFrameEvent(namedFrame));
                }
            });
            this.projectComboPanel.add(this.projectComboBox);
        }
        return this.projectComboBox;
    }

    public void activateFrame(NamedFrame namedFrame) {
        this.getProjectComboBox().setSelectedItem(namedFrame);
        if (this.previous != null) {
            this.container.remove(this.previous);
            this.previous.setActive(false);
            this.previous.setVisible(false);
        } else if (this.container != null) {
            this.container.remove(this.emptyPanel);
        }
        this.previous = namedFrame;
        if (namedFrame == null) {
            return;
        }
        this.container.add((Component)namedFrame, "Center");
        namedFrame.setActive(true);
        namedFrame.setVisible(true);
    }

    public NamedFrame getFrame(String string) {
        for (int i2 = 0; i2 < this.getProjectComboBox().getItemCount(); ++i2) {
            NamedFrame namedFrame = (NamedFrame)this.getProjectComboBox().getItemAt(i2);
            if (!namedFrame.getId().equals(string)) continue;
            return namedFrame;
        }
        return null;
    }

    public void addFrame(NamedFrame namedFrame) {
        this.getProjectComboBox().addItem(namedFrame);
        namedFrame.setManager(this);
        this.activateFrame(namedFrame);
        this.projectComboPanel.setVisible(true);
    }

    public AbstractList getAllFrames() {
        LinkedList<NamedFrame> linkedList = new LinkedList<NamedFrame>();
        for (int i2 = 0; i2 < this.getProjectComboBox().getItemCount(); ++i2) {
            NamedFrame namedFrame = (NamedFrame)this.getProjectComboBox().getItemAt(i2);
            linkedList.add(namedFrame);
        }
        return linkedList;
    }

    public Component getSelectedFrame() {
        return (Component)this.getProjectComboBox().getSelectedItem();
    }

    public void removeFrame(NamedFrame namedFrame) {
        if (namedFrame == null) {
            return;
        }
        this.getProjectComboBox().removeItem(namedFrame);
        this.container.remove(namedFrame);
        ((DocumentFrame)namedFrame).cleanUp();
        if (this.getProjectComboBox().getItemCount() == 0) {
            this.previous = null;
            this.container.add((Component)this.emptyPanel, "Center");
            this.projectComboPanel.setVisible(false);
        } else if (this.previous != null) {
            this.activateFrame(this.previous);
        } else {
            this.activateFrame((NamedFrame)this.getProjectComboBox().getItemAt(0));
        }
    }

    public void showFrame(NamedFrame namedFrame) {
        this.getProjectComboBox().setSelectedItem(namedFrame);
    }

    public void update() {
        FrameComboBoxModel frameComboBoxModel = (FrameComboBoxModel)this.getProjectComboBox().getModel();
        frameComboBoxModel.update();
    }

    public void setTabTitle(NamedFrame namedFrame, String string) {
    }

    public Workspace getWorkspace() {
        return new Workspace();
    }

    final Container getEmptyPanel() {
        return this.emptyPanel;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n2) {
        FrameWorkspace frameWorkspace;
        this.workspace = frameWorkspace = (FrameWorkspace)workspaceSetting;
        for (DocumentFrame.Workspace workspace : frameWorkspace.list) {
            Object object;
            long l2 = workspace.getProjectId();
            Project project = ProjectFactory.getInstance().findFromId(l2);
            if (project == null) {
                object = new LoadOptions();
                ((LoadOptions)object).setId(l2);
                ((LoadOptions)object).setSync(true);
                ProjectFactory.getInstance().openProject((LoadOptions)object);
            }
            object = this.graphicManager.addProjectFrame(project);
            ((DocumentFrame)object).restoreWorkspace(workspace, n2);
        }
        this.getProjectComboBox().setSelectedIndex(frameWorkspace.getSelectedIndex());
    }

    public WorkspaceSetting createWorkspace(int n2) {
        FrameWorkspace frameWorkspace = new FrameWorkspace();
        frameWorkspace.list = new LinkedList();
        for (int i2 = 0; i2 < this.getProjectComboBox().getItemCount(); ++i2) {
            DocumentFrame documentFrame = (DocumentFrame)this.getProjectComboBox().getItemAt(i2);
            frameWorkspace.list.add(documentFrame.createWorkspace(n2));
        }
        frameWorkspace.selectedIndex = this.getProjectComboBox().getSelectedIndex();
        return frameWorkspace;
    }

    final GraphicManager getGraphicManager() {
        return this.graphicManager;
    }

    public JPanel getProjectComboPanel() {
        return this.projectComboPanel;
    }

    public static class FrameWorkspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -4029197146082617077L;
        LinkedList list;
        int selectedIndex;

        public final LinkedList getList() {
            return this.list;
        }

        public final void setList(LinkedList linkedList) {
            this.list = linkedList;
        }

        public final int getSelectedIndex() {
            return this.selectedIndex;
        }

        public final void setSelectedIndex(int n2) {
            this.selectedIndex = n2;
        }
    }

    protected class FrameComboBoxModel
    extends DefaultComboBoxModel {
        public void update() {
            this.fireContentsChanged(this, -1, -1);
        }

        public void addElement(Object object) {
            super.addElement(object);
        }
    }
}

