/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.model.cache;

import com.projity.association.InvalidAssociationException;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.WalkersNodeModel;
import com.projity.grouping.core.transform.TransformList;
import com.projity.grouping.core.transform.ViewTransformerEvent;
import com.projity.grouping.core.transform.ViewTransformerListener;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.model.cache.VisibleDependencies;
import com.projity.pm.graphic.model.cache.VisibleNodes;
import com.projity.pm.graphic.model.event.CacheListener;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.model.transform.DependencyCacheTransformer;
import com.projity.pm.graphic.model.transform.NodeCacheTransformer;
import com.projity.pm.task.Project;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.Closure;

public class ViewNodeModelCache
implements NodeModelCache,
ViewTransformerListener,
CacheListener {
    protected ReferenceNodeModelCache reference;
    protected VisibleNodes visibleNodes;
    protected VisibleDependencies visibleDependencies;
    protected String viewName;
    protected EventListenerList treeModelListenerList = new EventListenerList();

    ViewNodeModelCache(ReferenceNodeModelCache referenceNodeModelCache, String string, Closure closure) {
        this(referenceNodeModelCache, new VisibleNodes(string, new NodeCacheTransformer(string, referenceNodeModelCache, closure)), new VisibleDependencies(string, new DependencyCacheTransformer(string, referenceNodeModelCache)));
        this.viewName = string;
    }

    private ViewNodeModelCache(ReferenceNodeModelCache referenceNodeModelCache, VisibleNodes visibleNodes, VisibleDependencies visibleDependencies) {
        this.reference = referenceNodeModelCache;
        this.visibleNodes = visibleNodes;
        this.visibleDependencies = visibleDependencies;
        this.addNodeModelListener(this);
        visibleDependencies.setVisibleNodes(visibleNodes);
        visibleNodes.setVisibleDependencies(visibleDependencies);
        referenceNodeModelCache.bindView(visibleNodes, visibleDependencies);
        ((NodeCacheTransformer)visibleNodes.getTransformer()).getTransformer().addViewTransformerListener(this);
    }

    public NodeModel getModel() {
        return this.reference.getModel();
    }

    public void setModel(NodeModel nodeModel) {
        this.reference.setModel(nodeModel);
    }

    public WalkersNodeModel getWalkersModel() {
        NodeCacheTransformer nodeCacheTransformer = (NodeCacheTransformer)this.visibleNodes.getTransformer();
        return nodeCacheTransformer.getWalkersModel();
    }

    public void setType(int n2) {
        this.reference.setType(n2);
    }

    public int getType() {
        return this.reference.getType();
    }

    public String getViewName() {
        return this.viewName;
    }

    public void transformerChanged(ViewTransformerEvent viewTransformerEvent) {
        this.update();
    }

    public void update() {
        this.reference.updateVisibleElements(this.visibleNodes);
    }

    public ReferenceNodeModelCache getReference() {
        return this.reference;
    }

    public Object getElementAt(int n2) {
        return this.visibleNodes.getElementAt(n2);
    }

    public ListIterator getIterator() {
        return this.visibleNodes.getIterator();
    }

    public ListIterator getIterator(int n2) {
        return this.visibleNodes.getIterator(n2);
    }

    public ListIterator getEdgesIterator() {
        return this.visibleDependencies.getIterator();
    }

    public ListIterator getEdgesIterator(int n2) {
        return this.visibleDependencies.getIterator(n2);
    }

    public int getMaxLevel() {
        int n2 = 0;
        ListIterator listIterator = this.getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (graphicNode.getLevel() <= n2) continue;
            n2 = graphicNode.getLevel();
        }
        return n2;
    }

    public List getElementsAt(int[] nArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Object object = this.getElementAt(nArray[i2]);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getNodesAt(int[] nArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Node node = ((GraphicNode)this.getElementAt(nArray[i2])).getNode();
            if (node == null) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Object getEdgeElementAt(int n2) {
        return this.visibleDependencies.getElementAt(n2);
    }

    public int getSize() {
        return this.visibleNodes.getSize();
    }

    public int getEdgesSize() {
        return this.visibleDependencies.getSize();
    }

    public int getRowAt(Object object) {
        return this.visibleNodes.getRow(object);
    }

    public Object getGraphicNode(Object object) {
        return this.reference.getGraphicNode(object);
    }

    public Object getGraphicDependency(Object object) {
        return this.reference.getGraphicDependency(object);
    }

    public GraphicNode getParent(GraphicNode graphicNode) {
        GraphicNode graphicNode2 = this.reference.getParent(graphicNode);
        if (this.visibleNodes.getElements().contains(graphicNode)) {
            return graphicNode2;
        }
        return null;
    }

    public List getChildren(GraphicNode graphicNode) {
        List list = this.reference.getChildren(graphicNode);
        if (list == null) {
            return null;
        }
        ArrayList arrayList = this.visibleNodes.getElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (arrayList.contains(iterator.next())) continue;
            iterator.remove();
        }
        return list;
    }

    public void changeCollapsedState(GraphicNode graphicNode) {
        this.reference.changeCollapsedState(graphicNode);
    }

    public void createDependency(GraphicNode graphicNode, GraphicNode graphicNode2) throws InvalidAssociationException {
        this.reference.createDependency(graphicNode, graphicNode2);
    }

    public void createHierarchyDependency(GraphicNode graphicNode, GraphicNode graphicNode2) throws InvalidAssociationException {
        this.reference.createDependency(graphicNode, graphicNode2);
    }

    public void addNodeModelListener(CacheListener cacheListener) {
        this.visibleNodes.addNodeModelListener(cacheListener);
    }

    public void removeNodeModelListener(CacheListener cacheListener) {
        this.visibleNodes.removeNodeModelListener(cacheListener);
    }

    public CacheListener[] getNodeModelListeners() {
        return this.visibleNodes.getNodeModelListeners();
    }

    public void close() {
    }

    private boolean isAllowedAction(Node node, boolean bl) {
        if (node != null && node.getImpl() instanceof Task) {
            boolean bl2 = true;
            Task task = (Task)node.getImpl();
            if (task instanceof SubProj) {
                Project project;
                Project project2 = project = bl ? ((SubProj)((Object)task)).getSubproject() : task.getOwningProject();
                if (project != null && project.isReadOnly()) {
                    bl2 = false;
                }
            } else {
                boolean bl3 = bl2 = !task.isReadOnly();
            }
            if (!bl2) {
                Alert.error(MessageFormat.format(Messages.getString("Message.readOnlyTask"), task.getName()));
            }
            return bl2;
        }
        return true;
    }

    private boolean isAllowedAction(List list, boolean bl) {
        if (list != null) {
            for (Object object : list) {
                if (object == null) continue;
                if (object instanceof GraphicNode) {
                    object = ((GraphicNode)object).getNode();
                }
                if (this.isAllowedAction((Node)object, bl)) continue;
                return false;
            }
        }
        return true;
    }

    public void newNode(GraphicNode graphicNode) {
        Node node = graphicNode.getNode();
        if (!this.isAllowedAction(node, false)) {
            return;
        }
        if (node != null && node.getImpl() instanceof Task && ((Task)node.getImpl()).isReadOnly()) {
            return;
        }
        Node node2 = this.getModel().getParent(node);
        int n2 = node2.getIndex(node);
        this.getModel().newNode(node2, n2, 3);
    }

    public void deleteNodes(List list) {
        if (!this.isAllowedAction(list, false)) {
            return;
        }
        this.getModel().remove(list, 3);
    }

    public void cutNodes(List list) {
        if (!this.isAllowedAction(list, false)) {
            return;
        }
        List list2 = this.getModel().cut(list, 3);
        list.clear();
        list.addAll(list2);
    }

    public void copyNodes(List list) {
        List list2 = this.getModel().copy(list, 3);
        list.clear();
        list.addAll(list2);
    }

    public void pasteNodes(Node node, List list, int n2) {
        if (!this.isAllowedAction(node, true)) {
            return;
        }
        this.getModel().paste(node, list, n2, 3);
    }

    public void addNodes(Node node, List list) {
        this.getModel().addBefore(node, list, 3);
    }

    public void expandNodes(List list, boolean bl) {
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            for (GraphicNode graphicNode : list) {
                if (bl && !graphicNode.isFetched()) {
                    graphicNode.fetch();
                }
                if (graphicNode.isCollapsed() != bl) continue;
                this.changeCollapsedState(graphicNode);
            }
        }
    }

    public void indentNodes(List list) {
        if (list == null) {
            return;
        }
        if (!this.isAllowedAction(list, false)) {
            return;
        }
        List list2 = TransformList.getNotVoidFilter().filterList(this.convertToBase(list));
        if (list2.size() > 0) {
            this.getModel().getHierarchy().indent(list2, 1, this.getModel(), 3);
        }
    }

    public void outdentNodes(List list) {
        if (list == null) {
            return;
        }
        if (!this.isAllowedAction(list, false)) {
            return;
        }
        List list2 = TransformList.getNotVoidFilter().filterList(this.convertToBase(list));
        if (list2.size() > 0) {
            this.getModel().getHierarchy().indent(list2, -1, this.getModel(), 3);
        }
    }

    private List convertToBase(List list) {
        if (list == null) {
            return null;
        }
        ListIterator<Node> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(((GraphicNode)listIterator.next()).getNode());
        }
        return list;
    }

    private int getLastNormalRow() {
        for (int i2 = this.visibleNodes.getSize() - 1; i2 >= 0; --i2) {
            GraphicNode graphicNode = (GraphicNode)this.visibleNodes.getElementAt(i2);
            if (graphicNode.isVoid()) continue;
            return i2;
        }
        return -1;
    }

    public int getLevel(GraphicNode graphicNode) {
        if (graphicNode.isGroup()) {
            return graphicNode.getLevel();
        }
        NodeCacheTransformer nodeCacheTransformer = (NodeCacheTransformer)this.visibleNodes.getTransformer();
        return graphicNode.getLevel() + nodeCacheTransformer.getLevelOffset();
    }

    public int getPertLevel(GraphicNode graphicNode) {
        return graphicNode.getPertLevel();
    }

    public void setPertLevel(GraphicNode graphicNode, int n2) {
        graphicNode.setPertLevel(n2);
    }

    public VisibleDependencies getVisibleDependencies() {
        return this.visibleDependencies;
    }

    public VisibleNodes getVisibleNodes() {
        return this.visibleNodes;
    }

    public boolean isReceiveEvents() {
        return this.reference.isReceiveEvents();
    }

    public void setReceiveEvents(boolean bl) {
        this.reference.setReceiveEvents(bl);
    }

    public Object getChild(Object object, int n2) {
        GraphicNode graphicNode;
        ListIterator listIterator = this.getIterator();
        GraphicNode graphicNode2 = null;
        if (object == this.getRoot()) {
            graphicNode2 = (GraphicNode)this.getRoot();
        } else {
            while (listIterator.hasNext()) {
                graphicNode = (GraphicNode)listIterator.next();
                if (graphicNode != object) continue;
                graphicNode2 = graphicNode;
                break;
            }
        }
        if (graphicNode2 == null) {
            return null;
        }
        int n3 = 0;
        while (listIterator.hasNext() && (graphicNode = (GraphicNode)listIterator.next()).getLevel() > graphicNode2.getLevel()) {
            if (graphicNode.getLevel() != graphicNode2.getLevel() + 1) continue;
            if (n3 == n2) {
                return graphicNode;
            }
            ++n3;
        }
        return null;
    }

    public int getChildCount(Object object) {
        GraphicNode graphicNode;
        ListIterator listIterator = this.getIterator();
        GraphicNode graphicNode2 = null;
        if (object == this.getRoot()) {
            graphicNode2 = (GraphicNode)this.getRoot();
        } else {
            while (listIterator.hasNext()) {
                graphicNode = (GraphicNode)listIterator.next();
                if (graphicNode != object) continue;
                graphicNode2 = graphicNode;
                break;
            }
        }
        int n2 = 0;
        if (graphicNode2 != null) {
            while (listIterator.hasNext() && (graphicNode = (GraphicNode)listIterator.next()).getLevel() > graphicNode2.getLevel()) {
                if (graphicNode.getLevel() != graphicNode2.getLevel() + 1) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int getIndexOfChild(Object object, Object object2) {
        GraphicNode graphicNode;
        ListIterator listIterator = this.getIterator();
        GraphicNode graphicNode2 = null;
        if (object == this.getRoot()) {
            graphicNode2 = (GraphicNode)this.getRoot();
        } else {
            while (listIterator.hasNext()) {
                graphicNode = (GraphicNode)listIterator.next();
                if (graphicNode != object) continue;
                graphicNode2 = graphicNode;
                break;
            }
        }
        if (graphicNode2 == null) {
            return -1;
        }
        int n2 = 0;
        while (listIterator.hasNext() && (graphicNode = (GraphicNode)listIterator.next()).getLevel() > graphicNode2.getLevel()) {
            if (graphicNode.getLevel() != graphicNode2.getLevel() + 1) continue;
            if (graphicNode == object2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object getRoot() {
        return this.reference.getRoot();
    }

    public boolean isLeaf(Object object) {
        GraphicNode graphicNode;
        ListIterator listIterator = this.getIterator();
        GraphicNode graphicNode2 = null;
        if (object == this.getRoot()) {
            graphicNode2 = (GraphicNode)this.getRoot();
        } else {
            while (listIterator.hasNext()) {
                graphicNode = (GraphicNode)listIterator.next();
                if (graphicNode != object) continue;
                graphicNode2 = graphicNode;
                break;
            }
        }
        if (graphicNode2 == null) {
            return true;
        }
        if (listIterator.hasNext()) {
            graphicNode = (GraphicNode)listIterator.next();
            return graphicNode.getLevel() <= graphicNode2.getLevel();
        }
        return true;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeModelUpdate(Object object) {
        Object[] objectArray = this.treeModelListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, new Object[]{this.getRoot()});
            }
            ((TreeModelListener)objectArray[i2 + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        this.fireTreeModelUpdate(this);
    }
}

