/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.model.transform;

import com.projity.document.Document;
import com.projity.grouping.core.GroupNodeImpl;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.model.WalkersNodeModel;
import com.projity.grouping.core.transform.HierarchicObject;
import com.projity.grouping.core.transform.ViewConfiguration;
import com.projity.grouping.core.transform.ViewTransformer;
import com.projity.grouping.core.transform.filtering.BaseFilter;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import com.projity.grouping.core.transform.grouping.NodeGroup;
import com.projity.grouping.core.transform.grouping.NodeGrouper;
import com.projity.grouping.core.transform.sorting.NodeSorter;
import com.projity.grouping.core.transform.transformer.NodeTransformer;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.model.transform.CacheTransformer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCacheTransformer
implements CacheTransformer {
    protected ViewTransformer transformer;
    protected ReferenceNodeModelCache refCache;
    protected int levelOffset = 0;
    protected String viewName;
    protected ViewConfiguration view;
    private TransformerNodeModel model = new TransformerNodeModel();

    public NodeCacheTransformer(String string, ReferenceNodeModelCache referenceNodeModelCache, Closure closure) {
        this.view = ViewConfiguration.getView(string);
        this.transformer = this.view.getTransform();
        if (closure != null) {
            closure.execute(this.transformer);
        }
        this.refCache = referenceNodeModelCache;
        this.viewName = string;
    }

    public ViewTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public void transfrom(List arrayList) {
        boolean bl;
        this.model.clear();
        if (arrayList == null) {
            return;
        }
        boolean bl2 = this.transformer.isPreserveHierarchy();
        if (!this.transformer.isShowSummary()) {
            bl2 = false;
            this.removeSummaries(arrayList);
        }
        Map<GraphicNode, List<GraphicNode>> map = null;
        if (!this.transformer.isShowAssignments()) {
            this.removeAssignments(arrayList);
        }
        if (!this.transformer.isShowEmptyLines()) {
            this.removeVoids(arrayList);
        }
        if (this.transformer.isShowEmptyLines() && !this.transformer.isShowEndEmptyLines()) {
            this.removeEndVoids(arrayList);
        }
        NodeTransformer nodeTransformer = this.transformer.getTransformer();
        NodeFilter nodeFilter = this.transformer.getHiddenFilter();
        if (nodeFilter instanceof BaseFilter && !((BaseFilter)nodeFilter).isActive()) {
            nodeFilter = null;
        }
        NodeFilter nodeFilter2 = this.transformer.isNoneFilter() ? null : this.transformer.getUserFilter();
        boolean bl3 = nodeFilter != null || nodeFilter2 != null;
        NodeSorter nodeSorter = this.transformer.getHiddenSorter();
        NodeSorter nodeSorter2 = this.transformer.getUserSorter();
        boolean bl4 = nodeSorter != null || !this.transformer.isNoneSorter();
        NodeGrouper nodeGrouper = this.transformer.getUserGrouper();
        boolean bl5 = bl = !this.transformer.isNoneGrouper();
        if (!(bl3 || bl4 || bl)) {
            return;
        }
        if (this.transformer.isShowAssignments() && bl2 && !this.transformer.isTreatAssignmentsAsTasks()) {
            map = this.extractAssignments(arrayList);
        }
        ArrayList<GraphicNode> arrayList2 = null;
        Stack<GraphicNode> stack = null;
        if (bl2) {
            arrayList2 = new ArrayList<GraphicNode>();
            stack = new Stack<GraphicNode>();
        } else {
            arrayList2 = arrayList;
        }
        GraphicNode graphicNode = null;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            GraphicNode graphicNode2 = (GraphicNode)object.next();
            graphicNode2.setFiltered(false);
            if (!graphicNode2.isVoid()) {
                Node node = nodeTransformer == null ? graphicNode2.getNode() : nodeTransformer.evaluate(graphicNode2.getNode());
                boolean bl6 = false;
                if (nodeFilter != null && !nodeFilter.evaluate(node)) {
                    if (!graphicNode2.isSummary() || !bl2) {
                        object.remove();
                        continue;
                    }
                    if (graphicNode2.isSummary() && bl2) {
                        graphicNode2.setFiltered(true);
                    }
                    bl6 = true;
                }
                if (nodeFilter2 != null && !bl6 && !nodeFilter2.evaluate(node)) {
                    if (!graphicNode2.isSummary() || !bl2) {
                        object.remove();
                        continue;
                    }
                    if (graphicNode2.isSummary() && bl2) {
                        graphicNode2.setFiltered(true);
                    }
                }
            }
            if (!bl2) continue;
            if (graphicNode2.getLevel() == 1) {
                arrayList2.add(graphicNode2);
                stack.clear();
            } else {
                if (graphicNode.getLevel() < graphicNode2.getLevel()) {
                    stack.push(graphicNode);
                } else if (graphicNode.getLevel() >= graphicNode2.getLevel()) {
                    while (stack.size() >= graphicNode2.getLevel()) {
                        stack.pop();
                    }
                }
                ((GraphicNode)stack.peek()).getChildren().add(graphicNode2);
            }
            graphicNode = graphicNode2;
        }
        if (bl2) {
            arrayList.clear();
            if (this.transformer.isShowEmptySummaries()) {
                if ("TaskUsage".equals(this.viewName)) {
                    this.filterBadBranches(arrayList2);
                }
            } else {
                this.filterEmptySummaries(arrayList2, false);
            }
        }
        if (bl4) {
            if (nodeSorter != null) {
                nodeSorter.sortList(arrayList2, new GraphicNodeComparator(nodeSorter, nodeTransformer), bl2);
            }
            if (!this.transformer.isNoneSorter()) {
                nodeSorter2.sortList(arrayList2, new GraphicNodeComparator(nodeSorter2, nodeTransformer), bl2);
            }
        }
        if (bl) {
            object = nodeGrouper.getGroups();
            this.levelOffset = object.size();
            LinkedList linkedList = new LinkedList();
            this.groupList(arrayList2, linkedList, object.listIterator(), null, nodeTransformer, bl2);
            arrayList2.clear();
            arrayList2.addAll(linkedList);
        }
        if (bl2) {
            this.treeToList(arrayList2, arrayList);
        }
        if (map != null) {
            this.recoverAssignments(arrayList, map);
        }
    }

    private boolean filterEmptySummaries(List list, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)iterator.next();
            if (graphicNode.isVoid()) {
                bl3 = true;
                continue;
            }
            if (!graphicNode.isSummary() || graphicNode.getChildren().size() > 0 && this.filterEmptySummaries(graphicNode.getChildren(), true)) {
                bl2 = true;
                continue;
            }
            iterator.remove();
        }
        if (!(bl2 || bl3 && !bl)) {
            list.clear();
        }
        return bl2;
    }

    private void filterBadBranches(List list) {
        this.filterBadBranches(list, false);
    }

    private boolean filterBadBranches(List list, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)iterator.next();
            boolean bl3 = bl | graphicNode.isFiltered();
            if (!graphicNode.isSummary() || !graphicNode.isFiltered() && graphicNode.getChildren().size() == 0 || this.filterBadBranches(graphicNode.getChildren(), bl3) || !graphicNode.isFiltered()) {
                bl2 = true;
                continue;
            }
            iterator.remove();
        }
        return bl2;
    }

    private void treeToList(List list, List list2) {
        for (HierarchicObject hierarchicObject : list) {
            list2.add(hierarchicObject);
            if (hierarchicObject.getChildren().size() > 0) {
                this.treeToList(hierarchicObject.getChildren(), list2);
            }
            hierarchicObject.getChildren().clear();
        }
    }

    public int getLevelOffset() {
        return this.levelOffset;
    }

    protected static GraphicNode createGroupWithName(int n2, NodeGroup nodeGroup, String string) {
        Node node = NodeFactory.getInstance().createGroup(nodeGroup, string);
        GraphicNode graphicNode = new GraphicNode(node, n2);
        graphicNode.setComposite(true);
        graphicNode.setSummary(true);
        graphicNode.setCollapsed(false);
        return graphicNode;
    }

    protected GraphicNode createGroup(int n2, NodeGroup nodeGroup, NodeSorter nodeSorter, Node node) {
        return NodeCacheTransformer.createGroupWithName(n2, nodeGroup, nodeSorter.getGroupName(node));
    }

    private void groupList(List list, List list2, ListIterator listIterator, Node node, NodeTransformer nodeTransformer, boolean bl) {
        NodeGroup nodeGroup = (NodeGroup)listIterator.next();
        NodeSorter nodeSorter = nodeGroup.getSorter();
        GraphicNodeComparator graphicNodeComparator = new GraphicNodeComparator(nodeSorter, nodeTransformer);
        nodeSorter.sortList(list, graphicNodeComparator, bl);
        GraphicNode graphicNode = null;
        LinkedList<GraphicNode> linkedList = null;
        ListIterator listIterator2 = list.listIterator();
        while (listIterator2.hasNext()) {
            GraphicNode graphicNode2 = (GraphicNode)listIterator2.next();
            if (graphicNode == null) {
                linkedList = new LinkedList<GraphicNode>();
            } else if (graphicNodeComparator.compare(graphicNode, graphicNode2) != 0) {
                this.handleGroup(list2, listIterator, node, nodeGroup, graphicNode, linkedList, nodeTransformer, bl);
                linkedList = new LinkedList();
            }
            linkedList.add(graphicNode2);
            graphicNode = graphicNode2;
        }
        if (linkedList != null && linkedList.size() > 0) {
            this.handleGroup(list2, listIterator, node, nodeGroup, graphicNode, linkedList, nodeTransformer, bl);
        }
        listIterator.previous();
    }

    private void handleGroup(List list, ListIterator listIterator, Node node, NodeGroup nodeGroup, GraphicNode graphicNode, List list2, NodeTransformer nodeTransformer, boolean bl) {
        GraphicNode graphicNode2 = this.createGroup(listIterator.nextIndex(), nodeGroup, nodeGroup.getSorter(), graphicNode.getNode());
        list.add(graphicNode2);
        this.model.addRelationship(node, graphicNode2.getNode());
        if (listIterator.hasNext()) {
            this.groupList(list2, list, listIterator, graphicNode2.getNode(), nodeTransformer, bl);
        } else {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                this.model.addRelationship(graphicNode2.getNode(), ((GraphicNode)iterator.next()).getNode());
            }
            list.addAll(list2);
        }
    }

    private void placeVoidNodes(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            this.placeVoidNodes(listIterator, graphicNode.getNode());
        }
        this.placeVoidNodes(listIterator, (Node)this.refCache.getModel().getRoot());
    }

    private void placeVoidNodes(ListIterator listIterator, Node node) {
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (!node2.isVoid()) continue;
            GraphicNode graphicNode = this.refCache.getGraphicNode(node2);
            listIterator.add(graphicNode);
        }
    }

    private void removeVoids(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (!graphicNode.isVoid()) continue;
            listIterator.remove();
        }
    }

    private void removeEndVoids(List list) {
        GraphicNode graphicNode;
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious() && (graphicNode = (GraphicNode)listIterator.previous()).isVoid()) {
            listIterator.remove();
        }
    }

    private void removeSummaries(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (!graphicNode.isSummary()) continue;
            listIterator.remove();
        }
    }

    private void removeAssignments(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (!graphicNode.isAssignment()) continue;
            listIterator.remove();
        }
    }

    private Map<GraphicNode, List<GraphicNode>> extractAssignments(List list) {
        HashMap<GraphicNode, List<GraphicNode>> hashMap = new HashMap<GraphicNode, List<GraphicNode>>();
        Stack<GraphicNode> stack = new Stack<GraphicNode>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode;
            GraphicNode graphicNode2 = (GraphicNode)listIterator.next();
            if (graphicNode2.getLevel() == 1) {
                stack.clear();
                stack.push(graphicNode2);
                continue;
            }
            while ((graphicNode = (GraphicNode)stack.peek()).getLevel() >= graphicNode2.getLevel()) {
                stack.pop();
            }
            if (graphicNode2.isAssignment()) {
                GraphicNode graphicNode3 = (GraphicNode)stack.peek();
                LinkedList<GraphicNode> linkedList = (LinkedList<GraphicNode>)hashMap.get(graphicNode3);
                if (linkedList == null) {
                    linkedList = new LinkedList<GraphicNode>();
                    hashMap.put(graphicNode3, linkedList);
                }
                linkedList.add(graphicNode2);
                listIterator.remove();
            }
            stack.push(graphicNode2);
        }
        return hashMap;
    }

    private void recoverAssignments(List list, Map<GraphicNode, List<GraphicNode>> map) {
        GraphicNode graphicNode = null;
        ListIterator<GraphicNode> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            graphicNode = (GraphicNode)listIterator.next();
            if (!map.containsKey(graphicNode)) continue;
            List<GraphicNode> list2 = map.get(graphicNode);
            for (GraphicNode graphicNode2 : list2) {
                listIterator.add(graphicNode2);
            }
        }
    }

    public WalkersNodeModel getWalkersModel() {
        return this.model;
    }

    class TransformerNodeModel
    implements WalkersNodeModel {
        protected MultiMap childrenMap = new MultiHashMap();
        protected Map parentMap = new HashMap();

        TransformerNodeModel() {
        }

        public List getChildren(Node node) {
            if (node.getImpl() instanceof GroupNodeImpl) {
                return (List)this.childrenMap.get(node);
            }
            return NodeCacheTransformer.this.refCache.getModel().getChildren(node);
        }

        public Node getParent(Node node) {
            if (this.parentMap.containsKey(node)) {
                return (Node)this.parentMap.get(node);
            }
            return NodeCacheTransformer.this.refCache.getModel().getParent(node);
        }

        public boolean isSummary(Node node) {
            if (node.getImpl() instanceof GroupNodeImpl) {
                return true;
            }
            return NodeCacheTransformer.this.refCache.getModel().isSummary(node);
        }

        public Node search(Object object) {
            Node node = NodeCacheTransformer.this.refCache.getModel().search(object);
            return null;
        }

        public void addRelationship(Node node, Node node2) {
            if (node != null) {
                this.childrenMap.put(node, node2);
            }
            this.parentMap.put(node2, node);
        }

        public void clear() {
            this.childrenMap.clear();
            this.parentMap.clear();
        }

        public Document getDocument() {
            return NodeCacheTransformer.this.refCache.getDocument();
        }
    }

    private class GraphicNodeComparator
    implements Comparator {
        protected NodeSorter comparator;
        protected NodeTransformer composition;

        private GraphicNodeComparator(NodeSorter nodeSorter) {
            this(nodeSorter, null);
        }

        private GraphicNodeComparator(NodeSorter nodeSorter, NodeTransformer nodeTransformer) {
            this.comparator = nodeSorter;
            this.composition = nodeTransformer;
        }

        public int compare(Object object, Object object2) {
            GraphicNode graphicNode = (GraphicNode)object;
            GraphicNode graphicNode2 = (GraphicNode)object2;
            if (graphicNode == graphicNode2) {
                return 0;
            }
            if (graphicNode.isVoid()) {
                return 1;
            }
            if (graphicNode2.isVoid()) {
                return -1;
            }
            if (this.composition == null) {
                return this.comparator.compare(graphicNode.getNode(), graphicNode2.getNode());
            }
            return this.comparator.compare(this.composition.evaluate(graphicNode.getNode()), this.composition.evaluate(graphicNode2.getNode()));
        }

        public ListIterator getCurrentSorter() {
            return this.comparator.getCurrentSorter();
        }
    }
}

