/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.timescale;

import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.gantt.GanttParams;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeIterator;
import com.projity.util.Environment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TimeScaleComponent
extends JPanel {
    protected CoordinatesConverter coord;
    protected static Color textColor;
    protected static Color lineColor;

    public TimeScaleComponent(CoordinatesConverter coordinatesConverter) {
        this.coord = coordinatesConverter;
        int n2 = GraphicConfiguration.getInstance().getColumnHeaderHeight();
        if (textColor == null) {
            textColor = Color.BLACK;
        }
        if (lineColor == null) {
            lineColor = Environment.isMac() ? Color.LIGHT_GRAY : Color.BLACK;
        }
        this.setPreferredSize(new Dimension(0, n2));
        if (Environment.isMac()) {
            this.setBackground(GraphicManager.getInstance().getLafManager().getUnselectedBackgroundColor());
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        TimeScaleComponent.paintTimeScale(graphics2D, this.coord, this.getFont(), new Dimension(0, this.getHeight()), true);
    }

    public static void paintTimeScale(Graphics2D graphics2D, GanttParams ganttParams, Font font) {
        TimeScaleComponent.paintTimeScale(graphics2D, ganttParams.getCoord(), font, new Dimension((int)ganttParams.getGanttBounds().getWidth(), ganttParams.getConfiguration().getColumnHeaderHeight()), false);
    }

    public static void paintTimeScale(Graphics2D graphics2D, CoordinatesConverter coordinatesConverter, Font font, Dimension dimension, boolean bl) {
        double d2;
        double d3;
        Rectangle rectangle = graphics2D.getClipBounds();
        double d4 = dimension.getHeight();
        if (bl) {
            d3 = rectangle.getX();
            d2 = rectangle.getWidth();
            GraphicManager.getInstance().getLafManager().paintTimeScale(graphics2D, rectangle.x, 0, rectangle.width, dimension.height, new Shape[]{new Line2D.Double(d3, 0.0, d3 + d2, 0.0), new Line2D.Double(d3, d4 - 1.0, d3 + d2, d4 - 1.0)});
        } else {
            d3 = 0.0;
            d2 = dimension.getWidth();
        }
        graphics2D.setColor(lineColor);
        if (Environment.isMac()) {
            graphics2D.draw(new Line2D.Double(d3, d4 - 1.0, d3 + d2, d4 - 1.0));
        }
        graphics2D.draw(new Line2D.Double(d3, d4 / 2.0, d3 + d2, d4 / 2.0));
        TimeIterator timeIterator = coordinatesConverter.getTimeIterator(d3, d3 + d2);
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        long l2 = -1L;
        long l3 = -1L;
        while (timeIterator.hasNext()) {
            TimeInterval timeInterval = timeIterator.next();
            if (l2 == -1L) {
                l2 = timeInterval.getStart1();
            }
            l3 = timeInterval.getEnd1();
            double d5 = coordinatesConverter.toX(timeInterval.getStart1());
            double d6 = coordinatesConverter.toX(timeInterval.getEnd1());
            graphics2D.setColor(lineColor);
            if (bl) {
                graphics2D.draw(new Line2D.Double(d5, d4 / 2.0, d5, d4));
            }
            graphics2D.draw(new Line2D.Double(d6, d4 / 2.0, d6, d4));
            String string = timeInterval.getText1();
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            graphics2D.setColor(textColor);
            graphics2D.drawString(string, (float)((int)d5 + 2), (float)((int)d4) - lineMetrics.getDescent() - lineMetrics.getLeading());
            if (timeInterval.getText2() == null) continue;
            double d7 = coordinatesConverter.toX(timeInterval.getStart2());
            double d8 = coordinatesConverter.toX(timeInterval.getEnd2());
            graphics2D.setColor(lineColor);
            if (bl) {
                graphics2D.draw(new Line2D.Double(d7, 0.0, d7, d4 / 2.0));
            }
            graphics2D.draw(new Line2D.Double(d8, 0.0, d8, d4 / 2.0));
            string = timeInterval.getText2();
            lineMetrics = font.getLineMetrics(string, fontRenderContext);
            if (!bl && !((double)((int)d7 + 2) >= d3)) continue;
            graphics2D.setColor(textColor);
            graphics2D.drawString(string, (float)((int)d7 + 2), (float)((int)d4 / 2) - lineMetrics.getDescent() - lineMetrics.getLeading());
        }
    }
}

