/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.pm.time.HasStartAndEnd;
import com.projity.util.DateTime;
import java.util.Date;

public class ScheduleInterval
implements HasStartAndEnd,
Cloneable {
    long start;
    long end;
    long minimumStart = 0L;
    long maximumStart = DateTime.getMaxDate().getTime();
    long minimumEnd = 0L;
    long maximumEnd = this.maximumStart;

    public ScheduleInterval(long l2, long l3) {
        this.start = l2;
        this.end = l3;
    }

    public boolean isValid() {
        return this.start <= this.end;
    }

    public boolean canChangeStart() {
        return this.minimumStart != this.maximumStart;
    }

    public boolean canChangeDuration() {
        return this.minimumEnd != this.maximumEnd;
    }

    boolean canChangeOwner() {
        return false;
    }

    public long getMaximumEnd() {
        return this.maximumEnd;
    }

    public void setMaximumEnd(long l2) {
        this.maximumEnd = l2;
    }

    public long getMaximumStart() {
        return this.maximumStart;
    }

    public void setMaximumStart(long l2) {
        this.maximumStart = l2;
    }

    public long getMinimumEnd() {
        return this.minimumEnd;
    }

    public void setMinimumEnd(long l2) {
        this.minimumEnd = l2;
    }

    public long getMinimumStart() {
        return this.minimumStart;
    }

    public void setMinimumStart(long l2) {
        this.minimumStart = l2;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public ScheduleInterval intersectWith(HasStartAndEnd hasStartAndEnd) {
        if (hasStartAndEnd == null) {
            return this;
        }
        ScheduleInterval scheduleInterval = (ScheduleInterval)this.clone();
        scheduleInterval.start = Math.max(this.start, hasStartAndEnd.getStart());
        scheduleInterval.end = Math.min(this.end, hasStartAndEnd.getEnd());
        return scheduleInterval;
    }

    public String toString() {
        return "Start:" + new Date(this.start) + " End:" + new Date(this.end);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

