/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.task;

import com.projity.algorithm.ReverseQuery;
import com.projity.algorithm.TimeIteratorGenerator;
import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.association.AssociationFormatParameters;
import com.projity.association.AssociationList;
import com.projity.association.AssociationListFormat;
import com.projity.configuration.Configuration;
import com.projity.configuration.Settings;
import com.projity.datatype.Duration;
import com.projity.datatype.ImageLink;
import com.projity.document.Document;
import com.projity.field.CustomFieldsImpl;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.functor.IntervalConsumer;
import com.projity.functor.NumberClosure;
import com.projity.functor.ObjectVisitor;
import com.projity.graphic.configuration.HasIndicators;
import com.projity.graphic.configuration.HasTaskIndicators;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.summaries.DeepChildWalker;
import com.projity.options.CalculationOption;
import com.projity.options.CalendarOption;
import com.projity.options.ScheduleOption;
import com.projity.pm.assignment.Allocation;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentFormat;
import com.projity.pm.assignment.AssignmentService;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.assignment.TimeDistributedFields;
import com.projity.pm.assignment.timesheet.TimesheetHelper;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.costing.EarnedValueCalculator;
import com.projity.pm.costing.EarnedValueFields;
import com.projity.pm.costing.EarnedValueValues;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.key.HasKeyImpl;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.scheduling.BarClosure;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleEvent;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.scheduling.ScheduleUtil;
import com.projity.pm.scheduling.SchedulingFields;
import com.projity.pm.scheduling.SchedulingRule;
import com.projity.pm.scheduling.SchedulingType;
import com.projity.pm.snapshot.BaselineScheduleFields;
import com.projity.pm.snapshot.DataSnapshot;
import com.projity.pm.snapshot.SnapshottableImpl;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.pm.task.TaskBackup;
import com.projity.pm.task.TaskSnapshot;
import com.projity.pm.task.TaskSnapshotBackup;
import com.projity.pm.task.TaskSpecificFields;
import com.projity.server.access.ErrorLogger;
import com.projity.strings.Messages;
import com.projity.util.DateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.collections.Closure;

public class NormalTask
extends Task
implements Allocation,
TaskSpecificFields,
SchedulingFields,
HasAssignments,
EarnedValueValues,
EarnedValueFields,
TimeDistributedFields,
BaselineScheduleFields,
HasTaskIndicators {
    static final long serialVersionUID = 273898992929L;
    boolean estimated = true;
    int priority = 500;
    private static NormalTask UNASSIGNED = null;
    private WorkCalendar workCalendar = null;
    protected static transient BarClosure barClosureInstance = new BarClosure();
    private static short DEFAULT_VERSION = (short)2;
    private short version = DEFAULT_VERSION;

    public NormalTask(Project project) {
        this(project.isLocal(), project);
    }

    public NormalTask(boolean bl, Project project) {
        super(bl);
        this.project = project;
        this.initializeDates();
        this.addDefaultAssignment();
    }

    public NormalTask() {
    }

    void initializeDates() {
        this.setRawConstraintType(this.project == null ? 0 : this.project.getDefaultConstraintType());
        long l2 = CalendarOption.getInstance().getDefaultDuration();
        this.setRawDuration(l2);
        this.setWorkCalendar(null);
        long l3 = this.project.getStart();
        this.currentSchedule.setStart(l3);
        this.currentSchedule.setFinish(l3);
        if (ScheduleOption.getInstance().isNewTasksStartToday()) {
            this.setWindowEarlyStart(CalendarOption.getInstance().makeValidStart(DateTime.midnightToday(), true));
        }
    }

    private NormalTask(boolean bl) {
        super(true);
    }

    public static NormalTask getUnassignedInstance() {
        if (UNASSIGNED == null) {
            UNASSIGNED = new NormalTask(true);
            UNASSIGNED.setName(Messages.getString("Text.Unassigned"));
        }
        return UNASSIGNED;
    }

    private Assignment newDefaultAssignment() {
        return Assignment.getInstance((Task)this, ResourceImpl.getUnassignedInstance(), 1.0, 0);
    }

    public boolean isNormal() {
        return !this.isSummary() && !this.isMilestone() && !this.isExternal();
    }

    public boolean isCritical() {
        if (this.currentSchedule.isForward()) {
            return this.getEarlyFinish() >= this.getLateFinish();
        }
        return this.getLateStart() <= this.getEarlyStart();
    }

    public boolean isMilestone() {
        return Duration.millis(this.getRawDuration()) == 0L || this.isMarkTaskAsMilestone();
    }

    public double getPercentComplete() {
        if (this.isZeroDuration()) {
            int n2 = 0;
            double d2 = 0.0;
            for (Assignment assignment : this.getAssignments()) {
                d2 += assignment.getPercentComplete();
                ++n2;
            }
            if (n2 == 0) {
                return 0.0;
            }
            return d2 / (double)n2;
        }
        return super.getPercentComplete();
    }

    public long getDuration() {
        long l2;
        if (this.isWbsParent() || this.isExternal() || this.isSubproject()) {
            long l3 = this.getRawDuration();
            if (l3 >= 0L) {
                l2 = Duration.millis(l3);
            } else {
                this.project.addRepaired(this);
                ErrorLogger.logOnce("raw parent", "repaired bad raw duration" + this, null);
                l2 = 0L;
            }
        } else {
            AssociationList associationList = this.getAssignments();
            if (associationList.size() == 1) {
                l2 = ((Assignment)associationList.getFirst()).getDurationMillis();
            } else {
                Iterator iterator = associationList.iterator();
                long l4 = 0L;
                while (iterator.hasNext()) {
                    l4 = Math.max(l4, ((Assignment)iterator.next()).getEnd());
                }
                l2 = this.getEffectiveWorkCalendar().compare(l4, this.getStart(), false);
            }
        }
        l2 = Duration.setAsEstimated(l2, this.estimated);
        return l2;
    }

    public boolean hasDuration() {
        if (this.isWbsParent()) {
            return this.getRawDuration() != 0L;
        }
        AssociationList associationList = this.getAssignments();
        if (associationList.size() == 1) {
            return ((Assignment)associationList.getFirst()).hasDuration();
        }
        Iterator iterator = associationList.iterator();
        while (iterator.hasNext()) {
            if (!((Assignment)iterator.next()).hasDuration()) continue;
            return true;
        }
        return false;
    }

    public void setDuration(long l2) {
        this.setRawDuration(l2);
        this.estimated = Duration.isEstimated(l2);
        l2 = Duration.millis(l2);
        long l3 = Duration.millis(this.getActualDuration());
        if (l2 < l3) {
            this.setPercentComplete(1.0);
        }
        if (!this.isWbsParent()) {
            long l4 = l2 - l3;
            this.getSchedulingRule().adjustRemainingDuration(this, l4, true);
        }
        this.updateCachedDuration();
    }

    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    public WorkCalendar getEffectiveWorkCalendar() {
        if (this.workCalendar == null) {
            if (this.getProject() == null) {
                System.out.println("------No project in getting calendar for task " + this.getUniqueId() + " " + this.getName());
                return CalendarService.getInstance().getDefaultInstance();
            }
            return this.getProject().getEffectiveWorkCalendar();
        }
        return this.workCalendar;
    }

    public void setWorkCalendar(WorkCalendar workCalendar) {
        this.workCalendar = workCalendar;
    }

    public DataSnapshot getCurrentSnapshot() {
        return this.snapshots.getCurrentSnapshot();
    }

    public DataSnapshot getSnapshot(Object object) {
        return this.snapshots.getSnapshot(object);
    }

    public void saveCurrentToSnapshot(Object object) {
        this.setSnapshot(object, this.cloneSnapshot(this.getSnapshot(CURRENT)));
        this.markTaskAsNeedingRecalculation();
        this.setDirty(true);
    }

    public void restoreSnapshot(Object object, Object object2) {
        TaskBackup taskBackup = (TaskBackup)object2;
        if (taskBackup.snapshot == null) {
            return;
        }
        TaskSnapshot taskSnapshot = (TaskSnapshot)((TaskSnapshot)this.getSnapshot(CURRENT)).clone();
        this.restoreDetail(this, taskBackup, true, taskSnapshot);
        this.setSnapshot(object, taskSnapshot);
        this.markTaskAsNeedingRecalculation();
        this.setDirty(true);
    }

    public void setCurrentSnapshot(DataSnapshot dataSnapshot) {
        this.snapshots.setCurrentSnapshot(dataSnapshot);
    }

    public void setSnapshot(Object object, DataSnapshot dataSnapshot) {
        this.snapshots.setSnapshot(object, dataSnapshot);
    }

    public void clearSnapshot(Object object) {
        this.snapshots.clearSnapshot(object);
        this.markTaskAsNeedingRecalculation();
        this.setDirty(true);
    }

    public boolean hasRealAssignments() {
        return null == this.findAssignment(ResourceImpl.getUnassignedInstance());
    }

    public AssociationList getAssignments() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getAssignments();
    }

    public AssociationList getRealAssignments() {
        if (this.hasRealAssignments()) {
            return this.getAssignments();
        }
        return new AssociationList();
    }

    public boolean isAssignedToMe() {
        for (Assignment assignment : this.getAssignments()) {
            if (!assignment.isMine()) continue;
            return true;
        }
        return false;
    }

    public Assignment addDefaultAssignment() {
        Assignment assignment = this.newDefaultAssignment();
        this.addAssignment(assignment);
        return assignment;
    }

    public void addAssignment(Assignment assignment) {
        boolean bl = !assignment.isDefault() && assignment.isInitialized() && assignment.isLabor();
        Assignment assignment2 = this.findAssignment(ResourceImpl.getUnassignedInstance());
        if (!assignment.isDefault()) {
            if (assignment2 != null) {
                assignment.usePropertiesOf(assignment2);
                AssignmentService.getInstance().remove(assignment2, null, true);
            } else {
                if (this.getActualStart() != 0L) {
                    assignment.setDelay(Duration.millis(this.getActualDuration()));
                }
                assignment.adjustRemainingDuration(Duration.millis(this.getRemainingDuration()), false);
            }
        } else {
            if (assignment2 != null) {
                AssignmentService.getInstance().remove(assignment2, null, true);
            }
            assignment.setDuration(this.getRawDuration());
        }
        double d2 = this.getMostLoadedAssignmentUnits();
        double d3 = this.getRemainingUnits();
        ((TaskSnapshot)this.getCurrentSnapshot()).addAssignment(assignment);
        if (!assignment.isInitialized()) {
            return;
        }
        if (bl && this.isEffortDriven() && d3 != 0.0) {
            if (this.getSchedulingType() == 1) {
                assignment.adjustRemainingUnits(Math.min(1.0, d2), 1.0, false, false);
            }
            double d4 = d3 + assignment.getRemainingLaborUnits();
            this.getSchedulingRule().adjustRemainingUnits(this, d4, d3, true, true);
        }
        this.setDirty(true);
    }

    public void removeAssignment(Assignment assignment) {
        boolean bl = !assignment.isDefault() && assignment.isInitialized();
        double d2 = this.getRemainingUnits();
        ((TaskSnapshot)this.getCurrentSnapshot()).removeAssignment(assignment);
        if (!assignment.isDefault()) {
            double d3;
            if (bl && this.isEffortDriven() && (d3 = d2 - assignment.getLaborUnits()) != 0.0) {
                this.getSchedulingRule().adjustRemainingUnits(this, d3, d2, true, true);
            }
            if (this.getAssignments().isEmpty()) {
                Assignment assignment2 = this.newDefaultAssignment();
                assignment2.usePropertiesOf(assignment);
                AssignmentService.getInstance().connect(assignment2, null);
            }
        }
        this.setDirty(true);
    }

    public DataSnapshot cloneSnapshot(DataSnapshot dataSnapshot) {
        return (DataSnapshot)((TaskSnapshot)dataSnapshot).clone();
    }

    public TaskSnapshot getBaselineSnapshot() {
        return (TaskSnapshot)this.getSnapshot(CalculationOption.getInstance().getEarnedValueBaselineId());
    }

    public void buildReverseQuery(ReverseQuery reverseQuery) {
        ((TaskSnapshot)this.getCurrentSnapshot()).buildReverseQuery(reverseQuery);
        Collection collection = this.getWbsChildrenNodes();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = ((Node)iterator.next()).getImpl();
                if (!(object instanceof NormalTask)) continue;
                Task task = (Task)object;
                task.buildReverseQuery(reverseQuery);
            }
        }
    }

    public long getBaselineStartOrZero() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return 0L;
        }
        return this.getBaselineStart();
    }

    public long getBaselineFinishOrZero() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return 0L;
        }
        return this.getBaselineFinish();
    }

    public long getBaselineStart() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return this.getStart();
        }
        return taskSnapshot.getCurrentSchedule().getStart();
    }

    public long getBaselineFinish() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return this.getEnd();
        }
        return taskSnapshot.getCurrentSchedule().getFinish();
    }

    public int getSchedulingType() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getSchedulingType();
    }

    public void setSchedulingType(int n2) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setSchedulingType(n2);
    }

    public boolean isEffortDriven() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).isEffortDriven();
    }

    public void setEffortDriven(boolean bl) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setEffortDriven(bl);
    }

    public boolean isReadOnlyEffortDriven(FieldContext fieldContext) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).isReadOnlyEffortDriven(fieldContext);
    }

    public static Closure forAllAssignments(Closure closure) {
        return new ObjectVisitor(closure){

            protected Object getObject(Object object) {
                return ((TaskSnapshot)((Task)object).getCurrentSnapshot()).getHasAssignments();
            }
        };
    }

    public double getFixedCost() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getFixedCost();
    }

    public void setFixedCost(double d2) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setFixedCost(d2);
    }

    public final int getFixedCostAccrual() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getFixedCostAccrual();
    }

    public final void setFixedCostAccrual(int n2) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setFixedCostAccrual(n2);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public Assignment findAssignment(Resource resource) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).findAssignment(resource);
    }

    public Assignment findAssignment(Task task) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).findAssignment(task);
    }

    public void updateAssignment(Assignment assignment) {
        ((TaskSnapshot)this.getCurrentSnapshot()).updateAssignment(assignment);
    }

    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        ((TaskSnapshot)this.getCurrentSnapshot()).forEachWorkingInterval(closure, bl, workCalendar);
    }

    public boolean isEstimated() {
        return this.estimated;
    }

    public void setEstimated(boolean bl) {
        NormalTask normalTask;
        boolean bl2 = this.estimated != bl;
        this.estimated = bl;
        if (bl2 && this.isWbsParent() && (normalTask = (NormalTask)this.getWbsParentTask()) != null) {
            normalTask.updateEstimatedStatus();
        }
    }

    private void updateEstimatedStatus() {
        Collection collection = this.getWbsChildrenNodes();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof NormalTask)) continue;
            NormalTask normalTask = (NormalTask)object;
            bl |= normalTask.isEstimated();
        }
        this.setEstimated(bl);
    }

    protected void assignParentActualDatesFromChildren() {
        NormalTask normalTask = this;
        while ((normalTask = (NormalTask)normalTask.getWbsParentTask()) != null) {
            normalTask.assignActualDatesFromChildren();
        }
    }

    public void assignActualDatesFromChildren() {
        long l2 = Long.MAX_VALUE;
        long l3 = 0L;
        Collection collection = this.getWbsChildrenNodes();
        Iterator iterator = collection.iterator();
        long l4 = Duration.millis(this.getActualDuration());
        while (iterator.hasNext()) {
            NormalTask normalTask;
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof NormalTask) || !(normalTask = (NormalTask)object).inProgress()) continue;
            long l5 = normalTask.getActualStart();
            if (l5 != 0L) {
                l2 = Math.min(l2, l5);
            }
            l3 = Math.max(l3, normalTask.getStop());
        }
        long l6 = 0L;
        if (l2 != Long.MAX_VALUE && l3 != 0L) {
            l6 = this.getEffectiveWorkCalendar().compare(l3, this.getStart(), false);
        }
        if (l2 != Long.MAX_VALUE) {
            this.setActualStartNoEvent(l2);
        } else {
            this.setActualStartNoEvent(0L);
        }
        if (l6 != l4) {
            double d2 = (double)l6 / (double)this.getDurationMillis();
            this.currentSchedule.setPercentComplete(d2);
            this.markTaskAsNeedingRecalculation();
        }
    }

    public WorkCalendar getTaskCalendar() {
        return this.getWorkCalendar();
    }

    public void setTaskCalendar(WorkCalendar workCalendar) {
        if (this.workCalendar == workCalendar) {
            return;
        }
        CalendarService.getInstance().reassignCalendar(this, this.workCalendar, workCalendar);
        this.setWorkCalendar(workCalendar);
        this.invalidateAssignmentCalendars();
    }

    public long getBaselineStart(int n2) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0L;
        }
        return taskSnapshot.getCurrentSchedule().getStart();
    }

    public long getBaselineFinish(int n2) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0L;
        }
        return taskSnapshot.getCurrentSchedule().getEnd();
    }

    public long getBaselineDuration(int n2) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0L;
        }
        return taskSnapshot.getCurrentSchedule().getRawDuration();
    }

    public double getBaselineCost(int n2, long l2, long l3) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0.0;
        }
        return taskSnapshot.cost(l2, l3);
    }

    public double getBaselineWork(int n2, long l2, long l3) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0.0;
        }
        return taskSnapshot.work(l2, l3);
    }

    public String getResourceInitials() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.initials"), false, false))).format(this.getAssignments());
    }

    public void setResourceInitials(String string) throws FieldParseException {
        this.getAssignments().setAssociations(string, AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.initials"), false, false)));
    }

    public String getResourcePhonetics() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.phonetics"), false, true))).format(this.getAssignments());
    }

    public String getResourceGroup() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.group"), false, false))).format(this.getAssignments());
    }

    public String getResourceNames() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.name"), true, true))).format(this.getAssignments());
    }

    public void setResourceNames(String string) throws FieldParseException {
        this.getAssignments().setAssociations(string, AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.name"), true, true)));
    }

    public double getUnits() {
        if (this.getAssignments().isEmpty()) {
            return 0.0;
        }
        long l2 = this.getDurationMillis();
        if ((double)l2 == 0.0) {
            return 1.0;
        }
        if (!this.isInitialized()) {
            return 1.0;
        }
        long l3 = this.calcWork();
        if (l3 == 0L) {
            return 1.0;
        }
        return (double)l3 / (double)l2;
    }

    public double getRemainingUnits() {
        if (this.getAssignments().isEmpty()) {
            return 0.0;
        }
        long l2 = Duration.millis(this.getRemainingDuration());
        if ((double)l2 == 0.0) {
            return 1.0;
        }
        if (!this.isInitialized()) {
            return 1.0;
        }
        long l3 = this.getRemainingWork(null);
        return (double)l3 / (double)l2;
    }

    public void setWork(long l2, FieldContext fieldContext) {
        if (FieldContext.hasInterval(fieldContext)) {
            for (Assignment assignment : this.getAssignments()) {
                assignment.setWork(l2, fieldContext);
            }
        } else {
            this.setWork(l2);
        }
    }

    public void setWork(long l2) {
        l2 = Duration.millis(l2);
        if (this.hasLaborAssignment() && l2 < 60000L) {
            l2 = (long)((double)l2 * Duration.timeUnitFactor(1));
        }
        long l3 = l2 - this.getActualWork(null);
        this.getSchedulingRule().adjustRemainingWork(this, l3, true);
    }

    public long calcWork() {
        if (!this.hasRealAssignments()) {
            return 0L;
        }
        return this.getWork(null);
    }

    public double getMostLoadedAssignmentUnits() {
        double d2 = 0.0;
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            d2 = Math.max(d2, ((Assignment)iterator.next()).getLaborUnits());
        }
        return d2;
    }

    public void adjustRemainingDuration(long l2, boolean bl) {
        long l3 = Duration.millis(l2);
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            ((Assignment)iterator.next()).adjustRemainingDurationIfWorkingAtTaskEnd(l3);
        }
    }

    public void adjustUnitsDelta(double d2) {
        this.getSchedulingRule().adjustRemainingUnits(this, this.getRemainingUnits() + d2, this.getRemainingUnits(), false, false);
    }

    public void adjustRemainingUnits(double d2, double d3, boolean bl, boolean bl2) {
        if (!bl) {
            return;
        }
        double d4 = 1.0;
        if (bl2) {
            d4 = d3 / d2;
        }
        double d5 = d2;
        double d6 = this.getRemainingUnits();
        double d7 = d5 / d6;
        for (Assignment assignment : this.getAssignments()) {
            double d8 = assignment.getLaborUnits();
            if (bl2) {
                this.getSchedulingRule().adjustRemainingUnits(assignment, assignment.getRemainingLaborUnits() * d4, assignment.getRemainingLaborUnits(), false, false);
                continue;
            }
            this.getSchedulingRule().adjustRemainingUnits(assignment, d7 * d8, d8, false, false);
        }
    }

    public void adjustRemainingWork(double d2, boolean bl) {
        for (Assignment assignment : this.getAssignments()) {
            if (!assignment.isLabor()) continue;
            this.getSchedulingRule().adjustRemainingWork(assignment, (long)((double)assignment.getRemainingWork() * d2), false);
        }
    }

    public SchedulingRule getSchedulingRule() {
        return SchedulingType.getSchedulingRuleInstance(this.getSchedulingType());
    }

    public boolean isReadOnlyUnits(FieldContext fieldContext) {
        return true;
    }

    public long getCompletedThrough() {
        long l2 = this.getStart();
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = DateTime.closestDate((double)this.getDurationMillis() * this.getPercentComplete());
        return this.getEffectiveWorkCalendar().add(l2, l3, true);
    }

    public long getStop() {
        return this.getEarliestStop();
    }

    public void adjustActualStartFromAssignments() {
        Iterator iterator = this.getAssignments().iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            if (!(assignment.getPercentComplete() > 0.0)) continue;
            l2 = this.getStart();
            break;
        }
        this.setActualStart(l2);
        this.assignParentActualDatesFromChildren();
    }

    public void setStop(long l2) {
        if (l2 == this.getStop()) {
            return;
        }
        l2 = DateTime.closestDate(l2);
        l2 = Math.min(l2, this.getEnd());
        Iterator iterator = this.getAssignments().iterator();
        long l3 = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            assignment.setStop(l2);
            long l4 = assignment.getActualStart();
            if (l4 == 0L || l4 >= l3) continue;
            l3 = l4;
        }
        if (l3 == Long.MAX_VALUE) {
            l3 = 0L;
        }
        this.setActualStart(l3);
        this.assignParentActualDatesFromChildren();
        if (l3 == 0L) {
            this.getDocument().getObjectEventManager().fireUpdateEvent((Object)this, (Object)this, Configuration.getFieldFromId("Field.start"));
        } else {
            this.getProject().fireScheduleChanged(this, ScheduleEvent.ACTUAL, this);
        }
    }

    public long getResume() {
        long l2 = Long.MAX_VALUE;
        for (Assignment assignment : this.getAssignments()) {
            l2 = Math.min(l2, assignment.getResume());
        }
        return l2;
    }

    public void setResume(long l2) {
        for (Assignment assignment : this.getAssignments()) {
            assignment.setResume(l2);
        }
    }

    private void setStopNoExtend(long l2) {
        long l3 = this.getStart();
        if (l2 < l3) {
            this.setActualDuration(0L);
            l2 = l3;
        } else {
            long l4 = this.getEffectiveWorkCalendar().compare(l2, l3, false);
            l4 = Math.min(l4, this.getDurationMillis());
            this.setActualDuration(l4);
        }
    }

    private boolean isParentWithoutAssignments() {
        return this.isWbsParent() && !this.hasRealAssignments();
    }

    public double cost(long l2, long l3) {
        if (this.isParentWithoutAssignments()) {
            return 0.0;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).cost(l2, l3);
    }

    public long work(long l2, long l3) {
        if (this.isParentWithoutAssignments()) {
            return 0L;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).work(l2, l3);
    }

    public double actualCost(long l2, long l3) {
        if (this.isParentWithoutAssignments()) {
            return 0.0;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).actualCost(l2, l3);
    }

    public long actualWork(long l2, long l3) {
        if (this.isParentWithoutAssignments()) {
            return 0L;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).actualWork(l2, l3);
    }

    public long remainingWork(long l2, long l3) {
        if (this.isParentWithoutAssignments()) {
            return 0L;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).remainingWork(l2, l3);
    }

    public double baselineCost(long l2, long l3) {
        if (this.getBaselineSnapshot() == null) {
            return 0.0;
        }
        return this.getBaselineSnapshot().cost(l2, l3);
    }

    public long baselineWork(long l2, long l3) {
        if (this.getBaselineSnapshot() == null) {
            return 0L;
        }
        return this.getBaselineSnapshot().work(l2, l3);
    }

    public double acwp(long l2, long l3) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).acwp(l2, l3);
    }

    public double bac(long l2, long l3) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).bac(l2, l3);
    }

    public double bcwp(long l2, long l3) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).bcwp(l2, l3);
    }

    public double bcws(long l2, long l3) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).bcws(l2, l3);
    }

    boolean isInRange(long l2, long l3) {
        long l4 = this.getStart();
        return l3 > l4 && l2 < this.getEnd();
    }

    private boolean isFieldHidden(FieldContext fieldContext) {
        return fieldContext != null && !this.isInRange(fieldContext.getStart(), fieldContext.getEnd());
    }

    private boolean isBaselineFieldHidden(int n2, FieldContext fieldContext) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return fieldContext.getStart() >= taskSnapshot.getCurrentSchedule().getFinish() || fieldContext.getEnd() <= taskSnapshot.getCurrentSchedule().getStart();
    }

    private boolean isEarnedValueFieldHidden(FieldContext fieldContext) {
        if (this.isFieldHidden(fieldContext)) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return this.project.getStatusDate() < fieldContext.getStart();
    }

    public boolean fieldHideCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideBaselineCost(int n2, FieldContext fieldContext) {
        return this.isBaselineFieldHidden(n2, fieldContext);
    }

    public boolean fieldHideBaselineWork(int n2, FieldContext fieldContext) {
        return this.isBaselineFieldHidden(n2, fieldContext);
    }

    public boolean fieldHideAcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideBac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideBcwp(FieldContext fieldContext) {
        return this.isEarnedValueFieldHidden(fieldContext);
    }

    public boolean fieldHideBcws(FieldContext fieldContext) {
        return this.isEarnedValueFieldHidden(fieldContext);
    }

    public boolean fieldHideCv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideSv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideEac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideVac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideCpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideSpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideCvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideSvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public boolean fieldHideTcpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    public double getCost(FieldContext fieldContext) {
        return this.getFixedCost(fieldContext) + this.cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long getWork(FieldContext fieldContext) {
        return this.work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getActualFixedCost(FieldContext fieldContext) {
        return this.fixedCost(FieldContext.start(fieldContext), Math.min(this.getStop(), FieldContext.end(fieldContext)));
    }

    public double getFixedCost(FieldContext fieldContext) {
        if (!FieldContext.hasInterval(fieldContext)) {
            return ((TaskSnapshot)this.getCurrentSnapshot()).getFixedCost();
        }
        return this.fixedCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double actualFixedCost(long l2, long l3) {
        return this.fixedCost(l2, Math.min(this.getStop(), l3));
    }

    public double fixedCost(long l2, long l3) {
        long l4 = this.getStart();
        long l5 = this.getEnd();
        double d2 = 0.0;
        double d3 = this.getFixedCost();
        if (this.getFixedCostAccrual() == 1) {
            if (l4 >= l2 && l4 <= l3) {
                d2 = d3;
            }
        } else if (this.getFixedCostAccrual() == 3) {
            if ((l2 = Math.max(l2, l4)) < (l3 = Math.min(l3, l5))) {
                long l6 = this.getEffectiveWorkCalendar().compare(l3, l2, false);
                double d4 = (double)l6 / (double)this.getDurationMillis();
                d2 = d3 * d4;
            }
        } else if (l5 >= l2 && l5 <= l3) {
            d2 = d3;
        }
        return d2;
    }

    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return false;
    }

    public double getActualCost(FieldContext fieldContext) {
        return this.getActualFixedCost(fieldContext) + this.actualCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long getActualWork(FieldContext fieldContext) {
        return this.actualWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long getRemainingWork(FieldContext fieldContext) {
        return this.remainingWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long getRemainingWork() {
        return this.getRemainingWork(null);
    }

    public double getRemainingCost(FieldContext fieldContext) {
        return this.getCost(fieldContext) - this.getActualCost(fieldContext);
    }

    public double getBaselineCost(int n2, FieldContext fieldContext) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0.0;
        }
        return ((TaskSnapshot)this.getSnapshot(new Integer(n2))).cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long getBaselineWork(int n2, FieldContext fieldContext) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return 0L;
        }
        return ((TaskSnapshot)this.getSnapshot(new Integer(n2))).work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getAcwp(FieldContext fieldContext) {
        return this.acwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getBac(FieldContext fieldContext) {
        return this.bac(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getBcwp(FieldContext fieldContext) {
        return this.bcwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getBcws(FieldContext fieldContext) {
        return this.bcws(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getCv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getSv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().sv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getEac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().eac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getVac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().vac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getCpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getSpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().spi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getCsi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().csi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getCvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cvPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getSvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().svPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public double getTcpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().tcpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public void calcDataBetween(Object object, TimeIteratorGenerator timeIteratorGenerator, CalculatedValues calculatedValues) {
        ((TaskSnapshot)this.getCurrentSnapshot()).calcDataBetween(object, timeIteratorGenerator, calculatedValues);
    }

    public void setPercentComplete(double d2) {
        if (d2 > 1.0) {
            System.out.println("percent complete more than 100%");
            d2 = 1.0;
        } else if (d2 < 0.0) {
            System.out.println("percent complete less than 0%");
            d2 = 0.0;
        }
        if (this.isZeroDuration()) {
            double d3 = d2;
            Iterator iterator = this.getAssignments().iterator();
            while (iterator.hasNext()) {
                ((Assignment)iterator.next()).setPercentComplete(d3);
            }
        } else {
            long l2 = DateTime.closestDate((double)this.getDurationMillis() * d2);
            this.setActualDuration(l2);
            long l3 = this.getEffectiveWorkCalendar().add(this.getStart(), l2, false);
            DeepChildWalker.recursivelyTreatBranch(this.getProject().getTaskOutline(), this, (Closure)new NumberClosure(l3){

                public void execute(Object object) {
                    if (object == null) {
                        return;
                    }
                    Object object2 = ((Node)object).getImpl();
                    if (object2 instanceof NormalTask) {
                        NormalTask normalTask = (NormalTask)object2;
                        normalTask.setStop(Math.min(this.longValue(), normalTask.getEnd()));
                    }
                }
            });
        }
    }

    public double getPercentWorkComplete() {
        long l2 = this.calcSummedWork();
        if (l2 == 0L) {
            return 0.0;
        }
        return (double)this.calcSummedActualWork() / (double)l2;
    }

    private long calcSummedWork() {
        NodeModel nodeModel = this.getProject().getTaskOutline();
        Node node = nodeModel.search(this);
        if (node == null) {
            return 0L;
        }
        Number number = (Number)Configuration.getFieldFromId("Field.work").getValue(node, nodeModel, null);
        return number.longValue();
    }

    private long calcSummedActualWork() {
        NodeModel nodeModel = this.getProject().getTaskOutline();
        Node node = nodeModel.search(this);
        Number number = (Number)Configuration.getFieldFromId("Field.actualWork").getValue(node, nodeModel, null);
        return number.longValue();
    }

    public void setPercentWorkComplete(double d2) {
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        double d3 = d2 * (double)this.calcSummedWork();
        long l2 = ReverseQuery.getDateAtValue(WORK, this, d3, true);
        DeepChildWalker.recursivelyTreatBranch(this.getProject().getTaskOutline(), this, (Closure)new NumberClosure(l2){

            public void execute(Object object) {
                if (object == null) {
                    return;
                }
                Object object2 = ((Node)object).getImpl();
                if (object2 instanceof NormalTask) {
                    ((NormalTask)object2).setStopNoExtend(this.getLongValue());
                }
            }
        });
    }

    void cleanUp(Object object, boolean bl, boolean bl2, boolean bl3) {
        super.cleanUp(object, bl, bl2, bl3);
        if (bl) {
            for (int i2 = 0; i2 < Settings.numBaselines(); ++i2) {
                Integer n2 = new Integer(i2);
                TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(n2);
                if (taskSnapshot == null) continue;
                Object object2 = this.getCurrentSnapshot() == taskSnapshot ? object : null;
                LinkedList linkedList = new LinkedList();
                AssignmentService.getInstance().remove((Collection)taskSnapshot.getAssignments(), linkedList);
                AssignmentService.getInstance().remove(linkedList, object2, false);
                if (taskSnapshot == this.getCurrentSnapshot()) continue;
                this.getProject().fireBaselineChanged(object, this, n2, false);
            }
        }
    }

    public Collection childrenToRollup() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getHasAssignments().childrenToRollup();
    }

    public double getCost() {
        return this.getCost(null);
    }

    public double getBaselineCost() {
        return this.getBaselineCost(0, null);
    }

    public double getBaselineCost(int n2) {
        return this.getBaselineCost(n2, null);
    }

    public double getWork() {
        return this.getWork(null);
    }

    public double getBaselineWork() {
        return this.getBaselineWork(0, null);
    }

    public double getBaselineWork(int n2) {
        return this.getBaselineWork(n2, null);
    }

    public long getTotalSlackStart() {
        return this.getConstraintType() == 1 ? this.getEarlyStart() : this.getEarlyFinish();
    }

    public long getTotalSlackEnd() {
        return this.getConstraintType() == 1 ? this.getLateStart() : this.getLateFinish();
    }

    public long calcOffsetFrom(long l2, long l3, boolean bl, boolean bl2, boolean bl3) {
        long l4;
        if (this.isWbsParent()) {
            long l5;
            long l6 = l5 = bl2 ? Duration.millis(this.getRemainingDuration()) : this.getDurationMillis();
            if (!bl) {
                l5 = -l5;
            }
            return this.getEffectiveWorkCalendar().add(l2, l5, bl3);
        }
        Iterator iterator = this.getAssignments().iterator();
        if (l2 < 0L) {
            l4 = bl ? Long.MIN_VALUE : 0L;
        } else {
            long l7 = l4 = bl ? 0L : Long.MAX_VALUE;
        }
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            long l8 = assignment.calcOffsetFrom(l2, l3, bl, bl2, bl3);
            l4 = bl ? Math.max(l4, l8) : Math.min(l4, l8);
        }
        return l4;
    }

    public long calcActiveAssignmentDuration(WorkCalendar workCalendar) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).calcActiveAssignmentDuration(workCalendar);
    }

    public void moveRemainingToDate(long l2) {
        l2 = this.getEffectiveWorkCalendar().adjustInsideCalendar(l2, false);
        if (this.getActualStart() == 0L) {
            this.setStart(l2);
        } else if (this.inProgress()) {
            for (Assignment assignment : this.getAssignments()) {
                assignment.moveRemainingToDate(l2);
            }
        }
    }

    public void moveInterval(Object object, long l2, long l3, ScheduleInterval scheduleInterval, boolean bl) {
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        boolean bl2 = workCalendar.compare(l2 = workCalendar.adjustInsideCalendar(l2, false), scheduleInterval.getStart(), false) != 0L;
        long l4 = this.getEarliestAssignmentStart();
        long l5 = workCalendar.compare(scheduleInterval.getStart(), l4, false);
        if (bl2 && l5 == 0L) {
            long l6 = workCalendar.compare(l2, l4, false);
            long l7 = workCalendar.add(this.getStart(), l6, false);
            this.setStart(l7);
        } else {
            long l8 = workCalendar.compare(l3, scheduleInterval.getEnd(), false);
            if (l8 == 0L) {
                return;
            }
            for (Assignment assignment : this.getAssignments()) {
                assignment.moveInterval(object, l2, l3, scheduleInterval, true);
            }
        }
        this.setRawDuration(this.getDurationMillis());
        this.recalculate(object);
        this.assignParentActualDatesFromChildren();
    }

    public void split(Object object, long l2, long l3) {
        l2 = this.getEffectiveWorkCalendar().adjustInsideCalendar(l2, false);
        if (l2 == (l3 = this.getEffectiveWorkCalendar().adjustInsideCalendar(l3, false))) {
            l3 = this.getEffectiveWorkCalendar().add(l2, CalendarOption.getInstance().getMillisPerDay(), false);
        }
        for (Assignment assignment : this.getAssignments()) {
            assignment.split(object, l2, l3);
        }
        this.recalculate(object);
        this.assignParentActualDatesFromChildren();
    }

    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        if (this.isWbsParent() || this.isSubproject()) {
            intervalConsumer.consumeInterval(new ScheduleInterval(this.getStart(), this.getEnd()));
            return;
        }
        barClosureInstance.initialize(intervalConsumer, this);
        this.forEachWorkingInterval(barClosureInstance, true, this.getEffectiveWorkCalendar());
        if (barClosureInstance.getCount() == 0L) {
            intervalConsumer.consumeInterval(new ScheduleInterval(this.getStart(), this.getEnd()));
        }
    }

    public void setEnd(long l2) {
        long l3;
        long l4 = this.getStart();
        if (l4 == 0L) {
            l4 = CalendarOption.getInstance().makeValidStart(DateTime.midnightToday(), true);
            this.getCurrentSchedule().setStart(l4);
        }
        if ((l2 = CalendarOption.getInstance().makeValidEnd(l2, true)) < l4) {
            l2 = l4;
        }
        if (l2 != (l3 = this.getEnd())) {
            super.setEnd(l2);
            for (Assignment assignment : this.getAssignments()) {
                assignment.setEnd(l2);
            }
            this.setRawDuration(this.getDurationMillis());
        }
        this.assignParentActualDatesFromChildren();
    }

    public void setActualStart(long l2) {
        l2 = this.getEffectiveWorkCalendar().adjustInsideCalendar(l2, false);
        this.setActualStartNoEvent(l2);
        this.markTaskAsNeedingRecalculation();
        this.getProject().fireScheduleChanged(this, ScheduleEvent.ACTUAL, this);
    }

    public void setActualStartNoEvent(long l2) {
        long l3 = this.getActualStart();
        if (l2 == l3) {
            return;
        }
        this.actualStart = l2;
        this.assignParentActualDatesFromChildren();
    }

    public boolean isIgnoreResourceCalendar() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).isIgnoreResourceCalendar();
    }

    public void setIgnoreResourceCalendar(boolean bl) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setIgnoreResourceCalendar(bl);
    }

    public boolean isDefault() {
        return this == UNASSIGNED;
    }

    public short getVersion() {
        return this.version;
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.hasKey.serialize(objectOutputStream);
        this.customFields.serialize(objectOutputStream);
        if (this.version < 1) {
            this.currentSchedule.serialize(objectOutputStream);
        } else {
            TaskSnapshot taskSnapshot;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < Settings.numBaselines(); ++n2) {
                taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
                if (taskSnapshot == null) continue;
                ++n3;
            }
            objectOutputStream.writeInt(n3);
            for (n2 = 0; n2 < Settings.numBaselines(); ++n2) {
                taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n2));
                if (taskSnapshot == null) continue;
                objectOutputStream.writeInt(n2);
                taskSnapshot.serialize(objectOutputStream);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hasKey = HasKeyImpl.deserialize(objectInputStream, this);
        this.customFields = CustomFieldsImpl.deserialize(objectInputStream);
        if (this.version < 1) {
            this.currentSchedule = TaskSchedule.deserialize(objectInputStream);
        } else {
            this.snapshots = new SnapshottableImpl(Settings.numBaselines());
            int n2 = objectInputStream.readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = objectInputStream.readInt();
                TaskSnapshot taskSnapshot = TaskSnapshot.deserialize(objectInputStream, this);
                this.setSnapshot(new Integer(n3), taskSnapshot);
            }
        }
        if (this.version < 1) {
            super.initializeTransientTaskObjects();
        } else {
            super.initializeTransientTaskObjectsAfterDeserialization();
        }
        this.version = DEFAULT_VERSION;
    }

    public Object clone() {
        Task task = (Task)super.clone();
        return task;
    }

    public void cloneTo(Task task) {
        if (task instanceof NormalTask) {
            NormalTask normalTask = (NormalTask)task;
            normalTask.estimated = this.estimated;
            normalTask.priority = this.priority;
            normalTask.version = this.version;
            normalTask.workCalendar = this.workCalendar;
        }
        super.cloneTo(task);
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
    }

    public boolean isReadOnlyWork(FieldContext fieldContext) {
        if (!this.hasLaborAssignment()) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return !this.hasActiveAssignment(fieldContext.getStart(), fieldContext.getEnd());
    }

    public void setActualWork(long l2, FieldContext fieldContext) {
        if (FieldContext.hasInterval(fieldContext)) {
            for (Assignment assignment : this.getAssignments()) {
                assignment.setActualWork(l2, fieldContext);
            }
        } else {
            long l3 = Duration.millis(l2);
            if (l3 == 0L) {
                this.setPercentComplete(0.0);
            } else {
                long l4 = ReverseQuery.getDateAtValue(WORK, this, l3, false);
                this.setStop(l4);
            }
        }
    }

    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return false;
    }

    public void setRemainingWork(long l2, FieldContext fieldContext) {
        this.setActualWork(this.getWork(fieldContext) - Duration.millis(l2), fieldContext);
    }

    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return this.isReadOnlyWork(fieldContext);
    }

    public void setFixedCost(double d2, FieldContext fieldContext) {
        if (!FieldContext.hasInterval(fieldContext)) {
            this.setFixedCost(d2);
        }
    }

    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return FieldContext.hasInterval(fieldContext);
    }

    public boolean isLabor() {
        return true;
    }

    public boolean hasLaborAssignment() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).hasLaborAssignment();
    }

    public void setRawDuration(long l2) {
        this.currentSchedule.setRawDuration(l2);
    }

    public void setParentDuration() {
        if (!this.isWbsParent()) {
            return;
        }
        this.currentSchedule.assignDatesFromChildren(null);
        long l2 = this.getDurationMillis();
        this.getSchedulingRule().adjustRemainingDuration(this, l2 - Duration.millis(this.getActualDuration()), true);
    }

    public void invalidateAssignmentCalendars() {
        ((TaskSnapshot)this.getCurrentSnapshot()).invalidateAssignmentCalendars();
    }

    public Document invalidateCalendar() {
        this.invalidateAssignmentCalendars();
        this.markTaskAsNeedingRecalculation();
        return this.getProject();
    }

    public boolean hasActiveAssignment(long l2, long l3) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).hasActiveAssignment(l2, l3);
    }

    public boolean isInvalidIntersectionCalendar() {
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            if (!((Assignment)iterator.next()).isInvalidIntersectionCalendar()) continue;
            return true;
        }
        return false;
    }

    public HasIndicators getIndicators() {
        return this;
    }

    public long getEarliestAssignmentStart() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getEarliestAssignmentStart();
    }

    public boolean isParentWithAssignments() {
        return this.isWbsParent() && this.hasRealAssignments();
    }

    public void setComplete(boolean bl) {
        ScheduleUtil.setComplete(this, bl);
    }

    public boolean applyTimesheet(Collection collection, long l2) {
        return TimesheetHelper.applyTimesheet(this.getAssignments(), collection, l2);
    }

    public long getLastTimesheetUpdate() {
        return TimesheetHelper.getLastTimesheetUpdate(this.getAssignments());
    }

    public boolean isPendingTimesheetUpdate() {
        return TimesheetHelper.isPendingTimesheetUpdate(this.getAssignments());
    }

    public int getTimesheetStatus() {
        return TimesheetHelper.getTimesheetStatus(this.getAssignments());
    }

    public String getTimesheetStatusName() {
        return TimesheetHelper.getTimesheetStatusName(this.getTimesheetStatus());
    }

    public final long getEarliestStop() {
        long l2 = Long.MAX_VALUE;
        if (this.isWbsParent()) {
            Collection collection = this.getWbsChildrenNodes();
            for (Object e2 : collection) {
                Object object;
                if (!(e2 instanceof Node) || !((object = ((Node)e2).getImpl()) instanceof Schedule)) continue;
                Schedule schedule = (Schedule)object;
                l2 = Math.min(l2, schedule.getEarliestStop());
            }
        } else {
            for (Assignment assignment : this.getAssignments()) {
                l2 = Math.min(l2, assignment.getEarliestStop());
            }
        }
        return l2;
    }

    public void setCompletedThrough(long l2) {
        l2 = DateTime.closestDate(l2);
        if ((l2 = Math.min(l2, this.getEnd())) == this.getCompletedThrough()) {
            return;
        }
        Iterator iterator = this.getAssignments().iterator();
        long l3 = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            assignment.setCompletedThrough(l2);
            long l4 = assignment.getActualStart();
            if (l4 == 0L || l4 >= l3) continue;
            l3 = l4;
        }
        if (l3 == Long.MAX_VALUE) {
            l3 = 0L;
        }
        this.setActualStart(l3);
        this.assignParentActualDatesFromChildren();
        if (l3 == 0L) {
            this.getDocument().getObjectEventManager().fireUpdateEvent((Object)this, (Object)this, Configuration.getFieldFromId("Field.start"));
        } else {
            this.getProject().fireScheduleChanged(this, ScheduleEvent.ACTUAL, this);
        }
    }

    public long getFinishOffset() {
        return EarnedValueCalculator.getInstance().getFinishOffset(this);
    }

    public long getStartOffset() {
        return EarnedValueCalculator.getInstance().getStartOffset(this);
    }

    public ImageLink getBudgetStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getCpi(null));
    }

    public ImageLink getScheduleStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getSpi(null));
    }

    public Object backupDetail() {
        return this.backupDetail(null);
    }

    public Object backupDetail(Object object) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)(object == null ? this.getCurrentSnapshot() : this.getSnapshot(object));
        TaskSnapshotBackup taskSnapshotBackup = TaskSnapshotBackup.backup(taskSnapshot, true);
        TaskBackup taskBackup = new TaskBackup();
        taskBackup.snapshot = taskSnapshotBackup;
        taskBackup.windowEarlyFinish = this.windowEarlyFinish;
        taskBackup.windowEarlyStart = this.windowEarlyStart;
        taskBackup.windowLateFinish = this.windowLateFinish;
        taskBackup.windowLateStart = this.windowLateStart;
        taskBackup.actualStart = this.actualStart;
        return taskBackup;
    }

    public void restoreDetail(Object object, Object object2, boolean bl) {
        this.restoreDetail(object, object2, bl, (TaskSnapshot)this.getCurrentSnapshot());
    }

    public void restoreDetail(Object object, Object object2, boolean bl, TaskSnapshot taskSnapshot) {
        TaskBackup taskBackup = (TaskBackup)object2;
        this.windowEarlyFinish = taskBackup.windowEarlyFinish;
        this.windowEarlyStart = taskBackup.windowEarlyStart;
        this.windowLateFinish = taskBackup.windowLateFinish;
        this.windowLateStart = taskBackup.windowLateStart;
        this.actualStart = taskBackup.actualStart;
        TaskSnapshotBackup.restore(taskSnapshot, taskBackup.snapshot);
        if (!bl) {
            this.recalculate(object);
        }
    }

    public boolean renumber(final boolean bl) {
        ResultClosure resultClosure = new ResultClosure(){

            public void execute(Object object) {
                this.result |= ((Assignment)object).renumber(bl);
            }
        };
        boolean bl2 = resultClosure.result;
        this.forSnapshotsAssignments((Closure)resultClosure, true);
        return bl2 | this.hasKey.renumber(bl);
    }

    public boolean isLocal() {
        return this.hasKey.isLocal();
    }

    public void setLocal(boolean bl) {
        this.hasKey.setLocal(bl);
    }

    public boolean isSlipped() {
        long l2 = this.getBaselineFinish();
        return l2 != 0L && this.getEnd() > l2;
    }

    public void setTaskAssignementAndPredsDirty() {
        this.setDirty(true);
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            ((Assignment)iterator.next()).setDirty(true);
        }
        Iterator iterator2 = this.getDependencyList(true).iterator();
        while (iterator2.hasNext()) {
            ((Dependency)iterator2.next()).setDirty(false);
        }
    }

    private static abstract class ResultClosure
    implements Closure {
        boolean result = false;

        private ResultClosure() {
        }
    }
}

