/*
 * Decompiled with CFR 0.152.
 */
package com.projity.timescale;

import com.projity.strings.Messages;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ExtendedDateFormat
extends SimpleDateFormat {
    protected boolean quarter;
    protected boolean half;
    protected boolean normal;
    protected String text;

    public ExtendedDateFormat() {
    }

    public ExtendedDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        super(string, dateFormatSymbols);
    }

    public ExtendedDateFormat(String string, Locale locale) {
        super(string, locale);
    }

    public ExtendedDateFormat(String string) {
        super(string);
    }

    public void applyPattern(String string) {
        this.quarter = false;
        this.half = false;
        this.normal = false;
        if (string.startsWith("Q")) {
            int n2 = string.startsWith("QQ") ? 2 : 1;
            this.text = Messages.getString("Date.Quarter" + n2);
            if (n2 == 2) {
                this.text = this.text + " ";
            }
            string = string.substring(n2);
            this.quarter = true;
        } else if (string.startsWith("L")) {
            int n3 = string.startsWith("LL") ? 2 : 1;
            this.text = Messages.getString("Date.Half" + n3);
            if (n3 == 2) {
                this.text = this.text + " ";
            }
            string = string.substring(n3);
            this.half = true;
        }
        if (string.length() > 0) {
            super.applyPattern(string);
            this.normal = true;
        }
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.quarter || this.half) {
            this.calendar.setTime(date);
            int n2 = this.calendar.get(2);
            stringBuffer.append(this.text).append(n2 / (this.quarter ? 3 : 6) + 1);
        }
        if (this.normal) {
            super.format(date, stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }
}

