/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.pm.key.HasId;
import com.projity.server.data.DataObject;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.Environment;
import java.util.Map;

public class DebugUtils {
    private static long LOW_MEMORY_LIMIT = 1000000L;

    public static void dumpStack(String string) {
        try {
            throw new Exception(string);
        }
        catch (Exception exception) {
            System.out.println(string);
            exception.printStackTrace();
            return;
        }
    }

    public static void dumpMapOfHasIdKeys(Map map) {
        for (Object k2 : map.keySet()) {
            String string = "" + k2;
            if (k2 instanceof DataObject) {
                string = "" + ((DataObject)k2).getUniqueId();
            } else if (k2 instanceof HasId) {
                string = "" + ((HasId)k2).getId();
            }
            System.out.println("key=" + string + " value=" + map.get(k2));
        }
    }

    public static boolean isMemoryOk(boolean bl) {
        long l2 = Runtime.getRuntime().freeMemory();
        System.out.println("Free Memory" + l2);
        if (l2 < LOW_MEMORY_LIMIT) {
            System.gc();
            l2 = Runtime.getRuntime().freeMemory();
            if (l2 < LOW_MEMORY_LIMIT) {
                Environment.setOutOfMemory(true);
                if (bl) {
                    Alert.error(Messages.getString("Error.OutOfMemory"));
                }
                return false;
            }
        }
        return true;
    }
}

