/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.OperaOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class OperaInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 32768;
    private static Hashtable stream_map = new Hashtable();
    private static int next_stream_id = 0;
    private int protocol_response = -1;
    private byte[] buffer = new byte[32768];
    private int next_read = 0;
    private int last_avail = -1;
    private int available = 0;
    private int total_input = 0;
    private int content_len = -1;
    private int stream_id = -1;
    private boolean header_loaded = false;
    private boolean eof_state = false;
    protected Hashtable header_fields = new Hashtable();

    protected OperaInputStream() {
    }

    public int getResponse() {
        return this.protocol_response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            return this.available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            while (this.available == 0 && !this.eof_state) {
                try {
                    this.starving();
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.eof_state = true;
                    this.available = 0;
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            if (this.available == 0 && this.eof_state) {
                this.buffer = null;
                return -1;
            }
            --this.available;
            if (this.next_read == 32768) {
                this.next_read = 0;
            }
            return 0xFF & this.buffer[this.next_read++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void headerLoaded(int n, int n2) {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            if (n == 0) {
                n = -1;
            }
            this.content_len = n;
            this.protocol_response = n2;
            this.header_loaded = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getContentLength() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            while (!this.header_loaded) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.content_len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEOF() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            this.eof_state = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalStream() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addInput(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            try {
                if (this.eof_state) {
                    this.notifyAll();
                    return -1;
                }
                if (byArray.length > 0 && this.available < 32768) {
                    int n3 = 32768 - this.available;
                    if (this.last_avail < Short.MAX_VALUE) {
                        n = byArray.length < 32768 - this.last_avail ? byArray.length : 32768 - this.last_avail - 1;
                        if (n > n3) {
                            n = n3;
                        }
                        System.arraycopy(byArray, 0, this.buffer, this.last_avail + 1, n);
                    }
                    if ((n3 -= n) > 0) {
                        n2 = byArray.length - n > n3 ? n3 : byArray.length - n;
                        System.arraycopy(byArray, n, this.buffer, 0, n2);
                    }
                    this.last_avail = (this.last_avail + n + n2) % 32768;
                }
                this.notifyAll();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace(System.err);
            }
            this.available += n + n2;
            this.total_input += n + n2;
            return n + n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int addStream(OperaInputStream operaInputStream) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            stream_map.put(new Integer(next_stream_id), operaInputStream);
            operaInputStream.stream_id = next_stream_id++;
        }
        return operaInputStream.stream_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeStream(int n) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            stream_map.remove(new Integer(n));
        }
        OperaOutputStream.removeStream(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OperaInputStream getStream(int n) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            return (OperaInputStream)stream_map.get(new Integer(n));
        }
    }

    private native void starving();

    private void addHeader(String string, String string2) {
        this.header_fields.put(string.toLowerCase(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void signalStreams() {
        Enumeration enumeration = stream_map.elements();
        while (enumeration.hasMoreElements()) {
            Object v;
            Object v2 = v = enumeration.nextElement();
            synchronized (v2) {
                v.notifyAll();
            }
        }
    }

    protected boolean isHeaderLoaded() {
        return this.header_loaded;
    }

    private int writeReady() {
        return 32768 - this.available;
    }
}

