/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.OperaInputStream;
import com.opera.OperaOutputStream;
import com.opera.PluginContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;

public class OperaURLConnection
extends HttpURLConnection {
    private OperaInputStream is = new OperaInputStream();
    private int istream_id;
    private OperaOutputStream os = new OperaOutputStream();
    private int ostream_id;

    protected OperaURLConnection(URL uRL) {
        super(uRL);
        this.istream_id = OperaInputStream.addStream(this.is);
        this.ostream_id = OperaOutputStream.addStream(this.os);
        this.os.istream_id = this.istream_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        block21: {
            SecurityManager securityManager;
            Object object;
            int n;
            if (this.connected) break block21;
            String string = this.url.toString();
            if (this.url.getPort() == -1 && (n = string.indexOf(":-1")) != -1) {
                object = new StringBuffer(string);
                ((StringBuffer)object).delete(n, n + 3);
                string = ((StringBuffer)object).toString();
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkConnect(this.url.getHost(), this.url.getPort());
            }
            try {
                if (this.method.compareTo("POST") == 0) {
                    object = PluginContext.opera_mutex;
                    synchronized (object) {
                        this.nativeConnect(string, this.method, this.ostream_id);
                        this.ostream_id = -1;
                        this.istream_id = -1;
                    }
                    this.connected = true;
                    break block21;
                }
                if (this.method.compareTo("GET") == 0) {
                    object = PluginContext.opera_mutex;
                    synchronized (object) {
                        this.nativeConnect(string, this.method, this.istream_id);
                        this.ostream_id = -1;
                        this.istream_id = -1;
                    }
                    try {
                        OperaInputStream operaInputStream = this.is;
                        synchronized (operaInputStream) {
                            if (!this.is.isHeaderLoaded()) {
                                this.is.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.responseCode = this.is.getResponse();
                    this.connected = this.responseCode < 400;
                    break block21;
                }
                object = this.is;
                synchronized (object) {
                    this.is.headerLoaded(0, 200);
                    this.is.setEOF();
                }
                this.connected = true;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private native void nativeConnect(String var1, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.method.compareTo("POST") == 0) {
            if (!this.os.isClosed()) {
                this.os.close();
            }
            if (this.is.getResponse() == -1) {
                try {
                    OperaInputStream operaInputStream = this.is;
                    synchronized (operaInputStream) {
                        this.is.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.is.getResponse() >= 400) {
                this.connected = false;
                throw new FileNotFoundException(this.url.toString());
            }
            this.connected = true;
        } else if (this.is.getResponse() >= 400) {
            this.connected = false;
            throw new FileNotFoundException(this.url.toString());
        }
        return this.is;
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.is != null) {
            return this.is.getContentLength();
        }
        return 0;
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public OutputStream getOutputStream() throws IOException {
        this.method = "POST";
        if (!this.connected) {
            this.connect();
        }
        return this.os;
    }

    public int getHeaderFieldInt(String string, int n) {
        String string2 = this.getHeaderField(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n;
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.waitForHeaderLoaded();
        Enumeration enumeration = this.is.header_fields.elements();
        while (n > 0 && enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (n == 1) {
                return (String)v;
            }
            --n;
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.waitForHeaderLoaded();
        Enumeration enumeration = this.is.header_fields.keys();
        while (n > 0 && enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (n == 1) {
                return (String)k;
            }
            --n;
        }
        return null;
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.waitForHeaderLoaded();
        return (String)this.is.header_fields.get(string.toLowerCase());
    }

    public String getRequestProperty(String string) {
        return (String)this.os.req_props.get(string);
    }

    public void setRequestProperty(String string, String string2) {
        if (string.compareToIgnoreCase("Content-length") != 0) {
            this.os.req_props.put(string, string2);
        }
    }

    public void disconnect() {
    }

    public boolean usingProxy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            OperaInputStream operaInputStream = this.is;
            synchronized (operaInputStream) {
                if (!this.is.isHeaderLoaded()) {
                    this.is.wait();
                    this.responseCode = this.is.getResponse();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.responseCode;
    }

    protected void finalize() throws Throwable {
        if (this.istream_id != -1) {
            OperaInputStream.removeStream(this.istream_id);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForHeaderLoaded() {
        try {
            OperaInputStream operaInputStream = this.is;
            synchronized (operaInputStream) {
                if (!this.is.isHeaderLoaded()) {
                    this.is.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

