/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletClassLoader;
import com.opera.AppletContextManager;
import com.opera.AppletManager;
import com.opera.AppletPanel;
import com.opera.CPointer;
import com.opera.JSObject;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AppletContext
implements java.applet.AppletContext {
    private HashSet panels = new HashSet();
    private static boolean useAudioCache;
    private Hashtable audioCache = new Hashtable();
    private static boolean useImageCache;
    private Hashtable imageCache = new Hashtable();
    private AppletClassLoader lcClassLoader = null;
    private CPointer documentPtr;
    private int refMac = 0;

    protected static void setCachePolicy(boolean bl, boolean bl2) {
        useImageCache = bl;
        useAudioCache = bl2;
    }

    AppletClassLoader getLCClassLoader(URL uRL) {
        try {
            if (this.lcClassLoader == null) {
                this.lcClassLoader = AppletPanel.getClassLoader(uRL, uRL, null);
                this.lcClassLoader.grab();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return this.lcClassLoader;
    }

    CPointer getDocumentPtr() {
        return this.documentPtr;
    }

    void documentDeleted() {
        this.documentPtr = null;
        if (this.lcClassLoader != null) {
            this.lcClassLoader.release();
            this.lcClassLoader = null;
        }
    }

    protected AppletContext(CPointer cPointer) {
        this.documentPtr = cPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPanel(AppletPanel appletPanel) {
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            this.panels.add(appletPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePanel(AppletPanel appletPanel) {
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            if (appletPanel != null) {
                this.panels.remove(appletPanel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean usesLoader(AppletClassLoader appletClassLoader) {
        if (this.lcClassLoader == appletClassLoader) {
            return true;
        }
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            Iterator iterator = this.panels.iterator();
            while (iterator.hasNext()) {
                AppletPanel appletPanel = (AppletPanel)iterator.next();
                if (!appletPanel.usesLoader(appletClassLoader)) continue;
                return true;
            }
            return false;
        }
    }

    private static void checkConnect(URL uRL) {
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) break block3;
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                    break block3;
                }
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    protected void setLoadingFinished(CPointer cPointer) {
        if (this.documentPtr != null && cPointer != null) {
            this.nativeSetLoadingFinished(this.documentPtr, cPointer);
        }
    }

    private native void nativeSetLoadingFinished(CPointer var1, CPointer var2);

    JSObject getJSWindow() {
        return this.getJSWindow(this.documentPtr);
    }

    private native JSObject getJSWindow(CPointer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applet getApplet(String string) {
        string = string.toLowerCase();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            Iterator iterator = this.panels.iterator();
            while (iterator.hasNext()) {
                AppletPanel appletPanel = (AppletPanel)iterator.next();
                String string2 = appletPanel.getParameter("name");
                if (string2 == null || !string.equals(string2 = string2.toLowerCase())) continue;
                return appletPanel.getApplet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getApplets() {
        Vector<Applet> vector = new Vector<Applet>();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            Iterator iterator = this.panels.iterator();
            while (iterator.hasNext()) {
                vector.addElement(((AppletPanel)iterator.next()).getApplet());
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getAudioClip(final URL uRL) {
        AppletContext.checkConnect(uRL);
        Hashtable hashtable = this.audioCache;
        synchronized (hashtable) {
            SoftReference softReference;
            AudioClip audioClip = null;
            if (useAudioCache && (softReference = (SoftReference)this.audioCache.get(uRL)) != null) {
                audioClip = (AudioClip)softReference.get();
            }
            if (audioClip == null) {
                audioClip = (AudioClip)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = Class.forName(AppletManager.getInstance().getAudioClipClassName());
                            Class[] classArray = new Class[]{Class.forName("java.net.URL")};
                            Object[] objectArray = new Object[]{uRL};
                            Constructor<?> constructor = clazz.getConstructor(classArray);
                            AudioClip audioClip = (AudioClip)constructor.newInstance(objectArray);
                            if (useAudioCache && audioClip != null) {
                                AppletContext.this.audioCache.put(uRL, new SoftReference<AudioClip>(audioClip));
                            }
                            return audioClip;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                            return null;
                        }
                    }
                });
            }
            return audioClip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL uRL) {
        AppletClassLoader appletClassLoader = (AppletClassLoader)Thread.currentThread().getContextClassLoader();
        AppletContext.checkConnect(uRL);
        Hashtable hashtable = this.imageCache;
        synchronized (hashtable) {
            Object object;
            Image image = null;
            if (useImageCache && (object = (SoftReference)this.imageCache.get(uRL)) != null) {
                image = (Image)((SoftReference)object).get();
            }
            if (image == null) {
                try {
                    String string;
                    InputStream inputStream;
                    String string2 = appletClassLoader.getCodeBase().toString();
                    String string3 = uRL.toString();
                    int n = string3.indexOf(string2);
                    if (n == 0 && (inputStream = appletClassLoader.getResourceAsStream(string = string3.charAt(string2.length()) == '/' ? string3.substring(string2.length() + 1) : string3.substring(string2.length()))) != null) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[8192];
                        int n2 = 0;
                        while ((n2 = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n2);
                        }
                        bufferedInputStream.close();
                        object = byteArrayOutputStream.toByteArray();
                        if (object != null && ((Object)object).length > 0) {
                            image = Toolkit.getDefaultToolkit().createImage((byte[])object);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                if (image == null) {
                    image = Toolkit.getDefaultToolkit().createImage(uRL);
                }
                if (useImageCache && image != null) {
                    this.imageCache.put(uRL, new SoftReference<Image>(image));
                }
            }
            return image;
        }
    }

    public void showDocument(URL uRL) {
        this.showDocument(uRL, "_top");
    }

    public void showDocument(URL uRL, String string) {
        String string2 = uRL.toString();
        this.showDocument(this.documentPtr, string2, string);
    }

    private native void showDocument(CPointer var1, String var2, String var3);

    public void showStatus(String string) {
        if (this.documentPtr != null) {
            this.showStatus(this.documentPtr, string);
        }
    }

    private native void showStatus(CPointer var1, String var2);

    public void setStream(String string, InputStream inputStream) throws IOException {
    }

    public InputStream getStream(String string) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    void incRefMac() {
        ++this.refMac;
    }

    void decRefMac() {
        if (--this.refMac == 0) {
            AppletContextManager.deleteContext(this);
        }
    }
}

