/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletPanel;
import com.opera.ConsoleOStream;
import java.awt.Button;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintStream;

class JavaConsole
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private TextArea outputArea = new TextArea();
    private Button but;

    JavaConsole(String string) {
        super(string);
        this.add(this.outputArea);
        this.but = new Button("Clear");
        this.but.addActionListener(this);
        this.add("South", this.but);
        this.pack();
        this.outputArea.setVisible(true);
        this.outputArea.setEditable(false);
        this.setSize(300, 250);
        PrintStream printStream = new PrintStream(new ConsoleOStream(this.outputArea));
        System.setOut(printStream);
        System.setErr(printStream);
        this.addWindowListener(this);
        this.outputArea.addKeyListener(this);
        this.but.addKeyListener(this);
        this.printInfo();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getModifiers() != 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 67: {
                this.outputArea.setText(null);
                this.printInfo();
                break;
            }
            case 70: {
                System.out.print("Running finalization ... ");
                System.runFinalization();
                System.out.println("Done.");
                break;
            }
            case 71: {
                System.out.print("Running garbage collection ... ");
                System.gc();
                System.out.println("Done.");
                break;
            }
            case 72: {
                this.printHelp();
                break;
            }
            case 76: {
                AppletPanel.printClassLoaders();
                break;
            }
            case 77: {
                long l = Runtime.getRuntime().freeMemory() / 1024L;
                long l2 = Runtime.getRuntime().totalMemory() / 1024L;
                System.out.println("Total memory: " + l2 + "K  Free memory: " + l + "K");
                break;
            }
            case 84: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Dump thread list ...\n");
                Thread thread = Thread.currentThread();
                ThreadGroup threadGroup = thread.getThreadGroup();
                this.dumpThreadGroup(threadGroup, stringBuffer);
                stringBuffer.append("Done.");
                System.out.println(stringBuffer.toString());
                break;
            }
            case 88: {
                System.out.print("Clearing classloader cache ... ");
                AppletPanel.clearClassLoaderCache();
                System.out.println("Done.");
                break;
            }
        }
    }

    private void printInfo() {
        System.out.println("-- " + System.getProperty("browser.opera.consoleString") + " --\n");
        System.out.println("Java vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("\ntype 'h' for help\n\n--");
    }

    private void printHelp() {
        System.out.println("\nCommands:\n----------------------------------------");
        System.out.println("c - clear console");
        System.out.println("f - run finalization");
        System.out.println("g - run garbage collection");
        System.out.println("h - help");
        System.out.println("l - list cached classloaders");
        System.out.println("m - memory usage");
        System.out.println("t - dump threads");
        System.out.println("x - clear classloader cache\n");
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.but) {
            this.outputArea.setText(null);
            this.printInfo();
        }
    }

    private void dumpThreadGroup(ThreadGroup threadGroup, StringBuffer stringBuffer) {
        if (threadGroup != null) {
            try {
                if (threadGroup.activeCount() == 0 && threadGroup.activeGroupCount() == 0 && !threadGroup.isDestroyed()) {
                    threadGroup.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stringBuffer.append("Group " + threadGroup.getName());
            stringBuffer.append(",ac=" + threadGroup.activeCount());
            stringBuffer.append(",agc=" + threadGroup.activeGroupCount());
            stringBuffer.append(",pri=" + threadGroup.getMaxPriority());
            if (threadGroup.isDestroyed()) {
                stringBuffer.append(",destoyed");
            }
            if (threadGroup.isDaemon()) {
                stringBuffer.append(",daemon");
            }
            stringBuffer.append("\n");
            Thread[] threadArray = new Thread[1000];
            threadGroup.enumerate(threadArray, false);
            int n = 0;
            while (n < threadArray.length) {
                if (threadArray[n] != null) {
                    stringBuffer.append("    ");
                    stringBuffer.append(threadArray[n].getName());
                    stringBuffer.append(",");
                    stringBuffer.append(threadArray[n].getPriority());
                    if (threadArray[n].isAlive()) {
                        stringBuffer.append(",alive");
                    } else {
                        stringBuffer.append(",not alive");
                    }
                    if (threadArray[n].isDaemon()) {
                        stringBuffer.append(",daemon");
                    }
                    if (threadArray[n].isInterrupted()) {
                        stringBuffer.append(",interrupted");
                    }
                    stringBuffer.append("\n");
                }
                ++n;
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
            threadGroup.enumerate(threadGroupArray, false);
            int n2 = 0;
            while (n2 < threadGroupArray.length) {
                if (threadGroupArray[n2] != null) {
                    this.dumpThreadGroup(threadGroupArray[n2], stringBuffer);
                }
                ++n2;
            }
        }
    }
}

