
/* autogenerated from test.orc */

#include <orc/orc.h>
#include <orc-test/orctest.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_AS_FLOAT(x) (((union { int i; float f; } *)(&x))->f)
typedef union { int32_t i; float f; } orc_union32;
typedef union { int64_t i; double f; } orc_union64;
/* end Orc C target preamble */


/* orc_absb */
static void
_backup_orc_absb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absb */
    var0 = ORC_ABS(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addb */
static void
_backup_orc_addb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addb */
    var0 = var4 + var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addssb */
static void
_backup_orc_addssb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addssb */
    var0 = ORC_CLAMP_SB(var4 + var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addusb */
static void
_backup_orc_addusb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addusb */
    var0 = ORC_CLAMP_UB((uint8_t)var4 + (uint8_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_andb */
static void
_backup_orc_andb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: andb */
    var0 = var4 & var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_andnb */
static void
_backup_orc_andnb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: andnb */
    var0 = (~var4) & var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_avgsb */
static void
_backup_orc_avgsb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsb */
    var0 = (var4 + var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_avgub */
static void
_backup_orc_avgub (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpeqb */
static void
_backup_orc_cmpeqb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpeqb */
    var0 = (var4 == var5) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpgtsb */
static void
_backup_orc_cmpgtsb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpgtsb */
    var0 = (var4 > var5) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_copyb */
static void
_backup_orc_copyb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyb */
    var0 = var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxsb */
static void
_backup_orc_maxsb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxsb */
    var0 = ORC_MAX(var4, var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxub */
static void
_backup_orc_maxub (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxub */
    var0 = ORC_MAX((uint8_t)var4, (uint8_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minsb */
static void
_backup_orc_minsb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minsb */
    var0 = ORC_MIN(var4, var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minub */
static void
_backup_orc_minub (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minub */
    var0 = ORC_MIN((uint8_t)var4, (uint8_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mullb */
static void
_backup_orc_mullb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mullb */
    var0 = (var4 * var5) & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulhsb */
static void
_backup_orc_mulhsb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulhsb */
    var0 = (var4 * var5) >> 8;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulhub */
static void
_backup_orc_mulhub (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulhub */
    var0 = ((uint32_t)(uint8_t)var4 * (uint32_t)(uint8_t)var5) >> 8;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_orb */
static void
_backup_orc_orb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: orb */
    var0 = var4 | var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shlb */
static void
_backup_orc_shlb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  const int8_t var24 = ex->params[24];

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlb */
    var0 = var4 << var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shrsb */
static void
_backup_orc_shrsb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  const int8_t var24 = ex->params[24];

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shrsb */
    var0 = var4 >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shrub */
static void
_backup_orc_shrub (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  const int8_t var24 = ex->params[24];

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shrub */
    var0 = ((uint8_t)var4) >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_signb */
static void
_backup_orc_signb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: signb */
    var0 = ORC_CLAMP(var4,-1,1);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subb */
static void
_backup_orc_subb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subb */
    var0 = var4 - var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subssb */
static void
_backup_orc_subssb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subssb */
    var0 = ORC_CLAMP_SB(var4 - var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subusb */
static void
_backup_orc_subusb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subusb */
    var0 = ORC_CLAMP_UB((uint8_t)var4 - (uint8_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_xorb */
static void
_backup_orc_xorb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: xorb */
    var0 = var4 ^ var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_absw */
static void
_backup_orc_absw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var0 = ORC_ABS(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addw */
static void
_backup_orc_addw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var0 = var4 + var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addssw */
static void
_backup_orc_addssw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addssw */
    var0 = ORC_CLAMP_SW(var4 + var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addusw */
static void
_backup_orc_addusw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addusw */
    var0 = ORC_CLAMP_UW((uint16_t)var4 + (uint16_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_andw */
static void
_backup_orc_andw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: andw */
    var0 = var4 & var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_andnw */
static void
_backup_orc_andnw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: andnw */
    var0 = (~var4) & var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_avgsw */
static void
_backup_orc_avgsw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var0 = (var4 + var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_avguw */
static void
_backup_orc_avguw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avguw */
    var0 = ((uint16_t)var4 + (uint16_t)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpeqw */
static void
_backup_orc_cmpeqw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpeqw */
    var0 = (var4 == var5) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpgtsw */
static void
_backup_orc_cmpgtsw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpgtsw */
    var0 = (var4 > var5) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_copyw */
static void
_backup_orc_copyw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var0 = var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxsw */
static void
_backup_orc_maxsw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxsw */
    var0 = ORC_MAX(var4, var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxuw */
static void
_backup_orc_maxuw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxuw */
    var0 = ORC_MAX((uint16_t)var4, (uint16_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minsw */
static void
_backup_orc_minsw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minsw */
    var0 = ORC_MIN(var4, var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minuw */
static void
_backup_orc_minuw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minuw */
    var0 = ORC_MIN((uint16_t)var4, (uint16_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mullw */
static void
_backup_orc_mullw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mullw */
    var0 = (var4 * var5) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulhsw */
static void
_backup_orc_mulhsw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulhsw */
    var0 = (var4 * var5) >> 16;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulhuw */
static void
_backup_orc_mulhuw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulhuw */
    var0 = ((uint32_t)((uint16_t)var4) * (uint32_t)((uint16_t)var5)) >> 16;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_orw */
static void
_backup_orc_orw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: orw */
    var0 = var4 | var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shlw */
static void
_backup_orc_shlw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var24 = ex->params[24];

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shrsw */
static void
_backup_orc_shrsw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var24 = ex->params[24];

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shrsw */
    var0 = var4 >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shruw */
static void
_backup_orc_shruw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var24 = ex->params[24];

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shruw */
    var0 = ((uint16_t)var4) >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_signw */
static void
_backup_orc_signw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: signw */
    var0 = ORC_CLAMP(var4,-1,1);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subw */
static void
_backup_orc_subw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var4 - var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subssw */
static void
_backup_orc_subssw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subssw */
    var0 = ORC_CLAMP_SW(var4 - var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subusw */
static void
_backup_orc_subusw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subusw */
    var0 = ORC_CLAMP_UW((uint16_t)var4 - (uint16_t)var5);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_xorw */
static void
_backup_orc_xorw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: xorw */
    var0 = var4 ^ var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_absl */
static void
_backup_orc_absl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absl */
    var0.i = ORC_ABS(var4.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addl */
static void
_backup_orc_addl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addl */
    var0.i = var4.i + var5.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addssl */
static void
_backup_orc_addssl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addssl */
    var0.i = ORC_CLAMP_SL((int64_t)var4.i + (int64_t)var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addusl */
static void
_backup_orc_addusl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addusl */
    var0.i = ORC_CLAMP_UL((int64_t)(uint32_t)var4.i + (int64_t)(uint32_t)var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_andl */
static void
_backup_orc_andl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: andl */
    var0.i = var4.i & var5.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_andnl */
static void
_backup_orc_andnl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: andnl */
    var0.i = (~var4.i) & var5.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_avgsl */
static void
_backup_orc_avgsl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsl */
    var0.i = ((int64_t)var4.i + (int64_t)var5.i + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_avgul */
static void
_backup_orc_avgul (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgul */
    var0.i = ((uint64_t)(uint32_t)var4.i + (uint64_t)(uint32_t)var5.i + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpeql */
static void
_backup_orc_cmpeql (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpeql */
    var0.i = (var4.i == var5.i) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpgtsl */
static void
_backup_orc_cmpgtsl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpgtsl */
    var0.i = (var4.i > var5.i) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_copyl */
static void
_backup_orc_copyl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var0.i = var4.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxsl */
static void
_backup_orc_maxsl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxsl */
    var0.i = ORC_MAX(var4.i, var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxul */
static void
_backup_orc_maxul (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxul */
    var0.i = ORC_MAX((uint32_t)var4.i, (uint32_t)var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minsl */
static void
_backup_orc_minsl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minsl */
    var0.i = ORC_MIN(var4.i, var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minul */
static void
_backup_orc_minul (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minul */
    var0.i = ORC_MIN((uint32_t)var4.i, (uint32_t)var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulll */
static void
_backup_orc_mulll (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulll */
    var0.i = (var4.i * var5.i) & 0xffffffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulhsl */
static void
_backup_orc_mulhsl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulhsl */
    var0.i = ((int64_t)var4.i * (int64_t)var5.i) >> 32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulhul */
static void
_backup_orc_mulhul (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulhul */
    var0.i = ((uint64_t)var4.i * (uint64_t)var5.i) >> 32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_orl */
static void
_backup_orc_orl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: orl */
    var0.i = var4.i | var5.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shll */
static void
_backup_orc_shll (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  const orc_union32 var24 = *(orc_union32 *)(ex->params + 24);

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shll */
    var0.i = var4.i << var24.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shrsl */
static void
_backup_orc_shrsl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  const orc_union32 var24 = *(orc_union32 *)(ex->params + 24);

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shrsl */
    var0.i = var4.i >> var24.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_shrul */
static void
_backup_orc_shrul (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  const orc_union32 var24 = *(orc_union32 *)(ex->params + 24);

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shrul */
    var0.i = ((uint32_t)var4.i) >> var24.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_signl */
static void
_backup_orc_signl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: signl */
    var0.i = ORC_CLAMP(var4.i,-1,1);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subl */
static void
_backup_orc_subl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subl */
    var0.i = var4.i - var5.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subssl */
static void
_backup_orc_subssl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subssl */
    var0.i = ORC_CLAMP_SL((int64_t)var4.i - (int64_t)var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subusl */
static void
_backup_orc_subusl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subusl */
    var0.i = ORC_CLAMP_UL((int64_t)(uint32_t)var4.i - (int64_t)(uint32_t)var5.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_xorl */
static void
_backup_orc_xorl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: xorl */
    var0.i = var4.i ^ var5.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convsbw */
static void
_backup_orc_convsbw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convsbw */
    var0 = var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convubw */
static void
_backup_orc_convubw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var0 = (uint8_t)var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convswl */
static void
_backup_orc_convswl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convswl */
    var0.i = var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convuwl */
static void
_backup_orc_convuwl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convuwl */
    var0.i = (uint16_t)var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convwb */
static void
_backup_orc_convwb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convwb */
    var0 = var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convssswb */
static void
_backup_orc_convssswb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convssswb */
    var0 = ORC_CLAMP_SB(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convsuswb */
static void
_backup_orc_convsuswb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convsuswb */
    var0 = ORC_CLAMP_UB(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convusswb */
static void
_backup_orc_convusswb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convusswb */
    var0 = ORC_CLAMP_SB((uint16_t)var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convuuswb */
static void
_backup_orc_convuuswb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convuuswb */
    var0 = ORC_CLAMP_UB((uint16_t)var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convlw */
static void
_backup_orc_convlw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convlw */
    var0 = var4.i;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convssslw */
static void
_backup_orc_convssslw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convssslw */
    var0 = ORC_CLAMP_SW(var4.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convsuslw */
static void
_backup_orc_convsuslw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convsuslw */
    var0 = ORC_CLAMP_UW(var4.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convusslw */
static void
_backup_orc_convusslw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convusslw */
    var0 = ORC_CLAMP_SW((uint32_t)var4.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convuuslw */
static void
_backup_orc_convuuslw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convuuslw */
    var0 = ORC_CLAMP_UW((uint32_t)var4.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulsbw */
static void
_backup_orc_mulsbw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulsbw */
    var0 = var4 * var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulubw */
static void
_backup_orc_mulubw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulubw */
    var0 = (uint8_t)var4 * (uint8_t)var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulswl */
static void
_backup_orc_mulswl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulswl */
    var0.i = var4 * var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_muluwl */
static void
_backup_orc_muluwl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: muluwl */
    var0.i = (uint16_t)var4 * (uint16_t)var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_accw */
static void
_backup_orc_accw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var12 = 0;

  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: accw */
    var12 = var12 + var4;
  }
  ex->accumulators[0] = (var12 & 0xffff);

}

/* orc_accl */
static void
_backup_orc_accl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var12 =  { 0 };

  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: accl */
    var12.i = var12.i + var4.i;
  }
  ex->accumulators[0] = var12.i;

}

/* orc_accsadubl */
static void
_backup_orc_accsadubl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  orc_union32 var12 =  { 0 };

  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: accsadubl */
    var12.i = var12.i + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
  }
  ex->accumulators[0] = var12.i;

}

/* orc_swapw */
static void
_backup_orc_swapw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: swapw */
    var0 = ORC_SWAP_W(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_swapl */
static void
_backup_orc_swapl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: swapl */
    var0.i = ORC_SWAP_L(var4.i);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_select0wb */
static void
_backup_orc_select0wb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0wb */
    var0 = (uint16_t)var4 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_select1wb */
static void
_backup_orc_select1wb (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = (int8_t *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1wb */
    var0 = ((uint16_t)var4 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_select0lw */
static void
_backup_orc_select0lw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var0 = (uint32_t)var4.i & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_select1lw */
static void
_backup_orc_select1lw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var0 = ((uint32_t)var4.i >> 16)&0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mergewl */
static void
_backup_orc_mergewl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (int16_t *)ex->arrays[4];
  ptr5 = (int16_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mergewl */
    var0.i = ((uint16_t)var4) | ((uint16_t)var5 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mergebw */
static void
_backup_orc_mergebw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = (int16_t *)ex->arrays[0];
  ptr4 = (int8_t *)ex->arrays[4];
  ptr5 = (int8_t *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mergebw */
    var0 = ((uint8_t)var4) | ((uint8_t)var5 << 8);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addf */
static void
_backup_orc_addf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addf */
    var0.f = var4.f + var5.f;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subf */
static void
_backup_orc_subf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subf */
    var0.f = var4.f - var5.f;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mulf */
static void
_backup_orc_mulf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mulf */
    var0.f = var4.f * var5.f;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_divf */
static void
_backup_orc_divf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: divf */
    var0.f = var4.f / var5.f;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_sqrtf */
static void
_backup_orc_sqrtf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: sqrtf */
    var0.f = sqrt(var4.f);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_maxf */
static void
_backup_orc_maxf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: maxf */
    var0.f = ORC_MAX(var4.f,var5.f);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_minf */
static void
_backup_orc_minf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: minf */
    var0.f = ORC_MIN(var4.f,var5.f);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpeqf */
static void
_backup_orc_cmpeqf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpeqf */
    var0.i = (var4.f == var5.f) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmpltf */
static void
_backup_orc_cmpltf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmpltf */
    var0.i = (var4.f < var5.f) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_cmplef */
static void
_backup_orc_cmplef (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_union32 var5;
  const orc_union32 * ptr5;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: cmplef */
    var0.i = (var4.f <= var5.f) ? (~0) : 0;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convfl */
static void
_backup_orc_convfl (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convfl */
    var0.i = (int)var4.f;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convlf */
static void
_backup_orc_convlf (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convlf */
    var0.f = var4.i;
    *ptr0 = var0;
    ptr0++;
  }

}


int
main (int argc, char *argv[])
{
  int error = FALSE;

  orc_test_init ();

  /* orc_absb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_absb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_absb");
    orc_program_set_backup_function (p, _backup_orc_absb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");

    orc_program_append (p, "absb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addb");
    orc_program_set_backup_function (p, _backup_orc_addb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "addb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addssb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addssb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addssb");
    orc_program_set_backup_function (p, _backup_orc_addssb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "addssb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addusb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addusb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addusb");
    orc_program_set_backup_function (p, _backup_orc_addusb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "addusb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_andb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_andb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_andb");
    orc_program_set_backup_function (p, _backup_orc_andb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "andb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_andnb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_andnb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_andnb");
    orc_program_set_backup_function (p, _backup_orc_andnb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "andnb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_avgsb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avgsb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_avgsb");
    orc_program_set_backup_function (p, _backup_orc_avgsb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgsb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_avgub */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avgub:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_avgub");
    orc_program_set_backup_function (p, _backup_orc_avgub);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpeqb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpeqb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpeqb");
    orc_program_set_backup_function (p, _backup_orc_cmpeqb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "cmpeqb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpgtsb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpgtsb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpgtsb");
    orc_program_set_backup_function (p, _backup_orc_cmpgtsb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "cmpgtsb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_copyb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_copyb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_copyb");
    orc_program_set_backup_function (p, _backup_orc_copyb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");

    orc_program_append (p, "copyb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxsb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxsb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxsb");
    orc_program_set_backup_function (p, _backup_orc_maxsb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "maxsb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxub */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxub:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxub");
    orc_program_set_backup_function (p, _backup_orc_maxub);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "maxub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minsb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minsb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minsb");
    orc_program_set_backup_function (p, _backup_orc_minsb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "minsb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minub */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minub:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minub");
    orc_program_set_backup_function (p, _backup_orc_minub);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "minub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mullb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mullb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mullb");
    orc_program_set_backup_function (p, _backup_orc_mullb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "mullb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulhsb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulhsb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulhsb");
    orc_program_set_backup_function (p, _backup_orc_mulhsb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "mulhsb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulhub */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulhub:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulhub");
    orc_program_set_backup_function (p, _backup_orc_mulhub);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "mulhub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_orb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_orb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_orb");
    orc_program_set_backup_function (p, _backup_orc_orb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "orb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shlb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shlb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shlb");
    orc_program_set_backup_function (p, _backup_orc_shlb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_parameter (p, 1, "p1");

    orc_program_append (p, "shlb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shrsb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shrsb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shrsb");
    orc_program_set_backup_function (p, _backup_orc_shrsb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_parameter (p, 1, "p1");

    orc_program_append (p, "shrsb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shrub */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shrub:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shrub");
    orc_program_set_backup_function (p, _backup_orc_shrub);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_parameter (p, 1, "p1");

    orc_program_append (p, "shrub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_signb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_signb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_signb");
    orc_program_set_backup_function (p, _backup_orc_signb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");

    orc_program_append (p, "signb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subb");
    orc_program_set_backup_function (p, _backup_orc_subb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "subb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subssb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subssb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subssb");
    orc_program_set_backup_function (p, _backup_orc_subssb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "subssb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subusb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subusb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subusb");
    orc_program_set_backup_function (p, _backup_orc_subusb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "subusb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_xorb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_xorb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_xorb");
    orc_program_set_backup_function (p, _backup_orc_xorb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "xorb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_absw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_absw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_absw");
    orc_program_set_backup_function (p, _backup_orc_absw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "absw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addw");
    orc_program_set_backup_function (p, _backup_orc_addw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addssw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addssw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addssw");
    orc_program_set_backup_function (p, _backup_orc_addssw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "addssw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addusw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addusw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addusw");
    orc_program_set_backup_function (p, _backup_orc_addusw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "addusw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_andw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_andw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_andw");
    orc_program_set_backup_function (p, _backup_orc_andw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "andw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_andnw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_andnw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_andnw");
    orc_program_set_backup_function (p, _backup_orc_andnw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "andnw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_avgsw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avgsw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_avgsw");
    orc_program_set_backup_function (p, _backup_orc_avgsw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "avgsw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_avguw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avguw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_avguw");
    orc_program_set_backup_function (p, _backup_orc_avguw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "avguw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpeqw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpeqw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpeqw");
    orc_program_set_backup_function (p, _backup_orc_cmpeqw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "cmpeqw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpgtsw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpgtsw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpgtsw");
    orc_program_set_backup_function (p, _backup_orc_cmpgtsw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "cmpgtsw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_copyw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_copyw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_copyw");
    orc_program_set_backup_function (p, _backup_orc_copyw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxsw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxsw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxsw");
    orc_program_set_backup_function (p, _backup_orc_maxsw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "maxsw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxuw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxuw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxuw");
    orc_program_set_backup_function (p, _backup_orc_maxuw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "maxuw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minsw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minsw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minsw");
    orc_program_set_backup_function (p, _backup_orc_minsw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "minsw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minuw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minuw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minuw");
    orc_program_set_backup_function (p, _backup_orc_minuw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "minuw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mullw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mullw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mullw");
    orc_program_set_backup_function (p, _backup_orc_mullw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulhsw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulhsw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulhsw");
    orc_program_set_backup_function (p, _backup_orc_mulhsw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "mulhsw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulhuw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulhuw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulhuw");
    orc_program_set_backup_function (p, _backup_orc_mulhuw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "mulhuw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_orw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_orw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_orw");
    orc_program_set_backup_function (p, _backup_orc_orw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "orw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shlw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shlw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shlw");
    orc_program_set_backup_function (p, _backup_orc_shlw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shrsw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shrsw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shrsw");
    orc_program_set_backup_function (p, _backup_orc_shrsw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shruw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shruw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shruw");
    orc_program_set_backup_function (p, _backup_orc_shruw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "shruw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_signw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_signw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_signw");
    orc_program_set_backup_function (p, _backup_orc_signw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "signw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subw");
    orc_program_set_backup_function (p, _backup_orc_subw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subssw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subssw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subssw");
    orc_program_set_backup_function (p, _backup_orc_subssw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "subssw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subusw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subusw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subusw");
    orc_program_set_backup_function (p, _backup_orc_subusw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "subusw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_xorw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_xorw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_xorw");
    orc_program_set_backup_function (p, _backup_orc_xorw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "xorw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_absl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_absl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_absl");
    orc_program_set_backup_function (p, _backup_orc_absl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "absl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addl");
    orc_program_set_backup_function (p, _backup_orc_addl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "addl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addssl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addssl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addssl");
    orc_program_set_backup_function (p, _backup_orc_addssl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "addssl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addusl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addusl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addusl");
    orc_program_set_backup_function (p, _backup_orc_addusl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "addusl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_andl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_andl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_andl");
    orc_program_set_backup_function (p, _backup_orc_andl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "andl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_andnl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_andnl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_andnl");
    orc_program_set_backup_function (p, _backup_orc_andnl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "andnl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_avgsl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avgsl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_avgsl");
    orc_program_set_backup_function (p, _backup_orc_avgsl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "avgsl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_avgul */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avgul:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_avgul");
    orc_program_set_backup_function (p, _backup_orc_avgul);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "avgul", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpeql */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpeql:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpeql");
    orc_program_set_backup_function (p, _backup_orc_cmpeql);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "cmpeql", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpgtsl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpgtsl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpgtsl");
    orc_program_set_backup_function (p, _backup_orc_cmpgtsl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "cmpgtsl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_copyl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_copyl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_copyl");
    orc_program_set_backup_function (p, _backup_orc_copyl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "copyl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxsl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxsl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxsl");
    orc_program_set_backup_function (p, _backup_orc_maxsl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "maxsl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxul */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxul:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxul");
    orc_program_set_backup_function (p, _backup_orc_maxul);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "maxul", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minsl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minsl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minsl");
    orc_program_set_backup_function (p, _backup_orc_minsl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "minsl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minul */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minul:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minul");
    orc_program_set_backup_function (p, _backup_orc_minul);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "minul", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulll */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulll:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulll");
    orc_program_set_backup_function (p, _backup_orc_mulll);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "mulll", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulhsl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulhsl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulhsl");
    orc_program_set_backup_function (p, _backup_orc_mulhsl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "mulhsl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulhul */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulhul:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulhul");
    orc_program_set_backup_function (p, _backup_orc_mulhul);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "mulhul", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_orl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_orl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_orl");
    orc_program_set_backup_function (p, _backup_orc_orl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "orl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shll */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shll:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shll");
    orc_program_set_backup_function (p, _backup_orc_shll);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_parameter (p, 4, "p1");

    orc_program_append (p, "shll", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shrsl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shrsl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shrsl");
    orc_program_set_backup_function (p, _backup_orc_shrsl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_parameter (p, 4, "p1");

    orc_program_append (p, "shrsl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_shrul */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_shrul:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_shrul");
    orc_program_set_backup_function (p, _backup_orc_shrul);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_parameter (p, 4, "p1");

    orc_program_append (p, "shrul", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_signl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_signl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_signl");
    orc_program_set_backup_function (p, _backup_orc_signl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "signl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subl");
    orc_program_set_backup_function (p, _backup_orc_subl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "subl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subssl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subssl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subssl");
    orc_program_set_backup_function (p, _backup_orc_subssl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "subssl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subusl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subusl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subusl");
    orc_program_set_backup_function (p, _backup_orc_subusl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "subusl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_xorl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_xorl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_xorl");
    orc_program_set_backup_function (p, _backup_orc_xorl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "xorl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convsbw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convsbw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convsbw");
    orc_program_set_backup_function (p, _backup_orc_convsbw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");

    orc_program_append (p, "convsbw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convubw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convubw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convubw");
    orc_program_set_backup_function (p, _backup_orc_convubw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");

    orc_program_append (p, "convubw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convswl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convswl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convswl");
    orc_program_set_backup_function (p, _backup_orc_convswl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convswl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convuwl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convuwl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convuwl");
    orc_program_set_backup_function (p, _backup_orc_convuwl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convuwl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convwb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convwb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convwb");
    orc_program_set_backup_function (p, _backup_orc_convwb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convwb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convssswb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convssswb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convssswb");
    orc_program_set_backup_function (p, _backup_orc_convssswb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convssswb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convsuswb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convsuswb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convsuswb");
    orc_program_set_backup_function (p, _backup_orc_convsuswb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convusswb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convusswb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convusswb");
    orc_program_set_backup_function (p, _backup_orc_convusswb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convusswb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convuuswb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convuuswb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convuuswb");
    orc_program_set_backup_function (p, _backup_orc_convuuswb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convuuswb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convlw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convlw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convlw");
    orc_program_set_backup_function (p, _backup_orc_convlw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convlw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convssslw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convssslw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convssslw");
    orc_program_set_backup_function (p, _backup_orc_convssslw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convssslw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convsuslw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convsuslw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convsuslw");
    orc_program_set_backup_function (p, _backup_orc_convsuslw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convsuslw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convusslw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convusslw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convusslw");
    orc_program_set_backup_function (p, _backup_orc_convusslw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convusslw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convuuslw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convuuslw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convuuslw");
    orc_program_set_backup_function (p, _backup_orc_convuuslw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convuuslw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulsbw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulsbw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulsbw");
    orc_program_set_backup_function (p, _backup_orc_mulsbw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "mulsbw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulubw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulubw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulubw");
    orc_program_set_backup_function (p, _backup_orc_mulubw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "mulubw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulswl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulswl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulswl");
    orc_program_set_backup_function (p, _backup_orc_mulswl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "mulswl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_muluwl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_muluwl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_muluwl");
    orc_program_set_backup_function (p, _backup_orc_muluwl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "muluwl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_accw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_accw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_accw");
    orc_program_set_backup_function (p, _backup_orc_accw);
    orc_program_add_source (p, 2, "s1");
    orc_program_add_accumulator (p, 2, "a1");

    orc_program_append (p, "accw", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_accl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_accl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_accl");
    orc_program_set_backup_function (p, _backup_orc_accl);
    orc_program_add_source (p, 4, "s1");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_accsadubl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_accsadubl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_accsadubl");
    orc_program_set_backup_function (p, _backup_orc_accsadubl);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_swapw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_swapw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_swapw");
    orc_program_set_backup_function (p, _backup_orc_swapw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "swapw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_swapl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_swapl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_swapl");
    orc_program_set_backup_function (p, _backup_orc_swapl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "swapl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_select0wb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_select0wb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_select0wb");
    orc_program_set_backup_function (p, _backup_orc_select0wb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_select1wb */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_select1wb:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_select1wb");
    orc_program_set_backup_function (p, _backup_orc_select1wb);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_select0lw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_select0lw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_select0lw");
    orc_program_set_backup_function (p, _backup_orc_select0lw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "select0lw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_select1lw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_select1lw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_select1lw");
    orc_program_set_backup_function (p, _backup_orc_select1lw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "select1lw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mergewl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mergewl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mergewl");
    orc_program_set_backup_function (p, _backup_orc_mergewl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mergebw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mergebw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mergebw");
    orc_program_set_backup_function (p, _backup_orc_mergebw);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "mergebw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_addf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addf");
    orc_program_set_backup_function (p, _backup_orc_addf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "addf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_subf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subf");
    orc_program_set_backup_function (p, _backup_orc_subf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "subf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_mulf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mulf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mulf");
    orc_program_set_backup_function (p, _backup_orc_mulf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "mulf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_divf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_divf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_divf");
    orc_program_set_backup_function (p, _backup_orc_divf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "divf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_sqrtf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sqrtf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_sqrtf");
    orc_program_set_backup_function (p, _backup_orc_sqrtf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "sqrtf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_maxf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_maxf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_maxf");
    orc_program_set_backup_function (p, _backup_orc_maxf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "maxf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_minf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_minf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_minf");
    orc_program_set_backup_function (p, _backup_orc_minf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "minf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpeqf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpeqf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpeqf");
    orc_program_set_backup_function (p, _backup_orc_cmpeqf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "cmpeqf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmpltf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmpltf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmpltf");
    orc_program_set_backup_function (p, _backup_orc_cmpltf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "cmpltf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_cmplef */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_cmplef:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_cmplef");
    orc_program_set_backup_function (p, _backup_orc_cmplef);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_source (p, 4, "s2");

    orc_program_append (p, "cmplef", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convfl */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convfl:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convfl");
    orc_program_set_backup_function (p, _backup_orc_convfl);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convfl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }

  /* orc_convlf */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convlf:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convlf");
    orc_program_set_backup_function (p, _backup_orc_convlf);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 4, "s1");

    orc_program_append (p, "convlf", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    printf ("  cycles (backup):   ");
    orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    printf ("  cycles (compiled): ");
    orc_test_performance (p, 0);

    orc_program_free (p);
  }


  if (error) {
    return 1;
  };
  return 0;
}
