/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.javagroups.Address;
import org.javagroups.BlockEvent;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.GetStateEvent;
import org.javagroups.Header;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.SetStateEvent;
import org.javagroups.SuspectEvent;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PullPushAdapter
implements Runnable {
    static final String PULL_HEADER = "PULL_HEADER";
    protected Transport transport;
    protected MessageListener listener;
    protected List membership_listeners;
    protected Thread receiver_thread;
    protected HashMap listeners;

    public Transport getTransport() {
        return this.transport;
    }

    public void start() {
        if (this.receiver_thread == null) {
            this.receiver_thread = new Thread((Runnable)this, "PullPushAdapterThread");
            this.receiver_thread.setDaemon(true);
            this.receiver_thread.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.receiver_thread != null && this.receiver_thread.isAlive()) {
            tmp = this.receiver_thread;
            this.receiver_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.receiver_thread = null;
    }

    public void send(Serializable identifier, Message msg) throws Exception {
        if (msg == null) {
            Trace.error("PullPushAdapter.send()", "msg is null");
            return;
        }
        if (identifier == null) {
            this.transport.send(msg);
        } else {
            msg.putHeader(PULL_HEADER, new PullHeader(identifier));
            this.transport.send(msg);
        }
    }

    public void send(Message msg) throws Exception {
        this.send(null, msg);
    }

    public void setListener(MessageListener l) {
        this.listener = l;
    }

    public void registerListener(Serializable identifier, MessageListener l) {
        if (l == null || identifier == null) {
            Trace.error("PullPushAdapter.registerListener()", "message listener or identifier is null");
            return;
        }
        if (this.listeners.containsKey(identifier)) {
            Trace.error("PullPushAdapter.registerListener()", "listener with identifier=" + identifier + " already exists, choose a different identifier");
        }
        this.listeners.put(identifier, l);
    }

    public void setMembershipListener(MembershipListener ml) {
        this.addMembershipListener(ml);
    }

    public void addMembershipListener(MembershipListener l) {
        if (l != null && !this.membership_listeners.contains(l)) {
            this.membership_listeners.add(l);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        while (this.receiver_thread != null) {
            obj = this.transport.receive(0L);
            if (obj == null) continue;
            if (obj instanceof Message) {
                this.handleMessage((Message)obj);
                continue;
            }
            if (!(obj instanceof GetStateEvent)) ** GOTO lbl17
            if (this.listener != null) {
                if (this.transport instanceof Channel) {
                    ((Channel)this.transport).returnState(this.listener.getState());
                } else {
                    Trace.error("PullPushAdapter.run()", "underlying transport is not a Channel, but a " + this.transport.getClass().getName() + ": cannot fetch state using returnState()");
                }
            }
            continue;
lbl17:
            // 1 sources

            if (!(obj instanceof SetStateEvent)) ** GOTO lbl27
            if (this.listener != null) {
                try {
                    this.listener.setState(((SetStateEvent)obj).getArg());
                }
                catch (ClassCastException cast_ex) {
                    Trace.error("PullPushAdapter.run()", "received SetStateEvent, but argument " + ((SetStateEvent)obj).getArg() + " is not serializable ! Discarding message.");
                    continue;
                }
            }
            try {
                continue;
lbl27:
                // 1 sources

                if (obj instanceof View) {
                    this.notifyViewChange((View)obj);
                    continue;
                }
                if (obj instanceof SuspectEvent) {
                    this.notifySuspect((Address)((SuspectEvent)obj).getMember());
                    continue;
                }
                if (!(obj instanceof BlockEvent)) continue;
                this.notifyBlock();
            }
            catch (ChannelNotConnectedException conn) {
                local_addr = ((Channel)this.transport).getLocalAddress();
                Trace.warn("PullPushAdapter.run()", "[" + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel not connected, exception is " + conn);
                Util.sleep(1000L);
                break;
            }
            catch (ChannelClosedException closed_ex) {
                local_addr = ((Channel)this.transport).getLocalAddress();
                Trace.warn("PullPushAdapter.run()", "[" + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel closed, exception is " + closed_ex);
                Util.sleep(1000L);
                break;
            }
            catch (Throwable var2_6) {
                // empty catch block
            }
        }
    }

    protected void handleMessage(Message msg) {
        Serializable identifier;
        PullHeader hdr = (PullHeader)msg.getHeader(PULL_HEADER);
        if (hdr != null && (identifier = hdr.getIdentifier()) != null) {
            MessageListener l = (MessageListener)this.listeners.get(identifier);
            if (l == null) {
                Trace.error("PullPushAdapter.handleMessage()", "received a messages tagged with identifier=" + identifier + ", but there is no registration for that identifier. Will drop message");
            } else {
                l.receive(msg);
            }
        } else if (this.listener != null) {
            this.listener.receive(msg);
        }
    }

    protected void notifyViewChange(View v) {
        if (v == null) {
            return;
        }
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.viewAccepted(v);
            }
            catch (Throwable ex) {
                Trace.error("PullPushAdapter.notifyViewChange()", "exception notifying " + l + ": " + ex);
            }
        }
    }

    protected void notifySuspect(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.suspect(suspected_mbr);
            }
            catch (Throwable ex) {
                Trace.error("PullPushAdapter.notifySuspect()", "exception notifying " + l + ": " + ex);
            }
        }
    }

    protected void notifyBlock() {
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.block();
            }
            catch (Throwable ex) {
                Trace.error("PullPushAdapter.block()", "exception notifying " + l + ": " + ex);
            }
        }
    }

    private final /* synthetic */ void this() {
        this.transport = null;
        this.listener = null;
        this.membership_listeners = new ArrayList();
        this.receiver_thread = null;
        this.listeners = new HashMap();
    }

    public PullPushAdapter(Transport transport) {
        this.this();
        this.transport = transport;
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l) {
        this.this();
        this.transport = transport;
        this.setListener(l);
        this.start();
    }

    public PullPushAdapter(Transport transport, MembershipListener ml) {
        this.this();
        this.transport = transport;
        this.addMembershipListener(ml);
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l, MembershipListener ml) {
        this.this();
        this.transport = transport;
        this.setListener(l);
        this.addMembershipListener(ml);
        this.start();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class PullHeader
    extends Header {
        Serializable identifier;

        public final Serializable getIdentifier() {
            return this.identifier;
        }

        public final long size() {
            return 128L;
        }

        public final String toString() {
            return "PullHeader";
        }

        public final void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.identifier);
        }

        public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.identifier = (Serializable)in.readObject();
        }

        private final /* synthetic */ void this() {
            this.identifier = null;
        }

        public PullHeader() {
            this.this();
        }

        public PullHeader(Serializable identifier) {
            this.this();
            this.identifier = identifier;
        }
    }
}

