/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.protocols.TOTAL_OLD;

class TotalRetransmissionThread
extends Thread {
    private static final long polling_delay = 1000L;
    private static final long resend_timeout = 2000L;
    private static final int max_request = 10;
    private long last_retrans_request_time;
    private long last_requested_seq;
    private TOTAL_OLD prot_ptr;
    private boolean is_running;

    public void reset() {
        this.last_retrans_request_time = -1;
        this.last_requested_seq = -1;
    }

    private final void sendResendRequest(Address sequencer, Address local_addr, long seq_id) {
        Message resend_msg = new Message(sequencer, local_addr, null);
        resend_msg.putHeader(this.getName(), new TOTAL_OLD.TotalHeader(7, seq_id));
        this.prot_ptr.passDown(new Event(1, resend_msg));
        System.err.println("TotalRetransmissionThread.resend() - resend requested for message " + seq_id);
    }

    private final void checkForResend() {
        long next_seq_id;
        long first_seq_id = this.prot_ptr.getFirstQueuedSeqID();
        if (first_seq_id >= 0L && (next_seq_id = this.prot_ptr.getNextSeqID()) < first_seq_id) {
            long time_now = System.currentTimeMillis();
            if (next_seq_id > this.last_requested_seq || time_now > this.last_retrans_request_time + 2000L || this.last_retrans_request_time < 0L) {
                long temp_long;
                Address sequencer = this.prot_ptr.getSequencer();
                if (sequencer == null) {
                    System.out.println("Error: (TOTAL_OLD) TotalRetransmissionThread.checkForResend() - could not determine sequencer to send a TOTAL_RESEND request");
                    return;
                }
                Address local_addr = this.prot_ptr.getLocalAddr();
                if (local_addr == null) {
                    System.out.println("Warning: (TOTAL_OLD) TotalRetransmissionThread.checkForResend() - local address not specified in TOTAL_RESEND request... attempting to send requests anyway");
                }
                long last_resend_seq_id = (temp_long = next_seq_id + 10L) > first_seq_id ? first_seq_id : temp_long;
                long resend_seq = next_seq_id;
                while (resend_seq < last_resend_seq_id) {
                    this.sendResendRequest(sequencer, local_addr, resend_seq);
                    ++resend_seq;
                }
                this.last_retrans_request_time = time_now;
                this.last_requested_seq = last_resend_seq_id;
            }
        }
    }

    public void run() {
        while (this.is_running) {
            this.checkForResend();
            try {
                TotalRetransmissionThread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stopResendRequests() {
        this.is_running = false;
    }

    public TotalRetransmissionThread(TOTAL_OLD parent_prot) {
        if (parent_prot != null) {
            this.prot_ptr = parent_prot;
        } else {
            System.err.println("Error: TotalRetransmissionThread.TotalRetransmissionThread() - given parent protocol reference is null\n  (FATAL ERROR - TOTAL_OLD protocol will not function properly)");
            this.is_running = false;
        }
        this.reset();
        this.is_running = true;
    }
}

