/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;
import org.javagroups.stack.GossipServer;
import org.javagroups.stack.Router;
import org.javagroups.util.Promise;

public class DisconnectTest
extends TestCase {
    private JChannel channel;
    static /* synthetic */ Class class$org$javagroups$tests$DisconnectTest;

    public void setUp() throws Exception {
        super.setUp();
        Trace.setTrace(true);
        Trace.setDefaultOutput(3, System.err);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    private final String getTUNNELProps(int routerPort, int gossipPort) {
        return "TUNNEL(router_host=localhost;router_port=" + routerPort + "):PING(gossip_host=localhost;gossip_port=" + gossipPort + "):pbcast.FD:VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=100;retransmit_timeout=3000;down_thread=true;up_thread=true):pbcast.STABLE(desired_avg_gossip=20000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=false;down_thread=true;up_thread=true)";
    }

    public void testDisconnectConnectOne_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.startRouter(), this.startGossipServer());
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.startRouter(), this.startGossipServer());
        JChannel coordinator = new JChannel(props);
        coordinator.connect("testgroup");
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.startRouter(), this.startGossipServer());
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel(props);
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        boolean bl = false;
        if (msg != null) {
            bl = true;
        }
        DisconnectTest.assertTrue((boolean)bl);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public void testDisconnectConnectOne_Default() throws Exception {
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_Default() throws Exception {
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_Default() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        boolean bl = false;
        if (msg != null) {
            bl = true;
        }
        DisconnectTest.assertTrue((boolean)bl);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public static Test suite() {
        Class clazz = class$org$javagroups$tests$DisconnectTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$DisconnectTest = DisconnectTest.class$("[Lorg.javagroups.tests.DisconnectTest;", false);
        }
        TestSuite s = new TestSuite(clazz);
        return s;
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class clazz = class$org$javagroups$tests$DisconnectTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$DisconnectTest = DisconnectTest.class$("[Lorg.javagroups.tests.DisconnectTest;", false);
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
    }

    private final int startRouter() throws Exception {
        long startms;
        int routerPort = this.getFreePort();
        Thread routerThread = new Thread(new Runnable(this, routerPort){
            final /* synthetic */ DisconnectTest this$0;
            final /* synthetic */ int val$routerPort;

            public final void run() {
                try {
                    new Router(this.val$routerPort).start();
                }
                catch (Exception e) {
                    System.err.println("Failed to start the router on port " + this.val$routerPort);
                    e.printStackTrace();
                }
            }
            {
                this.this$0 = disconnectTest;
                this.val$routerPort = n;
            }
        });
        routerThread.start();
        long crtms = startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        while (crtms - startms < 10000L) {
            Socket s = null;
            try {
                s = new Socket("localhost", routerPort);
            }
            catch (Exception e) {
                lastConnectException = e;
                crtms = System.currentTimeMillis();
                continue;
            }
            lastConnectException = null;
            DataInputStream dis = new DataInputStream(s.getInputStream());
            DataOutputStream dos = new DataOutputStream(s.getOutputStream());
            int len = dis.readInt();
            byte[] buffer = new byte[len];
            dis.read(buffer, 0, len);
            dos.writeInt(-10);
            dos.writeUTF("nogroup_setup");
            dis.readInt();
            s.close();
            break;
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            DisconnectTest.fail((String)"Cannot connect to the router");
        }
        System.out.println("router ok");
        return routerPort;
    }

    private final int startGossipServer() throws Exception {
        long startms;
        int gossipPort = this.getFreePort();
        Thread gossipThread = new Thread(new Runnable(this, gossipPort){
            final /* synthetic */ DisconnectTest this$0;
            final /* synthetic */ int val$gossipPort;

            public final void run() {
                try {
                    new GossipServer(this.val$gossipPort).run();
                }
                catch (Exception e) {
                    System.err.println("Failed to start the gossip server on port " + this.val$gossipPort);
                    e.printStackTrace();
                }
            }
            {
                this.this$0 = disconnectTest;
                this.val$gossipPort = n;
            }
        });
        gossipThread.start();
        long crtms = startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        while (crtms - startms < 10000L) {
            Socket s = null;
            try {
                s = new Socket("localhost", gossipPort);
            }
            catch (Exception e) {
                lastConnectException = e;
                crtms = System.currentTimeMillis();
                continue;
            }
            lastConnectException = null;
            ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
            Object gd = null;
            oos.writeObject(gd);
            oos.close();
            s.close();
            break;
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            DisconnectTest.fail((String)"Cannot connect to the gossip server");
        }
        System.out.println("gossip server ok");
        return gossipPort;
    }

    private final int getFreePort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DisconnectTest(String name) {
        super(name);
    }

    private class PromisedMessageListener
    implements MessageListener {
        private Promise promise;

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }

        public void setState(byte[] state) {
        }

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }
    }
}

