/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.Serializable;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.blocks.MessageDispatcher;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.blocks.RspCollector;
import org.javagroups.debug.Debugger;
import org.javagroups.log.Trace;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MessageDispatcherTestAsync
implements RequestHandler {
    static final int NUM = 10;
    Channel channel;
    MessageDispatcher disp;
    RspList rsp_list;
    MyCollector coll;
    Debugger debugger;
    boolean debug;
    boolean cummulative;
    boolean done_submitted;
    String props;

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        if (this.debug) {
            this.debugger = new Debugger((JChannel)this.channel, this.cummulative);
            this.debugger.start();
        }
        this.disp = new MessageDispatcher(this.channel, null, null, this);
        this.channel.connect("MessageDispatcherTestAsyncGroup");
    }

    public void mcast(int num) {
        if (!this.done_submitted) {
            System.err.println("Must submit 'done' (press 'd') before mcasting new message");
            return;
        }
        int i = 0;
        while (i < num) {
            Util.sleep(100L);
            System.out.println("Casting message #" + i);
            this.disp.castMessage(null, i, new Message(null, null, (Serializable)((Object)("Number #" + i))), this.coll);
            ++i;
        }
        this.done_submitted = false;
    }

    public void disconnect() {
        System.out.println("** Disconnecting channel");
        this.channel.disconnect();
        System.out.println("** Disconnecting channel -- done");
        System.out.println("** Closing channel");
        this.channel.close();
        System.out.println("** Closing channel -- done");
        System.out.println("** disp.stop()");
        this.disp.stop();
        System.out.println("** disp.stop() -- done");
    }

    public void done() {
        int i = 0;
        while (i < 10) {
            this.disp.done(i);
            ++i;
        }
        this.done_submitted = true;
    }

    public Object handle(Message msg) {
        System.out.println("** handle(" + msg.getObject() + ')');
        return new String(msg.getObject() + ": success");
    }

    public static void main(String[] args) {
        MessageDispatcherTestAsync test = null;
        boolean debug = false;
        boolean cummulative = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                MessageDispatcherTestAsync.help();
                return;
            }
            if (args[i].equals("-debug")) {
                debug = true;
            } else if (args[i].equals("-cummulative")) {
                cummulative = true;
            }
            ++i;
        }
        Trace.init();
        try {
            test = new MessageDispatcherTestAsync(debug, cummulative);
            test.start();
            block8: while (true) {
                System.out.println("[m=mcast 10 msgs x=exit]");
                int c = System.in.read();
                switch (c) {
                    case 120: {
                        test.disconnect();
                        System.exit(0);
                        return;
                    }
                    case 109: {
                        test.mcast(10);
                        continue block8;
                    }
                    case 100: {
                        test.done();
                        continue block8;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void help() {
        System.out.println("MessageDispatcherTestAsync [-debug] [-cummulative]");
    }

    private final /* synthetic */ void this() {
        this.coll = new MyCollector();
        this.debugger = null;
        this.debug = false;
        this.cummulative = false;
        this.done_submitted = true;
        this.props = "UDP(loopback=true;mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=10000;max_interval=20000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    }

    public MessageDispatcherTestAsync(boolean debug, boolean cummulative) {
        this.this();
        this.debug = debug;
        this.cummulative = cummulative;
    }

    class MyCollector
    implements RspCollector {
        public void receiveResponse(Message msg) {
            System.out.println("** received response " + msg.getObject() + " [sender=" + msg.getSrc() + ']');
        }

        public void suspect(Address mbr) {
            System.out.println("** suspected member " + mbr);
        }

        public void viewChange(View new_view) {
            System.out.println("** received new view " + new_view);
        }

        MyCollector() {
        }
    }
}

