/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimedWriter {
    Thread thread;
    long timeout;
    boolean completed;
    Exception write_ex;
    Socket sock;

    void start(InetAddress local, InetAddress remote, int peer_port) {
        this.stop();
        this.thread = new SocketCreator(local, remote, peer_port);
        this.thread.start();
    }

    void start(OutputStream out, byte[] buf) {
        this.stop();
        this.thread = new WriterThread(out, buf);
        this.thread.start();
    }

    void start(OutputStream out, int i) {
        this.stop();
        this.thread = new WriterThread(out, i);
        this.thread.start();
    }

    void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void write(OutputStream out, byte[] buf, long timeout) throws Exception, Timeout, InterruptedException {
        if (out == null || buf == null) {
            System.err.println("TimedWriter.write(): output stream or buffer is null, ignoring write");
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, buf);
            if (this.thread == null) {
                Object var6_4 = null;
                this.stop();
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.stop();
            throw throwable;
        }
        {
            Object var6_6 = null;
            this.stop();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void write(OutputStream out, int i, long timeout) throws Exception, Timeout, InterruptedException {
        if (out == null) {
            System.err.println("TimedWriter.write(): output stream is null, ignoring write");
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, i);
            if (this.thread == null) {
                Object var6_4 = null;
                this.stop();
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.stop();
            throw throwable;
        }
        {
            Object var6_6 = null;
            this.stop();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Socket createSocket(InetAddress local, InetAddress remote, int port, long timeout) throws Exception, Timeout, InterruptedException {
        block5: {
            Object ret = null;
            try {
                this.timeout = timeout;
                this.completed = false;
                this.start(local, remote, port);
                if (this.thread != null) break block5;
                Socket socket = null;
                Object var8_8 = null;
                this.stop();
                return socket;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.stop();
                throw throwable;
            }
        }
        this.thread.join(timeout);
        if (!this.completed) {
            throw new Timeout();
        }
        if (this.write_ex != null) {
            Exception tmp = this.write_ex;
            this.write_ex = null;
            throw tmp;
        }
        Socket socket = this.sock;
        Object var8_9 = null;
        this.stop();
        return socket;
    }

    public static void main(String[] args) {
        TimedWriter w = new TimedWriter();
        InetAddress local = null;
        InetAddress remote = null;
        int port = 0;
        Socket sock = null;
        if (args.length != 3) {
            System.err.println("TimedWriter <local host> <remote host> <remote port>");
            return;
        }
        try {
            local = InetAddress.getByName(args[0]);
            remote = InetAddress.getByName(args[1]);
            port = new Integer(args[2]);
        }
        catch (Exception e) {
            System.err.println("Could find host " + remote);
            return;
        }
        while (true) {
            try {
                sock = w.createSocket(local, remote, port, 3000L);
                if (sock == null) continue;
                System.out.println("Connection created");
                return;
            }
            catch (Timeout timeout) {
                System.err.println("Timed out creating socket");
                continue;
            }
            catch (Exception io_ex) {
                System.err.println("Connection could not be created, retrying");
                Util.sleep(2000L);
                continue;
            }
            break;
        }
    }

    private final /* synthetic */ void this() {
        this.thread = null;
        this.timeout = 2000L;
        this.completed = true;
        this.write_ex = null;
        this.sock = null;
    }

    public TimedWriter() {
        this.this();
    }

    class Timeout
    extends Exception {
        public String toString() {
            return "TimedWriter.Timeout";
        }

        Timeout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WriterThread
    extends Thread {
        DataOutputStream out;
        byte[] buf;
        int i;

        public void run() {
            try {
                if (this.buf != null) {
                    this.out.write(this.buf);
                } else {
                    this.out.writeInt(this.i);
                }
            }
            catch (IOException e) {
                TimedWriter.this.write_ex = e;
            }
            TimedWriter.this.completed = true;
        }

        private final /* synthetic */ void this() {
            this.out = null;
            this.buf = null;
            this.i = 0;
        }

        public WriterThread(OutputStream out, byte[] buf) {
            this.this();
            this.out = new DataOutputStream(out);
            this.buf = buf;
            this.setName("TimedWriter.WriterThread");
        }

        public WriterThread(OutputStream out, int i) {
            this.this();
            this.out = new DataOutputStream(out);
            this.i = i;
            this.setName("TimedWriter.WriterThread");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SocketCreator
    extends Thread {
        InetAddress local;
        InetAddress remote;
        int peer_port;

        public void run() {
            TimedWriter.this.completed = false;
            TimedWriter.this.sock = null;
            try {
                TimedWriter.this.sock = new Socket(this.remote, this.peer_port, this.local, 0);
            }
            catch (IOException io_ex) {
                TimedWriter.this.write_ex = io_ex;
            }
            TimedWriter.this.completed = true;
        }

        private final /* synthetic */ void this() {
            this.local = null;
            this.remote = null;
            this.peer_port = 0;
        }

        public SocketCreator(InetAddress local, InetAddress remote, int peer_port) {
            this.this();
            this.local = local;
            this.remote = remote;
            this.peer_port = peer_port;
        }
    }
}

