<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the Open Shading Language Project. -->

# TSC meeting 2020-04-02 (first TSC meeting!)

Host: John Mertic

### Attendees:

Meeting chair pro tem: John Mertic, Linux Foundation

TSC members:

  * [x] Luke Emrose, Animal Logic
  * [x] Eric Enderton, NVIDIA
  * [x] Stephen Friedman, Pixar
  * [x] Larry Gritz, Sony Pictures Imageworks
  * [x] Derek Haase, DNEG
  * [x] Adrien Herubel, Autodesk
  * [x] Lee Kerley, Sony Pictures Imageworks
  * [x] Chris Kulla, Sony Pictures Imageworks
  * [x] Mitch Prater, Laika
  * [x] Brecht Van Lommel, Blender

Additional attendees:

  * [x] Max Liani, Pixar
  * [x] Zap Anderson, Autodesk
  * [x] Pete Segal, Foundry
  * [x] JT Nelson, Pasadena Open Source
  * [x] Amir Shachar, DNEG
  * [x] Alex Wells, Intel


### Agenda / Meeting notes

* Charter / legalities
  - All the proposed documents are in this PR:
    https://github.com/imageworks/OpenShadingLanguage/pull/1137
  - **Action**: Everybody please look over the charter, etc., give a +1,
    raise any objections or ask questions.
  - **Action**: Look at the CLA, show to your legal depts if they care. It's
    identical to the other ASWF projects, so the bar to alter it will be
    extremely high, please resist the temptation.
  - Aim to vote on approval by the next TSC meeting

* TSC membership
  - As above, per pre-meeting correspondence and opportunities to
    volunteer.
  - **Action**: suggest any edits to TSC voting members
    - People or orgs  not on the list who want to be members and can commit
      a high level of involvement.
    - Swapping, adding, or subtracting people in the future is easy as
      circumstances changes, so don't overthink it.

* Office elections
  - LG nominated himself as chief architect, Chris Kulla for chair.
  - Both passed by voice vote without objections.
  - Welcome to the ASWF TAC, Chris!
  - Elections (and/or ratification of people staying in their current roles)
    will be annual.

* John went over the infrastructure checklist as we transition the project:
  - Where does the code live, issues, etc: we're already on GitHub, nothing
    to do there
  - CI: we are already using GitHub Actions CI
      - short term, nothing to do
      - long term, we will want to enhance our lack of good Windows CI and
        ability to CI test both the GPU path and the CPU "wide SIMD" batch
        shading mode.
  - **Action**: look at the CLA, +1 it
  - When we set up the new EasyCLA system, even orgs who previously signed
    the old Sony CLA will need to sign the new LF one. We will want to have
    everybody do this before we move the repository.
  - **Action**: LG to turn over the openshadinglanguage.org domain to LF
    (right now it's just a redirect to our GitHub repo)
  - **Action**: LF/Steve Winslow will do the code scan, make sure licenses
    are in order, etc., as another prerequisite to moving the repo from
    imageworks GH account to ASWF GH account.
  - Mail list:
    - **Action**: John Mertic will set up osl-dev@lists.aswf.io (and a
      second osl-tsc-private for the occasional topics among TSC members
      that can't be public, like security or code of conduct issues)
    - **Action**: LG will let people know about the new list. You will need
      to sign up even if you were signed up to the old list.
    - **Action**: John will figure out how to transfer the archives of the
      old osl-dev so they are not lost.
    - Future action: in a few weeks, after everybody is signed up for the
      new list, we will throw the switch and stop using the old one.
  - Social media: there are no other accounts to transfer.
  - Trademarks: SPI never registered any.
  - Slack channel: John already set up on ASWF slack.

* Meeting cadence
  - Let's keep the Thursday 2pm PT time for now. (No objections.)
  - LG suggests that we meet every 2nd week -- because this project is
    starting with so much more already completed compared to the other
    projects when they joined (already have CI, documents are same as were
    approved by the orgs before, etc.), we probably don't need every week.
    Can adjust later.
  - Hopefully will get this administrivia done soon and can spend all our
    time on tech stuff.

* Items for next TSC meeting agenda:
  - Ratify charter, governance, CLAs
