# Project Intake checklist

This is a checklist for TSC's to review as part of the intake process. The TSC should review this entire list during the kickoff meeting. For anything outstanding, create an [issue](../issues) to track and link to it in the list

- Existing Project Governance
  - [X] Project License exists ( [LICENSE.md](../LICENSE.md) ) and is OSI-approved
  - [X] Any third-party components/dependencies included are listed along with their licenses ( [THIRD_PARTY.md](../THIRD_PARTY.md) )
  - [X] Governance defined, outlining community roles and how decsions are made ( [GOVERNANCE.md](../GOVERNANCE.md] )
    - Closed by https://github.com/imageworks/OpenShadingLanguage/pull/1137
  - [X] Contribution Policy defined ( [CONTRIBUTING.md](../CONTRIBUTING.md) )
    - Closed by https://github.com/imageworks/OpenShadingLanguage/pull/1137
  - [X] Code of Conduct defined ( existing or pull from [ASWF Sample Project](https://github.com/AcademySoftwareFoundation/aswf-sample-project/blob/master/CODE_OF_CONDUCT.md) )
    - Closed by https://github.com/imageworks/OpenShadingLanguage/pull/1137
  - [ ] Release methodology defined	( [release.md](process/release.md) )
- New Project Governance
  - [X] TSC members identified
  - [X] First TSC meeting held
  - [X] TSC meeting cadence set and added to project calendar
  - [ ] CLA Approved ( if used ) ( [CCLA](ccla.md) and [ICLA](icla.md) )
  - Project charter	( [charter.md](charter.md) )
    - [X] Approved by TSC
      - Closed by https://github.com/imageworks/OpenShadingLanguage/pull/1137
    - [ ] Filed ( create pull request against [foundation repo](https://github.com/AcademySoftwareFoundation/foundation) )
- Current tools
  - [X] Source Control ( https://github.com/imageworks/OpenShadingLanguage )	
	- [X] Issue/feature tracker ( https://github.com/imageworks/OpenShadingLanguage/issues )
  - Collaboration tools 
    - [X] Mailing lists (old: http://groups.google.com/group/osl-dev )
      - [X] Move to groups.io ( create [issue on foundation repo](https://github.com/AcademySoftwareFoundation/foundation/issues/new ) to setup/transfer
    - [X] Slack or IRC ( #openshadinglanguage )
  - [ ] CI/build environment
    - Already using GitHub Actions CI
    - [ ] Needs work on Windows
    - [X] Needs to use ASWF docker images for more complete VFXPlatform coverage
    - [ ] Longer term: needs GPU tests
- Project assets
  - [X] Domain name
	- [X] Logo(s)	( https://github.com/AcademySoftwareFoundation/artwork/blob/master/examples/incubating.md#open-shading-language-logos )
	- [ ] Trademarks/mark ownership rights ( John to follow up with Larry on this )
- Outreach
  - [X] New project announcement done ( https://www.aswf.io/osl-joins-aswf/ )
  - [X] Project added to ASWF website and ASWF landscape
- Graduation
  - [ ] CII Badge	achieved
  - [ ] Committer Diversity	established
	- [ ] Commit/Contribution growth during incubation
	- [ ] Committers defined in the project	( [COMMITTERS.csv](COMMITTERS.csv) or [COMMITTERS.yml](COMMITTERS.yml) )
  - [X] TAC representative appointed
    - Chris Kulla, TSC chair, is our TAC rep for the project
  - [X]	License scan completed and no issues found
    - Minor issues were found but already fixed in PR https://github.com/imageworks/OpenShadingLanguage/pull/1145
  - [ ] Code repository imported to ASWF GitHub organization
    - [ ] Developer Certificate of Origin past commit signoff done and DCO Probot enabled.
