%%------------------------------------------------------------
%%
%% Implementation stub file
%% 
%% Target: mnesia_connector
%% Source: /ldisk/daily_build/otp_prebuild_r11b.2007-06-11_19/otp_src_R11B-5/lib/mnesia_session/src/mnesia_session.idl
%% IC vsn: 4.2.13
%% 
%% This file is automatically generated. DO NOT EDIT IT.
%%
%%------------------------------------------------------------

-module(mnesia_connector).
-ic_compiled("4_2_13").


%% Interface functions
-export([connect/1, disconnect/2]).

%% Type identification function
-export([typeID/0]).

%% Used to start server
-export([oe_create/0, oe_create_link/0, oe_create/1]).
-export([oe_create_link/1, oe_create/2, oe_create_link/2]).

-export([start/2, start_link/3]).

%% gen server export stuff
-behaviour(gen_server).
-export([stop/1, init/1, terminate/2]).
-export([handle_call/3, handle_cast/2, handle_info/2]).
-export([code_change/3]).


%%------------------------------------------------------------
%%
%% Object interface functions.
%%
%%------------------------------------------------------------



%%%% Operation: connect
%% 
%%   Returns: RetVal
%%
connect(OE_THIS) ->
    gen_server:call(OE_THIS, connect, infinity).

%%%% Operation: disconnect
%% 
%%   Returns: RetVal
%%
disconnect(OE_THIS, Object_key) ->
    gen_server:call(OE_THIS, {disconnect, Object_key}, infinity).




%%------------------------------------------------------------
%%
%% Server implementation.
%%
%%------------------------------------------------------------


%%------------------------------------------------------------
%%
%% Function for fetching the interface type ID.
%%
%%------------------------------------------------------------

typeID() ->
    "IDL:mnesia/connector:1.0".


%%------------------------------------------------------------
%%
%% Server creation functions.
%%
%%------------------------------------------------------------

oe_create() ->
    start([], []).

oe_create_link() ->
    start_link([], []).

oe_create(Env) ->
    start(Env, []).

oe_create_link(Env) ->
    start_link(Env, []).

oe_create(Env, RegName) ->
    start(RegName, Env, []).

oe_create_link(Env, RegName) ->
    start_link(RegName, Env, []).

%%------------------------------------------------------------
%%
%% Start functions.
%%
%%------------------------------------------------------------

start(Env, Opt) ->
    gen_server:start(?MODULE, Env, Opt).

start_link(Env, Opt) ->
    gen_server:start_link(?MODULE, Env, Opt).

start(RegName, Env, Opt) ->
    gen_server:start(RegName, ?MODULE, Env, Opt).

start_link(RegName, Env, Opt) ->
    gen_server:start_link(RegName, ?MODULE, Env, Opt).

%% Standard gen_server termination
stop(OE_THIS) ->
    gen_server:cast(OE_THIS,stop).

%% Call to implementation init
init(Env) ->
    mnesia_connector_impl:init(Env).

terminate(Reason, State) ->
    mnesia_connector_impl:terminate(Reason, State).


%%%% Operation: connect
%% 
%%   Returns: RetVal
%%
handle_call(connect, _, OE_State) ->
    mnesia_connector_impl:connect(OE_State);

%%%% Operation: disconnect
%% 
%%   Returns: RetVal
%%
handle_call({disconnect, Object_key}, _, OE_State) ->
    mnesia_connector_impl:disconnect(OE_State, Object_key);



%%%% Standard gen_server call handle
%%
handle_call(stop, _, State) ->
    {stop, normal, ok, State}.




%%%% Standard gen_server cast handle
%%
handle_cast(stop, State) ->
    {stop, normal, State}.




%%%% Standard gen_server handles
%%
handle_info(_, State) ->
    {noreply, State}.



code_change(OldVsn, State, Extra) ->
    mnesia_connector_impl:code_change(OldVsn, State, Extra).

