%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:1.4.5
%% Purpose: encoder and decoder to the types in mod PKIXAttributeCertificate

-module('PKIXAttributeCertificate').
-include("PKIXAttributeCertificate.hrl").
-define('RT_BER',asn1rt_ber_bin_v2).
-asn1_info([{vsn,'1.4.5'},
            {module,'PKIXAttributeCertificate'},
            {options,[ber_bin_v2,report_errors,{cwd,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]},{outdir,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]},noobj,optimize,compact_bit_string,der,{i,[46]},{i,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]}]}]).

-export([encoding_rule/0]).
-export([
'enc_AttributeCertificate'/2,
'enc_AttributeCertificateInfo'/2,
'enc_AttCertVersion'/2,
'enc_Holder'/2,
'enc_ObjectDigestInfo'/2,
'enc_AttCertIssuer'/2,
'enc_V2Form'/2,
'enc_IssuerSerial'/2,
'enc_AttCertValidityPeriod'/2,
'enc_Targets'/2,
'enc_Target'/2,
'enc_TargetCert'/2,
'enc_IetfAttrSyntax'/2,
'enc_SvceAuthInfo'/2,
'enc_RoleSyntax'/2,
'enc_Clearance'/2,
'enc_ClassList'/2,
'enc_SecurityCategory'/2,
'enc_AAControls'/2,
'enc_AttrSpec'/2,
'enc_ACClearAttrs'/2,
'enc_ProxyInfo'/2
]).

-export([
'dec_AttributeCertificate'/2,
'dec_AttributeCertificateInfo'/2,
'dec_AttCertVersion'/2,
'dec_Holder'/2,
'dec_ObjectDigestInfo'/2,
'dec_AttCertIssuer'/2,
'dec_V2Form'/2,
'dec_IssuerSerial'/2,
'dec_AttCertValidityPeriod'/2,
'dec_Targets'/2,
'dec_Target'/2,
'dec_TargetCert'/2,
'dec_IetfAttrSyntax'/2,
'dec_SvceAuthInfo'/2,
'dec_RoleSyntax'/2,
'dec_Clearance'/2,
'dec_ClassList'/2,
'dec_SecurityCategory'/2,
'dec_AAControls'/2,
'dec_AttrSpec'/2,
'dec_ACClearAttrs'/2,
'dec_ProxyInfo'/2
]).

-export([
'id-pe-ac-auditIdentity'/0,
'id-pe-aaControls'/0,
'id-pe-ac-proxying'/0,
'id-ce-targetInformation'/0,
'id-aca'/0,
'id-aca-authenticationInfo'/0,
'id-aca-accessIdentity'/0,
'id-aca-chargingIdentity'/0,
'id-aca-group'/0,
'id-aca-encAttrs'/0,
'id-at-role'/0,
'id-at-clearance'/0
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber_bin_v2.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,element(1,?RT_BER:decode(Data))
) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  Result ->
    {ok,Result}
end.

encode_disp('AttributeCertificate',Data) -> 'enc_AttributeCertificate'(Data);
encode_disp('AttributeCertificateInfo',Data) -> 'enc_AttributeCertificateInfo'(Data);
encode_disp('AttCertVersion',Data) -> 'enc_AttCertVersion'(Data);
encode_disp('Holder',Data) -> 'enc_Holder'(Data);
encode_disp('ObjectDigestInfo',Data) -> 'enc_ObjectDigestInfo'(Data);
encode_disp('AttCertIssuer',Data) -> 'enc_AttCertIssuer'(Data);
encode_disp('V2Form',Data) -> 'enc_V2Form'(Data);
encode_disp('IssuerSerial',Data) -> 'enc_IssuerSerial'(Data);
encode_disp('AttCertValidityPeriod',Data) -> 'enc_AttCertValidityPeriod'(Data);
encode_disp('Targets',Data) -> 'enc_Targets'(Data);
encode_disp('Target',Data) -> 'enc_Target'(Data);
encode_disp('TargetCert',Data) -> 'enc_TargetCert'(Data);
encode_disp('IetfAttrSyntax',Data) -> 'enc_IetfAttrSyntax'(Data);
encode_disp('SvceAuthInfo',Data) -> 'enc_SvceAuthInfo'(Data);
encode_disp('RoleSyntax',Data) -> 'enc_RoleSyntax'(Data);
encode_disp('Clearance',Data) -> 'enc_Clearance'(Data);
encode_disp('ClassList',Data) -> 'enc_ClassList'(Data);
encode_disp('SecurityCategory',Data) -> 'enc_SecurityCategory'(Data);
encode_disp('AAControls',Data) -> 'enc_AAControls'(Data);
encode_disp('AttrSpec',Data) -> 'enc_AttrSpec'(Data);
encode_disp('ACClearAttrs',Data) -> 'enc_ACClearAttrs'(Data);
encode_disp('ProxyInfo',Data) -> 'enc_ProxyInfo'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('AttributeCertificate',Data) -> 'dec_AttributeCertificate'(Data);
decode_disp('AttributeCertificateInfo',Data) -> 'dec_AttributeCertificateInfo'(Data);
decode_disp('AttCertVersion',Data) -> 'dec_AttCertVersion'(Data);
decode_disp('Holder',Data) -> 'dec_Holder'(Data);
decode_disp('ObjectDigestInfo',Data) -> 'dec_ObjectDigestInfo'(Data);
decode_disp('AttCertIssuer',Data) -> 'dec_AttCertIssuer'(Data);
decode_disp('V2Form',Data) -> 'dec_V2Form'(Data);
decode_disp('IssuerSerial',Data) -> 'dec_IssuerSerial'(Data);
decode_disp('AttCertValidityPeriod',Data) -> 'dec_AttCertValidityPeriod'(Data);
decode_disp('Targets',Data) -> 'dec_Targets'(Data);
decode_disp('Target',Data) -> 'dec_Target'(Data);
decode_disp('TargetCert',Data) -> 'dec_TargetCert'(Data);
decode_disp('IetfAttrSyntax',Data) -> 'dec_IetfAttrSyntax'(Data);
decode_disp('SvceAuthInfo',Data) -> 'dec_SvceAuthInfo'(Data);
decode_disp('RoleSyntax',Data) -> 'dec_RoleSyntax'(Data);
decode_disp('Clearance',Data) -> 'dec_Clearance'(Data);
decode_disp('ClassList',Data) -> 'dec_ClassList'(Data);
decode_disp('SecurityCategory',Data) -> 'dec_SecurityCategory'(Data);
decode_disp('AAControls',Data) -> 'dec_AAControls'(Data);
decode_disp('AttrSpec',Data) -> 'dec_AttrSpec'(Data);
decode_disp('ACClearAttrs',Data) -> 'dec_ACClearAttrs'(Data);
decode_disp('ProxyInfo',Data) -> 'dec_ProxyInfo'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
   case ?MODULE:module_info() of
      MI when is_list(MI) ->
         case lists:keysearch(attributes,1,MI) of
            {value,{_,Attributes}} when is_list(Attributes) ->
               case lists:keysearch(asn1_info,1,Attributes) of
                  {value,{_,Info}} when is_list(Info) ->
                     Info;
                  _ ->
                     []
               end;
            _ ->
               []
         end
   end.


%%================================
%%  AttributeCertificate
%%================================
'enc_AttributeCertificate'(Val) ->
    'enc_AttributeCertificate'(Val, [<<48>>]).

'enc_AttributeCertificate'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute acinfo(1)   External PKIXAttributeCertificate:AttributeCertificateInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AttributeCertificateInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Explicit88':'enc_AlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureValue(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_bit_string([], Cindex3, [], [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AttributeCertificate'(Tlv) ->
   'dec_AttributeCertificate'(Tlv, [16]).

'dec_AttributeCertificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute acinfo(1)   External PKIXAttributeCertificate:AttributeCertificateInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AttributeCertificateInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Explicit88':'dec_AlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signatureValue(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_compact_bit_string(V3,[],[],[3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'AttributeCertificate', Term1, Term2, Term3}.



%%================================
%%  AttributeCertificateInfo
%%================================
'enc_AttributeCertificateInfo'(Val) ->
    'enc_AttributeCertificateInfo'(Val, [<<48>>]).

'enc_AttributeCertificateInfo'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7, Cindex8, Cindex9} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], Cindex1, [{v2,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute holder(2)   External PKIXAttributeCertificate:Holder
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Holder'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIXAttributeCertificate:AttCertIssuer
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AttCertIssuer'(Cindex3, []),

%%-------------------------------------------------
%% attribute signature(4)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'PKIX1Explicit88':'enc_AlgorithmIdentifier'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = ?RT_BER:encode_integer([], Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute attrCertValidityPeriod(6)   External PKIXAttributeCertificate:AttCertValidityPeriod
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_AttCertValidityPeriod'(Cindex6, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_AttributeCertificateInfo_attributes'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex8, [], [<<3>>])
       end,

%%-------------------------------------------------
%% attribute extensions(9)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit88':'enc_Extensions'(Cindex9, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfo_attributes
%%================================

'enc_AttributeCertificateInfo_attributes'({'AttributeCertificateInfo_attributes',Val}, TagIn) ->
   'enc_AttributeCertificateInfo_attributes'(Val, TagIn);

'enc_AttributeCertificateInfo_attributes'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfo_attributes_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfo_attributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeCertificateInfo_attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit88':'enc_Attribute'(H, [<<48>>]),
   'enc_AttributeCertificateInfo_attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_AttributeCertificateInfo_attributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['PKIX1Explicit88':'dec_Attribute'(V1, [16]) || V1 <- Tlv1].




'dec_AttributeCertificateInfo'(Tlv) ->
   'dec_AttributeCertificateInfo'(Tlv, [16]).

'dec_AttributeCertificateInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_integer(V1,[],[{v2,1}],[2]),

%%-------------------------------------------------
%% attribute holder(2)   External PKIXAttributeCertificate:Holder
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Holder'(V2, [16]),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIXAttributeCertificate:AttCertIssuer
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AttCertIssuer'(V3, []),

%%-------------------------------------------------
%% attribute signature(4)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'PKIX1Explicit88':'dec_AlgorithmIdentifier'(V4, [16]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = ?RT_BER:decode_integer(V5,[],[2]),

%%-------------------------------------------------
%% attribute attrCertValidityPeriod(6)   External PKIXAttributeCertificate:AttCertValidityPeriod
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_AttCertValidityPeriod'(V6, [16]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_AttributeCertificateInfo_attributes'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{3,V8}|TempTlv9] ->
    {?RT_BER:decode_compact_bit_string(V8,[],[],[]), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute extensions(9)   External PKIX1Explicit88:Extensions OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{16,V9}|TempTlv10] ->
    {'PKIX1Explicit88':'dec_Extensions'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
   {'AttributeCertificateInfo', Term1, Term2, Term3, Term4, Term5, Term6, Term7, Term8, Term9}.



%%================================
%%  AttCertVersion
%%================================
'enc_AttCertVersion'(Val) ->
    'enc_AttCertVersion'(Val, [<<2>>]).


'enc_AttCertVersion'({'AttCertVersion',Val}, TagIn) ->
   'enc_AttCertVersion'(Val, TagIn);

'enc_AttCertVersion'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, [{v2,1}], TagIn).


'dec_AttCertVersion'(Tlv) ->
   'dec_AttCertVersion'(Tlv, [2]).

'dec_AttCertVersion'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,[],[{v2,1}],TagIn).



%%================================
%%  Holder
%%================================
'enc_Holder'(Val) ->
    'enc_Holder'(Val, [<<48>>]).

'enc_Holder'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute baseCertificateID(1)   External PKIXAttributeCertificate:IssuerSerial OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IssuerSerial'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute entityName(2)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit88':'enc_GeneralNames'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_Holder'(Tlv) ->
   'dec_Holder'(Tlv, [16]).

'dec_Holder'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute baseCertificateID(1)   External PKIXAttributeCertificate:IssuerSerial OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_IssuerSerial'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute entityName(2)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralNames'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Holder', Term1, Term2, Term3}.



%%================================
%%  ObjectDigestInfo
%%================================
'enc_ObjectDigestInfo'(Val) ->
    'enc_ObjectDigestInfo'(Val, [<<48>>]).

'enc_ObjectDigestInfo'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute digestedObjectType(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case (case Cindex1 of {_,_}->element(2,Cindex1);_->Cindex1 end) of
publicKey -> ?RT_BER:encode_enumerated(0,[<<10>>]);
publicKeyCert -> ?RT_BER:encode_enumerated(1,[<<10>>]);
otherObjectTypes -> ?RT_BER:encode_enumerated(2,[<<10>>]);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute otherObjectTypeID(2) with type OBJECT IDENTIFIER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_object_identifier(Cindex2, [<<6>>])
       end,

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'PKIX1Explicit88':'enc_AlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute objectDigest(4) with type BIT STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = ?RT_BER:encode_bit_string([], Cindex4, [], [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ObjectDigestInfo'(Tlv) ->
   'dec_ObjectDigestInfo'(Tlv, [16]).

'dec_ObjectDigestInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute digestedObjectType(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_enumerated(V1,[],[{publicKey,0},{publicKeyCert,1},{otherObjectTypes,2}],[10]),

%%-------------------------------------------------
%% attribute otherObjectTypeID(2) with type OBJECT IDENTIFIER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{6,V2}|TempTlv3] ->
    {?RT_BER:decode_object_identifier(V2,[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External PKIX1Explicit88:AlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'PKIX1Explicit88':'dec_AlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute objectDigest(4) with type BIT STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = ?RT_BER:decode_compact_bit_string(V4,[],[],[3]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
   {'ObjectDigestInfo', Term1, Term2, Term3, Term4}.



%%================================
%%  AttCertIssuer
%%================================
'enc_AttCertIssuer'(Val) ->
    'enc_AttCertIssuer'(Val, []).


'enc_AttCertIssuer'({'AttCertIssuer',Val}, TagIn) ->
   'enc_AttCertIssuer'(Val, TagIn);

'enc_AttCertIssuer'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      v1Form ->
         'PKIX1Implicit88':'enc_GeneralNames'(element(2,Val), [<<48>>]);
      v2Form ->
         'enc_V2Form'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_AttCertIssuer'(Tlv) ->
   'dec_AttCertIssuer'(Tlv, []).

'dec_AttCertIssuer'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'v1Form'
    {16, V1} -> 
        {v1Form, 'PKIX1Implicit88':'dec_GeneralNames'(V1, [])};


%% 'v2Form'
    {131072, V1} -> 
        {v2Form, 'dec_V2Form'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  V2Form
%%================================
'enc_V2Form'(Val) ->
    'enc_V2Form'(Val, [<<48>>]).

'enc_V2Form'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit88':'enc_GeneralNames'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute baseCertificateID(2)   External PKIXAttributeCertificate:IssuerSerial OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IssuerSerial'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_V2Form'(Tlv) ->
   'dec_V2Form'(Tlv, [16]).

'dec_V2Form'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'PKIX1Implicit88':'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute baseCertificateID(2)   External PKIXAttributeCertificate:IssuerSerial OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_IssuerSerial'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute objectDigestInfo(3)   External PKIXAttributeCertificate:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'V2Form', Term1, Term2, Term3}.



%%================================
%%  IssuerSerial
%%================================
'enc_IssuerSerial'(Val) ->
    'enc_IssuerSerial'(Val, [<<48>>]).

'enc_IssuerSerial'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Implicit88:GeneralNames
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit88':'enc_GeneralNames'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute serial(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_integer([], Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute issuerUID(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex3, [], [<<3>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IssuerSerial'(Tlv) ->
   'dec_IssuerSerial'(Tlv, [16]).

'dec_IssuerSerial'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Implicit88:GeneralNames
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit88':'dec_GeneralNames'(V1, [16]),

%%-------------------------------------------------
%% attribute serial(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_integer(V2,[],[2]),

%%-------------------------------------------------
%% attribute issuerUID(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{3,V3}|TempTlv4] ->
    {?RT_BER:decode_compact_bit_string(V3,[],[],[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'IssuerSerial', Term1, Term2, Term3}.



%%================================
%%  AttCertValidityPeriod
%%================================
'enc_AttCertValidityPeriod'(Val) ->
    'enc_AttCertValidityPeriod'(Val, [<<48>>]).

'enc_AttCertValidityPeriod'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBeforeTime(1) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_generalized_time([], Cindex1, [<<24>>]),

%%-------------------------------------------------
%% attribute notAfterTime(2) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_generalized_time([], Cindex2, [<<24>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AttCertValidityPeriod'(Tlv) ->
   'dec_AttCertValidityPeriod'(Tlv, [16]).

'dec_AttCertValidityPeriod'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute notBeforeTime(1) with type GeneralizedTime
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_generalized_time(V1,[],[24]),

%%-------------------------------------------------
%% attribute notAfterTime(2) with type GeneralizedTime
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_generalized_time(V2,[],[24]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AttCertValidityPeriod', Term1, Term2}.



%%================================
%%  Targets
%%================================
'enc_Targets'(Val) ->
    'enc_Targets'(Val, [<<48>>]).


'enc_Targets'({'Targets',Val}, TagIn) ->
   'enc_Targets'(Val, TagIn);

'enc_Targets'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Targets_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_Targets_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Targets_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Target'(H, []),
   'enc_Targets_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Targets'(Tlv) ->
   'dec_Targets'(Tlv, [16]).

'dec_Targets'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_Target'(V1, []) || V1 <- Tlv1].




%%================================
%%  Target
%%================================
'enc_Target'(Val) ->
    'enc_Target'(Val, []).


'enc_Target'({'Target',Val}, TagIn) ->
   'enc_Target'(Val, TagIn);

'enc_Target'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      targetName ->
         'PKIX1Implicit88':'enc_GeneralName'(element(2,Val), [<<160>>]);
      targetGroup ->
         'PKIX1Implicit88':'enc_GeneralName'(element(2,Val), [<<161>>]);
      targetCert ->
         'enc_TargetCert'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_Target'(Tlv) ->
   'dec_Target'(Tlv, []).

'dec_Target'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'targetName'
    {131072, V1} -> 
        {targetName, 'PKIX1Implicit88':'dec_GeneralName'(V1, [])};


%% 'targetGroup'
    {131073, V1} -> 
        {targetGroup, 'PKIX1Implicit88':'dec_GeneralName'(V1, [])};


%% 'targetCert'
    {131074, V1} -> 
        {targetCert, 'dec_TargetCert'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  TargetCert
%%================================
'enc_TargetCert'(Val) ->
    'enc_TargetCert'(Val, [<<48>>]).

'enc_TargetCert'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute targetCertificate(1)   External PKIXAttributeCertificate:IssuerSerial
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_IssuerSerial'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute targetName(2)   External PKIX1Implicit88:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit88':'enc_GeneralName'(Cindex2, [])
       end,

%%-------------------------------------------------
%% attribute certDigestInfo(3)   External PKIXAttributeCertificate:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ObjectDigestInfo'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TargetCert'(Tlv) ->
   'dec_TargetCert'(Tlv, [16]).

'dec_TargetCert'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute targetCertificate(1)   External PKIXAttributeCertificate:IssuerSerial
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_IssuerSerial'(V1, [16]),

%%-------------------------------------------------
%% attribute targetName(2)   External PKIX1Implicit88:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {131072,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131076,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131077,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131078,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131079,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131080,_}|TempTlv3] ->
    {'PKIX1Implicit88':'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute certDigestInfo(3)   External PKIXAttributeCertificate:ObjectDigestInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_ObjectDigestInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'TargetCert', Term1, Term2, Term3}.



%%================================
%%  IetfAttrSyntax
%%================================
'enc_IetfAttrSyntax'(Val) ->
    'enc_IetfAttrSyntax'(Val, [<<48>>]).

'enc_IetfAttrSyntax'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyAuthority(1)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit88':'enc_GeneralNames'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute values(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IetfAttrSyntax_values'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IetfAttrSyntax_values
%%================================

'enc_IetfAttrSyntax_values'({'IetfAttrSyntax_values',Val}, TagIn) ->
   'enc_IetfAttrSyntax_values'(Val, TagIn);

'enc_IetfAttrSyntax_values'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_IetfAttrSyntax_values_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_IetfAttrSyntax_values_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IetfAttrSyntax_values_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IetfAttrSyntax_values_SEQOF'(H, []),
   'enc_IetfAttrSyntax_values_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  IetfAttrSyntax_values_SEQOF
%%================================

'enc_IetfAttrSyntax_values_SEQOF'({'IetfAttrSyntax_values_SEQOF',Val}, TagIn) ->
   'enc_IetfAttrSyntax_values_SEQOF'(Val, TagIn);

'enc_IetfAttrSyntax_values_SEQOF'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      octets ->
         ?RT_BER:encode_octet_string([], element(2,Val), [<<4>>]);
      oid ->
         ?RT_BER:encode_object_identifier(element(2,Val), [<<6>>]);
      string ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).


'dec_IetfAttrSyntax_values_SEQOF'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'octets'
    {4, V1} -> 
        {octets, ?RT_BER:decode_octet_string(V1,[],[])};


%% 'oid'
    {6, V1} -> 
        {oid, ?RT_BER:decode_object_identifier(V1,[])};


%% 'string'
    {12, V1} -> 
        {string, ?RT_BER:decode_UTF8_string(V1,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_IetfAttrSyntax_values'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_IetfAttrSyntax_values_SEQOF'(V1, []) || V1 <- Tlv1].




'dec_IetfAttrSyntax'(Tlv) ->
   'dec_IetfAttrSyntax'(Tlv, [16]).

'dec_IetfAttrSyntax'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute policyAuthority(1)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'PKIX1Implicit88':'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute values(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IetfAttrSyntax_values'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'IetfAttrSyntax', Term1, Term2}.



%%================================
%%  SvceAuthInfo
%%================================
'enc_SvceAuthInfo'(Val) ->
    'enc_SvceAuthInfo'(Val, [<<48>>]).

'enc_SvceAuthInfo'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute service(1)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit88':'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute ident(2)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit88':'enc_GeneralName'(Cindex2, []),

%%-------------------------------------------------
%% attribute authInfo(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], Cindex3, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SvceAuthInfo'(Tlv) ->
   'dec_SvceAuthInfo'(Tlv, [16]).

'dec_SvceAuthInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute service(1)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit88':'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute ident(2)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit88':'dec_GeneralName'(V2, []),

%%-------------------------------------------------
%% attribute authInfo(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{4,V3}|TempTlv4] ->
    {?RT_BER:decode_octet_string(V3,[],[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'SvceAuthInfo', Term1, Term2, Term3}.



%%================================
%%  RoleSyntax
%%================================
'enc_RoleSyntax'(Val) ->
    'enc_RoleSyntax'(Val, [<<48>>]).

'enc_RoleSyntax'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute roleAuthority(1)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit88':'enc_GeneralNames'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute roleName(2)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit88':'enc_GeneralName'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RoleSyntax'(Tlv) ->
   'dec_RoleSyntax'(Tlv, [16]).

'dec_RoleSyntax'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute roleAuthority(1)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'PKIX1Implicit88':'dec_GeneralNames'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute roleName(2)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit88':'dec_GeneralName'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'RoleSyntax', Term1, Term2}.



%%================================
%%  Clearance
%%================================
'enc_Clearance'(Val) ->
    'enc_Clearance'(Val, [<<48>>]).

'enc_Clearance'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case catch asn1rt_check:check_bitstring([unclassified], Cindex2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}]) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex2, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Clearance_securityCategories'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Clearance_securityCategories
%%================================

'enc_Clearance_securityCategories'({'Clearance_securityCategories',Val}, TagIn) ->
   'enc_Clearance_securityCategories'(Val, TagIn);

'enc_Clearance_securityCategories'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Clearance_securityCategories_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_Clearance_securityCategories_components'([], AccBytes, AccLen) -> 
   {asn1rt_check:dynamicsort_SETOF(AccBytes),AccLen};

'enc_Clearance_securityCategories_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SecurityCategory'(H, [<<48>>]),
   'enc_Clearance_securityCategories_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_Clearance_securityCategories'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_SecurityCategory'(V1, [16]) || V1 <- Tlv1].




'dec_Clearance'(Tlv) ->
   'dec_Clearance'(Tlv, [16]).

'dec_Clearance'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute policyId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[131072]),

%%-------------------------------------------------
%% attribute classList(2) with type BIT STRING DEFAULT = [unclassified]
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_compact_bit_string(V2,[],[{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}],[]), TempTlv3};
    _ ->
        {[unclassified],Tlv2}
end,

%%-------------------------------------------------
%% attribute securityCategories(3) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_Clearance_securityCategories'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'Clearance', Term1, Term2, Term3}.



%%================================
%%  ClassList
%%================================
'enc_ClassList'(Val) ->
    'enc_ClassList'(Val, [<<3>>]).


'enc_ClassList'({'ClassList',Val}, TagIn) ->
   'enc_ClassList'(Val, TagIn);

'enc_ClassList'(Val, TagIn) ->
?RT_BER:encode_bit_string([], Val, [{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}], TagIn).


'dec_ClassList'(Tlv) ->
   'dec_ClassList'(Tlv, [3]).

'dec_ClassList'(Tlv, TagIn) ->
?RT_BER:decode_compact_bit_string(Tlv,[],[{unmarked,0},{unclassified,1},{restricted,2},{confidential,3},{secret,4},{topSecret,5}],TagIn).



%%================================
%%  SecurityCategory
%%================================
'enc_SecurityCategory'(Val) ->
    'enc_SecurityCategory'(Val, [<<48>>]).

'enc_SecurityCategory'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SecurityCategory'(Tlv) ->
   'dec_SecurityCategory'(Tlv, [16]).

'dec_SecurityCategory'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[131072]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_open_type_as_binary(V2,[131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SecurityCategory', Term1, Term2}.



%%================================
%%  AAControls
%%================================
'enc_AAControls'(Val) ->
    'enc_AAControls'(Val, [<<48>>]).

'enc_AAControls'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute pathLenConstraint(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex1, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute permittedAttrs(2)   External PKIXAttributeCertificate:AttrSpec OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttrSpec'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute excludedAttrs(3)   External PKIXAttributeCertificate:AttrSpec OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttrSpec'(Cindex3, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute permitUnSpecified(4) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case catch asn1rt_check:check_bool(true, Cindex4) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex4, [<<1>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AAControls'(Tlv) ->
   'dec_AAControls'(Tlv, [16]).

'dec_AAControls'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute pathLenConstraint(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {?RT_BER:decode_integer(V1,{0,'MAX'},[]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute permittedAttrs(2)   External PKIXAttributeCertificate:AttrSpec OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_AttrSpec'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute excludedAttrs(3)   External PKIXAttributeCertificate:AttrSpec OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_AttrSpec'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute permitUnSpecified(4) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{1,V4}|TempTlv5] ->
    {?RT_BER:decode_boolean(V4,[]), TempTlv5};
    _ ->
        {true,Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
   {'AAControls', Term1, Term2, Term3, Term4}.



%%================================
%%  AttrSpec
%%================================
'enc_AttrSpec'(Val) ->
    'enc_AttrSpec'(Val, [<<48>>]).


'enc_AttrSpec'({'AttrSpec',Val}, TagIn) ->
   'enc_AttrSpec'(Val, TagIn);

'enc_AttrSpec'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttrSpec_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_AttrSpec_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttrSpec_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_object_identifier(H, [<<6>>]),
   'enc_AttrSpec_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_AttrSpec'(Tlv) ->
   'dec_AttrSpec'(Tlv, [16]).

'dec_AttrSpec'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_object_identifier(V1,[6]) || V1 <- Tlv1].




%%================================
%%  ACClearAttrs
%%================================
'enc_ACClearAttrs'(Val) ->
    'enc_ACClearAttrs'(Val, [<<48>>]).

'enc_ACClearAttrs'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute acIssuer(1)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit88':'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute acSerial(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_integer([], Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute attrs(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ACClearAttrs_attrs'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ACClearAttrs_attrs
%%================================

'enc_ACClearAttrs_attrs'({'ACClearAttrs_attrs',Val}, TagIn) ->
   'enc_ACClearAttrs_attrs'(Val, TagIn);

'enc_ACClearAttrs_attrs'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ACClearAttrs_attrs_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_ACClearAttrs_attrs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ACClearAttrs_attrs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit88':'enc_Attribute'(H, [<<48>>]),
   'enc_ACClearAttrs_attrs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_ACClearAttrs_attrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['PKIX1Explicit88':'dec_Attribute'(V1, [16]) || V1 <- Tlv1].




'dec_ACClearAttrs'(Tlv) ->
   'dec_ACClearAttrs'(Tlv, [16]).

'dec_ACClearAttrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute acIssuer(1)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit88':'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute acSerial(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_integer(V2,[],[2]),

%%-------------------------------------------------
%% attribute attrs(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ACClearAttrs_attrs'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'ACClearAttrs', Term1, Term2, Term3}.



%%================================
%%  ProxyInfo
%%================================
'enc_ProxyInfo'(Val) ->
    'enc_ProxyInfo'(Val, [<<48>>]).


'enc_ProxyInfo'({'ProxyInfo',Val}, TagIn) ->
   'enc_ProxyInfo'(Val, TagIn);

'enc_ProxyInfo'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ProxyInfo_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_ProxyInfo_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ProxyInfo_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Targets'(H, [<<48>>]),
   'enc_ProxyInfo_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ProxyInfo'(Tlv) ->
   'dec_ProxyInfo'(Tlv, [16]).

'dec_ProxyInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_Targets'(V1, [16]) || V1 <- Tlv1].


'id-pe-ac-auditIdentity'() ->
{1,3,6,1,5,5,7,1,4}.

'id-pe-aaControls'() ->
{1,3,6,1,5,5,7,1,6}.

'id-pe-ac-proxying'() ->
{1,3,6,1,5,5,7,1,10}.

'id-ce-targetInformation'() ->
{2,5,29,55}.

'id-aca'() ->
{1,3,6,1,5,5,7,10}.

'id-aca-authenticationInfo'() ->
{1,3,6,1,5,5,7,10,1}.

'id-aca-accessIdentity'() ->
{1,3,6,1,5,5,7,10,2}.

'id-aca-chargingIdentity'() ->
{1,3,6,1,5,5,7,10,3}.

'id-aca-group'() ->
{1,3,6,1,5,5,7,10,4}.

'id-aca-encAttrs'() ->
{1,3,6,1,5,5,7,10,6}.

'id-at-role'() ->
{2,5,4,72}.

'id-at-clearance'() ->
{2,5,1,5,55}.

