changecom(`/*', `*/')dnl
/*
 * $Id$
 */

#`include' "hipe_sparc_asm.h"
#`include' "hipe_literals.h"

/*
 * These m4 macros expand to assembly code which
 * is further processed using the C pre-processor:
 * - Expansion of symbolic names for registers and PCB fields.
 * - Conditional assembly. Some BIFs need specialised code.
 *   Instead of special-casing them in all generated BIF lists,
 *   we use #ifndef wrappers to allow hand-written code to
 *   override that generated by the standard m4 macros.
 *   This is used for:
 *   - demonitor/1, exit/2, group_leader/2, link/1, monitor/2,
 *     port_command/2, send/2, unlink/1: can fail with RESCHEDULE
 *
 * XXX: TODO:
 * - Replace "subcc ARG0,0,%g0; bz,pn" with "brz,pn ARG0"
 */

`#define TEST_GOT_MBUF		ld [P+P_MBUF],%o1; cmp %o1,0; bne 3f; nop; 2:
#define JOIN3(A,B,C)		A##B##C
#define HANDLE_GOT_MBUF		3: st TEMP3,[P+P_NRA]; st NSP,[P+P_NSP]; mov %o0,%o1; mov P,%o0; call erts_gc_after_bif_call; nop; ld [P+P_HP_LIMIT],HP_LIMIT; b 2b; nop'

/*
 * standard_bif_interface_1(nbif_name, cbif_name)
 * standard_bif_interface_2(nbif_name, cbif_name)
 * standard_bif_interface_3(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 1-3 arguments and
 * standard failure mode (may fail, but not with RESCHEDULE).
 */
define(standard_bif_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,nbif_1_simple_exception
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(standard_bif_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,nbif_2_simple_exception
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(standard_bif_interface_3,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,nbif_3_simple_exception
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * expensive_bif_interface_1(nbif_name, cbif_name)
 * expensive_bif_interface_2(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 1-2 arguments and
 * an expensive failure mode (may fail with RESCHEDULE).
 */
define(expensive_bif_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save actual parameters in case we must reschedule
	mov ARG0,TEMP1

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,1f
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
1:
	set $1,TEMP0
	b nbif_hairy_exception
	mov 1,ARG4
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(expensive_bif_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Make room for P in the first arg
	!! mov ARG1,ARG2
	!! mov ARG0,ARG1
	mov P,%o0

	!! Save actual parameters in case we must reschedule
	mov ARG0,TEMP1
	mov ARG1,TEMP2

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,1f
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
1:
	set $1,TEMP0
	b nbif_hairy_exception
	mov 2,ARG4
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * gc_nofail_primop_interface_1(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 1 argument and
 * no failure mode.
 * The BIF may do gc, so the native code heap and stack limit registers
 * will be reloaded after the call.
 */
define(gc_nofail_primop_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Save P
	!! mov ARG0,ARG1
	mov P,%o0

	!! Save registers and call the C function
	st RA,[P+P_NRA]
	st FCALLS,[P+P_FCALLS]
	st HP,[P+P_HP]
	mov RA,TEMP3
	call $2
	st NSP,[P+P_NSP]

	!! Restore registers and return
	ld [P+P_HP_LIMIT],HP_LIMIT
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * gc_bif_interface_N(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 1-2 arguments and
 * standard failure mode (may fail, but not with RESCHEDULE).
 * The BIF may do a GC, so the heap limit register is reloaded
 * after the call.
 */
define(gc_bif_interface_N,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save registers and call the C function
	st RA,[P+P_NRA]
	st FCALLS,[P+P_FCALLS]
	st HP,[P+P_HP]
	mov RA,TEMP3
	call $2
	st NSP,[P+P_NSP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	ld [P+P_HP_LIMIT],HP_LIMIT
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,nbif_2_simple_exception
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * expensive_gc_bif_interface_1(nbif_name, cbif_name)
 * expensive_gc_bif_interface_2(nbif_name, cbif_name)
 *
 * Generate native interface for a BIF with 1-2 arguments and
 * standard failure mode (may fail, but not with RESCHEDULE).
 * The BIF may do a GC, so the heap limit register is reloaded
 * after the call.
 */
define(expensive_gc_bif_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save actual parameters in case we must reschedule
	mov ARG0,TEMP1

	!! Save registers and call the C function
	st RA,[P+P_NRA]
	st FCALLS,[P+P_FCALLS]
	st HP,[P+P_HP]
	mov RA,TEMP3
	call $2
	st NSP,[P+P_NSP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	ld [P+P_HP_LIMIT],HP_LIMIT
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,1f
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
1:
	set $1,TEMP0
	b nbif_hairy_exception
	mov 1,ARG4
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(expensive_gc_bif_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Move P to the first C-arg
	mov P,%o0

	!! Save actual parameters in case we must reschedule
	mov ARG0,TEMP1
	mov ARG1,TEMP2

	!! Save registers and call the C function
	st RA,[P+P_NRA]
	st FCALLS,[P+P_FCALLS]
	st HP,[P+P_HP]
	mov RA,TEMP3
	call $2
	st NSP,[P+P_NSP]
	TEST_GOT_MBUF

	!! Restore registers and test for success/failure
	ld [P+P_HP_LIMIT],HP_LIMIT
	subcc %o0,THE_NON_VALUE,%g0
	bz,pn %icc,1f
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
1:
	set $1,TEMP0
	b nbif_hairy_exception
	mov 2,ARG4
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * nofail_primop_interface_0(nbif_name, cbif_name)
 * nofail_primop_interface_1(nbif_name, cbif_name)
 * nofail_primop_interface_2(nbif_name, cbif_name)
 * nofail_primop_interface_3(nbif_name, cbif_name)
 *
 * Generate native interface for a guard BIF with 0-3 arguments.
 * (Like standard_bif_interface without the error check at return.)
 */
define(nofail_primop_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Make room for P in the first arg
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and return
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(nofail_primop_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Make room for P in the first arg
	!! mov ARG0,ARG1
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and return
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(nofail_primop_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Make room for P in the first arg
	!! mov ARG1,ARG2
	!! mov ARG0,ARG1
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and return
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

define(nofail_primop_interface_3,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Make room for P in the first arg
	!! mov ARG1,ARG2
	!! mov ARG0,ARG1
	mov P,%o0

	!! Save registers and call the C function
	st FCALLS,[P+P_FCALLS]
	mov RA,TEMP3
	call $2
	st HP,[P+P_HP]
	TEST_GOT_MBUF

	!! Restore registers and return
	ld [P+P_FCALLS],FCALLS
	jmpl TEMP3+8,%g0
	ld [P+P_HP],HP
	HANDLE_GOT_MBUF
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * noproc_primop_interface_0(nbif_name, cbif_name)
 * noproc_primop_interface_1(nbif_name, cbif_name)
 * noproc_primop_interface_2(nbif_name, cbif_name)
 * noproc_primop_interface_3(nbif_name, cbif_name)
 * noproc_primop_interface_5(nbif_name, cbif_name)
 *
 * Generate native interface for a primop with no implicit P
 * parameter, 0-3 or 5 ordinary parameters, and no failure mode.
 * The primop cannot CONS or gc.
 */
define(noproc_primop_interface_0,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! XXX: this case is always trivial; how to suppress the branch?
	!! Perform a quick save;call;restore;ret sequence.
	b $2
	nop
	.size $1,.-$1
	.type $1,#function
#endif')

define(noproc_primop_interface_1,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Perform a quick save;call;restore;ret sequence.
	b $2
	mov ARG0,%o0
	.size $1,.-$1
	.type $1,#function
#endif')

define(noproc_primop_interface_2,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Perform a quick save;call;restore;ret sequence.
	mov ARG0,%o0
	b $2
	mov ARG1,%o1
	.size $1,.-$1
	.type $1,#function
#endif')

define(noproc_primop_interface_3,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Perform a quick save;call;restore;ret sequence.
	mov ARG0,%o0
	mov ARG1,%o1
	b $2
	mov ARG2,%o2
	.size $1,.-$1
	.type $1,#function
#endif')

define(noproc_primop_interface_5,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align 4
	.global $1
$1:
	!! Perform a quick save;call;restore;ret sequence.
	mov ARG0,%o0
	mov ARG1,%o1
	mov ARG2,%o2
	mov ARG3,%o3
	b $2
	mov ARG4,%o4
	.size $1,.-$1
	.type $1,#function
#endif')

/*
 * nocons_nofail_primop_interface_N(nbif_name, cbif_name)
 *
 * Generate native interface for a primop with implicit P
 * parameter, up to 5 ordinary parameters, and no failure mode.
 * The primop cannot CONS or gc.
 */
define(nocons_nofail_primop_interface_N,
`
#ifndef HAVE_$1
#`define' HAVE_$1
	.section ".text"
	.align	4
	.global	$1
$1:
	!! Perform a quick save;call;restore;ret sequence.
	b $2
	mov P,%o0
	.size	$1,.-$1
	.type	$1,#function
#endif')

/*
 * Implement standard_bif_interface_0 as nofail_primop_interface_0.
 */
define(standard_bif_interface_0,`nofail_primop_interface_0($1, $2)')

/*
 * Implement gc_bif_interface_0 as gc_nofail_primop_interface_1.
 * (Arities do not match, but that does not matter for SPARC.)
 */
define(gc_bif_interface_0,`gc_nofail_primop_interface_1($1, $2)')

/*
 * Implement gc_bif_interface_{1,2} as gc_bif_interface_N.
 */
define(gc_bif_interface_1,`gc_bif_interface_N($1, $2)')
define(gc_bif_interface_2,`gc_bif_interface_N($1, $2)')

/*
 * Implement nocons_nofail_primop_interface_{0,1,2,3,5}
 * as nocons_nofail_primop_interface_N.
 */
define(nocons_nofail_primop_interface_0,`nocons_nofail_primop_interface_N($1, $2)')
define(nocons_nofail_primop_interface_1,`nocons_nofail_primop_interface_N($1, $2)')
define(nocons_nofail_primop_interface_2,`nocons_nofail_primop_interface_N($1, $2)')
define(nocons_nofail_primop_interface_3,`nocons_nofail_primop_interface_N($1, $2)')
define(nocons_nofail_primop_interface_5,`nocons_nofail_primop_interface_N($1, $2)')

include(`hipe/hipe_bif_list.m4')
