/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002-2006  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <string>
extern "C" {
  #include <glib.h>
  #include <glib/gi18n.h>
};
#ifdef HAVE_GNOME
#include <libgnome/gnome-url.h>
#elif defined(G_OS_WIN32)
#define _WIN32_WINNT 0x0501
#include <windows.h>
#include <shellapi.h>
#else
#include <pan/general/debug.h>
#include <pan/general/string-view.h>
#endif
#include <pan/general/log.h>
#include "url.h"

using namespace pan;

void
pan ::  pan_url_show (const char * url)
{
  g_return_if_fail (url && *url);

  std::string tmp;
  if (!strstr (url, "://") && strstr (url, "www"))
    tmp = std::string("http://") + url;
  else if (!strstr (url, "://") && strchr (url, '@') && !strstr(url,"mailto:"))
    tmp = std::string("mailto:") + url;
  else
    tmp = url;

#ifdef HAVE_GNOME

  GError * error (0);
  gnome_url_show (tmp.c_str(), &error); 
  if (error) {
    Log::add_err (error->message);
    g_clear_error (&error);
  }

#elif defined(G_OS_WIN32)

  if ((int) ShellExecute (HWND_DESKTOP, "open", tmp.c_str(), NULL, NULL, SW_SHOWNORMAL) <= 32)
    Log::add_err_va (_("There was an error launching the default action command associated with \"%s\"."), tmp.c_str());

#else

  StringView token, browser (g_getenv ("BROWSER"));
  while (browser.pop_token (token, ':'))
  {
    std::string s (token.to_string());

    // perform BROWSER substitutions as described in http://www.catb.org/~esr/BROWSER/
    std::string::size_type pos;
    if (s.find("%s") == std::string::npos)
      s += std::string(" ") + url;
    else while (((pos = s.find ("%s"))) != std::string::npos)
      s.replace (pos, 2, url);
    while (((pos = s.find ("%%"))) != std::string::npos)
      s.replace (pos, 2, "%");

    // parse the command...
    GError * err (0);
    const bool ok (g_spawn_command_line_async (s.c_str(), &err));
    if (err != NULL) {
      Log::add_err_va (_("Error spawning browser: %s (Command was: %s)"), err->message, s.c_str());
      g_clear_error (&err);
    }

    if (ok) // this one worked!
      break;
  }

#endif
}

