/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <pan/base/pan-i18n.h>
#include <pan/dialogs/dialogs.h>
#include <pan/dialogs/pan-about.h>

static char * get_credits_code (void);
static char * get_credits_users (void);
static char * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	char * pch;
	char * credits_bugs;
	char * credits_i18n;
	char * credits_code;
	GtkWidget * about;

	about = pan_about_new (GTK_WINDOW(window),
	                       "Pan", VERSION,
	                       _("A newsreader for GNOME"),
	                       _("Copyright (C) 2002 Charles Kerr"),
	                       PAN_ABOUT_LICENSE_GPL,
	                       "http://pan.rebelbase.com/");

	pan_about_add_author (about, "Charles Kerr", "charles@rebelbase.com",
	                      _("Programmer"));
	pan_about_add_author (about, "Christophe Lambin", "clambin@easynet.be",
	                      _("Programmer"));
	pan_about_add_author (about, "Adam Huffman", "bloch@verdurin.com",
	                      _("Programmer & Documentation"));
	pan_about_add_author (about, "Matt Eagleson", "e.Messiah@superpimp.org",
	                      _("Project Originator, Programmer"));
	pan_about_add_author (about, "Jason Leach", NULL,
	                      _("Programmer, 0.6 - 0.7"));

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"
                                 "\n"
	                         "Contributors to previous versions are listed at\n"
	                         "http://pan.rebelbase.com/CREDITS"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (about, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_widget_show (about);
}


static char *
get_credits_translators (void)
{
	const char * str =
		"\n\tcs - Miloslav Trmac"
		"\n\tde - Benjamin Greiner"
		"\n\tes - Pablo Gonzalo del Campo"
		"\n\tet - Tivo Leedjrv"
		"\n\tfr - Christophe Merlet"
		"\n\tja - KAMAGASAKO Masatoshi"
		"\n\tlv - Artis Trops"
		"\n\tno - Kjartan Maraas"
		"\n\tnl - Vincent van Adrighem"
		"\n\tpl - GNOME PL Team"
		"\n\tpt - Duarte Loreto"
		"\n\tpt_BR - Evandro Fernandes Giovanini"
		"\n\tsk - Marcel Telka"
		"\n\tsv - Christian Rose"
		"\n\ttr - Arman Aksoy (Armish)";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_code (void)
{
	const char * str = 
		"\n\t";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_users (void)
{
	const char * str = 
		"\n\tBlueJAMC (#108769, #108991)"
		"\n\tBruce Bowler (#107484)"
		"\n\tBobby D. Bryant (#108592, #108593)"
		"\n\tDave C (#111432)"
		"\n\tChris Charlebois (#109274)"
		"\n\tMichael A. Chase (#111307)"
		"\n\tPetr Chloupek (#99247)"
		"\n\tStephen Cofer"
		"\n\tSimon Cooke (#107328)"
		"\n\tDuncan (#110794)"
		"\n\tJim Dutton (#104716)"
		"\n\tErik Funkenbusch (#107324)"
		"\n\tEvandro Fernandes Giovanini (#107900)"
		"\n\tLin Ford (#109271, #109273)"
		"\n\tCarl Hudkins (#107891, #107894)"
		"\n\tPaul Hudson (#109279)"
		"\n\tDave Hill (#110937, #110938)"
		"\n\tSamuli Karkkainen (#110319)"
		"\n\tPatrick Lamaiziere (#108567, #109004, #109006)"
		"\n\tTivo Leedjrv (#110478, #110491, #110967)"
		"\n\tChristian Lohmaier (#90067)"
		"\n\tEugenia Loli-Queru (#109652)"
		"\n\tPav Lucistnik (#111145)"
		"\n\tMahalo (#104479, #108057, #108489)"
		"\n\tGeorge McAllister (#109282)"
		"\n\tDonald L. McDaniel (#107302, #107519)"
		"\n\tJ. B. Moreno (#108126)"
		"\n\tBrian Morrison (#110790)"
		"\n\tChris Petersen"
		"\n\tGabriel Phoenix (#100444)"
		"\n\tJustin Piszcz (#107919)"
		"\n\tNathan Robertson (#110151)"
		"\n\tThorsten Ruffle-Brandt (#108171)"
		"\n\tJeffrey Stedfast"
		"\n\tTorstein Sunde (#107869, #107901)"
		"\n\tSal Tepedino (#98452)"
		"\n\tKetil Thorsen (#107238, #108575)"
		"\n\tTRB (#108220)"
		"\n\tJohn van der Kamp (#100651)"
		"\n\tFrederik Vanrenterghem (#103872)"
		"\n\tOlav Vitters (#110041)"
		"\n\tMichael Waters (#107113)" ;
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}
