/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2003  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __TASK_STATE__H_
#define __TASK_STATE__H_

#define TASK_STATE(a) ((TaskState *)a)


/**
 * These are the different states that can be set for a task.
 * Note that TASK_FAIL is only here because a number of low-level
 * funcs return TASK_SUCCESS, TASK_FAIL, and TASK_FAIL_HOPELESS;
 * tasks themselves should never have the state TASK_FAIL.
 * 
 * In older versions of Pan, TASK_FAIL was used to denote a temporary
 * failure due to network problems.  Tasks experiencing network problems
 * now should set themselvs to TASK_NEED_SOCKET, so they that when the
 * NNTP server is available again the queue can feed the task a socket.
 */
typedef enum
{
	TASK_SUCCESS           =  0, /* task has finished successfully */
	TASK_FAIL              = -1, /* temporary failure; ie, socket failed */
	TASK_FAIL_HOPELESS     = -2, /* permanent failure; ie, no such article */
	TASK_NEED_SOCKET       =  1, /* waiting on a socket */
	TASK_NEED_WORK         =  2, /* waiting to run */
	TASK_WORKING           =  3  /* running */
}
TaskStateEnum;

struct _Task;
struct _PanSocket;
struct _Server;

typedef void (*TaskFunc)(struct _Task*, struct _PanSocket*);

typedef struct _TaskState TaskState;

struct _TaskState
{
	struct _Server * server;
	TaskFunc func;
	TaskStateEnum state;
};

/**
***  PUBLIC 
**/

void     task_state_set                (TaskState         * task,
                                        TaskStateEnum       success_or_hopeless_or_working);

void     task_state_set_need_socket    (TaskState         * task,
                                        struct _Server    * server,
                                        TaskFunc            socket_func);

void     task_state_set_need_work      (TaskState         * task,
                                        TaskFunc            workproc);

#endif /* __SOCKET_POOL_H__ */
