/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include <time.h> /* for time_t */

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkitemfactory.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenushell.h>

#include <pan/base/pan-glib-extensions.h> /* for PRETTY_FUNCTION */

/**
***  Living with Thread in a GUI app
**/

#define pan_lock() pan_lock_from(__FILE__, PRETTY_FUNCTION, __LINE__)
void pan_lock_from (const char * file, const char * func, int line);

#define pan_unlock() pan_unlock_from(__FILE__, PRETTY_FUNCTION, __LINE__)
void pan_unlock_from (const char * file, const char * func, int line);

guint pan_timeout_add   (guint32            interval,
                         GSourceFunc        function,
                         gpointer           data);

void gui_queue_add (GSourceFunc func, gpointer user_data);

void gui_queue_init (void);

void gui_queue_shutdown (void);

/**
***  Dialogs
**/

void pan_info_dialog (const char * fmt, ...);

void pan_error_dialog (const char * fmt, ...);

void pan_error_dialog_parented (gpointer gtkwindow, const char * fmt, ...);


/**
***  Menus
**/

GtkWidget* menubar_create     (GtkWidget             * window,
                               GtkItemFactoryEntry   * entries,
                               unsigned int            entries_qty,
                               const char            * path,
                               gpointer                data);

GtkWidget* menu_create_items  (GtkItemFactoryEntry  * entries,
                               unsigned int           entries_qty,
                               const char           * path,
                               GtkItemFactory      ** factory,
                               gpointer               data);

void menu_set_sensitive       (GtkItemFactory       * ifactory,
                               const char           * path,
                               gboolean               sensitive);

void menu_set_checked         (GtkItemFactory       * ifactory,
                               const char           * path,
                               gboolean               checked);

gboolean menu_is_checked      (GtkItemFactory       * ifactory,
                               const char           * path);

/**
***  Column Widths and Window Geometry
**/

void     gui_save_column_widths               (GtkWidget    * clist,
                                               const char   * key);

void     gui_save_column_widths_tree_view     (GtkWidget    * tree_view,
                                               const char   * key);

void     gui_save_window_size                 (GtkWidget    * window,
                                               const char   * key);

void     gui_restore_column_widths            (GtkWidget    * clist,
                                               const char   * key);

void     gui_restore_column_widths_tree_view  (GtkWidget    * tree_view,
                                               const char   * key);

gboolean gui_restore_window_size              (GtkWidget    * window,
                                               const char   * key);


/**
***
**/

void launch_external_editor (const char    * edit_command,
                             const char    * filename,
                             int             line_number,
                             GSourceFunc     finished_callback,
                             gpointer        finished_user_data);


void get_date_display_string (time_t date, const char * strftime_fmt, char * buf, int size);

void pan_widget_set_font (GtkWidget* w, const char* font_name);

void pan_url_show (const char * url);

void pan_gtk_entry_set_text   (GtkWidget            * w,
                               const char           * text);


enum
{
	GUI_PAD_SMALL = 3,
	GUI_PAD = 6,
	GUI_PAD_BIG = 12,
	GUI_PAD_LARGE = 12
};

#endif /* __UTIL_H__ */
