#include <stdlib.h>

#include <string.h>

#include <glib.h>
#include <gmime/gmime.h>

#include <pan/base/article.h>
#include <pan/base/base-prefs.h>
#include <pan/base/debug.h>
#include <pan/base/group.h>
#include <pan/base/pan-glib-extensions.h>
#include <pan/base/server.h>


static void
pan_init (void)
{
	char * base;
	char * download_dir;

        g_mime_init (0);

	base = getenv ("srcdir");
	base = g_strdup_printf ("%s/", base!=NULL ? base : getenv("PWD"));
	download_dir = g_strdup_printf ("%s/data/save/", base);
	base_prefs_init (download_dir, 1000, FALSE, FALSE);
	g_free (download_dir);
	g_free (base);
}

#define check(A) \
	++test; \
	if (A) \
		g_message ("PASS article test #%d, file %s, line %d", test, __FILE__, __LINE__); \
	else { \
		g_message ("FAIL article test #%d, file %s, line %d \"%s\"", test, __FILE__, __LINE__, #A); \
		return test; \
	}

int
main (void)
{
	int test = 0;
	int article_qty = 0;
	Server * s;
	Group * g;
	Article * a;
	Article * a1;
	Article * articles [512];
	const char * cpch;
	const char * out;
	char buf[512];

	g_thread_init (NULL);
	pan_init ();

	s = server_new ();
	s->name = g_strdup ("Server");
	g = group_new (s, "alt.test");
	group_ref_articles (g, NULL);

	/* ctor sanity */
	++test;
	a1 = article_new (g);
	check (a1 != NULL)
	check (a1->part == 0)
	check (a1->parts == 0)
	check (a1->linecount == 0)
	check (a1->multipart_state == 0)
	check (a1->decode_state == 0)
	check (a1->unread_children == 0)
	check (a1->date == 0)
	check (a1->threads == NULL)
	check (a1->parent == NULL)
	check (a1->author_addr == NULL)
	check (a1->author_real == NULL)
	check (a1->subject == NULL)
	check (a1->message_id == NULL)
	check (a1->references == NULL)

	/**
	***  article_set_subject
	***  article_get_subject
	**/

	/* don't crash */
	article_set_subject (NULL, NULL);

	/* don't crash */
	article_set_subject (a1, NULL);
	check (a1->message_id == NULL)

	/* set the subject */
	cpch = "Some Subject";
	article_set_subject (a1, cpch);
	check (a1->subject != NULL)
	check (a1->subject != cpch)
	check (!pan_strcmp (a1->subject, cpch))

	/**
	*** article_set_message_id
	**/

	/* don't crash */
	article_set_message_id (NULL, NULL);
	out = article_get_message_id (NULL);
	check (!pan_strcmp (out, ""))

	/* don't crash */
	article_set_message_id (a1, NULL);
	check (a1->message_id == NULL)
	check (!pan_strcmp (article_get_message_id (a1), ""));

	/* don't crash */
	cpch = "<asdf@foo.com>";
	article_set_message_id (NULL, cpch);

	/* set the message-id */
	article_set_message_id (a1, cpch);
	check (a1->message_id != NULL)
	check (a1->message_id != cpch)
	check (!pan_strcmp(a1->message_id, cpch))

	/* this is the last step in place for article_is_valid() to pass */
	a1->number = 1;
	cpch = "<querty@foo.com>";
	article_set_message_id (a1, cpch);
	check (!pan_strcmp (article_get_message_id(a1), cpch))

	/**
	***  article_set_references
	**/

	article_set_references (NULL, NULL);
	article_set_references (a1, NULL);
	check (a1->references == NULL)
	article_set_references (a1, cpch = "<asdf@foo.com> <1434@bar.com>");
	check (a1->references != NULL)
	check (a1->references != cpch)
	check (!pan_strcmp (a1->references, cpch))

	/**
	***  article_set_xrefs
	***  article_get_crosspost_qty
	**/

	article_set_xrefs (NULL, NULL);
	check (article_get_crosspost_qty (NULL) == 0)
	article_set_xrefs (a1, NULL);
	check (a1->xref == NULL)
	check (article_get_crosspost_qty (a1) == 1)
	article_set_xrefs (a1, cpch = "servername comp.lang.c:666");
	check (a1->xref != NULL)
	check (a1->xref != cpch)
	check (!pan_strcmp (a1->xref, cpch))
	check (article_get_crosspost_qty (a1) == 1)
	article_set_xrefs (a1, cpch = "servername comp.lang.c:666 alt.fan.rubber.duckie:999");
	check (a1->xref != NULL)
	check (a1->xref != cpch)
	check (!pan_strcmp (a1->xref, cpch))
	check (article_get_crosspost_qty (a1) == 2)

	/**
	***  article_set_author
	***  article_get_author_str
	***  article_get_short_author_str
	**/

	a = a1;
	a->number = 1;
	article_set_author (a, "joe@foo.com");
	article_get_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "\"joe\" <joe@foo.com>"))
	article_get_short_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "joe"))

	article_set_author (a, "joe@foo.com (Joe Bob)");
	article_get_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "\"Joe Bob\" <joe@foo.com>"))
	article_get_short_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "Joe Bob"))

	article_set_author (a, "Joe Bob <joe@foo.com>");
	article_get_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "\"Joe Bob\" <joe@foo.com>"))
	article_get_short_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "Joe Bob"))

	article_set_author (a, "Joe Bob");
	article_get_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "\"Joe Bob\" <unknown@spammesenseless.com>"))
	article_get_short_author_str (a, buf, sizeof(buf));
	check (!pan_strcmp(buf, "Joe Bob"))

	/**
	***  articles_set_multipart_state
	***  article_get_multipart_state
	**/

	a = articles[article_qty++] = article_new (g);
	a->number = article_qty;
	article_set_message_id (a, "<213.214.242.41.21@foo.com>");
	article_set_subject (a, "Me and the Major");

	a = articles[article_qty++] = article_new (g);
	a->number = article_qty;
	article_set_message_id (a, "<213.214.242.41.21@foo.com>");
	article_set_subject (a, "Like Dylan in the Movies");

	articles_set_multipart_state (articles, 0, MULTIPART_STATE_SOME);
	articles_set_multipart_state (NULL, 0, MULTIPART_STATE_SOME);
	articles_set_multipart_state (NULL, article_qty, MULTIPART_STATE_SOME);
	articles_set_multipart_state (NULL, article_qty, ~0);

	articles_set_multipart_state (articles, article_qty, MULTIPART_STATE_SOME);
	check (article_get_multipart_state (articles[0]) == MULTIPART_STATE_SOME)
	check (article_get_multipart_state (articles[1]) == MULTIPART_STATE_SOME)

	articles_set_multipart_state (articles, article_qty, MULTIPART_STATE_ALL);
	check (article_get_multipart_state (articles[0]) == MULTIPART_STATE_ALL)
	check (article_get_multipart_state (articles[1]) == MULTIPART_STATE_ALL)

	articles_set_multipart_state (articles, article_qty, MULTIPART_STATE_NONE);
	check (article_get_multipart_state (articles[0]) == MULTIPART_STATE_NONE)
	check (article_get_multipart_state (articles[1]) == MULTIPART_STATE_NONE)

	/**
	***  article_get_decode_state
	***  articles_set_decode_state
	**/

	articles_set_decode_state (articles, 0, DECODE_STATE_NONE);
	articles_set_decode_state (NULL, 0, DECODE_STATE_NONE);
	articles_set_decode_state (NULL, article_qty, DECODE_STATE_NONE);
	articles_set_decode_state (NULL, article_qty, ~0);

	articles_set_decode_state (articles, article_qty, DECODE_STATE_NONE);
	check (article_get_decode_state (articles[0]) == DECODE_STATE_NONE)
	check (article_get_decode_state (articles[1]) == DECODE_STATE_NONE)

	articles_set_decode_state (articles, article_qty, DECODE_STATE_FAILED);
	check (article_get_decode_state (articles[0]) == DECODE_STATE_FAILED)
	check (article_get_decode_state (articles[1]) == DECODE_STATE_FAILED)

	articles_set_decode_state (articles, article_qty, DECODE_STATE_DECODED);
	check (article_get_decode_state (articles[0]) == DECODE_STATE_DECODED)
	check (article_get_decode_state (articles[1]) == DECODE_STATE_DECODED)


	/* success */
	g_message ("All article tests passed");
	return 0;
}
