# 1 "src/Text/Pandoc/Data.hsb"
{-# LANGUAGE OverloadedStrings #-}
-- to be processed using hsb2hs
module Text.Pandoc.Data (dataFiles) where
import qualified Data.ByteString as B

dataFiles :: [(FilePath, B.ByteString)]
dataFiles = [("epub.css","/* This defines styles and classes used in the book */\nbody { margin: 5%; text-align: justify; font-size: medium; }\ncode { font-family: monospace; }\nh1 { text-align: left; }\nh2 { text-align: left; }\nh3 { text-align: left; }\nh4 { text-align: left; }\nh5 { text-align: left; }\nh6 { text-align: left; }\nh1.title { }\nh2.author { }\nh3.date { }\nol.toc { padding: 0; margin-left: 1em; }\nol.toc li { list-style-type: none; margin: 0; padding: 0; }\n"),("LaTeXMathML.js","/*\nLaTeXMathML.js from http://math.etsu.edu/LaTeXMathML/\nAdapted by Jeff Knisely and Douglas Woodall from ASCIIMathML.js v. 1.4.7,\n(c) 2005 Peter Jipsen http://www.chapman.edu/~jipsen.\nReleased under the GNU General Public License version 2 or later.\nSee the GNU General Public License (at http://www.gnu.org/copyleft/gpl.html)\nfor more details.\n*/\nvar checkForMathML=true;var notifyIfNoMathML=true;var alertIfNoMathML=false;var mathcolor=\"\";var mathfontfamily=\"\";var showasciiformulaonhover=true;var isIE=document.createElementNS==null;if(document.getElementById==null)\nalert(\"This webpage requires a recent browser such as \\nMozilla/Netscape 7+ or Internet Explorer 6+MathPlayer\")\nfunction AMcreateElementXHTML(t){if(isIE)return document.createElement(t);else return document.createElementNS(\"http://www.w3.org/1999/xhtml\",t);}\nfunction AMnoMathMLNote(){var nd=AMcreateElementXHTML(\"h3\");nd.setAttribute(\"align\",\"center\")\nnd.appendChild(AMcreateElementXHTML(\"p\"));nd.appendChild(document.createTextNode(\"To view the \"));var an=AMcreateElementXHTML(\"a\");an.appendChild(document.createTextNode(\"LaTeXMathML\"));an.setAttribute(\"href\",\"http://www.maths.nott.ac.uk/personal/drw/lm.html\");nd.appendChild(an);nd.appendChild(document.createTextNode(\" notation use Internet Explorer 6+\"));an=AMcreateElementXHTML(\"a\");an.appendChild(document.createTextNode(\"MathPlayer\"));an.setAttribute(\"href\",\"http://www.dessci.com/en/products/mathplayer/download.htm\");nd.appendChild(an);nd.appendChild(document.createTextNode(\" or Netscape/Mozilla/Firefox\"));nd.appendChild(AMcreateElementXHTML(\"p\"));return nd;}\nfunction AMisMathMLavailable(){if(navigator.appName.slice(0,8)==\"Netscape\")\nif(navigator.appVersion.slice(0,1)>=\"5\")return null;else return AMnoMathMLNote();else if(navigator.appName.slice(0,9)==\"Microsoft\")\ntry{var ActiveX=new ActiveXObject(\"MathPlayer.Factory.1\");return null;}catch(e){return AMnoMathMLNote();}\nelse return AMnoMathMLNote();}\nvar AMcal=[0xEF35,0x212C,0xEF36,0xEF37,0x2130,0x2131,0xEF38,0x210B,0x2110,0xEF39,0xEF3A,0x2112,0x2133,0xEF3B,0xEF3C,0xEF3D,0xEF3E,0x211B,0xEF3F,0xEF40,0xEF41,0xEF42,0xEF43,0xEF44,0xEF45,0xEF46];var AMfrk=[0xEF5D,0xEF5E,0x212D,0xEF5F,0xEF60,0xEF61,0xEF62,0x210C,0x2111,0xEF63,0xEF64,0xEF65,0xEF66,0xEF67,0xEF68,0xEF69,0xEF6A,0x211C,0xEF6B,0xEF6C,0xEF6D,0xEF6E,0xEF6F,0xEF70,0xEF71,0x2128];var AMbbb=[0xEF8C,0xEF8D,0x2102,0xEF8E,0xEF8F,0xEF90,0xEF91,0x210D,0xEF92,0xEF93,0xEF94,0xEF95,0xEF96,0x2115,0xEF97,0x2119,0x211A,0x211D,0xEF98,0xEF99,0xEF9A,0xEF9B,0xEF9C,0xEF9D,0xEF9E,0x2124];var CONST=0,UNARY=1,BINARY=2,INFIX=3,LEFTBRACKET=4,RIGHTBRACKET=5,SPACE=6,UNDEROVER=7,DEFINITION=8,TEXT=9,BIG=10,LONG=11,STRETCHY=12,MATRIX=13;var AMsqrt={input:\"\\\\sqrt\",tag:\"msqrt\",output:\"sqrt\",ttype:UNARY},AMroot={input:\"\\\\root\",tag:\"mroot\",output:\"root\",ttype:BINARY},AMfrac={input:\"\\\\frac\",tag:\"mfrac\",output:\"/\",ttype:BINARY},AMover={input:\"\\\\stackrel\",tag:\"mover\",output:\"stackrel\",ttype:BINARY},AMatop={input:\"\\\\atop\",tag:\"mfrac\",output:\"\",ttype:INFIX},AMchoose={input:\"\\\\choose\",tag:\"mfrac\",output:\"\",ttype:INFIX},AMsub={input:\"_\",tag:\"msub\",output:\"_\",ttype:INFIX},AMsup={input:\"^\",tag:\"msup\",output:\"^\",ttype:INFIX},AMtext={input:\"\\\\mathrm\",tag:\"mtext\",output:\"text\",ttype:TEXT},AMmbox={input:\"\\\\mbox\",tag:\"mtext\",output:\"mbox\",ttype:TEXT};var AMsymbols=[{input:\"\\\\alpha\",tag:\"mi\",output:\"\\u03B1\",ttype:CONST},{input:\"\\\\beta\",tag:\"mi\",output:\"\\u03B2\",ttype:CONST},{input:\"\\\\gamma\",tag:\"mi\",output:\"\\u03B3\",ttype:CONST},{input:\"\\\\delta\",tag:\"mi\",output:\"\\u03B4\",ttype:CONST},{input:\"\\\\epsilon\",tag:\"mi\",output:\"\\u03B5\",ttype:CONST},{input:\"\\\\varepsilon\",tag:\"mi\",output:\"\\u025B\",ttype:CONST},{input:\"\\\\zeta\",tag:\"mi\",output:\"\\u03B6\",ttype:CONST},{input:\"\\\\eta\",tag:\"mi\",output:\"\\u03B7\",ttype:CONST},{input:\"\\\\theta\",tag:\"mi\",output:\"\\u03B8\",ttype:CONST},{input:\"\\\\vartheta\",tag:\"mi\",output:\"\\u03D1\",ttype:CONST},{input:\"\\\\iota\",tag:\"mi\",output:\"\\u03B9\",ttype:CONST},{input:\"\\\\kappa\",tag:\"mi\",output:\"\\u03BA\",ttype:CONST},{input:\"\\\\lambda\",tag:\"mi\",output:\"\\u03BB\",ttype:CONST},{input:\"\\\\mu\",tag:\"mi\",output:\"\\u03BC\",ttype:CONST},{input:\"\\\\nu\",tag:\"mi\",output:\"\\u03BD\",ttype:CONST},{input:\"\\\\xi\",tag:\"mi\",output:\"\\u03BE\",ttype:CONST},{input:\"\\\\pi\",tag:\"mi\",output:\"\\u03C0\",ttype:CONST},{input:\"\\\\varpi\",tag:\"mi\",output:\"\\u03D6\",ttype:CONST},{input:\"\\\\rho\",tag:\"mi\",output:\"\\u03C1\",ttype:CONST},{input:\"\\\\varrho\",tag:\"mi\",output:\"\\u03F1\",ttype:CONST},{input:\"\\\\varsigma\",tag:\"mi\",output:\"\\u03C2\",ttype:CONST},{input:\"\\\\sigma\",tag:\"mi\",output:\"\\u03C3\",ttype:CONST},{input:\"\\\\tau\",tag:\"mi\",output:\"\\u03C4\",ttype:CONST},{input:\"\\\\upsilon\",tag:\"mi\",output:\"\\u03C5\",ttype:CONST},{input:\"\\\\phi\",tag:\"mi\",output:\"\\u03C6\",ttype:CONST},{input:\"\\\\varphi\",tag:\"mi\",output:\"\\u03D5\",ttype:CONST},{input:\"\\\\chi\",tag:\"mi\",output:\"\\u03C7\",ttype:CONST},{input:\"\\\\psi\",tag:\"mi\",output:\"\\u03C8\",ttype:CONST},{input:\"\\\\omega\",tag:\"mi\",output:\"\\u03C9\",ttype:CONST},{input:\"\\\\Gamma\",tag:\"mo\",output:\"\\u0393\",ttype:CONST},{input:\"\\\\Delta\",tag:\"mo\",output:\"\\u0394\",ttype:CONST},{input:\"\\\\Theta\",tag:\"mo\",output:\"\\u0398\",ttype:CONST},{input:\"\\\\Lambda\",tag:\"mo\",output:\"\\u039B\",ttype:CONST},{input:\"\\\\Xi\",tag:\"mo\",output:\"\\u039E\",ttype:CONST},{input:\"\\\\Pi\",tag:\"mo\",output:\"\\u03A0\",ttype:CONST},{input:\"\\\\Sigma\",tag:\"mo\",output:\"\\u03A3\",ttype:CONST},{input:\"\\\\Upsilon\",tag:\"mo\",output:\"\\u03A5\",ttype:CONST},{input:\"\\\\Phi\",tag:\"mo\",output:\"\\u03A6\",ttype:CONST},{input:\"\\\\Psi\",tag:\"mo\",output:\"\\u03A8\",ttype:CONST},{input:\"\\\\Omega\",tag:\"mo\",output:\"\\u03A9\",ttype:CONST},{input:\"\\\\frac12\",tag:\"mo\",output:\"\\u00BD\",ttype:CONST},{input:\"\\\\frac14\",tag:\"mo\",output:\"\\u00BC\",ttype:CONST},{input:\"\\\\frac34\",tag:\"mo\",output:\"\\u00BE\",ttype:CONST},{input:\"\\\\frac13\",tag:\"mo\",output:\"\\u2153\",ttype:CONST},{input:\"\\\\frac23\",tag:\"mo\",output:\"\\u2154\",ttype:CONST},{input:\"\\\\frac15\",tag:\"mo\",output:\"\\u2155\",ttype:CONST},{input:\"\\\\frac25\",tag:\"mo\",output:\"\\u2156\",ttype:CONST},{input:\"\\\\frac35\",tag:\"mo\",output:\"\\u2157\",ttype:CONST},{input:\"\\\\frac45\",tag:\"mo\",output:\"\\u2158\",ttype:CONST},{input:\"\\\\frac16\",tag:\"mo\",output:\"\\u2159\",ttype:CONST},{input:\"\\\\frac56\",tag:\"mo\",output:\"\\u215A\",ttype:CONST},{input:\"\\\\frac18\",tag:\"mo\",output:\"\\u215B\",ttype:CONST},{input:\"\\\\frac38\",tag:\"mo\",output:\"\\u215C\",ttype:CONST},{input:\"\\\\frac58\",tag:\"mo\",output:\"\\u215D\",ttype:CONST},{input:\"\\\\frac78\",tag:\"mo\",output:\"\\u215E\",ttype:CONST},{input:\"\\\\pm\",tag:\"mo\",output:\"\\u00B1\",ttype:CONST},{input:\"\\\\mp\",tag:\"mo\",output:\"\\u2213\",ttype:CONST},{input:\"\\\\triangleleft\",tag:\"mo\",output:\"\\u22B2\",ttype:CONST},{input:\"\\\\triangleright\",tag:\"mo\",output:\"\\u22B3\",ttype:CONST},{input:\"\\\\cdot\",tag:\"mo\",output:\"\\u22C5\",ttype:CONST},{input:\"\\\\star\",tag:\"mo\",output:\"\\u22C6\",ttype:CONST},{input:\"\\\\ast\",tag:\"mo\",output:\"\\u002A\",ttype:CONST},{input:\"\\\\times\",tag:\"mo\",output:\"\\u00D7\",ttype:CONST},{input:\"\\\\div\",tag:\"mo\",output:\"\\u00F7\",ttype:CONST},{input:\"\\\\circ\",tag:\"mo\",output:\"\\u2218\",ttype:CONST},{input:\"\\\\bullet\",tag:\"mo\",output:\"\\u2022\",ttype:CONST},{input:\"\\\\oplus\",tag:\"mo\",output:\"\\u2295\",ttype:CONST},{input:\"\\\\ominus\",tag:\"mo\",output:\"\\u2296\",ttype:CONST},{input:\"\\\\otimes\",tag:\"mo\",output:\"\\u2297\",ttype:CONST},{input:\"\\\\bigcirc\",tag:\"mo\",output:\"\\u25CB\",ttype:CONST},{input:\"\\\\oslash\",tag:\"mo\",output:\"\\u2298\",ttype:CONST},{input:\"\\\\odot\",tag:\"mo\",output:\"\\u2299\",ttype:CONST},{input:\"\\\\land\",tag:\"mo\",output:\"\\u2227\",ttype:CONST},{input:\"\\\\wedge\",tag:\"mo\",output:\"\\u2227\",ttype:CONST},{input:\"\\\\lor\",tag:\"mo\",output:\"\\u2228\",ttype:CONST},{input:\"\\\\vee\",tag:\"mo\",output:\"\\u2228\",ttype:CONST},{input:\"\\\\cap\",tag:\"mo\",output:\"\\u2229\",ttype:CONST},{input:\"\\\\cup\",tag:\"mo\",output:\"\\u222A\",ttype:CONST},{input:\"\\\\sqcap\",tag:\"mo\",output:\"\\u2293\",ttype:CONST},{input:\"\\\\sqcup\",tag:\"mo\",output:\"\\u2294\",ttype:CONST},{input:\"\\\\uplus\",tag:\"mo\",output:\"\\u228E\",ttype:CONST},{input:\"\\\\amalg\",tag:\"mo\",output:\"\\u2210\",ttype:CONST},{input:\"\\\\bigtriangleup\",tag:\"mo\",output:\"\\u25B3\",ttype:CONST},{input:\"\\\\bigtriangledown\",tag:\"mo\",output:\"\\u25BD\",ttype:CONST},{input:\"\\\\dag\",tag:\"mo\",output:\"\\u2020\",ttype:CONST},{input:\"\\\\dagger\",tag:\"mo\",output:\"\\u2020\",ttype:CONST},{input:\"\\\\ddag\",tag:\"mo\",output:\"\\u2021\",ttype:CONST},{input:\"\\\\ddagger\",tag:\"mo\",output:\"\\u2021\",ttype:CONST},{input:\"\\\\lhd\",tag:\"mo\",output:\"\\u22B2\",ttype:CONST},{input:\"\\\\rhd\",tag:\"mo\",output:\"\\u22B3\",ttype:CONST},{input:\"\\\\unlhd\",tag:\"mo\",output:\"\\u22B4\",ttype:CONST},{input:\"\\\\unrhd\",tag:\"mo\",output:\"\\u22B5\",ttype:CONST},{input:\"\\\\sum\",tag:\"mo\",output:\"\\u2211\",ttype:UNDEROVER},{input:\"\\\\prod\",tag:\"mo\",output:\"\\u220F\",ttype:UNDEROVER},{input:\"\\\\bigcap\",tag:\"mo\",output:\"\\u22C2\",ttype:UNDEROVER},{input:\"\\\\bigcup\",tag:\"mo\",output:\"\\u22C3\",ttype:UNDEROVER},{input:\"\\\\bigwedge\",tag:\"mo\",output:\"\\u22C0\",ttype:UNDEROVER},{input:\"\\\\bigvee\",tag:\"mo\",output:\"\\u22C1\",ttype:UNDEROVER},{input:\"\\\\bigsqcap\",tag:\"mo\",output:\"\\u2A05\",ttype:UNDEROVER},{input:\"\\\\bigsqcup\",tag:\"mo\",output:\"\\u2A06\",ttype:UNDEROVER},{input:\"\\\\coprod\",tag:\"mo\",output:\"\\u2210\",ttype:UNDEROVER},{input:\"\\\\bigoplus\",tag:\"mo\",output:\"\\u2A01\",ttype:UNDEROVER},{input:\"\\\\bigotimes\",tag:\"mo\",output:\"\\u2A02\",ttype:UNDEROVER},{input:\"\\\\bigodot\",tag:\"mo\",output:\"\\u2A00\",ttype:UNDEROVER},{input:\"\\\\biguplus\",tag:\"mo\",output:\"\\u2A04\",ttype:UNDEROVER},{input:\"\\\\int\",tag:\"mo\",output:\"\\u222B\",ttype:CONST},{input:\"\\\\oint\",tag:\"mo\",output:\"\\u222E\",ttype:CONST},{input:\":=\",tag:\"mo\",output:\":=\",ttype:CONST},{input:\"\\\\lt\",tag:\"mo\",output:\"<\",ttype:CONST},{input:\"\\\\gt\",tag:\"mo\",output:\">\",ttype:CONST},{input:\"\\\\ne\",tag:\"mo\",output:\"\\u2260\",ttype:CONST},{input:\"\\\\neq\",tag:\"mo\",output:\"\\u2260\",ttype:CONST},{input:\"\\\\le\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\leq\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\leqslant\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\ge\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\geq\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\geqslant\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\equiv\",tag:\"mo\",output:\"\\u2261\",ttype:CONST},{input:\"\\\\ll\",tag:\"mo\",output:\"\\u226A\",ttype:CONST},{input:\"\\\\gg\",tag:\"mo\",output:\"\\u226B\",ttype:CONST},{input:\"\\\\doteq\",tag:\"mo\",output:\"\\u2250\",ttype:CONST},{input:\"\\\\prec\",tag:\"mo\",output:\"\\u227A\",ttype:CONST},{input:\"\\\\succ\",tag:\"mo\",output:\"\\u227B\",ttype:CONST},{input:\"\\\\preceq\",tag:\"mo\",output:\"\\u227C\",ttype:CONST},{input:\"\\\\succeq\",tag:\"mo\",output:\"\\u227D\",ttype:CONST},{input:\"\\\\subset\",tag:\"mo\",output:\"\\u2282\",ttype:CONST},{input:\"\\\\supset\",tag:\"mo\",output:\"\\u2283\",ttype:CONST},{input:\"\\\\subseteq\",tag:\"mo\",output:\"\\u2286\",ttype:CONST},{input:\"\\\\supseteq\",tag:\"mo\",output:\"\\u2287\",ttype:CONST},{input:\"\\\\sqsubset\",tag:\"mo\",output:\"\\u228F\",ttype:CONST},{input:\"\\\\sqsupset\",tag:\"mo\",output:\"\\u2290\",ttype:CONST},{input:\"\\\\sqsubseteq\",tag:\"mo\",output:\"\\u2291\",ttype:CONST},{input:\"\\\\sqsupseteq\",tag:\"mo\",output:\"\\u2292\",ttype:CONST},{input:\"\\\\sim\",tag:\"mo\",output:\"\\u223C\",ttype:CONST},{input:\"\\\\simeq\",tag:\"mo\",output:\"\\u2243\",ttype:CONST},{input:\"\\\\approx\",tag:\"mo\",output:\"\\u2248\",ttype:CONST},{input:\"\\\\cong\",tag:\"mo\",output:\"\\u2245\",ttype:CONST},{input:\"\\\\Join\",tag:\"mo\",output:\"\\u22C8\",ttype:CONST},{input:\"\\\\bowtie\",tag:\"mo\",output:\"\\u22C8\",ttype:CONST},{input:\"\\\\in\",tag:\"mo\",output:\"\\u2208\",ttype:CONST},{input:\"\\\\ni\",tag:\"mo\",output:\"\\u220B\",ttype:CONST},{input:\"\\\\owns\",tag:\"mo\",output:\"\\u220B\",ttype:CONST},{input:\"\\\\propto\",tag:\"mo\",output:\"\\u221D\",ttype:CONST},{input:\"\\\\vdash\",tag:\"mo\",output:\"\\u22A2\",ttype:CONST},{input:\"\\\\dashv\",tag:\"mo\",output:\"\\u22A3\",ttype:CONST},{input:\"\\\\models\",tag:\"mo\",output:\"\\u22A8\",ttype:CONST},{input:\"\\\\perp\",tag:\"mo\",output:\"\\u22A5\",ttype:CONST},{input:\"\\\\smile\",tag:\"mo\",output:\"\\u2323\",ttype:CONST},{input:\"\\\\frown\",tag:\"mo\",output:\"\\u2322\",ttype:CONST},{input:\"\\\\asymp\",tag:\"mo\",output:\"\\u224D\",ttype:CONST},{input:\"\\\\notin\",tag:\"mo\",output:\"\\u2209\",ttype:CONST},{input:\"\\\\begin{eqnarray}\",output:\"X\",ttype:MATRIX,invisible:true},{input:\"\\\\begin{array}\",output:\"X\",ttype:MATRIX,invisible:true},{input:\"\\\\\\\\\",output:\"}&{\",ttype:DEFINITION},{input:\"\\\\end{eqnarray}\",output:\"}}\",ttype:DEFINITION},{input:\"\\\\end{array}\",output:\"}}\",ttype:DEFINITION},{input:\"\\\\big\",tag:\"mo\",output:\"X\",atval:\"1.2\",ieval:\"2.2\",ttype:BIG},{input:\"\\\\Big\",tag:\"mo\",output:\"X\",atval:\"1.6\",ieval:\"2.6\",ttype:BIG},{input:\"\\\\bigg\",tag:\"mo\",output:\"X\",atval:\"2.2\",ieval:\"3.2\",ttype:BIG},{input:\"\\\\Bigg\",tag:\"mo\",output:\"X\",atval:\"2.9\",ieval:\"3.9\",ttype:BIG},{input:\"\\\\left\",tag:\"mo\",output:\"X\",ttype:LEFTBRACKET},{input:\"\\\\right\",tag:\"mo\",output:\"X\",ttype:RIGHTBRACKET},{input:\"{\",output:\"{\",ttype:LEFTBRACKET,invisible:true},{input:\"}\",output:\"}\",ttype:RIGHTBRACKET,invisible:true},{input:\"(\",tag:\"mo\",output:\"(\",atval:\"1\",ttype:STRETCHY},{input:\"[\",tag:\"mo\",output:\"[\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lbrack\",tag:\"mo\",output:\"[\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\{\",tag:\"mo\",output:\"{\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lbrace\",tag:\"mo\",output:\"{\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\langle\",tag:\"mo\",output:\"\\u2329\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lfloor\",tag:\"mo\",output:\"\\u230A\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lceil\",tag:\"mo\",output:\"\\u2308\",atval:\"1\",ttype:STRETCHY},{input:\")\",tag:\"mo\",output:\")\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"]\",tag:\"mo\",output:\"]\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rbrack\",tag:\"mo\",output:\"]\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\}\",tag:\"mo\",output:\"}\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rbrace\",tag:\"mo\",output:\"}\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rangle\",tag:\"mo\",output:\"\\u232A\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rfloor\",tag:\"mo\",output:\"\\u230B\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rceil\",tag:\"mo\",output:\"\\u2309\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"|\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\|\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\vert\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\Vert\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\mid\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\parallel\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"/\",tag:\"mo\",output:\"/\",atval:\"1.01\",ttype:STRETCHY},{input:\"\\\\backslash\",tag:\"mo\",output:\"\\u2216\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\setminus\",tag:\"mo\",output:\"\\\\\",ttype:CONST},{input:\"\\\\!\",tag:\"mspace\",atname:\"width\",atval:\"-0.167em\",ttype:SPACE},{input:\"\\\\,\",tag:\"mspace\",atname:\"width\",atval:\"0.167em\",ttype:SPACE},{input:\"\\\\>\",tag:\"mspace\",atname:\"width\",atval:\"0.222em\",ttype:SPACE},{input:\"\\\\:\",tag:\"mspace\",atname:\"width\",atval:\"0.222em\",ttype:SPACE},{input:\"\\\\;\",tag:\"mspace\",atname:\"width\",atval:\"0.278em\",ttype:SPACE},{input:\"~\",tag:\"mspace\",atname:\"width\",atval:\"0.333em\",ttype:SPACE},{input:\"\\\\quad\",tag:\"mspace\",atname:\"width\",atval:\"1em\",ttype:SPACE},{input:\"\\\\qquad\",tag:\"mspace\",atname:\"width\",atval:\"2em\",ttype:SPACE},{input:\"\\\\prime\",tag:\"mo\",output:\"\\u2032\",ttype:CONST},{input:\"'\",tag:\"mo\",output:\"\\u02B9\",ttype:CONST},{input:\"''\",tag:\"mo\",output:\"\\u02BA\",ttype:CONST},{input:\"'''\",tag:\"mo\",output:\"\\u2034\",ttype:CONST},{input:\"''''\",tag:\"mo\",output:\"\\u2057\",ttype:CONST},{input:\"\\\\ldots\",tag:\"mo\",output:\"\\u2026\",ttype:CONST},{input:\"\\\\cdots\",tag:\"mo\",output:\"\\u22EF\",ttype:CONST},{input:\"\\\\vdots\",tag:\"mo\",output:\"\\u22EE\",ttype:CONST},{input:\"\\\\ddots\",tag:\"mo\",output:\"\\u22F1\",ttype:CONST},{input:\"\\\\forall\",tag:\"mo\",output:\"\\u2200\",ttype:CONST},{input:\"\\\\exists\",tag:\"mo\",output:\"\\u2203\",ttype:CONST},{input:\"\\\\Re\",tag:\"mo\",output:\"\\u211C\",ttype:CONST},{input:\"\\\\Im\",tag:\"mo\",output:\"\\u2111\",ttype:CONST},{input:\"\\\\aleph\",tag:\"mo\",output:\"\\u2135\",ttype:CONST},{input:\"\\\\hbar\",tag:\"mo\",output:\"\\u210F\",ttype:CONST},{input:\"\\\\ell\",tag:\"mo\",output:\"\\u2113\",ttype:CONST},{input:\"\\\\wp\",tag:\"mo\",output:\"\\u2118\",ttype:CONST},{input:\"\\\\emptyset\",tag:\"mo\",output:\"\\u2205\",ttype:CONST},{input:\"\\\\infty\",tag:\"mo\",output:\"\\u221E\",ttype:CONST},{input:\"\\\\surd\",tag:\"mo\",output:\"\\\\sqrt{}\",ttype:DEFINITION},{input:\"\\\\partial\",tag:\"mo\",output:\"\\u2202\",ttype:CONST},{input:\"\\\\nabla\",tag:\"mo\",output:\"\\u2207\",ttype:CONST},{input:\"\\\\triangle\",tag:\"mo\",output:\"\\u25B3\",ttype:CONST},{input:\"\\\\therefore\",tag:\"mo\",output:\"\\u2234\",ttype:CONST},{input:\"\\\\angle\",tag:\"mo\",output:\"\\u2220\",ttype:CONST},{input:\"\\\\diamond\",tag:\"mo\",output:\"\\u22C4\",ttype:CONST},{input:\"\\\\Diamond\",tag:\"mo\",output:\"\\u25C7\",ttype:CONST},{input:\"\\\\neg\",tag:\"mo\",output:\"\\u00AC\",ttype:CONST},{input:\"\\\\lnot\",tag:\"mo\",output:\"\\u00AC\",ttype:CONST},{input:\"\\\\bot\",tag:\"mo\",output:\"\\u22A5\",ttype:CONST},{input:\"\\\\top\",tag:\"mo\",output:\"\\u22A4\",ttype:CONST},{input:\"\\\\square\",tag:\"mo\",output:\"\\u25AB\",ttype:CONST},{input:\"\\\\Box\",tag:\"mo\",output:\"\\u25A1\",ttype:CONST},{input:\"\\\\wr\",tag:\"mo\",output:\"\\u2240\",ttype:CONST},{input:\"\\\\arccos\",tag:\"mi\",output:\"arccos\",ttype:UNARY,func:true},{input:\"\\\\arcsin\",tag:\"mi\",output:\"arcsin\",ttype:UNARY,func:true},{input:\"\\\\arctan\",tag:\"mi\",output:\"arctan\",ttype:UNARY,func:true},{input:\"\\\\arg\",tag:\"mi\",output:\"arg\",ttype:UNARY,func:true},{input:\"\\\\cos\",tag:\"mi\",output:\"cos\",ttype:UNARY,func:true},{input:\"\\\\cosh\",tag:\"mi\",output:\"cosh\",ttype:UNARY,func:true},{input:\"\\\\cot\",tag:\"mi\",output:\"cot\",ttype:UNARY,func:true},{input:\"\\\\coth\",tag:\"mi\",output:\"coth\",ttype:UNARY,func:true},{input:\"\\\\csc\",tag:\"mi\",output:\"csc\",ttype:UNARY,func:true},{input:\"\\\\deg\",tag:\"mi\",output:\"deg\",ttype:UNARY,func:true},{input:\"\\\\det\",tag:\"mi\",output:\"det\",ttype:UNARY,func:true},{input:\"\\\\dim\",tag:\"mi\",output:\"dim\",ttype:UNARY,func:true},{input:\"\\\\exp\",tag:\"mi\",output:\"exp\",ttype:UNARY,func:true},{input:\"\\\\gcd\",tag:\"mi\",output:\"gcd\",ttype:UNARY,func:true},{input:\"\\\\hom\",tag:\"mi\",output:\"hom\",ttype:UNARY,func:true},{input:\"\\\\inf\",tag:\"mo\",output:\"inf\",ttype:UNDEROVER},{input:\"\\\\ker\",tag:\"mi\",output:\"ker\",ttype:UNARY,func:true},{input:\"\\\\lg\",tag:\"mi\",output:\"lg\",ttype:UNARY,func:true},{input:\"\\\\lim\",tag:\"mo\",output:\"lim\",ttype:UNDEROVER},{input:\"\\\\liminf\",tag:\"mo\",output:\"liminf\",ttype:UNDEROVER},{input:\"\\\\limsup\",tag:\"mo\",output:\"limsup\",ttype:UNDEROVER},{input:\"\\\\ln\",tag:\"mi\",output:\"ln\",ttype:UNARY,func:true},{input:\"\\\\log\",tag:\"mi\",output:\"log\",ttype:UNARY,func:true},{input:\"\\\\max\",tag:\"mo\",output:\"max\",ttype:UNDEROVER},{input:\"\\\\min\",tag:\"mo\",output:\"min\",ttype:UNDEROVER},{input:\"\\\\Pr\",tag:\"mi\",output:\"Pr\",ttype:UNARY,func:true},{input:\"\\\\sec\",tag:\"mi\",output:\"sec\",ttype:UNARY,func:true},{input:\"\\\\sin\",tag:\"mi\",output:\"sin\",ttype:UNARY,func:true},{input:\"\\\\sinh\",tag:\"mi\",output:\"sinh\",ttype:UNARY,func:true},{input:\"\\\\sup\",tag:\"mo\",output:\"sup\",ttype:UNDEROVER},{input:\"\\\\tan\",tag:\"mi\",output:\"tan\",ttype:UNARY,func:true},{input:\"\\\\tanh\",tag:\"mi\",output:\"tanh\",ttype:UNARY,func:true},{input:\"\\\\gets\",tag:\"mo\",output:\"\\u2190\",ttype:CONST},{input:\"\\\\leftarrow\",tag:\"mo\",output:\"\\u2190\",ttype:CONST},{input:\"\\\\to\",tag:\"mo\",output:\"\\u2192\",ttype:CONST},{input:\"\\\\rightarrow\",tag:\"mo\",output:\"\\u2192\",ttype:CONST},{input:\"\\\\leftrightarrow\",tag:\"mo\",output:\"\\u2194\",ttype:CONST},{input:\"\\\\uparrow\",tag:\"mo\",output:\"\\u2191\",ttype:CONST},{input:\"\\\\downarrow\",tag:\"mo\",output:\"\\u2193\",ttype:CONST},{input:\"\\\\updownarrow\",tag:\"mo\",output:\"\\u2195\",ttype:CONST},{input:\"\\\\Leftarrow\",tag:\"mo\",output:\"\\u21D0\",ttype:CONST},{input:\"\\\\Rightarrow\",tag:\"mo\",output:\"\\u21D2\",ttype:CONST},{input:\"\\\\Leftrightarrow\",tag:\"mo\",output:\"\\u21D4\",ttype:CONST},{input:\"\\\\iff\",tag:\"mo\",output:\"~\\\\Longleftrightarrow~\",ttype:DEFINITION},{input:\"\\\\Uparrow\",tag:\"mo\",output:\"\\u21D1\",ttype:CONST},{input:\"\\\\Downarrow\",tag:\"mo\",output:\"\\u21D3\",ttype:CONST},{input:\"\\\\Updownarrow\",tag:\"mo\",output:\"\\u21D5\",ttype:CONST},{input:\"\\\\mapsto\",tag:\"mo\",output:\"\\u21A6\",ttype:CONST},{input:\"\\\\longleftarrow\",tag:\"mo\",output:\"\\u2190\",ttype:LONG},{input:\"\\\\longrightarrow\",tag:\"mo\",output:\"\\u2192\",ttype:LONG},{input:\"\\\\longleftrightarrow\",tag:\"mo\",output:\"\\u2194\",ttype:LONG},{input:\"\\\\Longleftarrow\",tag:\"mo\",output:\"\\u21D0\",ttype:LONG},{input:\"\\\\Longrightarrow\",tag:\"mo\",output:\"\\u21D2\",ttype:LONG},{input:\"\\\\Longleftrightarrow\",tag:\"mo\",output:\"\\u21D4\",ttype:LONG},{input:\"\\\\longmapsto\",tag:\"mo\",output:\"\\u21A6\",ttype:CONST},AMsqrt,AMroot,AMfrac,AMover,AMsub,AMsup,AMtext,AMmbox,AMatop,AMchoose,{input:\"\\\\acute\",tag:\"mover\",output:\"\\u00B4\",ttype:UNARY,acc:true},{input:\"\\\\grave\",tag:\"mover\",output:\"\\u0060\",ttype:UNARY,acc:true},{input:\"\\\\breve\",tag:\"mover\",output:\"\\u02D8\",ttype:UNARY,acc:true},{input:\"\\\\check\",tag:\"mover\",output:\"\\u02C7\",ttype:UNARY,acc:true},{input:\"\\\\dot\",tag:\"mover\",output:\".\",ttype:UNARY,acc:true},{input:\"\\\\ddot\",tag:\"mover\",output:\"..\",ttype:UNARY,acc:true},{input:\"\\\\mathring\",tag:\"mover\",output:\"\\u00B0\",ttype:UNARY,acc:true},{input:\"\\\\vec\",tag:\"mover\",output:\"\\u20D7\",ttype:UNARY,acc:true},{input:\"\\\\overrightarrow\",tag:\"mover\",output:\"\\u20D7\",ttype:UNARY,acc:true},{input:\"\\\\overleftarrow\",tag:\"mover\",output:\"\\u20D6\",ttype:UNARY,acc:true},{input:\"\\\\hat\",tag:\"mover\",output:\"\\u005E\",ttype:UNARY,acc:true},{input:\"\\\\widehat\",tag:\"mover\",output:\"\\u0302\",ttype:UNARY,acc:true},{input:\"\\\\tilde\",tag:\"mover\",output:\"~\",ttype:UNARY,acc:true},{input:\"\\\\widetilde\",tag:\"mover\",output:\"\\u02DC\",ttype:UNARY,acc:true},{input:\"\\\\bar\",tag:\"mover\",output:\"\\u203E\",ttype:UNARY,acc:true},{input:\"\\\\overbrace\",tag:\"mover\",output:\"\\uFE37\",ttype:UNARY,acc:true},{input:\"\\\\overbracket\",tag:\"mover\",output:\"\\u23B4\",ttype:UNARY,acc:true},{input:\"\\\\overline\",tag:\"mover\",output:\"\\u00AF\",ttype:UNARY,acc:true},{input:\"\\\\underbrace\",tag:\"munder\",output:\"\\uFE38\",ttype:UNARY,acc:true},{input:\"\\\\underbracket\",tag:\"munder\",output:\"\\u23B5\",ttype:UNARY,acc:true},{input:\"\\\\underline\",tag:\"munder\",output:\"\\u00AF\",ttype:UNARY,acc:true},{input:\"\\\\displaystyle\",tag:\"mstyle\",atname:\"displaystyle\",atval:\"true\",ttype:UNARY},{input:\"\\\\textstyle\",tag:\"mstyle\",atname:\"displaystyle\",atval:\"false\",ttype:UNARY},{input:\"\\\\scriptstyle\",tag:\"mstyle\",atname:\"scriptlevel\",atval:\"1\",ttype:UNARY},{input:\"\\\\scriptscriptstyle\",tag:\"mstyle\",atname:\"scriptlevel\",atval:\"2\",ttype:UNARY},{input:\"\\\\textrm\",tag:\"mstyle\",output:\"\\\\mathrm\",ttype:DEFINITION},{input:\"\\\\mathbf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"bold\",ttype:UNARY},{input:\"\\\\textbf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"bold\",ttype:UNARY},{input:\"\\\\mathit\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"italic\",ttype:UNARY},{input:\"\\\\textit\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"italic\",ttype:UNARY},{input:\"\\\\mathtt\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"monospace\",ttype:UNARY},{input:\"\\\\texttt\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"monospace\",ttype:UNARY},{input:\"\\\\mathsf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"sans-serif\",ttype:UNARY},{input:\"\\\\mathbb\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"double-struck\",ttype:UNARY,codes:AMbbb},{input:\"\\\\mathcal\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"script\",ttype:UNARY,codes:AMcal},{input:\"\\\\mathfrak\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"fraktur\",ttype:UNARY,codes:AMfrk},{input:\"\\\\textcolor\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"mathcolor\",ttype:BINARY},{input:\"\\\\colorbox\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"background\",ttype:BINARY}];function compareNames(s1,s2){if(s1.input>s2.input)return 1\nelse return-1;}\nvar AMnames=[];function AMinitSymbols(){AMsymbols.sort(compareNames);for(i=0;i<AMsymbols.length;i++)AMnames[i]=AMsymbols[i].input;}\nvar AMmathml=\"http://www.w3.org/1998/Math/MathML\";function AMcreateElementMathML(t){if(isIE)return document.createElement(\"m:\"+t);else return document.createElementNS(AMmathml,t);}\nfunction AMcreateMmlNode(t,frag){if(isIE)var node=document.createElement(\"m:\"+t);else var node=document.createElementNS(AMmathml,t);node.appendChild(frag);return node;}\nfunction newcommand(oldstr,newstr){AMsymbols=AMsymbols.concat([{input:oldstr,tag:\"mo\",output:newstr,ttype:DEFINITION}]);}\nfunction AMremoveCharsAndBlanks(str,n){var st;st=str.slice(n);for(var i=0;i<st.length&&st.charCodeAt(i)<=32;i=i+1);return st.slice(i);}\nfunction AMposition(arr,str,n){if(n==0){var h,m;n=-1;h=arr.length;while(n+1<h){m=(n+h)>>1;if(arr[m]<str)n=m;else h=m;}\nreturn h;}else\nfor(var i=n;i<arr.length&&arr[i]<str;i++);return i;}\nfunction AMgetSymbol(str){var k=0;var j=0;var mk;var st;var tagst;var match=\"\";var more=true;for(var i=1;i<=str.length&&more;i++){st=str.slice(0,i);j=k;k=AMposition(AMnames,st,j);if(k<AMnames.length&&str.slice(0,AMnames[k].length)==AMnames[k]){match=AMnames[k];mk=k;i=match.length;}\nmore=k<AMnames.length&&str.slice(0,AMnames[k].length)>=AMnames[k];}\nAMpreviousSymbol=AMcurrentSymbol;if(match!=\"\"){AMcurrentSymbol=AMsymbols[mk].ttype;return AMsymbols[mk];}\nAMcurrentSymbol=CONST;k=1;st=str.slice(0,1);if(\"0\"<=st&&st<=\"9\")tagst=\"mn\";else tagst=((\"A\">st||st>\"Z\")&&(\"a\">st||st>\"z\")?\"mo\":\"mi\");return{input:st,tag:tagst,output:st,ttype:CONST};}\nvar AMpreviousSymbol,AMcurrentSymbol;function AMparseSexpr(str){var symbol,node,result,result2,i,st,newFrag=document.createDocumentFragment();str=AMremoveCharsAndBlanks(str,0);symbol=AMgetSymbol(str);if(symbol==null||symbol.ttype==RIGHTBRACKET)\nreturn[null,str,null];if(symbol.ttype==DEFINITION){str=symbol.output+AMremoveCharsAndBlanks(str,symbol.input.length);symbol=AMgetSymbol(str);if(symbol==null||symbol.ttype==RIGHTBRACKET)\nreturn[null,str,null];}\nstr=AMremoveCharsAndBlanks(str,symbol.input.length);switch(symbol.ttype){case SPACE:node=AMcreateElementMathML(symbol.tag);node.setAttribute(symbol.atname,symbol.atval);return[node,str,symbol.tag];case UNDEROVER:if(isIE){if(symbol.input.substr(0,4)==\"\\\\big\"){str=\"\\\\\"+symbol.input.substr(4)+str;symbol=AMgetSymbol(str);symbol.ttype=UNDEROVER;str=AMremoveCharsAndBlanks(str,symbol.input.length);}}\nreturn[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];case CONST:var output=symbol.output;if(isIE){if(symbol.input==\"'\")\noutput=\"\\u2032\";else if(symbol.input==\"''\")\noutput=\"\\u2033\";else if(symbol.input==\"'''\")\noutput=\"\\u2033\\u2032\";else if(symbol.input==\"''''\")\noutput=\"\\u2033\\u2033\";else if(symbol.input==\"\\\\square\")\noutput=\"\\u25A1\";else if(symbol.input.substr(0,5)==\"\\\\frac\"){var denom=symbol.input.substr(6,1);if(denom==\"5\"||denom==\"6\"){str=symbol.input.replace(/\\\\frac/,\"\\\\frac \")+str;return[node,str,symbol.tag];}}}\nnode=AMcreateMmlNode(symbol.tag,document.createTextNode(output));return[node,str,symbol.tag];case LONG:node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));node.setAttribute(\"minsize\",\"1.5\");node.setAttribute(\"maxsize\",\"1.5\");node=AMcreateMmlNode(\"mover\",node);node.appendChild(AMcreateElementMathML(\"mspace\"));return[node,str,symbol.tag];case STRETCHY:if(isIE&&symbol.input==\"\\\\backslash\")\nsymbol.output=\"\\\\\";node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));if(symbol.input==\"|\"||symbol.input==\"\\\\vert\"||symbol.input==\"\\\\|\"||symbol.input==\"\\\\Vert\"){node.setAttribute(\"lspace\",\"0em\");node.setAttribute(\"rspace\",\"0em\");}\nnode.setAttribute(\"maxsize\",symbol.atval);if(symbol.rtag!=null)\nreturn[node,str,symbol.rtag];else\nreturn[node,str,symbol.tag];case BIG:var atval=symbol.atval;if(isIE)\natval=symbol.ieval;symbol=AMgetSymbol(str);if(symbol==null)\nreturn[null,str,null];str=AMremoveCharsAndBlanks(str,symbol.input.length);node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"height\",atval+\"ex\");node=AMcreateMmlNode(\"mrow\",node);node.appendChild(space);}else{node.setAttribute(\"minsize\",atval);node.setAttribute(\"maxsize\",atval);}\nreturn[node,str,symbol.tag];case LEFTBRACKET:if(symbol.input==\"\\\\left\"){symbol=AMgetSymbol(str);if(symbol!=null){if(symbol.input==\".\")\nsymbol.invisible=true;str=AMremoveCharsAndBlanks(str,symbol.input.length);}}\nresult=AMparseExpr(str,true,false);if(symbol==null||(typeof symbol.invisible==\"boolean\"&&symbol.invisible))\nnode=AMcreateMmlNode(\"mrow\",result[0]);else{node=AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output));node=AMcreateMmlNode(\"mrow\",node);node.appendChild(result[0]);}\nreturn[node,result[1],result[2]];case MATRIX:if(symbol.input==\"\\\\begin{array}\"){var mask=\"\";symbol=AMgetSymbol(str);str=AMremoveCharsAndBlanks(str,0);if(symbol==null)\nmask=\"l\";else{str=AMremoveCharsAndBlanks(str,symbol.input.length);if(symbol.input!=\"{\")\nmask=\"l\";else do{symbol=AMgetSymbol(str);if(symbol!=null){str=AMremoveCharsAndBlanks(str,symbol.input.length);if(symbol.input!=\"}\")\nmask=mask+symbol.input;}}while(symbol!=null&&symbol.input!=\"\"&&symbol.input!=\"}\");}\nresult=AMparseExpr(\"{\"+str,true,true);node=AMcreateMmlNode(\"mtable\",result[0]);mask=mask.replace(/l/g,\"left \");mask=mask.replace(/r/g,\"right \");mask=mask.replace(/c/g,\"center \");node.setAttribute(\"columnalign\",mask);node.setAttribute(\"displaystyle\",\"false\");if(isIE)\nreturn[node,result[1],null];var lspace=AMcreateElementMathML(\"mspace\");lspace.setAttribute(\"width\",\"0.167em\");var rspace=AMcreateElementMathML(\"mspace\");rspace.setAttribute(\"width\",\"0.167em\");var node1=AMcreateMmlNode(\"mrow\",lspace);node1.appendChild(node);node1.appendChild(rspace);return[node1,result[1],null];}else{result=AMparseExpr(\"{\"+str,true,true);node=AMcreateMmlNode(\"mtable\",result[0]);if(isIE)\nnode.setAttribute(\"columnspacing\",\"0.25em\");else\nnode.setAttribute(\"columnspacing\",\"0.167em\");node.setAttribute(\"columnalign\",\"right center left\");node.setAttribute(\"displaystyle\",\"true\");node=AMcreateMmlNode(\"mrow\",node);return[node,result[1],null];}\ncase TEXT:if(str.charAt(0)==\"{\")i=str.indexOf(\"}\");else i=0;if(i==-1)\ni=str.length;st=str.slice(1,i);if(st.charAt(0)==\" \"){node=AMcreateElementMathML(\"mspace\");node.setAttribute(\"width\",\"0.33em\");newFrag.appendChild(node);}\nnewFrag.appendChild(AMcreateMmlNode(symbol.tag,document.createTextNode(st)));if(st.charAt(st.length-1)==\" \"){node=AMcreateElementMathML(\"mspace\");node.setAttribute(\"width\",\"0.33em\");newFrag.appendChild(node);}\nstr=AMremoveCharsAndBlanks(str,i+1);return[AMcreateMmlNode(\"mrow\",newFrag),str,null];case UNARY:result=AMparseSexpr(str);if(result[0]==null)return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str];if(typeof symbol.func==\"boolean\"&&symbol.func){st=str.charAt(0);if(st==\"^\"||st==\"_\"||st==\",\"){return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];}else{node=AMcreateMmlNode(\"mrow\",AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)));if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"width\",\"0.167em\");node.appendChild(space);}\nnode.appendChild(result[0]);return[node,result[1],symbol.tag];}}\nif(symbol.input==\"\\\\sqrt\"){if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"height\",\"1.2ex\");space.setAttribute(\"width\",\"0em\");node=AMcreateMmlNode(symbol.tag,result[0])\nnode.appendChild(space);return[node,result[1],symbol.tag];}else\nreturn[AMcreateMmlNode(symbol.tag,result[0]),result[1],symbol.tag];}else if(typeof symbol.acc==\"boolean\"&&symbol.acc){node=AMcreateMmlNode(symbol.tag,result[0]);var output=symbol.output;if(isIE){if(symbol.input==\"\\\\hat\")\noutput=\"\\u0302\";else if(symbol.input==\"\\\\widehat\")\noutput=\"\\u005E\";else if(symbol.input==\"\\\\bar\")\noutput=\"\\u00AF\";else if(symbol.input==\"\\\\grave\")\noutput=\"\\u0300\";else if(symbol.input==\"\\\\tilde\")\noutput=\"\\u0303\";}\nvar node1=AMcreateMmlNode(\"mo\",document.createTextNode(output));if(symbol.input==\"\\\\vec\"||symbol.input==\"\\\\check\")\nnode1.setAttribute(\"maxsize\",\"1.2\");if(isIE&&symbol.input==\"\\\\bar\")\nnode1.setAttribute(\"maxsize\",\"0.5\");if(symbol.input==\"\\\\underbrace\"||symbol.input==\"\\\\underline\")\nnode1.setAttribute(\"accentunder\",\"true\");else\nnode1.setAttribute(\"accent\",\"true\");node.appendChild(node1);if(symbol.input==\"\\\\overbrace\"||symbol.input==\"\\\\underbrace\")\nnode.ttype=UNDEROVER;return[node,result[1],symbol.tag];}else{if(!isIE&&typeof symbol.codes!=\"undefined\"){for(i=0;i<result[0].childNodes.length;i++)\nif(result[0].childNodes[i].nodeName==\"mi\"||result[0].nodeName==\"mi\"){st=(result[0].nodeName==\"mi\"?result[0].firstChild.nodeValue:result[0].childNodes[i].firstChild.nodeValue);var newst=[];for(var j=0;j<st.length;j++)\nif(st.charCodeAt(j)>64&&st.charCodeAt(j)<91)newst=newst+\nString.fromCharCode(symbol.codes[st.charCodeAt(j)-65]);else newst=newst+st.charAt(j);if(result[0].nodeName==\"mi\")\nresult[0]=AMcreateElementMathML(\"mo\").appendChild(document.createTextNode(newst));else result[0].replaceChild(AMcreateElementMathML(\"mo\").appendChild(document.createTextNode(newst)),result[0].childNodes[i]);}}\nnode=AMcreateMmlNode(symbol.tag,result[0]);node.setAttribute(symbol.atname,symbol.atval);if(symbol.input==\"\\\\scriptstyle\"||symbol.input==\"\\\\scriptscriptstyle\")\nnode.setAttribute(\"displaystyle\",\"false\");return[node,result[1],symbol.tag];}\ncase BINARY:result=AMparseSexpr(str);if(result[0]==null)return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.input)),str,null];result2=AMparseSexpr(result[1]);if(result2[0]==null)return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.input)),str,null];if(symbol.input==\"\\\\textcolor\"||symbol.input==\"\\\\colorbox\"){var tclr=str.match(/\\{\\s*([#\\w]+)\\s*\\}/);str=str.replace(/\\{\\s*[#\\w]+\\s*\\}/,\"\");if(tclr!=null){if(IsColorName.test(tclr[1].toLowerCase())){tclr=LaTeXColor[tclr[1].toLowerCase()];}else{tclr=tclr[1];}\nnode=AMcreateElementMathML(\"mstyle\");node.setAttribute(symbol.atval,tclr);node.appendChild(result2[0]);return[node,result2[1],symbol.tag];}}\nif(symbol.input==\"\\\\root\"||symbol.input==\"\\\\stackrel\")newFrag.appendChild(result2[0]);newFrag.appendChild(result[0]);if(symbol.input==\"\\\\frac\")newFrag.appendChild(result2[0]);return[AMcreateMmlNode(symbol.tag,newFrag),result2[1],symbol.tag];case INFIX:str=AMremoveCharsAndBlanks(str,symbol.input.length);return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output)),str,symbol.tag];default:return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];}}\nfunction AMparseIexpr(str){var symbol,sym1,sym2,node,result,tag,underover;str=AMremoveCharsAndBlanks(str,0);sym1=AMgetSymbol(str);result=AMparseSexpr(str);node=result[0];str=result[1];tag=result[2];symbol=AMgetSymbol(str);if(symbol.ttype==INFIX){str=AMremoveCharsAndBlanks(str,symbol.input.length);result=AMparseSexpr(str);if(result[0]==null)\nresult[0]=AMcreateMmlNode(\"mo\",document.createTextNode(\"\\u25A1\"));str=result[1];tag=result[2];if(symbol.input==\"_\"||symbol.input==\"^\"){sym2=AMgetSymbol(str);tag=null;underover=((sym1.ttype==UNDEROVER)||(node.ttype==UNDEROVER));if(symbol.input==\"_\"&&sym2.input==\"^\"){str=AMremoveCharsAndBlanks(str,sym2.input.length);var res2=AMparseSexpr(str);str=res2[1];tag=res2[2];node=AMcreateMmlNode((underover?\"munderover\":\"msubsup\"),node);node.appendChild(result[0]);node.appendChild(res2[0]);}else if(symbol.input==\"_\"){node=AMcreateMmlNode((underover?\"munder\":\"msub\"),node);node.appendChild(result[0]);}else{node=AMcreateMmlNode((underover?\"mover\":\"msup\"),node);node.appendChild(result[0]);}\nnode=AMcreateMmlNode(\"mrow\",node);}else{node=AMcreateMmlNode(symbol.tag,node);if(symbol.input==\"\\\\atop\"||symbol.input==\"\\\\choose\")\nnode.setAttribute(\"linethickness\",\"0ex\");node.appendChild(result[0]);if(symbol.input==\"\\\\choose\")\nnode=AMcreateMmlNode(\"mfenced\",node);}}\nreturn[node,str,tag];}\nfunction AMparseExpr(str,rightbracket,matrix){var symbol,node,result,i,tag,newFrag=document.createDocumentFragment();do{str=AMremoveCharsAndBlanks(str,0);result=AMparseIexpr(str);node=result[0];str=result[1];tag=result[2];symbol=AMgetSymbol(str);if(node!=undefined){if((tag==\"mn\"||tag==\"mi\")&&symbol!=null&&typeof symbol.func==\"boolean\"&&symbol.func){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"width\",\"0.167em\");node=AMcreateMmlNode(\"mrow\",node);node.appendChild(space);}\nnewFrag.appendChild(node);}}while((symbol.ttype!=RIGHTBRACKET)&&symbol!=null&&symbol.output!=\"\");tag=null;if(symbol.ttype==RIGHTBRACKET){if(symbol.input==\"\\\\right\"){str=AMremoveCharsAndBlanks(str,symbol.input.length);symbol=AMgetSymbol(str);if(symbol!=null&&symbol.input==\".\")\nsymbol.invisible=true;if(symbol!=null)\ntag=symbol.rtag;}\nif(symbol!=null)\nstr=AMremoveCharsAndBlanks(str,symbol.input.length);var len=newFrag.childNodes.length;if(matrix&&len>0&&newFrag.childNodes[len-1].nodeName==\"mrow\"&&len>1&&newFrag.childNodes[len-2].nodeName==\"mo\"&&newFrag.childNodes[len-2].firstChild.nodeValue==\"&\"){var pos=[];var m=newFrag.childNodes.length;for(i=0;matrix&&i<m;i=i+2){pos[i]=[];node=newFrag.childNodes[i];for(var j=0;j<node.childNodes.length;j++)\nif(node.childNodes[j].firstChild.nodeValue==\"&\")\npos[i][pos[i].length]=j;}\nvar row,frag,n,k,table=document.createDocumentFragment();for(i=0;i<m;i=i+2){row=document.createDocumentFragment();frag=document.createDocumentFragment();node=newFrag.firstChild;n=node.childNodes.length;k=0;for(j=0;j<n;j++){if(typeof pos[i][k]!=\"undefined\"&&j==pos[i][k]){node.removeChild(node.firstChild);row.appendChild(AMcreateMmlNode(\"mtd\",frag));k++;}else frag.appendChild(node.firstChild);}\nrow.appendChild(AMcreateMmlNode(\"mtd\",frag));if(newFrag.childNodes.length>2){newFrag.removeChild(newFrag.firstChild);newFrag.removeChild(newFrag.firstChild);}\ntable.appendChild(AMcreateMmlNode(\"mtr\",row));}\nreturn[table,str];}\nif(typeof symbol.invisible!=\"boolean\"||!symbol.invisible){node=AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output));newFrag.appendChild(node);}}\nreturn[newFrag,str,tag];}\nfunction AMparseMath(str){var result,node=AMcreateElementMathML(\"mstyle\");var cclr=str.match(/\\\\color\\s*\\{\\s*([#\\w]+)\\s*\\}/);str=str.replace(/\\\\color\\s*\\{\\s*[#\\w]+\\s*\\}/g,\"\");if(cclr!=null){if(IsColorName.test(cclr[1].toLowerCase())){cclr=LaTeXColor[cclr[1].toLowerCase()];}else{cclr=cclr[1];}\nnode.setAttribute(\"mathcolor\",cclr);}else{if(mathcolor!=\"\")node.setAttribute(\"mathcolor\",mathcolor);};if(mathfontfamily!=\"\")node.setAttribute(\"fontfamily\",mathfontfamily);node.appendChild(AMparseExpr(str.replace(/^\\s+/g,\"\"),false,false)[0]);node=AMcreateMmlNode(\"math\",node);if(showasciiformulaonhover)\nnode.setAttribute(\"title\",str.replace(/\\s+/g,\" \"));if(false){var fnode=AMcreateElementXHTML(\"font\");fnode.setAttribute(\"face\",mathfontfamily);fnode.appendChild(node);return fnode;}\nreturn node;}\nfunction AMstrarr2docFrag(arr,linebreaks){var newFrag=document.createDocumentFragment();var expr=false;for(var i=0;i<arr.length;i++){if(expr)newFrag.appendChild(AMparseMath(arr[i]));else{var arri=(linebreaks?arr[i].split(\"\\n\\n\"):[arr[i]]);newFrag.appendChild(AMcreateElementXHTML(\"span\").appendChild(document.createTextNode(arri[0])));for(var j=1;j<arri.length;j++){newFrag.appendChild(AMcreateElementXHTML(\"p\"));newFrag.appendChild(AMcreateElementXHTML(\"span\").appendChild(document.createTextNode(arri[j])));}}\nexpr=!expr;}\nreturn newFrag;}\nfunction AMprocessNodeR(n,linebreaks){var mtch,str,arr,frg,i;if(n.childNodes.length==0){if((n.nodeType!=8||linebreaks)&&n.parentNode.nodeName!=\"form\"&&n.parentNode.nodeName!=\"FORM\"&&n.parentNode.nodeName!=\"textarea\"&&n.parentNode.nodeName!=\"TEXTAREA\"&&n.parentNode.nodeName!=\"pre\"&&n.parentNode.nodeName!=\"PRE\"){str=n.nodeValue;if(!(str==null)){str=str.replace(/\\r\\n\\r\\n/g,\"\\n\\n\");str=str.replace(/\\x20+/g,\" \");str=str.replace(/\\s*\\r\\n/g,\" \");mtch=(str.indexOf(\"\\$\")==-1?false:true);str=str.replace(/([^\\\\])\\$/g,\"$1 \\$\");str=str.replace(/^\\$/,\" \\$\");arr=str.split(\" \\$\");for(i=0;i<arr.length;i++)\narr[i]=arr[i].replace(/\\\\\\$/g,\"\\$\");if(arr.length>1||mtch){if(checkForMathML){checkForMathML=false;var nd=AMisMathMLavailable();AMnoMathML=nd!=null;if(AMnoMathML&&notifyIfNoMathML)\nif(alertIfNoMathML)\nalert(\"To view the ASCIIMathML notation use Internet Explorer 6 +\\nMathPlayer (free from www.dessci.com)\\nor Firefox/Mozilla/Netscape\");else AMbody.insertBefore(nd,AMbody.childNodes[0]);}\nif(!AMnoMathML){frg=AMstrarr2docFrag(arr,n.nodeType==8);var len=frg.childNodes.length;n.parentNode.replaceChild(frg,n);return len-1;}else return 0;}}}else return 0;}else if(n.nodeName!=\"math\"){for(i=0;i<n.childNodes.length;i++)\ni+=AMprocessNodeR(n.childNodes[i],linebreaks);}\nreturn 0;}\nfunction AMprocessNode(n,linebreaks,spanclassAM){var frag,st;if(spanclassAM!=null){frag=document.getElementsByTagName(\"span\")\nfor(var i=0;i<frag.length;i++)\nif(frag[i].className==\"AM\")\nAMprocessNodeR(frag[i],linebreaks);}else{try{st=n.innerHTML;}catch(err){}\nif(st==null||st.indexOf(\"\\$\")!=-1)\nAMprocessNodeR(n,linebreaks);}\nif(isIE){frag=document.getElementsByTagName('math');for(var i=0;i<frag.length;i++)frag[i].update()}}\nvar inAppendix=false;var sectionCntr=0;var IEcommentWarning=true;var biblist=[];var bibcntr=0;var LaTeXCounter=[];LaTeXCounter[\"definition\"]=0;LaTeXCounter[\"proposition\"]=0;LaTeXCounter[\"lemma\"]=0;LaTeXCounter[\"theorem\"]=0;LaTeXCounter[\"corollary\"]=0;LaTeXCounter[\"example\"]=0;LaTeXCounter[\"exercise\"]=0;LaTeXCounter[\"subsection\"]=0;LaTeXCounter[\"subsubsection\"]=0;LaTeXCounter[\"figure\"]=0;LaTeXCounter[\"equation\"]=0;LaTeXCounter[\"table\"]=0;var LaTeXColor=[];LaTeXColor[\"greenyellow\"]=\"#D9FF4F\";LaTeXColor[\"yellow\"]=\"#FFFF00\";LaTeXColor[\"goldenrod\"]=\"#FFE529\";LaTeXColor[\"dandelion\"]=\"#FFB529\";LaTeXColor[\"apricot\"]=\"#FFAD7A\";LaTeXColor[\"peach\"]=\"#FF804D\";LaTeXColor[\"melon\"]=\"#FF8A80\";LaTeXColor[\"yelloworange\"]=\"#FF9400\";LaTeXColor[\"orange\"]=\"#FF6321\";LaTeXColor[\"burntorange\"]=\"#FF7D00\";LaTeXColor[\"bittersweet\"]=\"#C20300\";LaTeXColor[\"redorange\"]=\"#FF3B21\";LaTeXColor[\"mahogany\"]=\"#A60000\";LaTeXColor[\"maroon\"]=\"#AD0000\";LaTeXColor[\"brickred\"]=\"#B80000\";LaTeXColor[\"red\"]=\"#FF0000\";LaTeXColor[\"orangered\"]=\"#FF0080\";LaTeXColor[\"rubinered\"]=\"#FF00DE\";LaTeXColor[\"wildstrawberry\"]=\"#FF0A9C\";LaTeXColor[\"salmon\"]=\"#FF789E\";LaTeXColor[\"carnationpink\"]=\"#FF5EFF\";LaTeXColor[\"magenta\"]=\"#FF00FF\";LaTeXColor[\"violetred\"]=\"#FF30FF\";LaTeXColor[\"rhodamine\"]=\"#FF2EFF\";LaTeXColor[\"mulberry\"]=\"#A314FA\";LaTeXColor[\"redviolet\"]=\"#9600A8\";LaTeXColor[\"fuchsia\"]=\"#7303EB\";LaTeXColor[\"lavender\"]=\"#FF85FF\";LaTeXColor[\"thistle\"]=\"#E069FF\";LaTeXColor[\"orchid\"]=\"#AD5CFF\";LaTeXColor[\"darkorchid\"]=\"#9933CC\";LaTeXColor[\"purple\"]=\"#8C24FF\";LaTeXColor[\"plum\"]=\"#8000FF\";LaTeXColor[\"violet\"]=\"#361FFF\";LaTeXColor[\"royalpurple\"]=\"#401AFF\";LaTeXColor[\"blueviolet\"]=\"#1A0DF5\";LaTeXColor[\"periwinkle\"]=\"#6E73FF\";LaTeXColor[\"cadetblue\"]=\"#616EC4\";LaTeXColor[\"cornflowerblue\"]=\"#59DEFF\";LaTeXColor[\"midnightblue\"]=\"#007091\";LaTeXColor[\"navyblue\"]=\"#0F75FF\";LaTeXColor[\"royalblue\"]=\"#0080FF\";LaTeXColor[\"blue\"]=\"#0000FF\";LaTeXColor[\"cerulean\"]=\"#0FE3FF\";LaTeXColor[\"cyan\"]=\"#00FFFF\";LaTeXColor[\"processblue\"]=\"#0AFFFF\";LaTeXColor[\"skyblue\"]=\"#61FFE0\";LaTeXColor[\"turquoise\"]=\"#26FFCC\";LaTeXColor[\"tealblue\"]=\"#1FFAA3\";LaTeXColor[\"aquamarine\"]=\"#2EFFB2\";LaTeXColor[\"bluegreen\"]=\"#26FFAB\";LaTeXColor[\"emerald\"]=\"#00FF80\";LaTeXColor[\"junglegreen\"]=\"#03FF7A\";LaTeXColor[\"seagreen\"]=\"#4FFF80\";LaTeXColor[\"green\"]=\"#00FF00\";LaTeXColor[\"forestgreen\"]=\"#00E000\";LaTeXColor[\"pinegreen\"]=\"#00BF29\";LaTeXColor[\"limegreen\"]=\"#80FF00\";LaTeXColor[\"yellowgreen\"]=\"#8FFF42\";LaTeXColor[\"springgreen\"]=\"#BDFF3D\";LaTeXColor[\"olivegreen\"]=\"#009900\";LaTeXColor[\"rawsienna\"]=\"#8C0000\";LaTeXColor[\"sepia\"]=\"#4D0000\";LaTeXColor[\"brown\"]=\"#660000\";LaTeXColor[\"tan\"]=\"#DB9470\";LaTeXColor[\"gray\"]=\"#808080\";LaTeXColor[\"grey\"]=\"#808080\";LaTeXColor[\"black\"]=\"#000000\";LaTeXColor[\"white\"]=\"#FFFFFF\";var IsColorName=/^(?:greenyellow|yellow|goldenrod|dandelion|apricot|peach|melon|yelloworange|orange|burntorange|bittersweet|redorange|mahogany|maroon|brickred|red|orangered|rubinered|wildstrawberry|salmon|carnationpink|magenta|violetred|rhodamine|mulberry|redviolet|fuchsia|lavender|thistle|orchid|darkorchid|purple|plum|violet|royalpurple|blueviolet|periwinkle|cadetblue|cornflowerblue|midnightblue|navyblue|royalblue|blue|cerulean|cyan|processblue|skyblue|turquoise|tealblue|aquamarine|bluegreen|emerald|junglegreen|seagreen|green|forestgreen|pinegreen|limegreen|yellowgreen|springgreen|olivegreen|rawsienna|sepia|brown|tan|gray|grey|black|white)$/;var IsCounter=/^(?:definition|proposition|lemma|theorem|corollary|example|exercise|subsection|subsubsection|figure|equation|table)$/;var IsLaTeXElement=/^(?:displayequation|title|author|address|date|abstract|keyword|section|subsection|subsubsection|ref|cite|thebibliography|definition|proposition|lemma|theorem|corollary|example|exercise|itemize|enumerate|enddefinition|endproposition|endlemma|endtheorem|endcorollary|endexample|endexercise|enditemize|endenumerate|LaTeXMathMLlabel|LaTeXMathML|smallskip|medskip|bigskip|quote|quotation|endquote|endquotation|center|endcenter|description|enddescription|inlinemath)$/;var IsTextOnlyArea=/^(?:form|textarea|pre)$/i;var tableid=0;function makeNumberString(cntr){if(sectionCntr>0){if(inAppendix){return\"A\"+sectionCntr+\".\"+cntr;}else{return sectionCntr+\".\"+cntr;}}else{return\"\"+cntr;}};function LaTeXpreProcess(thebody){var TheBody=thebody;if(TheBody.hasChildNodes()){if(!(IsLaTeXElement.test(TheBody.className)))\n{for(var i=0;i<TheBody.childNodes.length;i++){LaTeXpreProcess(TheBody.childNodes[i])}}}\nelse{if(TheBody.nodeType==3&&!(IsTextOnlyArea.test(TheBody.parentNode.nodeName)))\n{var str=TheBody.nodeValue;if(!(str==null)){str=str.replace(/\\\\%/g,\"<per>\");str=str.replace(/%[^\\n]*(?=\\n)/g,\"\");str=str.replace(/%[^\\r]*(?=\\r)/g,\"\");str=str.replace(/%[^\\n]*$/,\"\")\nif(isIE&&str.match(/%/g)!=null&&IEcommentWarning){alert(\"Comments may not have parsed properly.  Try putting in <pre class='LaTeX><div>..</div></pre> structure.\");IEcommentWarning=false;}\nstr=str.replace(/<per>/g,\"%\");if(str.match(/XXX[\\s\\S]*/)!=null){var tmp=str.match(/XXX[\\s\\S]*/)[0];var tmpstr=tmp.charCodeAt(7)+\"::\"+tmp.charCodeAt(8)+\"::\"+tmp.charCodeAt(9)+\"::\"+tmp.charCodeAt(10)+\"::\"+tmp.charCodeAt(11)+\"::\"+tmp.charCodeAt(12)+\"::\"+tmp.charCodeAt(13);alert(tmpstr);}\nstr=str.replace(/([^\\\\])\\\\(\\s)/g,\"$1\\u00A0$2\");str=str.replace(/\\\\quad/g,\"\\u2001\");str=str.replace(/\\\\qquad/g,\"\\u2001\\u2001\");str=str.replace(/\\\\enspace/g,\"\\u2002\");str=str.replace(/\\\\;/g,\"\\u2004\");str=str.replace(/\\\\:/g,\"\\u2005\");str=str.replace(/\\\\,/g,\"\\u2006\");str=str.replace(/\\\\thinspace/g,\"\\u200A\");str=str.replace(/([^\\\\])~/g,\"$1\\u00A0\");str=str.replace(/\\\\~/g,\"~\");str=str.replace(/\\\\\\[/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\\\]/g,\"}$ <DEQ> \");str=str.replace(/\\$\\$/g,\"${$<DEQ>$}$\");str=str.replace(/\\\\begin\\s*\\{\\s*array\\s*\\}/g,\"\\\\begin{array}\");str=str.replace(/\\\\end\\s*\\{\\s*array\\s*\\}/g,\"\\\\end{array}\");str=str.replace(/\\\\begin\\s*\\{\\s*eqnarray\\s*\\}/g,\"  <DEQ>eqno$\\\\begin{eqnarray}\");str=str.replace(/\\\\end\\s*\\{\\s*eqnarray\\s*\\}/g,\"\\\\end{eqnarray}$<DEQ>  \");str=str.replace(/\\\\begin\\s*\\{\\s*eqnarray\\*\\s*\\}/g,\"  <DEQ>$\\\\begin{eqnarray}\");str=str.replace(/\\\\end\\s*\\{\\s*eqnarray\\*\\s*\\}/g,\"\\\\end{eqnarray}$<DEQ>  \");str=str.replace(/\\\\begin\\s*\\{\\s*displaymath\\s*\\}/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*displaymath\\s*\\}/g,\"}$ <DEQ> \");str=str.replace(/\\\\begin\\s*\\{\\s*equation\\s*\\*\\s*\\}/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*equation\\s*\\*\\s*\\}/g,\"}$ <DEQ> \");str=str.replace(/\\\\begin\\s*\\{\\s*equation\\s*\\}/g,\" <DEQ>eqno$\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*equation\\s*\\}/g,\"}$ <DEQ> \");str=str.split(\"<DEQ>\");var newFrag=document.createDocumentFragment();for(var i=0;i<str.length;i++){if(i%2){var DEQtable=document.createElement(\"table\");DEQtable.className='displayequation';var DEQtbody=document.createElement(\"tbody\");var DEQtr=document.createElement(\"tr\");var DEQtdeq=document.createElement(\"td\");DEQtdeq.className='eq';str[i]=str[i].replace(/\\$\\}\\$/g,\"$\\\\displaystyle{\");str[i]=str[i].replace(/\\$\\{\\$/g,\"}\");var lbl=str[i].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);var ISeqno=str[i].match(/^eqno/);str[i]=str[i].replace(/^eqno/,\" \");str[i]=str[i].replace(/\\\\label\\s*\\{\\s*\\w+\\s*\\}/,\" \");DEQtdeq.appendChild(document.createTextNode(str[i]));DEQtr.appendChild(DEQtdeq);str[i]=str[i].replace(/\\\\nonumber/g,\"\");if(ISeqno!=null||lbl!=null){var DEQtdno=document.createElement(\"td\");DEQtdno.className='eqno';LaTeXCounter[\"equation\"]++;var eqnoString=makeNumberString(LaTeXCounter[\"equation\"]);var DEQanchor=document.createElement(\"a\");if(lbl!=null){DEQanchor.id=lbl[1]};DEQanchor.className=\"eqno\";var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"eqno\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(eqnoString));DEQanchor.appendChild(anchorSpan);DEQtdno.appendChild(DEQanchor);var DEQspan=document.createElement(\"span\");DEQspan.className=\"eqno\";DEQspan.appendChild(document.createTextNode(\"(\"+eqnoString+\")\"));DEQtdno.appendChild(DEQspan);DEQtr.appendChild(DEQtdno);}\nDEQtbody.appendChild(DEQtr);DEQtable.appendChild(DEQtbody);newFrag.appendChild(DEQtable);}\nelse{str[i]=str[i].replace(/\\$\\}\\$/g,\"\");str[i]=str[i].replace(/\\$\\{\\$/g,\"\");str[i]=str[i].replace(/\\\\maketitle/g,\"\");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*document\\s*\\}/g,\"\");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*document\\s*\\}/g,\"\");str[i]=str[i].replace(/\\\\documentclass[^\\}]*?\\}/g,\"\");str[i]=str[i].replace(/\\\\usepackage[^\\}]*?\\}/g,\"\");str[i]=str[i].replace(/\\\\noindent/g,\"\");str[i]=str[i].replace(/\\\\notag/g,\"\");str[i]=str[i].replace(/\\\\ref\\s*\\{\\s*(\\w+)\\}/g,\" \\\\[ref\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\url\\s*\\{\\s*([^\\}\\n]+)\\}/g,\" \\\\[url\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\href\\s*\\{\\s*([^\\}]+)\\}\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[href\\\\]$1\\\\]$2\\\\[ \");str[i]=str[i].replace(/\\\\cite\\s*\\{\\s*(\\w+)\\}/g,\" \\\\[cite\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\qed/g,\"\\u220E\");str[i]=str[i].replace(/\\\\endproof/g,\"\\u220E\");str[i]=str[i].replace(/\\\\proof/g,\"\\\\textbf{Proof: }\");str[i]=str[i].replace(/\\\\n(?=\\s)/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\newline/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\linebreak/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\smallskip/g,\" \\\\[logicalbreak\\\\]smallskip\\\\[ \");str[i]=str[i].replace(/\\\\medskip/g,\" \\\\[logicalbreak\\\\]medskip\\\\[ \");str[i]=str[i].replace(/\\\\bigskip/g,\" \\\\[logicalbreak\\\\]bigskip\\\\[ \");str[i]=str[i].replace(/[\\n\\r]+[ \\f\\n\\r\\t\\v\\u2028\\u2029]*[\\n\\r]+/g,\" \\\\[logicalbreak\\\\]LaTeXMathML\\\\[ \");if(isIE){str[i]=str[i].replace(/\\r/g,\" \");}\nstr[i]=str[i].replace(/\\\\bibitem\\s*([^\\{]*\\{\\s*\\w*\\s*\\})/g,\" \\\\[bibitem\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\bibitem\\s*/g,\" \\\\[bibitem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\item\\s*\\[\\s*(\\w+)\\s*\\]/g,\" \\\\[alistitem\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\item\\s*/g,\" \\\\[alistitem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\appendix/g,\" \\\\[appendix\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*figure\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*figure\\s*\\}/g,\" \\\\[figure\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*table\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*table\\s*\\}/g,\" \\\\[table\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*theorem\\s*\\}/g,\" \\\\[theorem\\\\]Theorem \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*theorem\\s*\\}/g,\" \\\\[endtheorem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*definition\\s*\\}/g,\" \\\\[definition\\\\]Definition \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*definition\\s*\\}/g,\" \\\\[enddefinition\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*lemma\\s*\\}/g,\" \\\\[lemma\\\\]Lemma \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*lemma\\s*\\}/g,\" \\\\[endlemma\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*corollary\\s*\\}/g,\" \\\\[corollary\\\\]Corollary \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*corollary\\s*\\}/g,\" \\\\[endcorollary\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*proposition\\s*\\}/g,\" \\\\[proposition\\\\]Proposition \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proposition\\s*\\}/g,\" \\\\[endproposition\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*example\\s*\\}/g,\" \\\\[example\\\\]Example \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*example\\s*\\}/g,\" \\\\[endexample\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*exercise\\s*\\}/g,\" \\\\[exercise\\\\]Exercise \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*exercise\\s*\\}/g,\" \\\\[endexercise\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*thebibliography\\s*\\}\\s*\\{\\s*\\w+\\s*\\}/g,\" \\\\[thebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*thebibliography\\s*\\}/g,\" \\\\[thebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*thebibliography\\s*\\}/g,\" \\\\[endthebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*proof\\s*\\}/g,\" \\\\[proof\\\\]Proof: \\\\[ \");if(isIE){str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proof\\s*\\}/g,\"\\u220E \\\\[endproof\\\\] \\\\[ \");}else{str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proof\\s*\\}/g,\" \\\\[endproof\\\\] \\\\[ \");}\nstr[i]=str[i].replace(/\\\\title\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[title\\\\] \\\\[$1 \\\\[endtitle\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\author\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[author\\\\] \\\\[$1 \\\\[endauthor\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\address\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[address\\\\] \\\\[$1 \\\\[endaddress\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\date\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[date\\\\] \\\\[$1 \\\\[enddate\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*keyword\\s*\\}/g,\" \\\\[keyword\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*keyword\\s*\\}/g,\" \\\\[endkeyword\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*abstract\\s*\\}/g,\" \\\\[abstract\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*abstract\\s*\\}/g,\" \\\\[endabstract\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*(?!array|tabular)(\\w+)\\s*\\}/g,\" \\\\[$1\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*(?!array|tabular)(\\w+)\\s*\\}/g,\" \\\\[end$1\\\\] \\\\[ \");var sectionIndex=str[i].search(/\\\\section\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\section\\s*\\{/,\" \\\\[section\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\section\\s*\\{\\s*[\\s\\S]+\\}/);}\nsectionIndex=str[i].search(/\\\\subsection\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\subsection\\s*\\{/,\" \\\\[subsection\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\subsection\\s*\\{\\s*[\\s\\S]+\\}/);}\nsectionIndex=str[i].search(/\\\\subsubsection\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\subsubsection\\s*\\{/,\" \\\\[subsubsection\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\subsubsection\\s*\\{\\s*[\\s\\S]+\\}/);}\nvar CatToNextEven=\"\";var strtmp=str[i].split(\"\\\\[\");for(var j=0;j<strtmp.length;j++){if(j%2){var strtmparray=strtmp[j].split(\"\\\\]\");switch(strtmparray[0]){case\"section\":var nodeTmp=document.createElement(\"H2\");nodeTmp.className='section';sectionCntr++;for(var div in LaTeXCounter){LaTeXCounter[div]=0};var nodeAnchor=document.createElement(\"a\");if(inAppendix){nodeAnchor.className='appendixsection';}else{nodeAnchor.className='section';}\nvar nodeNumString=makeNumberString(\"\");var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"section\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='section';nodeSpan.appendChild(document.createTextNode(nodeNumString+\" \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"subsection\":var nodeTmp=document.createElement(\"H3\");nodeTmp.className='subsection';LaTeXCounter[\"subsection\"]++;LaTeXCounter[\"subsubsection\"]=0;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className='subsection';var nodeNumString=makeNumberString(LaTeXCounter[\"subsection\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"subsection\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='subsection';nodeSpan.appendChild(document.createTextNode(nodeNumString+\". \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"subsubsection\":var nodeTmp=document.createElement(\"H4\");nodeTmp.className='subsubsection';LaTeXCounter[\"subsubsection\"]++;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className='subsubsection';var nodeNumString=makeNumberString(LaTeXCounter[\"subsection\"]+\".\"+LaTeXCounter[\"subsubsection\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"subsubsection\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='subsubsection';nodeSpan.appendChild(document.createTextNode(nodeNumString+\". \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"href\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathML';nodeTmp.href=strtmparray[1];nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"url\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathML';nodeTmp.href=strtmparray[1];nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"figure\":var nodeTmp=document.createElement(\"table\");nodeTmp.className='figure';var FIGtbody=document.createElement(\"tbody\");var FIGlbl=strtmparray[1].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\\\label\\s*\\{\\w+\\}/g,\"\");var capIndex=strtmparray[1].search(/\\\\caption\\s*\\{[\\s\\S]+\\}/);var FIGcap=\"\";if(capIndex>=0){var tmp=strtmparray[1];var delimcnt=0;var capstart=-1;for(var pos=capIndex;pos<tmp.length;pos++){if(tmp.charAt(pos)==\"{\"){delimcnt++};if(tmp.charAt(pos)==\"}\"){delimcnt--};if(delimcnt==1&&capstart<0){capstart=pos+1};if(delimcnt==0&&capstart>0){capend=pos-1;FIGcap=tmp.substring(capstart,pos);break}}}\nvar FIGtr2=document.createElement(\"tr\");var FIGtd2=document.createElement(\"td\");FIGtd2.className=\"caption\";var FIGanchor=document.createElement(\"a\");FIGanchor.className=\"figure\";if(FIGlbl!=null){FIGanchor.id=FIGlbl[1];}\nLaTeXCounter[\"figure\"]++;var fignmbr=makeNumberString(LaTeXCounter[\"figure\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"figure\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(fignmbr));FIGanchor.appendChild(anchorSpan);FIGtd2.appendChild(FIGanchor);var FIGspan=document.createElement(\"span\");FIGspan.className=\"figure\";FIGspan.appendChild(document.createTextNode(\"Figure \"+fignmbr+\". \"));FIGtd2.appendChild(FIGspan);FIGtd2.appendChild(document.createTextNode(\"\"+FIGcap));FIGtr2.appendChild(FIGtd2);FIGtbody.appendChild(FIGtr2);var IsSpecial=false;var FIGinfo=strtmparray[1].match(/\\\\includegraphics\\s*\\{([^\\}]+)\\}/);if(FIGinfo==null){FIGinfo=strtmparray[1].match(/\\\\includegraphics\\s*\\[[^\\]]*\\]\\s*\\{\\s*([^\\}]+)\\s*\\}/);}\nif(FIGinfo==null){FIGinfo=strtmparray[1].match(/\\\\special\\s*\\{\\s*([^\\}]+)\\}/);IsSpecial=true};if(FIGinfo!=null){var FIGtr1=document.createElement(\"tr\");var FIGtd1=document.createElement(\"td\");FIGtd1.className=\"image\";var FIGimg=document.createElement(\"img\");var FIGsrc=FIGinfo[1];FIGimg.src=FIGsrc;FIGimg.alt=\"Figure \"+FIGsrc+\" did not load\";FIGimg.title=\"Figure \"+fignmbr+\". \"+FIGcap;FIGimg.id=\"figure\"+fignmbr;FIGtd1.appendChild(FIGimg);FIGtr1.appendChild(FIGtd1);FIGtbody.appendChild(FIGtr1);}\nnodeTmp.appendChild(FIGtbody);newFrag.appendChild(nodeTmp);break;case\"table\":var nodeTmp=document.createElement(\"table\");if(strtmparray[1].search(/\\\\centering/)>=0){nodeTmp.className='LaTeXtable centered';nodeTmp.align=\"center\";}else{nodeTmp.className='LaTeXtable';};tableid++;nodeTmp.id=\"LaTeXtable\"+tableid;var TABlbl=strtmparray[1].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\\\label\\s*\\{\\w+\\}/g,\"\");var capIndex=strtmparray[1].search(/\\\\caption\\s*\\{[\\s\\S]+\\}/);var TABcap=\"\";if(capIndex>=0){var tmp=strtmparray[1];var delimcnt=0;var capstart=-1;for(var pos=capIndex;pos<tmp.length;pos++){if(tmp.charAt(pos)==\"{\"){delimcnt++};if(tmp.charAt(pos)==\"}\"){delimcnt--};if(delimcnt==1&&capstart<0){capstart=pos+1};if(delimcnt==0&&capstart>0){capend=pos-1;TABcap=tmp.substring(capstart,pos);break}}}\nif(TABcap!=\"\"){var TABtbody=document.createElement(\"tbody\");var TABcaption=document.createElement(\"caption\");TABcaption.className=\"LaTeXtable centered\";var TABanchor=document.createElement(\"a\");TABanchor.className=\"LaTeXtable\";if(TABlbl!=null){TABanchor.id=TABlbl[1];}\nLaTeXCounter[\"table\"]++;var tabnmbr=makeNumberString(LaTeXCounter[\"table\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"LaTeXtable\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(tabnmbr));TABanchor.appendChild(anchorSpan);TABcaption.appendChild(TABanchor);var TABspan=document.createElement(\"span\");TABspan.className=\"LaTeXtable\";TABspan.appendChild(document.createTextNode(\"Table \"+tabnmbr+\". \"));TABcaption.appendChild(TABspan);TABcaption.appendChild(document.createTextNode(\"\"+TABcap));nodeTmp.appendChild(TABcaption);}\nvar TABinfo=strtmparray[1].match(/\\\\begin\\s*\\{\\s*tabular\\s*\\}([\\s\\S]+)\\\\end\\s*\\{\\s*tabular\\s*\\}/);if(TABinfo!=null){var TABtbody=document.createElement('tbody');var TABrow=null;var TABcell=null;var row=0;var col=0;var TABalign=TABinfo[1].match(/^\\s*\\{([^\\}]+)\\}/);TABinfo=TABinfo[1].replace(/^\\s*\\{[^\\}]+\\}/,\"\");TABinfo=TABinfo.replace(/\\\\hline/g,\"\");TABalign[1]=TABalign[1].replace(/\\|/g,\"\");TABalign[1]=TABalign[1].replace(/\\s/g,\"\");TABinfo=TABinfo.split(\"\\\\\\\\\");for(row=0;row<TABinfo.length;row++){TABrow=document.createElement(\"tr\");TABinfo[row]=TABinfo[row].split(\"&\");for(col=0;col<TABinfo[row].length;col++){TABcell=document.createElement(\"td\");switch(TABalign[1].charAt(col)){case\"l\":TABcell.align=\"left\";break;case\"c\":TABcell.align=\"center\";break;case\"r\":TABcell.align=\"right\";break;default:TABcell.align=\"left\";};TABcell.appendChild(document.createTextNode(TABinfo[row][col]));TABrow.appendChild(TABcell);}\nTABtbody.appendChild(TABrow);}\nnodeTmp.appendChild(TABtbody);}\nnewFrag.appendChild(nodeTmp);break;case\"logicalbreak\":var nodeTmp=document.createElement(\"p\");nodeTmp.className=strtmparray[1];nodeTmp.appendChild(document.createTextNode(\"\\u00A0\"));newFrag.appendChild(nodeTmp);break;case\"appendix\":inAppendix=true;sectionCntr=0;break;case\"alistitem\":var EndDiv=document.createElement(\"div\");EndDiv.className=\"endlistitem\";newFrag.appendChild(EndDiv);var BegDiv=document.createElement(\"div\");BegDiv.className=\"listitem\";if(strtmparray[1]!=\" \"){var BegSpan=document.createElement(\"span\");BegSpan.className=\"listitemmarker\";var boldBegSpan=document.createElement(\"b\");boldBegSpan.appendChild(document.createTextNode(strtmparray[1]+\" \"));BegSpan.appendChild(boldBegSpan);BegDiv.appendChild(BegSpan);}\nnewFrag.appendChild(BegDiv);break;case\"br\":newFrag.appendChild(document.createElement(\"br\"));break;case\"bibitem\":newFrag.appendChild(document.createElement(\"br\"));var nodeTmp=document.createElement(\"a\");nodeTmp.className='bibitem';var nodeSpan=document.createElement(\"span\");nodeSpan.className='bibitem';bibcntr++;var lbl=strtmparray[1].match(/\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\s*\\{\\s*\\w+\\s*\\}/g,\"\");strtmparray[1]=strtmparray[1].replace(/^\\s*\\[/,\"\");strtmparray[1]=strtmparray[1].replace(/\\s*\\]$/,\"\");strtmparray[1]=strtmparray[1].replace(/^\\s+|\\s+$/g,\"\");if(lbl==null){biblist[bibcntr]=\"bibitem\"+bibcntr}else{biblist[bibcntr]=lbl[1];};nodeTmp.name=biblist[bibcntr];nodeTmp.id=biblist[bibcntr];if(strtmparray[1]!=\"\"){nodeSpan.appendChild(document.createTextNode(strtmparray[1]));}else{nodeSpan.appendChild(document.createTextNode(\"[\"+bibcntr+\"]\"));}\nnodeTmp.appendChild(nodeSpan);newFrag.appendChild(nodeTmp);break;case\"cite\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='cite';nodeTmp.name='cite';nodeTmp.href=\"#\"+strtmparray[1];newFrag.appendChild(nodeTmp);break;case\"ref\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='ref';nodeTmp.name='ref';nodeTmp.href=\"#\"+strtmparray[1];newFrag.appendChild(nodeTmp);break;default:var nodeTmp=document.createElement(\"div\");nodeTmp.className=strtmparray[0];if(IsCounter.test(strtmparray[0])){LaTeXCounter[strtmparray[0]]++;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className=strtmparray[0];var divnum=makeNumberString(LaTeXCounter[strtmparray[0]]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=strtmparray[0];anchorSpan.appendChild(document.createTextNode(divnum));anchorSpan.style.display=\"none\";nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className=strtmparray[0];nodeSpan.appendChild(document.createTextNode(strtmparray[1]+\" \"+divnum+\". \"));nodeTmp.appendChild(nodeSpan);}\nif(isIE){if(strtmparray[0]==(\"thebibliography\"||\"abstract\"||\"keyword\"||\"proof\")){var nodeSpan=document.createElement(\"span\");nodeSpan.className=strtmparray[0];nodeSpan.appendChild(document.createTextNode(strtmparray[1]));nodeTmp.appendChild(nodeSpan);}}\nif(strtmparray[0]==\"endenumerate\"||strtmparray[0]==\"enditemize\"||strtmparray[0]==\"enddescription\"){var endDiv=document.createElement(\"div\");endDiv.className=\"endlistitem\";newFrag.appendChild(endDiv);}\nnewFrag.appendChild(nodeTmp);if(strtmparray[0]==\"enumerate\"||strtmparray[0]==\"itemize\"||strtmparray[0]==\"description\"){var endDiv=document.createElement(\"div\");endDiv.className=\"listitem\";newFrag.appendChild(endDiv);}}}else{strtmp[j]=strtmp[j].replace(/\\\\\\$/g,\"<per>\");strtmp[j]=strtmp[j].replace(/\\$([^\\$]+)\\$/g,\" \\\\[$1\\\\[ \");strtmp[j]=strtmp[j].replace(/<per>/g,\"\\\\$\");strtmp[j]=strtmp[j].replace(/\\\\begin\\s*\\{\\s*math\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*math\\s*\\}/g,\" \\\\[$1\\\\[ \");var strtmptmp=strtmp[j].split(\"\\\\[\");for(var jjj=0;jjj<strtmptmp.length;jjj++){if(jjj%2){var nodeTmp=document.createElement(\"span\");nodeTmp.className='inlinemath';nodeTmp.appendChild(document.createTextNode(\"$\"+strtmptmp[jjj]+\"$\"));newFrag.appendChild(nodeTmp);}else{var TagIndex=strtmptmp[jjj].search(/\\\\\\w+/);var tmpIndex=TagIndex;while(tmpIndex>-1){if(/^\\\\textcolor/.test(strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length))){strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\textcolor\\s*\\{\\s*(\\w+)\\s*\\}\\s*/,\" \\\\[textcolor\\\\]$1\\\\]|\");}else{if(/^\\\\colorbox/.test(strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length))){strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\colorbox\\s*\\{\\s*(\\w+)\\s*\\}\\s*/,\" \\\\[colorbox\\\\]$1\\\\]|\");}else{strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).replace(/\\\\\\s*(\\w+)\\s*/,\" \\\\[$1\\\\]|\");}}\nTagIndex+=strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).search(/\\|/);TagIndex++;strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\]\\|/,\"\\\\] \");if(strtmptmp[jjj].charAt(TagIndex)==\"{\"){strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+strtmptmp[jjj].substring(TagIndex+1,strtmptmp[jjj].length);var delimcnt=1;for(var kk=TagIndex;kk<strtmptmp[jjj].length;kk++){if(strtmptmp[jjj].charAt(kk)==\"{\"){delimcnt++};if(strtmptmp[jjj].charAt(kk)==\"}\"){delimcnt--};if(delimcnt==0){break;}}\nstrtmptmp[jjj]=strtmptmp[jjj].substring(0,kk)+\"\\\\[ \"+strtmptmp[jjj].substring(kk+1,strtmptmp[jjj].length);TagIndex=kk+3;}else{strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+\"\\\\[ \"+strtmptmp[jjj].substring(TagIndex+1,strtmptmp[jjj].length);TagIndex=TagIndex+3;}\nif(TagIndex<strtmptmp[jjj].length){tmpIndex=strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).search(/\\\\\\w+/);}\nelse{tmpIndex=-1};TagIndex+=tmpIndex;}\nstrtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\\\\\s*\\\\\\\\/g,\"\\\\\\\\\");strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\\\/g,\" \\\\[br\\\\] \\\\[ \");strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/g,\" \\\\[a\\\\]$1\\\\[ \");var strlbls=strtmptmp[jjj].split(\"\\\\[\");for(var jj=0;jj<strlbls.length;jj++){if(jj%2){var strtmparray=strlbls[jj].split(\"\\\\]\");switch(strtmparray[0]){case\"textcolor\":var nodeTmp=document.createElement(\"span\");nodeTmp.className='LaTeXColor';if(IsColorName.test(strtmparray[1].toLowerCase())){nodeTmp.style.color=LaTeXColor[strtmparray[1].toLowerCase()];}else{nodeTmp.style.color=strtmparray[1];};nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"colorbox\":var nodeTmp=document.createElement(\"span\");nodeTmp.className='LaTeXColor';if(IsColorName.test(strtmparray[1].toLowerCase())){nodeTmp.style.background=LaTeXColor[strtmparray[1].toLowerCase()];}else{nodeTmp.style.background=strtmparray[1];};nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"br\":newFrag.appendChild(document.createElement(\"br\"));break;case\"a\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathMLlabel';nodeTmp.id=strtmparray[1];nodeTmp.style.display=\"none\";newFrag.appendChild(nodeTmp);break;default:var nodeTmp=document.createElement(\"span\");nodeTmp.className=strtmparray[0];nodeTmp.appendChild(document.createTextNode(strtmparray[1]))\nnewFrag.appendChild(nodeTmp);}}else{newFrag.appendChild(document.createTextNode(strlbls[jj]));}}}}}}}};TheBody.parentNode.replaceChild(newFrag,TheBody);}}}\nreturn TheBody;}\nfunction LaTeXDivsAndRefs(thebody){var TheBody=thebody;var EndDivClass=null;var AllDivs=TheBody.getElementsByTagName(\"div\");var lbl2id=\"\";var lblnode=null;for(var i=AllDivs.length-1;i>=0;i--){EndDivClass=AllDivs[i].className.match(/end\\w+/);if(EndDivClass!=null){EndDivClass=EndDivClass[0];var DivClass=EndDivClass.substring(3,EndDivClass.length);var EndDivNode=AllDivs[i];break;}}\nwhile(EndDivClass!=null){var newFrag=document.createDocumentFragment();var RootNode=EndDivNode.parentNode;var ClassCount=1;while(EndDivNode.previousSibling!=null&&ClassCount>0){switch(EndDivNode.previousSibling.className){case EndDivClass:ClassCount++;newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);break;case DivClass:if(EndDivNode.previousSibling.nodeName==\"DIV\"){ClassCount--;if(lbl2id!=\"\"){EndDivNode.previousSibling.id=lbl2id;lbl2id=\"\"}\nif(ClassCount==0){RootNode=EndDivNode.previousSibling;}else{newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);}};break;case'LaTeXMathMLlabel':lbl2id=EndDivNode.previousSibling.id;EndDivNode.parentNode.removeChild(EndDivNode.previousSibling);break;default:newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);}}\nRootNode.appendChild(newFrag);EndDivNode.parentNode.removeChild(EndDivNode);AllDivs=TheBody.getElementsByTagName(\"DIV\");for(i=AllDivs.length-1;i>=0;i--){EndDivClass=AllDivs[i].className.match(/end\\w+/);if(EndDivClass!=null){ClassCount=0;EndDivClass=EndDivClass[0];DivClass=EndDivClass.substring(3,EndDivClass.length);EndDivNode=AllDivs[i];RootNode=EndDivNode.parentNode;break;}}}\nvar AllDivs=TheBody.getElementsByTagName(\"div\");var DIV2LI=null;for(var i=0;i<AllDivs.length;i++){if(AllDivs[i].className==\"itemize\"||AllDivs[i].className==\"enumerate\"||AllDivs[i].className==\"description\"){if(AllDivs[i].className==\"itemize\"){RootNode=document.createElement(\"UL\");}else{RootNode=document.createElement(\"OL\");}\nRootNode.className='LaTeXMathML';if(AllDivs[i].hasChildNodes()){AllDivs[i].removeChild(AllDivs[i].firstChild)};while(AllDivs[i].hasChildNodes()){if(AllDivs[i].firstChild.hasChildNodes()){DIV2LI=document.createElement(\"LI\");while(AllDivs[i].firstChild.hasChildNodes()){DIV2LI.appendChild(AllDivs[i].firstChild.firstChild);}\nif(DIV2LI.firstChild.className==\"listitemmarker\"){DIV2LI.style.listStyleType=\"none\";}\nRootNode.appendChild(DIV2LI)}\nAllDivs[i].removeChild(AllDivs[i].firstChild);}\nAllDivs[i].appendChild(RootNode);}}\nvar AllAnchors=TheBody.getElementsByTagName(\"a\");for(var i=0;i<AllAnchors.length;i++){if(AllAnchors[i].className==\"ref\"||AllAnchors[i].className==\"cite\"){var label=AllAnchors[i].href.match(/\\#(\\w+)/);if(label!=null){var labelNode=document.getElementById(label[1]);if(labelNode!=null){var TheSpans=labelNode.getElementsByTagName(\"SPAN\");if(TheSpans!=null){var refNode=TheSpans[0].cloneNode(true);refNode.style.display=\"inline\"\nrefNode.className=AllAnchors[i].className;AllAnchors[i].appendChild(refNode);}}}}}\nreturn TheBody;}\nvar AMbody;var AMnoMathML=false,AMtranslated=false;function translate(spanclassAM){if(!AMtranslated){AMtranslated=true;AMinitSymbols();var LaTeXContainers=[];var AllContainers=document.getElementsByTagName('*');var ExtendName=\"\";for(var k=0,l=0;k<AllContainers.length;k++){ExtendName=\" \"+AllContainers[k].className+\" \";if(ExtendName.match(/\\sLaTeX\\s/)!=null){LaTeXContainers[l]=AllContainers[k];l++;}};if(LaTeXContainers.length>0){for(var m=0;m<LaTeXContainers.length;m++){AMbody=LaTeXContainers[m];try{AMbody=LaTeXDivsAndRefs(LaTeXpreProcess(AMbody));}catch(err){alert(\"Unknown Error: Defaulting to Original LaTeXMathML\");}\nif(AMbody.tagName==\"PRE\"){var PreChilds=document.createDocumentFragment();var DivChilds=document.createElement(\"DIV\");while(AMbody.hasChildNodes()){DivChilds.appendChild(AMbody.firstChild);}\nPreChilds.appendChild(DivChilds);AMbody.parentNode.replaceChild(PreChilds,AMbody);AMbody=DivChilds;}\nAMprocessNode(AMbody,false,spanclassAM);}}else{AMbody=document.getElementsByTagName(\"body\")[0];try{AMbody=LaTeXDivsAndRefs(LaTeXpreProcess(AMbody));}catch(err){alert(\"Unknown Error: Defaulting to Original LaTeXMathML\");}\nAMprocessNode(AMbody,false,spanclassAM);}}}\nif(isIE){document.write(\"<object id=\\\"mathplayer\\\" classid=\\\"clsid:32F66A20-7614-11D4-BD11-00104BD3F987\\\"></object>\");document.write(\"<?import namespace=\\\"m\\\" implementation=\\\"#mathplayer\\\"?>\");}\nfunction generic()\n{translate();};if(typeof window.addEventListener!='undefined')\n{window.addEventListener('load',generic,false);}\nelse if(typeof document.addEventListener!='undefined')\n{document.addEventListener('load',generic,false);}\nelse if(typeof window.attachEvent!='undefined')\n{window.attachEvent('onload',generic);}\nelse\n{if(typeof window.onload=='function')\n{var existing=onload;window.onload=function()\n{existing();generic();};}\nelse\n{window.onload=generic;}}\n"),("MathMLinHTML.js","/* \nMarch 19, 2004 MathHTML (c) Peter Jipsen http://www.chapman.edu/~jipsen\nReleased under the GNU General Public License version 2 or later.\nSee the GNU General Public License (at http://www.gnu.org/copyleft/gpl.html)\nfor more details.\n*/\n\nfunction convertMath(node) {// for Gecko\n  if (node.nodeType==1) {\n    var newnode = \n      document.createElementNS(\"http://www.w3.org/1998/Math/MathML\",\n        node.nodeName.toLowerCase());\n    for(var i=0; i < node.attributes.length; i++)\n      newnode.setAttribute(node.attributes[i].nodeName,\n        node.attributes[i].nodeValue);\n    for (var i=0; i<node.childNodes.length; i++) {\n      var st = node.childNodes[i].nodeValue;\n      if (st==null || st.slice(0,1)!=\" \" && st.slice(0,1)!=\"\\n\") \n        newnode.appendChild(convertMath(node.childNodes[i]));\n    }\n    return newnode;\n  }\n  else return node;\n}\n\nfunction convert() {\n  var mmlnode = document.getElementsByTagName(\"math\");\n  var st,str,node,newnode;\n  for (var i=0; i<mmlnode.length; i++)\n    if (document.createElementNS!=null)\n      mmlnode[i].parentNode.replaceChild(convertMath(mmlnode[i]),mmlnode[i]);\n    else { // convert for IE\n      str = \"\";\n      node = mmlnode[i];\n      while (node.nodeName!=\"/MATH\") {\n        st = node.nodeName.toLowerCase();\n        if (st==\"#text\") str += node.nodeValue;\n        else {\n          str += (st.slice(0,1)==\"/\" ? \"</m:\"+st.slice(1) : \"<m:\"+st);\n          if (st.slice(0,1)!=\"/\") \n             for(var j=0; j < node.attributes.length; j++)\n               if (node.attributes[j].nodeValue!=\"italic\" &&\n                 node.attributes[j].nodeValue!=\"\" &&\n                 node.attributes[j].nodeValue!=\"inherit\" &&\n                 node.attributes[j].nodeValue!=undefined)\n                 str += \" \"+node.attributes[j].nodeName+\"=\"+\n                     \"\\\"\"+node.attributes[j].nodeValue+\"\\\"\";\n          str += \">\";\n        }\n        node = node.nextSibling;\n        node.parentNode.removeChild(node.previousSibling);\n      }\n      str += \"</m:math>\";\n      newnode = document.createElement(\"span\");\n      node.parentNode.replaceChild(newnode,node);\n      newnode.innerHTML = str;\n    }\n}\n\nif (document.createElementNS==null) {\n  document.write(\"<object id=\\\"mathplayer\\\"\\\n  classid=\\\"clsid:32F66A20-7614-11D4-BD11-00104BD3F987\\\"></object>\");\n  document.write(\"<?import namespace=\\\"m\\\" implementation=\\\"#mathplayer\\\"?>\");\n}\nif(typeof window.addEventListener != 'undefined'){\n  window.addEventListener('load', convert, false);\n}\nif(typeof window.attachEvent != 'undefined') {\n  window.attachEvent('onload', convert);\n}\n"),("pandoc.lua","-- pandoc.lua\n-- This module contains most of David Heiko Kolf's dkjson.lua\n-- (license below), plus some functions to help with pandoc\n-- scripting in lua.\n\n    -- Module options:\n    local register_global_module_table = false\n    local global_module_name = 'json'\n\n    --[==[\n--------------------------------------------------------------------\n\n*Copyright (C) 2010-2013 David Heiko Kolf*\n\nPermission is hereby granted, free of charge, to any person obtaining\na copy of this software and associated documentation files (the\n\"Software\"), to deal in the Software without restriction, including\nwithout limitation the rights to use, copy, modify, merge, publish,\ndistribute, sublicense, and/or sell copies of the Software, and to\npermit persons to whom the Software is furnished to do so, subject to\nthe following conditions:\n\nThe above copyright notice and this permission notice shall be\nincluded in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\nEXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\nMERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\nNONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS\nBE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN\nACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\nCONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n<!--]==]\n\n-- global dependencies:\nlocal pairs, type, tostring, tonumber, getmetatable, setmetatable, rawset =\n      pairs, type, tostring, tonumber, getmetatable, setmetatable, rawset\nlocal error, require, pcall, select = error, require, pcall, select\nlocal floor, huge = math.floor, math.huge\nlocal strrep, gsub, strsub, strbyte, strchar, strfind, strlen, strformat =\n      string.rep, string.gsub, string.sub, string.byte, string.char,\n      string.find, string.len, string.format\nlocal concat = table.concat\n\nlocal json = { version = \"dkjson 2.3\" }\n\nif register_global_module_table then\n  _G[global_module_name] = json\nend\n\nlocal _ENV = nil -- blocking globals in Lua 5.2\n\npcall (function()\n  -- Enable access to blocked metatables.\n  -- Don't worry, this module doesn't change anything in them.\n  local debmeta = require \"debug\".getmetatable\n  if debmeta then getmetatable = debmeta end\nend)\n\njson.null = setmetatable ({}, {\n  __tojson = function () return \"null\" end\n})\n\nlocal function isarray (tbl)\n  local max, n, arraylen = 0, 0, 0\n  for k,v in pairs (tbl) do\n    if k == 'n' and type(v) == 'number' then\n      arraylen = v\n      if v > max then\n        max = v\n      end\n    else\n      if type(k) ~= 'number' or k < 1 or floor(k) ~= k then\n        return false\n      end\n      if k > max then\n        max = k\n      end\n      n = n + 1\n    end\n  end\n  if max > 10 and max > arraylen and max > n * 2 then\n    return false -- don't create an array with too many holes\n  end\n  return true, max\nend\n\nlocal escapecodes = {\n  [\"\\\"\"] = \"\\\\\\\"\", [\"\\\\\"] = \"\\\\\\\\\", [\"\\b\"] = \"\\\\b\", [\"\\f\"] = \"\\\\f\",\n  [\"\\n\"] = \"\\\\n\",  [\"\\r\"] = \"\\\\r\",  [\"\\t\"] = \"\\\\t\"\n}\n\nlocal function escapeutf8 (uchar)\n  local value = escapecodes[uchar]\n  if value then\n    return value\n  end\n  local a, b, c, d = strbyte (uchar, 1, 4)\n  a, b, c, d = a or 0, b or 0, c or 0, d or 0\n  if a <= 0x7f then\n    value = a\n  elseif 0xc0 <= a and a <= 0xdf and b >= 0x80 then\n    value = (a - 0xc0) * 0x40 + b - 0x80\n  elseif 0xe0 <= a and a <= 0xef and b >= 0x80 and c >= 0x80 then\n    value = ((a - 0xe0) * 0x40 + b - 0x80) * 0x40 + c - 0x80\n  elseif 0xf0 <= a and a <= 0xf7 and b >= 0x80 and c >= 0x80 and d >= 0x80 then\n    value = (((a - 0xf0) * 0x40 + b - 0x80) * 0x40 + c - 0x80) * 0x40 + d - 0x80\n  else\n    return \"\"\n  end\n  if value <= 0xffff then\n    return strformat (\"\\\\u%.4x\", value)\n  elseif value <= 0x10ffff then\n    -- encode as UTF-16 surrogate pair\n    value = value - 0x10000\n    local highsur, lowsur = 0xD800 + floor (value/0x400), 0xDC00 + (value % 0x400)\n    return strformat (\"\\\\u%.4x\\\\u%.4x\", highsur, lowsur)\n  else\n    return \"\"\n  end\nend\n\nlocal function fsub (str, pattern, repl)\n  -- gsub always builds a new string in a buffer, even when no match\n  -- exists. First using find should be more efficient when most strings\n  -- don't contain the pattern.\n  if strfind (str, pattern) then\n    return gsub (str, pattern, repl)\n  else\n    return str\n  end\nend\n\nlocal function quotestring (value)\n  -- based on the regexp \"escapable\" in https://github.com/douglascrockford/JSON-js\n  value = fsub (value, \"[%z\\1-\\31\\\"\\\\\\127]\", escapeutf8)\n  if strfind (value, \"[\\194\\216\\220\\225\\226\\239]\") then\n    value = fsub (value, \"\\194[\\128-\\159\\173]\", escapeutf8)\n    value = fsub (value, \"\\216[\\128-\\132]\", escapeutf8)\n    value = fsub (value, \"\\220\\143\", escapeutf8)\n    value = fsub (value, \"\\225\\158[\\180\\181]\", escapeutf8)\n    value = fsub (value, \"\\226\\128[\\140-\\143\\168-\\175]\", escapeutf8)\n    value = fsub (value, \"\\226\\129[\\160-\\175]\", escapeutf8)\n    value = fsub (value, \"\\239\\187\\191\", escapeutf8)\n    value = fsub (value, \"\\239\\191[\\176-\\191]\", escapeutf8)\n  end\n  return \"\\\"\" .. value .. \"\\\"\"\nend\njson.quotestring = quotestring\n\nlocal function addnewline2 (level, buffer, buflen)\n  buffer[buflen+1] = \"\\n\"\n  buffer[buflen+2] = strrep (\"  \", level)\n  buflen = buflen + 2\n  return buflen\nend\n\nfunction json.addnewline (state)\n  if state.indent then\n    state.bufferlen = addnewline2 (state.level or 0,\n                           state.buffer, state.bufferlen or #(state.buffer))\n  end\nend\n\nlocal encode2 -- forward declaration\n\nlocal function addpair (key, value, prev, indent, level, buffer, buflen, tables, globalorder)\n  local kt = type (key)\n  if kt ~= 'string' and kt ~= 'number' then\n    return nil, \"type '\" .. kt .. \"' is not supported as a key by JSON.\"\n  end\n  if prev then\n    buflen = buflen + 1\n    buffer[buflen] = \",\"\n  end\n  if indent then\n    buflen = addnewline2 (level, buffer, buflen)\n  end\n  buffer[buflen+1] = quotestring (key)\n  buffer[buflen+2] = \":\"\n  return encode2 (value, indent, level, buffer, buflen + 2, tables, globalorder)\nend\n\nencode2 = function (value, indent, level, buffer, buflen, tables, globalorder)\n  local valtype = type (value)\n  local valmeta = getmetatable (value)\n  valmeta = type (valmeta) == 'table' and valmeta -- only tables\n  local valtojson = valmeta and valmeta.__tojson\n  if valtojson then\n    if tables[value] then\n      return nil, \"reference cycle\"\n    end\n    tables[value] = true\n    local state = {\n        indent = indent, level = level, buffer = buffer,\n        bufferlen = buflen, tables = tables, keyorder = globalorder\n    }\n    local ret, msg = valtojson (value, state)\n    if not ret then return nil, msg end\n    tables[value] = nil\n    buflen = state.bufferlen\n    if type (ret) == 'string' then\n      buflen = buflen + 1\n      buffer[buflen] = ret\n    end\n  elseif value == nil then\n    buflen = buflen + 1\n    buffer[buflen] = \"null\"\n  elseif valtype == 'number' then\n    local s\n    if value ~= value or value >= huge or -value >= huge then\n      -- This is the behaviour of the original JSON implementation.\n      s = \"null\"\n    else\n      s = tostring (value)\n    end\n    buflen = buflen + 1\n    buffer[buflen] = s\n  elseif valtype == 'boolean' then\n    buflen = buflen + 1\n    buffer[buflen] = value and \"true\" or \"false\"\n  elseif valtype == 'string' then\n    buflen = buflen + 1\n    buffer[buflen] = quotestring (value)\n  elseif valtype == 'table' then\n    if tables[value] then\n      return nil, \"reference cycle\"\n    end\n    tables[value] = true\n    level = level + 1\n    local isa, n = isarray (value)\n    if n == 0 and valmeta and valmeta.__jsontype == 'object' then\n      isa = false\n    end\n    local msg\n    if isa then -- JSON array\n      buflen = buflen + 1\n      buffer[buflen] = \"[\"\n      for i = 1, n do\n        buflen, msg = encode2 (value[i], indent, level, buffer, buflen, tables, globalorder)\n        if not buflen then return nil, msg end\n        if i < n then\n          buflen = buflen + 1\n          buffer[buflen] = \",\"\n        end\n      end\n      buflen = buflen + 1\n      buffer[buflen] = \"]\"\n    else -- JSON object\n      local prev = false\n      buflen = buflen + 1\n      buffer[buflen] = \"{\"\n      local order = valmeta and valmeta.__jsonorder or globalorder\n      if order then\n        local used = {}\n        n = #order\n        for i = 1, n do\n          local k = order[i]\n          local v = value[k]\n          if v then\n            used[k] = true\n            buflen, msg = addpair (k, v, prev, indent, level, buffer, buflen, tables, globalorder)\n            prev = true -- add a seperator before the next element\n          end\n        end\n        for k,v in pairs (value) do\n          if not used[k] then\n            buflen, msg = addpair (k, v, prev, indent, level, buffer, buflen, tables, globalorder)\n            if not buflen then return nil, msg end\n            prev = true -- add a seperator before the next element\n          end\n        end\n      else -- unordered\n        for k,v in pairs (value) do\n          buflen, msg = addpair (k, v, prev, indent, level, buffer, buflen, tables, globalorder)\n          if not buflen then return nil, msg end\n          prev = true -- add a seperator before the next element\n        end\n      end\n      if indent then\n        buflen = addnewline2 (level - 1, buffer, buflen)\n      end\n      buflen = buflen + 1\n      buffer[buflen] = \"}\"\n    end\n    tables[value] = nil\n  else\n    return nil, \"type '\" .. valtype .. \"' is not supported by JSON.\"\n  end\n  return buflen\nend\n\nfunction json.encode (value, state)\n  state = state or {}\n  local oldbuffer = state.buffer\n  local buffer = oldbuffer or {}\n  local ret, msg = encode2 (value, state.indent, state.level or 0,\n                   buffer, state.bufferlen or 0, state.tables or {}, state.keyorder)\n  if not ret then\n    error (msg, 2)\n  elseif oldbuffer then\n    state.bufferlen = ret\n    return true\n  else\n    return concat (buffer)\n  end\nend\n\nlocal function loc (str, where)\n  local line, pos, linepos = 1, 1, 0\n  while true do\n    pos = strfind (str, \"\\n\", pos, true)\n    if pos and pos < where then\n      line = line + 1\n      linepos = pos\n      pos = pos + 1\n    else\n      break\n    end\n  end\n  return \"line \" .. line .. \", column \" .. (where - linepos)\nend\n\nlocal function unterminated (str, what, where)\n  return nil, strlen (str) + 1, \"unterminated \" .. what .. \" at \" .. loc (str, where)\nend\n\nlocal function scanwhite (str, pos)\n  while true do\n    pos = strfind (str, \"%S\", pos)\n    if not pos then return nil end\n    if strsub (str, pos, pos + 2) == \"\\239\\187\\191\" then\n      -- UTF-8 Byte Order Mark\n      pos = pos + 3\n    else\n      return pos\n    end\n  end\nend\n\nlocal escapechars = {\n  [\"\\\"\"] = \"\\\"\", [\"\\\\\"] = \"\\\\\", [\"/\"] = \"/\", [\"b\"] = \"\\b\", [\"f\"] = \"\\f\",\n  [\"n\"] = \"\\n\", [\"r\"] = \"\\r\", [\"t\"] = \"\\t\"\n}\n\nlocal function unichar (value)\n  if value < 0 then\n    return nil\n  elseif value <= 0x007f then\n    return strchar (value)\n  elseif value <= 0x07ff then\n    return strchar (0xc0 + floor(value/0x40),\n                    0x80 + (floor(value) % 0x40))\n  elseif value <= 0xffff then\n    return strchar (0xe0 + floor(value/0x1000),\n                    0x80 + (floor(value/0x40) % 0x40),\n                    0x80 + (floor(value) % 0x40))\n  elseif value <= 0x10ffff then\n    return strchar (0xf0 + floor(value/0x40000),\n                    0x80 + (floor(value/0x1000) % 0x40),\n                    0x80 + (floor(value/0x40) % 0x40),\n                    0x80 + (floor(value) % 0x40))\n  else\n    return nil\n  end\nend\n\nlocal function scanstring (str, pos)\n  local lastpos = pos + 1\n  local buffer, n = {}, 0\n  while true do\n    local nextpos = strfind (str, \"[\\\"\\\\]\", lastpos)\n    if not nextpos then\n      return unterminated (str, \"string\", pos)\n    end\n    if nextpos > lastpos then\n      n = n + 1\n      buffer[n] = strsub (str, lastpos, nextpos - 1)\n    end\n    if strsub (str, nextpos, nextpos) == \"\\\"\" then\n      lastpos = nextpos + 1\n      break\n    else\n      local escchar = strsub (str, nextpos + 1, nextpos + 1)\n      local value\n      if escchar == \"u\" then\n        value = tonumber (strsub (str, nextpos + 2, nextpos + 5), 16)\n        if value then\n          local value2\n          if 0xD800 <= value and value <= 0xDBff then\n            -- we have the high surrogate of UTF-16. Check if there is a\n            -- low surrogate escaped nearby to combine them.\n            if strsub (str, nextpos + 6, nextpos + 7) == \"\\\\u\" then\n              value2 = tonumber (strsub (str, nextpos + 8, nextpos + 11), 16)\n              if value2 and 0xDC00 <= value2 and value2 <= 0xDFFF then\n                value = (value - 0xD800)  * 0x400 + (value2 - 0xDC00) + 0x10000\n              else\n                value2 = nil -- in case it was out of range for a low surrogate\n              end\n            end\n          end\n          value = value and unichar (value)\n          if value then\n            if value2 then\n              lastpos = nextpos + 12\n            else\n              lastpos = nextpos + 6\n            end\n          end\n        end\n      end\n      if not value then\n        value = escapechars[escchar] or escchar\n        lastpos = nextpos + 2\n      end\n      n = n + 1\n      buffer[n] = value\n    end\n  end\n  if n == 1 then\n    return buffer[1], lastpos\n  elseif n > 1 then\n    return concat (buffer), lastpos\n  else\n    return \"\", lastpos\n  end\nend\n\nlocal scanvalue -- forward declaration\n\nlocal function scantable (what, closechar, str, startpos, nullval, objectmeta, arraymeta)\n  local len = strlen (str)\n  local tbl, n = {}, 0\n  local pos = startpos + 1\n  if what == 'object' then\n    setmetatable (tbl, objectmeta)\n  else\n    setmetatable (tbl, arraymeta)\n  end\n  while true do\n    pos = scanwhite (str, pos)\n    if not pos then return unterminated (str, what, startpos) end\n    local char = strsub (str, pos, pos)\n    if char == closechar then\n      return tbl, pos + 1\n    end\n    local val1, err\n    val1, pos, err = scanvalue (str, pos, nullval, objectmeta, arraymeta)\n    if err then return nil, pos, err end\n    pos = scanwhite (str, pos)\n    if not pos then return unterminated (str, what, startpos) end\n    char = strsub (str, pos, pos)\n    if char == \":\" then\n      if val1 == nil then\n        return nil, pos, \"cannot use nil as table index (at \" .. loc (str, pos) .. \")\"\n      end\n      pos = scanwhite (str, pos + 1)\n      if not pos then return unterminated (str, what, startpos) end\n      local val2\n      val2, pos, err = scanvalue (str, pos, nullval, objectmeta, arraymeta)\n      if err then return nil, pos, err end\n      tbl[val1] = val2\n      pos = scanwhite (str, pos)\n      if not pos then return unterminated (str, what, startpos) end\n      char = strsub (str, pos, pos)\n    else\n      n = n + 1\n      tbl[n] = val1\n    end\n    if char == \",\" then\n      pos = pos + 1\n    end\n  end\nend\n\nscanvalue = function (str, pos, nullval, objectmeta, arraymeta)\n  pos = pos or 1\n  pos = scanwhite (str, pos)\n  if not pos then\n    return nil, strlen (str) + 1, \"no valid JSON value (reached the end)\"\n  end\n  local char = strsub (str, pos, pos)\n  if char == \"{\" then\n    return scantable ('object', \"}\", str, pos, nullval, objectmeta, arraymeta)\n  elseif char == \"[\" then\n    return scantable ('array', \"]\", str, pos, nullval, objectmeta, arraymeta)\n  elseif char == \"\\\"\" then\n    return scanstring (str, pos)\n  else\n    local pstart, pend = strfind (str, \"^%-?[%d%.]+[eE]?[%+%-]?%d*\", pos)\n    if pstart then\n      local number = tonumber (strsub (str, pstart, pend))\n      if number then\n        return number, pend + 1\n      end\n    end\n    pstart, pend = strfind (str, \"^%a%w*\", pos)\n    if pstart then\n      local name = strsub (str, pstart, pend)\n      if name == \"true\" then\n        return true, pend + 1\n      elseif name == \"false\" then\n        return false, pend + 1\n      elseif name == \"null\" then\n        return nullval, pend + 1\n      end\n    end\n    return nil, pos, \"no valid JSON value at \" .. loc (str, pos)\n  end\nend\n\nlocal function optionalmetatables(...)\n  if select(\"#\", ...) > 0 then\n    return ...\n  else\n    return {__jsontype = 'object'}, {__jsontype = 'array'}\n  end\nend\n\nfunction json.decode (str, pos, nullval, ...)\n  local objectmeta, arraymeta = optionalmetatables(...)\n  return scanvalue (str, pos, nullval, objectmeta, arraymeta)\nend\n\n\n-- pandoc-specific stuff\n\nfunction isArray(x)\n  local mt = getmetatable(x) or {}\n  if type(x) ~= \"table\" then\n    return false\n  elseif mt.__jsontype == 'array' then\n    return true\n  elseif x[1] then\n    return true\n  else\n    return (x == {})\n  end\nend\n\nfunction isObject(x)\n  local mt = getmetatable(x) or {}\n  if type(x) ~= \"table\" then\n    return false\n  elseif mt.__jsontype == 'object' then\n    return true\n  elseif x[1] then\n    return false\n  else\n    return false\n  end\nend\n\nfunction emptyArray()\n  local array = {}\n  setmetatable(array, {__jsontype = 'array'})\n  return array\nend\n\nfunction emptyObject()\n  local obj = {}\n  setmetatable(obj, {__jsontype = 'object'})\n  return obj\nend\n\n-- Walk a JSON-encoded pandoc structure, performing\n-- 'action' on each object encountered, and possibly\n-- replacing or deleting it.  The 'format' parameter\n-- allows 'action' to be sensitive to the intended\n-- output format.\n--\n-- JSON-encoded pandoc Inline and Block objects have\n-- the structure {key: value}, where key is 'Str',\n-- 'Para', etc., and value is invariably an array.\n-- 'action' takes three parameters: the key of the\n-- current object, the value, and the intended output\n-- format.  It can return two values.  If the first\n-- value is nil, the object is left unchanged.  If\n-- the first value is the empty table {}, the object\n-- is deleted.  Otherwise, we expect the first value\n-- to be a key (possibly a different one) and the\n-- second a value.  The original object is replaced\n-- with a new object with the specified key and value.\nfunction walk(x, action, format)\n  if isArray(x) then\n    local array, j = {}, 1\n    setmetatable(array, {__jsontype = 'array'})\n    for _,w in pairs(x) do\n      if isObject(w) then\n        for kk,vv in pairs(w) do -- should be just one\n          local res, extra = action(kk, vv, format)\n          if res == nil then\n            array[j] = walk(w, action, format)\n            j = j + 1\n          elseif isArray(res) then\n            for _,z in pairs(res) do\n              array[j] = walk(z, action, format)\n              j = j + 1\n            end\n          elseif type(res) == \"string\" and extra then\n            local newobj = {[res] = walk(extra, action, format)}\n            setmetatable(newobj, {__jsontype = 'object'})\n            array[j] = newobj\n            j = j + 1\n          else\n            array[j] = walk(res, action, format)\n            j = j + 1\n          end\n        end\n      else\n        array[j] = walk(w, action, format)\n        j = j + 1\n      end\n    end\n    return array\n  elseif isObject(x) then\n    local obj = {}\n    setmetatable(obj, {__jsontype = 'object'})\n    for k,v in pairs(x) do\n      obj[k] = walk(v, action, format)\n    end\n    return obj\n  else  -- basic type\n    return x\n  end\nend\n\n-- 'filter(action)' promotes an action (as described above)\n-- to a function that transforms a JSON-encoded pandoc\n-- structure.\nfunction filter(action)\n  return function(text, format)\n    local doc = json.decode(text)\n    return json.encode(walk(doc, action, format))\n  end\nend\n\n-- convenience function for creating RawInline elements.\nfunction rawInline(format, s)\n  return {RawInline = {{unFormat = format}, s}}\nend\n\n-- convenience function for creating RawBlock elements.\nfunction rawBlock(format, s)\n  return {RawBlock = {{unFormat = format}, s}}\nend\n\n-- convenience function for creating attributes.\n-- attributes{id = \"smith\", classes = {\"green\", \"square\"}}.\nfunction attributes(attrs)\n  attrs = attrs or {}\n  local keyvals = {}\n  for k,v in pairs(attrs) do\n    if k ~= \"id\" and k ~= \"classes\" then\n      keyvals[k] = v\n    end\n  end\n  return {attrs.id or \"\", attrs.classes or {}, keyvals}\nend\n"),("reference.docx","PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\NAK\184WB\179M\143\225m\SOH\NUL\NUL*\a\NUL\NUL\DC3\NUL\FS\NUL[Content_Types].xmlUT\t\NUL\ETX\153\186)Q\153\186)Qux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\181\149\203n\131\&0\DLEE\247\249\n\196\182\STX\167]tQ\133n\218n\219H\205\SI8f n\253\146=y\253}\199P\161\144E \175\r\210\216\190\231^\198\131\152-\246\SOB\178\211\202\132\"]!\186\ETB\198\130X\129\230!\183\SO\f\237T\214k\142T\250\154\&9.~y\r\236i:}f\194\SUB\EOT\131\EMFF\250:I\146\217\215\ACK\188\151%$s\238\241\147k(R\182\181\190d[X~\ETX\162\&4u\200\137\153&o\173\&8\250\ETB)wNI\193QZ\195\&6\166<r\206lUI\SOH\165\NAKkM\146<\STX\157\183\STXB \158V\249\SOH\252!\194\217\233,f\173\151\224\233\244\237\147t\232\&19\194\221\SUB\DC2\206\232\ACK\210eC\251|\188:I\131\EM\227Z\145\199\130/\NAK\220\254\229;\244@\SO\"\204\189u\129\145\223\213)`G\202\DC2\202\140\162\&8\240(a\168\249\157\189\176\254\130.\252\DEL\137yT\143\&7m\231\SO\247\n\238\&1u\rwL\130\142q\243\f\221\142\230\210\140\ESCD\139\198\226=\250\209\161\SIr\188C\197\215\n/\186j\SI\170\&9\DC3V\210\181\204\228#\142]\160\181\"\165\221\&0\214\228X{F>WV=i\172OH\165\142\191\139]\ACK\186/\139\245\160\204\153\186\239E\245\160\232\199A_\213,\f\202j\217\SI\CANk\DC2\205X\243\135|\157\252\SOHPK\ETX\EOT\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ACK\NUL\FS\NUL_rels/UT\t\NUL\ETX4\249\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULzn#@5\145\&2W\238\NUL\NUL\NULj\STX\NUL\NUL\v\NUL\FS\NUL_rels/.relsUT\t\NUL\ETXxx\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\173\146\193J\196\&0\DLE\134\207.\236;\132\185o\211U\DC1\145\198\189\136\176\&7\145\250\NULCf\218\ACK\219$$\163\238\190\189\DC1\EOT\183 U\193c\254\204|\243MH\179;L\163z\229\148]\240\ACK\182U\r\138\189\r\228|o\224\169\189\223\\\131\202\130\158p\f\158\r\FS9\195\238v\189j\RSyD)Myp1\171B\241\217\192 \DC2o\180\206v\224\ts\NAK\"\251r\211\133\&4\161\148c\234uD\251\140=\235\243\186\190\210\233\148\SOH\133\186^\157\205\192jO\ACK\210\158.A\181\199\200\191\EM\DLE\186\206Y\190\v\246eb/\223\204\209|\DLE\246\196\180\137\169\244'qe%\213b\234Y\fP\176\SI%\206\SUBc\172\n\SUB\244\130\214\246?\181\230\NAK_Fo!\145\166\207\248G\165\139\191*\209\130\210\196\130\132\130\218\134\196\203\207\245Qq\"\215\232\217\255(\217;PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\t\NUL\FS\NULdocProps/UT\t\NUL\ETX4\249\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\229[#@,,\fwJ\SOH\NUL\NUL\174\STX\NUL\NUL\DLE\NUL\FS\NULdocProps/app.xmlUT\t\NUL\ETX~W\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157R\193N\195\&0\f\189\239+\170\221i\198`\ETXM!\DC2\218\SO\FS\NULMZa\231(u\219hi\DC2%\EM\218\254\RS{\221J'8\209\147\253\158\223\179\251Z\190\SO\206CH\SUBbvh\141\141O\227&%\191`,\170\ACKZ\EMs\164-2\149\v\173L\216\134\154\185\170\210\nVN\237[\176\137M'\147\&9\131C\STX[By\227{\195q\231\184\248J\255\&5-\157\162\251\226gq\244\232'FY\198\183.\148Q<\222q\214U\132m\SUB\EM\160D\173\168\164\137\192\217\SI@\244\v\170\131\209v\ETB\151\141\180\&5\148\151\177\223\EOT\141\191j\vQ\220N9\235*\194\158\189\255\132\DLE\181\179H\228\DC3|8\ESC`g\217.~\248\194\173d\130\203\134k\240\236d\180\146\137doZ\ENQ\ETB]\149\&2z\151\140\156\243\206\184\US!\t\RS\ETB\164J\184k\171S\179\241R\225U3\138\224O\134$\ENQ\180\222\208\202w\138\216\228\165K-g=J#\152\206\ACK\212>\232t\DC4\184t\216\158\FS\\\146\166\208-\136\&9\n\251\230\DC4\183\146\ACK\150\248a\250\184{\224\250\\q\255\&0\ESC\RSy\162\215\216\213A\250\ACK\191\"g\131\174#k\202\158p*FX\244\255\147\CAN}\ETXPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULan#@\177\t\162\248S\SOH\NUL\NUL\175\ETX\NUL\NUL\DC1\NUL\FS\NULdocProps/core.xmlUT\t\NUL\ETXFx\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\205\147?O\195\&0\DLE\197\247~\138({\234\&8\165\fQ\155\SOH\DLE\DC3\149*Q\t\196f\236kk\154\216\209\249J\218o\143\ESC\236\136 \150n\140\231\247\238\231w\254\179\&0./\165EX\163m\SOHI\131KNMm\\\233\133e\186'jK\198\156\220C#\220\212[\140W\183\SYN\ESCA\190\196\GSk\133<\136\GS\176\"\207oY\ETX$\148 \193.\196\172\GS\144i5I\146\133\146%i\170!l\160\228\192o\143X\247\&4%\EM\212\208\128!\199\248\148\179\180Z\v\163\172L\DLE\182\128`$$\190:-XdE\176;\190\DEL\128\164\171\208=%4F\142D\DLEd\241zNh\236\&9\151\&3=\192\185\179\168\156WGe\212k\225he\149\222jPw\231\224\250\181\CAN\189\b\159\218ik*\254m\ESC\234h\144\130`g1b\134\&2\f\165\192I\212-\249\150\235\a\251\209\FSx\EOT\216\184\239\129A\ENQ\224\201\233\129\216u\221\180\155\245L\255*8{]==\247\SI(\211\198\145\240\151\152\SO1z\214\159Yz\133y\167\211%\157[X\166q\231\151\217\253\195\230\&1\173\138\156\ETBY\206\179|\182\225\188,\230\229\252\230\237\DC2y\148o\148\185\tg\251oC\199\128\213$\220\228\232gV\147/PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL\193\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ENQ\NUL\FS\NULword/UT\t\NUL\ETX\n\250\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL\200\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\FS\NULword/_rels/UT\t\NUL\ETX\ETB\250\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\135\161%B\198UX\DEL\226\NUL\NUL\NUL.\EOT\NUL\NUL\FS\NUL\FS\NULword/_rels/document.xml.relsUT\t\NUL\ETX\157\249\232P\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\189\212K\SO\194 \DC4\ENQ\208\185\171 ,@\180\254\DC2\211:r\226T\187\SOHZ_?\177|\STX\207\168\187\151\168i\159\209\129\DC3\EM\146\v\151\ETX!\164{\232$\182F\251\166\181\158]U\167}\198\ESCD\187\SYN\194\151\r(\233\199\198\130\SOIe\156\146\CAN\134\174\SYNV\150'Y\131H&\147\165p\180\131oF\140\165\180\150\229\&7\v\191\148\154\170jK\216\154\242\172@\227\151n\161\207\170\NUL\215\234\154\135Mv\199\140\187\221q\202Y.]\r\152\241>\RS\135f\206\196?)\RSo\GSx\226H\ACK\199\&3\139\129\NUL\196p\\\202\152\DC1\198+\141\NUL\185@q\248\180\204\a\v\153\DLE\129S\EM\141\185,: \152\197\128\233\227\b\DC4\fk)c90\RS\209s\194\&4\202\165\CAN\212\ACK\223\RS\237\138^\202+\238)\169x\251\GS6\163;PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\194n#@R\138\243\174\157\NUL\NUL\NUL\227\NUL\NUL\NUL\DC1\NUL\FS\NULword/document.xmlUT\t\NUL\ETX\252x\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULE\142I\SO\194\&0\fE\247=\133\149=Ma\129P\213a\203\&5B\226\SOR\DC2GIJ\225\246\184\131\196\234?\235\235?\185\233?\206\194\ESCc\154\201\183\226ZV\STX\208k2\179\US[\177\228\225\242\DLE\208wE\179\214\134\244\226\208g\224\133O\245\218\138)\231PK\153\244\132N\165\146\STXz\238\ACK\138Ne>\227(W\138&D\210\152\DC2\v\157\149\183\170\186K\167f/v\231\139\204w\135\208\NAK\NUL\156q\203\157\242A\NULO\180\150\128M\214\148G)\207v\ETX\RSl\DC1\142\&8}\242\255mW\252\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULTK#@jp<\224\155\SOH\NUL\NUL\229\b\NUL\NUL\DC2\NUL\FS\NULword/fontTable.xmlUT\t\NUL\ETXP:\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\229\149MK\195@\DLE\134\207\n\254\135\176w\155MZ5\150F\209J\143\RS\252\192\243\&4\221\&4\v\251\DC1v\182\141\253\247N\210\134\182\168Q\EOTO\t,l\222wvvx\152I&\183\239Z\ENQk\225PZ\147\178h\192Y Lf\ETB\210,S\246\250\&2;OX\128\RS\204\STX\148\&5\"e\ESC\129\236\246\230\236tR\141sk<\ACKt\222\224\216\165\172\240\190\FS\135!f\133\208\128\ETX[\nC^n\157\ACKO\175n\EM\218<\151\153x\176\217J\v\227\195\152\243\203\208\t\ENQ\158\238\198B\150\200v\217\170\223d\171\172[\148\206f\STX\145\138\213j\155O\131\&4\140\234;\217\NAK\CANTc\ETX\154\n\DEL\222\232\185U\141U{%\CAN\139\"\"{\r*e\156\SO\243\v~\244\176\176\r\206\np(\252>xo\229\160\165\218\180\SO\172\188\221{\165\244Y\209Zkp\DC2\230J\236m\148K2W8\231\148\178\189s\171D\159\148\184Q\162\ETXex\FS\147\&5y\146c\229\&0Os\239$\220b\249\138\208\139\212\STX\131GQ\ENQOV\131\233@\NAK\243K>$\\#Z1\237F\223\163\226\255\133j\248\ETX\170C\229KT;!\250\v\170\169]9)\\\r\171\ETX\211\NAK\161\185np\213\152F\253\195\244F\131Y\DELI\240[H5\152\168Y\t\SOHJ\bY\210\183\177\155\130\158S\141\GS}T\143\217v\220\234\177\139\251\215GSP\146\CANu \154\&5\157\DC47\176z\137\232\142\n\236\250\187\221S\239\140v\136\226\RS\NULj\183H\251\SIPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\174\161%B\245\143\150\206\228\NUL\NUL\NUL\165\STX\NUL\NUL\DC2\NUL\FS\NULword/footnotes.xmlUT\t\NUL\ETX\232\249\232P\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157\146\193j\195\&0\f\134\239y\138\224{\234t\135\&1L\211^\202\158`{\NUL\227\216\141!\182\140\164\196{\252y\180\ETX\247RB|\DC1F\250?\161\159\255t\249\ts\187Z$\SIq\DLE\199C/Z\ESC\r\140>\222\ACK\241\253\245\217}\136\203\185\&9e\229\NUL8\STX[j\218\242\138*\146\202\131\152\152\147\146\146\204d\131\166\ETX$\ESCK\207\SOH\ACK\205\229\139\&7\153\SOH\199\132`,Q\129\134Y\190\245\253\187\f\218GQ\161\194\SYN\DC48\231\141\189\130Y\130\141\252\SI\226\169\ACK\225^\DLE\218Ysq\129&\159\168&\194 \SYN\140\234\129\235\130\&7\b\EOT\142;\ETXA\221I\143R\171\214W\170\&5\204\245l>\246\ESCv\252\EMY\171\244\150KG\212\249\133\237\201\155\GS\148\162\226\ENQ\159\206\205i\a\231\&9\SUB\215{S\148\184\201*o\231\230\ETBPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\184M2@0\SUB]B\168\ETX\NUL\NUL\a\RS\NUL\NUL\DC2\NUL\FS\NULword/numbering.xmlUT\t\NUL\ETXK\ENQ\ETBO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\213\153\221N\219\&0\DC4\199\175\199ST\145v\t\249\254hE\139\DLEPi\DC3b\147\198\180\235\&4q\169\&5\DELDv\218\194\237\246\&0{\132I{\169\189\194\236\164\t)\DC4\226RGk\185\169\227s\206\223'?;\246\177\&8=\187\199\168\183\NUL\140CJ\134\134}b\EM=@\DC2\154Br74\190\222\142\143#\163\199\243\152\164\&1\162\EOT\f\141\a\192\141\179\209\209\233r@\230x\STX\152\240\235\t\t\194\ax14\230\140\fx2\ETX8\230\199\CAN&\140r:\205\143\DC3\138\a8N\ACK\v\140\140\202\153\SO\141Y\158g\ETX\211\\\249\159\212\254'\194\223\164\211)L\128)\194\170\166cY\145x\134\164\210X\128g\SUB4\ETXD\CAN\167\148\225\&8\ETB\143\236ND\176\239\243L\230\144\197\&9\156@\EOT\243\a\169\NAKT2\244\181\180\203\177W?U\EOTS\EM\183\f\185\164\201\FS\ETX\146\ETB#\154\f \145\ETX%|\ACK3^\163x\171\154\&0\206j\SYN\175\189D\131\251\210\182\DC4^wIYZG\168\164'\ETX2F\DC3\192\185X\DLE\CANU\t>N\214\146<\159\173\141\&3.\165\202p\217jd\158\169$\146\178x\217\200`=\175\203\210h\140\142\222\137\245\ESCOx\206\226$\191\153\227\222\218\211\135thX\210Iz\DC1\SOSa^\196hh\140\139?\251\210\&0WF<G9\188\ACK\v\128n\US2P\185\NAK\189H\246\214\142\&9\206Pe\190\180<\171\DEL\DC1^\212F\180\144\&6(~\170qe\175\248\232X^\197\216\165\243\187\242\179\ESC\227\218\&0\153#\EOT\242G\171\DLE\185\ENQ\247\181y\205\240\&1\169\186\DC1\152\&6b\178\207\172h\SYN\137\n\SO\229\195\234\169\n\DC1\195\SUB\162\157Q.\147\&4W\SOHf3B\EOT@\"aIy\233%\154S\200x~\r\229\228WQ2\168\SUBR\132\176\198\232lLI\206\229l\240\EOT\194\161\241\229\SOHO(\146:\179s1\DC1k\GS\144\136\&1R0\141\ENQ\237\134\242JN6\197+o l\235%\252\247\199\239n \135\142\SUBf\219\138\n\210\179\152\220\NAK\155\182\ESC\236\tiG/i\218\rg\219\243\DC4AG\150\ACK\208\ETBt\206 `\189\ESC\176l\208~\218\251V\228\174\238\197\253\171\ESC\232\142\GS\168Aw|G\ETX\244o\"TV4\188\129|\189\239\173\192=\205\192\DEL\254\233\bx\DC4\169\SOHw\GSo\175\129\251\a\178}\vl\138\192\251\193\158\238\223\193A\236\223\158\171xPz\129\142\131\178\219\253;<\144\253\219\183\DC4\SIM\223\211qhv\183\157D\a\178\DEL\251\161\226\129\EM\216\251u`\202V\227n5j\191z\217\155\174^\174\229G~?tw\187z\157{\225\149\237_\\i\185z\165 \129\&8F/\174\133\247\246\201\255\189\EM\132OV\194c\\c%\232\187(\181\242p:\226\161^\193{\222ND\182\189\208\180\DC2q;\"\162^^\219\193ND\182\189o\180\DC2\241\186\"\162Z\255\SYN\142;\DLE\217\246B\208J\196\239\136\136z\129\SUBX;\DC1\217\182bo%\DC2tDD\189\146tw\219Y\183-\172[\137\132\GS\DC1Q/\243\172\221v\214m\235\222V\"QWDT\235\176\194q\a\"\219\SYN\166\173D\250\GS\DC1\t<\197\157\181p\220\130\200\198\202\145\DC4\NAK#yR)\174U\144U\146\165\184T!\ESC\163\157W\163\237f\141\248i\SOH\CAN\131)x\169Vl\216\215\130\205\181\232W\244l\205z\142f=W\179\158\167Y\207\215\172\ETBh\214\v5\235Eo\212\171\191\134U\163\252\a\238\232\232\USPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULTK#@>\166j\135\245\STX\NUL\NUL\224\a\NUL\NUL\DC1\NUL\FS\NULword/settings.xmlUT\t\NUL\ETXP:\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157UMs\218\&0\DLE\189\231Wx|.\177\249\ACK\SI$S $\a\210a\226\164wY^\131\ACK\201\242H\STX\151\254\250\174\193\178=M\157dzBzo\223j\181\214>f\247\191\EOTwN\160\&4\147\233\220\237\222\250\174\ETX)\149\&1Kws\247\237u\221\153\184\142\&6$\141\t\151)\204\221\&3h\247\254\238f\150\a\SUB\140\193(\237`\134T\ar\238\RSU\SUBh\186\aAtG0\170\164\150\137\233P)\STX\153$\140B\249\227\150\n5w\247\198d\129\231\149\162[\153A\138\\\"\149 \ACK\183j\231]%+I\143\STXR\227\245|\DEL\228)\224\196`\189z\207\&2m\179\137\255\205\134\228\222&9}t\137\147\224\&6.\239\250_\184n.U\\)\190R^!\200\148\164\160\&5vVp[ Km\SUB\205\191\146\231JmX\164\136:7\146\220\221\&8\SO~\185\223R\n'\SI2P\DC4\187\&0w\167\190\235\149\DC4\136\b\226\240\172\r\136\181L\141\182\&8V%\147\208\DLE\ETX(\212\EMp~y \148\ETX\193\218\242`\167\136\DLEDY\196\202\180\&9s\216\146\DC4\214\151\234\214\140\ESCP\CAN~\"x\SI\223\247\aUd,\DELH\243\170\b=<\203\DC3T\231\198\144\144#7\175$\n\141\204\172r\220\171+\142\NAK\201\177\150G\197\226'\169\216o\172\154\240\&0#\DC4A\ESC\223\US\253\&3\254'(\195\232\199\209Lg\156\156\235\204\171Z\254\128cs\174.\243\183\196&\255\\@\247\EOT\239\141\141)\235X\226AJr\ESCx\233\204R\138L\225\179\168;KN\176Upb\144o\EM5G\ENQ\150\193Q\142u\177\174v/R\154\186\233\195\169\191\242\199\215DUH\227\155t\187\203\201\162\149\RS<\244\166\139~+\253I\242\241d\176\SUBNZ\233\201j4\EM\181'_LF\139\241\176\157^\SO&\171vz\217\US\245\198\211V\250\161\223\GS~/\207\158y\141\&6\206DPX\196V\149\194\235\182\152\SOG\\\197\155#e1q\RS\NAK\218$T\a\136 R\135\ENQKmT\EOT8\162\239\233\240\CAN\217\136N\167\193jA8_\227\195\176lB\184n\202\139w\182\130\164\141\230\207D\237\234\211\253\ACK\165\218\169\\\145\236\133\237\246\166\134Xj6L\216`}\140\194c\214P\164h1-\252\204k\182\SO;n\208\150\160\232\220\134\212\227\ACKi\231-\172\135\129\171\176p/x&Yv\GS\202h\215\157\187\188(\170[X\141\193]L\212\225\178\137v\189\146\235]\184\222\149\187l\b-\236\r\163\203E\141\245,\214\136\235[\172_c\ETX\139\rjlh\177a\141\141,6*\176\253\EM\157\NAK\253\241\128Vm\151\ENQ\158H\206e\SO\241S\205\191\131j\ETB\SOH\202\240\ENQ\132g\DC1\213Vp[\209\156i\DC3B\134\198ade\168\223\n\186x\187\246\175\249\238\230\SIPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\229\176~B\GS\EOT\218\158\192\EOT\NUL\NUL\217#\NUL\NUL\SI\NUL\FS\NULword/styles.xmlUT\t\NUL\ETX}\196WQ}\196WQux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\237YQs\226\&6\DLE~\231Wx\252\158\ETX\ETXI)\DC3rCH3\201Lz\205\NAK\210>\v[`]l\201\149\228\DLE\238\215w%\219`\EM\219\DLEB\147&\195\ESC\218]\175\246\251\244y%\228\243\175\207a`=a.\b\163\ETX\219\249\210\178-L]\230\DC1:\US\216\177\156\157\244lKHD=\DC40\138\a\246\DC2\v\251\235E\227|\209\ETBr\EM`a\193\243T\244\249\192\246\165\140\250\205\166p}\FS\"\241\133E\152\130o\198x\136$\f\249\188\201f3\226\226+\230\198!\166\178\217n\181\206\154\FS\aH\194\220\194'\145\176\ESCI\182\197.\217\SYN\140{\DC1g.\SYN\STX\138\r\131$_\136\b\181/\SUB\150\ENQ\NAKz\204\189\194\&3\DC4\aR(\139\182\241{\158\218\DC2Sf\204F\201\248\154Q)\172E\US\t\151\144\t\148\NUL\200CB\EM\191\EMRA\236U\236\162\143\145\144CA\208f\DLE8}\245\163\246qW\200\156\251\146x\240\\\211\168E\252\132\176'\DC4\f\236vw\211\&7\DC2\213\222\NUL\209y\230\197\244\228al\231\234\205\153\166\&0\235\192F\252d<\204\165\&8o\230xI\a\ACKs0CTFfT SD\200%\186\DC24\147\CAN\132\STX\235T\152'\202\207c&U\150\194:jh\DC2\DC44N\DC4\b\SOHxv\199\220G\236\141%8\ACKv\203N\140\SI\183\247\156\&0N\228R\217\SUBVb\GS\227\144\220\DLE\207\195\&4\ETBI}\226\225\191}L\US\EOT\246\214\246\239\215Zq\171\199]\SYNS\CAN\181\DEL9K!d/\STX\248\228\&2\130\185#\196\209\156\163\200O3\168\178\225\197R#\GSx\v\217\191\169\164\129\189\226\145\162\DLEg+\149\250\&2\130\192\251ORC\206\146\163\216 x\138\225\ENQ\129\SUB\156\158\174?\229[\143\154\ACK\193\EM\179\186\162\237\&0V\133\143X\b\147\201\242\202\&3g\174\208)\STX6\255\160\135\196\214\&9\203A\235\156\GS\n\217\132\200\NUL\151\227J\\/AE\241\179\220\US\243#\198\209\&7\149\161Y0\222\DC1\nro\214\210\211\&5\150\190\221\&5^\181E\255\135\155\213\229\194\v\132y\EM}\197\150X\217\DLE\209\143BG\219l\135*\228\183\212\182\209\DC1K\158_\247C\229,\244CE\189\&9\SUB\153t\184,`<\ETX\216\233\158\SO{C5\169N9R>hs\174\STX\238\172g\212\206\177\143<\152\244\242\212\156m\221{sB\219\232\188\ENQ\DC1\242\253E8\140\165\207\184(\151a\230|\SI\157\237\"\155}\NUL_A\187.G\171=\159\t\234\rF\234P\229\148\195M\189\150s\192>\DC3\147l\247\203b~}\167\&6ThB,\150\SOH\228\184{\n\178\194J7\168c\USz\175>\148\170\177]\175\213\246\219i56\142go%b}P\221]\196\206'\SYNq\247\186\231\\^U\137\184J\172\237\SUB\177\182\SI,\214N\189X;G\177\RS\197Z'\214v\175Z\172\&9\223a\196\218\173\ETBk\247(\214\163Xk\197\218\173\DC1k\247\192b=\173\ETB\235\233Q\172\US[\172\196\FS}P\177^\ACK\204}\252\RS\179\170?\148\218o%\SOH\255\DEL\193\150\220\233\EM*tZ\US\239/SAX9\129\180j\EOT\210z\185@\\\US\DC4\226\234\255\238\198\NAKl\195\&2\238\RS\DC2\199}\166&\197S\197]D\DC2i\173B-\GS\155[<\177\186R\222\178\248\245\133K4U7\141\149\247\198\DC3\229\223~ylM\146<{\212W!N9\r\fQ\193\248\150z0\235\"\189*O\234\247\158\145\185\146\DLE7\194A\240;2?\tH\SYNmyV\135\ENQx&\147\&8\167\213\171\141\156\&2)Y\184KNN\230\254\246\164j\153\138\181\167\182W\\v\225\EM\161D}\236\154`\RSVJ-\141\177t\208\190\157j\157\199\174\236\&1{m\138\ESC\187`}\247\153\RS\168\187\231\240l\225mW\202\246\218c\152\183\156\NULc\NAK;\fx-\237~\201\170\193\233\225\&1\159A%\CANA\ETX\171^\183\141\197p\218\a\251\192\163;\199\bE\213L\235\b+\vy+\164\217.h\236\129\229\176KTH\SO\164\194\219\DLE\205\235\217\209\DC1\159\158\GSc\131uc\SOH\189W\DEL\139\221\220d\r$\245o\141UD[\160\172t\191\222B\224N\239\250\238h\254\194|\138$\t\171\209d\DC1\219\192T\173p\221\217M}a\165\130\ENQH\172\142cyS\197\217j\143{\182\221\t\185fLR8Q\255\137g\229|d\SOH\150\138x-\GSO\152\203a@\230\171\199D\FSa.\\N\"\249_\162\132\253\240\177\FS\158\246\188\SYN\214\RS\255\176\202A\174~\138\139\198\191PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\FS\NULword/theme/UT\t\NUL\ETX4\249\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULTK#@\157\\\139\190\"\ACK\NUL\NUL\135\GS\NUL\NUL\NAK\NUL\FS\NULword/theme/theme1.xmlUT\t\NUL\ETXP:\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\237YMo\219\&6\CAN\190\SI\216\DEL to\229/\165NP\167\136\GS\187\221\154\180A\226v\232\145\150h\137\r%\n$\157\196\183\161=\SO\CAN0\172\ESCvX\129\221v\CAN\182\NAKh\129]\186_\147\173\195\214\SOH\253\v{\245a\153\178\233\196I\211\173C\155\131#R\207\251\253\242!i_\189v\DC42t@\132\164<jY\213\203\NAK\v\145\200\229\RS\141\252\150u\167\223\187\212\180\144T8\242\&0\227\DC1iYc\"\173k\235\US~p\NAK\175\169\128\132\EOT\129|$\215p\203\n\148\138\215l[\186\&0\141\229e\RS\147\b\222\r\185\b\177\130\161\240mO\224C\208\ESC2\187V\169\172\216!\166\145\133\"\FS\130\218\219\195!u\t\234'*\173\245\137\242.\131\143H\201d\194eb\207M-\234\DC2)\214\219\175&\255\228Xv\152@\a\152\181,\176\227\241\195>9R\SYNbX*x\209\178*\233\159e\175_\181\v!\166\SYN\200jr\189\244/\151\203\ENQ\188\253Z*'\252A!X\237\&5V\175l\SYN\250k\153\254y\\\183\219\237t\171\133\190\DC4\128]\ETB\"\173\206a\ESC\189f\181=\209\169\129\178\199y\221\157\138Si\148\241\154\254\250\FS~\181\221n;\171%|}\138o\204\225\155\149\149\198F\173\132oL\241\206\188\255\237\141Ng\165\132w\166\248\149\&9|\239\202\234J\163\140OA\SOH\163\209\254\FS:\169gQ\153\STX2\228\236\134\DC1\222\EOTxs\210\NULS\148\173uW&\US\169E\189\SYN\226\251\\\244\NUL\144\SYN\ETB+\SUB!5\142\201\DLE\187\128\235`F\a\130&\ACK\240\SUB\193\218\155l\202\149sS\137-$]Ac\213\178>\142\&1\172\136)\228\213\243\US_=\DEL\138\142\US<;~\240\203\241\195\135\199\SI~6H\221\192\145\175K\189\252\254\139\191\US\DEL\138\254z\250\221\203G_\153\241R\199\255\254\211g\191\253\250\165\EM\168t\224\139\175\159\252\241\236\201\139o>\255\243\135G\ACK\248\134\192\ETX\GS\222\167!\145\232\SYN9D\187<\132\192\f\ACK\200@\156M\162\US`\170KlD\190\196\DC1Nd\f\232\174\nJ\232[c\204\176\SOH\215&\229\f\222\NAK@\SOH&\224\245\209\253\146\195{\129\CAN)j\NUL\222\f\194\DC2p\155s\214\230\194\CAN\211\205\196\150\158\133Q\228\155\141\139\145\142\219\197\248\192d\187\&3S\223\238(\134^\166&\149\157\128\148\220\220aPr\236\147\136(\148\188\227\251\132\CAN\196\238QZ\202\235\&6u\ENQ\151|\168\208=\138\218\152\SUBS\210\167\ETXe\SYN\186AC\168\203\216\228 \212\187\148\155\237\187\168\205\153I\253&9(#aU`fRIX)\141\215\241H\225\208\232\&1\SO\153\142\220\194*09\185\&7\SYNn)\225RA\165}\194\&8\234zDJ\147\204m1.\185{\DC3\168\195\\\246m6\SO\203H\161\232\190\t\185\133\&9\215\145\155|\191\DC3\224\&06\250L\163@\199~$\247\161E1\218\225\202\232\EOT/\175\144d\fu\192\209\194r\223\165D\157mm\223\161~`n\144\228\205H\228\188]b\224\144F'\209q\bl\140/\154\142\129\NUL_|\251\248\DELD\196\ESC\144\EOT\211J\152\165\223E\184Y\210\237p\225\209\183\159s7\241(\218!\208\230\239)\247=\229\190\139\148\187h=/K\180Sn\181\245Cq\170/\\xB\RSR\198\246\212\152\145-\153\178\178\EOT\167\189\RSL\166\131T\168\&8\144\199\SOH<\230\230J8_\224\244\EM\t\174>\161*\216\vp\ff\170\169\ENQ_\230\170}\137b.\225\SUB`-\212\157\222%)\EOT\159\206\&9\147\v \160\177\218\230^6]\215/\134\133\154t\228K\221P=Q\176\172\177\250\149\215\&3V\205\128KZ\171:fk\206\137\214l-\155\176\SUB\DLEN\174\253\213\149Zf\SUB:\ACK3\226%y\207\DC4L\202\242\ACKKT\173h5\n\176G\f\211Z|\213\250\ESC\201\166s&'.&\201\149\185$\219\243\171\137E\229\DC1:\132;\188Ss,\228\226\184e\r\225\f\EOT\143a\f\250d\194\US\152\249Q\203rU\SYN\224\233kq&\226UsWU+\206\162\128K&b!\213&\150A&\149\190\154|\237\DC1M\253\175\&9\141$\SI\ETB\DC3\128\129L\150\243\162\222\172\254\135^\216\179\165%\195!q\213\130\153\233\&0\DEL\199G\138\136\189\192;D\ETX6\DC2\187\CAN\252nd\221\229Q\t\148_\155\f\EOT\244v#o\188\242\194\205\215\198\236\215+\249\154\193,\SOp\222\237M\173\246\EM<}.|HG\154{\246\STX\223\207\EMJ\253\STXCq\222\221P\146\206\133Sg\221K\175B\176\139\v\140\146\RSmY\\\168\128\ETX\v\197\SOHu{\STX\246\253\212\SYN\248\133`Y$.!\150|Y\156\248J\SO\166\188\149\233\200H\206\SI\212.\245\145\160\192t*\DLE\132\236\168<\206S\148Uk\250\246\&8Q\148\243L\225\174\140\179\255\ETXr@X?Y\189+I\252\SYN\n&l\146'\"\197\205\SYN\205\&6\173\174\129\223{\139\SI.\141sm<SC\141\179l~\r\141\244\181\173`\245\245\\Xf\ETX\214\204\213\204\DC1\215\156\133;\207\236V\ESC\195\221\SOH%\US@\220T\184lz<\237\243]\168>*\246y\EOT\141x\169\153/\191br\NUL>7\181\224\DC2U\255\214)\168\185\160\222\ETByv\212\146]_\144\236\147\205\157?\217\142!\215\206\201\169\182\231\151\168\173\221C\210\209\220\143F|p\USlo\194=g\196\178\EM\EM\195({\216\DC1i\192\ETX\238\141\243G&3J\200\DC21\161t\SYN\237\146!\162\222\209\164\172\&3\EM\205\DEL\149)6\243\221\204@\DC2{!X?]0\199O7\145B\184v\186p!1\185\236\NAK\194\233-\206\164\128M-g\248\172\202\ENQE\SYN\153b\209\235\164l\t\231\205)3v\239\178)[\162P\231H\153::9ey\166lS\227\145#%pg\242\&3\DC3\244\175=m\217\245\DEL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\229[#@\204d$|\129\NUL\NUL\NUL\159\NUL\NUL\NUL\DC4\NUL\FS\NULword/webSettings.xmlUT\t\NUL\ETX~W\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL]\142\&1\SO\194\&0\DLE\EOT\251\188\194\202\ETX8\139\130\194\&2\145h\160\139\144\252\STX\147\FS\137\165\179\207\242Y\152\231c\SUB\n\202\157\213\172\214&\209\166\225\195a\173!m\162\222\145\146\152N\207\227^k6\NUL\178\236\CAN\189\FS8c\234\237\147K\244\181\199\178A\227\178\230\194\v\138t9\DC2\FS\181>A\244!\141\211\160\148\253\142{\"n\247\249\ACK?\178\242\204\213\249\ETB^\196u\141\240\SUB\b{m\225\239\204\&4|\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\NAK\184WB\179M\143\225m\SOH\NUL\NUL*\a\NUL\NUL\DC3\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129\NUL\NUL\NUL\NUL[Content_Types].xmlUT\ENQ\NUL\ETX\153\186)Qux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ACK\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\186\SOH\NUL\NUL_rels/UT\ENQ\NUL\ETX4\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULzn#@5\145\&2W\238\NUL\NUL\NULj\STX\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\250\SOH\NUL\NUL_rels/.relsUT\ENQ\NUL\ETXxx\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\t\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A-\ETX\NUL\NULdocProps/UT\ENQ\NUL\ETX4\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\229[#@,,\fwJ\SOH\NUL\NUL\174\STX\NUL\NUL\DLE\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129p\ETX\NUL\NULdocProps/app.xmlUT\ENQ\NUL\ETX~W\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULan#@\177\t\162\248S\SOH\NUL\NUL\175\ETX\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129\EOT\ENQ\NUL\NULdocProps/core.xmlUT\ENQ\NUL\ETXFx\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL\193\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ENQ\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\162\ACK\NUL\NULword/UT\ENQ\NUL\ETX\n\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL\200\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\225\ACK\NUL\NULword/_rels/UT\ENQ\NUL\ETX\ETB\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\135\161%B\198UX\DEL\226\NUL\NUL\NUL.\EOT\NUL\NUL\FS\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129&\a\NUL\NULword/_rels/document.xml.relsUT\ENQ\NUL\ETX\157\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\194n#@R\138\243\174\157\NUL\NUL\NUL\227\NUL\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129^\b\NUL\NULword/document.xmlUT\ENQ\NUL\ETX\252x\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULTK#@jp<\224\155\SOH\NUL\NUL\229\b\NUL\NUL\DC2\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129F\t\NUL\NULword/fontTable.xmlUT\ENQ\NUL\ETXP:\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\174\161%B\245\143\150\206\228\NUL\NUL\NUL\165\STX\NUL\NUL\DC2\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129-\v\NUL\NULword/footnotes.xmlUT\ENQ\NUL\ETX\232\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\184M2@0\SUB]B\168\ETX\NUL\NUL\a\RS\NUL\NUL\DC2\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129]\f\NUL\NULword/numbering.xmlUT\ENQ\NUL\ETXK\ENQ\ETBOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULTK#@>\166j\135\245\STX\NUL\NUL\224\a\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129Q\DLE\NUL\NULword/settings.xmlUT\ENQ\NUL\ETXP:\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\229\176~B\GS\EOT\218\158\192\EOT\NUL\NUL\217#\NUL\NUL\SI\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\145\DC3\NUL\NULword/styles.xmlUT\ENQ\NUL\ETX}\196WQux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\154\CAN\NUL\NULword/theme/UT\ENQ\NUL\ETX4\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULTK#@\157\\\139\190\"\ACK\NUL\NUL\135\GS\NUL\NUL\NAK\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\223\CAN\NUL\NULword/theme/theme1.xmlUT\ENQ\NUL\ETXP:\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\229[#@\204d$|\129\NUL\NUL\NUL\159\NUL\NUL\NUL\DC4\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129P\US\NUL\NULword/webSettings.xmlUT\ENQ\NUL\ETX~W\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ENQ\ACK\NUL\NUL\NUL\NUL\DC2\NUL\DC2\NUL\SOH\ACK\NUL\NUL\US \NUL\NUL\NUL\NUL"),("reference.odt","PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC^\198\&2\f'\NUL\NUL\NUL'\NUL\NUL\NUL\b\NUL\NUL\NULmimetypeapplication/vnd.oasis.opendocument.textPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL;\138\vC\163\159\SOHAJ\SOH\NUL\NUL\STX\ETX\NUL\NUL\b\NUL\FS\NULmeta.xmlUT\t\NUL\ETX\177)\bR\177)\bRux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\141R\203v\131 \DLE\221\231+<t\173\168\201\162\225\168\217u\221E\251\SOH\EOT'J\171\224\SOH\140\249\252\STXF\139I\ETBu\199}\204\220\153\177\&8\221\250.\186\130\210\\\138\DC2eI\138\"\DLEL\214\\4%\250\252x\139_\209\169\218\NAK\242r\225\fH-\217\216\131\&0q\SI\134\238\"\251Y\187\208d\166K4*A$\213\\\DC3A{\208\196\&0\"\a\DLE\139\141\132j\226\154\ENQ5n\GS\ETB\223%j\141\EM\b\198\211\&4%\211>\145\170\193\217\241x\196\158\r\229\&5[\181\195\168:\175\172\EM\134\SO\\'\141\179$\195\161\222%\254o@\167}\140'\165\\\ESC:\203<\132o\155\167\233\SOH\207\239\208\209\168\186\238\254\SUB\200\234\247\216\166\165\134\198W\SO\211\203\236\186\175%8F\142*\203,\203w\169*\175,|\192\245\CAN\218P\195\181\225\204\147Q\228YC\207\GS\196L\142\194\148\200^\213\131\188\167\205\DC3(\207_\192\204/\SUBV\EM\STX}\134\SYNL\209F\209\161]\136\252NLR\213\v\182\223\148a\173\245\&0\ETXj\173u\216\240B\138xj\185\SOH=Pf\ESC>\201s\132\195\209\ESC\DLE\160\168\145\170z\167\238x\ENQ~\128\221\218\240fo\235s\243\SIW\187\USPK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\"\STX\240\214\207\ENQ\NUL\NUL\138&\NUL\NUL\f\NUL\NUL\NULsettings.xml\181Z]s\218:\DLE}\191\191\"\227\247\148\144\228\&67LB\aHiiI`\128\&6s\251&\236\ENQt#k=\146\FS\224\223\223\149\fi\n8\165\182\245\148\137?v\165\213\238\158s\214\220|X\197\226\228\EM\148\230(o\131\250\187\179\224\EOTd\136\DC1\151\243\219\224\219\164{\250O\240\161\249\215\r\206f<\132F\132a\SUB\131\&4\167\SUB\140\161G\244\t\189.u#\187}\ESC\164J6\144i\174\ESC\146\197\160\ESC&l`\STXr\251Z\227\245\211\r\231,\187\178\DC2\\>\221\ACK\vc\146F\173\182\\.\223-/\222\161\154\215\234\215\215\215\&5ww\251h\136r\198\231\199\186\202\158~\237\n\DC1_\FS\217\ETB\178\197\&8g\231gg\151\181\236\255\224d\179\200W\161\&9\SI\154\219\&8l\183\223\188\217\&8\200\254\156r\ETX\177\141\205\201\230\178]\218m@.\ESC\207\FS\150/Q\v\SO\189\247\235;\223\233\249\150\STX6\193$\216\222\&1\235\132\238pi\130\230\217Mm\223\194\241V\251\&03\RS\204>\242\200,\SO\217=\175_]^\149\179\253\EM\248|qp\209\245\179\DEL\174.\139\EM\US/p9\130\136\242\v:\v&\231\160w\FSL\DC1\ENQ0\EM4\141J\161\152\143\158l+\\j\184\199\b\242\172\207\152\208G\155?\141Yr\202e\EOT+\136\246cu8\185\220;T\SYNj}\\\196{\209\206R\181Q\148\185A\211\230\241y\241\147\204K\188\139\179\203zq\171\&9ER\198\168\230S\SOH\149\151\137\179ZuI;\163\163\188\234\176\165\247w)\211m4\ACK\227\188\202\187(f\251\ab<!K\187i\182@U\174\SI\245\217\SUBS\211A\145\198r\183\154\171\178\222F|\170\172\156\247\227\210e\161Aux\237\245\179\130\171\239\233\&1\b\b\rD]E\ETB\n,\253\192\197\215m%\239\246\166S\GS~\128\DLE\241x\f\205.\164\138\EMB\228?\SOHS\234\237\202\180R\131\223\146\136\153\220\189\151\232\241\186\207\166 \238\&6\228\195C^\220\&3\179h3\r\SYN\170Z\130\207\165'?#\205w[\DELV\234\151W\ETBW\245\235bF\a\169\177\235\238\195\&3\136\DEL9\136H?\164\241\DC4\FS\162T\191\133!\217\&5\182u\SI\153\ETB@\191\195\a4_Rm\248l\221\167m\233Gn\SYN\247L\166L\180\137\168<y\216RG\240$\129h\200C\147\170\252=\149\240\224rj\194\166c\131\201\DLE5\183%V}\232\220\209L`e\134\130\133\176@\DC1\193n\159\171b3\223\&4\fD\228\&3\199:\169RT\128w\204\176)Ue\a\227\152\201\FS\206T;&.h\168\&7wQ\237\226le\ENQ\209\166\136?uQ\SUB\US\217\227<\208&tB\187\CANM\250\RS\\\180i\249s\133\169\140\134L\177\SOH\233\178;\197\150\SO\NUL\170w\214\NAK\200\f\GS\173\128\a\140\153\154\243=*Q\133\151q\204\132\232\176D\SIA\133\148M\212\174\222\191\247u:\GS:z\133\194C?\252He\SYN\141\215\154n\248\202/\v\224D\138@Q\161%\212\NUL\173$\175\156=\186\&0}\230Q\EOT\210\182(?}\201\150\&8(k\255Q\177$\241\211\157z\250+(\217\210\156\201a*\t3\216[\237\188\170\186\247e\255c\156\152\245\155X^\230H\228\212b\182+\245-^x\241\179=\250\193\244?\138\213\SYNb=\161\DC3J\162q?\211l \201+\185\244\224jb#7\194\229W\128]U[Y\STX\140\192N\225`\ETB^+Z\190\RS\129\160\250x&]\222#\169\146\207\170K\210\RS\167\208=Q\210\172\SOY\STX\170\171\&0\RS\131I}\FSF+\202\180\227`6#\241\229\133\133F\SO\221\199\t\v\169\&2&\232\178\171\ETX\194\aleZ\208\198k\STXq\"\188\232B\218\207\199\NAK\193\150d\162\SI,z\163\218K\158\253\152L\v\248\130So\236\SO\148\173\SO;a\167\DC2\201\198 9#\194\ENQ%\250)\129\&4\138\212\182\184\226:t\132xx\224[F\139\146b{\202\142\254\192\EOTg;d)\DC1\167\150\148h\FS\222\230\219/HP\168\SUB,\239\189w\132\212\155l\218\156\246=\208q\134>\210i3p\223h\RS\n\212WX\239\186!M\245\254\178\205%S\235\227\244\147[\243\193\198\247\135\166zs\137\n\186\\ic\197}\ACK\t=\233UL\162\DLE\164\STX\192\DC1\GS\219\237l\SI\244\212(@=\236O\255\142\ETB\170\142\235\251b\249=I\217m\218\168\136\186l \192\ESCg%\FS\254\169(=\205\136H\218\217q\141\213\169\196\191\244@Z\175~H\140\237\v3\129K\SI\DLE\150$bM\157A\217YG\245\230i\237-7\172\203\n\141\&8\178M\254\&9\145\214\133\238\201>\215^t\152\\\145\163\DLE~\128B\194\231\223@s\EM\133\207\158\225{\246\ENQy ;\STX\181\143\227w\t\221e\171R\133=6k\SOH\250\SOH\239`\198R\225#\232\ESCn\231(\221o\170\187d\143\251\221`\168\184\249>\178hD\217\130R\236AVU'\249\201\230\254\ESC\200[|\245];z\247\249\EM\164%\168\ENQ\185M\DLE\DC3\237\&0\EM\130\240\192\219\183J\218\194\179?\152\176\165\251I\224\148\189|\213\177\204\209\203p\235\215Y\178\253;\198T\133\197\139\&9\227\&0V\219\182d\212\SYN\140\214M!\179\241\234\&0\DC1\166\194\215\&8\232\240T\252\192\160\174\204\ao\a\173# \ENQj\219I\203\CANe7G\252\204\210\DC2O\223^Z\250e\STX\217\146!\145x\136\RS\NAK=\170\186b\237$\177\&7\217\229\218\165\135^p\160\ESC\183\204\216\&0U`\252\145\251a\183\182\247s\169Z\222\SI\201\154\255\ETXPK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\250+^\183\175\ETX\NUL\NUL+\SO\NUL\NUL\v\NUL\NUL\NULcontent.xml\165W\223o\219\&6\DLE~\223_\161i@\223\CAN\198\241\ACK4j\236bhQl@2\fM\138\245\149!)\155\ESCE\170$e\217\255\253\142\164EK\142e\v\240\139l\241\190\239\238x\191H=|\220V2\219pc\133V\139|vs\155g\\Q\205\132Z-\242o/_\208\251\252\227\242\167\a]\150\130\242\130i\218T\\9D\181r\240\155\SOH[\217\"J\ETBycT\161\137\NAK\182P\164\226\182p\180\208\&5W\GS\171\232\163\139`+\174X\183\147\147\233\SOH\220g;\190uS\201\RS;\224\146\215\233\150\ETX\184\207f\134\180S\201\RS\vA\237\211K=\149\188\181\DC2\149\SUB\162^\213\196\137#/\182R\168\255\SYN\249\218\185\186\192\184m\219\155v~\163\205\n\207\238\239\239q\144&\135i\194\213\141\145\SOH\197(\230\146{c\SYN\207nf\184\195V\220\145\169\254yl\223%\213T\175\220L\SO\rq\228MV\237f5\185\"6\171\145\208\208\&51\147k#\128\135\233\157\179\233\233\157\179>\183\"n=\146\147\247\248\t\132\225\241\244x\168\ENQSM\181\229\177\131PQ#\234\201\219\140\232>_k\157\\\245\132\216\160\193\221\187\219\219_q|\239\161\219\179\240\214\b\199M\SIN\207\194)\145\&4E\\W\167\130\ACK\184\EM\ACK\EOT\226\ESC_\166\169\240} \236\b\225\SOGq\STX[6\170\250\251\211\227\&3]\243\138\FS\192\226\&2\CAN\te\GSQ\135\200\CAN\159\132\209\157\254\134\r\175\181q)0\229\244\129\t\217\186K\190\173]%\199\219\221K;\232\202\&0v\DC2\n\238\204\&1\180>4\RS\218\b\222\254\146\SI&\249\249\130\184?*\136\&0\SYN/Q\STX\168?7\207\DC2f\183\216cR\ESCC\137\FS\134\188Y\165s\168\212\141\130M\192\217\181\SI \223\214\220\b/\"2\208\138\129\134\193\244\NAK\\v\237\157\236\159R\ETX\158\162\202B\182\161\170u]\244\216\195an\170\237\&4u\190\146\&5+\143\&5\RSu5\181v\238N%\239\229+\246\&2\228\207\&2\152\214{K\189\&3\252._v\avlv\139\211B\t\a7*\t\229\136q*\237\242!\SO\222\180\156\197w\239\247\"\DELv\196<\239\170W\r\NAK\ENQC\182CUB\238\ACKB|^\205\vY\235\138\204N\232\136\146K\252O\186\&1\130\155\236/\222\158\208\241\142\212\218~\232a\226B\158\rTz,Zq\ENQy\128qTi\198\141\SUB@j\225(L\236Rl9\187\184!\200\165\245\166\178\175\224\190\SUBu\234\b7\193\&1\179\215\247\198\175\r1\"\180\208\ENQ\215~\a\216\169lu\235\227\166m+\172\189\198\244cC\ENQ#\217\&3Q6\251\166\EOT\\\"\249hdN`'D\199\238\172\227\213\&5>\238\vn\180\DC2\175\183\142\199\SUBm\191N\SUB\a\134\156\160(\232I\GS\CAN\158\ETX_\255\158%[{'kb\200\202\144z\221\t`\193\223\198\195\v\138\172/Z\251\211\183S\155(\168\134Q\195\141\DC3P\145\165\SO\ETBaD\164X\193\196\160\\\133\ETX;2\254m\172\DC3\229\SOY\184\173\130\214V\ESC\152\146%\145\&6n\175\231\237a\179o7\181\ETB\188j\182K/\222\230\242!\\\193-\255\209\192wF\n\206\219\197,,1akIvH7\SO\238\177\FSI\184\SOH\192\137\ACKC2\136\227\150\255\148\DC2|6\225\FS\240>^\165\236\165K\228uZ\224\239\213J>\199O\134\DLE\246\241\168\213\145\210\175\SOH\CAN\205p,\SUB\150/\255\224R\234\236\USm$\251y\175\164>\164-&\EOT\SIr\133G>\245\150\255\ETXPK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vCq\197\131\202\DC1\ETX\NUL\NUL\DC1\ETX\NUL\NUL\CAN\NUL\NUL\NULThumbnails/thumbnail.png\137PNG\r\n\SUB\n\NUL\NUL\NUL\rIHDR\NUL\NUL\NUL\198\NUL\NUL\SOH\NUL\b\STX\NUL\NUL\NULg?\158\ETB\NUL\NUL\STX\216IDATx\156\237\214A\n\194\&0\DC4\NULQ\ETX\222\255\202_\161 E\DLE\186\CANQ\235{\139\240\179j\SYNC\210\235\204\\\160s\253\244\SOH8\ESCI\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC4\177,\169\181\214\204\220\215m\251\152\183\225i\173>\202\ETB*o\169GO\251y\ESC\246+\231\246\222\135o\DELo\241'\178\164^=g\158\185\DEL\227\247\156\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\234\144\181\214\204|\250\DC4\191AR\135\232\233\&8I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC4\177\ESC\b\SUB(\EOTp\211\ESCp\NUL\NUL\NUL\NULIEND\174B`\130PK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\180\247h\210\ENQ\SOH\NUL\NUL\131\ETX\NUL\NUL\f\NUL\NUL\NULmanifest.rdf\205\147\205n\131\&0\DLE\132\239<\133e\206\216@/\ENQ\ENQr(\202\185j\159\192\&5\134X\ENQ/\242\154\DC2\222\190\142\147VQ\164\170\234\159\212\227\174F3\223\142\180\155\237a\FS\200\139\178\168\193T4c)%\202Hh\181\233+:\187.\185\165\219:\218\216\182+\US\154\GS\241j\131\165\159*\186wn*9_\150\133-7\fl\207\179\162(x\154\243<O\188\"\193\213\&8qH\f\198\180\142\b\t\RS\141Bi\245\228|\SUB9\206\226\tfWQt\235\160\144y\247 =\139\221:\169\160\178\na\182R\189\135\182 \145\129@\141\tL\202\132t\131\FS\186NK\197\&3\150\243Q9\193\161\237\226\199`\189\211\131\162<`\240+\142\207\216\222\136\f\166\229^\224\189\176\238\\\131\223|\149hz\238czu\211\197\241\223#\148`\156\&2\238O\234\187;y\255\231\254.\207\255\EM\226\175\180vDl@\206\163g\250\144\231\180\242\USUG\175PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\US\NUL\NUL\NULConfigurations2/images/Bitmaps/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NULConfigurations2/popupmenu/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NULConfigurations2/toolpanel/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NULConfigurations2/statusbar/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\FS\NUL\NUL\NULConfigurations2/progressbar/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NULConfigurations2/toolbar/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NULConfigurations2/menubar/PK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\NUL\NUL\NUL\NUL\STX\NUL\NUL\NUL\NUL\NUL\NUL\NUL'\NUL\NUL\NULConfigurations2/accelerator/current.xml\ETX\NULPK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NULConfigurations2/floater/PK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\252\a0s&\DC1\NUL\NUL>\185\NUL\NUL\n\NUL\NUL\NULstyles.xml\237][\143\227\182\NAK~\239\175\&0\FS\164@\USd\235b\249\&2\221\217 \221\&4H\128M\154f7\207\SOH-\209\182\178\178(\232\&2\158\217\167<\DC4}/\n\180}(\n\180?\173?\160\191\161$EI\148L\209\186\217\214\140\131\NULIL\RS\146\231|\231\240\240\DC3I\141^}\246\184wG\SI0\b\GS\228\221\143\181\137:\RSA\207B\182\227m\239\199?\188\255RY\142?{\253\171Wh\179q,xg#+\222C/R\194\232\201\133\225\b7\246\194\187\164\242~\FS\a\222\GS\STX\161\DC3\222y`\SI\195\187\200\186C>\244\210Fw\188\244\GS\GS*)\161\157\213mN\133\249\214\DC1|\140\234\&6&\178\133\182`]\DELd*\204\183\182\ETXp\168\219\152\200bL\249\230\ESCT\183\241c\232*\ESC\164Xh\239\131\200)i\241\232:\222\135\251\241.\138\252\187\233\244p8L\SO\198\EOT\ENQ\219\169\182Z\173\166\180\&6S\216\202\228\252\&8p\169\148mM\161\v\201`\225T\155h\211Tv\SI#PW?\"\203\171\228\197\251\&5\fjC\ETX\"p\228\213\240a[;\"\RS\182\NAK\208X;\DLE\212\142\r*\\t\175a\215w\175a\243m\247 \218U\248d9\253\ACKW\210\DEL}\243\&6\143\133`_w,\"[\128\202\n\FS\191\182\153\137\&4\223\RS!\148\169J\SUB$\DC3\148\170\171\171\234l\154\252\230\164\SIR\241C\224D0\224\196-\169\184\ENQ\\+C\FS\237E\160a9m\138%\DC4\248@\194\&4\149\SO\136\209\149=\155\211\NUL\250(\136\&2E6\245\DC3\DC4FG\207\166\215.\218\187\213\211\139\212\166\162\219\192\182\133\162X\GSc\138\167\SUB\SOt\229\193\129\135O\198\133\204)w\192\170\228\NUL\154\134N5\161B|\158\146\&6\208\212)\145\201\166\rvI\158T\131m\150\246\&7(\246\176\DC1x\169`\NUL\194G\US\ACK\SO\169\STX.mvW\232\161\&0\ETB\195\208\136D\224\188\255~J\234\DC4\146\155q\246a\203\ETX\183$\233\227\215\233\250\179Ax\237\217\NUL\v*6\180\220\240\245\171$od\197\163\228\&7Q\238~\252.\STX\193\187\167\253\SUBa\a\225\FS\145J\237\GS\247\169P9\149w\243\RS\236\208\RSh\130>\146\154S\237\223\160\&8p`0\250\SYN\RS\EOT}\252\SUB\248(\252-'\147\DC4\140G\133.\137\172\178\133\RS\ACK\ESC\207\166=\178a\224\NAKD|'\178p\194\217\&8\143\208>i\DLEvXH\134\SUB}\143\213\247*\149*\201\213P,`\253\GS\233\245\NUL\STX\135F\228\t\213>\199b\"o\165\229\213C\135\a'\f\187\f\253\&6\182\FS\ESC\140\222\SOH/\FS\253\224\&9\152\STX\193Jd\EOT\178\&5\208\t\159\194\b\238\187\232\200\STX\174\&2\DC2\187\143>\173\154h\172<\225}\169\150\&6\220\128\216el0\237\153\169\180\r\128\191s\172q*\203~+~\128\211O\DLE98\180\&6\232\238\128K\NAK\228Gt\170\147\US\227\DC1\201Dw\225\SO\216\232\160\224QC\CAN)\143\247cu\162iK\205\241\132\245O\199\245xzG\n\230>P\t}`a\230\165\236P\224|D$S%\210\218L&\253@t\180\EOT\178x\185\168\221\239\145\172\168W\ACK\155\139\205\&98\209NI\248\236\ACK\184!\ETB\SI>\b\NULE\144\199/\169\"\242\n\136#D\ACK\193A\226\216\DLE%\162\192\245wYPP=\214\SOH\EOT\152+\134\DC1\SO\137(\173!\v6Q\142\164\149\251\177\ESC(\209\186\DLE&\142gC\178J\DC2\222\207[\147*\153\234\136\215\FS\FS\t\200\SII\FSU\171\157\137\DC3\189\143\172\137C\136a\240\136s\233\224\SYNr\DC1f\146Q\DLE\227\233\136\ETX\134\SYN\134\206G\172\169\166\251\DC1-s\129\183\141\193\SYN\ETBA\143\SYNXx\157\138\STX\FS\NAK?\188\203\204\135\DC1f%\202\a\156\&8\169\234I\135\156\149\164O\ENQs\ETX\224\165=\179\134\172\243\180\238\227\227cZ\197\134Ik<\228\t\186$\204\212\133\143\NAK\157f\181\130n\179:\218q\SOja\214\213\153\138\153\ETB\198\210p\194\192\237\158\252\GS\244\232\n\175\184\192\198\203\140B\181!:`\223\239\157\204\130\154Q\231\199\158\NAK\197I\135dzc\STX\128M\199\RS8\GS\150i8)\182\131\231\167G\ACKQ'\179\149n\230\147\166\CAN\185>\ACK4\159\&1-\194\139s]\197Jy\206\NUL$C\166\161$^\140\206\SUB\172t\248,\228\EOT\vJ\175\209\204\a\ESCL\DC3I9\STX\ETX\184\a\142\167\144\a\179\&4\f\245#!?\SOw%\145\SOS%\225\205\\Fs!\USD\201\SYN\192\SUB\ENQdf\144\168\195\153\FS\135\144\v\252\144\196t\215\129\149\NUL\GSJ\131\227\146\210\FS\253\NUL\161\175Dh\v\163\GSy\198&s\240\212\192\252\128\EM7\198L>\176\199\149\169\"u\159\v\194\DLE\171\135gS>\183\142\251\251\n\STX\155\155\213\149\221\225\130l\251H\DC1\171\226\145\137\203\v\188\199\ENQ?\234\234\143kd?\137\212:\149\212\246 \192\EM\aC\230\211ew>\167\EM$\175X\163(\"\SI\158\234D]\SUB\\v\177p\212\227\254c\224\150W\188\204\rt\193\246\232\130\r\220\ETXx\nO\229\US.\185\&0N[J)\179|Zu\203\n\194\142\SUB\204o\210>\SI\171\DC3\225$r\DC1N\219\190\v\158\&8'\142\248\234.!\210\222\251\170\185ZVz\159\213\157\242~mT\222\226\133\171\141\185\146\128wI\151\&5C\172\236m\173\190\230o\NUL\165\228=\250\n\171\SUB\128\166\206b\211\177\211T\165[\190\201\134$e\175a\177\134\242\143t\191R\173\158\190\NAK+\DELRFZ`\n\132\US\SOH\240\ETXO\157u:o\150\214\n\SUB\139}XoI\230\ACK\200\234\217\DLE\181\131\224kL\249\US{\f\SOH\135\246'\r\129\158\156\213\223D`\235\SUB\153\141\154\&8\177\&1\137\145\214\ACK\169\210\178Yk\233KWx\DC4G\DC4\SI\ETB>\DLE\SUB\162\201\146\227\137h\214\204O\243h>@g\187\195\v\218\SUB\185vu0\211&\\e\210*\173\SYN\183\205#\181\162u&@\219\183q\146.w\146~e'\233\GS\156\&4\147\164\156f\190+S\131S\137\168\153o\197\189\151\179\208Y\188o\200\189o\\\217\251F_\222o\231\230nn\236\205I3\185\147fWv\210\172\189\147\150|\SUB\237\&2C\151\165\244\216\235\EOT\NAKw~\145\249i\202]o^\217\245fO\174o\229\227N>\236\205Cs\185\135\230W\246\208\188\189\135\SYN\141=\180\232\226\161\138\198-=\244\199\CANEt\187+l\227\128\n>N\143\174k>\145\185p\DC3\145\199.ce,\138\143dA\130\164\168*\221q\169z\134\211\234\238\181P\207:\244\EOT\STX\183\203[\145\189/\165P\217\240\t\253\187\NUL\146\219\DC4 \138\160MB\144\132\162x\ACK\240\146#^\236\194\142H0\173@\180\230\238\133x\186p\193*8\184.\209\DC1U\178MU<\240\174 '\194\SO\178\217!\237\"\231(j\147=\170/\224\198\241\FS2\137\DC2O\a{\177\167s\185\DC1/\212\235\150fQ\151\252\215\144w\179*u>\133\226\177\232\249\182\135\ESC\166\&3S\156\203X\233\217\210\206{\178\181Ot~C\220B\175\&4\137\&0\164b\163\178\204\165\&7\227R\172T}\181\170H\253\\US\204\154o\249\&4\132\184\196>D\bw8\188\168\244\228\133\144\198\\}\235\145\147S\DLEd\249\244\167\&8\140\156\205\147B\142\164\176\162\a\DC4\216]\SYNSV\157\220\184H\143\239z\222U\173\228c'8W7V\245%B\145\135\"x\237\153\165\173\202GR\178D\164\228\r\250\158Zux\244\209\202-]\214\187,\216\196=\228\"\233%\157\211\f\178\163\155/\229\130TE\DC4:\201\NAK'c\194\223_\136\158|\172\173\133\213\199vNO6\158O\142\218\210@\225 \229\&4\145^\193iK\153\232\DEL\233\152u\184\211\168 z\DC1\ACK\149+\216\144J-\202\&9\151\163R\172\238\236T\170>\186<\208\157\&1\238\149\&4\245\245\156rV\STX\246\ENQ\232'\235\215#\163\149\t\149\212\&6?\151\251<\142v\168\151\188x<\171\&8\\\246 $\ETB\150\200\173*V+\SI\148\180j\155g\200\244n\202Y`\248*\187wI\NUL\DEL\235\228\247\153J{W\153\220\136\ETB\186\212\NAK\149\222\RS\238K\171\190d\230$\STX\236\150\DC2]\178\SO\142\GS\237\248\140\166\170\248\225p\132\255G3\216\255\208\DC2:\176\SI\236\228\245\175T\147\180':\255\179\235[\172\148M\255r15\165\\\152*\160M4\205\143F6\138\t\253\254d\169\146\DEL\154\242\149\148\237\"\n\DC2\233\255\228\SYNG\145\201\204%DFX\151\241\152y#\SUB\227\EOT!\r\142\163H+\198)\149\ESC\GS\t]\244*\149\228\134\215\183\DC4x\182M\156\188\&9Q\241\216\154I\142Jb\217]\183\DC3C\253.v]\CAN\157\FS'\DC1\147\SOR{\175\139\DELW\164\CAN%+\201NW\225\r\DC3q \t\155g\129$\235 \DC3Z5\137\182\223\239\253\GSy\195\169\DC1\FS5.\178\208 \170>\129J\234[_5y\ETB\ENQ(\137\172\178\254E\151'r\163NF^\231Y\DC3k\238|\128(>bj5\226\148\150\210\236\ETB\237\STX\DC4ow\169\163B\228:Mt\136q\191\201\251\DELm\181\200\USFB\210\217\200\\~\218d\252u\DEL\163\175\155\141\253\198I\SOP\158\215\188x\SIq\134\195\SIz\221\146[\213nz\157M\251\234}\249\ACK\247\200\&0\143\244\146\132\158\188\141,\154\218\169\212\136\ETB\169\235%v\141\255\DC3\149\208\152\140\SUBP\193\CAN?!\EOT\201k+\252\164\DC1\139P\158\196x\171X\130\141\148\191<\208|\187)_\216*\136\NUL\147\ESC\149V\134\154\171'?\f\240,\238Q\161b\152\162\208E3B\245\209@j%e~\233)\240q\a\DELHj\198%Az\\\204\196\DC3\238X\186$\135i\164\146\156\231q\143\&5\228r-kZ\222\DC2\218\147\231_\176\198\&5\252\219(\SUB\225\227\196\216\170\193k\170\165\SIS-c\152j\205\134\169\150\&9L\181\230\195Tk1L\181\150\195Tk5L\181\&4\245\226z\NAK\171xe\233h\199+D\225\185\181\226\SOw\254\196\170\141\249\222\184\145\217\198Cy5\161?\153\192\201\199d\STXR\CANo6\SOfR\DC3\DC1rZ3\232\CAN[\201v\134\&2\228*\148o`\154~\NAK\211\232\187\164\202\154\220\180I\226a\181\208\201\RS\212\229\236\&6\ACKawz\149\234rv\207\ACKa\183\185RW\151\181\219\FS\132\221\139\229bvY\187\231\131\176{\181\156\205/k\247b\NULvk\DC3mIW\186\v\218\189\FS\132\221\ACK\SO\244\203\218\189\SUB\132\221\230\194\188\240:\166\169\131\&0|\177\208\251Il\\uS\206W\241JX\206\249\244ss\190\151A\239r+\210\182\228\143\230<\NUL7\134\164\195V\244n~\225\&4\216\134\222I\237\&6\218\209;]Js\CAN\253\187\&2\189\147\218=kGs\230\210\229\158\253q\151+\211;\169\221f\155,\168/V\154\204nL{\245\235\211;\169\221\243\&6v/\231+Cf\247B\165\184\\\153\222I\237^4\183[\199\203\253Rj\247J5\a@\239\164v/\155\219mLfKC\146\215\180\137\170\ESC\243\235\211;\169\221\171\230v\207&\166\186\144\172c\152\238\171\250r\NUL\244Nj\184\166\&6\183\220\156\204\&5UBlq\230\211\233\ETX\253Y\249]\197K\223\&9\191\&3\134\205\239\232\227`\207yp\b\252\238\212c\238\&9\236\RS\STX\191\211'\198\\\151\240\156s\216=\EOT~gL\204\217L\194s\206a\247\DLE\248\221l\178\208e\143\247\231\176{\b\252\206\196<f.\225\&9\231\176{\b\252n1Q\151\139\229e\237\RS\STX\191[N\244\249R\202\239\250\183{\b\252n5\153]x\NAK\ESC\ACK\187\211\212\201\220\232i\SOH\239@\239*\254\\LN\239fW=\178\253\250Y\239\233\157\&0\173\191\141\190g\DEL\142+\EOT\163\229\238\223\179?\220\NAK\130\209jK\240\ENQ\156\248\n\193h\193#_\196\&1\176\DLE\140\SYN\228\242E\156\r\v\193h\193\&8_\196\129\177\DLE\140\SYN4\244E\156\"\v\193h\193M_\198\209\178\DLE\141V\148u\DLE\a\206\NAK\DEL\229.g\172\230\243\188dh.\134\206X+\182.\147\194\212\ESCt\240\176-\147]\200\153\172n\210-\145\129\&0\217\223\136@\STX\189\&1\217\153aH\207\&5\EMXm\193X'\239w\182c\178T,\233\129~\GS\226~\252\223\159\255\211\198H\252\f,g\168fz\152\151tM\228\234\190jZ\141L\162y\ETXd\234\211\218\222\144\&9IW\135\129L}\142\219\ESC2\171\153\252\130\199@\144\169Ox{BF\155\168\171\165d\235t0\200\212g\191\189!\163\155\&3\233\165\129\129 S\159\n\247\134\204L]=\135\152i\192\139{\131\198\156\155WL\193\205\&8\242['\249\&3\CAN\NAK\239\224\144j\201\235\&7\"\192\207\143\183\148\ACK_5\218\234s\231\222V5l\249\137Um\DLE\200\212'\204\189!ch'\246\170\134\129\204\NAK\216\243\236\212\243\248\&0\144\185\STX{\158\179\191\228\&9pd\174\192\158\ETB\210\227\245\193 sq\246L\158+dG\209\131A\230\n\236YS\159E\158\185\STX{\214\205S\236y\DLE\200\\\131=\207\180\133\252 \225\172\208\180c\207\NAKo3Q\246\\\253\"S\239\236\249\175m\217s\242\145\238kG[7\246\\\203\248#\246\204>O>pd\186\177\231V\200\232\198\\~\132\&5\fd\186\177\231V\200\CAN\166\236\133\138\193 \211\141=\183Bfv\226B\209\&0\128\233F\158[\SOH\195\222%\ESC:2\221\200s+d\216\219fCG\166\ESCyn\133\204R\DEL\SYN\179\169\ESCyn\133\204jf\202\&7\229\135\129LG\242\220\STX\SUBm\"\189\251\DELnd\218q\231\138\&7\197(w\174~I\172o\238\252\143\191\180\222y\RS\196\&9G'\238\252\183\DEL\183\219y6O\236{\f\STX\153N\220\249\185\135E'z\252\162\195\162\DC3=~\238a\209\137\STX\191\232\176\232D\129\159{Xtb\185/:,:\177\220\231\RS\SYN\221\136\236s\140\139vL\182\226\165\&8\202d\171\223\135\235\155\201\254\235\134\239P\252\239\231?\255r\135\162\STX\153?\253r\135\162Odn\224\SOEKdn\224\SOEKdn\224\SOEKdn\224\SOE+dn\226\SOEKdn\225\SOEKh\158\227\GS\138\138\ETB\244({\174~7\175o\246\252\207\191\223.{\174i\252\r\178\231\150\200\220\NUL{n\137\204\r\176\231\150\200\220\NUL{n\137\204\r\176\231\150\200\220\NUL{n\133\204M\176\231\150\200\220\STX{n\t\205 \217\&3\249(d\168X\200\219\&8\219\&8\160_M\GSe\NAK\n\251\\\244\134}=\146\233n\177\207\171*<x\162\SI^\SYN\165\201w\168+\155\DC4\191Ky\242\239<\164\238K5\v\185OS\146\175\210\ETB\218x\169_\NAK\210\159\141\172x\SI\189\252\131\147\181 \128\158\157 p\172\160#Vp\154\133\163\as\rD\195\208J\209G\208\209f\DC3\194\136\255zB5<\172\151\FS\ACK\242\ENQwV\231xV\NUL\137\205\132z\144P\193\GS;\SYN\251Fg\248\250\NAK\251I\190\132\138\251t,%\173H\134;~\184\250\230\187\236\197\206&\159,'\SO\135A6w\178&|\148oP\DC2\248\192u\182\216\n\v\146O\197\166}\254\DC4\135\145\179\193Q\132\161\196\189\RSP`s\223\129\ETB}\134\148\EOT\ETX\158hO(\142\138\SYN\248{m,\DLE*\169Bk\216\f]N\168\v\210\210\GS\251\180\&4\253\171\136b\199\176\222\177\227#\ENQ\ENQ\SO6\ENQ\176\DLEEA\DC4\NUL'\162\189\237A\176\197\217 B>n\196F`ek\DC4a\151\FS\NAK\DC3\215\RS\NAK\ACKL\157\\\155C\128C\SOH\199\220\RS\217\216b7P\162u\254\185\223d\222({\240\152Y\162\226\166)$\153@\b\253\180\187\&4Q\169\234\130\ESC%\253\166\US\203t\164\SOH\NAK2\146\133\160$\EOT6\216\157b\EM\254\187\189\RS\242\178\185\ACKl\226\246$|\147\160N\202\131<y\234\230\167i)\255u`U\229\194B\236\228\212\222\GS\EOT6Q\140\252\152\242 \164\133%AVU\140\SYN\146\212\&30'3\145\211T\161\211J\165\&4\DC4\212\137\206\225\247\132\195\150LL\188\166`\151\RS\a}Q\213c\147\243I\DEL<\203Y\197\RS\132Y\ETB\EM.\172\144\244T\152?x\237\241l\DLE\216\249l\207\209\NAK\204\176D=\150\DC1\253\227\165\151$\148\180\150\244\196\255m\156\DLE\186\208\138\168\n8\US\196\SOHI+\227\215\SUB[\209\&8\241\215\163\180\172\EOTK\246\147\179&\a\164dwZ\156\174\DC3i\197\255\SOHPK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC_\197\128\&2\FS\SOH\NUL\NUL>\EOT\NUL\NUL\NAK\NUL\NUL\NULMETA-INF/manifest.xml\173TKn\195 \DLE\221\231\DC4\SYN\219\202\208fU\161\&8YT\234\t\210\ETXP<v\144`\176`\136\226\219\ETB[M\236\170Je\171\217\&1\191\247\222|\196\238pq\182\&8C\136\198c\197^\248\&3+\NUL\181\175\r\182\NAK\251\&8\190\151\175\236\176\223\236\156B\211@$y}\DC4\185\SO\227\205\172X\n(\189\138&JT\SO\162$-}\aX{\157\FS \201\159\249rd\186Y3\SOH[\182\223\DC4\DC3_c,\148\185>\244Sv\147\172-;E\167\138\137{ \147\219AmTI}\a\NAKS]g\141V\148\211\196\EMk>\n\230s\157\156\224BL\172\209\224\128\DC4\207\237\221\225\FS\NUL\197\DLE^\ENQ\SUB\129(\239 >\FSX{\164\161\207G\227\RSO\201}\162\&26\n\186>y\135\237\GS\DC2\227T\vb\136\175\155\245\183\143\135\186Y\176\227\156\245\180\186\147\&7\143\141iS\CAN!\226V(\173\193B6}\DLE:\133\240\247\244\254\199\181\240nc\194A\STXO\134\235\&9\194\202\ESC\163\222\194\210\v\219\137_\DEL\192\254\vPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC^\198\&2\f'\NUL\NUL\NUL'\NUL\NUL\NUL\b\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NULmimetypePK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL;\138\vC\163\159\SOHAJ\SOH\NUL\NUL\STX\ETX\NUL\NUL\b\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\182\129M\NUL\NUL\NULmeta.xmlUT\ENQ\NUL\ETX\177)\bRux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\"\STX\240\214\207\ENQ\NUL\NUL\138&\NUL\NUL\f\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\217\SOH\NUL\NULsettings.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\250+^\183\175\ETX\NUL\NUL+\SO\NUL\NUL\v\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\210\a\NUL\NULcontent.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vCq\197\131\202\DC1\ETX\NUL\NUL\DC1\ETX\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\170\v\NUL\NULThumbnails/thumbnail.pngPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\180\247h\210\ENQ\SOH\NUL\NUL\131\ETX\NUL\NUL\f\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\241\SO\NUL\NULmanifest.rdfPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\US\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL \DLE\NUL\NULConfigurations2/images/Bitmaps/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL]\DLE\NUL\NULConfigurations2/popupmenu/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\149\DLE\NUL\NULConfigurations2/toolpanel/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\205\DLE\NUL\NULConfigurations2/statusbar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\FS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ENQ\DC1\NUL\NULConfigurations2/progressbar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL?\DC1\NUL\NULConfigurations2/toolbar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NULu\DC1\NUL\NULConfigurations2/menubar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\NUL\NUL\NUL\NUL\STX\NUL\NUL\NUL\NUL\NUL\NUL\NUL'\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\171\DC1\NUL\NULConfigurations2/accelerator/current.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\242\DC1\NUL\NULConfigurations2/floater/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\252\a0s&\DC1\NUL\NUL>\185\NUL\NUL\n\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL(\DC2\NUL\NULstyles.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC_\197\128\&2\FS\SOH\NUL\NUL>\EOT\NUL\NUL\NAK\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NULv#\NUL\NULMETA-INF/manifest.xmlPK\ENQ\ACK\NUL\NUL\NUL\NUL\DC1\NUL\DC1\NUL\136\EOT\NUL\NUL\197$\NUL\NUL\NUL\NUL"),("sample.lua","-- This is a sample custom writer for pandoc.  It produces output\n-- that is very similar to that of pandoc's HTML writer.\n-- There is one new feature: code blocks marked with class 'dot'\n-- are piped through graphviz and images are included in the HTML\n-- output using 'data:' URLs.\n--\n-- Invoke with: pandoc -t sample.lua\n--\n-- Note:  you need not have lua installed on your system to use this\n-- custom writer.  However, if you do have lua installed, you can\n-- use it to test changes to the script.  'lua sample.lua' will\n-- produce informative error messages if your code contains\n-- syntax errors.\n\n-- Character escaping\nlocal function escape(s, in_attribute)\n  return s:gsub(\"[<>&\\\"']\",\n    function(x)\n      if x == '<' then\n        return '&lt;'\n      elseif x == '>' then\n        return '&gt;'\n      elseif x == '&' then\n        return '&amp;'\n      elseif x == '\"' then\n        return '&quot;'\n      elseif x == \"'\" then\n        return '&#39;'\n      else\n        return x\n      end\n    end)\nend\n\n-- Helper function to convert an attributes table into\n-- a string that can be put into HTML tags.\nlocal function attributes(attr)\n  local attr_table = {}\n  for x,y in pairs(attr) do\n    if y and y ~= \"\" then\n      table.insert(attr_table, ' ' .. x .. '=\"' .. escape(y,true) .. '\"')\n    end\n  end\n  return table.concat(attr_table)\nend\n\n-- Run cmd on a temporary file containing inp and return result.\nlocal function pipe(cmd, inp)\n  local tmp = os.tmpname()\n  local tmph = io.open(tmp, \"w\")\n  tmph:write(inp)\n  tmph:close()\n  local outh = io.popen(cmd .. \" \" .. tmp,\"r\")\n  local result = outh:read(\"*all\")\n  outh:close()\n  os.remove(tmp)\n  return result\nend\n\n-- Table to store footnotes, so they can be included at the end.\nlocal notes = {}\n\n-- Blocksep is used to separate block elements.\nfunction Blocksep()\n  return \"\\n\\n\"\nend\n\n-- This function is called once for the whole document. Parameters:\n-- body is a string, metadata is a table, variables is a table.\n-- One could use some kind of templating\n-- system here; this just gives you a simple standalone HTML file.\nfunction Doc(body, metadata, variables)\n  local buffer = {}\n  local function add(s)\n    table.insert(buffer, s)\n  end\n  add('<!DOCTYPE html>')\n  add('<html>')\n  add('<head>')\n  add('<title>' .. (metadata['title'] or '') .. '</title>')\n  add('</head>')\n  add('<body>')\n  if metadata['title'] and metadata['title'] ~= \"\" then\n    add('<h1 class=\"title\">' .. metadata['title'] .. '</h1>')\n  end\n  for _, author in pairs(metadata['author'] or {}) do\n    add('<h2 class=\"author\">' .. author .. '</h2>')\n  end\n  if metadata['date'] and metadata['date'] ~= \"\" then\n    add('<h3 class=\"date\">' .. metadata.date .. '</h3>')\n  end\n  add(body)\n  if #notes > 0 then\n    add('<ol class=\"footnotes\">')\n    for _,note in pairs(notes) do\n      add(note)\n    end\n    add('</ol>')\n  end\n  add('</body>')\n  add('</html>')\n  return table.concat(buffer,'\\n')\nend\n\n-- The functions that follow render corresponding pandoc elements.\n-- s is always a string, attr is always a table of attributes, and\n-- items is always an array of strings (the items in a list).\n-- Comments indicate the types of other variables.\n\nfunction Str(s)\n  return escape(s)\nend\n\nfunction Space()\n  return \" \"\nend\n\nfunction LineBreak()\n  return \"<br/>\"\nend\n\nfunction Emph(s)\n  return \"<em>\" .. s .. \"</em>\"\nend\n\nfunction Strong(s)\n  return \"<strong>\" .. s .. \"</strong>\"\nend\n\nfunction Subscript(s)\n  return \"<sub>\" .. s .. \"</sub>\"\nend\n\nfunction Superscript(s)\n  return \"<sup>\" .. s .. \"</sup>\"\nend\n\nfunction SmallCaps(s)\n  return '<span style=\"font-variant: small-caps;\">' .. s .. '</span>'\nend\n\nfunction Strikeout(s)\n  return '<del>' .. s .. '</del>'\nend\n\nfunction Link(s, src, tit)\n  return \"<a href='\" .. escape(src,true) .. \"' title='\" ..\n         escape(tit,true) .. \"'>\" .. s .. \"</a>\"\nend\n\nfunction Image(s, src, tit)\n  return \"<img src='\" .. escape(src,true) .. \"' title='\" ..\n         escape(tit,true) .. \"'/>\"\nend\n\nfunction Code(s, attr)\n  return \"<code\" .. attributes(attr) .. \">\" .. escape(s) .. \"</code>\"\nend\n\nfunction InlineMath(s)\n  return \"\\\\(\" .. escape(s) .. \"\\\\)\"\nend\n\nfunction DisplayMath(s)\n  return \"\\\\[\" .. escape(s) .. \"\\\\]\"\nend\n\nfunction Note(s)\n  local num = #notes + 1\n  -- insert the back reference right before the final closing tag.\n  s = string.gsub(s,\n          '(.*)</', '%1 <a href=\"#fnref' .. num ..  '\">&#8617;</a></')\n  -- add a list item with the note to the note table.\n  table.insert(notes, '<li id=\"fn' .. num .. '\">' .. s .. '</li>')\n  -- return the footnote reference, linked to the note.\n  return '<a id=\"fnref' .. num .. '\" href=\"#fn' .. num ..\n            '\"><sup>' .. num .. '</sup></a>'\nend\n\nfunction Span(s, attr)\n  return \"<span\" .. attributes(attr) .. \">\" .. s .. \"</span>\"\nend\n\nfunction Plain(s)\n  return s\nend\n\nfunction Para(s)\n  return \"<p>\" .. s .. \"</p>\"\nend\n\n-- lev is an integer, the header level.\nfunction Header(lev, s, attr)\n  return \"<h\" .. lev .. attributes(attr) ..  \">\" .. s .. \"</h\" .. lev .. \">\"\nend\n\nfunction BlockQuote(s)\n  return \"<blockquote>\\n\" .. s .. \"\\n</blockquote>\"\nend\n\nfunction HorizontalRule()\n  return \"<hr/>\"\nend\n\nfunction CodeBlock(s, attr)\n  -- If code block has class 'dot', pipe the contents through dot\n  -- and base64, and include the base64-encoded png as a data: URL.\n  if attr.class and string.match(' ' .. attr.class .. ' ',' dot ') then\n    local png = pipe(\"base64\", pipe(\"dot -Tpng\", s))\n    return '<img src=\"data:image/png;base64,' .. png .. '\"/>'\n  -- otherwise treat as code (one could pipe through a highlighter)\n  else\n    return \"<pre><code\" .. attributes(attr) .. \">\" .. escape(s) ..\n           \"</code></pre>\"\n  end\nend\n\nfunction BulletList(items)\n  local buffer = {}\n  for _, item in pairs(items) do\n    table.insert(buffer, \"<li>\" .. item .. \"</li>\")\n  end\n  return \"<ul>\\n\" .. table.concat(buffer, \"\\n\") .. \"\\n</ul>\"\nend\n\nfunction OrderedList(items)\n  local buffer = {}\n  for _, item in pairs(items) do\n    table.insert(buffer, \"<li>\" .. item .. \"</li>\")\n  end\n  return \"<ol>\\n\" .. table.concat(buffer, \"\\n\") .. \"\\n</ol>\"\nend\n\n-- Revisit association list STackValue instance.\nfunction DefinitionList(items)\n  local buffer = {}\n  for _,item in pairs(items) do\n    for k, v in pairs(item) do\n      table.insert(buffer,\"<dt>\" .. k .. \"</dt>\\n<dd>\" ..\n                        table.concat(v,\"</dd>\\n<dd>\") .. \"</dd>\")\n    end\n  end\n  return \"<dl>\\n\" .. table.concat(buffer, \"\\n\") .. \"\\n</dl>\"\nend\n\n-- Convert pandoc alignment to something HTML can use.\n-- align is AlignLeft, AlignRight, AlignCenter, or AlignDefault.\nfunction html_align(align)\n  if align == 'AlignLeft' then\n    return 'left'\n  elseif align == 'AlignRight' then\n    return 'right'\n  elseif align == 'AlignCenter' then\n    return 'center'\n  else\n    return 'left'\n  end\nend\n\n-- Caption is a string, aligns is an array of strings,\n-- widths is an array of floats, headers is an array of\n-- strings, rows is an array of arrays of strings.\nfunction Table(caption, aligns, widths, headers, rows)\n  local buffer = {}\n  local function add(s)\n    table.insert(buffer, s)\n  end\n  add(\"<table>\")\n  if caption ~= \"\" then\n    add(\"<caption>\" .. caption .. \"</caption>\")\n  end\n  if widths and widths[1] ~= 0 then\n    for _, w in pairs(widths) do\n      add('<col width=\"' .. string.format(\"%d%%\", w * 100) .. '\" />')\n    end\n  end\n  local header_row = {}\n  local empty_header = true\n  for i, h in pairs(headers) do\n    local align = html_align(aligns[i])\n    table.insert(header_row,'<th align=\"' .. align .. '\">' .. h .. '</th>')\n    empty_header = empty_header and h == \"\"\n  end\n  if empty_header then\n    head = \"\"\n  else\n    add('<tr class=\"header\">')\n    for _,h in pairs(header_row) do\n      add(h)\n    end\n    add('</tr>')\n  end\n  local class = \"even\"\n  for _, row in pairs(rows) do\n    class = (class == \"even\" and \"odd\") or \"even\"\n    add('<tr class=\"' .. class .. '\">')\n    for i,c in pairs(row) do\n      add('<td align=\"' .. html_align(aligns[i]) .. '\">' .. c .. '</td>')\n    end\n    add('</tr>')\n  end\n  add('</table')\n  return table.concat(buffer,'\\n')\nend\n\nfunction Div(s, attr)\n  return \"<div\" .. attributes(attr) .. \">\\n\" .. s .. \"</div>\"\nend\n\n-- The following code will produce runtime warnings when you haven't defined\n-- all of the functions you need for the custom writer, so it's useful\n-- to include when you're working on a writer.\nlocal meta = {}\nmeta.__index =\n  function(_, key)\n    io.stderr:write(string.format(\"WARNING: Undefined function '%s'\\n\",key))\n    return function() return \"\" end\n  end\nsetmetatable(_G, meta)\n\n"),("dzslides/template.html","<!DOCTYPE html>\n\n<meta charset=\"utf-8\">\n<title>The Title Of Your Presentation</title>\n\n<!-- Your Slides -->\n<!-- One section is one slide -->\n\n<section>\n    <!-- This is the first slide -->\n    <h1>My Presentation</h1>\n    <footer>by John Doe</footer>\n</section>\n\n<section>\n    <p>Some random text: But I've never been to the moon! You can see how I lived before I met you. Also Zoidberg.\n    I could if you hadn't turned on the light and shut off my stereo.</p>\n</section>\n\n<section>\n    <h3>An incremental list</h3>\n    <ul class=\"incremental\">\n      <li>Item 1\n      <li>Item 2\n      <li>Item 3\n    </ul>\n    <details>Some notes. They are only visible using onstage shell.</details>\n</section>\n\n<section>\n  <q>\n    Who's brave enough to fly into something we all keep calling a death sphere?\n  </q>\n</section>\n\n<section>\n    <h2>Part two</h2>\n</section>\n\n<section>\n    <figure> <!-- Figures are used to display images and videos fullpage -->\n      <img src=\"http://placekitten.com/g/800/600\">\n      <figcaption>An image</figcaption>\n    </figure>\n    <details>Kittens are so cute!</details>\n</section>\n\n<section>\n    <figure> <!-- Videos are automatically played -->\n      <video src=\"http://videos-cdn.mozilla.net/brand/Mozilla_Firefox_Manifesto_v0.2_640.webm\" poster=\"http://www.mozilla.org/images/about/poster.jpg\"></video>\n      <figcaption>A video</figcaption>\n    </figure>\n</section>\n\n<section>\n    <h2>End!</h2>\n</section>\n\n<!-- Your Style -->\n<!-- Define the style of your presentation -->\n\n<!-- Maybe a font from http://www.google.com/webfonts ? -->\n<link href='http://fonts.googleapis.com/css?family=Oswald' rel='stylesheet'>\n\n<style>\n  html { background-color: black; }\n  body { background-color: white; border-radius: 12px}\n  /* A section is a slide. It's size is 800x600, and this will never change */\n  section {\n      /* The font from Google */\n      font-family: 'Oswald', arial, serif;\n      font-size: 30px;\n  }\n  h1, h2 {\n    margin-top: 200px;\n    text-align: center;\n    font-size: 80px;\n  }\n  h3 {\n    margin: 100px 0 50px 100px;\n  }\n\n  ul {\n      margin: 50px 200px;\n  }\n\n  p {\n    margin: 75px;\n    font-size: 50px;\n  }\n\n  q {\n    display: block;\n    width: 100%;\n    height: 100%;\n    background-color: black;\n    color: white;\n    font-size: 60px;\n    padding: 50px;\n  }\n\n  /* Figures are displayed full-page, with the caption\n     on top of the image/video */\n  figure {\n    background-color: black;\n  }\n  figcaption {\n    margin: 70px;\n    font-size: 50px;\n  }\n\n  footer {\n    position: absolute;\n    bottom: 0;\n    width: 100%;\n    padding: 40px;\n    text-align: right;\n    background-color: #F3F4F8;\n    border-top: 1px solid #CCC;\n  }\n\n  /* Transition effect */\n  /* Feel free to change the transition effect for original\n     animations. See here:\n     https://developer.mozilla.org/en/CSS/CSS_transitions\n     How to use CSS3 Transitions: */\n  section {\n      -moz-transition: left 400ms linear 0s;\n      -webkit-transition: left 400ms linear 0s;\n      -ms-transition: left 400ms linear 0s;\n      transition: left 400ms linear 0s;\n  }\n\n  /* Before */\n  section { left: -150%; }\n  /* Now */\n  section[aria-selected] { left: 0; }\n  /* After */\n  section[aria-selected] ~ section { left: +150%; }\n\n  /* Incremental elements */\n\n  /* By default, visible */\n  .incremental > * { opacity: 1; }\n\n  /* The current item */\n  .incremental > *[aria-selected] { opacity: 1; }\n\n  /* The items to-be-selected */\n  .incremental > *[aria-selected] ~ * { opacity: 0; }\n\n  /* The progressbar, at the bottom of the slides, show the global\n     progress of the presentation. */\n  #progress-bar {\n    height: 2px;\n    background: #AAA;\n  }\n</style>\n\n<!-- {{{{ dzslides core\n#\n#\n#     __  __  __       .  __   ___  __\n#    |  \\  / /__` |    | |  \\ |__  /__`\n#    |__/ /_ .__/ |___ | |__/ |___ .__/ core :\226\130\172\n#\n#\n# The following block of code is not supposed to be edited.\n# But if you want to change the behavior of these slides,\n# feel free to hack it!\n#\n-->\n\n<div id=\"progress-bar\"></div>\n\n<!-- Default Style -->\n<style>\n  * { margin: 0; padding: 0; -moz-box-sizing: border-box; -webkit-box-sizing: border-box; box-sizing: border-box; }\n  details { display: none; }\n  body {\n    width: 800px; height: 600px;\n    margin-left: -400px; margin-top: -300px;\n    position: absolute; top: 50%; left: 50%;\n    overflow: hidden;\n  }\n  section {\n    position: absolute;\n    pointer-events: none;\n    width: 100%; height: 100%;\n  }\n  section[aria-selected] { pointer-events: auto; }\n  html { overflow: hidden; }\n  body { display: none; }\n  body.loaded { display: block; }\n  .incremental {visibility: hidden; }\n  .incremental[active] {visibility: visible; }\n  #progress-bar{\n    bottom: 0;\n    position: absolute;\n    -moz-transition: width 400ms linear 0s;\n    -webkit-transition: width 400ms linear 0s;\n    -ms-transition: width 400ms linear 0s;\n    transition: width 400ms linear 0s;\n  }\n  figure {\n    width: 100%;\n    height: 100%;\n  }\n  figure > * {\n    position: absolute;\n  }\n  figure > img, figure > video {\n    width: 100%; height: 100%;\n  }\n</style>\n\n<script>\n  var Dz = {\n    remoteWindows: [],\n    idx: -1,\n    step: 0,\n    slides: null,\n    progressBar : null,\n    params: {\n      autoplay: \"1\"\n    }\n  };\n\n  Dz.init = function() {\n    document.body.className = \"loaded\";\n    this.slides = $$(\"body > section\");\n    this.progressBar = $(\"#progress-bar\");\n    this.setupParams();\n    this.onhashchange();\n    this.setupTouchEvents();\n    this.onresize();\n  }\n  \n  Dz.setupParams = function() {\n    var p = window.location.search.substr(1).split('&');\n    p.forEach(function(e, i, a) {\n      var keyVal = e.split('=');\n      Dz.params[keyVal[0]] = decodeURIComponent(keyVal[1]);\n    });\n  // Specific params handling\n    if (!+this.params.autoplay)\n      $$.forEach($$(\"video\"), function(v){ v.controls = true });\n  }\n\n  Dz.onkeydown = function(aEvent) {\n    // Don't intercept keyboard shortcuts\n    if (aEvent.altKey\n      || aEvent.ctrlKey\n      || aEvent.metaKey\n      || aEvent.shiftKey) {\n      return;\n    }\n    if ( aEvent.keyCode == 37 // left arrow\n      || aEvent.keyCode == 38 // up arrow\n      || aEvent.keyCode == 33 // page up\n    ) {\n      aEvent.preventDefault();\n      this.back();\n    }\n    if ( aEvent.keyCode == 39 // right arrow\n      || aEvent.keyCode == 40 // down arrow\n      || aEvent.keyCode == 34 // page down\n    ) {\n      aEvent.preventDefault();\n      this.forward();\n    }\n    if (aEvent.keyCode == 35) { // end\n      aEvent.preventDefault();\n      this.goEnd();\n    }\n    if (aEvent.keyCode == 36) { // home\n      aEvent.preventDefault();\n      this.goStart();\n    }\n    if (aEvent.keyCode == 32) { // space\n      aEvent.preventDefault();\n      this.toggleContent();\n    }\n    if (aEvent.keyCode == 70) { // f\n      aEvent.preventDefault();\n      this.goFullscreen();\n    }\n  }\n\n  /* Touch Events */\n\n  Dz.setupTouchEvents = function() {\n    var orgX, newX;\n    var tracking = false;\n\n    var db = document.body;\n    db.addEventListener(\"touchstart\", start.bind(this), false);\n    db.addEventListener(\"touchmove\", move.bind(this), false);\n\n    function start(aEvent) {\n      aEvent.preventDefault();\n      tracking = true;\n      orgX = aEvent.changedTouches[0].pageX;\n    }\n\n    function move(aEvent) {\n      if (!tracking) return;\n      newX = aEvent.changedTouches[0].pageX;\n      if (orgX - newX > 100) {\n        tracking = false;\n        this.forward();\n      } else {\n        if (orgX - newX < -100) {\n          tracking = false;\n          this.back();\n        }\n      }\n    }\n  }\n\n  /* Adapt the size of the slides to the window */\n\n  Dz.onresize = function() {\n    var db = document.body;\n    var sx = db.clientWidth / window.innerWidth;\n    var sy = db.clientHeight / window.innerHeight;\n    var transform = \"scale(\" + (1/Math.max(sx, sy)) + \")\";\n\n    db.style.MozTransform = transform;\n    db.style.WebkitTransform = transform;\n    db.style.OTransform = transform;\n    db.style.msTransform = transform;\n    db.style.transform = transform;\n  }\n\n\n  Dz.getDetails = function(aIdx) {\n    var s = $(\"section:nth-of-type(\" + aIdx + \")\");\n    var d = s.$(\"details\");\n    return d ? d.innerHTML : \"\";\n  }\n\n  Dz.onmessage = function(aEvent) {\n    var argv = aEvent.data.split(\" \"), argc = argv.length;\n    argv.forEach(function(e, i, a) { a[i] = decodeURIComponent(e) });\n    var win = aEvent.source;\n    if (argv[0] === \"REGISTER\" && argc === 1) {\n      this.remoteWindows.push(win);\n      this.postMsg(win, \"REGISTERED\", document.title, this.slides.length);\n      this.postMsg(win, \"CURSOR\", this.idx + \".\" + this.step);\n      return;\n    }\n    if (argv[0] === \"BACK\" && argc === 1)\n      this.back();\n    if (argv[0] === \"FORWARD\" && argc === 1)\n      this.forward();\n    if (argv[0] === \"START\" && argc === 1)\n      this.goStart();\n    if (argv[0] === \"END\" && argc === 1)\n      this.goEnd();\n    if (argv[0] === \"TOGGLE_CONTENT\" && argc === 1)\n      this.toggleContent();\n    if (argv[0] === \"SET_CURSOR\" && argc === 2)\n      window.location.hash = \"#\" + argv[1];\n    if (argv[0] === \"GET_CURSOR\" && argc === 1)\n      this.postMsg(win, \"CURSOR\", this.idx + \".\" + this.step);\n    if (argv[0] === \"GET_NOTES\" && argc === 1)\n      this.postMsg(win, \"NOTES\", this.getDetails(this.idx));\n  }\n\n  Dz.toggleContent = function() {\n    // If a Video is present in this new slide, play it.\n    // If a Video is present in the previous slide, stop it.\n    var s = $(\"section[aria-selected]\");\n    if (s) {\n      var video = s.$(\"video\");\n      if (video) {\n        if (video.ended || video.paused) {\n          video.play();\n        } else {\n          video.pause();\n        }\n      }\n    }\n  }\n\n  Dz.setCursor = function(aIdx, aStep) {\n    // If the user change the slide number in the URL bar, jump\n    // to this slide.\n    aStep = (aStep != 0 && typeof aStep !== \"undefined\") ? \".\" + aStep : \".0\";\n    window.location.hash = \"#\" + aIdx + aStep;\n  }\n\n  Dz.onhashchange = function() {\n    var cursor = window.location.hash.split(\"#\"),\n        newidx = 1,\n        newstep = 0;\n    if (cursor.length == 2) {\n      newidx = ~~cursor[1].split(\".\")[0];\n      newstep = ~~cursor[1].split(\".\")[1];\n      if (newstep > Dz.slides[newidx - 1].$$('.incremental > *').length) {\n        newstep = 0;\n        newidx++;\n      }\n    }\n    this.setProgress(newidx, newstep);\n    if (newidx != this.idx) {\n      this.setSlide(newidx);\n    }\n    if (newstep != this.step) {\n      this.setIncremental(newstep);\n    }\n    for (var i = 0; i < this.remoteWindows.length; i++) {\n      this.postMsg(this.remoteWindows[i], \"CURSOR\", this.idx + \".\" + this.step);\n    }\n  }\n\n  Dz.back = function() {\n    if (this.idx == 1 && this.step == 0) {\n      return;\n    }\n    if (this.step == 0) {\n      this.setCursor(this.idx - 1,\n                     this.slides[this.idx - 2].$$('.incremental > *').length);\n    } else {\n      this.setCursor(this.idx, this.step - 1);\n    }\n  }\n\n  Dz.forward = function() {\n    if (this.idx >= this.slides.length &&\n        this.step >= this.slides[this.idx - 1].$$('.incremental > *').length) {\n        return;\n    }\n    if (this.step >= this.slides[this.idx - 1].$$('.incremental > *').length) {\n      this.setCursor(this.idx + 1, 0);\n    } else {\n      this.setCursor(this.idx, this.step + 1);\n    }\n  }\n\n  Dz.goStart = function() {\n    this.setCursor(1, 0);\n  }\n\n  Dz.goEnd = function() {\n    var lastIdx = this.slides.length;\n    var lastStep = this.slides[lastIdx - 1].$$('.incremental > *').length;\n    this.setCursor(lastIdx, lastStep);\n  }\n\n  Dz.setSlide = function(aIdx) {\n    this.idx = aIdx;\n    var old = $(\"section[aria-selected]\");\n    var next = $(\"section:nth-of-type(\"+ this.idx +\")\");\n    if (old) {\n      old.removeAttribute(\"aria-selected\");\n      var video = old.$(\"video\");\n      if (video) {\n        video.pause();\n      }\n    }\n    if (next) {\n      next.setAttribute(\"aria-selected\", \"true\");\n      var video = next.$(\"video\");\n      if (video && !!+this.params.autoplay) {\n        video.play();\n      }\n    } else {\n      // That should not happen\n      this.idx = -1;\n      // console.warn(\"Slide doesn't exist.\");\n    }\n  }\n\n  Dz.setIncremental = function(aStep) {\n    this.step = aStep;\n    var old = this.slides[this.idx - 1].$('.incremental > *[aria-selected]');\n    if (old) {\n      old.removeAttribute('aria-selected');\n    }\n    var incrementals = $$('.incremental');\n    if (this.step <= 0) {\n      $$.forEach(incrementals, function(aNode) {\n        aNode.removeAttribute('active');\n      });\n      return;\n    }\n    var next = this.slides[this.idx - 1].$$('.incremental > *')[this.step - 1];\n    if (next) {\n      next.setAttribute('aria-selected', true);\n      next.parentNode.setAttribute('active', true);\n      var found = false;\n      $$.forEach(incrementals, function(aNode) {\n        if (aNode != next.parentNode)\n          if (found)\n            aNode.removeAttribute('active');\n          else\n            aNode.setAttribute('active', true);\n        else\n          found = true;\n      });\n    } else {\n      setCursor(this.idx, 0);\n    }\n    return next;\n  }\n\n  Dz.goFullscreen = function() {\n    var html = $('html'),\n        requestFullscreen = html.requestFullscreen || html.requestFullScreen || html.mozRequestFullScreen || html.webkitRequestFullScreen;\n    if (requestFullscreen) {\n      requestFullscreen.apply(html);\n    }\n  }\n  \n  Dz.setProgress = function(aIdx, aStep) {\n    var slide = $(\"section:nth-of-type(\"+ aIdx +\")\");\n    if (!slide)\n      return;\n    var steps = slide.$$('.incremental > *').length + 1,\n        slideSize = 100 / (this.slides.length - 1),\n        stepSize = slideSize / steps;\n    this.progressBar.style.width = ((aIdx - 1) * slideSize + aStep * stepSize) + '%';\n  }\n  \n  Dz.postMsg = function(aWin, aMsg) { // [arg0, [arg1...]]\n    aMsg = [aMsg];\n    for (var i = 2; i < arguments.length; i++)\n      aMsg.push(encodeURIComponent(arguments[i]));\n    aWin.postMessage(aMsg.join(\" \"), \"*\");\n  }\n  \n  function init() {\n    Dz.init();\n    window.onkeydown = Dz.onkeydown.bind(Dz);\n    window.onresize = Dz.onresize.bind(Dz);\n    window.onhashchange = Dz.onhashchange.bind(Dz);\n    window.onmessage = Dz.onmessage.bind(Dz);\n  }\n\n  window.onload = init;\n</script>\n\n\n<script> // Helpers\n  if (!Function.prototype.bind) {\n    Function.prototype.bind = function (oThis) {\n\n      // closest thing possible to the ECMAScript 5 internal IsCallable\n      // function \n      if (typeof this !== \"function\")\n      throw new TypeError(\n        \"Function.prototype.bind - what is trying to be fBound is not callable\"\n      );\n\n      var aArgs = Array.prototype.slice.call(arguments, 1),\n          fToBind = this,\n          fNOP = function () {},\n          fBound = function () {\n            return fToBind.apply( this instanceof fNOP ? this : oThis || window,\n                   aArgs.concat(Array.prototype.slice.call(arguments)));\n          };\n\n      fNOP.prototype = this.prototype;\n      fBound.prototype = new fNOP();\n\n      return fBound;\n    };\n  }\n\n  var $ = (HTMLElement.prototype.$ = function(aQuery) {\n    return this.querySelector(aQuery);\n  }).bind(document);\n\n  var $$ = (HTMLElement.prototype.$$ = function(aQuery) {\n    return this.querySelectorAll(aQuery);\n  }).bind(document);\n\n  $$.forEach = function(nodeList, fun) {\n    Array.prototype.forEach.call(nodeList, fun);\n  }\n\n</script>\n<!-- vim: set fdm=marker: }}} -->\n"),("reference_docx/[Content_Types].xml","<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n  <Override PartName=\"/word/webSettings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml\"/>\n  <Override PartName=\"/word/numbering.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml\"/>\n  <Override PartName=\"/word/settings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml\"/>\n  <Override PartName=\"/word/theme/theme1.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.theme+xml\"/>\n  <Override PartName=\"/word/fontTable.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml\"/>\n  <Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/>\n  <Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/>\n  <Override PartName=\"/word/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml\"/>\n  <Override PartName=\"/word/document.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml\"/>\n  <Override PartName=\"/word/footnotes.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml\"/>\n  <Default ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" Extension=\"rels\"/>\n  <Default ContentType=\"application/xml\" Extension=\"xml\"/>\n  <Default ContentType=\"application/pdf\" Extension=\"pdf\"/>\n  <Default ContentType=\"image/x-emf\" Extension=\"emf\"/>\n  <Default ContentType=\"image/png\" Extension=\"png\"/>\n  <Default ContentType=\"image/jpeg\" Extension=\"jpeg\"/>\n  <Default ContentType=\"image/gif\" Extension=\"gif\"/>\n</Types>\n"),("reference_docx/docProps/app.xml","<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\" xmlns:vt=\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\">\n  <Words>83</Words>\n  <SharedDoc>false</SharedDoc>\n  <HyperlinksChanged>false</HyperlinksChanged>\n  <Lines>12</Lines>\n  <AppVersion>12.0000</AppVersion>\n  <LinksUpToDate>false</LinksUpToDate>\n  <Application>Microsoft Word 12.0.0</Application>\n  <CharactersWithSpaces>583</CharactersWithSpaces>\n  <Template>Normal.dotm</Template>\n  <DocSecurity>0</DocSecurity>\n  <TotalTime>6</TotalTime>\n  <ScaleCrop>false</ScaleCrop>\n  <Characters>475</Characters>\n  <Paragraphs>8</Paragraphs>\n  <Pages>1</Pages>\n</Properties>\n"),("reference_docx/docProps/core.xml","<ns0:coreProperties xmlns:ns0=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\">\n  <dc:title xmlns:dc=\"http://purl.org/dc/elements/1.1/\">Pandoc reference docx</dc:title>\n  <dc:subject xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:subject>\n  <dc:creator xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:creator>\n  <ns0:keywords></ns0:keywords>\n  <ns0:lastModifiedBy></ns0:lastModifiedBy>\n  <ns0:revision>1</ns0:revision>\n  <ns0:category></ns0:category>\n  <dc:description xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:description>\n  <dcterms:created xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xsi:type=\"dcterms:W3CDTF\">2012-01-03T11:25:54Z</dcterms:created>\n  <dcterms:modified xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xsi:type=\"dcterms:W3CDTF\">2012-01-03T11:25:54Z</dcterms:modified>\n</ns0:coreProperties>\n"),("reference_docx/word/document.xml","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<w:document xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n<w:body>\n<w:p>\n  <w:r>\n    <w:t>\n      Hello world.\n    </w:t>\n  </w:r>\n</w:p>\n</w:body>\n</w:document>\n"),("reference_docx/word/fontTable.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<w:fonts xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\r\n\t<w:font w:name=\"Symbol\">\r\n\t\t<w:panose1 w:val=\"02000500000000000000\"/>\r\n\t\t<w:charset w:val=\"02\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000000\" w:usb1=\"00000000\" w:usb2=\"00010000\" w:usb3=\"00000000\" w:csb0=\"80000000\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Times New Roman\">\r\n\t\t<w:panose1 w:val=\"02020603050405020304\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Courier New\">\r\n\t\t<w:panose1 w:val=\"02070309020205020404\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Wingdings\">\r\n\t\t<w:panose1 w:val=\"05020102010804080708\"/>\r\n\t\t<w:charset w:val=\"02\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000000\" w:usb1=\"00000000\" w:usb2=\"00010000\" w:usb3=\"00000000\" w:csb0=\"80000000\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Cambria\">\r\n\t\t<w:panose1 w:val=\"02040503050406030204\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Calibri\">\r\n\t\t<w:panose1 w:val=\"020F0502020204030204\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Arial\">\r\n\t\t<w:panose1 w:val=\"020B0604020202020204\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n</w:fonts>\r\n"),("reference_docx/word/footnotes.xml","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<w:footnotes\n    xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"\n    xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\"\n    xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n    xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n    xmlns:v=\"urn:schemas-microsoft-com:vml\"\n    xmlns:w10=\"urn:schemas-microsoft-com:office:word\"\n    xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"\n    xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"\n    xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\">\n</w:footnotes>\n"),("reference_docx/word/numbering.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<w:numbering xmlns:mv=\"urn:schemas-microsoft-com:mac:vml\" xmlns:mo=\"http://schemas.microsoft.com/office/mac/office/2008/main\" xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\">\n\t<w:abstractNum w:abstractNumId=\"0\">\n\t\t<w:nsid w:val=\"FFFFFF1D\"/>\n\t\t<w:multiLevelType w:val=\"multilevel\"/>\n\t\t<w:tmpl w:val=\"D0409C7C\"/>\n\t\t<w:lvl w:ilvl=\"0\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"0\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"0\" w:firstLine=\"0\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Symbol\" w:hAnsi=\"Symbol\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"1\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\183\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"720\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"1080\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Symbol\" w:hAnsi=\"Symbol\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"2\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"o\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"1440\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"1800\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Courier New\" w:hAnsi=\"Courier New\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"3\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\167\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2160\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"2520\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"4\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\131\186\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2880\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"3240\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"5\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\183\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"3600\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"3960\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Symbol\" w:hAnsi=\"Symbol\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"6\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"o\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"4320\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"4680\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Courier New\" w:hAnsi=\"Courier New\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"7\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\167\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5040\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"5400\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"8\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\131\186\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5760\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"6120\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t</w:abstractNum>\n\t<w:abstractNum w:abstractNumId=\"1\">\n\t\t<w:nsid w:val=\"30585973\"/>\n\t\t<w:multiLevelType w:val=\"multilevel\"/>\n\t\t<w:tmpl w:val=\"A47E15CE\"/>\n\t\t<w:lvl w:ilvl=\"0\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%1.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"720\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"720\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"1\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%2.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"1440\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"1440\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"2\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%3.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2160\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"2160\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"3\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%4.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2880\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"2880\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"4\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%5.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"3600\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"3600\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"5\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%6.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"4320\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"4320\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"6\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%7.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5040\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"5040\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"7\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%8.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5760\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"5760\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"8\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%9.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"6480\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"6480\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t</w:abstractNum>\n\t<w:num w:numId=\"1\">\n\t\t<w:abstractNumId w:val=\"0\"/>\n\t</w:num>\n\t<w:num w:numId=\"2\">\n\t\t<w:abstractNumId w:val=\"1\"/>\n\t\t<w:lvlOverride w:ilvl=\"0\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"1\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"2\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"3\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"4\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"5\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"6\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"7\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"8\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t</w:num>\n</w:numbering>\n"),("reference_docx/word/settings.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<w:settings xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:sl=\"http://schemas.openxmlformats.org/schemaLibrary/2006/main\">\n  <w:zoom w:percent=\"90\"/>\n  <w:embedSystemFonts/>\n  <w:proofState w:spelling=\"clean\" w:grammar=\"clean\"/>\n  <w:stylePaneFormatFilter w:val=\"0004\"/>\n  <w:doNotTrackMoves/>\n  <w:defaultTabStop w:val=\"720\"/>\n  <w:drawingGridHorizontalSpacing w:val=\"360\"/>\n  <w:drawingGridVerticalSpacing w:val=\"360\"/>\n  <w:displayHorizontalDrawingGridEvery w:val=\"0\"/>\n  <w:displayVerticalDrawingGridEvery w:val=\"0\"/>\n  <w:characterSpacingControl w:val=\"doNotCompress\"/>\n  <w:savePreviewPicture/>\n  <w:rsids>\n    <w:rsidRoot w:val=\"00590D07\"/>\n    <w:rsid w:val=\"00011C8B\"/>\n    <w:rsid w:val=\"004E29B3\"/>\n    <w:rsid w:val=\"00590D07\"/>\n    <w:rsid w:val=\"00784D58\"/>\n    <w:rsid w:val=\"008D6863\"/>\n    <w:rsid w:val=\"00B86B75\"/>\n    <w:rsid w:val=\"00BC48D5\"/>\n    <w:rsid w:val=\"00C36279\"/>\n    <w:rsid w:val=\"00E315A3\"/>\n  </w:rsids>\n  <m:mathPr>\n    <m:mathFont m:val=\"Lucida Grande\"/>\n    <m:brkBin m:val=\"before\"/>\n    <m:brkBinSub m:val=\"--\"/>\n    <m:smallFrac m:val=\"false\"/>\n    <m:dispDef m:val=\"false\"/>\n    <m:lMargin m:val=\"0\"/>\n    <m:rMargin m:val=\"0\"/>\n    <m:wrapRight/>\n    <m:intLim m:val=\"subSup\"/>\n    <m:naryLim m:val=\"subSup\"/>\n  </m:mathPr>\n  <w:themeFontLang w:val=\"en-US\"/>\n  <w:clrSchemeMapping w:bg1=\"light1\" w:t1=\"dark1\" w:bg2=\"light2\" w:t2=\"dark2\" w:accent1=\"accent1\" w:accent2=\"accent2\" w:accent3=\"accent3\" w:accent4=\"accent4\" w:accent5=\"accent5\" w:accent6=\"accent6\" w:hyperlink=\"hyperlink\" w:followedHyperlink=\"followedHyperlink\"/>\n  <w:decimalSymbol w:val=\".\"/>\n  <w:listSeparator w:val=\",\"/>\n</w:settings>\n"),("reference_docx/word/styles.xml","<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>\n<w:styles xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\nxmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n  <w:docDefaults>\n    <w:rPrDefault>\n      <w:rPr>\n        <w:rFonts w:asciiTheme=\"minorHAnsi\"\n        w:eastAsiaTheme=\"minorHAnsi\" w:hAnsiTheme=\"minorHAnsi\"\n        w:cstheme=\"minorBidi\" />\n        <w:sz w:val=\"24\" />\n        <w:szCs w:val=\"24\" />\n        <w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" />\n      </w:rPr>\n    </w:rPrDefault>\n    <w:pPrDefault>\n      <w:pPr>\n        <w:spacing w:after=\"200\" />\n      </w:pPr>\n    </w:pPrDefault>\n  </w:docDefaults>\n  <w:latentStyles w:defLockedState=\"0\" w:defUIPriority=\"0\"\n  w:defSemiHidden=\"0\" w:defUnhideWhenUsed=\"0\" w:defQFormat=\"0\"\n  w:count=\"276\" />\n  <w:style w:type=\"paragraph\" w:default=\"1\" w:styleId=\"Normal\">\n    <w:name w:val=\"Normal\" />\n    <w:qFormat />\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Title\">\n    <w:name w:val=\"Title\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"480\" w:after=\"240\" />\n      <w:jc w:val=\"center\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"345A8A\" w:themeColor=\"accent1\"\n      w:themeShade=\"B5\" />\n      <w:sz w:val=\"36\" />\n      <w:szCs w:val=\"36\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Authors\">\n    <w:name w:val=\"Authors\" />\n    <w:next w:val=\"Normal\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:jc w:val=\"center\" />\n    </w:pPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Date\">\n    <w:name w:val=\"Date\" />\n    <w:next w:val=\"Normal\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:jc w:val=\"center\" />\n    </w:pPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading1\">\n    <w:name w:val=\"Heading 1\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"480\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"0\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"345A8A\" w:themeColor=\"accent1\"\n      w:themeShade=\"B5\" />\n      <w:sz w:val=\"36\" />\n      <w:szCs w:val=\"36\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading2\">\n    <w:name w:val=\"Heading 2\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"32\" />\n      <w:szCs w:val=\"32\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading3\">\n    <w:name w:val=\"Heading 3\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"28\" />\n      <w:szCs w:val=\"28\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading4\">\n    <w:name w:val=\"Heading 4\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"24\" />\n      <w:szCs w:val=\"24\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading5\">\n    <w:name w:val=\"Heading 5\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:i />\n      <w:iCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"24\" />\n      <w:szCs w:val=\"24\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"BlockQuote\">\n    <w:name w:val=\"Block Quote\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:spacing w:before=\"100\" w:after=\"100\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:bCs />\n      <w:sz w:val=\"20\" />\n      <w:szCs w:val=\"20\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:default=\"1\"\n  w:styleId=\"DefaultParagraphFont\">\n    <w:name w:val=\"Default Paragraph Font\" />\n    <w:semiHidden />\n    <w:unhideWhenUsed />\n  </w:style>\n  <w:style w:type=\"table\" w:default=\"1\" w:styleId=\"TableNormal\">\n    <w:name w:val=\"Normal Table\" />\n    <w:semiHidden />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:tblPr>\n      <w:tblInd w:w=\"0\" w:type=\"dxa\" />\n      <w:tblCellMar>\n        <w:top w:w=\"0\" w:type=\"dxa\" />\n        <w:left w:w=\"108\" w:type=\"dxa\" />\n        <w:bottom w:w=\"0\" w:type=\"dxa\" />\n        <w:right w:w=\"108\" w:type=\"dxa\" />\n      </w:tblCellMar>\n    </w:tblPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"DefinitionTerm\">\n    <w:name w:val=\"Definition Term\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Definition\" />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:after=\"0\" />\n    </w:pPr>\n    <w:rPr>\n      <w:b />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Definition\">\n    <w:name w:val=\"Definition\" />\n    <w:basedOn w:val=\"Normal\" />\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"BodyText\">\n    <w:name w:val=\"Body Text\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:link w:val=\"BodyTextChar\" />\n    <w:pPr>\n      <w:spacing w:after=\"120\" />\n    </w:pPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"TableCaption\">\n    <w:name w:val=\"Table Caption\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:link w:val=\"BodyTextChar\" />\n    <w:pPr>\n      <w:spacing w:before=\"0\" w:after=\"120\" />\n    </w:pPr>\n    <w:rPr>\n      <w:i />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"ImageCaption\">\n    <w:name w:val=\"Image Caption\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:link w:val=\"BodyTextChar\" />\n    <w:pPr>\n      <w:spacing w:before=\"0\" w:after=\"120\" />\n    </w:pPr>\n    <w:rPr>\n      <w:i />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"BodyTextChar\">\n    <w:name w:val=\"Body Text Char\" />\n    <w:basedOn w:val=\"DefaultParagraphFont\" />\n    <w:link w:val=\"BodyText\" />\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"VerbatimChar\">\n    <w:name w:val=\"Verbatim Char\" />\n    <w:basedOn w:val=\"BodyTextChar\" />\n    <w:rPr>\n      <w:rFonts w:ascii=\"Consolas\" w:hAnsi=\"Consolas\" />\n      <w:sz w:val=\"22\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"FootnoteReference\">\n    <w:name w:val=\"Footnote Reference\" />\n    <w:basedOn w:val=\"BodyTextChar\" />\n    <w:rPr>\n      <w:vertAlign w:val=\"superscript\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"Hyperlink\">\n    <w:name w:val=\"Hyperlink\" />\n    <w:basedOn w:val=\"BodyTextChar\" />\n    <w:rPr>\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n    </w:rPr>\n  </w:style>\n</w:styles>\n"),("reference_docx/word/webSettings.xml","<ns0:webSettings xmlns:ns0=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n  <ns0:allowPNG/>\n  <ns0:doNotSaveAsSingleFile/>\n</ns0:webSettings>\n"),("reference_docx/word/_rels/document.xml.rels","<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering\"\n  Id=\"rId1\" Target=\"numbering.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\"\n  Id=\"rId2\" Target=\"styles.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings\"\n  Id=\"rId3\" Target=\"settings.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/webSettings\"\n  Id=\"rId4\" Target=\"webSettings.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable\"\n  Id=\"rId5\" Target=\"fontTable.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme\"\n  Id=\"rId6\" Target=\"theme/theme1.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes\"\n  Id=\"rId7\" Target=\"footnotes.xml\" />\n</Relationships>\n"),("reference_docx/word/theme/theme1.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<a:theme xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" name=\"Office Theme\"><a:themeElements><a:clrScheme name=\"Office\"><a:dk1><a:sysClr val=\"windowText\" lastClr=\"000000\"/></a:dk1><a:lt1><a:sysClr val=\"window\" lastClr=\"FFFFFF\"/></a:lt1><a:dk2><a:srgbClr val=\"1F497D\"/></a:dk2><a:lt2><a:srgbClr val=\"EEECE1\"/></a:lt2><a:accent1><a:srgbClr val=\"4F81BD\"/></a:accent1><a:accent2><a:srgbClr val=\"C0504D\"/></a:accent2><a:accent3><a:srgbClr val=\"9BBB59\"/></a:accent3><a:accent4><a:srgbClr val=\"8064A2\"/></a:accent4><a:accent5><a:srgbClr val=\"4BACC6\"/></a:accent5><a:accent6><a:srgbClr val=\"F79646\"/></a:accent6><a:hlink><a:srgbClr val=\"0000FF\"/></a:hlink><a:folHlink><a:srgbClr val=\"800080\"/></a:folHlink></a:clrScheme><a:fontScheme name=\"Office\"><a:majorFont><a:latin typeface=\"Calibri\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\239\188\173\239\188\179 \227\130\180\227\130\183\227\131\131\227\130\175\"/><a:font script=\"Hang\" typeface=\"\235\167\145\236\157\128 \234\179\160\235\148\149\"/><a:font script=\"Hans\" typeface=\"\229\174\139\228\189\147\"/><a:font script=\"Hant\" typeface=\"\230\150\176\231\180\176\230\152\142\233\171\148\"/><a:font script=\"Arab\" typeface=\"Times New Roman\"/><a:font script=\"Hebr\" typeface=\"Times New Roman\"/><a:font script=\"Thai\" typeface=\"Angsana New\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"MoolBoran\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Times New Roman\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/></a:majorFont><a:minorFont><a:latin typeface=\"Cambria\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\239\188\173\239\188\179 \230\152\142\230\156\157\"/><a:font script=\"Hang\" typeface=\"\235\167\145\236\157\128 \234\179\160\235\148\149\"/><a:font script=\"Hans\" typeface=\"\229\174\139\228\189\147\"/><a:font script=\"Hant\" typeface=\"\230\150\176\231\180\176\230\152\142\233\171\148\"/><a:font script=\"Arab\" typeface=\"Arial\"/><a:font script=\"Hebr\" typeface=\"Arial\"/><a:font script=\"Thai\" typeface=\"Cordia New\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"DaunPenh\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Arial\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/></a:minorFont></a:fontScheme><a:fmtScheme name=\"Office\"><a:fillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"35000\"><a:schemeClr val=\"phClr\"><a:tint val=\"37000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"15000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"1\"/></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"100000\"/><a:shade val=\"100000\"/><a:satMod val=\"130000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:shade val=\"100000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"0\"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w=\"9525\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"><a:shade val=\"95000\"/><a:satMod val=\"105000\"/></a:schemeClr></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"25400\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"38100\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"20000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"38000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst=\"orthographicFront\"><a:rot lat=\"0\" lon=\"0\" rev=\"0\"/></a:camera><a:lightRig rig=\"threePt\" dir=\"t\"><a:rot lat=\"0\" lon=\"0\" rev=\"1200000\"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w=\"63500\" h=\"25400\"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"40000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"40000\"><a:schemeClr val=\"phClr\"><a:tint val=\"45000\"/><a:shade val=\"99000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"20000\"/><a:satMod val=\"255000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"-80000\" r=\"50000\" b=\"180000\"/></a:path></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"80000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"30000\"/><a:satMod val=\"200000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"50000\" r=\"50000\" b=\"50000\"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults><a:spDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"3\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"lt1\"/></a:fontRef></a:style></a:spDef><a:lnDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"0\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"tx1\"/></a:fontRef></a:style></a:lnDef></a:objectDefaults><a:extraClrSchemeLst/></a:theme>"),("s5/default/blank.gif","GIF89a\SOH\NUL\SOH\NUL\145\255\NUL\255\255\255\NUL\NUL\NUL\192\192\192\NUL\NUL\NUL!\249\EOT\SOH\NUL\NUL\STX\NUL,\NUL\NUL\NUL\NUL\SOH\NUL\SOH\NUL\NUL\STX\STXT\SOH\NUL;"),("s5/default/bodybg.gif","GIF89a\230\NULN\SOH\196\255\NUL\192\192\192\181\181\181\189\189\189\198\198\198\206\206\206\214\214\214\222\222\222\231\231\231\239\239\239\247\247\247\231\239\239\239\247\247\247\255\255\198\206\206\206\214\214\214\222\222\222\231\231\181\189\189\189\198\198\231\247\247\206\222\222\214\231\231\222\239\239\198\214\214\189\206\206\206\231\231\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL!\249\EOT\SOH\NUL\NUL\NUL\NUL,\NUL\NUL\NUL\NUL\230\NULN\SOH\NUL\ENQ\255\224!\RS\207u\EM\212\243@\142\154B\164\STX\204\244lM\128\181\212|?)\v\160B\214c(,\nFo\185\212\&1\SYN\150\EOT\179\166\192\SOH\142DEe\168\173\252,\211pm\STX\SYN\155g\199\217\162\210p\156\223\240\218\136\212\184<\n\170\186\195\209(8\f\SIe=\n\DC4\EM\bqXdK\tP\135q<\DLE8k:a\v\DC4D9U3\tG\f\DLE\r;W\NAK\EM[\143hQ[\t\EM\133\152L\f\NAKH5\v\EM2\179\DC4\130\166\185<s\"\SI\r*v\SI\"\128\128\SOR<kV\143X\DLEM\NAK\NAK\161\186\177\158H\154=\179\184\\E\DC4\DC45Ji\185P\NUL\DC3\205\226a\158A\NAK\215\234\150\ETB\205\186\240\&3\188$\SI\ACKm\194#\SI\DEL\239\178\180\b\184g\160(Y2$\158\r\"\DLE(QB\198o\198\132g\EOT%\fDvkJ4Y\208\222-\128\144\NUL \141#\v\US\150\162\177f\156\132\v\RS\r\255\190\225\165o^>\a\"\174A0\ETBg#\DC3p\241~\FST\a\141\199+\143\ESCu\FS\163A\225B\SIU\183*4\164Qm\201\198W\NULJ\214`\DC4\EOT\203P\NUL\140\&2\240P\NAKUB\n\149\166\230\180t\217\v\230\129\173\234tI\237\215Jm\218!\156\128\240P:\DC1\227\207h\NAK(\f|\150!\ETX\EOTu\t\210nE\162\fY\218\192\NUL\CAN$PL\202B,&\170\248\ENQ^\252\tC[\176b\230\CAN0KvsL\SUBP\225\173\221$\216 \130\n\156\202\CAN\241\134\186\238\212\153\140, x\b\202\194\179(\139\DC1c-\r\250\178+\n\163f\182\STX\169 \161OR4ZC\200 \193\&7\230%#\f\\ ;\STX\194\244\179\201]?Z\203 C\202p\183\181\&6\225h\230\EM\172\132\132,8X\176@7\214B\188U\242F\194-\195\213\SUB\NAK\246J\225\214@\251\243\RS\195pF\157g\216yr_8`@\132Y\255h6\245\DLE\201\129bts\197\ENQ%\161\246\159\CAN\ETB\177\a!Q\FSZP\b\SOH\ETB\134!\130u\212Uw\221&\226\EM\196\192\ETX\NULH\136\153\132\f\184X\195Bb\f\196Hw\US\233`a\136S,eF\138\148|\210@|<\STX \194u%\RS`\143\b2\132\166\146VN\170x\CAN@\218\152\DC1\216\DC3JU%\131\ENQ\DLE\204T$\FS\198M\145\223^;\208\210\128\143<\RS\128d\146$\236!^\138\ACK\189\249\"\rp\ACK\241\CAN\DC3\200!\167\212{\232Us\209\151bL\240g\SI\SI\216\&7\131p\SYN0\183\225\DEL\a4\192\166X\133\206 #<yI\nV\138N\ACK\197\EOT_i\193\137\165 \206\SOH*_(\221( A\ACK\r\136j\228\154\143\RS !\156\210,6\ETX\172\185\148&!#\165qi\219\&3\178j\ETB\CAN\145=\NUL\171*\FS=\NAKd&\139\128\158\208\234\FS\226ud\144\140\180\154\"\163:\175\176\243\ETX\255\ETB\236\181\&7E\148\&5\SO\251\236\172\NUL\252\&3\SOH(\128\SUB\176l>\142\180\CAN\SI\141\234\198S\154V\147\177\167k\168sE\235\173A\249\&5\129CA\132d \NUL\160\231\142\144*\157\241\192*\236\ESC\EM\212\197\235\&3h\134a\239\189\238\STX\144\223\142\&4< E\SUB\222\&9\240\GSX\SOH\US9\145{\210\242\144\&0<\228\205u\176\152\139BL\233d\249\146\137\134\STX\b\DC4\DC2A\202\241t\220\232UW\154r\195\\4\135\145/~\254\149\215\179\202+\207\176\133\DC1\ENQI\\-\170A\ESC\212\177\n=\232\181\204e\DC4\155\210SrC\a\155\&5\209\238\198U\NAK*\237-\231\192\201\186t\140\135vU\v\141\ACK\175\DC2o=c+W#\146\193\160\\\135\CAN\v9I@\SOH\197b\133H@\183\211\GSS\bI\220g\244\132\196b\208\DLE\254\198\157\135\254=\ENQ\227\222\238\141\134\227*\129s\237\DLE\tq\242\151\212\140v\188\222\140AQ.\139\255\ENQH\215\208\165\232\131l\EM\r\187f$\253\229\DC3\174\233\202\b\ENQ\ETB\DC1\130:\FSGH\161%\DC4\142!!\192\198e\a|\199}:p\137\250S\NUL@\208\150\135\183;\EOT\ACK\204\n\209\219\132\244\185\&86\208iR \237Xb\214+0\247\NAK\DC3\252\160\CANhn##\155\DC2zs\242L\DLE\rP\US\135\231\200\170\145\151\f\145\152\177\&3\STXI\204\168<\228L4X\141\f\174\v\b\240\224\160\147\143\NUL'\DEL/\179\202&\152\STX@0\204b\v\242\218\193\DC3\194\145\144Ph\162#\EM\152\NUL7:\183\172\205\196\143\f\178:\136\CAN\210\176\189\143\f\193\&1\212\147\\A\232\227>\146\&4\204\DC4C\b\194)\174\DLE\ENQ\222\137\206{@\224\199,\148g\167#4o+'\172\146c\SYNp\166\231\156\171\CAN\200Z\192\SOH\\\163\NUL\141M\161#\140@\224\f\155\&8\192\201L\177)o@^<\STX\211\192Y\bA~\138\v\ETXN\174\144\132\255\EOT\240\144\140(\220\196\NUL7q\132fh\SOH\DC3\132(\223\DC4\240\241\168\DC4\CAN\192\NUL3\164B\NAK\184\225\155\226\\a)ih\227\198\160\168\ACK\b0\224\US@X\163\SUB\155\246\ACK(>$\135Qy\161)\160\DLE@\166\192\168\"YL\v{4\210\ACK\204\b(Ic\201\163\SUB\202\240\143g0\160.B\137\STX\SI\192QJC.\225!\139\132B\ENQ%\137\DC1\131\&8\230\CAN\t G\145\156\213?\134a\233\rFP^T\EOTc\137\SYN\138\225\SO\173\ne$WY\134\&5\\\NUL8\236\209B9\226\179\150d\184\210\ESCry\ENQ#f\194\rE&\166dp\216\193\t\UST\183k\132\&02o\b\223\&47q\129\129\&9m,\160\&4\139\252\214A\131_Q !\169\164[\131\134\153\&3\146P\203BkH\192\ENQ\200F\ETX/\133\DC3\v~*\231\EM@\198\200a:\DC4+\SO\NUL\DC1\224\224\&9\160\DC3u\196?\253\220\205BFc\158\188\b\255\194\140\168\161\152\151\fz\165n\158\193\160\153\EOT\160B\US\DC1#RX\177\DC2\128\161\SYN\ENQ\"\160\146\151$\t\STXx8\203h|\STX\FS\211M\163\&8I\160\216h^\161\NAKhTEb\209\208\230\194\196X\201m\253r\165\248Bj\202l\162\ESC\nH\NULp\195`\213<H\180\155\&0\184'\154\\hcGW\145\ETB\228$\ACK\169\201S\158\SI\167\&21\251\216\171\135M\165\147:2\240\128=A\NAK3\163\136\144\165Z\DC4\NUL\172\RS\169\SO\NAK=\v\183\136bVO\212\135\v\133\176D^\184Q\136U0\150vZ\b\ENQ\SYNA\211\141BH\236\149\202\147S\189:uW\RS\133d\t8jW\ENQ\250\n\143\234\&8JM\238\&0\215<\166\131\NAK\131\153\&51\STX\197@!( [\198\214\&6Q}\161@\NUL\128\&3[\SOH` 0\v \ETX\221\NULcY\153\144\241\n\ETB1%f\250B\n%\156\146X\224*\DC24\188'\166\232\ACK\160\161\255\"\154\195i\245pG^8j\175FC\v7\130\226\128\162\204-\178kx\198\ETX\186\177\138\NUL\184\212\DC2\153@(.$\180A\180\EOT\183\f@j\r^k\NUL\156\247F\179\186}i\151g'\203\131W\EM\141\180\185\208n;G\208\206\DC3\168\224\SO\ETB(@\SO\134\"\152\217\186\151\STX\STX\240[\ENQO\147\134\191$`1\176*T\NUL\EOT\224\157\191\DLE\167\148\209%\197\164\236\ETX\139\151\DC1E\142bX\ENQ\NUL^\203\&0\DC4RM\155\EOTC\ACK\SUB.5\ENQ\205\n\NUL\187L`\176KL\208\128\"c@\US,\130\147*\144\195\141\188\228'\SOH\180\179\142Ui\167\131P<c\182\171\152H\ENQ$ \129!\GS\183=\182!Jq7\241\ETB\172D7\a?|\EOT\178\236\243a*|!\a\v\131\211(>&\156\STX\198\ETX\145L\160ow\140\146`\DC1\156V\187G\218\195\RST@\136\132\152\a\202\SOHp\239\140\245reX\244\235\168\DC2\211\255\175\196f[\136\&6\207@\NULC\240\139\ENQ$\DLE\NUL\ENQ-\SUB4\DLE\129\&2x'%\221\245\201\144\140\233\147\STX\132\\\164\149K\140Q4\156\DC3\153\DC2P\ETX\SOH\SOH\192X`\171\237n>|\161#\222^\249\CAN\221\&8t3/pB8[\154`\240\EM\ENQX=T\148\223- \STX=m\145\132F\209)\173\156z\198\DLE\155\215\DC1\200\241\SI1\160\ACK\204\&3N\SUB\CANpA\208\SUB\CANJkh\173\NUL\159\US!\228y8\128U\190\CAN\STX\ENQ&\240\225\162\FSC+\205\DC2\207\STX,C\134# `P\163\NUL\SO\175lc\156!L\160\148\208h\242\172\&6(\152=\185(\174\170J\131\fw\218\131]\157\STX\a\248\147\r\233\218\&6g\137\157[\SYN\147\235D\176v\144\145\NUL\164Y\RS~\134\129\187\235\161\153\f\DLE\219\216z\170Tt\215\&0\DC3\227\NUL\220\201)\154O\177\205(\SOHU\236Vi\163\192\165x~6\178\187f\212\NAKzL\152\DC4\255\236C#\bP@\n\132\163\164\159h7r\163\153\202\155r8\DC2u\222\173Z\DC2\EOT\NUL\a3a\128m\130\253\&3\165\ENQ\198\141)\249\v\139q\169\CAN\170DE\144\134\132r\EOT\FS\176g\n\135\205P;J\155B\205\216\220\"@\153\DC1\201\145\193#\219\166\133\142\244\164j0\v+\235\146Cr(\152\156\221#R\214\144\187\RS\136\245l$/\ETB\248\213P\feY\201\241\NUL\NAK\203\&9\ACK\181;\138\ENQ.\216\ACK}\DC20F\208\153\194\DC3\168[\249\228\162:\165\EM/\226\tXl$\172X\b\133'p`8\170\131\134\146Q\193\202\226sp\b$l\SUB\235(\ETB\193\US\\B \229[u\a\USVwz\241B\153f<\189\226P\232\201r\174\191\202\171d\191\&5\234\SO\204\247\240\211x\163\193\222[\137j\236\142\242\182\189k\207\160.3\161QG\198\141\t\b\164\235\243[\210\STX\185\224\&0\a\201\207\129\ENQ*'\GS\EM6\EOT\255\ETX!\SOH\198\DC37\168\240d\ESCG\ENQ\192\199<q\240a\182Ar\t\227t\209@H^\226~\157\229Y\247\ETBC\167\161\f;3=d\164\NUL\CAN\128|s\208\STX\188\192\STX\170%\GS\169W~\SYNp\SOH\255\128R\135\af\247\DC1V5Q\ETBk\176\DC1;\NUL\SOH\ETX\NUL\ENQ\151`~`v\ba\148\129\162\210\ENQ\DLE$B\EOTQ\ACKG }p\208u&X\130)\216N\r\128G\201C?\142v'\FSa{\178Q\EOTH\NULdjtB\\\194X\171\176%\DC20\SOH\ETB \RS\198\135\ENQ\153 \132\128\178\133&\244a\GS!A\DLE\151;z\243\vp\176|\202GGMh\GSz\240\NUL;\DLE\viT?ixK\211p-\255\211BA@sN\215Qe\ENQ@\DC2\176\ENQ@p\SUB\EM\a@\198\164\134\143p94\160\bj\132\NUL-\229\FS\DC2\247\133\205\195\STX\248\144SwxGPh\a\SO\144\DELi\152\138\213\224%:\160\ENQ\255\245q\t\142!(\CAN\178\FSj\213;\SUB\178\CAN\174c*\151\224X\142\&8n\200G\137\&5!\b\165SO\185\179(\146C\ACK'\176\DC2\174R\NUL$\192\140\a\128\a\190p\SOH|\DLE\f=\200/H\152\ENQ\142\150\t(tp\236\161\CAN\150 p\163\176<\133\208;0C7\132\NUL@\DC4P\a\132\144X\186\196\t\231\a\140\136p\EM\227\131!\236`\GSnp\ACK#\208\STX\240\164\SI\166\136\SOHH\132v4\132\ACK\172\160#\254\150\133\160\197\t\171\144\144\171\224@\182\247v\227\196?\182\240\fu\240+g$\n\240\248%z\163\vf\EOT\129Jh\ACKs\224\a\248P\STX\SI\150z\a\240\at\ETB\144~\DC4I\223(\137\251\148\CAN\247\247~\254t\ESC\210$\ETBqQ\ENQ\233\240\f\152`\DC3\v`\STX\236q\v9IK\ETB\185E\195w\ACK\175\160\CANy!Q\153!\GS\207D\am\128\a&\249\v\245\192\135\145\&4\DEL\SIUh\176\132\137\255F\227M\STX\DC1\ETB\144\241a\216\&0OP\230\&7\182\&1\DC44\DC1\148<\130R\210\242\DC3\ETXp\ACK\r \NULE\214\a,P\146\208\134\STX\190\128\SI\ACK\192\SO\t\168\ACK\179\NAKR\235d\ETX\\\STX\a\191R\CAN^\229\ETB\187\241\EOT\227Uf\243d\150_\242\&0b\128\CANG\208\USfp\STX\SOH\216\ACK\159\DLEa\146\249n\195\192\SO\183\208\DC1\205\DLE\EMkP-\SIu8\229\ACK\SIK\182\FS\234`\STX3\SYN\n \163\152\255\SOHqgPeZ\DLE?=\194|\CAN\240\a\DC1V\STXf\161VX\145^\240\STX\CAN\134\DC4j\234P\DLE\221\145\DC2\221\&1\154g@\n\ESCAl\222s\b\131\197\154<\SYN\SI\198\129a\RS\201|{pd\141R\STX#\192\NAKJUO\161\134\FS\147!\RS\197Q\150\145vY\255aJ\DLE\128\SOH\150\NUL/\140\233\156\186 \ETB\130i\n\227B3\159$\SYN\DC1`\NULN\183$1\209m|SO\SOH\182\"PB\vD\DLEe\255x\241d\198I,\221\240\t\150\128q\191\200\158\229A\158\238r\143S\160\148\159d\SI{`.\247\DLE\DC31\146\149\130AW\v')\224)\\X3\DLE\164\246J+d\RS1\182\ETX\STX\160A\154\197\160\152\&1\EOT\193\185\EOT\158\230\&3\b\SYNd\164x\130\SOH\224(\DELP\DC4\142\"a\SO5[\230\150\CAN\145\146<\226\225\147DPv\229\230\163\231f\RSd58A\208\FS\244\197\162\173\t\ENQd\224\CAN\DEL\DC1f\SO*&\255\146]\141\194\v\ACK\DLE\NUL\211!\GS\141\DC2\fD\176\DC1,\182\161\236\229\"Tg\b4D1c6B\236\177\ESC|\193X\146\162\ETB\209\231!-\146H\216\ACK\165\255q\b\237\177\NULFyYd\179\147\239\153uj\226]\v&\141t\233(h\138or\150\144tB\v\ETX\128\ETX\SO\CAN^\166P\SO\139Q(\204%p\240\145<\228B\v<\180\160z\SUB\a\234\240\ETB<\193H\159\160\165\DEL&\STX^\234\SO\255w\216\NUL)\128\t\191\&2\158D\161\DC4^\201\r\167x\v\bpU303D\210v\217\STX:iQv\RSG\n\223f\vW0\134\149\NAK\170k\168\SOavMM`kS\160|*\183\165\&7\186\165G\"\f\r\160dW\ACK+\248v\ESC\ENQ'\ETX\ETB \SOH\STX \NULk@j\213\STX\v\209VH\170\153\ETB\178i4W\198G\NUL\208W\222\241\142\202j?\134W\170^\181\131\209j\173ZW\173v \STX \153\173u!~\177\214\"\171\137\ETB\213\128\SUBE\231\174\245\EOT\DC4\222`4\220p\NAK\182\225\NULY\166n\b\240q\245z!Q\176\177\206\186)\161R\146g\242W\ap\163,\208\132\215i\174\&3\ACKu\tY\SUBAP\DC1\222s\CANlSV\245Dq\229\&17R\192\DC1\244\SOH\ACK\157F\175\EM\251\154\156\208\&3\n\NUL\153K@\SOH\246y$\ETB\DLE\NUL\DLE\DLE\SOHQ\232g\170Eh\ESCCmS!/\142q\v5\a\DC1\255\135w\fmg\165\185\240\ETB\DC1tT\210\bc=\139;\238\&8\148W\176\DEL=\160,\239Fd\155!y\172\218\v\186\178)=A;\217\215%\178ap\187I\172\&9\216\ETB\152*\172\210\224\136\128\152\NUL\150\DC1\182\170\178\DC1\139\194\NUL\SO\240\146\&40\GS&)\GSg\STX\DC3\255\138\a\211\138?\192\225\SUBJQV\133PWO\NULilu\DC1\203\193\179\211s\177;0.A\NUL\182\130\251\ACKr\241\&8\SI\224\US\RS\180\a\186\165\SI\155\193\a\194\224\DELQq\131\US\161lks5\132\208\139\\\130\181\166\147\131\158\235\ETXT\SYN\CAN\aD\182\165k\DLE\178h\DC1\135\187\EOT\230R\NUL'\224\NULsW\146\250P^w\NUL\SOH,WO\ETX\225=\190WP\186\231@\137\247}\196\147\189\255\161\&7{\164\156\147X\188\aU\t\ENQ\224\ESCEa\aDK\146&\248n*\192\188\194\&0\b\133\209/\243\182\155\FS\177\ACK\180\NULM\177\129\184\CAN\137\RS\255\t\160\142\160j\190\CANB9\vP\NUL)Q\NUL\221\165\143\250\216\188\245\NUL\191\230RH\168\DC1W\198\199\&6\221\&4P\DC4\152\138\SYN\177\NUL\179Q\ENQ\np \179p<\183\180e\229K\192\SOH\161\137a`\SOHR\184\v\249\240\v9\234\148+\224\v\251\DLE\NAKB\129C\203S\FS\233\STXe\t\t\FS\RS\162\137\222\&3~9@:F\160\DC4H\224t\137\181J=h%\ACKW_&\140\EM\185\244\134\SYN\209\177\201G\a\143k\STX\128\160\192\DC40\141Q\DC4\186I\140\ACK\180\&0\r\DC1\148\SOH\ETXP\a\207t\142y4N\152\196\193\&6\217\RS\138\248\197\SOH)F\176\192\ACKM\252\US\\\249D0\NUL /\129L\251\216\STX\197`T\178\177C\171\132\DC2k\ETX\ESC\RS\130\EOT&p\v\130\156\146_\176\177APA\133\148\ESC\207\165A@P\b\134\228\USF\192%\CAN0\199tL9\158\224#&\219&\244\144\SI\210X\SI\ACK\240\193^I\ETBH\236F\255\128\241M\208g*\205\145\RS4\209 \129\&1D\189a\ESCcZ\SOI1?\140p\USA\161\171\154\172\DC2\171!\ACK\DLE\176\194D1\159\243\NUL\b\160l\ENQ\ETBu\r\196:]>\244\129\137As;\153\&8\253S%$\193\RS\163\160\ETX\132\EM\EM:p\v7\DLEC\252$\200\191\\9f0\204\NUL\178\143m0\f\\j\amDV-\166\151\US\204Gz\DC3m\193\188\147\DC4rU\232t\DC4\161R\171\152\EOT\167\US\156<\255\DC3P\233:\206\&0\244\DC1\141\201:J\194\EM\210\SOH\DC3\vm\159\SI\198\188\179\187\CAN\b\DLE\174N1\150\222\131\EOT\135\160\n\142`\SOH\187\&5P]\245~r\EOTe\212\"1\142\252~O\231\ETB\RSM\208\ENQ\157\ENQ\r\ENQ3\187@\"\195\128\SOH\245\t\128\237\180\au\128\192\168\200\196(\226JJ\161\ENQ9P\b\ETB\139\132\t\ETBR\242SC\176\231RFsF\148`\t4\171\210#4\SO\137q\188A\147\146\255\ENQ\181|\v\205\a\SOHP\130\229U\a\SI\128\&9%\SYN#\n\STX\214\218\212\173]\145*O\a\ACK\170\160\195\226\SOH\214\191B\188(\147\149\255C:z1\162N\253\212W\176\t\193<\b\196l$\DEL\230\SO\237\DC4\SOH\188\208\STXu\144\173\233\CAN\SOH\RS\245a\175uY\150\181\FS\147C\t0\210\"\FSj)\250\ACK\148\155\DC2\n\153u\ENQ\255@\166u\173\SYNj\240\207\175\196\163\ENQu\GS\149\137Z\169\218(\172[\USB1\164\188\SOH\214;\ACK@\238\144\ETB\153<i\SOH6+\241bT\231w5\198'\217t\189\217L\160\fD0\168\&4\176\215|\192`\142\226(H+\SYN#\NUL\206\228\201\\\193\210\DLE` \SOH\179\193\RS}\229\163\162\149\&8\203\225X%\140Vh4c\FS\177\158\188M\ETX\135\240\219j FW\241nf\177]jR\218#\128\SYN\239b\ACK3\218W\175``\179\146\SYNj\229\154\194\156\ENQG`Y\187\253\221:\166\ACK\255y\221?\r\193\184\233\173u#\219usp'|a\216\149\181\158\226\FS\175s*`\139\195\ESCy\ENQ\130-\146\158y\202\223\&5\161-\SYNA\204\168\NAK\166\215\161\a\CAN0\SI]\221\r\187\242\ETB\187UT\a\243\ETX.BZ2v\225B\179\&4E\245\&0\177\160\191\230\193\133\CAN\RS|\128\183\225r\DLE\133DV\220*\ETB\NUL\206\200`\ETBM\170\EM\240x\171\247~\222\232\DLE\144=2\137\152\ETBJ\224)S\229a\"\250#z\185\RS\251}\227\200\128>\149\176D4P\168D\214`\142\194\STX\SOH \f\161\232\NAK\r \SOH\DC1\240L\164\&2Z^\186\nc\227\199\242\182f\180\195\r\179Fa'\195\198\238J3\EOT\168\205G\142\229\CAN\178P\a0\DC4j\194u\253\183\182\240\203\EM\139\165<\199\150\ETBP\167\136\218\214\ENQ\210\198\232\201A\231pP-\226G3\246\129?\b\144\NUL\205\225\231VB\NAK\139\146\NUL\129N\ETX\DEL\176\180\188\160,\255\210(\SOHt4\SO\NUL\151y\217\145\178\225\185m\181y\221\SO\240\158zw\SO1k\192r\173\EOT\DC1\144\221\188M\NAK~\234\no:\ETX\252\232*u\160Z\\g\146$\137\GS0\n\190\a\DC1M}\145z\SI\145\197\173\176}6\142\US\DC3\DC3\132\140gx\130\227\233\141\185@\144\&1\236\171\226AGb.\150i.[\GS\133\131\DLEp\DEL\195X.\218\r\251F1\137\242'\222\200\193v\182)\172\CAN*\197\&2\DC2\222\254DC\147\227F\178\SI\249(\f&h\138\128\128\SOHf;\ETXE\166\237\251\230LJA\SOv0\DC1\ACK9#\240\129O\183\148\194T\199?j\196\153\192\221\239H~l\225\222\229\159\f\189\208\v\195\"p\DC2WQ\SOH\DC1\DLE\NUL)\193\233\181\224\NUL#\184^\GS\v\136\f!\238\188\147\&2\194\164\241\226\128\RS\RS\239U\193~\SO\155.\SI\212\v\230\163L\SI%+\f\128\176>\222\DLE\192\193Iu\128+\ETX\185\244L\255\164\208GAx{\184\148\217\143#\137N!\EOT\SUB\223\243Hn\ACKFp\f\209\209\v\237\228\140\&0L\SOH\208[\ENQ\134\198\ACK\202\131\DC2+\180\142A\144\SOHc\243\179Y\SI\EM(\132Kd\ESCH)Q\r]\239\245\224\RS\ACKAo$%H\240\181y\135Q\217\STXa\213MV\149\ENQj\154\ETX\DC1 \NUL\247tJ\167;\b\ESCcz\vQ\199G(\158lT\196~_\tMsH\161 \202A\254\NUL$\169\SID\235\186o\250\EOT[\248\239|oh\209\240j\200`z\SYN\180\&1Z\STX!\170\DEL\237~\SO\242K\128\NUL\142\DLE \211J\a0\DC1\189\174\250\EM\189\145\147a\168\GS\135\200\t\130\146\SO\244\ACK\148Z\DC2\v\176/\v8\155\ESC\171D\217\222\SO;4\195\193\135\178\a.\241\NUL\181\169\STX\229\ENQ\141\147?C\r\130\r!\148\152Sq\SUB\141\132\209[(I[\t\r\CAN\187\154\157\SI\238\226\238\DC4\142`\135\">hm h\255\SUB\ETX\STX\n4\SOH\229R\SOHgY&\149\149\172\137\178\172L\229\178\153\181\242<\163(&\SYN\151m\215\&3eR\EMH\134\ACK`\188\142\210)\181j\189b\179\218\RS\236\153`t\165\bD\233`>\163\r\SO\199\195qh\191\129\nDEa\130\164P\188\132\197\t\CAN\150@@|\157\168$P\232\&00H%$)PT\180$\224\GS\241%\200,P\EOT\SOH\180ly~\130\134\138\166,\132Q-\216\SOH\160\173\RS\168A8P\CAN\168=\FS<)\244M\224-,\SOH\232y\149B\208X\204X\EOT\DEL\225\&5B\248\182@,\246\252\236,\236\&4\250r%Q\ETXPp&\141v{\DEL\DEL\154R%\212\170\178\158\169\157\173\&94<\164\138\228\149\&0@\230\220\EOT\SI\ETX\r\211\216\180\160\244\251D\146\STX\164\STX$JT\130\245\210\134\"\n\184\134\SO\US\154\144We\SOH\EMs\231\f\\8\ETX\161\r\ENQv\DC4\140p;\145\SOH\133\r\ESC<*\255H\ETX\226d\199\&5C\EM\180\157\244\195\131\STX\197\b\213\166\160\212\&4\SOH\ENQL\136>\DEL\130r\150@f\143\ENQ\229\206\153y\133\166\129:\ENQ\ETB\138\249\137Da*$g+\180\225\131\SUB0G\tn<\DLE\246\224v\193j\149&\143Px\ENQ\170v\237\148.\fJ\141;z\SO\STX\211\&3p\206\NULp\n\147\231\141\SUBz\134\254Y0\225V\159\DC4\214\NUL<H\ESCH&J\DEL#o\RS\153\145\225\229\f\182\150/\175(u\137l\209\138H\SIdl\149\SOM\t\ENQ\143\147$A\244\210\215H\CANS\229\b\154\162\173'\143\180\v\148\221\152\170X\n\ENQ\b4wc\SO\254\147\232\145\ENQp\145\214\ENQ\GS\154\244\157C\217\DC2\170\166\NUL\ACK\143\163\202\164 \ETXHRa\183\156\204'\230\165\182\226\136BE\225\230\DEL\138cD\227\\\242\209\171js\170\176\200\235\246\237\139\179\211V\209\ETX\166\244#\EMR\173p\rL\192\ENQXB\NUL\156\157\151\255\224\&7\v XT\EMK-w\128\ETX\DLE\156\195\131\&4\156\244\226_\CAN\248(\214IX\t\GSA\ESC\v\212\233A`^\143\136\168\160\138\163|Q\ENQ\CAN\139\160q\SOH\133\171D\136\215L\206\164\216\139\US;\164h\210I0d@\SYN*R\164\150\SOH\f[\DC1y\193\138KvC\\%\199Ix\129\SOH\172$\247\222I\206\200Gd\SI\131q\182[\DC2\SI\132q\219\DC4\f4\211_/\233\149\144#\147kb\SOH\131\147\&5\FS\176\136\ETXRN\185\n\EOTRV\248cWh\"\185'\ETBY\174 \USJ\ENQR!\232VFJ1(\155\139^\241\SYN\131h\198\128\NUL\fm\212hF\165\&6\ACK\186H\159z^\169\225\149Lt\SOHD\131g\222\224\EOTX\SYN\SUB\193\168\170\140\176\224\196[\b\SO\181H\SOH\180\224i\ACK;u\230\EM(\r\138\RS\193k\t\155\254\SUB\198\160\NAKL\224\196\160\np&\159\&2Q\201\&4\201\170\207\RS\SOH\134\ETB`\192\NAK\255-\131\136IH\203\156\r\204\248\EM\SI@\252\250\166\175\NUL\156\SUB\211\n\b\217c\199\160\213\ACK\202\a\175\SYN `\213\184\208>+m\139\163\130\SOH\ETX\EOT\179>p\SOH-\159\&1\ETB\238\137T\136\202\131\ENQ$\FSQ\216\185.\196\251\223\188\231\138 \147iv@\241&\189\171J;\SO\\l8P\NUL\192\172\CAN\172\174\197\228\202\EOT\SOH\128_!Ln\US\190\245\ACK\SOHCR83\140\193\f\SOr\177\205{\188\&8\ENQ\STX4l\244\239\199\SOH_\248\199\201=\140\176\135\ENQ\r\202\\\130\ENQ}X@\211\SYNI\255A\ACK\212\&7\223l1\ETX\146\"\230\241\207VJ\ETX\ETX\184\EOT\159<\245\183\NUL\222\146O\RS\169V\241\181\204?\fM5\180\EM\235L\131\207[\219xKih?3\181\221\SYNn\167\201\ne\139\160\192\rm\ETB5\140\DC1\224\154\236\182\219\144\150\176\&3\NUL\179\190\209\192\ENQ\237\252\204\tC{GF\DLE\218\152\167\240\STXg\bd\181\255\ETX\231\197\221\131G.B+N\245\ETB\144^=\169\228\ENQ\204x\215g\150\152\128\247\223\209\156\fz\f.Oq\155\&4\186\216\190\229\b\192\SI\150\250\197/*\210\162\DC4\DC4\169\210\173]n|&xf\216\233g!\NUL;\201\179\180HC\223\246O\245\189\a\163\135\152\198\211\187\186am]\r\192\SUB\ETBhm\ACKF\DC3\174\242\128\252\&3\200\&0\t\154\227\175\160\189\fvd\210G$\223\DEL\167/\223\171Dc\200\167\&8\CAN\152oy\NUL \131,\f ;\247]\192\SOH\rl\195\SUB\CAN\196\&4\236\&4\226\ENQz\NULB#\242B\ETX\ENQD\160\DC3>\218]J8a\GSFD\STX;\ACK\132\150\171\218\STX%\bB\207\f\148\154\211rH\SYN\190\NULm\135\ETB5\144\EOT\a\255\163\f\a\220\160/\209\178\SIW\198d$\NAK\174pU\132\&8E\139hx\129\201\197\208\NAKkPC]\152V\f>\244\130z\EOT\225\ETX\197T\178\DC3\205P\129\SOH\SI\240\255K\161Z`\162$\170\234\DC2\167H\133\SOH 0%\231%eB\233\160\128\132\128\NUL*\148(\163\131\217\168\202Bl'\130\&3\DC2\234\tj2I\ACK\198\136F\170]\139\DC1r\249X\EOTe(\191\188,-\n\136\154\135/r\148\SI\211\&0n&\223z\DC3$&sH\170\193\173(\139\220Z\ESC<f\130\DC3\f!G#4\SOHah\160&.\224\r8\246\t\192'\171\&6\142\ENQ>\232g\178\144\160\ETX\203f\f0\212\a\DC1\136\&0\228L\200\&6\178@^\ENQf\SI8P-m\ACK\131\ACK\173'\151\159ic\EOT_\209\DC1\194(c\b\145\CANUf\208\246\202\SI\129\211`\219\201d3\153\212\194J\NUL\198\"\159i\228+(\168\146R\CAN\137\156]\217d\SYN \179\ESC\n(\175\156\208\202\164\fV\192HK\173\195\fw+\215D\f\146\157,X2l\199\212\167\130\194\228\162r\168\&3F\146s\163\148bX\139a\DC4+\v\171\FS\DC2\SYN\255\NUL\NAK\150\152\149\135\161\139ZD\ETB\248\t \SUB5 9s\154\211*Fg\133U>\167\158\226\216\149\215\b'R&)O\DC1cZ`\ETBV\250D\\M\SO4\172p\135'R\132\168*D\"H\133\147\131\216n\170D\141\249\161\129\&3\218\214\182\224\CAN\anF\235e)\176i\166n \SO\233 `0\\u\234\154\242i\173\&0\168\227\167s\178*:\142v\133a\137\227a\ACK\131Dz\ACK\DC34\178\RSoT\t\192Z\t\250\197\134\STX\252\DC4`\CANY\168\178\128%W\165\241\129\160w\192\171\205B\EM\153\&0<\192\129\254bk\SUB\216\144I\211\144\233a\240\162\130\204\SO\203\216\155\&1\174u+XCd?\230F\248\DC1\140X\228R\172\229 \ENQ\174b\164\236\179\169\&3+\ETB\216%\v]\SYN\NUL~\DLE\237A\193\150F82\185VtM\149\237\205\FS\235\131X\249skl\b\216\244\222\&1\\2\189)h.%\174\234\158\DLE\255\&7\RS\NUL\172c\ACK\232\200\220\246\224\130P\r70\189;\\x\169K/\227\238\&0\164\159\153\NAKF\230v\NUL\147\DC1Fa\168\&4h\200z\a\143\223\153\215x:\133\EM\CAN\147;T\139\166\161\NUL\248\224\171\239\232\155\191\182A\SOH\190\130\211A~\141\&72\230}er\STX`\223\ESC\NUL\140\134\&6\DLE\240\174\188\GSZ>v\182\b\233\&5\216\193\227H\US\SI\NUL\235\175\ACKH \STX\146\131\158 &\136a\128\228\134\193<\208\GS)RrB\137\132x\182\209\197%\SI\"\216\NUL\232a\EOT\ETX*\150\FS\SOH\158\CAN\193\ah\STX\155.\216E\SO\140\240\157\EOT\228\130 7\206\177\SOHi@[\DC3\168\145\a\r\136\192\228\STX\192e7\CAN@r\179H\233\148\FS\224\203>\184i\EMz\160\228\v\140\DC3S*\175\144\159!\237\235\ETXRLQ\f\EOT\128\134l\200\&3\ENQ$ \208\198\&5\235%#9\201\217P\DC1[8\147/\157\207`\192n\US\180\175\NUL\255\228\EM\160\239}\226\ETX~\252gOT\128\DC2\229E\180\219\160\153e\236\" )a\134t\NULD\163\ACK\SOH\196\144\211p\142\238\156Y@\SO4P\b\STX\164\150Ri/\173\133K\184Y\213h\132\DC49\164\176\ACKFF@\NUL?\158\220TR\218\128F\217Ca\186N\244N\ESC]\STXv\144\154\212)}\175T\GS \SOH\t4\NUL\DC1.P\128\EOT~u\131A\ETB(_\193[vu\139\163h\236\246,\178\212\188@\180U<\171\142\DLEdN\CAN\216\129G\SI\SUB\168 \146\187\202m\137\151\DC4\232&\161`_\251\STX\218\254\203\183\233\145\239f\178\206\217\210\244\183\194\&9\129\213\131\235{y\173^\184\191!.\219\156q\225\220\216e8\166,\238T7\241\ETBR\FS\239\184\199E\154<\206\192\128\175G\CAN\185\173Knr\226\&8jT,o\184\203k\249\233\SUB\176k\229,\175\249\199\&9C-\139\205\156\231\f\GS\nm\243\197\184\160\v\189\255\150p\v\165\163\170\128\244\164\215\178ZV\201\215\196\253\203q\168\151\211\184Dw\250\206\177\142\240gh\\\231#\247z\212\139Cb*<\157\236q\142\214^\175\144v\181\147\143\&80\160\185\213\EM\SO\247\NAK:\233\vU\223\248\216\239n\192\153.\240\225\DC1\173\184\223SW\n\162\232\GS\vo/\252\197Jj=~\187\189\235\140\175Zz\188\150\133\197O\254\169\&0k\187\226%\159yz\209@&\US\212\STX\230??\210\202\243\184\243}7=\198X\149s+\148\158\245Kj\145)\230.\248\186\DC3^\246\140\202\251\217U\DELu\221\167\145,z\191=\238\233\ACK\252\145:\220\aW#>\197\141\DEL|&\145\148,\139\200\&5\233=\255\252\134\250<\229\242\236A\236\175\US\FS\179~\225-\159\232\190\247\&1\147Ojm\159\251\214/\255y\224\150r\230\ETB\DELk\236_Q\CAN\146\183w\174\175~\254\230\201'\STX\ETB\218\239\245\235\US[8\255\131\171$\RS(\144_\NUL>\EOT\STXY\ENQ\STX\221\US\254\253\RS\STXZ\ACK\181X\200\SI\136\194\SOHB`C\176\139\DC34\160\ETX\218\221\ENQ\178\133\&8\204\221(X\160\a\142\194~ED\234\EM \NUL\146`C\NUL\RS\221\249^\a\174 D\128`\227t\195\b\198\224\SYN\152 \134\168\130\&7\216\224\rb\129cY\153\255\193\158\n\250`PpAi|C\SI\SYN\225)\DC4\a'\b\225\DLE\230\223\DC2\134\194\f\230\ENQ8(\161\DC4\RS\161\242\241\148\NAK\DC2!\SYNZ\129\DC3\132\193\&3m`\245E\161\ETBf\129[\200\195\251\&5\196\NAK\154a\SO2 \252A\225\ETX\154\225\EM\130]\n\164\223\229u\225\FSf\225\RS\144\194C\176\225\DC2\210\214f\188\RS\SI\230\161\RS>\SOH\130L\223\DC3\146\161\FS\182\225\230\193\n'\140\225\248\NAK\"\tJ\139P,\STXz\181\200 &\225$\146\160\SUB\233\148\EOT\178\157\DC3\254\196\US\150\159\251\&9\RS\171p\158O\144\226\245\209\255\158u\129\FS\204$\"P\172\226\241\149\148\180\CANG\"U\194\DC3Db(\204\162\236\217\139q\184I\ETB\f\162-\222a\n\150!%\246\159\133\220\220\DC1\166\226(rb)>\DC3\204i\226>@\158,>#+\190\197\DC2\233\224\t:\200\SYN\174E/f\RSI)\SI`h\"\v\244![\128c\230\SOH\ACK\SUB~\161.^F:\134\163\248\181I\EM`\ACK<\SYN^\244m\159\DC3\224\":^\227\243\181\226\NAK\bc1\DC2\226\&1\178_\CANN\vz\197\192\223\b\135=b\221>\FS\162\149\165\NUL7\161\149y0$\212\ENQ$\174e#\DC3\"!E\246\227\231\157\162\ETB\132Vf\b$\ETB\DC2\228\243\201\163<\194E\SO\226\140(\158GE\214\\\255\GS^\SUB\"\228~U\227Bvd\225\&9d\SUB:\\\216%\159\&7\182\228M\SYN\RS\248\EM\GS\"\SO\160\"B\132K\146\GS\198\229\"K*\bRb\GS\237=\226\DC3\148c=\STX\229\231%\255\207>z\129<\212d\130\&8\229S\194\140<`%WV\165\223]\226fD\165\GS\174IWZ\FS\\TK\229\r\224HZcI\250\162\STX^\153\&9\158\210\162\168%\196\ENQ\227\152\b\133Q\242\163\\\234\RSB\246$\132\225\229X\170]h\149TX.I^B\FS\239\181\202\179\&0&\185A$\ETB8\195\171@\166az\165\220\213\192.\254$`\170#\245Y\SIX\194\161Mz&\227\129\225R:!\\\ACKGdr\154\147\248A\239A\vk\194\EM\154\212\USg\170\136l\230\216\149\213\166\219\224f\131\193\138\US\DLE\230\205\244&uM\223\RS\158#ob\166\197\145\148qNel&\231\193\217\162\SYN\222\165\241\f\167SUbz\192\141\227\144Ou\222\212\234\136\131R\170\FSu>\167\174\NAK]m\170fZ\142\167\170\129\160UP\196h2\nw\150\211\189\FSWej'\SUB\193\167\210M\159)L]s*\206}~RN\197\255\128P\132\167}\166'q%\146c-\157m\218\140\DEL\166\206'\"\215|\154\128\130.h\129~V\237\173d\171\184\231\197\&0\168\225\161\207\n\212\167>m\232\226\&8\162\135\158\231\132\150\230\178\229\157<\\\141_\246'\133\146\NAKv\134\193\206\176h\139\158(\149]\194P \158[\240g-\133\168\170\\\162u5a\171\148(\141\&2\226'e(3\186f\152\f(Y\245\232\&7\252h\t>\233\RS\212\223\142\234\DC3e\221V\SUB\180\145\v\SUB\143wf(B\138\222\SOH\f\233v\226\138\251\212\t\174\148\169\150v\SUB\v\156\220\173YY\131(\SUB0\134X+\160\195\ESC5\144\f\161\ETX\154\&6\150'\250A]\154]O\250\128\232\241\164l\189\ETB\133\152i\150N\201\ESCQ\219\DELb\153\133\&6\nm\158_\160\DC2\151\251\200\233\164\210\194\161\138\134\EM(\166q\170\ENQ\252U&>V\226d\170\a_\238\SOHh\198\169\251\DLE\234\140\208i+t\255\203\&6\182\ENQ\171\STX\ENQ\159\230\"\CAN\230\140\&8V\226q\149c\190D\202\140\&2\212\156\138\ACK\FSY\234\159\&1\136JF\132<\STX\ENQ\168\226\CAN\171\212@\DC3>\168\171\130]N\237L\152\&6\DC3+d\169\157D\214\140\196\192f\252\169(\158\230Ky\STX\242<\DC3\134\208&7Yb\182\142\137)P\EOT\180\150\DC3\221\164\170\179\213\159\&9\"\DLE\184\186\b\179\150\171\171\173\233\149-g[X(b\214f\166R\EM\195\225\n\171d$\237\185\EM\172\170\233<\226\\\150\173\142\220\233\NAKH\RS\162e>\131L\188\197V\234\SUB\230a\171\248\225h\193~\195?\202\231\RS:,'|\154\212-#\206\NAK\ENQ\169\146[\233\193\ENQ\255E\159\&7\172i\179\neb\SUBGY\190\b\191J\165\173\134l\201\DC2\225>\174\169`2Q\248}k \n\171\189(O)\164\236\214\153\155\144P\132\174RW\SI\226\234!~e(\166a\CAN\214\158\t\182\162\195\174\255\206\139d\210\235\237\NAK\149\170\154\DC2b\\\173V\237\249\249)r=S\242\236$\209)\194\181\216\v\134NK\239\b\USEHl\201]a\198\CAN\221\181\200\234fT\236r^\167\221f\229\214=\147\221Z-\250\208\214\209\RSi\191v!\193\SYN\197\141\RS\171\148\162\211\163\232$\222\246-Z\226k\SO\SUB\199\146&\157\ENQn\159[\NUL(\206\DC1\229\216F\EOT[\134\137\208\178\157J\RS-\186\DC2n\141\226`4j*\189\230K\218R\203[:b\237\GS\237\228\201&[\222\226!\154\143\197\130\145`\174\238\181\214n\230\&1\230\214\157&\226\218\225:\230d\185\230\220\207!\173\197\&1f\232\221\\\253\245-\177\246\206\205\229\203\203\234\222\242\n\227-6\203\168\&2\DC1\216\221\"\233B\\^\154\171\SO\186\202B\DC1\173w\156\171\247*\175\139\250\128(\nc\f\244\151z\164G\247\162/\220\170\175\249bY\DLE6\nQ\FS\RS\152\206o\205\185\255\164R\182\239\SI*\229V],\EOT\186$\174}\194\201\133a\236\174\224\255\194\161\209\165\ETB\201^\160\DEL\n\175\195\201h\255\222\GSw\130\162T\202/\SYN\246f\211\225\220\203\SUB\174\a\178\230\210\130\229\249\SUB\226\224\&9\USPL/\ETB(\NUL\255\166p\252U\142O\172l\171\132Z\242N0\133\254-\206yX\fO\129=\SO\240^\205\129\204\198p:\154%\174\141\129\214\SYN1Pf\163f\\e\247\SO\174\ETB\218\160f\244\151\"\128\193\179b\240\rb\158\213\222\168\207Mn\DC2G\241\DC2s\FS%X\177\220\130%\209\EM\199\SOHH\202\b\251\&0\RS\250[\ESC\EM\192\141*\160f\f\133\140\STXc\SYN\167\176`5\208\RS\v\148\NAKO.\246\226p\ESC+\222\RS\DC3\242\\\184Q\GS\159o\CAN\v\242\SYN\196ZR\136Zd\201O$\ETB\192$K\138\176.\178e8\144\ETX\205\202$\171\ESC\FS\187\145\EM\140\193%\171\200\225U\173(\155\242)\163\EOT\178'\132\NUL\NUL;"),("s5/default/framing.css","/* The following styles size, place, and layer the slide components.\n   Edit these if you want to change the overall slide layout.\n   The commented lines can be uncommented (and modified, if necessary) \n    to help you with the rearrangement process. */\n\n/* target = 1024x768 */\n\ndiv#header, div#footer, .slide {width: 100%; top: 0; left: 0;}\ndiv#header {top: 0; height: 3em; z-index: 1;}\ndiv#footer {top: auto; bottom: 0; height: 2.5em; z-index: 5;}\n.slide {top: 0; width: 92%; padding: 3.5em 4% 4%; z-index: 2;  list-style: none;}\ndiv#controls {left: 50%; bottom: 0; width: 50%; z-index: 100;}\ndiv#controls form {position: absolute; bottom: 0; right: 0; width: 100%;\n  margin: 0;}\n#currentSlide {position: absolute; width: 10%; left: 45%; bottom: 1em; z-index: 10;}\nhtml>body #currentSlide {position: fixed;}\n\n/*\ndiv#header {background: #FCC;}\ndiv#footer {background: #CCF;}\ndiv#controls {background: #BBD;}\ndiv#currentSlide {background: #FFC;}\n*/\n"),("s5/default/iepngfix.htc","<public:component>\r\n<public:attach event=\"onpropertychange\" onevent=\"doFix()\" />\r\n\r\n<script>\r\n\r\n// IE5.5+ PNG Alpha Fix v1.0 by Angus Turnbull http://www.twinhelix.com\r\n// Free usage permitted as long as this notice remains intact.\r\n\r\n// This must be a path to a blank image. That's all the configuration you need here.\r\nvar blankImg = 'ui/default/blank.gif';\r\n\r\nvar f = 'DXImageTransform.Microsoft.AlphaImageLoader';\r\n\r\nfunction filt(s, m) {\r\n if (filters[f]) {\r\n  filters[f].enabled = s ? true : false;\r\n  if (s) with (filters[f]) { src = s; sizingMethod = m }\r\n } else if (s) style.filter = 'progid:'+f+'(src=\"'+s+'\",sizingMethod=\"'+m+'\")';\r\n}\r\n\r\nfunction doFix() {\r\n if ((parseFloat(navigator.userAgent.match(/MSIE (\\S+)/)[1]) < 5.5) ||\r\n  (event && !/(background|src)/.test(event.propertyName))) return;\r\n\r\n if (tagName == 'IMG') {\r\n  if ((/\\.png$/i).test(src)) {\r\n   filt(src, 'image');  // was 'scale'\r\n   src = blankImg;\r\n  } else if (src.indexOf(blankImg) < 0) filt();\r\n } else if (style.backgroundImage) {\r\n  if (style.backgroundImage.match(/^url[(\"']+(.*\\.png)[)\"']+$/i)) {\r\n   var s = RegExp.$1;\r\n   style.backgroundImage = '';\r\n   filt(s, 'crop');\r\n  } else filt();\r\n }\r\n}\r\n\r\ndoFix();\r\n\r\n</script>\r\n</public:component>"),("s5/default/opera.css","/* DO NOT CHANGE THESE unless you really want to break Opera Show */\n.slide {\n\tvisibility: visible !important;\n\tposition: static !important;\n\tpage-break-before: always;\n}\n#slide0 {page-break-before: avoid;}\n"),("s5/default/outline.css","/* don't change this unless you want the layout stuff to show up in the outline view! */\n\n.layout div, #footer *, #controlForm * {display: none;}\n#footer, #controls, #controlForm, #navLinks, #toggle {\n  display: block; visibility: visible; margin: 0; padding: 0;}\n#toggle {float: right; padding: 0.5em;}\nhtml>body #toggle {position: fixed; top: 0; right: 0;}\n\n/* making the outline look pretty-ish */\n\n#slide0 h1, #slide0 h2, #slide0 h3, #slide0 h4 {border: none; margin: 0;}\n#slide0 h1 {padding-top: 1.5em;}\n.slide h1 {margin: 1.5em 0 0; padding-top: 0.25em;\n  border-top: 1px solid #888; border-bottom: 1px solid #AAA;}\n#toggle {border: 1px solid; border-width: 0 0 1px 1px; background: #FFF;}\n"),("s5/default/pretty.css","/* Following are the presentation styles -- edit away! */\n\nbody {background: #FFF url(bodybg.gif) -16px 0 no-repeat; color: #000; font-size: 2em;}\n:link, :visited {text-decoration: none; color: #00C;}\n#controls :active {color: #88A !important;}\n#controls :focus {outline: 1px dotted #227;}\nh1, h2, h3, h4 {font-size: 100%; margin: 0; padding: 0; font-weight: inherit;}\nul, pre {margin: 0; line-height: 1em;}\nhtml, body {margin: 0; padding: 0;}\n\nblockquote, q {font-style: italic;}\nblockquote {padding: 0 2em 0.5em; margin: 0 1.5em 0.5em; text-align: center; font-size: 1em;}\nblockquote p {margin: 0;}\nblockquote i {font-style: normal;}\nblockquote b {display: block; margin-top: 0.5em; font-weight: normal; font-size: smaller; font-style: normal;}\nblockquote b i {font-style: italic;}\n\nkbd {font-weight: bold; font-size: 1em;}\nsup {font-size: smaller; line-height: 1px;}\n\n.slide code {padding: 2px 0.25em; font-weight: bold; color: #533;}\n.slide code.bad, code del {color: red;}\n.slide code.old {color: silver;}\n.slide pre {padding: 0; margin: 0.25em 0 0.5em 0.5em; color: #533; font-size: 90%;}\n.slide pre code {display: block;}\n.slide ul {margin-left: 5%; margin-right: 7%; list-style: disc;}\n.slide li {margin-top: 0.75em; margin-right: 0;}\n.slide ul ul {line-height: 1;}\n.slide ul ul li {margin: .2em; font-size: 85%; list-style: square;}\n.slide img.leader {display: block; margin: 0 auto;}\n\ndiv#header, div#footer {background: #005; color: #AAB;\n  font-family: Verdana, Helvetica, sans-serif;}\ndiv#header {background: #005 url(bodybg.gif) -16px 0 no-repeat;\n  line-height: 1px;}\ndiv#footer {font-size: 0.5em; font-weight: bold; padding: 1em 0;}\n#footer h1, #footer h2 {display: block; padding: 0 1em;}\n#footer h2 {font-style: italic;}\n\ndiv.long {font-size: 0.75em;}\n.slide h1 {position: absolute; top: 0.7em; left: 87px; z-index: 1;\n  margin: 0; padding: 0.3em 0 0 50px; white-space: nowrap;\n  font: bold 150%/1em Helvetica, sans-serif; text-transform: capitalize;\n  color: #DDE; background: #005;}\n.slide h3 {font-size: 130%;}\nh1 abbr {font-variant: small-caps;}\n\ndiv#controls {position: absolute; left: 50%; bottom: 0;\n  width: 50%;\n  text-align: right; font: bold 0.9em Verdana, Helvetica, sans-serif;}\nhtml>body div#controls {position: fixed; padding: 0 0 1em 0;\n  top: auto;}\ndiv#controls form {position: absolute; bottom: 0; right: 0; width: 100%;\n  margin: 0; padding: 0;}\n#controls #navLinks a {padding: 0; margin: 0 0.5em; \n  background: #005; border: none; color: #779; \n  cursor: pointer;}\n#controls #navList {height: 1em;}\n#controls #navList #jumplist {position: absolute; bottom: 0; right: 0; background: #DDD; color: #227;}\n\n#currentSlide {text-align: center; font-size: 0.5em; color: #449;}\n\n#slide0 {padding-top: 3.5em; font-size: 90%;}\n#slide0 h1 {position: static; margin: 1em 0 0; padding: 0;\n   font: bold 2em Helvetica, sans-serif; white-space: normal;\n   color: #000; background: transparent;}\n#slide0 h2 {font: bold italic 1em Helvetica, sans-serif; margin: 0.25em;}\n#slide0 h3 {margin-top: 1.5em; font-size: 1.5em;}\n#slide0 h4 {margin-top: 0; font-size: 1em;}\n\nul.urls {list-style: none; display: inline; margin: 0;}\n.urls li {display: inline; margin: 0;}\n.note {display: none;}\n.external {border-bottom: 1px dotted gray;}\nhtml>body .external {border-bottom: none;}\n.external:after {content: \" \\274F\"; font-size: smaller; color: #77B;}\n\n.incremental, .incremental *, .incremental *:after {color: #DDE; visibility: visible;}\nimg.incremental {visibility: hidden;}\n.slide .current {color: #B02;}\n\n\n/* diagnostics\n\nli:after {content: \" [\" attr(class) \"]\"; color: #F88;}\n*/\n"),("s5/default/print.css","/* The following rule is necessary to have all slides appear in print! DO NOT REMOVE IT! */\n.slide, ul {page-break-inside: avoid; visibility: visible !important;}\nh1 {page-break-after: avoid;}\n\nbody {font-size: 12pt; background: white;}\n* {color: black;}\n\n#slide0 h1 {font-size: 200%; border: none; margin: 0.5em 0 0.25em;}\n#slide0 h3 {margin: 0; padding: 0;}\n#slide0 h4 {margin: 0 0 0.5em; padding: 0;}\n#slide0 {margin-bottom: 3em;}\n\nh1 {border-top: 2pt solid gray; border-bottom: 1px dotted silver;}\n.extra {background: transparent !important;}\ndiv.extra, pre.extra, .example {font-size: 10pt; color: #333;}\nul.extra a {font-weight: bold;}\np.example {display: none;}\n\n#header {display: none;}\n#footer h1 {margin: 0; border-bottom: 1px solid; color: gray; font-style: italic;}\n#footer h2, #controls {display: none;}\n\n/* The following rule keeps the layout stuff out of print.  Remove at your own risk! */\n.layout, .layout * {display: none !important;}\n"),("s5/default/s5-core.css","/* Do not edit or override these styles! The system will likely break if you do. */\n\ndiv#header, div#footer, div#controls, .slide {position: absolute;}\nhtml>body div#header, html>body div#footer, \n  html>body div#controls, html>body .slide {position: fixed;}\n.handout {display: none;}\n.layout {display: block;}\n.slide, .hideme, .incremental {visibility: hidden;}\n#slide0 {visibility: visible;}\n"),("s5/default/slides.css","@import url(s5-core.css); /* required to make the slide show run at all */\n@import url(framing.css); /* sets basic placement and size of slide components */\n@import url(pretty.css);  /* stuff that makes the slides look better than blah */"),("s5/default/slides.js","// S5 v1.1 slides.js -- released into the Public Domain\n//\n// Please see http://www.meyerweb.com/eric/tools/s5/credits.html for information \n// about all the wonderful and talented contributors to this code!\n\nvar undef;\nvar slideCSS = '';\nvar snum = 0;\nvar smax = 1;\nvar incpos = 0;\nvar number = undef;\nvar s5mode = true;\nvar defaultView = 'slideshow';\nvar controlVis = 'visible';\n\nvar isIE = navigator.appName == 'Microsoft Internet Explorer' && navigator.userAgent.indexOf('Opera') < 1 ? 1 : 0;\nvar isOp = navigator.userAgent.indexOf('Opera') > -1 ? 1 : 0;\nvar isGe = navigator.userAgent.indexOf('Gecko') > -1 && navigator.userAgent.indexOf('Safari') < 1 ? 1 : 0;\n\nfunction hasClass(object, className) {\n\tif (!object.className) return false;\n\treturn (object.className.search('(^|\\\\s)' + className + '(\\\\s|$)') != -1);\n}\n\nfunction hasValue(object, value) {\n\tif (!object) return false;\n\treturn (object.search('(^|\\\\s)' + value + '(\\\\s|$)') != -1);\n}\n\nfunction removeClass(object,className) {\n\tif (!object) return;\n\tobject.className = object.className.replace(new RegExp('(^|\\\\s)'+className+'(\\\\s|$)'), RegExp.$1+RegExp.$2);\n}\n\nfunction addClass(object,className) {\n\tif (!object || hasClass(object, className)) return;\n\tif (object.className) {\n\t\tobject.className += ' '+className;\n\t} else {\n\t\tobject.className = className;\n\t}\n}\n\nfunction GetElementsWithClassName(elementName,className) {\n\tvar allElements = document.getElementsByTagName(elementName);\n\tvar elemColl = new Array();\n\tfor (var i = 0; i< allElements.length; i++) {\n\t\tif (hasClass(allElements[i], className)) {\n\t\t\telemColl[elemColl.length] = allElements[i];\n\t\t}\n\t}\n\treturn elemColl;\n}\n\nfunction isParentOrSelf(element, id) {\n\tif (element == null || element.nodeName=='BODY') return false;\n\telse if (element.id == id) return true;\n\telse return isParentOrSelf(element.parentNode, id);\n}\n\nfunction nodeValue(node) {\n\tvar result = \"\";\n\tif (node.nodeType == 1) {\n\t\tvar children = node.childNodes;\n\t\tfor (var i = 0; i < children.length; ++i) {\n\t\t\tresult += nodeValue(children[i]);\n\t\t}\t\t\n\t}\n\telse if (node.nodeType == 3) {\n\t\tresult = node.nodeValue;\n\t}\n\treturn(result);\n}\n\nfunction slideLabel() {\n\tvar slideColl = GetElementsWithClassName('*','slide');\n\tvar list = document.getElementById('jumplist');\n\tsmax = slideColl.length;\n\tfor (var n = 0; n < smax; n++) {\n\t\tvar obj = slideColl[n];\n\n\t\tvar did = 'slide' + n.toString();\n\t\tobj.setAttribute('id',did);\n\t\tif (isOp) continue;\n\n\t\tvar otext = '';\n\t\tvar menu = obj.firstChild;\n\t\tif (!menu) continue; // to cope with empty slides\n\t\twhile (menu && menu.nodeType == 3) {\n\t\t\tmenu = menu.nextSibling;\n\t\t}\n\t \tif (!menu) continue; // to cope with slides with only text nodes\n\n\t\tvar menunodes = menu.childNodes;\n\t\tfor (var o = 0; o < menunodes.length; o++) {\n\t\t\totext += nodeValue(menunodes[o]);\n\t\t}\n\t\tlist.options[list.length] = new Option(n + ' : '  + otext, n);\n\t}\n}\n\nfunction currentSlide() {\n\tvar cs;\n\tif (document.getElementById) {\n\t\tcs = document.getElementById('currentSlide');\n\t} else {\n\t\tcs = document.currentSlide;\n\t}\n\tcs.innerHTML = '<span id=\"csHere\">' + snum + '<\\/span> ' + \n\t\t'<span id=\"csSep\">\\/<\\/span> ' + \n\t\t'<span id=\"csTotal\">' + (smax-1) + '<\\/span>';\n\tif (snum == 0) {\n\t\tcs.style.visibility = 'hidden';\n\t} else {\n\t\tcs.style.visibility = 'visible';\n\t}\n}\n\nfunction go(step) {\n\tif (document.getElementById('slideProj').disabled || step == 0) return;\n\tvar jl = document.getElementById('jumplist');\n\tvar cid = 'slide' + snum;\n\tvar ce = document.getElementById(cid);\n\tif (incrementals[snum].length > 0) {\n\t\tfor (var i = 0; i < incrementals[snum].length; i++) {\n\t\t\tremoveClass(incrementals[snum][i], 'current');\n\t\t\tremoveClass(incrementals[snum][i], 'incremental');\n\t\t}\n\t}\n\tif (step != 'j') {\n\t\tsnum += step;\n\t\tlmax = smax - 1;\n\t\tif (snum > lmax) snum = lmax;\n\t\tif (snum < 0) snum = 0;\n\t} else\n\t\tsnum = parseInt(jl.value);\n\tvar nid = 'slide' + snum;\n\tvar ne = document.getElementById(nid);\n\tif (!ne) {\n\t\tne = document.getElementById('slide0');\n\t\tsnum = 0;\n\t}\n\tif (step < 0) {incpos = incrementals[snum].length} else {incpos = 0;}\n\tif (incrementals[snum].length > 0 && incpos == 0) {\n\t\tfor (var i = 0; i < incrementals[snum].length; i++) {\n\t\t\tif (hasClass(incrementals[snum][i], 'current'))\n\t\t\t\tincpos = i + 1;\n\t\t\telse\n\t\t\t\taddClass(incrementals[snum][i], 'incremental');\n\t\t}\n\t}\n\tif (incrementals[snum].length > 0 && incpos > 0)\n\t\taddClass(incrementals[snum][incpos - 1], 'current');\n\tce.style.visibility = 'hidden';\n\tne.style.visibility = 'visible';\n\tjl.selectedIndex = snum;\n\tcurrentSlide();\n\tnumber = 0;\n}\n\nfunction goTo(target) {\n\tif (target >= smax || target == snum) return;\n\tgo(target - snum);\n}\n\nfunction subgo(step) {\n\tif (step > 0) {\n\t\tremoveClass(incrementals[snum][incpos - 1],'current');\n\t\tremoveClass(incrementals[snum][incpos], 'incremental');\n\t\taddClass(incrementals[snum][incpos],'current');\n\t\tincpos++;\n\t} else {\n\t\tincpos--;\n\t\tremoveClass(incrementals[snum][incpos],'current');\n\t\taddClass(incrementals[snum][incpos], 'incremental');\n\t\taddClass(incrementals[snum][incpos - 1],'current');\n\t}\n}\n\nfunction toggle() {\n\tvar slideColl = GetElementsWithClassName('*','slide');\n\tvar slides = document.getElementById('slideProj');\n\tvar outline = document.getElementById('outlineStyle');\n\tif (!slides.disabled) {\n\t\tslides.disabled = true;\n\t\toutline.disabled = false;\n\t\ts5mode = false;\n\t\tfontSize('1em');\n\t\tfor (var n = 0; n < smax; n++) {\n\t\t\tvar slide = slideColl[n];\n\t\t\tslide.style.visibility = 'visible';\n\t\t}\n\t} else {\n\t\tslides.disabled = false;\n\t\toutline.disabled = true;\n\t\ts5mode = true;\n\t\tfontScale();\n\t\tfor (var n = 0; n < smax; n++) {\n\t\t\tvar slide = slideColl[n];\n\t\t\tslide.style.visibility = 'hidden';\n\t\t}\n\t\tslideColl[snum].style.visibility = 'visible';\n\t}\n}\n\nfunction showHide(action) {\n\tvar obj = GetElementsWithClassName('*','hideme')[0];\n\tswitch (action) {\n\tcase 's': obj.style.visibility = 'visible'; break;\n\tcase 'h': obj.style.visibility = 'hidden'; break;\n\tcase 'k':\n\t\tif (obj.style.visibility != 'visible') {\n\t\t\tobj.style.visibility = 'visible';\n\t\t} else {\n\t\t\tobj.style.visibility = 'hidden';\n\t\t}\n\tbreak;\n\t}\n}\n\n// 'keys' code adapted from MozPoint (http://mozpoint.mozdev.org/)\nfunction keys(key) {\n\tif (!key) {\n\t\tkey = event;\n\t\tkey.which = key.keyCode;\n\t}\n\tif (key.which == 84) {\n\t\ttoggle();\n\t\treturn;\n\t}\n\tif (s5mode) {\n\t\tswitch (key.which) {\n\t\t\tcase 10: // return\n\t\t\tcase 13: // enter\n\t\t\t\tif (window.event && isParentOrSelf(window.event.srcElement, 'controls')) return;\n\t\t\t\tif (key.target && isParentOrSelf(key.target, 'controls')) return;\n\t\t\t\tif(number != undef) {\n\t\t\t\t\tgoTo(number);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\tcase 32: // spacebar\n\t\t\tcase 34: // page down\n\t\t\tcase 39: // rightkey\n\t\t\tcase 40: // downkey\n\t\t\t\tif(number != undef) {\n\t\t\t\t\tgo(number);\n\t\t\t\t} else if (!incrementals[snum] || incpos >= incrementals[snum].length) {\n\t\t\t\t\tgo(1);\n\t\t\t\t} else {\n\t\t\t\t\tsubgo(1);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase 33: // page up\n\t\t\tcase 37: // leftkey\n\t\t\tcase 38: // upkey\n\t\t\t\tif(number != undef) {\n\t\t\t\t\tgo(-1 * number);\n\t\t\t\t} else if (!incrementals[snum] || incpos <= 0) {\n\t\t\t\t\tgo(-1);\n\t\t\t\t} else {\n\t\t\t\t\tsubgo(-1);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase 36: // home\n\t\t\t\tgoTo(0);\n\t\t\t\tbreak;\n\t\t\tcase 35: // end\n\t\t\t\tgoTo(smax-1);\n\t\t\t\tbreak;\n\t\t\tcase 67: // c\n\t\t\t\tshowHide('k');\n\t\t\t\tbreak;\n\t\t}\n\t\tif (key.which < 48 || key.which > 57) {\n\t\t\tnumber = undef;\n\t\t} else {\n\t\t\tif (window.event && isParentOrSelf(window.event.srcElement, 'controls')) return;\n\t\t\tif (key.target && isParentOrSelf(key.target, 'controls')) return;\n\t\t\tnumber = (((number != undef) ? number : 0) * 10) + (key.which - 48);\n\t\t}\n\t}\n\treturn false;\n}\n\nfunction clicker(e) {\n\tnumber = undef;\n\tvar target;\n\tif (window.event) {\n\t\ttarget = window.event.srcElement;\n\t\te = window.event;\n\t} else target = e.target;\n\tif (target.getAttribute('href') != null || hasValue(target.rel, 'external') || isParentOrSelf(target, 'controls') || isParentOrSelf(target,'embed') || isParentOrSelf(target,'object')) return true;\n\tif (!e.which || e.which == 1) {\n\t\tif (!incrementals[snum] || incpos >= incrementals[snum].length) {\n\t\t\tgo(1);\n\t\t} else {\n\t\t\tsubgo(1);\n\t\t}\n\t}\n}\n\nfunction findSlide(hash) {\n\tvar target = null;\n\tvar slides = GetElementsWithClassName('*','slide');\n\tfor (var i = 0; i < slides.length; i++) {\n\t\tvar targetSlide = slides[i];\n\t\tif ( (targetSlide.name && targetSlide.name == hash)\n\t\t || (targetSlide.id && targetSlide.id == hash) ) {\n\t\t\ttarget = targetSlide;\n\t\t\tbreak;\n\t\t}\n\t}\n\twhile(target != null && target.nodeName != 'BODY') {\n\t\tif (hasClass(target, 'slide')) {\n\t\t\treturn parseInt(target.id.slice(5));\n\t\t}\n\t\ttarget = target.parentNode;\n\t}\n\treturn null;\n}\n\nfunction slideJump() {\n\tif (window.location.hash == null) return;\n\tvar sregex = /^#slide(\\d+)$/;\n\tvar matches = sregex.exec(window.location.hash);\n\tvar dest = null;\n\tif (matches != null) {\n\t\tdest = parseInt(matches[1]);\n\t} else {\n\t\tdest = findSlide(window.location.hash.slice(1));\n\t}\n\tif (dest != null)\n\t\tgo(dest - snum);\n}\n\nfunction fixLinks() {\n\tvar thisUri = window.location.href;\n\tthisUri = thisUri.slice(0, thisUri.length - window.location.hash.length);\n\tvar aelements = document.getElementsByTagName('A');\n\tfor (var i = 0; i < aelements.length; i++) {\n\t\tvar a = aelements[i].href;\n\t\tvar slideID = a.match('\\#slide[0-9]{1,2}');\n\t\tif ((slideID) && (slideID[0].slice(0,1) == '#')) {\n\t\t\tvar dest = findSlide(slideID[0].slice(1));\n\t\t\tif (dest != null) {\n\t\t\t\tif (aelements[i].addEventListener) {\n\t\t\t\t\taelements[i].addEventListener(\"click\", new Function(\"e\",\n\t\t\t\t\t\t\"if (document.getElementById('slideProj').disabled) return;\" +\n\t\t\t\t\t\t\"go(\"+dest+\" - snum); \" +\n\t\t\t\t\t\t\"if (e.preventDefault) e.preventDefault();\"), true);\n\t\t\t\t} else if (aelements[i].attachEvent) {\n\t\t\t\t\taelements[i].attachEvent(\"onclick\", new Function(\"\",\n\t\t\t\t\t\t\"if (document.getElementById('slideProj').disabled) return;\" +\n\t\t\t\t\t\t\"go(\"+dest+\" - snum); \" +\n\t\t\t\t\t\t\"event.returnValue = false;\"));\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction externalLinks() {\n\tif (!document.getElementsByTagName) return;\n\tvar anchors = document.getElementsByTagName('a');\n\tfor (var i=0; i<anchors.length; i++) {\n\t\tvar anchor = anchors[i];\n\t\tif (anchor.getAttribute('href') && hasValue(anchor.rel, 'external')) {\n\t\t\tanchor.target = '_blank';\n\t\t\taddClass(anchor,'external');\n\t\t}\n\t}\n}\n\nfunction createControls() {\n\tvar controlsDiv = document.getElementById(\"controls\");\n\tif (!controlsDiv) return;\n\tvar hider = ' onmouseover=\"showHide(\\'s\\');\" onmouseout=\"showHide(\\'h\\');\"';\n\tvar hideDiv, hideList = '';\n\tif (controlVis == 'hidden') {\n\t\thideDiv = hider;\n\t} else {\n\t\thideList = hider;\n\t}\n\tcontrolsDiv.innerHTML = '<form action=\"#\" id=\"controlForm\"' + hideDiv + '>' +\n\t'<div id=\"navLinks\">' +\n\t'<a accesskey=\"t\" id=\"toggle\" href=\"javascript:toggle();\">&#216;<\\/a>' +\n\t'<a accesskey=\"z\" id=\"prev\" href=\"javascript:go(-1);\">&laquo;<\\/a>' +\n\t'<a accesskey=\"x\" id=\"next\" href=\"javascript:go(1);\">&raquo;<\\/a>' +\n\t'<div id=\"navList\"' + hideList + '><select id=\"jumplist\" onchange=\"go(\\'j\\');\"><\\/select><\\/div>' +\n\t'<\\/div><\\/form>';\n\tif (controlVis == 'hidden') {\n\t\tvar hidden = document.getElementById('navLinks');\n\t} else {\n\t\tvar hidden = document.getElementById('jumplist');\n\t}\n\taddClass(hidden,'hideme');\n}\n\nfunction fontScale() {  // causes layout problems in FireFox that get fixed if browser's Reload is used; same may be true of other Gecko-based browsers\n\tif (!s5mode) return false;\n\tvar vScale = 22;  // both yield 32 (after rounding) at 1024x768\n\tvar hScale = 32;  // perhaps should auto-calculate based on theme's declared value?\n\tif (window.innerHeight) {\n\t\tvar vSize = window.innerHeight;\n\t\tvar hSize = window.innerWidth;\n\t} else if (document.documentElement.clientHeight) {\n\t\tvar vSize = document.documentElement.clientHeight;\n\t\tvar hSize = document.documentElement.clientWidth;\n\t} else if (document.body.clientHeight) {\n\t\tvar vSize = document.body.clientHeight;\n\t\tvar hSize = document.body.clientWidth;\n\t} else {\n\t\tvar vSize = 700;  // assuming 1024x768, minus chrome and such\n\t\tvar hSize = 1024; // these do not account for kiosk mode or Opera Show\n\t}\n\tvar newSize = Math.min(Math.round(vSize/vScale),Math.round(hSize/hScale));\n\tfontSize(newSize + 'px');\n\tif (isGe) {  // hack to counter incremental reflow bugs\n\t\tvar obj = document.getElementsByTagName('body')[0];\n\t\tobj.style.display = 'none';\n\t\tobj.style.display = 'block';\n\t}\n}\n\nfunction fontSize(value) {\n\tif (!(s5ss = document.getElementById('s5ss'))) {\n\t\tif (!isIE) {\n\t\t\tdocument.getElementsByTagName('head')[0].appendChild(s5ss = document.createElement('style'));\n\t\t\ts5ss.setAttribute('media','screen, projection');\n\t\t\ts5ss.setAttribute('id','s5ss');\n\t\t} else {\n\t\t\tdocument.createStyleSheet();\n\t\t\tdocument.s5ss = document.styleSheets[document.styleSheets.length - 1];\n\t\t}\n\t}\n\tif (!isIE) {\n\t\twhile (s5ss.lastChild) s5ss.removeChild(s5ss.lastChild);\n\t\ts5ss.appendChild(document.createTextNode('body {font-size: ' + value + ' !important;}'));\n\t} else {\n\t\tdocument.s5ss.addRule('body','font-size: ' + value + ' !important;');\n\t}\n}\n\nfunction notOperaFix() {\n\tslideCSS = document.getElementById('slideProj').href;\n\tvar slides = document.getElementById('slideProj');\n\tvar outline = document.getElementById('outlineStyle');\n\tslides.setAttribute('media','screen');\n\toutline.disabled = true;\n\tif (isGe) {\n\t\tslides.setAttribute('href','null');   // Gecko fix\n\t\tslides.setAttribute('href',slideCSS); // Gecko fix\n\t}\n\tif (isIE && document.styleSheets && document.styleSheets[0]) {\n\t\tdocument.styleSheets[0].addRule('img', 'behavior: url(ui/default/iepngfix.htc)');\n\t\tdocument.styleSheets[0].addRule('div', 'behavior: url(ui/default/iepngfix.htc)');\n\t\tdocument.styleSheets[0].addRule('.slide', 'behavior: url(ui/default/iepngfix.htc)');\n\t}\n}\n\nfunction getIncrementals(obj) {\n\tvar incrementals = new Array();\n\tif (!obj) \n\t\treturn incrementals;\n\tvar children = obj.childNodes;\n\tfor (var i = 0; i < children.length; i++) {\n\t\tvar child = children[i];\n\t\tif (hasClass(child, 'incremental')) {\n\t\t\tif (child.nodeName == 'OL' || child.nodeName == 'UL') {\n\t\t\t\tremoveClass(child, 'incremental');\n\t\t\t\tfor (var j = 0; j < child.childNodes.length; j++) {\n\t\t\t\t\tif (child.childNodes[j].nodeType == 1) {\n\t\t\t\t\t\taddClass(child.childNodes[j], 'incremental');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tincrementals[incrementals.length] = child;\n\t\t\t\tremoveClass(child,'incremental');\n\t\t\t}\n\t\t}\n\t\tif (hasClass(child, 'show-first')) {\n\t\t\tif (child.nodeName == 'OL' || child.nodeName == 'UL') {\n\t\t\t\tremoveClass(child, 'show-first');\n\t\t\t\tif (child.childNodes[isGe].nodeType == 1) {\n\t\t\t\t\tremoveClass(child.childNodes[isGe], 'incremental');\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tincrementals[incrementals.length] = child;\n\t\t\t}\n\t\t}\n\t\tincrementals = incrementals.concat(getIncrementals(child));\n\t}\n\treturn incrementals;\n}\n\nfunction createIncrementals() {\n\tvar incrementals = new Array();\n\tfor (var i = 0; i < smax; i++) {\n\t\tincrementals[i] = getIncrementals(document.getElementById('slide'+i));\n\t}\n\treturn incrementals;\n}\n\nfunction defaultCheck() {\n\tvar allMetas = document.getElementsByTagName('meta');\n\tfor (var i = 0; i< allMetas.length; i++) {\n\t\tif (allMetas[i].name == 'defaultView') {\n\t\t\tdefaultView = allMetas[i].content;\n\t\t}\n\t\tif (allMetas[i].name == 'controlVis') {\n\t\t\tcontrolVis = allMetas[i].content;\n\t\t}\n\t}\n}\n\n// Key trap fix, new function body for trap()\nfunction trap(e) {\n\tif (!e) {\n\t\te = event;\n\t\te.which = e.keyCode;\n\t}\n\ttry {\n\t\tmodifierKey = e.ctrlKey || e.altKey || e.metaKey;\n\t}\n\tcatch(e) {\n\t\tmodifierKey = false;\n\t}\n\treturn modifierKey || e.which == 0;\n}\n\nfunction startup() {\n\tdefaultCheck();\n\tif (!isOp) \n\t\tcreateControls();\n\tslideLabel();\n\tfixLinks();\n\texternalLinks();\n\tfontScale();\n\tif (!isOp) {\n\t\tnotOperaFix();\n\t\tincrementals = createIncrementals();\n\t\tslideJump();\n\t\tif (defaultView == 'outline') {\n\t\t\ttoggle();\n\t\t}\n\t\tdocument.onkeyup = keys;\n\t\tdocument.onkeypress = trap;\n\t\tdocument.onclick = clicker;\n\t}\n}\n\nwindow.onload = startup;\nwindow.onresize = function(){setTimeout('fontScale()', 50);}"),("slideous/slideous.css","/*\tThis work is licensed under Creative Commons GNU LGPL License.\n\n\tLicense: http://creativecommons.org/licenses/LGPL/2.1/\n\tVersion: 1.0\n\n\tAuthor:  Stefan Goessner/2005\n\tWeb:     http://goessner.net/ \n*/\n@media screen, projection {\nbody {\n  background-color: #e3eee7;\n  padding: 0;\n  margin: 0;\n  color: #132; \n  border-color: #678; \n  font-size: 125%;\n}\n#statusbar {\n  display: none;\n  position: absolute; z-index: 10;\n  top: auto; bottom: 0; left: 0; right: 0;\n  height: 2em;\n  background-color: #f0fff8;\n  color: #132;\n  font-size: 75%;\n  padding: 0.5em 0.5em 0 2px;\n  border-top: solid 1px #000;\n}\n#statusbar button, #tocbox {\n  cursor: pointer; \n  color: #031;\n  background-color: #e0eee7;\n  margin: 1px;\n  padding: 0 0.5em;\n  border: inset 1px black;\n}\n#statusbar button:hover, #tocbox:hover {\n  color: #031;\n  background-color: #c0ccc6;\n  border: outset 1px black;\n}\n#tocbox {\n  width: 15em;\n}\n#eos {\n  visibility: hidden;\n  color: #021;\n  background-color: #fffafa;\n  border: inset 1px black;\n  font-size: 120%;\n}\ndiv.slide {\n   display: block;\n   margin: 0 0 2em 0;\n   padding: 0 150px;\n}\n\ndiv.slide h1 {\n  background: #a0aaa4;\n  color: #f0fff8;\n  padding: 0 0.5em 0 0.5em;\n  margin: 0 -150px;\n  font-size: 120%;\n  border-bottom: solid 1px black;\n}\n\ndiv.slide h1:before { content: \"# \"; }\ndiv.handout { display: block; }\n   \nbody>#statusbar {   /* ie6 hack for fixing the statusbar - in quirks mode */\n  position: fixed;  /* thanks to Anne van Kesteren and Arthur Steiner */\n}                   /* see http://limpid.nl/lab/css/fixed/footer */\n* html body {\n  overflow: hidden;\n}\n* html div.slide {\n  height: 100%;\n  padding-bottom: 2em;\n  overflow: auto;\n}                   /* end ie6-hack */\n\n} /* @media screen, projection */\n\n@media print {\nbody {\n  color: black;\n  font-family: sans-serif;\n  font-size: 11pt;\n}\n\n#statusbar { display: none; }\ndiv.slide { page-break-after: always; }\ndiv.handout { display: block; }\n\n} /* @media print */\n"),("slideous/slideous.js","/*\tThis work is licensed under Creative Commons GNU LGPL License.\n\n\tLicense: http://creativecommons.org/licenses/LGPL/2.1/\n\n\tAuthor:  Stefan Goessner/2005-2006\n\tWeb:     http://goessner.net/ \n*/\nvar Slideous = {\n   version: 1.0,\n   // == user customisable ===\n   clickables: { a: true, button: true, img: true, input: true, object: true, textarea: true, select: true, option: true },\n   incrementables: { blockquote: { filter: \"self, parent\" }, \n                     dd: { filter: \"self, parent\" },\n                     dt: { filter: \"self, parent\" },\n                     h2: { filter: \"self, parent\" },\n                     h3: { filter: \"self, parent\" },\n                     h4: { filter: \"self, parent\" },\n                     h5: { filter: \"self, parent\" },\n                     h6: { filter: \"self, parent\" },\n                     li: { filter: \"self, parent\" },\n                     p: { filter: \"self\" }, \n                     pre: { filter: \"self\" }, \n                     img: { filter: \"self, parent\" }, \n                     object: { filter: \"self, parent\" },\n                     table: { filter: \"self, parent\" },\n                     td: { filter: \"self, parent\" },\n                     th: { filter: \"self, parent\" },\n                     tr: { filter: \"parent, grandparent\" }\n                   },\n   autoincrementables: { ol: true, ul: true, dl: true },\n   autoincrement: false,\n   statusbar: true,\n   navbuttons: { incfontbutton:   function(){Slideous.changefontsize(+Slideous.fontdelta);},\n                 decfontbutton:   function(){Slideous.changefontsize(-Slideous.fontdelta);},\n                 contentbutton:   function(){Slideous.gotoslide(Slideous.tocidx(), true, true);},\n                 homebutton:      function(){Slideous.gotoslide(1, true, true);},\n                 prevslidebutton: function(){Slideous.previous(false);},\n                 previtembutton:  function(){Slideous.previous(true);},\n                 nextitembutton:  function(){Slideous.next(true);},\n                 nextslidebutton: function(){Slideous.next(false);},\n                 endbutton:       function(){Slideous.gotoslide(Slideous.count,true,true);} },\n   fontsize: 125,  // in percent, corresponding to body.font-size in css file\n   fontdelta: 5,   // increase/decrease fontsize by this value\n   mousesensitive: true,\n   tocidx: 0,\n   tocitems: { toc: \"<li><a href=\\\"#s{\\$slideidx}\\\">{\\$slidetitle}</a></li>\",\n               tocbox: \"<option value=\\\"#s{\\$slideidx}\\\" title=\\\"{\\$slidetitle}\\\">{\\$slidetitle}</option>\" },\n   keydown: function(evt) {\n      evt = evt || window.event;\n      var key = evt.keyCode || evt.which;\n      if (key && !evt.ctrlKey && !evt.altKey) {\n         switch (key) {\n            case 33: // page up  ... previous slide\n               Slideous.previous(false); evt.cancel = !Slideous.showall; break;\n            case 37: // left arrow ... previous item\n               Slideous.previous(true); evt.cancel = !Slideous.showall; break;\n            case 32: // space bar\n            case 39: // right arrow\n               Slideous.next(true); evt.cancel = !Slideous.showall; break;\n            case 13: // carriage return  ... next slide\n            case 34: // page down\n               Slideous.next(false); evt.cancel = !Slideous.showall; break;\n            case 35: // end  ... last slide (not recognised by opera)\n               Slideous.gotoslide(Slideous.count, true, true); evt.cancel = !Slideous.showall; break;\n            case 36: // home ... first slide (not recognised by opera)\n               Slideous.gotoslide(1, true, true); evt.cancel = !Slideous.showall; break;\n            case 65: // A ... show All\n            case 80: // P ... Print mode\n               Slideous.toggleshowall(!Slideous.showall); evt.cancel = true; break;\n            case 67: // C ... goto contents\n               Slideous.gotoslide(Slideous.tocidx, true, true); evt.cancel = true; break;\n            case 77: // M ... toggle mouse sensitivity\n               Slideous.mousenavigation(Slideous.mousesensitive = !Slideous.mousesensitive); evt.cancel = true; break;\n            case 83: // S ... toggle statusbar\n               Slideous.togglestatusbar(); evt.cancel = true; break;\n            case 61:  // + ... increase fontsize\n            case 107:\n               Slideous.changefontsize(+Slideous.fontdelta); evt.cancel = true; break;\n            case 109:  // - ... decrease fontsize\n               Slideous.changefontsize(-Slideous.fontdelta); evt.cancel = true; break;\n            default: break;\n         }\n         if (evt.cancel) evt.returnValue = false;\n      }\n      return !evt.cancel;\n   },\n\n   // == program logic ===\n   count: 0,                       // # of slides ..\n   curidx: 0,                      // current slide index ..\n   mousedownpos: null,             // last mouse down position ..\n   contentselected: false,         // indicates content selection ..\n   showall: true,\n   init: function() {\n      Slideous.curidx = 1;\n      Slideous.importproperties();\n      Slideous.registerslides();\n      document.body.innerHTML = Slideous.injectproperties(document.body.innerHTML);\n      Slideous.buildtocs();\n      Slideous.registeranchors();\n      Slideous.toggleshowall(false);\n      Slideous.updatestatus();\n      document.body.style.fontSize = Slideous.fontsize+\"%\";\n      document.getElementById(\"s1\").style.display = \"block\";\n      document.onkeydown = Slideous.keydown;\n      Slideous.mousenavigation(Slideous.mousesensitive);\n      Slideous.registerbuttons();\n      if (window.location.hash)\n         Slideous.gotoslide(window.location.hash.substr(2), true, true);\n   },\n   registerslides: function() {\n      var div = document.getElementsByTagName(\"div\");\n      Slideous.count = 0;\n      for (var i in div)\n         if (Slideous.hasclass(div[i], \"slide\"))\n            div[i].setAttribute(\"id\", \"s\"+(++Slideous.count));\n   },\n   registeranchors: function() {\n      var a = document.getElementsByTagName(\"a\"),\n          loc = (window.location.hostname+window.location.pathname).replace(/\\\\/g, \"/\");\n      for (var i in a) {\n         if (a[i].href && a[i].href.indexOf(loc) >= 0 && a[i].href.lastIndexOf(\"#\") >= 0) {\n            a[i].href = \"javascript:Slideous.gotoslide(\" + a[i].href.substr(a[i].href.lastIndexOf(\"#\")+2)+\",true,true)\";\n         }\n      }\n   },\n   registerbuttons: function() {\n      var button;\n      for (var b in Slideous.navbuttons)\n         if (button = document.getElementById(b))\n            button.onclick = Slideous.navbuttons[b];\n   },\n   importproperties: function() {  // from html meta section ..\n      var meta = document.getElementsByTagName(\"meta\"), elem;\n      for (var i in meta)\n         if (meta[i].attributes && meta[i].attributes[\"name\"] && meta[i].attributes[\"name\"].value in Slideous)\n            switch (typeof(Slideous[meta[i].attributes[\"name\"].value])) {\n               case \"number\": Slideous[meta[i].attributes[\"name\"].value] = parseInt(meta[i].attributes[\"content\"].value); break;\n               case \"boolean\": Slideous[meta[i].attributes[\"name\"].value] = meta[i].attributes[\"content\"].value == \"true\" ? true : false; break;\n               default: Slideous[meta[i].attributes[\"name\"].value] = meta[i].attributes[\"content\"].value; break;\n            }\n   },\n   injectproperties: function(str) {\n      var meta = document.getElementsByTagName(\"meta\"), elem;\n      for (var i in meta) {\n         if (meta[i].attributes && meta[i].attributes[\"name\"])\n            str = str.replace(new RegExp(\"{\\\\$\"+meta[i].attributes[\"name\"].value+\"}\",\"g\"), meta[i].attributes[\"content\"].value);\n      }\n      return str = str.replace(/{\\$generator}/g, \"Slideous\")\n                      .replace(/{\\$version}/g, Slideous.version)\n                      .replace(/{\\$title}/g, document.title)\n                      .replace(/{\\$slidecount}/g, Slideous.count);\n   },\n   buildtocs: function() {\n      var toc = document.getElementById(\"toc\"), list = \"\",\n          tocbox = document.getElementById(\"tocbox\");\n      if (toc) {\n         for (var i=0; i<Slideous.count; i++)\n            list += Slideous.tocitems.toc.replace(/{\\$slideidx}/g, i+1).replace(/{\\$slidetitle}/, document.getElementById(\"s\"+(i+1)).getElementsByTagName(\"h1\")[0].innerHTML);\n         toc.innerHTML = list;\n         while (toc && !Slideous.hasclass(toc, \"slide\")) toc = toc.parentNode;\n         if (toc) Slideous.tocidx = toc.getAttribute(\"id\").substr(1);\n      }\n      if (tocbox) {\n         tocbox.innerHTML = \"\";\n         for (var i=0; i<Slideous.count; i++)\n            tocbox.options[tocbox.length] = new Option((i+1)+\". \"+document.getElementById(\"s\"+(i+1)).getElementsByTagName(\"h1\")[0].innerHTML, \"#s\"+(i+1));\n         tocbox.onchange = function() { Slideous.gotoslide(this.selectedIndex+1, true, true); };\n      }\n   },\n   next: function(deep) {\n      if (!Slideous.showall) {\n         var slide = document.getElementById(\"s\"+Slideous.curidx),\n             item = Slideous.firstitem(slide, Slideous.isitemhidden);\n         if (deep) {  // next item\n            if (item)\n               Slideous.displayitem(item, true);\n            else\n               Slideous.gotoslide(Slideous.curidx+1, false, false);\n         }\n         else if (item)  // complete slide ..\n            while (item = Slideous.firstitem(slide, Slideous.isitemhidden))\n               Slideous.displayitem(item, true);\n         else           // next slide\n            Slideous.gotoslide(Slideous.curidx+1, true, false);\n         Slideous.updatestatus();\n      }\n   },\n   previous: function(deep) {\n      if (!Slideous.showall) {\n         var slide = document.getElementById(\"s\"+Slideous.curidx);\n         if (deep) {\n            var item = Slideous.lastitem(slide, Slideous.isitemvisible);\n            if (item)\n               Slideous.displayitem(item, false);\n            else\n               Slideous.gotoslide(Slideous.curidx-1, true, false);\n         }\n         else\n            Slideous.gotoslide(Slideous.curidx-1, true, false);\n         Slideous.updatestatus();\n      }\n   },\n   gotoslide: function(i, showitems, updatestatus) {\n      if (!Slideous.showall && i > 0 && i <= Slideous.count && i != Slideous.curidx) {\n         document.getElementById(\"s\"+Slideous.curidx).style.display = \"none\";\n         var slide = document.getElementById(\"s\"+(Slideous.curidx=i)), item;\n         while (item = Slideous.firstitem(slide, showitems ? Slideous.isitemhidden : Slideous.isitemvisible))\n            Slideous.displayitem(item, showitems);\n         slide.style.display = \"block\";\n         if (updatestatus)\n            Slideous.updatestatus();\n      }\n   },\n   firstitem: function(root, filter) {\n      var found = filter(root);\n      for (var node=root.firstChild; node!=null && !found; node = node.nextSibling)\n         found = Slideous.firstitem(node, filter);\n      return found;\n   },\n   lastitem: function(root, filter) {\n      var found = null;\n      for (var node=root.lastChild; node!=null && !found; node = node.previousSibling)\n         found = Slideous.lastitem(node, filter);\n      return found || filter(root);\n   },\n   isitem: function(node, visible) {\n      var nodename;\n      return node && node.nodeType == 1   // elements only ..\n          && (nodename=node.nodeName.toLowerCase()) in Slideous.incrementables\n          && (   Slideous.incrementables[nodename].filter.match(\"\\\\bself\\\\b\") && (Slideous.hasclass(node, \"incremental\") || (Slideous.autoincrement && nodename in Slideous.autoincrementables))\n              || Slideous.incrementables[nodename].filter.match(\"\\\\bparent\\\\b\") && (Slideous.hasclass(node.parentNode, \"incremental\") || (Slideous.autoincrement && node.parentNode.nodeName.toLowerCase() in Slideous.autoincrementables))\n              || Slideous.incrementables[nodename].filter.match(\"\\\\bgrandparent\\\\b\") && (Slideous.hasclass(node.parentNode.parentNode, \"incremental\") || (Slideous.autoincrement && node.parentNode.parentNode.nodeName.toLowerCase() in Slideous.autoincrementables))\n             )\n          && (visible ? (node.style.visibility != \"hidden\")\n                      : (node.style.visibility == \"hidden\"))\n          ? node : null;\n   },\n   isitemvisible: function(node) { return Slideous.isitem(node, true); },\n   isitemhidden: function(node) { return Slideous.isitem(node, false); },\n   displayitem: function(item, show) {\n      if (item) item.style.visibility = (show ? \"visible\" : \"hidden\");\n   },\n   updatestatus: function() {\n      if (Slideous.statusbar) {\n         var eos = document.getElementById(\"eos\"), \n             idx = document.getElementById(\"slideidx\"),\n             tocbox = document.getElementById(\"tocbox\");\n         if (eos) \n            eos.style.visibility = Slideous.firstitem(document.getElementById(\"s\"+Slideous.curidx), Slideous.isitemhidden) != null\n                                 ? \"visible\" : \"hidden\";\n         if (idx) \n            idx.innerHTML = Slideous.curidx;\n         if (tocbox)\n            tocbox.selectedIndex = Slideous.curidx-1;\n      }\n   },\n   changefontsize: function(delta) {\n      document.body.style.fontSize = (Slideous.fontsize+=delta)+\"%\";\n   },\n   togglestatusbar: function() {\n      document.getElementById(\"statusbar\").style.display = (Slideous.statusbar = !Slideous.statusbar) ? \"block\" : \"none\";\n   },\n   toggleshowall: function(showall) {\n      var slide, item;\n      for (var i=0; i<Slideous.count; i++) {\n         slide = document.getElementById(\"s\"+(i+1));\n         slide.style.display = showall ? \"block\" : \"none\";\n         while (item = Slideous.firstitem(slide, showall ? Slideous.isitemhidden : Slideous.isitemvisible)) \n            Slideous.displayitem(item, showall);\n         var divs = slide.getElementsByTagName(\"div\");\n         for (var j in divs)\n            if (Slideous.hasclass(divs[j], \"handout\"))\n               divs[j].style.display = showall ? \"block\" : \"none\";\n      }\n      if (!showall)\n         document.getElementById(\"s\"+Slideous.curidx).style.display = \"block\";\n      if (Slideous.statusbar) \n         document.getElementById(\"statusbar\").style.display = showall ? \"none\" : \"block\";\n      Slideous.showall = showall;\n   },\n   hasclass: function(elem, classname) {\n      var classattr = null;\n      return (classattr=(elem.attributes && elem.attributes[\"class\"])) \n          && classattr.nodeValue.match(\"\\\\b\"+classname+\"\\\\b\");\n   },\n   selectedcontent: function() {\n      return window.getSelection ? window.getSelection().toString() \n                                 : document.getSelection ? document.getSelection() \n                                                         : document.selection ? document.selection.createRange().text\n                                                                              : \"\";\n   },\n   mousenavigation: function(on) {\n      if (on) {\n         document.onmousedown = Slideous.mousedown;\n         document.onmouseup = Slideous.mouseup;\n      }\n      else\n         document.onmousedown = document.onmouseup = null;\n   },\n   mousepos: function(e) {\n      return e.pageX ? {x: e.pageX, y: e.pageY} \n                     : {x: e.x+document.body.scrollLeft, y: e.y+document.body.scrollTop};\n   },\n   mousedown: function(evt) {\n      evt = evt||window.event;\n      Slideous.mousedownpos = Slideous.mousepos(evt);\n      Slideous.contentselected = !!Slideous.selectedcontent() || ((evt.target || evt.srcElement).nodeName.toLowerCase() in Slideous.clickables);\n      return true;\n   },\n   mouseup: function(evt) {\n      evt = evt||window.event;\n      var pos = Slideous.mousepos(evt);\n      if (pos.x == Slideous.mousedownpos.x && pos.y == Slideous.mousedownpos.y && !Slideous.contentselected) {\n         Slideous.next(true);\n         return evt.returnValue = !(evt.cancel = true);\n      }\n      return false;\n   }\n};\nwindow.onload = Slideous.init;\n"),("slidy/graphics/fold-dim.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\195\195\255\204\204\204\235\235\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC1\140\143\162+\198\235^\v\STXX;e\150\241\161\US\DC4\NUL;"),("slidy/graphics/fold.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\NUL\NUL\NUL\NUL\NUL\255\195\195\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC1\132\143\162+\198\235^\ETX\"X;e\150\241\161\SI\DC4\NUL;"),("slidy/graphics/nofold-dim.gif","GIF87a\t\NUL\t\NUL\128\STX\NUL\204\204\204\235\235\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\SI\132\143\161\ESC\198\235^\ETXr\214\248\&0C\FS\DC4\NUL;"),("slidy/graphics/unfold-dim.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\195\195\255\204\204\204\235\235\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC4\140\143\162+\182\176\156\130\202\129{[xq\207\206t\bR\NUL\NUL;"),("slidy/graphics/unfold.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\NUL\NUL\NUL\NUL\NUL\255\195\195\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC4\132\143\162+\182\177\156\130\202\133{\ESCxq\207\206t\bR\NUL\NUL;"),("slidy/scripts/slidy.js","/* slidy.js\n\n   Copyright (c) 2005-2011 W3C (MIT, ERCIM, Keio), All Rights Reserved.\n   W3C liability, trademark, document use and software licensing\n   rules apply, see:\n\n   http://www.w3.org/Consortium/Legal/copyright-documents\n   http://www.w3.org/Consortium/Legal/copyright-software\n\n   Defines single name \"w3c_slidy\" in global namespace\n   Adds event handlers without trampling on any others\n*/\n\n// the slidy object implementation\nvar w3c_slidy = {\n  // classify which kind of browser we're running under\n  ns_pos: (typeof window.pageYOffset!='undefined'),\n  khtml: ((navigator.userAgent).indexOf(\"KHTML\") >= 0 ? true : false),\n  opera: ((navigator.userAgent).indexOf(\"Opera\") >= 0 ? true : false),\n  ipad: ((navigator.userAgent).indexOf(\"iPad\") >= 0 ? true : false),\n  iphone: ((navigator.userAgent).indexOf(\"iPhone\") >= 0 ? true : false),\n  android: ((navigator.userAgent).indexOf(\"Android\") >= 0 ? true : false),\n  ie: (typeof document.all != \"undefined\" && !this.opera),\n  ie6: (!this.ns_pos && navigator.userAgent.indexOf(\"MSIE 6\") != -1),\n  ie7: (!this.ns_pos && navigator.userAgent.indexOf(\"MSIE 7\") != -1),\n  ie8: (!this.ns_pos && navigator.userAgent.indexOf(\"MSIE 8\") != -1),\n  ie9: (!this.ns_pos && navigator.userAgent.indexOf(\"MSIE 9\") != -1),\n\n  // data for swipe and double tap detection on touch screens\n  last_tap: 0,\n  prev_tap: 0,\n  start_x: 0,\n  start_y: 0,\n  delta_x: 0,\n  delta_y: 0,\n\n  // are we running as XHTML? (doesn't work on Opera)\n  is_xhtml: /xml/.test(document.contentType),\n\n  slide_number: 0, // integer slide count: 0, 1, 2, ...\n  slide_number_element: null, // element containing slide number\n  slides: [], // set to array of slide div's\n  notes: [], // set to array of handout div's\n  backgrounds: [], // set to array of background div's\n  toolbar: null, // element containing toolbar\n  title: null, // document title\n  last_shown: null, // last incrementally shown item\n  eos: null,  // span element for end of slide indicator\n  toc: null, // table of contents\n  outline: null, // outline element with the focus\n  selected_text_len: 0, // length of drag selection on document\n  view_all: 0,  // 1 to view all slides + handouts\n  want_toolbar: true,  // user preference to show/hide toolbar\n  mouse_click_enabled: true, // enables left click for next slide\n  scroll_hack: 0, // IE work around for position: fixed\n  disable_slide_click: false,  // used by clicked anchors\n\n  lang: \"en\", // updated to language specified by html file\n\n  help_anchor: null, // used for keyboard focus hack in showToolbar()\n  help_page: \"http://www.w3.org/Talks/Tools/Slidy2/help/help.html\",\n  help_text: \"Navigate with mouse click, space bar, Cursor Left/Right, \" +\n             \"or Pg Up and Pg Dn. Use S and B to change font size.\",\n\n  size_index: 0,\n  size_adjustment: 0,\n  sizes:  new Array(\"10pt\", \"12pt\", \"14pt\", \"16pt\", \"18pt\", \"20pt\",\n                    \"22pt\", \"24pt\", \"26pt\", \"28pt\", \"30pt\", \"32pt\"),\n\n  // needed for efficient resizing\n  last_width: 0,\n  last_height: 0,\n\n\n  // Needed for cross browser support for relative width/height on\n  // object elements. The work around is to save width/height attributes\n  // and then to recompute absolute width/height dimensions on resizing\n   objects: [],\n\n  // attach initialiation event handlers\n  set_up: function () {\n    var init = function() { w3c_slidy.init(); };\n    if (typeof window.addEventListener != \"undefined\")\n      window.addEventListener(\"load\", init, false);\n    else\n      window.attachEvent(\"onload\", init);\n  },\n\n  hide_slides: function () {\n    if (document.body && !w3c_slidy.initialized)\n      document.body.style.visibility = \"hidden\";\n    else\n      setTimeout(w3c_slidy.hide_slides, 50);\n  },\n\n  // hack to persuade IE to compute correct document height\n  // as needed for simulating fixed positioning of toolbar\n  ie_hack: function () {\n    window.resizeBy(0,-1);\n    window.resizeBy(0, 1);\n  },\n\n  init: function () {\n    //alert(\"slidy starting test 10\");\n    document.body.style.visibility = \"visible\";\n    this.init_localization();\n    this.add_toolbar();\n    this.wrap_implicit_slides();\n    this.collect_slides();\n    this.collect_notes();\n    this.collect_backgrounds();\n    this.objects = document.body.getElementsByTagName(\"object\");\n    this.patch_anchors();\n    this.slide_number = this.find_slide_number(location.href);\n    window.offscreenbuffering = true;\n    this.size_adjustment = this.find_size_adjust();\n    this.time_left = this.find_duration();\n    this.hide_image_toolbar();  // suppress IE image toolbar popup\n    this.init_outliner();  // activate fold/unfold support\n    this.title = document.title;\n    this.keyboardless = (this.ipad||this.iphone||this.android);\n\n    if (this.keyboardless)\n    {\n      w3c_slidy.remove_class(w3c_slidy.toolbar, \"hidden\")\n      this.want_toolbar = 0;\n    }\n\n    // work around for opera bug\n    this.is_xhtml = (document.body.tagName == \"BODY\" ? false : true);\n\n    if (this.slides.length > 0)\n    {\n      var slide = this.slides[this.slide_number];\n   \n      if (this.slide_number > 0)\n      {\n        this.set_visibility_all_incremental(\"visible\");\n        this.last_shown = this.previous_incremental_item(null);\n        this.set_eos_status(true);\n      }\n      else\n      {\n        this.last_shown = null;\n        this.set_visibility_all_incremental(\"hidden\");\n        this.set_eos_status(!this.next_incremental_item(this.last_shown));\n      }\n\n      this.set_location();\n      this.add_class(this.slides[0], \"first-slide\");\n      w3c_slidy.show_slide(slide);\n    }\n\n    this.toc = this.table_of_contents();\n\n    this.add_initial_prompt();\n\n    // bind event handlers without interfering with custom page scripts\n    // Tap events behave too weirdly to support clicks reliably on\n    // iPhone and iPad, so exclude these from click handler\n\n    if (!this.keyboardless)\n    {\n      this.add_listener(document.body, \"click\", this.mouse_button_click);\n      this.add_listener(document.body, \"mousedown\", this.mouse_button_down);\n    }\n\n    this.add_listener(document, \"keydown\", this.key_down);\n    this.add_listener(document, \"keypress\", this.key_press);\n    this.add_listener(window, \"resize\", this.resized);\n    this.add_listener(window, \"scroll\", this.scrolled);\n    this.add_listener(window, \"unload\", this.unloaded);\n\n    //this.add_listener(document.body, \"touchstart\", this.touchstart);\n    //this.add_listener(document.body, \"touchmove\", this.touchmove);\n    //this.add_listener(document.body, \"touchend\", this.touchend);\n\n    this.add_listener(document, \"gesturechange\", function ()\n    {\n      return false;\n    });\n\n    this.attach_touch_handers(this.slides);\n\n    // this seems to be a debugging hack\n    //if (!document.body.onclick)\n    //  document.body.onclick = function () { };\n\n    this.single_slide_view();\n\n    //this.set_location();\n\n    this.resized();\n\n    if (this.ie7)\n      setTimeout(w3c_slidy.ie_hack, 100);\n\n    this.show_toolbar();\n\n    // for back button detection\n    setInterval(function () { w3c_slidy.check_location(); }, 200);\n    w3c_slidy.initialized = true;\n  },\n\n  // create div element with links to each slide\n  table_of_contents: function () {\n    var toc = this.create_element(\"div\");\n    this.add_class(toc, \"slidy_toc hidden\");\n    //toc.setAttribute(\"tabindex\", \"0\");\n\n    var heading = this.create_element(\"div\");\n    this.add_class(heading, \"toc-heading\");\n    heading.innerHTML = this.localize(\"Table of Contents\");\n\n    toc.appendChild(heading);\n    var previous = null;\n\n    for (var i = 0; i < this.slides.length; ++i)\n    {\n      var title = this.has_class(this.slides[i], \"title\");\n      var num = document.createTextNode((i + 1) + \". \");\n\n      toc.appendChild(num);\n\n      var a = this.create_element(\"a\");\n      a.setAttribute(\"href\", \"#(\" + (i+1) + \")\");\n\n      if (title)\n        this.add_class(a, \"titleslide\");\n\n      var name = document.createTextNode(this.slide_name(i));\n      a.appendChild(name);\n      a.onclick = w3c_slidy.toc_click;\n      a.onkeydown = w3c_slidy.toc_key_down;\n      a.previous = previous;\n\n      if (previous)\n        previous.next = a;\n\n      toc.appendChild(a);\n\n      if (i == 0)\n        toc.first = a;\n\n      if (i < this.slides.length - 1)\n      {\n        var br = this.create_element(\"br\");\n        toc.appendChild(br);\n      }\n\n      previous = a;\n    }\n\n    toc.focus = function () {\n      if (this.first)\n        this.first.focus();\n    }\n\n    toc.onmouseup = w3c_slidy.mouse_button_up;\n\n    toc.onclick = function (e) {\n      e||(e=window.event);\n\n      if (w3c_slidy.selected_text_len <= 0)\n         w3c_slidy.hide_table_of_contents(true);\n\n      w3c_slidy.stop_propagation(e);\n    \n      if (e.cancel != undefined)\n        e.cancel = true;\n      \n      if (e.returnValue != undefined)\n        e.returnValue = false;\n      \n      return false;\n    };\n\n    document.body.insertBefore(toc, document.body.firstChild);\n    return toc;\n  },\n\n  is_shown_toc: function () {\n    return !w3c_slidy.has_class(w3c_slidy.toc, \"hidden\");\n  },\n\n  show_table_of_contents: function () {\n    w3c_slidy.remove_class(w3c_slidy.toc, \"hidden\");\n    var toc = w3c_slidy.toc;\n    toc.focus();\n\n    if (w3c_slidy.ie7 && w3c_slidy.slide_number == 0)\n      setTimeout(w3c_slidy.ie_hack, 100);\n  },\n\n  hide_table_of_contents: function (focus) {\n    w3c_slidy.add_class(w3c_slidy.toc, \"hidden\");\n\n    if (focus && !w3c_slidy.opera &&\n        !w3c_slidy.has_class(w3c_slidy.toc, \"hidden\"))\n      w3c_slidy.help_anchor.focus();\n  },\n\n  toggle_table_of_contents: function () {\n    if (w3c_slidy.is_shown_toc())\n      w3c_slidy.hide_table_of_contents(true);\n    else\n      w3c_slidy.show_table_of_contents();\n  },\n\n  // called on clicking toc entry\n  toc_click: function (e) {\n    if (!e)\n      e = window.event;\n\n    var target = w3c_slidy.get_target(e);\n\n    if (target && target.nodeType == 1)\n    {\n      var uri = target.getAttribute(\"href\");\n\n      if (uri)\n      {\n        //alert(\"going to \" + uri);\n        var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n        w3c_slidy.hide_slide(slide);\n        w3c_slidy.slide_number = w3c_slidy.find_slide_number(uri);\n        slide = w3c_slidy.slides[w3c_slidy.slide_number];\n        w3c_slidy.last_shown = null;\n        w3c_slidy.set_location();\n        w3c_slidy.set_visibility_all_incremental(\"hidden\");\n        w3c_slidy.set_eos_status(!w3c_slidy.next_incremental_item(w3c_slidy.last_shown));\n        w3c_slidy.show_slide(slide);\n        //target.focus();\n\n        try\n        {\n          if (!w3c_slidy.opera)\n            w3c_slidy.help_anchor.focus();\n        }\n        catch (e)\n        {\n        }\n      }\n    }\n\n    w3c_slidy.hide_table_of_contents(true);\n    if (w3c_slidy.ie7) w3c_slidy.ie_hack();\n    w3c_slidy.stop_propagation(e);\n    return w3c_slidy.cancel(e);\n  },\n\n  // called onkeydown for toc entry\n  toc_key_down: function (event) {\n    var key;\n\n    if (!event)\n      var event = window.event;\n\n    // kludge around NS/IE differences \n    if (window.event)\n      key = window.event.keyCode;\n    else if (event.which)\n      key = event.which;\n    else\n      return true; // Yikes! unknown browser\n\n    // ignore event if key value is zero\n    // as for alt on Opera and Konqueror\n    if (!key)\n      return true;\n\n    // check for concurrent control/command/alt key\n    // but are these only present on mouse events?\n\n    if (event.ctrlKey || event.altKey)\n      return true;\n\n    if (key == 13)\n    {\n      var uri = this.getAttribute(\"href\");\n\n      if (uri)\n      {\n        //alert(\"going to \" + uri);\n       var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n        w3c_slidy.hide_slide(slide);\n        w3c_slidy.slide_number = w3c_slidy.find_slide_number(uri);\n        slide = w3c_slidy.slides[w3c_slidy.slide_number];\n        w3c_slidy.last_shown = null;\n        w3c_slidy.set_location();\n        w3c_slidy.set_visibility_all_incremental(\"hidden\");\n        w3c_slidy.set_eos_status(!w3c_slidy.next_incremental_item(w3c_slidy.last_shown));\n        w3c_slidy.show_slide(slide);\n        //target.focus();\n\n        try\n        {\n          if (!w3c_slidy.opera)\n            w3c_slidy.help_anchor.focus();\n        }\n        catch (e)\n        {\n        }\n      }\n\n      w3c_slidy.hide_table_of_contents(true);\n\n      if (self.ie7)\n       w3c_slidy.ie_hack();\n\n      return w3c_slidy.cancel(event);\n    }\n\n    if (key == 40 && this.next)\n    {\n      this.next.focus();\n      return w3c_slidy.cancel(event);\n    }\n\n    if (key == 38 && this.previous)\n    {\n      this.previous.focus();\n      return w3c_slidy.cancel(event);\n    }\n\n    return true;\n  },\n\n  touchstart: function (e)\n  {\n    //e.preventDefault();\n    this.prev_tap = this.last_tap;\n    this.last_tap = (new Date).getTime();\n\n    var tap_delay = this.last_tap - this.prev_tap;\n\n    if (tap_delay <= 200)\n    {\n      // double tap\n    }\n\n    var touch = e.touches[0];\n\n    this.start_x = touch.pageX;\n    this.start_y = touch.pageY;\n    this.delta_x = this.delta_y = 0;\n  },\n\n  touchmove: function (e)\n  {\n    //e.preventDefault();\n    var touch = e.touches[0];\n    this.delta_x = touch.pageX - this.start_x;\n    this.delta_y = touch.pageY - this.start_y;\n  },\n\n  touchend: function (e)\n  {\n    //e.preventDefault();\n    var delay = (new Date).getTime() - this.last_tap;\n    var dx = this.delta_x;\n    var dy = this.delta_y;\n    var abs_dx = Math.abs(dx);\n    var abs_dy = Math.abs(dy);\n\n    if (delay < 500 && (abs_dx > 100 || abs_dy > 100))\n    {\n      if (abs_dx > 0.5 * abs_dy)\n      {\n        if (dx < 0)\n          w3c_slidy.next_slide(true);\n        else\n          w3c_slidy.previous_slide(true);\n      }\n      else if (abs_dy > 2 * abs_dx)\n      {\n        w3c_slidy.toggle_table_of_contents();\n      }\n    }\n  },\n\n  // ### OBSOLETE ###\n  before_print: function () {\n    this.show_all_slides();\n    this.hide_toolbar();\n    alert(\"before print\");\n  },\n\n  // ### OBSOLETE ###\n  after_print: function () {\n    if (!this.view_all)\n    {\n      this.single_slide_view();\n      this.show_toolbar();\n    }\n    alert(\"after print\");\n  },\n\n  // ### OBSOLETE ###\n  print_slides: function () {\n    this.before_print();\n    window.print();\n    this.after_print();\n  },\n\n  // ### OBSOLETE ?? ###\n  toggle_view: function () {\n    if (this.view_all)\n    {\n      this.single_slide_view();\n      this.show_toolbar();\n      this.view_all = 0;\n    }\n    else\n    {\n      this.show_all_slides();\n      this.hide_toolbar();\n      this.view_all = 1;\n    }\n  },\n\n  // prepare for printing  ### OBSOLETE ###\n  show_all_slides: function () {\n    this.remove_class(document.body, \"single_slide\");\n    this.set_visibility_all_incremental(\"visible\");\n  },\n\n  // restore after printing  ### OBSOLETE ###\n  single_slide_view: function () {\n    this.add_class(document.body, \"single_slide\");\n    this.set_visibility_all_incremental(\"visible\");\n    this.last_shown = this.previous_incremental_item(null);\n  },\n\n  // suppress IE's image toolbar pop up\n  hide_image_toolbar: function () {\n    if (!this.ns_pos)\n    {\n      var images = document.getElementsByTagName(\"IMG\");\n\n      for (var i = 0; i < images.length; ++i)\n        images[i].setAttribute(\"galleryimg\", \"no\");\n    }\n  },\n\n  unloaded: function (e) {\n    //alert(\"unloaded\");\n  },\n\n  // Safari and Konqueror don't yet support getComputedStyle()\n  // and they always reload page when location.href is updated\n  is_KHTML: function () {\n    var agent = navigator.userAgent;\n    return (agent.indexOf(\"KHTML\") >= 0 ? true : false);\n  },\n\n  // find slide name from first h1 element\n  // default to document title + slide number\n  slide_name: function (index) {\n    var name = null;\n    var slide = this.slides[index];\n\n    var heading = this.find_heading(slide);\n\n    if (heading)\n      name = this.extract_text(heading);\n\n    if (!name)\n      name = this.title + \"(\" + (index + 1) + \")\";\n\n    name.replace(/\\&/g, \"&amp;\");\n    name.replace(/\\</g, \"&lt;\");\n    name.replace(/\\>/g, \"&gt;\");\n\n    return name;\n  },\n\n  // find first h1 element in DOM tree\n  find_heading: function (node) {\n    if (!node || node.nodeType != 1)\n      return null;\n\n    if (node.nodeName == \"H1\" || node.nodeName == \"h1\")\n      return node;\n\n    var child = node.firstChild;\n\n    while (child)\n    {\n      node = this.find_heading(child);\n\n      if (node)\n        return node;\n\n      child = child.nextSibling;\n    }\n\n    return null;\n  },\n\n  // recursively extract text from DOM tree\n  extract_text: function (node) {\n    if (!node)\n      return \"\";\n\n    // text nodes\n    if (node.nodeType == 3)\n      return node.nodeValue;\n\n    // elements\n    if (node.nodeType == 1)\n    {\n      node = node.firstChild;\n      var text = \"\";\n\n      while (node)\n      {\n        text = text + this.extract_text(node);\n        node = node.nextSibling;\n      }\n\n      return text;\n    }\n\n    return \"\";\n  },\n\n  // find copyright text from meta element\n  find_copyright: function () {\n    var name, content;\n    var meta = document.getElementsByTagName(\"meta\");\n\n    for (var i = 0; i < meta.length; ++i)\n    {\n      name = meta[i].getAttribute(\"name\");\n      content = meta[i].getAttribute(\"content\");\n\n      if (name == \"copyright\")\n        return content;\n    }\n\n    return null;\n  },\n\n  find_size_adjust: function () {\n    var name, content, offset;\n    var meta = document.getElementsByTagName(\"meta\");\n\n    for (var i = 0; i < meta.length; ++i)\n    {\n      name = meta[i].getAttribute(\"name\");\n      content = meta[i].getAttribute(\"content\");\n\n      if (name == \"font-size-adjustment\")\n        return 1 * content;\n    }\n\n    return 1;\n  },\n\n  // <meta name=\"duration\" content=\"20\" />  for 20 minutes\n  find_duration: function () {\n    var name, content, offset;\n    var meta = document.getElementsByTagName(\"meta\");\n\n    for (var i = 0; i < meta.length; ++i)\n    {\n      name = meta[i].getAttribute(\"name\");\n      content = meta[i].getAttribute(\"content\");\n\n      if (name == \"duration\")\n        return 60000 * content;\n    }\n\n    return null;\n  },\n\n  replace_by_non_breaking_space: function (str) {\n    for (var i = 0; i < str.length; ++i)\n      str[i] = 160;\n  },\n\n  // ### CHECK ME ### is use of \"li\" okay for text/html?\n  // for XHTML do we also need to specify namespace?\n  init_outliner: function () {\n    var items = document.getElementsByTagName(\"li\");\n\n    for (var i = 0; i < items.length; ++i)\n    {\n      var target = items[i];\n\n      if (!this.has_class(target.parentNode, \"outline\"))\n        continue;\n\n      target.onclick = this.outline_click;\n/* ### more work needed for IE6\n      if (!this.ns_pos)\n      {\n        target.onmouseover = this.hover_outline;\n        target.onmouseout = this.unhover_outline;\n      }\n*/\n      if (this.foldable(target))\n      {\n        target.foldable = true;\n        target.onfocus = function () {w3c_slidy.outline = this;};\n        target.onblur = function () {w3c_slidy.outline = null;};\n\n        if (!target.getAttribute(\"tabindex\"))\n          target.setAttribute(\"tabindex\", \"0\");\n\n        if (this.has_class(target, \"expand\"))\n          this.unfold(target);\n        else\n          this.fold(target);\n      }\n      else\n      {\n        this.add_class(target, \"nofold\");\n        target.visible = true;\n        target.foldable = false;\n      }\n    }\n  },\n\n  foldable: function (item) {\n    if (!item || item.nodeType != 1)\n      return false;\n\n    var node = item.firstChild;\n\n    while (node)\n    {\n      if (node.nodeType == 1 && this.is_block(node))\n        return true;\n\n      node = node.nextSibling;\n    }\n\n    return false;\n  },\n\n  // ### CHECK ME ### switch to add/remove \"hidden\" class\n  fold: function (item) {\n    if (item)\n    {\n      this.remove_class(item, \"unfolded\");\n      this.add_class(item, \"folded\");\n    }\n\n    var node = item ? item.firstChild : null;\n\n    while (node)\n    {\n      if (node.nodeType == 1 && this.is_block(node)) // element\n      {\n         w3c_slidy.add_class(node, \"hidden\");\n      }\n\n      node = node.nextSibling;\n    }\n\n    item.visible = false;\n  },\n\n  // ### CHECK ME ### switch to add/remove \"hidden\" class\n  unfold: function (item) {\n    if (item)\n    {\n      this.add_class(item, \"unfolded\");\n      this.remove_class(item, \"folded\");\n    }\n\n    var node = item ? item.firstChild : null;\n\n    while (node)\n    {\n      if (node.nodeType == 1 && this.is_block(node)) // element\n      {\n        w3c_slidy.remove_class(node, \"hidden\");\n      }\n\n      node = node.nextSibling;\n    }\n\n    item.visible = true;\n  },\n\n  outline_click: function (e) {\n    if (!e)\n      e = window.event;\n\n    var rightclick = false;\n    var target = w3c_slidy.get_target(e);\n\n    while (target && target.visible == undefined)\n      target = target.parentNode;\n\n    if (!target)\n      return true;\n\n    if (e.which)\n      rightclick = (e.which == 3);\n    else if (e.button)\n      rightclick = (e.button == 2);\n\n    if (!rightclick && target.visible != undefined)\n    {\n      if (target.foldable)\n      {\n        if (target.visible)\n          w3c_slidy.fold(target);\n        else\n          w3c_slidy.unfold(target);\n      }\n\n      w3c_slidy.stop_propagation(e);\n      e.cancel = true;\n      e.returnValue = false;\n    }\n\n    return false;\n  },\n\n  add_initial_prompt: function () {\n    var prompt = this.create_element(\"div\");\n    prompt.setAttribute(\"class\", \"initial_prompt\");\n\n    var p1 = this.create_element(\"p\");\n    prompt.appendChild(p1);\n    p1.setAttribute(\"class\", \"help\");\n\n    if (this.keyboardless)\n      p1.innerHTML = \"swipe left to move to next slide\";\n    else\n      p1.innerHTML = \"Space, Right Arrow or swipe left to move to \" +\n                     \"next slide, click help below for more details\";\n\n    this.add_listener(prompt, \"click\", function (e) {\n      document.body.removeChild(prompt);\n      w3c_slidy.stop_propagation(e);\n    \n      if (e.cancel != undefined)\n        e.cancel = true;\n      \n      if (e.returnValue != undefined)\n        e.returnValue = false;\n      \n      return false;\n    });\n\n    document.body.appendChild(prompt);\n    this.initial_prompt = prompt;\n    setTimeout(function() {document.body.removeChild(prompt);}, 5000);\n  },\n\n  add_toolbar: function () {\n    var counter, page;\n\n     this.toolbar = this.create_element(\"div\");\n     this.toolbar.setAttribute(\"class\", \"toolbar\");\n\n     // a reasonably behaved browser\n     if (this.ns_pos || !this.ie6)\n     {\n       var right = this.create_element(\"div\");\n       right.setAttribute(\"style\", \"float: right; text-align: right\");\n\n       counter = this.create_element(\"span\")\n       counter.innerHTML = this.localize(\"slide\") + \" n/m\";\n       right.appendChild(counter);\n       this.toolbar.appendChild(right);\n\n       var left = this.create_element(\"div\");\n       left.setAttribute(\"style\", \"text-align: left\");\n\n       // global end of slide indicator\n       this.eos = this.create_element(\"span\");\n       this.eos.innerHTML = \"* \";\n       left.appendChild(this.eos);\n\n       var help = this.create_element(\"a\");\n       help.setAttribute(\"href\", this.help_page);\n       help.setAttribute(\"title\", this.localize(this.help_text));\n       help.innerHTML = this.localize(\"help?\");\n       left.appendChild(help);\n       this.help_anchor = help;  // save for focus hack\n\n       var gap1 = document.createTextNode(\" \");\n       left.appendChild(gap1);\n\n       var contents = this.create_element(\"a\");\n       contents.setAttribute(\"href\", \"javascript:w3c_slidy.toggle_table_of_contents()\");\n       contents.setAttribute(\"title\", this.localize(\"table of contents\"));\n       contents.innerHTML = this.localize(\"contents?\");\n       left.appendChild(contents);\n\n       var gap2 = document.createTextNode(\" \");\n       left.appendChild(gap2);\n\n       var copyright = this.find_copyright();\n\n       if (copyright)\n       {\n         var span = this.create_element(\"span\");\n         span.className = \"copyright\";\n         span.innerHTML = copyright;\n         left.appendChild(span);\n       }\n\n       this.toolbar.setAttribute(\"tabindex\", \"0\");\n       this.toolbar.appendChild(left);\n     }\n     else // IE6 so need to work around its poor CSS support\n     {\n       this.toolbar.style.position = (this.ie7 ? \"fixed\" : \"absolute\");\n       this.toolbar.style.zIndex = \"200\";\n       this.toolbar.style.width = \"99.9%\";\n       this.toolbar.style.height = \"1.2em\";\n       this.toolbar.style.top = \"auto\";\n       this.toolbar.style.bottom = \"0\";\n       this.toolbar.style.left = \"0\";\n       this.toolbar.style.right = \"0\";\n       this.toolbar.style.textAlign = \"left\";\n       this.toolbar.style.fontSize = \"60%\";\n       this.toolbar.style.color = \"red\";\n       this.toolbar.borderWidth = 0;\n       this.toolbar.className = \"toolbar\";\n       this.toolbar.style.background = \"rgb(240,240,240)\";\n\n       // would like to have help text left aligned\n       // and page counter right aligned, floating\n       // div's don't work, so instead use nested\n       // absolutely positioned div's.\n\n       var sp = this.create_element(\"span\");\n       sp.innerHTML = \"&nbsp;&nbsp;*&nbsp;\";\n       this.toolbar.appendChild(sp);\n       this.eos = sp;  // end of slide indicator\n\n       var help = this.create_element(\"a\");\n       help.setAttribute(\"href\", this.help_page);\n       help.setAttribute(\"title\", this.localize(this.help_text));\n       help.innerHTML = this.localize(\"help?\");\n       this.toolbar.appendChild(help);\n       this.help_anchor = help;  // save for focus hack\n\n       var gap1 = document.createTextNode(\" \");\n       this.toolbar.appendChild(gap1);\n\n       var contents = this.create_element(\"a\");\n       contents.setAttribute(\"href\", \"javascript:toggleTableOfContents()\");\n       contents.setAttribute(\"title\", this.localize(\"table of contents\".localize));\n       contents.innerHTML = this.localize(\"contents?\");\n       this.toolbar.appendChild(contents);\n\n       var gap2 = document.createTextNode(\" \");\n       this.toolbar.appendChild(gap2);\n\n       var copyright = this.find_copyright();\n\n       if (copyright)\n       {\n         var span = this.create_element(\"span\");\n         span.innerHTML = copyright;\n         span.style.color = \"black\";\n         span.style.marginLeft = \"0.5em\";\n         this.toolbar.appendChild(span);\n       }\n\n       counter = this.create_element(\"div\")\n       counter.style.position = \"absolute\";\n       counter.style.width = \"auto\"; //\"20%\";\n       counter.style.height = \"1.2em\";\n       counter.style.top = \"auto\";\n       counter.style.bottom = 0;\n       counter.style.right = \"0\";\n       counter.style.textAlign = \"right\";\n       counter.style.color = \"red\";\n       counter.style.background = \"rgb(240,240,240)\";\n\n       counter.innerHTML = this.localize(\"slide\") + \" n/m\";\n       this.toolbar.appendChild(counter);\n     }\n\n     // ensure that click isn't passed through to the page\n     this.toolbar.onclick =\n         function (e) {\n           if (!e)\n             e = window.event;\n\n           var target = e.target;\n\n           if (!target && e.srcElement)\n             target = e.srcElement;\n\n           // work around Safari bug\n           if (target && target.nodeType == 3)\n             target = target.parentNode;\n\n           w3c_slidy.stop_propagation(e);\n\n           if (target && target.nodeName.toLowerCase() != \"a\")\n             w3c_slidy.mouse_button_click(e);\n         };\n\n     this.slide_number_element = counter;\n     this.set_eos_status(false);\n     document.body.appendChild(this.toolbar);\n  },\n\n  // wysiwyg editors make it hard to use div elements\n  // e.g. amaya loses the div when you copy and paste\n  // this function wraps div elements around implicit\n  // slides which start with an h1 element and continue\n  // up to the next heading or div element\n  wrap_implicit_slides: function () {\n    var i, heading, node, next, div;\n    var headings = document.getElementsByTagName(\"h1\");\n\n    if (!headings)\n      return;\n\n    for (i = 0; i < headings.length; ++i)\n    {\n      heading = headings[i];\n\n      if (heading.parentNode != document.body)\n        continue;\n\n      node = heading.nextSibling;\n\n      div = document.createElement(\"div\");\n      this.add_class(div, \"slide\");\n      document.body.replaceChild(div, heading);\n      div.appendChild(heading);\n\n      while (node)\n      {\n        if (node.nodeType == 1) // an element\n        {\n           if (node.nodeName == \"H1\" || node.nodeName == \"h1\")\n             break;\n\n           if (node.nodeName == \"DIV\" || node.nodeName == \"div\")\n           {\n             if (this.has_class(node, \"slide\"))\n               break;\n\n             if (this.has_class(node, \"handout\"))\n               break;\n           }\n        }\n\n        next = node.nextSibling;\n        node = document.body.removeChild(node);\n        div.appendChild(node);\n        node = next;\n      } \n    }\n  },\n\n  attach_touch_handers: function(slides)\n  {\n    var i, slide;\n\n    for (i = 0; i < slides.length; ++i)\n    {\n      slide = slides[i];\n      this.add_listener(slide, \"touchstart\", this.touchstart);\n      this.add_listener(slide, \"touchmove\", this.touchmove);\n      this.add_listener(slide, \"touchend\", this.touchend);\n    }\n  },\n\n// return new array of all slides\n  collect_slides: function () {\n    var slides = new Array();\n    var divs = document.body.getElementsByTagName(\"div\");\n\n    for (var i = 0; i < divs.length; ++i)\n    {\n      div = divs.item(i);\n\n      if (this.has_class(div, \"slide\"))\n      {\n        // add slide to collection\n        slides[slides.length] = div;\n\n        // hide each slide as it is found\n        this.add_class(div, \"hidden\");\n\n        // add dummy <br/> at end for scrolling hack\n        var node1 = document.createElement(\"br\");\n        div.appendChild(node1);\n        var node2 = document.createElement(\"br\");\n        div.appendChild(node2);\n      }\n      else if (this.has_class(div, \"background\"))\n      {  // work around for Firefox SVG reload bug\n        // which otherwise replaces 1st SVG graphic with 2nd\n        div.style.display = \"block\";\n      }\n    }\n\n    this.slides = slides;\n  },\n\n  // return new array of all <div class=\"handout\">\n  collect_notes: function () {\n    var notes = new Array();\n    var divs = document.body.getElementsByTagName(\"div\");\n\n    for (var i = 0; i < divs.length; ++i)\n    {\n      div = divs.item(i);\n\n      if (this.has_class(div, \"handout\"))\n      {\n        // add note to collection\n        notes[notes.length] = div;\n\n        // and hide it\n        this.add_class(div, \"hidden\");\n      }\n    }\n\n    this.notes = notes;\n  },\n\n  // return new array of all <div class=\"background\">\n  // including named backgrounds e.g. class=\"background titlepage\"\n  collect_backgrounds: function () {\n    var backgrounds = new Array();\n    var divs = document.body.getElementsByTagName(\"div\");\n\n    for (var i = 0; i < divs.length; ++i)\n    {\n      div = divs.item(i);\n\n      if (this.has_class(div, \"background\"))\n      {\n        // add background to collection\n        backgrounds[backgrounds.length] = div;\n\n        // and hide it\n        this.add_class(div, \"hidden\");\n      }\n    }\n\n    this.backgrounds = backgrounds;\n  },\n\n  // set click handlers on all anchors\n  patch_anchors: function () {\n    var self = w3c_slidy;\n    var handler = function (event) {\n      // compare this.href with location.href\n      // for link to another slide in this doc\n\n      if (self.page_address(this.href) == self.page_address(location.href))\n      {\n        // yes, so find new slide number\n        var newslidenum = self.find_slide_number(this.href);\n\n        if (newslidenum != self.slide_number)\n        {\n          var slide = self.slides[self.slide_number];\n          self.hide_slide(slide);\n          self.slide_number = newslidenum;\n          slide = self.slides[self.slide_number];\n          self.show_slide(slide);\n          self.set_location();\n        }\n      }\n      else\n        w3c_slidy.stop_propagation(event);\n\n//      else if (this.target == null)\n//        location.href = this.href;\n\n      this.blur();\n      self.disable_slide_click = true;\n    };\n\n    var anchors = document.body.getElementsByTagName(\"a\");\n\n    for (var i = 0; i < anchors.length; ++i)\n    {\n      if (window.addEventListener)\n        anchors[i].addEventListener(\"click\", handler, false);\n      else\n        anchors[i].attachEvent(\"onclick\", handler);\n    }\n  },\n\n  // ### CHECK ME ### see which functions are invoked via setTimeout\n  // either directly or indirectly for use of w3c_slidy vs this\n  show_slide_number: function () {\n    var timer = w3c_slidy.get_timer();\n    w3c_slidy.slide_number_element.innerHTML = timer + w3c_slidy.localize(\"slide\") + \" \" +\n           (w3c_slidy.slide_number + 1) + \"/\" + w3c_slidy.slides.length;\n  },\n\n  // every 200mS check if the location has been changed as a\n  // result of the user activating the Back button/menu item\n  // doesn't work for Opera < 9.5\n  check_location: function () {\n    var hash = location.hash;\n\n    if (w3c_slidy.slide_number > 0 && (hash == \"\" || hash == \"#\"))\n      w3c_slidy.goto_slide(0);\n    else if (hash.length > 2 && hash != \"#(\"+(w3c_slidy.slide_number+1)+\")\")\n    {\n      var num = parseInt(location.hash.substr(2));\n\n      if (!isNaN(num))\n        w3c_slidy.goto_slide(num-1);\n    }\n\n    if (w3c_slidy.time_left && w3c_slidy.slide_number > 0)\n    {\n      w3c_slidy.show_slide_number();\n\n      if (w3c_slidy.time_left > 0)\n        w3c_slidy.time_left -= 200;\n    } \n  },\n\n  get_timer: function () {\n    var timer = \"\";\n    if (w3c_slidy.time_left)\n    {\n      var mins, secs;\n      secs = Math.floor(w3c_slidy.time_left/1000);\n      mins = Math.floor(secs / 60);\n      secs = secs % 60;\n      timer = (mins ? mins+\"m\" : \"\") + secs + \"s \";\n    }\n\n    return timer;\n  },\n\n  // this doesn't push location onto history stack for IE\n  // for which a hidden iframe hack is needed: load page into\n  // the iframe with script that set's parent's location.hash\n  // but that won't work for standalone use unless we can\n  // create the page dynamically via a javascript: URL\n  // ### use history.pushState if available\n  set_location: function () {\n     var uri = w3c_slidy.page_address(location.href);\n     var hash = \"#(\" + (w3c_slidy.slide_number+1) + \")\";\n\n     if (w3c_slidy.slide_number >= 0)\n       uri = uri + hash;\n\n     if (typeof(history.pushState) != \"undefined\")\n     {\n       document.title = w3c_slidy.title + \" (\" + (w3c_slidy.slide_number+1) + \")\";\n       history.pushState(0, document.title, hash);\n       w3c_slidy.show_slide_number();\n       return;\n     }\n\n     if (w3c_slidy.ie && (w3c_slidy.ie6 || w3c_slidy.ie7))\n       w3c_slidy.push_hash(hash);\n\n     if (uri != location.href) // && !khtml\n        location.href = uri;\n\n     if (this.khtml)\n        hash = \"(\" + (w3c_slidy.slide_number+1) + \")\";\n\n     if (!this.ie && location.hash != hash && location.hash != \"\")\n       location.hash = hash;\n\n     document.title = w3c_slidy.title + \" (\" + (w3c_slidy.slide_number+1) + \")\";\n     w3c_slidy.show_slide_number();\n  },\n\n  page_address: function (uri) {\n    var i = uri.indexOf(\"#\");\n\n    if (i < 0)\n      i = uri.indexOf(\"%23\");\n\n    // check if anchor is entire page\n\n    if (i < 0)\n      return uri;  // yes\n\n    return uri.substr(0, i);\n  },\n\n  // only used for IE6 and IE7\n  on_frame_loaded: function (hash) {\n    location.hash = hash;\n    var uri = w3c_slidy.page_address(location.href);\n    location.href = uri + hash;\n  },\n\n  // history hack with thanks to Bertrand Le Roy\n  push_hash: function (hash) {\n    if (hash == \"\") hash = \"#(1)\";\n      window.location.hash = hash;\n\n    var doc = document.getElementById(\"historyFrame\").contentWindow.document;\n    doc.open(\"javascript:'<html></html>'\");\n    doc.write(\"<html><head><script type=\\\"text/javascript\\\">window.parent.w3c_slidy.on_frame_loaded('\"+\n      (hash) + \"');</script></head><body>hello mum</body></html>\");\n      doc.close();\n  },\n\n  // find current slide based upon location\n  // first find target anchor and then look\n  // for associated div element enclosing it\n  // finally map that to slide number\n  find_slide_number: function (uri) {\n    // first get anchor from page location\n\n    var i = uri.indexOf(\"#\");\n\n    // check if anchor is entire page\n    if (i < 0)\n      return 0;  // yes\n\n    var anchor = unescape(uri.substr(i+1));\n\n    // now use anchor as XML ID to find target\n    var target = document.getElementById(anchor);\n\n    if (!target)\n    {\n      // does anchor look like \"(2)\" for slide 2 ??\n      // where first slide is (1)\n      var re = /\\((\\d)+\\)/;\n\n      if (anchor.match(re))\n      {\n        var num = parseInt(anchor.substring(1, anchor.length-1));\n\n        if (num > this.slides.length)\n          num = 1;\n\n        if (--num < 0)\n          num = 0;\n\n        return num;\n      }\n\n      // accept [2] for backwards compatibility\n      re = /\\[(\\d)+\\]/;\n\n      if (anchor.match(re))\n      {\n         var num = parseInt(anchor.substring(1, anchor.length-1));\n\n         if (num > this.slides.length)\n            num = 1;\n\n         if (--num < 0)\n            num = 0;\n\n         return num;\n      }\n\n      // oh dear unknown anchor\n      return 0;\n    }\n\n    // search for enclosing slide\n\n    while (true)\n    {\n      // browser coerces html elements to uppercase!\n      if (target.nodeName.toLowerCase() == \"div\" &&\n            this.has_class(target, \"slide\"))\n      {\n        // found the slide element\n        break;\n      }\n\n      // otherwise try parent element if any\n\n      target = target.parentNode;\n\n      if (!target)\n      {\n        return 0;   // no luck!\n      }\n    };\n\n    for (i = 0; i < slides.length; ++i)\n    {\n      if (slides[i] == target)\n        return i;  // success\n    }\n\n    // oh dear still no luck\n    return 0;\n  },\n\n  previous_slide: function (incremental) {\n    if (!w3c_slidy.view_all)\n    {\n      var slide;\n\n      if ((incremental || w3c_slidy.slide_number == 0) && w3c_slidy.last_shown != null)\n      {\n        w3c_slidy.last_shown = w3c_slidy.hide_previous_item(w3c_slidy.last_shown);\n        w3c_slidy.set_eos_status(false);\n      }\n      else if (w3c_slidy.slide_number > 0)\n      {\n        slide = w3c_slidy.slides[w3c_slidy.slide_number];\n        w3c_slidy.hide_slide(slide);\n\n        w3c_slidy.slide_number = w3c_slidy.slide_number - 1;\n        slide = w3c_slidy.slides[w3c_slidy.slide_number];\n        w3c_slidy.set_visibility_all_incremental(\"visible\");\n        w3c_slidy.last_shown = w3c_slidy.previous_incremental_item(null);\n        w3c_slidy.set_eos_status(true);\n        w3c_slidy.show_slide(slide);\n      }\n\n      w3c_slidy.set_location();\n\n      if (!w3c_slidy.ns_pos)\n        w3c_slidy.refresh_toolbar(200);\n    }\n  },\n\n  next_slide: function (incremental) {\n    if (!w3c_slidy.view_all)\n    {\n      var slide, last = w3c_slidy.last_shown;\n\n      if (incremental || w3c_slidy.slide_number == w3c_slidy.slides.length - 1)\n         w3c_slidy.last_shown = w3c_slidy.reveal_next_item(w3c_slidy.last_shown);\n\n      if ((!incremental || w3c_slidy.last_shown == null) &&\n             w3c_slidy.slide_number < w3c_slidy.slides.length - 1)\n      {\n         slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.hide_slide(slide);\n\n         w3c_slidy.slide_number = w3c_slidy.slide_number + 1;\n         slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.last_shown = null;\n         w3c_slidy.set_visibility_all_incremental(\"hidden\");\n         w3c_slidy.show_slide(slide);\n      }\n      else if (!w3c_slidy.last_shown)\n      {\n         if (last && incremental)\n           w3c_slidy.last_shown = last;\n      }\n\n      w3c_slidy.set_location();\n\n      w3c_slidy.set_eos_status(!w3c_slidy.next_incremental_item(w3c_slidy.last_shown));\n\n      if (!w3c_slidy.ns_pos)\n         w3c_slidy.refresh_toolbar(200);\n     }\n  },\n\n  // to first slide with nothing revealed\n  // i.e. state at start of presentation\n  first_slide: function () {\n     if (!w3c_slidy.view_all)\n     {\n       var slide;\n\n       if (w3c_slidy.slide_number != 0)\n       {\n         slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.hide_slide(slide);\n\n         w3c_slidy.slide_number = 0;\n         slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.last_shown = null;\n         w3c_slidy.set_visibility_all_incremental(\"hidden\");\n         w3c_slidy.show_slide(slide);\n       }\n\n       w3c_slidy.set_eos_status(\n         !w3c_slidy.next_incremental_item(w3c_slidy.last_shown));\n       w3c_slidy.set_location();\n     }\n  },\n\n  // goto last slide with everything revealed\n  // i.e. state at end of presentation\n  last_slide: function () {\n    if (!w3c_slidy.view_all)\n    {\n      var slide;\n\n      w3c_slidy.last_shown = null; //revealNextItem(lastShown);\n\n      if (w3c_slidy.last_shown == null &&\n          w3c_slidy.slide_number < w3c_slidy.slides.length - 1)\n      {\n         slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.hide_slide(slide);\n         w3c_slidy.slide_number = w3c_slidy.slides.length - 1;\n         slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.set_visibility_all_incremental(\"visible\");\n         w3c_slidy.last_shown = w3c_slidy.previous_incremental_item(null);\n\n         w3c_slidy.show_slide(slide);\n      }\n      else\n      {\n         w3c_slidy.set_visibility_all_incremental(\"visible\");\n         w3c_slidy.last_shown = w3c_slidy.previous_incremental_item(null);\n      }\n\n      w3c_slidy.set_eos_status(true);\n      w3c_slidy.set_location();\n    }\n  },\n\n\n  // ### check this and consider add/remove class\n  set_eos_status: function (state) {\n    if (this.eos)\n      this.eos.style.color = (state ? \"rgb(240,240,240)\" : \"red\");\n  },\n\n  // first slide is 0\n  goto_slide: function (num) {\n    //alert(\"going to slide \" + (num+1));\n    var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n    w3c_slidy.hide_slide(slide);\n    w3c_slidy.slide_number = num;\n    slide = w3c_slidy.slides[w3c_slidy.slide_number];\n    w3c_slidy.last_shown = null;\n    w3c_slidy.set_visibility_all_incremental(\"hidden\");\n    w3c_slidy.set_eos_status(!w3c_slidy.next_incremental_item(w3c_slidy.last_shown));\n    document.title = w3c_slidy.title + \" (\" + (w3c_slidy.slide_number+1) + \")\";\n    w3c_slidy.show_slide(slide);\n    w3c_slidy.show_slide_number();\n  },\n\n\n  show_slide: function (slide) {\n    this.sync_background(slide);\n    this.remove_class(slide, \"hidden\");\n\n    // work around IE9 object rendering bug\n    setTimeout(\"window.scrollTo(0,0);\", 1);\n  },\n\n  hide_slide: function (slide) {\n    this.add_class(slide, \"hidden\");\n  },\n\n  // show just the backgrounds pertinent to this slide\n  // when slide background-color is transparent\n  // this should now work with rgba color values\n  sync_background: function (slide) {\n    var background;\n    var bgColor;\n\n    if (slide.currentStyle)\n      bgColor = slide.currentStyle[\"backgroundColor\"];\n    else if (document.defaultView)\n    {\n      var styles = document.defaultView.getComputedStyle(slide,null);\n\n      if (styles)\n        bgColor = styles.getPropertyValue(\"background-color\");\n      else // broken implementation probably due Safari or Konqueror\n      {\n        //alert(\"defective implementation of getComputedStyle()\");\n        bgColor = \"transparent\";\n      }\n    }\n    else\n      bgColor == \"transparent\";\n\n    if (bgColor == \"transparent\" ||\n        bgColor.indexOf(\"rgba\") >= 0 ||\n        bgColor.indexOf(\"opacity\") >= 0)\n    {\n      var slideClass = this.get_class_list(slide);\n\n      for (var i = 0; i < this.backgrounds.length; i++)\n      {\n        background = this.backgrounds[i];\n\n        var bgClass = this.get_class_list(background);\n\n        if (this.matching_background(slideClass, bgClass))\n          this.remove_class(background, \"hidden\");\n        else\n          this.add_class(background, \"hidden\");\n      }\n    }\n    else // forcibly hide all backgrounds\n      this.hide_backgrounds();\n  },\n\n  hide_backgrounds: function () {\n    for (var i = 0; i < this.backgrounds.length; i++)\n    {\n      background = this.backgrounds[i];\n      this.add_class(background, \"hidden\");\n    }\n  },\n\n  // compare classes for slide and background\n  matching_background: function (slideClass, bgClass) {\n    var i, count, pattern, result;\n\n    // define pattern as regular expression\n    pattern = /\\w+/g;\n\n    // check background class names\n    result = bgClass.match(pattern);\n\n    for (i = count = 0; i < result.length; i++)\n    {\n      if (result[i] == \"hidden\")\n        continue;\n\n      if (result[i] == \"background\")\n\tcontinue;\n\n      ++count;\n    }\n\n    if (count == 0)  // default match\n      return true;\n\n    // check for matches and place result in array\n    result = slideClass.match(pattern);\n\n    // now check if desired name is present for background\n    for (i = count = 0; i < result.length; i++)\n    {\n      if (result[i] == \"hidden\")\n        continue;\n\n      if (this.has_token(bgClass, result[i]))\n        return true;\n    }\n\n    return false;\n  },\n\n  resized: function () {\n     var width = 0;\n\n     if ( typeof( window.innerWidth ) == 'number' )\n       width = window.innerWidth;  // Non IE browser\n     else if (document.documentElement && document.documentElement.clientWidth)\n       width = document.documentElement.clientWidth;  // IE6\n     else if (document.body && document.body.clientWidth)\n       width = document.body.clientWidth; // IE4\n\n     var height = 0;\n\n     if ( typeof( window.innerHeight ) == 'number' )\n       height = window.innerHeight;  // Non IE browser\n     else if (document.documentElement && document.documentElement.clientHeight)\n       height = document.documentElement.clientHeight;  // IE6\n     else if (document.body && document.body.clientHeight)\n       height = document.body.clientHeight; // IE4\n\n     if (height && (width/height > 1.05*1024/768))\n     {\n       width = height * 1024.0/768;\n     }\n\n     // IE fires onresize even when only font size is changed!\n     // so we do a check to avoid blocking < and > actions\n     if (width != w3c_slidy.last_width || height != w3c_slidy.last_height)\n     {\n       if (width >= 1100)\n         w3c_slidy.size_index = 5;    // 4\n       else if (width >= 1000)\n         w3c_slidy.size_index = 4;    // 3\n       else if (width >= 800)\n         w3c_slidy.size_index = 3;    // 2\n       else if (width >= 600)\n         w3c_slidy.size_index = 2;    // 1\n       else if (width)\n         w3c_slidy.size_index = 0;\n\n       // add in font size adjustment from meta element e.g.\n       // <meta name=\"font-size-adjustment\" content=\"-2\" />\n       // useful when slides have too much content ;-)\n\n       if (0 <= w3c_slidy.size_index + w3c_slidy.size_adjustment &&\n             w3c_slidy.size_index + w3c_slidy.size_adjustment < w3c_slidy.sizes.length)\n         w3c_slidy.size_index = w3c_slidy.size_index + w3c_slidy.size_adjustment;\n\n       // enables cross browser use of relative width/height\n       // on object elements for use with SVG and Flash media\n       w3c_slidy.adjust_object_dimensions(width, height);\n\n       if (document.body.style.fontSize != w3c_slidy.sizes[w3c_slidy.size_index])\n       {\n         document.body.style.fontSize = w3c_slidy.sizes[w3c_slidy.size_index];\n       }\n\n       w3c_slidy.last_width = width;\n       w3c_slidy.last_height = height;\n\n       // force reflow to work around Mozilla bug\n       if (w3c_slidy.ns_pos)\n       {\n         var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n         w3c_slidy.hide_slide(slide);\n         w3c_slidy.show_slide(slide);\n       }\n\n       // force correct positioning of toolbar\n       w3c_slidy.refresh_toolbar(200);\n     }\n  },\n\n  scrolled: function () {\n    if (w3c_slidy.toolbar && !w3c_slidy.ns_pos && !w3c_slidy.ie7)\n    {\n      w3c_slidy.hack_offset = w3c_slidy.scroll_x_offset();\n      // hide toolbar\n      w3c_slidy.toolbar.style.display = \"none\";\n\n      // make it reappear later\n      if (w3c_slidy.scrollhack == 0 && !w3c_slidy.view_all)\n      {\n        setTimeout(function () {w3c_slidy.show_toolbar(); }, 1000);\n        w3c_slidy.scrollhack = 1;\n      }\n    }\n  },\n\n  hide_toolbar: function () {\n    w3c_slidy.add_class(w3c_slidy.toolbar, \"hidden\");\n    window.focus();\n  },\n\n  // used to ensure IE refreshes toolbar in correct position\n  refresh_toolbar: function (interval) {\n    if (!w3c_slidy.ns_pos && !w3c_slidy.ie7)\n    {\n      w3c_slidy.hide_toolbar();\n      setTimeout(function () {w3c_slidy.show_toolbar();}, interval);\n    }\n  },\n\n  // restores toolbar after short delay\n  show_toolbar: function () {\n    if (w3c_slidy.want_toolbar)\n    {\n      w3c_slidy.toolbar.style.display = \"block\";\n\n      if (!w3c_slidy.ns_pos)\n      {\n        // adjust position to allow for scrolling\n        var xoffset = w3c_slidy.scroll_x_offset();\n        w3c_slidy.toolbar.style.left = xoffset;\n        w3c_slidy.toolbar.style.right = xoffset;\n\n        // determine vertical scroll offset\n        //var yoffset = scrollYOffset();\n\n        // bottom is doc height - window height - scroll offset\n        //var bottom = documentHeight() - lastHeight - yoffset\n\n        //if (yoffset > 0 || documentHeight() > lastHeight)\n        //   bottom += 16;  // allow for height of scrollbar\n\n        w3c_slidy.toolbar.style.bottom = 0; //bottom;\n      }\n\n      w3c_slidy.remove_class(w3c_slidy.toolbar, \"hidden\");\n    }\n\n    w3c_slidy.scrollhack = 0;\n\n\n    // set the keyboard focus to the help link on the\n    // toolbar to ensure that document has the focus\n    // IE doesn't always work with window.focus()\n    // and this hack has benefit of Enter for help\n\n    try\n    {\n      if (!w3c_slidy.opera)\n        w3c_slidy.help_anchor.focus();\n    }\n    catch (e)\n    {\n    }\n  },\n\n// invoked via F key\n  toggle_toolbar: function () {\n    if (!w3c_slidy.view_all)\n    {\n      if (w3c_slidy.has_class(w3c_slidy.toolbar, \"hidden\"))\n      {\n        w3c_slidy.remove_class(w3c_slidy.toolbar, \"hidden\")\n        w3c_slidy.want_toolbar = 1;\n      }\n      else\n      {\n        w3c_slidy.add_class(w3c_slidy.toolbar, \"hidden\")\n        w3c_slidy.want_toolbar = 0;\n      }\n    }\n  },\n\n  scroll_x_offset: function () {\n    if (window.pageXOffset)\n      return self.pageXOffset;\n\n    if (document.documentElement && \n             document.documentElement.scrollLeft)\n      return document.documentElement.scrollLeft;\n\n    if (document.body)\n      return document.body.scrollLeft;\n\n    return 0;\n  },\n\n  scroll_y_offset: function () {\n    if (window.pageYOffset)\n      return self.pageYOffset;\n\n    if (document.documentElement && \n             document.documentElement.scrollTop)\n      return document.documentElement.scrollTop;\n\n    if (document.body)\n      return document.body.scrollTop;\n\n    return 0;\n  },\n\n  // looking for a way to determine height of slide content\n  // the slide itself is set to the height of the window\n  optimize_font_size: function () {\n    var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n\n    //var dh = documentHeight(); //getDocHeight(document);\n    var dh = slide.scrollHeight;\n    var wh = getWindowHeight();\n    var u = 100 * dh / wh;\n\n    alert(\"window utilization = \" + u + \"% (doc \"\n      + dh + \" win \" + wh + \")\");\n  },\n\n  // from document object\n  get_doc_height: function (doc) {\n    if (!doc)\n      doc = document;\n\n    if (doc && doc.body && doc.body.offsetHeight)\n      return doc.body.offsetHeight;  // ns/gecko syntax\n\n    if (doc && doc.body && doc.body.scrollHeight)\n      return doc.body.scrollHeight;\n\n    alert(\"couldn't determine document height\");\n  },\n\n  get_window_height: function () {\n    if ( typeof( window.innerHeight ) == 'number' )\n      return window.innerHeight;  // Non IE browser\n\n    if (document.documentElement && document.documentElement.clientHeight)\n      return document.documentElement.clientHeight;  // IE6\n\n    if (document.body && document.body.clientHeight)\n      return document.body.clientHeight; // IE4\n  },\n\n  document_height: function () {\n    var sh, oh;\n\n    sh = document.body.scrollHeight;\n    oh = document.body.offsetHeight;\n\n    if (sh && oh)\n    {\n      return (sh > oh ? sh : oh);\n    }\n\n    // no idea!\n    return 0;\n  },\n\n  smaller: function () {\n    if (w3c_slidy.size_index > 0)\n    {\n      --w3c_slidy.size_index;\n    }\n\n    w3c_slidy.toolbar.style.display = \"none\";\n    document.body.style.fontSize = w3c_slidy.sizes[w3c_slidy.size_index];\n    var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n    w3c_slidy.hide_slide(slide);\n    w3c_slidy.show_slide(slide);\n    setTimeout(function () {w3c_slidy.show_toolbar(); }, 50);\n  },\n\n  bigger: function () {\n    if (w3c_slidy.size_index < w3c_slidy.sizes.length - 1)\n    {\n      ++w3c_slidy.size_index;\n    }\n\n    w3c_slidy.toolbar.style.display = \"none\";\n    document.body.style.fontSize = w3c_slidy.sizes[w3c_slidy.size_index];\n    var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n    w3c_slidy.hide_slide(slide);\n    w3c_slidy.show_slide(slide);\n    setTimeout(function () {w3c_slidy.show_toolbar(); }, 50);\n  },\n\n  // enables cross browser use of relative width/height\n  // on object elements for use with SVG and Flash media\n  // with thanks to Ivan Herman for the suggestion\n  adjust_object_dimensions: function (width, height) {\n    for( var i = 0; i < w3c_slidy.objects.length; i++ )\n    {\n      var obj = this.objects[i];\n      var mimeType = obj.getAttribute(\"type\");\n\n      if (mimeType == \"image/svg+xml\" || mimeType == \"application/x-shockwave-flash\")\n      {\n        if ( !obj.initialWidth ) \n          obj.initialWidth = obj.getAttribute(\"width\");\n\n        if ( !obj.initialHeight ) \n          obj.initialHeight = obj.getAttribute(\"height\");\n\n        if ( obj.initialWidth && obj.initialWidth.charAt(obj.initialWidth.length-1) == \"%\" )\n        {\n          var w = parseInt(obj.initialWidth.slice(0, obj.initialWidth.length-1));\n          var newW = width * (w/100.0);\n          obj.setAttribute(\"width\",newW);\n        }\n\n        if ( obj.initialHeight &&\n             obj.initialHeight.charAt(obj.initialHeight.length-1) == \"%\" )\n        {\n          var h = parseInt(obj.initialHeight.slice(0, obj.initialHeight.length-1));\n          var newH = height * (h/100.0);\n          obj.setAttribute(\"height\", newH);\n        }\n      }\n    }\n  },\n\n  // needed for Opera to inhibit default behavior\n  // since Opera delivers keyPress even if keyDown\n  // was cancelled\n  key_press: function (event) {\n    if (!event)\n      event = window.event;\n\n    if (!w3c_slidy.key_wanted)\n      return w3c_slidy.cancel(event);\n\n    return true;\n  },\n\n  //  See e.g. http://www.quirksmode.org/js/events/keys.html for keycodes\n  key_down: function (event) {\n    var key, target, tag;\n\n    w3c_slidy.key_wanted = true;\n\n    if (!event)\n      event = window.event;\n\n    // kludge around NS/IE differences \n    if (window.event)\n    {\n      key = window.event.keyCode;\n      target = window.event.srcElement;\n    }\n    else if (event.which)\n    {\n      key = event.which;\n      target = event.target;\n    }\n    else\n      return true; // Yikes! unknown browser\n\n    // ignore event if key value is zero\n    // as for alt on Opera and Konqueror\n    if (!key)\n       return true;\n\n    // avoid interfering with keystroke\n    // behavior for non-slidy chrome elements\n    if (!w3c_slidy.slidy_chrome(target) &&\n        w3c_slidy.special_element(target))\n      return true;\n\n    // check for concurrent control/command/alt key\n    // but are these only present on mouse events?\n\n    if (event.ctrlKey || event.altKey || event.metaKey)\n       return true;\n\n    // dismiss table of contents if visible\n    if (w3c_slidy.is_shown_toc() && key != 9 && key != 16 && key != 38 && key != 40)\n    {\n      w3c_slidy.hide_table_of_contents(true);\n\n      if (key == 27 || key == 84 || key == 67)\n        return w3c_slidy.cancel(event);\n    }\n\n    if (key == 34) // Page Down\n    {\n      if (w3c_slidy.view_all)\n        return true;\n\n      w3c_slidy.next_slide(false);\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 33) // Page Up\n    {\n      if (w3c_slidy.view_all)\n        return true;\n\n      w3c_slidy.previous_slide(false);\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 32) // space bar\n    {\n      w3c_slidy.next_slide(true);\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 37) // Left arrow\n    {\n      w3c_slidy.previous_slide(!event.shiftKey);\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 36) // Home\n    {\n      w3c_slidy.first_slide();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 35) // End\n    {\n      w3c_slidy.last_slide();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 39) // Right arrow\n    {\n      w3c_slidy.next_slide(!event.shiftKey);\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 13) // Enter\n    {\n      if (w3c_slidy.outline)\n      {\n        if (w3c_slidy.outline.visible)\n          w3c_slidy.fold(w3c_slidy.outline);\n        else\n          w3c_slidy.unfold(w3c_slidy.outline);\n          \n       return w3c_slidy.cancel(event);\n      }\n    }\n    else if (key == 188)  // < for smaller fonts\n    {\n      w3c_slidy.smaller();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 190)  // > for larger fonts\n    {\n      w3c_slidy.bigger();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 189 || key == 109)  // - for smaller fonts\n    {\n      w3c_slidy.smaller();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 187 || key == 191 || key == 107)  // = +  for larger fonts\n    {\n      w3c_slidy.bigger();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 83)  // S for smaller fonts\n    {\n      w3c_slidy.smaller();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 66)  // B for larger fonts\n    {\n      w3c_slidy.bigger();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 90)  // Z for last slide\n    {\n      w3c_slidy.last_slide();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 70)  // F for toggle toolbar\n    {\n      w3c_slidy.toggle_toolbar();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 65)  // A for toggle view single/all slides\n    {\n      w3c_slidy.toggle_view();\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 75)  // toggle action of left click for next page\n    {\n      w3c_slidy.mouse_click_enabled = !w3c_slidy.mouse_click_enabled;\n      var alert_msg = (w3c_slidy.mouse_click_enabled ?\n                \"enabled\" : \"disabled\") +  \" mouse click advance\";\n\n      alert(w3c_slidy.localize(alert_msg));\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 84 || key == 67)  // T or C for table of contents\n    {\n      if (w3c_slidy.toc)\n        w3c_slidy.toggle_table_of_contents();\n\n      return w3c_slidy.cancel(event);\n    }\n    else if (key == 72) // H for help\n    {\n      window.location = w3c_slidy.help_page;\n      return w3c_slidy.cancel(event);\n    }\n    //else alert(\"key code is \"+ key);\n\n    return true;\n  },\n\n  // safe for both text/html and application/xhtml+xml\n  create_element: function (name) {\n    if (this.xhtml && (typeof document.createElementNS != 'undefined'))\n      return document.createElementNS(\"http://www.w3.org/1999/xhtml\", name)\n\n    return document.createElement(name);\n  },\n\n  get_element_style: function (elem, IEStyleProp, CSSStyleProp) {\n    if (elem.currentStyle)\n    {\n      return elem.currentStyle[IEStyleProp];\n    }\n    else if (window.getComputedStyle)\n    {\n      var compStyle = window.getComputedStyle(elem, \"\");\n      return compStyle.getPropertyValue(CSSStyleProp);\n    }\n    return \"\";\n  },\n\n  // the string str is a whitespace separated list of tokens\n  // test if str contains a particular token, e.g. \"slide\"\n  has_token: function (str, token) {\n    if (str)\n    {\n      // define pattern as regular expression\n      var pattern = /\\w+/g;\n\n      // check for matches\n      // place result in array\n      var result = str.match(pattern);\n\n      // now check if desired token is present\n      for (var i = 0; i < result.length; i++)\n      {\n        if (result[i] == token)\n          return true;\n      }\n    }\n\n    return false;\n  },\n\n  get_class_list: function (element) {\n    if (typeof element.className != 'undefined')\n      return element.className;\n\n    return element.getAttribute(\"class\");\n  },\n\n  has_class: function (element, name) {\n    if (element.nodeType != 1)\n      return false;\n\n    var regexp = new RegExp(\"(^| )\" + name + \"\\W*\");\n\n    if (typeof element.className != 'undefined')\n      return regexp.test(element.className);\n\n    return regexp.test(element.getAttribute(\"class\"));\n  },\n\n  remove_class: function (element, name) {\n    var regexp = new RegExp(\"(^| )\" + name + \"\\W*\");\n    var clsval = \"\";\n\n    if (typeof element.className != 'undefined')\n    {\n      clsval = element.className;\n\n      if (clsval)\n      {\n        clsval = clsval.replace(regexp, \"\");\n        element.className = clsval;\n      }\n    }\n    else\n    {\n      clsval = element.getAttribute(\"class\");\n\n      if (clsval)\n      {\n        clsval = clsval.replace(regexp, \"\");\n        element.setAttribute(\"class\", clsval);\n      }\n    }\n  },\n\n  add_class: function (element, name) {\n    if (!this.has_class(element, name))\n    {\n      if (typeof element.className != 'undefined')\n        element.className += \" \" + name;\n      else\n      {\n        var clsval = element.getAttribute(\"class\");\n        clsval = clsval ? clsval + \" \" + name : name;\n        element.setAttribute(\"class\", clsval);\n      }\n    }\n  },\n\n  // HTML elements that can be used with class=\"incremental\"\n  // note that you can also put the class on containers like\n  // up, ol, dl, and div to make their contents appear\n  // incrementally. Upper case is used since this is what\n  // browsers report for HTML node names (text/html).\n  incremental_elements: null,\n  okay_for_incremental: function (name) {\n    if (!this.incremental_elements)\n    {\n      var inclist = new Array();\n      inclist[\"p\"] = true;\n      inclist[\"pre\"] = true;\n      inclist[\"li\"] = true;\n      inclist[\"blockquote\"] = true;\n      inclist[\"dt\"] = true;\n      inclist[\"dd\"] = true;\n      inclist[\"h2\"] = true;\n      inclist[\"h3\"] = true;\n      inclist[\"h4\"] = true;\n      inclist[\"h5\"] = true;\n      inclist[\"h6\"] = true;\n      inclist[\"span\"] = true;\n      inclist[\"address\"] = true;\n      inclist[\"table\"] = true;\n      inclist[\"tr\"] = true;\n      inclist[\"th\"] = true;\n      inclist[\"td\"] = true;\n      inclist[\"img\"] = true;\n      inclist[\"object\"] = true;\n      this.incremental_elements = inclist;\n    }\n    return this.incremental_elements[name.toLowerCase()];\n  },\n\n  next_incremental_item: function (node) {\n    var br = this.is_xhtml ? \"br\" : \"BR\";\n    var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n\n    for (;;)\n    {\n      node = w3c_slidy.next_node(slide, node);\n\n      if (node == null || node.parentNode == null)\n        break;\n\n      if (node.nodeType == 1)  // ELEMENT\n      {\n        if (node.nodeName == br)\n          continue;\n\n        if (w3c_slidy.has_class(node, \"incremental\")\n             && w3c_slidy.okay_for_incremental(node.nodeName))\n          return node;\n\n        if (w3c_slidy.has_class(node.parentNode, \"incremental\")\n             && !w3c_slidy.has_class(node, \"non-incremental\"))\n          return node;\n      }\n    }\n\n    return node;\n  },\n\n  previous_incremental_item: function (node) {\n    var br = this.is_xhtml ? \"br\" : \"BR\";\n    var slide = w3c_slidy.slides[w3c_slidy.slide_number];\n\n    for (;;)\n    {\n      node = w3c_slidy.previous_node(slide, node);\n\n      if (node == null || node.parentNode == null)\n        break;\n\n      if (node.nodeType == 1)\n      {\n        if (node.nodeName == br)\n          continue;\n\n        if (w3c_slidy.has_class(node, \"incremental\")\n             && w3c_slidy.okay_for_incremental(node.nodeName))\n          return node;\n\n        if (w3c_slidy.has_class(node.parentNode, \"incremental\")\n             && !w3c_slidy.has_class(node, \"non-incremental\"))\n          return node;\n      }\n    }\n\n    return node;\n  },\n\n  // set visibility for all elements on current slide with\n  // a parent element with attribute class=\"incremental\"\n  set_visibility_all_incremental: function (value) {\n    var node = this.next_incremental_item(null);\n\n    if (value == \"hidden\")\n    {\n      while (node)\n      {\n        w3c_slidy.add_class(node, \"invisible\");\n        node = w3c_slidy.next_incremental_item(node);\n      }\n    }\n    else // value == \"visible\"\n    {\n      while (node)\n      {\n        w3c_slidy.remove_class(node, \"invisible\");\n        node = w3c_slidy.next_incremental_item(node);\n      }\n    }\n  },\n\n  // reveal the next hidden item on the slide\n  // node is null or the node that was last revealed\n  reveal_next_item: function (node) {\n    node = w3c_slidy.next_incremental_item(node);\n\n    if (node && node.nodeType == 1)  // an element\n      w3c_slidy.remove_class(node, \"invisible\");\n\n    return node;\n  },\n\n  // exact inverse of revealNextItem(node)\n  hide_previous_item: function (node) {\n    if (node && node.nodeType == 1)  // an element\n      w3c_slidy.add_class(node, \"invisible\");\n\n    return this.previous_incremental_item(node);\n  },\n\n  // left to right traversal of root's content\n  next_node: function (root, node) {\n    if (node == null)\n      return root.firstChild;\n\n    if (node.firstChild)\n      return node.firstChild;\n\n    if (node.nextSibling)\n      return node.nextSibling;\n\n    for (;;)\n    {\n      node = node.parentNode;\n\n      if (!node || node == root)\n        break;\n\n      if (node && node.nextSibling)\n        return node.nextSibling;\n    }\n\n    return null;\n  },\n\n  // right to left traversal of root's content\n  previous_node: function (root, node) {\n    if (node == null)\n    {\n      node = root.lastChild;\n\n      if (node)\n      {\n        while (node.lastChild)\n          node = node.lastChild;\n      }\n\n      return node;\n    }\n\n    if (node.previousSibling)\n    {\n      node = node.previousSibling;\n\n      while (node.lastChild)\n        node = node.lastChild;\n\n      return node;\n    }\n\n    if (node.parentNode != root)\n      return node.parentNode;\n\n    return null;\n  },\n\n  previous_sibling_element: function (el) {\n    el = el.previousSibling;\n\n    while (el && el.nodeType != 1)\n      el = el.previousSibling;\n\n    return el;\n  },\n\n  next_sibling_element: function (el) {\n    el = el.nextSibling;\n\n    while (el && el.nodeType != 1)\n      el = el.nextSibling;\n\n    return el;\n  },\n\n  first_child_element: function (el) {\n    var node;\n\n    for (node = el.firstChild; node; node = node.nextSibling)\n    {\n      if (node.nodeType == 1)\n        break;\n    }\n\n    return node;\n  },\n\n  first_tag: function (element, tag) {\n    var node;\n\n    if (!this.is_xhtml)\n      tag = tag.toUpperCase();\n\n    for (node = element.firstChild; node; node = node.nextSibling)\n    {\n      if (node.nodeType == 1 && node.nodeName == tag)\n        break;\n    }\n\n    return node;\n  },\n\n  hide_selection: function () {\n    if (window.getSelection) // Firefox, Chromium, Safari, Opera\n    {\n      var selection = window.getSelection();\n\n      if (selection.rangeCount > 0)\n      {\n        var range = selection.getRangeAt(0);\n        range.collapse (false);\n      }\n    }\n    else // Internet Explorer\n    {\n      var textRange = document.selection.createRange ();\n      textRange.collapse (false);\n    }\n  },\n\n  get_selected_text: function () {\n    try\n    {\n      if (window.getSelection)\n        return window.getSelection().toString();\n\n      if (document.getSelection)\n        return document.getSelection().toString();\n\n      if (document.selection)\n        return document.selection.createRange().text;\n    }\n    catch (e)\n    {\n    }\n\n    return \"\";\n  },\n\n  // make note of length of selected text\n  // as this evaluates to zero in click event\n  mouse_button_up: function (e) {\n    w3c_slidy.selected_text_len = w3c_slidy.get_selected_text().length;\n  },\n\n  mouse_button_down: function (e) {\n    w3c_slidy.selected_text_len = w3c_slidy.get_selected_text().length;\n    w3c_slidy.mouse_x = e.clientX;\n    w3c_slidy.mouse_y = e.clientY;\n  },\n\n  // right mouse button click is reserved for context menus\n  // it is more reliable to detect rightclick than leftclick\n  mouse_button_click: function (e) {\n    if (!e)\n      var e = window.event;\n\n    if (Math.abs(e.clientX -w3c_slidy.mouse_x) +\n        Math.abs(e.clientY -w3c_slidy.mouse_y) > 10)\n      return true;\n\n    if (w3c_slidy.selected_text_len > 0)\n      return true;\n\n    var rightclick = false;\n    var leftclick = false;\n    var middleclick = false;\n    var target;\n\n    if (!e)\n      var e = window.event;\n\n    if (e.target)\n      target = e.target;\n    else if (e.srcElement)\n      target = e.srcElement;\n\n    // work around Safari bug\n    if (target.nodeType == 3)\n      target = target.parentNode;\n\n    if (e.which) // all browsers except IE\n    {\n      leftclick = (e.which == 1);\n      middleclick = (e.which == 2);\n      rightclick = (e.which == 3);\n    }\n    else if (e.button)\n    {\n      // Konqueror gives 1 for left, 4 for middle\n      // IE6 gives 0 for left and not 1 as I expected\n\n      if (e.button == 4)\n        middleclick = true;\n\n      // all browsers agree on 2 for right button\n      rightclick = (e.button == 2);\n    }\n    else\n      leftclick = true;\n\n    if (w3c_slidy.selected_text_len > 0)\n    {\n      w3c_slidy.stop_propagation(e);\n      e.cancel = true;\n      e.returnValue = false;\n      return false;\n    }\n\n    // dismiss table of contents\n    w3c_slidy.hide_table_of_contents(false);\n\n    // check if target is something that probably want's clicks\n    // e.g. a, embed, object, input, textarea, select, option\n    var tag = target.nodeName.toLowerCase();\n\n    if (w3c_slidy.mouse_click_enabled && leftclick &&\n        !w3c_slidy.special_element(target) &&\n        !target.onclick)\n    {\n      w3c_slidy.next_slide(true);\n      w3c_slidy.stop_propagation(e);\n      e.cancel = true;\n      e.returnValue = false;\n      return false;\n    }\n\n    return true;\n  },\n\n  special_element: function (element) {\n    if (this.has_class(element, \"non-interactive\"))\n      return false;\n\n    var tag = element.nodeName.toLowerCase();\n\n    return element.onkeydown ||\n      element.onclick ||\n      tag == \"a\" ||\n      tag == \"embed\" ||\n      tag == \"object\" ||\n      tag == \"video\" ||\n      tag == \"audio\" ||\n      tag == \"svg\" ||\n      tag == \"canvas\" ||\n      tag == \"input\" ||\n      tag == \"textarea\" ||\n      tag == \"select\" ||\n      tag == \"option\";\n  },\n\n  slidy_chrome: function (el) {\n    while (el)\n    {\n      if (el == w3c_slidy.toc ||\n          el == w3c_slidy.toolbar ||\n          w3c_slidy.has_class(el, \"outline\"))\n        return true;\n\n      el = el.parentNode;\n    }\n\n    return false;\n  },\n\n  get_key: function (e)\n  {\n    var key;\n\n    // kludge around NS/IE differences \n    if (typeof window.event != \"undefined\")\n      key = window.event.keyCode;\n    else if (e.which)\n      key = e.which;\n\n    return key;\n  },\n\n  get_target: function (e) {\n    var target;\n\n    if (!e)\n      e = window.event;\n\n    if (e.target)\n      target = e.target;\n    else if (e.srcElement)\n      target = e.srcElement;\n\n    if (target.nodeType != 1)\n      target = target.parentNode;\n\n    return target;\n  },\n\n  // does display property provide correct defaults?\n  is_block: function (elem) {\n    var tag = elem.nodeName.toLowerCase();\n\n    return tag == \"ol\" || tag == \"ul\" || tag == \"p\" ||\n           tag == \"li\" || tag == \"table\" || tag == \"pre\" ||\n           tag == \"h1\" || tag == \"h2\" || tag == \"h3\" ||\n           tag == \"h4\" || tag == \"h5\" || tag == \"h6\" ||\n           tag == \"blockquote\" || tag == \"address\"; \n  },\n\n  add_listener: function (element, event, handler) {\n    if (window.addEventListener)\n      element.addEventListener(event, handler, false);\n    else\n      element.attachEvent(\"on\"+event, handler);\n  },\n\n  // used to prevent event propagation from field controls\n  stop_propagation: function (event) {\n    event = event ? event : window.event;\n    event.cancelBubble = true;  // for IE\n\n    if (event.stopPropagation)\n      event.stopPropagation();\n\n    return true;\n  },\n\n  cancel: function (event) {\n    if (event)\n    {\n       event.cancel = true;\n       event.returnValue = false;\n\n      if (event.preventDefault)\n        event.preventDefault();\n    }\n\n    w3c_slidy.key_wanted = false;\n    return false;\n  },\n\n// for each language define an associative array\n// and also the help text which is longer\n\n  strings_es: {\n    \"slide\":\"p\195\161g.\",\n    \"help?\":\"Ayuda\",\n    \"contents?\":\"\195\141ndice\",\n    \"table of contents\":\"tabla de contenidos\",\n    \"Table of Contents\":\"Tabla de Contenidos\",\n    \"restart presentation\":\"Reiniciar presentaci\195\179n\",\n    \"restart?\":\"Inicio\"\n  },\n  help_es:\n    \"Utilice el rat\195\179n, barra espaciadora, teclas Izda/Dcha, \" +\n    \"o Re p\195\161g y Av p\195\161g. Use S y B para cambiar el tama\195\177o de fuente.\",\n\n  strings_ca: {\n    \"slide\":\"p\195\160g..\",\n    \"help?\":\"Ajuda\",\n    \"contents?\":\"\195\141ndex\",\n    \"table of contents\":\"taula de continguts\",\n    \"Table of Contents\":\"Taula de Continguts\",\n    \"restart presentation\":\"Reiniciar presentaci\195\179\",\n    \"restart?\":\"Inici\"\n  },\n  help_ca:\n    \"Utilitzi el ratol\195\173, barra espaiadora, tecles Esq./Dta. \" +\n    \"o Re p\195\160g y Av p\195\160g. Usi S i B per canviar grand\195\160ria de font.\",\n\n  strings_cs: {\n    \"slide\":\"sn\195\173mek\",\n    \"help?\":\"n\195\161pov\196\155da\",\n    \"contents?\":\"obsah\",\n    \"table of contents\":\"obsah prezentace\",\n    \"Table of Contents\":\"Obsah prezentace\",\n    \"restart presentation\":\"znovu spustit prezentaci\",\n    \"restart?\":\"restart\"\n  },\n  help_cs:\n    \"Prezentaci m\197\175\197\190ete proch\195\161zet pomoc\195\173 kliknut\195\173 my\197\161i, mezern\195\173ku, \" +\n    \"\197\161ipek vlevo a vpravo nebo kl\195\161ves PageUp a PageDown. P\195\173smo se \" +\n    \"d\195\161 zv\196\155t\197\161it a zmen\197\161it pomoc\195\173 kl\195\161ves B a S.\",\n\n  strings_nl: {\n    \"slide\":\"pagina\",\n    \"help?\":\"Help?\",\n    \"contents?\":\"Inhoud?\",\n    \"table of contents\":\"inhoudsopgave\",\n    \"Table of Contents\":\"Inhoudsopgave\",\n    \"restart presentation\":\"herstart presentatie\",\n    \"restart?\":\"Herstart?\"\n  },\n  help_nl:\n     \"Navigeer d.m.v. het muis, spatiebar, Links/Rechts toetsen, \" +\n     \"of PgUp en PgDn. Gebruik S en B om de karaktergrootte te veranderen.\",\n\n  strings_de: {\n    \"slide\":\"Seite\",\n    \"help?\":\"Hilfe\",\n    \"contents?\":\"\195\156bersicht\",\n    \"table of contents\":\"Inhaltsverzeichnis\",\n    \"Table of Contents\":\"Inhaltsverzeichnis\",\n    \"restart presentation\":\"Pr\195\164sentation neu starten\",\n    \"restart?\":\"Neustart\"\n  },\n  help_de:\n    \"Benutzen Sie die Maus, Leerschlag, die Cursortasten links/rechts oder \" +\n    \"Page up/Page Down zum Wechseln der Seiten und S und B f\195\188r die Schriftgr\195\182sse.\",\n\n  strings_pl: {\n    \"slide\":\"slajd\",\n    \"help?\":\"pomoc?\",\n    \"contents?\":\"spis tre\197\155ci?\",\n    \"table of contents\":\"spis tre\197\155ci\",\n    \"Table of Contents\":\"Spis Tre\197\155ci\",\n    \"restart presentation\":\"Restartuj prezentacj\196\153\",\n    \"restart?\":\"restart?\"\n  },\n  help_pl:\n    \"Zmieniaj slajdy klikaj\196\133c mysz\196\133, naciskaj\196\133c spacj\196\153, strza\197\130ki lewo/prawo\" +\n    \"lub PgUp / PgDn. U\197\188yj klawiszy S i B, aby zmieni\196\135 rozmiar czczionki.\",\n\n  strings_fr: {\n    \"slide\":\"page\",\n    \"help?\":\"Aide\",\n    \"contents?\":\"Index\",\n    \"table of contents\":\"table des mati\195\168res\",\n    \"Table of Contents\":\"Table des mati\195\168res\",\n    \"restart presentation\":\"Recommencer l'expos\195\169\",\n    \"restart?\":\"D\195\169but\"\n  },\n  help_fr:\n    \"Naviguez avec la souris, la barre d'espace, les fl\195\168ches \" +\n    \"gauche/droite ou les touches Pg Up, Pg Dn. Utilisez \" +\n    \"les touches S et B pour modifier la taille de la police.\",\n\n  strings_hu: {\n    \"slide\":\"oldal\",\n    \"help?\":\"seg\195\173ts\195\169g\",\n    \"contents?\":\"tartalom\",\n    \"table of contents\":\"tartalomjegyz\195\169k\",\n    \"Table of Contents\":\"Tartalomjegyz\195\169k\",\n    \"restart presentation\":\"bemutat\195\179 \195\186jraind\195\173t\195\161sa\",\n    \"restart?\":\"\195\186jraind\195\173t\195\161s\"\n  },\n  help_hu:\n    \"Az oldalak k\195\182zti l\195\169pked\195\169shez kattintson az eg\195\169rrel, vagy \" +\n    \"haszn\195\161lja a sz\195\179k\195\182z, a bal, vagy a jobb ny\195\173l, illetve a Page Down, \" +\n    \"Page Up billenty\197\177ket. Az S \195\169s a B billenty\197\177kkel v\195\161ltoztathatja \" +\n    \"a sz\195\182veg m\195\169ret\195\169t.\",\n\n  strings_it: {\n    \"slide\":\"pag.\",\n    \"help?\":\"Aiuto\",\n    \"contents?\":\"Indice\",\n    \"table of contents\":\"indice\",\n    \"Table of Contents\":\"Indice\",\n    \"restart presentation\":\"Ricominciare la presentazione\",\n    \"restart?\":\"Inizio\"\n  },\n  help_it:\n    \"Navigare con mouse, barra spazio, frecce sinistra/destra o \" +\n    \"PgUp e PgDn. Usare S e B per cambiare la dimensione dei caratteri.\",\n\n  strings_el: {\n    \"slide\":\"\207\131\206\181\206\187\206\175\206\180\206\177\",\n    \"help?\":\"\206\178\206\191\206\174\206\184\206\181\206\185\206\177;\",\n    \"contents?\":\"\207\128\206\181\207\129\206\185\206\181\207\135\207\140\206\188\206\181\206\189\206\177;\",\n    \"table of contents\":\"\207\128\206\175\206\189\206\177\206\186\206\177\207\130 \207\128\206\181\207\129\206\185\206\181\207\135\206\191\206\188\206\173\206\189\207\137\206\189\",\n    \"Table of Contents\":\"\206\160\206\175\206\189\206\177\206\186\206\177\207\130 \206\160\206\181\207\129\206\185\206\181\207\135\206\191\206\188\206\173\206\189\207\137\206\189\",\n    \"restart presentation\":\"\206\181\207\128\206\177\206\189\206\181\206\186\206\186\206\175\206\189\206\183\207\131\206\183 \207\128\206\177\207\129\206\191\207\133\207\131\206\175\206\177\207\131\206\183\207\130\",\n    \"restart?\":\"\206\181\207\128\206\177\206\189\206\181\206\186\206\186\206\175\206\189\206\183\207\131\206\183;\"\n  },\n  help_el:\n    \"\206\160\206\187\206\191\206\183\206\179\206\183\206\184\206\181\206\175\207\132\206\181 \206\188\206\181 \207\132\206\191 \206\186\206\187\206\175\206\186 \207\132\206\191\207\133 \207\128\206\191\206\189\207\132\206\185\206\186\206\185\206\191\207\141, \207\132\206\191 space, \207\132\206\177 \206\178\206\173\206\187\206\183 \206\177\207\129\206\185\207\131\207\132\206\181\207\129\206\172/\206\180\206\181\206\190\206\185\206\172, \" +\n    \"\206\174 Page Up \206\186\206\177\206\185 Page Down. \206\167\207\129\206\183\207\131\206\185\206\188\206\191\207\128\206\191\206\185\206\174\207\131\207\132\206\181 \207\132\206\177 \207\128\206\187\206\174\206\186\207\132\207\129\206\177 S \206\186\206\177\206\185 B \206\179\206\185\206\177 \206\189\206\177 \206\177\206\187\206\187\206\172\206\190\206\181\207\132\206\181 \" +\n    \"\207\132\206\191 \206\188\206\173\206\179\206\181\206\184\206\191\207\130 \207\132\206\183\207\130 \206\179\207\129\206\177\206\188\206\188\206\177\207\132\206\191\207\131\206\181\206\185\207\129\206\172\207\130.\",\n\n  strings_ja: {\n    \"slide\":\"\227\130\185\227\131\169\227\130\164\227\131\137\",\n    \"help?\":\"\227\131\152\227\131\171\227\131\151\",\n    \"contents?\":\"\231\155\174\230\172\161\",\n    \"table of contents\":\"\231\155\174\230\172\161\227\130\146\232\161\168\231\164\186\",\n    \"Table of Contents\":\"\231\155\174\230\172\161\",\n    \"restart presentation\":\"\230\156\128\229\136\157\227\129\139\227\130\137\229\134\141\231\148\159\",\n    \"restart?\":\"\230\156\128\229\136\157\227\129\139\227\130\137\"\n  },\n  help_ja:\n     \"\227\131\158\227\130\166\227\130\185\229\183\166\227\130\175\227\131\170\227\131\131\227\130\175 \227\131\187 \227\130\185\227\131\154\227\131\188\227\130\185 \227\131\187 \229\183\166\229\143\179\227\130\173\227\131\188 \" +\n     \"\227\129\190\227\129\159\227\129\175 Page Up \227\131\187 Page Down\227\129\167\230\147\141\228\189\156\239\188\140 S \227\131\187 B\227\129\167\227\131\149\227\130\169\227\131\179\227\131\136\227\130\181\227\130\164\227\130\186\229\164\137\230\155\180\",\n\n  strings_zh: {\n    \"slide\":\"\229\185\187\231\129\175\231\137\135\",\n    \"help?\":\"\229\184\174\229\138\169?\",\n    \"contents?\":\"\229\134\133\229\174\185?\",\n    \"table of contents\":\"\231\155\174\229\189\149\",\n    \"Table of Contents\":\"\231\155\174\229\189\149\",\n    \"restart presentation\":\"\233\135\141\230\150\176\229\144\175\229\138\168\229\177\149\231\164\186\",\n    \"restart?\":\"\233\135\141\230\150\176\229\144\175\229\138\168?\"\n  },\n  help_zh:\n    \"\231\148\168\233\188\160\230\160\135\231\130\185\229\135\187, \231\169\186\230\160\188\230\157\161, \229\183\166\229\143\179\231\174\173\229\164\180, Pg Up \229\146\140 Pg Dn \229\175\188\232\136\170. \" +\n    \"\231\148\168 S, B \230\148\185\229\143\152\229\173\151\228\189\147\229\164\167\229\176\143.\",\n\n  strings_ru: {\n    \"slide\":\"\209\129\208\187\208\176\208\185\208\180\",\n    \"help?\":\"\208\191\208\190\208\188\208\190\209\137\209\140?\",\n    \"contents?\":\"\209\129\208\190\208\180\208\181\209\128\208\182\208\176\208\189\208\184\208\181?\",\n    \"table of contents\":\"\208\190\208\179\208\187\208\176\208\178\208\187\208\181\208\189\208\184\208\181\",\n    \"Table of Contents\":\"\208\158\208\179\208\187\208\176\208\178\208\187\208\181\208\189\208\184\208\181\",\n    \"restart presentation\":\"\208\191\208\181\209\128\208\181\208\183\208\176\208\191\209\131\209\129\209\130\208\184\209\130\209\140 \208\191\209\128\208\181\208\183\208\181\208\189\209\130\208\176\209\134\208\184\209\142\",\n    \"restart?\":\"\208\191\208\181\209\128\208\181\208\183\208\176\208\191\209\131\209\129\208\186?\"\n  },\n  help_ru:\n    \"\208\159\208\181\209\128\208\181\208\188\208\181\209\137\208\176\208\185\209\130\208\181\209\129\209\140 \208\186\208\187\208\184\208\186\208\176\209\143 \208\188\209\139\209\136\208\186\208\190\208\185, \208\184\209\129\208\191\208\190\208\187\209\140\208\183\209\131\209\143 \208\186\208\187\208\176\208\178\208\184\209\136\209\131 \208\191\209\128\208\190\208\177\208\181\208\187, \209\129\209\130\209\128\208\181\208\187\208\186\208\184\" +\n    \"\208\178\208\187\208\181\208\178\208\190/\208\178\208\191\209\128\208\176\208\178\208\190 \208\184\208\187\208\184 Pg Up \208\184 Pg Dn. \208\154\208\187\208\176\208\178\208\184\209\136\208\184 S \208\184 B \208\188\208\181\208\189\209\143\209\142\209\130 \209\128\208\176\208\183\208\188\208\181\209\128 \209\136\209\128\208\184\209\132\209\130\208\176.\",\n\n  strings_sv: {\n    \"slide\":\"sida\",\n    \"help?\":\"hj\195\164lp\",\n    \"contents?\":\"inneh\195\165ll\",\n    \"table of contents\":\"inneh\195\165llsf\195\182rteckning\",\n    \"Table of Contents\":\"Inneh\195\165llsf\195\182rteckning\",\n    \"restart presentation\":\"visa presentationen fr\195\165n b\195\182rjan\",\n    \"restart?\":\"b\195\182rja om\"\n  },\n  help_sv:\n    \"Bl\195\164ddra med ett klick med v\195\164nstra musknappen, mellanslagstangenten, \" +\n    \"v\195\164nster- och h\195\182gerpiltangenterna eller tangenterna Pg Up, Pg Dn. \" +\n    \"Anv\195\164nd tangenterna S och B f\195\182r att \195\164ndra textens storlek.\",\n\n  strings: { },\n\n  localize: function (src) {\n    if (src == \"\")\n      return src;\n\n     // try full language code, e.g. en-US\n     var s, lookup = w3c_slidy.strings[w3c_slidy.lang];\n\n     if (lookup)\n     {\n       s = lookup[src];\n\n       if (s)\n        return s;\n     }\n\n     // strip country code suffix, e.g.\n     // try en if undefined for en-US\n     var lg = w3c_slidy.lang.split(\"-\");\n\n     if (lg.length > 1)\n     {\n       lookup = w3c_slidy.strings[lg[0]];\n\n       if (lookup)\n       {\n         s = lookup[src];\n\n         if (s)\n          return s;\n       }\n     }\n\n     // otherwise string as is\n     return src;\n  },\n\n  init_localization: function () {\n    var i18n = w3c_slidy;\n    var help_text = w3c_slidy.help_text;\n\n    // each such language array is declared in the localize array\n    // this is used as in  w3c_slidy.localize(\"foo\");\n    this.strings = {\n      \"es\":this.strings_es,\n      \"ca\":this.strings_ca,\n      \"cs\":this.strings_cs,\n      \"nl\":this.strings_nl,\n      \"de\":this.strings_de,\n      \"pl\":this.strings_pl,\n      \"fr\":this.strings_fr,\n      \"hu\":this.strings_hu,\n      \"it\":this.strings_it,\n      \"el\":this.strings_el,\n      \"jp\":this.strings_ja,\n      \"zh\":this.strings_zh,\n      \"ru\":this.strings_ru,\n      \"sv\":this.strings_sv\n    },\n\n    i18n.strings_es[help_text] = i18n.help_es;\n    i18n.strings_ca[help_text] = i18n.help_ca;\n    i18n.strings_cs[help_text] = i18n.help_cs;\n    i18n.strings_nl[help_text] = i18n.help_nl;\n    i18n.strings_de[help_text] = i18n.help_de;\n    i18n.strings_pl[help_text] = i18n.help_pl;\n    i18n.strings_fr[help_text] = i18n.help_fr;\n    i18n.strings_hu[help_text] = i18n.help_hu;\n    i18n.strings_it[help_text] = i18n.help_it;\n    i18n.strings_el[help_text] = i18n.help_el;\n    i18n.strings_ja[help_text] = i18n.help_ja;\n    i18n.strings_zh[help_text] = i18n.help_zh;\n    i18n.strings_ru[help_text] = i18n.help_ru;\n    i18n.strings_sv[help_text] = i18n.help_sv;\n\n    w3c_slidy.lang = document.body.parentNode.getAttribute(\"lang\");\n\n    if (!w3c_slidy.lang)\n      w3c_slidy.lang = document.body.parentNode.getAttribute(\"xml:lang\");\n\n    if (!w3c_slidy.lang)\n      w3c_slidy.lang = \"en\";\n  }\n};\n\n// hack for back button behavior\nif (w3c_slidy.ie6 || w3c_slidy.ie7)\n{\n  document.write(\"<iframe id='historyFrame' \" +\n  \"src='javascript:\\\"<html\"+\"></\"+\"html>\\\"' \" +\n  \"height='1' width='1' \" +\n  \"style='position:absolute;left:-800px'></iframe>\");\n}\n\n// attach event listeners for initialization\nw3c_slidy.set_up();\n\n// hide the slides as soon as body element is available\n// to reduce annoying screen mess before the onload event\nsetTimeout(w3c_slidy.hide_slides, 50);\n\n"),("slidy/styles/slidy.css","/* slidy.css\n\n   Copyright (c) 2005-2010 W3C (MIT, ERCIM, Keio), All Rights Reserved.\n   W3C liability, trademark, document use and software licensing\n   rules apply, see:\n\n   http://www.w3.org/Consortium/Legal/copyright-documents\n   http://www.w3.org/Consortium/Legal/copyright-software\n*/\nbody\n{\n  margin: 0 0 0 0;\n  padding: 0 0 0 0;\n  width: 100%;\n  height: 100%;\n  color: black;\n  background-color: white;\n  font-family: \"Gill Sans MT\", \"Gill Sans\", GillSans, sans-serif;\n  font-size: 14pt;\n}\n\ndiv.toolbar {\n  position: fixed; z-index: 200;\n  top: auto; bottom: 0; left: 0; right: 0;\n  height: 1.2em; text-align: right;\n  padding-left: 1em;\n  padding-right: 1em; \n  font-size: 60%;\n  color: red;\n  background-color: rgb(240,240,240);\n  border-top: solid 1px rgb(180,180,180);\n}\n\ndiv.toolbar span.copyright {\n  color: black;\n  margin-left: 0.5em;\n}\n\ndiv.initial_prompt {\n  position: absolute;\n  z-index: 1000;\n  bottom: 1.2em;\n  width: 100%;\n  background-color: rgb(200,200,200);\n  opacity: 0.35;\n  background-color: rgb(200,200,200, 0.35);\n  cursor: pointer;\n}\n\ndiv.initial_prompt p.help {\n  text-align: center;\n}\n\ndiv.initial_prompt p.close {\n  text-align: right;\n  font-style: italic;\n}\n\ndiv.slidy_toc {\n  position: absolute;\n  z-index: 300;\n  width: 60%;\n  max-width: 30em;\n  height: 30em;\n  overflow: auto;\n  top: auto;\n  right: auto;\n  left: 4em;\n  bottom: 4em;\n  padding: 1em;\n  background: rgb(240,240,240);\n  border-style: solid;\n  border-width: 2px;\n  font-size: 60%;\n}\n\ndiv.slidy_toc .toc_heading {\n  text-align: center;\n  width: 100%;\n  margin: 0;\n  margin-bottom: 1em;\n  border-bottom-style: solid;\n  border-bottom-color: rgb(180,180,180);\n  border-bottom-width: 1px;\n}\n\ndiv.slide {\n  z-index: 20;\n  margin: 0 0 0 0;\n  padding-top: 0;\n  padding-bottom: 0;\n  padding-left: 20px;\n  padding-right: 20px;\n  border-width: 0;\n  clear: both;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  line-height: 120%;\n  background-color: transparent;\n}\n\ndiv.background {\n  display: none;\n}\n\ndiv.handout {\n  margin-left: 20px;\n  margin-right: 20px;\n}\n\ndiv.slide.titlepage {\n  text-align: center;\n}\n\ndiv.slide.titlepage h1 {\n  padding-top: 10%;\n  margin-right: 0;\n}\n\ndiv.slide h1 {\n  padding-left: 0;\n  padding-right: 20pt;\n  padding-top: 4pt;\n  padding-bottom: 4pt;\n  margin-top: 0;\n  margin-left: 0;\n  margin-right: 60pt;\n  margin-bottom: 0.5em;\n  display: block; \n  font-size: 160%;\n  line-height: 1.2em;\n  background: transparent;\n}\n\ndiv.toc {\n  position: absolute;\n  top: auto;\n  bottom: 4em;\n  left: 4em;\n  right: auto;\n  width: 60%;\n  max-width: 30em;\n  height: 30em;\n  border: solid thin black;\n  padding: 1em;\n  background: rgb(240,240,240);\n  color: black;\n  z-index: 300;\n  overflow: auto;\n  display: block;\n  visibility: visible;\n}\n\ndiv.toc-heading {\n  width: 100%;\n  border-bottom: solid 1px rgb(180,180,180);\n  margin-bottom: 1em;\n  text-align: center;\n}\n\nimg {\n  image-rendering: optimize-quality;\n}\n\npre {\n font-size: 80%;\n font-weight: bold;\n line-height: 120%;\n padding-top: 0.2em;\n padding-bottom: 0.2em;\n padding-left: 1em;\n padding-right: 1em;\n border-style: solid;\n border-left-width: 1em;\n border-top-width: thin;\n border-right-width: thin;\n border-bottom-width: thin;\n border-color: #95ABD0;\n color: #00428C;\n background-color: #E4E5E7;\n}\n\nli pre { margin-left: 0; }\n\nblockquote { font-style: italic }\n\nimg { background-color: transparent }\n\np.copyright { font-size: smaller }\n\n.center { text-align: center }\n.footnote { font-size: smaller; margin-left: 2em; }\n\na img { border-width: 0; border-style: none }\n\na:visited { color: navy }\na:link { color: navy }\na:hover { color: red; text-decoration: underline }\na:active { color: red; text-decoration: underline }\n\na {text-decoration: none}\n.navbar a:link {color: white}\n.navbar a:visited {color: yellow}\n.navbar a:active {color: red}\n.navbar a:hover {color: red}\n\nul { list-style-type: square; }\nul ul { list-style-type: disc; }\nul ul ul { list-style-type: circle; }\nul ul ul ul { list-style-type: disc; }\nli { margin-left: 0.5em; margin-top: 0.5em; }\nli li { font-size: 85%; font-style: italic }\nli li li { font-size: 85%; font-style: normal }\n\ndiv dt\n{\n  margin-left: 0;\n  margin-top: 1em;\n  margin-bottom: 0.5em;\n  font-weight: bold;\n}\ndiv dd\n{\n  margin-left: 2em;\n  margin-bottom: 0.5em;\n}\n\n\np,pre,ul,ol,blockquote,h2,h3,h4,h5,h6,dl,table {\n  margin-left: 1em;\n  margin-right: 1em;\n}\n\np.subhead { font-weight: bold; margin-top: 2em; }\n\n.smaller { font-size: smaller }\n.bigger { font-size: 130% }\n\ntd,th { padding: 0.2em }\n\nul {\n  margin: 0.5em 1.5em 0.5em 1.5em;\n  padding: 0;\n}\n\nol {\n  margin: 0.5em 1.5em 0.5em 1.5em;\n  padding: 0;\n}\n\nul { list-style-type: square; }\nul ul { list-style-type: disc; }\nul ul ul { list-style-type: circle; }\nul ul ul ul { list-style-type: disc; }\n\nul li { \n  list-style: square;\n  margin: 0.1em 0em 0.6em 0;\n  padding: 0 0 0 0;\n  line-height: 140%;\n}\n\nol li { \n  margin: 0.1em 0em 0.6em 1.5em;\n  padding: 0 0 0 0px;\n  line-height: 140%;\n  list-style-type: decimal;\n}\n\nli ul li { \n  font-size: 85%; \n  font-style: italic;\n  list-style-type: disc;\n  background: transparent;\n  padding: 0 0 0 0;\n}\nli li ul li { \n  font-size: 85%; \n  font-style: normal;\n  list-style-type: circle;\n  background: transparent;\n  padding: 0 0 0 0;\n}\nli li li ul li {\n  list-style-type: disc;\n  background: transparent;\n  padding: 0 0 0 0;\n}\n\nli ol li {\n  list-style-type: decimal;\n}\n\n\nli li ol li {\n  list-style-type: decimal;\n}\n\n/*\n setting class=\"outline on ol or ul makes it behave as an\n ouline list where blocklevel content in li elements is\n hidden by default and can be expanded or collapsed with\n mouse click. Set class=\"expand\" on li to override default\n*/\n\nol.outline li:hover { cursor: pointer }\nol.outline li.nofold:hover { cursor: default }\n\nul.outline li:hover { cursor: pointer }\nul.outline li.nofold:hover { cursor: default }\n\nol.outline { list-style:decimal; }\nol.outline ol { list-style-type:lower-alpha }\n\nol.outline li.nofold {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/nofold-dim.gif) no-repeat 0px 0.5em;\n}\nol.outline li.unfolded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold-dim.gif) no-repeat 0px 0.5em;\n}\nol.outline li.folded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold-dim.gif) no-repeat 0px 0.5em;\n}\nol.outline li.unfolded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold.gif) no-repeat 0px 0.5em;\n}\nol.outline li.folded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold.gif) no-repeat 0px 0.5em;\n}\n\nul.outline li.nofold {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/nofold-dim.gif) no-repeat 0px 0.5em;\n}\nul.outline li.unfolded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold-dim.gif) no-repeat 0px 0.5em;\n}\nul.outline li.folded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold-dim.gif) no-repeat 0px 0.5em;\n}\nul.outline li.unfolded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold.gif) no-repeat 0px 0.5em;\n}\nul.outline li.folded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold.gif) no-repeat 0px 0.5em;\n}\n\n/* for slides with class \"title\" in table of contents */\na.titleslide { font-weight: bold; font-style: italic }\n\n/*\n hide images for work around for save as bug\n where browsers fail to save images used by CSS\n*/\nimg.hidden { display: none; visibility: hidden }\ndiv.initial_prompt { display: none; visibility: hidden }\n\n  div.slide {\n     visibility: visible;\n     position: inherit;\n  }\n  div.handout {\n     border-top-style: solid;\n     border-top-width: thin;\n     border-top-color: black;\n  }\n\n@media screen {\n  .hidden { display: none; visibility: visible }\n\n  div.slide.hidden { display: block; visibility: visible }\n  div.handout.hidden { display: block; visibility: visible }\n  div.background { display: none; visibility: hidden }\n  body.single_slide div.initial_prompt { display: block; visibility: visible }\n  body.single_slide div.background { display: block; visibility: visible }\n  body.single_slide div.background.hidden { display: none; visibility: hidden }\n  body.single_slide .invisible { visibility: hidden }\n  body.single_slide .hidden { display: none; visibility: hidden }\n  body.single_slide div.slide { position: absolute }\n  body.single_slide div.handout { display: none; visibility: hidden }\n}\n\n@media print {\n  .hidden { display: block; visibility: visible }\n\n  div.slide pre { font-size: 60%; padding-left: 0.5em; }\n  div.toolbar { display: none; visibility: hidden; }\n  div.slidy_toc { display: none; visibility: hidden; }\n  div.background { display: none; visibility: hidden; }\n  div.slide { page-break-before: always }\n  /* :first-child isn't reliable for print media */\n  div.slide.first-slide { page-break-before: avoid }\n}\n\n"),("templates/default.asciidoc","$if(titleblock)$\n$title$\n$for(author)$\n:author: $author$\n$endfor$\n$if(date)$\n:date: $date$\n$endif$\n$if(toc)$\n:toc:\n$endif$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.beamer","\\documentclass[$if(fontsize)$$fontsize$,$endif$$if(handout)$handout,$endif$$if(beamer)$ignorenonframetext,$endif$$for(classoption)$$classoption$$sep$,$endfor$]{$documentclass$}\n$if(theme)$\n\\usetheme{$theme$}\n$endif$\n$if(colortheme)$\n\\usecolortheme{$colortheme$}\n$endif$\n$if(fonttheme)$\n\\usefonttheme{$fonttheme$}\n$endif$\n\\usepackage{amssymb,amsmath}\n\\usepackage{ifxetex,ifluatex}\n\\usepackage{fixltx2e} % provides \\textsubscript\n\\ifxetex\n  \\usepackage{fontspec,xltxtra,xunicode}\n  \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n\\else\n  \\ifluatex\n    \\usepackage{fontspec}\n    \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n  \\else\n    \\usepackage[utf8]{inputenc}\n  \\fi\n\\fi\n$if(natbib)$\n\\usepackage{natbib}\n\\bibliographystyle{plainnat}\n$endif$\n$if(biblatex)$\n\\usepackage{biblatex}\n$if(biblio-files)$\n\\bibliography{$biblio-files$}\n$endif$\n$endif$\n$if(listings)$\n\\usepackage{listings}\n$endif$\n$if(lhs)$\n\\lstnewenvironment{code}{\\lstset{language=Haskell,basicstyle=\\small\\ttfamily}}{}\n$endif$\n$if(highlighting-macros)$\n$highlighting-macros$\n$endif$\n$if(verbatim-in-note)$\n\\usepackage{fancyvrb}\n$endif$\n$if(tables)$\n\\usepackage{longtable}\n% These lines are needed to make table captions work with longtable:\n\\makeatletter\n\\def\\fnum@table{\\tablename~\\thetable}\n\\makeatother\n$endif$\n$if(url)$\n\\usepackage{url}\n$endif$\n$if(graphics)$\n\\usepackage{graphicx}\n% Redefine \\includegraphics so that, unless explicit options are\n% given, the image width will not exceed the width of the page.\n% Images get their normal width if they fit onto the page, but\n% are scaled down if they would overflow the margins.\n\\makeatletter\n\\def\\ScaleIfNeeded{%\n  \\ifdim\\Gin@nat@width>\\linewidth\n    \\linewidth\n  \\else\n    \\Gin@nat@width\n  \\fi\n}\n\\makeatother\n\\let\\Oldincludegraphics\\includegraphics\n\\renewcommand{\\includegraphics}[2][]{\\Oldincludegraphics[width=\\ScaleIfNeeded]{#2}}\n$endif$\n\n% Comment these out if you don't want a slide with just the\n% part/section/subsection/subsubsection title:\n\\AtBeginPart{\n  \\let\\insertpartnumber\\relax\n  \\let\\partname\\relax\n  \\frame{\\partpage}\n}\n\\AtBeginSection{\n  \\let\\insertsectionnumber\\relax\n  \\let\\sectionname\\relax\n  \\frame{\\sectionpage}\n}\n\\AtBeginSubsection{\n  \\let\\insertsubsectionnumber\\relax\n  \\let\\subsectionname\\relax\n  \\frame{\\subsectionpage}\n}\n\n$if(strikeout)$\n\\usepackage[normalem]{ulem}\n% avoid problems with \\sout in headers with hyperref:\n\\pdfstringdefDisableCommands{\\renewcommand{\\sout}{}}\n$endif$\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{6pt plus 2pt minus 1pt}\n\\setlength{\\emergencystretch}{3em}  % prevent overfull lines\n$if(numbersections)$\n$else$\n\\setcounter{secnumdepth}{0}\n$endif$\n$if(verbatim-in-note)$\n\\VerbatimFootnotes % allows verbatim text in footnotes\n$endif$\n$if(lang)$\n\\usepackage[$lang$]{babel}\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n\\title{$title$}\n$endif$\n$if(subtitle)$\n\\subtitle{$subtitle$}\n$endif$\n$if(author)$\n\\author{$for(author)$$author$$sep$ \\and $endfor$}\n$endif$\n$if(date)$\n\\date{$date$}\n$endif$\n\n\\begin{document}\n$if(title)$\n\\frame{\\titlepage}\n$endif$\n\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n\\begin{frame}\n\\tableofcontents[hideallsubsections]\n\\end{frame}\n\n$endif$\n$body$\n\n$if(natbib)$\n$if(biblio-files)$\n$if(biblio-title)$\n$if(book-class)$\n\\renewcommand\\bibname{$biblio-title$}\n$else$\n\\renewcommand\\refname{$biblio-title$}\n$endif$\n$endif$\n\\bibliography{$biblio-files$}\n\n$endif$\n$endif$\n$if(biblatex)$\n\\printbibliography$if(biblio-title)$[title=$biblio-title$]$endif$\n\n$endif$\n$for(include-after)$\n$include-after$\n\n$endfor$\n\\end{document}\n"),("templates/default.context","\\startmode[*mkii]\n  \\enableregime[utf-8]  \n  \\setupcolors[state=start]\n\\stopmode\n$if(mainlang)$\n\\mainlanguage[$mainlang$]\n$endif$\n\n% Enable hyperlinks\n\\setupinteraction[state=start, color=middleblue]\n\n\\setuppapersize [$if(papersize)$$papersize$$else$letter$endif$][$if(papersize)$$papersize$$else$letter$endif$]\n\\setuplayout    [width=middle,  backspace=1.5in, cutspace=1.5in,\n                 height=middle, topspace=0.75in, bottomspace=0.75in]\n\n\\setuppagenumbering[location={footer,center}]\n\n\\setupbodyfont[11pt]\n\n\\setupwhitespace[medium]\n\n\\setuphead[chapter]      [style=\\tfd]\n\\setuphead[section]      [style=\\tfc]\n\\setuphead[subsection]   [style=\\tfb]\n\\setuphead[subsubsection][style=\\bf]\n\n$if(number-sections)$\n$else$\n\\setuphead[chapter, section, subsection, subsubsection][number=no]\n$endif$\n\n\\definedescription\n  [description]\n  [headstyle=bold, style=normal, location=hanging, width=broad, margin=1cm]\n\n\\setupitemize[autointro]    % prevent orphan list intro\n\\setupitemize[indentnext=no]\n\n\\setupthinrules[width=15em] % width of horizontal rules\n\n\\setupdelimitedtext\n  [blockquote]\n  [before={\\blank[medium]},\n   after={\\blank[medium]},\n   indentnext=no,\n  ]\n\n$if(toc)$\n\\setupcombinedlist[content][list={$placelist$}]\n\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n\\starttext\n$if(title)$\n\\startalignment[center]\n  \\blank[2*big]\n  {\\tfd $title$}\n$if(author)$\n  \\blank[3*medium]\n  {\\tfa $for(author)$$author$$sep$\\crlf $endfor$}\n$endif$\n$if(date)$\n  \\blank[2*medium]\n  {\\tfa $date$}\n$endif$\n  \\blank[3*medium]\n\\stopalignment\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$if(toc)$\n\\placecontent\n$endif$\n\n$body$\n\n$for(include-after)$\n$include-after$\n$endfor$\n\\stoptext\n"),("templates/default.docbook","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n$if(mathml)$\n<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook EBNF Module V1.1CR1//EN\"\n                  \"http://www.oasis-open.org/docbook/xml/mathml/1.1CR1/dbmathml.dtd\">\n$else$\n<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\"\n                  \"http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd\">\n$endif$\n<article>\n  <articleinfo>\n    <title>$title$</title>\n$for(author)$\n    <author>\n      $author$\n    </author>\n$endfor$\n$if(date)$\n    <date>$date$</date>\n$endif$\n  </articleinfo>\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</article>\n"),("templates/default.dzslides","<!DOCTYPE html>\n<head>\n<meta charset=\"utf-8\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$if(css)$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" $if(html5)$$else$type=\"text/css\" $endif$/>\n$endfor$\n$else$\n<style>\n  html { background-color: black; }\n  body { background-color: white; border-radius: 12px}\n  /* A section is a slide. It's size is 800x600, and this will never change */\n  section {\n      font-family: Arial, serif;\n      font-size: 20pt;\n    }\n  address, blockquote, dl, fieldset, form, h1, h2, h3, h4, h5, h6, hr, ol, p, pre, table, ul, dl { padding: 10px 20px 10px 20px; }\n  h1, h2, h3 {\n    text-align: center;\n    margin: 10pt 10pt 20pt 10pt;\n  }\n  ul, ol {\n    margin: 10px 10px 10px 50px;\n  }\n  section.titleslide h1 { margin-top: 200px; }\n  h1.title { margin-top: 150px; }\n  h1 { font-size: 180%; }\n  h2 { font-size: 120%; }\n  h3 { font-size: 100%; }\n  q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }\n  blockquote { font-style: italic }\n  /* Figures are displayed full-page, with the caption on\n     top of the image/video */\n  figure {\n    background-color: black;\n  }\n  figcaption {\n    margin: 70px;\n  }\n  footer {\n    position: absolute;\n    bottom: 0;\n    width: 100%;\n    padding: 40px;\n    text-align: right;\n    background-color: #F3F4F8;\n    border-top: 1px solid #CCC;\n  }\n\n  /* Transition effect */\n  /* Feel free to change the transition effect for original\n     animations. See here:\n     https://developer.mozilla.org/en/CSS/CSS_transitions\n     How to use CSS3 Transitions: */\n  section {\n      -moz-transition: left 400ms linear 0s;\n      -webkit-transition: left 400ms linear 0s;\n      -ms-transition: left 400ms linear 0s;\n      transition: left 400ms linear 0s;\n  }\n\n  /* Before */\n  section { left: -150%; }\n  /* Now */\n  section[aria-selected] { left: 0; }\n  /* After */\n  section[aria-selected] ~ section { left: +150%; }\n\n  /* Incremental elements */\n\n  /* By default, visible */\n  .incremental > * { opacity: 1; }\n\n  /* The current item */\n  .incremental > *[aria-selected] { color: red; opacity: 1; }\n\n  /* The items to-be-selected */\n  .incremental > *[aria-selected] ~ * { opacity: 0.2; }\n</style>\n$endif$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$if(title)$\n<section class=\"title\">\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n  <h3 class=\"date\">$date$</h3>\n</section>\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n$dzslides-core$\n</body>\n</html>\n"),("templates/default.epub","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n  <title>$pagetitle$</title>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" href=\"$css$\" />\n$endfor$\n</head>\n<body>\n$if(titlepage)$\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n  <h3 class=\"date\">$date$</h3>\n$endif$\n$else$\n$body$\n$endif$\n</body>\n</html>\n\n"),("templates/default.epub3","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\"$if(lang)$ xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n  <title>$pagetitle$</title>\n$if(quotes)$\n  <style type=\"text/css\">\n    q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }\n  </style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" />\n$endfor$\n</head>\n<body>\n$if(titlepage)$\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n  <h3 class=\"date\">$date$</h3>\n$endif$\n$else$\n$body$\n$endif$\n</body>\n</html>\n\n"),("templates/default.html","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(quotes)$\n  <style type=\"text/css\">q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }</style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" $if(html5)$$else$type=\"text/css\" $endif$/>\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<div id=\"$idprefix$header\">\n<h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n<h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n<h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n<h3 class=\"date\">$date$</h3>\n$endif$\n</div>\n$endif$\n$if(toc)$\n<div id=\"$idprefix$TOC\">\n$toc$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.html5","<!DOCTYPE html>\n<html$if(lang)$ lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"generator\" content=\"pandoc\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, user-scalable=yes\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\">\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\">\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n  <!--[if lt IE 9]>\n    <script src=\"http://html5shim.googlecode.com/svn/trunk/html5.js\"></script>\n  <![endif]-->\n$if(quotes)$\n  <style type=\"text/css\">q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }</style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\">\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<header>\n<h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n<h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n<h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n<h3 class=\"date\">$date$</h3>\n$endif$\n</header>\n$endif$\n$if(toc)$\n<nav id=\"$idprefix$TOC\">\n$toc$\n</nav>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.latex","\\documentclass[$if(fontsize)$$fontsize$,$endif$$if(lang)$$lang$,$endif$$if(papersize)$$papersize$,$endif$$for(classoption)$$classoption$$sep$,$endfor$]{$documentclass$}\n\\usepackage[T1]{fontenc}\n\\usepackage{lmodern}\n\\usepackage{amssymb,amsmath}\n\\usepackage{ifxetex,ifluatex}\n\\usepackage{fixltx2e} % provides \\textsubscript\n% use upquote if available, for straight quotes in verbatim environments\n\\IfFileExists{upquote.sty}{\\usepackage{upquote}}{}\n\\ifnum 0\\ifxetex 1\\fi\\ifluatex 1\\fi=0 % if pdftex\n  \\usepackage[utf8]{inputenc}\n$if(euro)$\n  \\usepackage{eurosym}\n$endif$\n\\else % if luatex or xelatex\n  \\ifxetex\n    \\usepackage{mathspec}\n    \\usepackage{xltxtra,xunicode}\n  \\else\n    \\usepackage{fontspec}\n  \\fi\n  \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n  \\newcommand{\\euro}{\226\130\172}\n$if(mainfont)$\n    \\setmainfont{$mainfont$}\n$endif$\n$if(sansfont)$\n    \\setsansfont{$sansfont$}\n$endif$\n$if(monofont)$\n    \\setmonofont[Mapping=tex-ansi]{$monofont$}\n$endif$\n$if(mathfont)$\n    \\setmathfont(Digits,Latin,Greek){$mathfont$}\n$endif$\n\\fi\n% use microtype if available\n\\IfFileExists{microtype.sty}{\\usepackage{microtype}}{}\n$if(geometry)$\n\\usepackage[$for(geometry)$$geometry$$sep$,$endfor$]{geometry}\n$endif$\n$if(natbib)$\n\\usepackage{natbib}\n\\bibliographystyle{$if(biblio-style)$$biblio-style$$else$plainnat$endif$}\n$endif$\n$if(biblatex)$\n\\usepackage{biblatex}\n$if(biblio-files)$\n\\bibliography{$biblio-files$}\n$endif$\n$endif$\n$if(listings)$\n\\usepackage{listings}\n$endif$\n$if(lhs)$\n\\lstnewenvironment{code}{\\lstset{language=Haskell,basicstyle=\\small\\ttfamily}}{}\n$endif$\n$if(highlighting-macros)$\n$highlighting-macros$\n$endif$\n$if(verbatim-in-note)$\n\\usepackage{fancyvrb}\n$endif$\n$if(tables)$\n\\usepackage{longtable}\n$endif$\n$if(graphics)$\n\\usepackage{graphicx}\n% Redefine \\includegraphics so that, unless explicit options are\n% given, the image width will not exceed the width of the page.\n% Images get their normal width if they fit onto the page, but\n% are scaled down if they would overflow the margins.\n\\makeatletter\n\\def\\ScaleIfNeeded{%\n  \\ifdim\\Gin@nat@width>\\linewidth\n    \\linewidth\n  \\else\n    \\Gin@nat@width\n  \\fi\n}\n\\makeatother\n\\let\\Oldincludegraphics\\includegraphics\n{%\n \\catcode`\\@=11\\relax%\n \\gdef\\includegraphics{\\@ifnextchar[{\\Oldincludegraphics}{\\Oldincludegraphics[width=\\ScaleIfNeeded]}}%\n}%\n$endif$\n\\ifxetex\n  \\usepackage[setpagesize=false, % page size defined by xetex\n              unicode=false, % unicode breaks when used with xetex\n              xetex]{hyperref}\n\\else\n  \\usepackage[unicode=true]{hyperref}\n\\fi\n\\hypersetup{breaklinks=true,\n            bookmarks=true,\n            pdfauthor={$author-meta$},\n            pdftitle={$title-meta$},\n            colorlinks=true,\n            citecolor=$if(citecolor)$$citecolor$$else$blue$endif$,\n            urlcolor=$if(urlcolor)$$urlcolor$$else$blue$endif$,\n            linkcolor=$if(linkcolor)$$linkcolor$$else$magenta$endif$,\n            pdfborder={0 0 0}}\n\\urlstyle{same}  % don't use monospace font for urls\n$if(links-as-notes)$\n% Make links footnotes instead of hotlinks:\n\\renewcommand{\\href}[2]{#2\\footnote{\\url{#1}}}\n$endif$\n$if(strikeout)$\n\\usepackage[normalem]{ulem}\n% avoid problems with \\sout in headers with hyperref:\n\\pdfstringdefDisableCommands{\\renewcommand{\\sout}{}}\n$endif$\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{6pt plus 2pt minus 1pt}\n\\setlength{\\emergencystretch}{3em}  % prevent overfull lines\n$if(numbersections)$\n\\setcounter{secnumdepth}{5}\n$else$\n\\setcounter{secnumdepth}{0}\n$endif$\n$if(verbatim-in-note)$\n\\VerbatimFootnotes % allows verbatim text in footnotes\n$endif$\n$if(lang)$\n\\ifxetex\n  \\usepackage{polyglossia}\n  \\setmainlanguage{$mainlang$}\n\\else\n  \\usepackage[$lang$]{babel}\n\\fi\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n\\title{$title$}\n$endif$\n$if(subtitle)$\n\\subtitle{$subtitle$}\n$endif$\n\\author{$for(author)$$author$$sep$ \\and $endfor$}\n\\date{$date$}\n\n\\begin{document}\n$if(title)$\n\\maketitle\n$endif$\n\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n{\n\\hypersetup{linkcolor=black}\n\\setcounter{tocdepth}{$toc-depth$}\n\\tableofcontents\n}\n$endif$\n$body$\n\n$if(natbib)$\n$if(biblio-files)$\n$if(biblio-title)$\n$if(book-class)$\n\\renewcommand\\bibname{$biblio-title$}\n$else$\n\\renewcommand\\refname{$biblio-title$}\n$endif$\n$endif$\n\\bibliography{$biblio-files$}\n\n$endif$\n$endif$\n$if(biblatex)$\n\\printbibliography$if(biblio-title)$[title=$biblio-title$]$endif$\n\n$endif$\n$for(include-after)$\n$include-after$\n\n$endfor$\n\\end{document}\n"),("templates/default.man","$if(has-tables)$\n.\\\"t\n$endif$\n.TH \"$title$\" \"$section$\" \"$date$\" \"$footer$\" \"$header$\"\n$for(header-includes)$\n$header-includes$\n$endfor$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n$if(author)$\n.SH AUTHORS\n$for(author)$$author$$sep$; $endfor$.\n$endif$\n"),("templates/default.markdown","$if(titleblock)$\n$titleblock$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n$toc$\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.mediawiki","$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n__TOC__\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.opendocument","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" office:version=\"1.2\">\n  $automatic-styles$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n<office:body>\n<office:text>\n$if(title)$\n<text:h text:style-name=\"Title\">$title$</text:h>\n$endif$\n$for(author)$\n<text:p text:style-name=\"Author\">$author$</text:p>\n$endfor$\n$if(date)$\n<text:p text:style-name=\"Date\">$date$</text:p>\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</office:text>\n</office:body>\n</office:document-content>\n"),("templates/default.opml","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<opml version=\"2.0\">\n  <head>\n    <title>$title$</title>\n    <dateModified>$date$</dateModified>\n    <ownerName>$for(author)$$author$$sep$; $endfor$</ownerName>\n  </head>\n  <body>\n$body$\n  </body>\n</opml>\n"),("templates/default.org","$if(title)$\n#+TITLE: $title$\n\n$endif$\n$if(author)$\n#+AUTHOR: $for(author)$$author$$sep$; $endfor$\n$endif$\n$if(date)$\n#+DATE: $date$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.plain","$if(titleblock)$\n$titleblock$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n$toc$\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.revealjs","<!DOCTYPE html>\n<html$if(lang)$ lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"generator\" content=\"pandoc\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />\n  <meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\" />\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no\">\n  <link rel=\"stylesheet\" href=\"$revealjs-url$/css/reveal.min.css\"/>\n    <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n    <style type=\"text/css\">\n$highlighting-css$\n    </style>\n$endif$\n$if(css)$\n$for(css)$\n    <link rel=\"stylesheet\" href=\"$css$\"/>\n$endfor$\n$else$\n    <link rel=\"stylesheet\" href=\"$revealjs-url$/css/theme/simple.css\" id=\"theme\">\n$endif$\n  <link rel=\"stylesheet\" media=\"print\" href=\"$revealjs-url$/css/print/pdf.css\" />\n  <!--[if lt IE 9]>\n  <script src=\"$revealjs-url$/lib/js/html5shiv.js\"></script>\n  <![endif]-->\n$if(math)$\n    $math$\n$endif$\n$for(header-includes)$\n    $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n  <div class=\"reveal\">\n    <div class=\"slides\">\n\n$if(title)$\n<section>\n    <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n    <h2 class=\"author\">$author$</h2>\n$endfor$\n    <h3 class=\"date\">$date$</h3>\n</section>\n$endif$\n$if(toc)$\n<section id=\"$idprefix$TOC\">\n$toc$\n</section>\n$endif$\n\n$body$\n    </div>\n  </div>\n$for(include-after)$\n$include-after$\n$endfor$\n\n  <script src=\"$revealjs-url$/lib/js/head.min.js\"></script>\n  <script src=\"$revealjs-url$/js/reveal.min.js\"></script>\n\n  <script>\n\n      // Full list of configuration options available here:\n      // https://github.com/hakimel/reveal.js#configuration\n      Reveal.initialize({\n        controls: true,\n        progress: true,\n        history: true,\n        center: true,\n        theme: $if(theme)$'$theme$'$else$Reveal.getQueryHash().theme$endif$, // available themes are in /css/theme\n        transition: $if(transition)$'$transition$'$else$Reveal.getQueryHash().transition || 'default'$endif$, // default/cube/page/concave/zoom/linear/fade/none\n\n        // Optional libraries used to extend on reveal.js\n        dependencies: [\n          { src: '$revealjs-url$/lib/js/classList.js', condition: function() { return !document.body.classList; } },\n          { src: '$revealjs-url$/plugin/zoom-js/zoom.js', async: true, condition: function() { return !!document.body.classList; } },\n          { src: '$revealjs-url$/plugin/notes/notes.js', async: true, condition: function() { return !!document.body.classList; } },\n//          { src: '$revealjs-url$/plugin/search/search.js', async: true, condition: function() { return !!document.body.classList; }, }\n//          { src: '$revealjs-url$/plugin/remotes/remotes.js', async: true, condition: function() { return !!document.body.classList; } }\n]});\n    </script>\n  </body>\n</html>\n"),("templates/default.rst","$if(title)$\n$title$\n\n$endif$\n$for(author)$\n:Author: $author$\n$endfor$\n$if(date)$\n:Date:   $date$\n$endif$\n$if(author)$\n\n$else$\n$if(date)$\n\n$endif$\n$endif$\n$if(math)$\n.. role:: math(raw)\n   :format: html latex\n..\n\n$endif$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n.. contents::\n   :depth: $toc-depth$\n..\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.rtf","{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0 \\fswiss Helvetica;}{\\f1 Courier;}}\n{\\colortbl;\\red255\\green0\\blue0;\\red0\\green0\\blue255;}\n\\widowctrl\\hyphauto\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0 \\b \\fs36 $title$\\par}\n$endif$\n$for(author)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0  $author$\\par}\n$endfor$\n$if(date)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0  $date$\\par}\n$endif$\n$if(spacer)$\n{\\pard \\ql \\f0 \\sa180 \\li0 \\fi0 \\par}\n$endif$\n$if(toc)$\n$toc$\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n}\n"),("templates/default.s5","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n  <!-- configuration parameters -->\n  <meta name=\"defaultView\" content=\"slideshow\" />\n  <meta name=\"controlVis\" content=\"hidden\" />\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" type=\"text/css\" />\n$endfor$\n  <!-- style sheet links -->\n  <link rel=\"stylesheet\" href=\"$s5-url$/slides.css\" type=\"text/css\" media=\"projection\" id=\"slideProj\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/outline.css\" type=\"text/css\" media=\"screen\" id=\"outlineStyle\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/print.css\" type=\"text/css\" media=\"print\" id=\"slidePrint\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/opera.css\" type=\"text/css\" media=\"projection\" id=\"operaFix\" />\n  <!-- S5 JS -->\n  <script src=\"$s5-url$/slides.js\" type=\"text/javascript\"></script>\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n<div class=\"layout\">\n<div id=\"controls\"></div>\n<div id=\"currentSlide\"></div>\n<div id=\"header\"></div>\n<div id=\"footer\">\n  <h1>$date$</h1>\n  <h2>$title$</h2>\n</div>\n</div>\n<div class=\"presentation\">\n$if(title)$\n<div class=\"titleslide slide\">\n  <h1>$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n  <h2>$for(author)$$author$$sep$<br/>$endfor$</h2>\n  <h3>$date$</h3>\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</div>\n</body>\n</html>\n"),("templates/default.slideous","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n    href=\"$slideous-url$/slideous.css\" />\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n   href=\"$css$\" />\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n  <script src=\"$slideous-url$/slideous.js\"\n    charset=\"utf-8\" type=\"text/javascript\"></script>\n$if(duration)$\n  <meta name=\"duration\" content=\"$duration$\" />\n$endif$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n<div id=\"statusbar\">\n<span style=\"float:right;\">\n<span style=\"margin-right:4em;font-weight:bold;\"><span id=\"slideidx\"></span> of {$$slidecount}</span>\n<button id=\"homebutton\" title=\"first slide\">1</button>\n<button id=\"prevslidebutton\" title=\"previous slide\">&laquo;</button>\n<button id=\"previtembutton\" title=\"previous item\">&lsaquo;</button>\n<button id=\"nextitembutton\" title=\"next item\">&rsaquo;</button>\n<button id=\"nextslidebutton\" title=\"next slide\">&raquo;</button>\n<button id=\"endbutton\" title=\"last slide\">{$$slidecount}</button>\n<button id=\"incfontbutton\" title=\"content\">A+</button>\n<button id=\"decfontbutton\" title=\"first slide\">A-</button>\n<select id=\"tocbox\" size=\"1\"><option></option></select>\n</span>\n<span id=\"eos\">&frac12;</span>\n<span title=\"{$$location}, {$$date}\">{$$title}, {$$author}</span>\n</div>\n$if(title)$\n<div class=\"slide titlepage\">\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n  <p class=\"author\">\n$for(author)$$author$$sep$<br/>$endfor$\n  </p>\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.slidy","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n    href=\"$slidy-url$/styles/slidy.css\" />\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n   href=\"$css$\" />\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n  <script src=\"$slidy-url$/scripts/slidy.js\"\n    charset=\"utf-8\" type=\"text/javascript\"></script>\n$if(duration)$\n  <meta name=\"duration\" content=\"$duration$\" />\n$endif$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<div class=\"slide titlepage\">\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n  <p class=\"author\">\n$for(author)$$author$$sep$<br/>$endfor$\n  </p>\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.texinfo","\\input texinfo\n@documentencoding UTF-8\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(strikeout)$\n@macro textstrikeout{text}\n~~\\text\\~~\n@end macro\n\n$endif$\n$if(subscript)$\n@macro textsubscript{text}\n@iftex\n@textsubscript{\\text\\}\n@end iftex\n@ifnottex\n_@{\\text\\@}\n@end ifnottex\n@end macro\n\n$endif$\n$if(superscript)$\n@macro textsuperscript{text}\n@iftex\n@textsuperscript{\\text\\}\n@end iftex\n@ifnottex\n^@{\\text\\@}\n@end ifnottex\n@end macro\n\n$endif$\n@ifnottex\n@paragraphindent 0\n@end ifnottex\n$if(titlepage)$\n@titlepage\n@title $title$\n$for(author)$\n@author $author$\n$endfor$\n$if(date)$\n$date$\n$endif$\n@end titlepage\n\n$endif$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n@contents\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n\n@bye\n"),("templates/default.textile","$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/README.markdown","Templates for [pandoc](http://github.com/jgm/pandoc).\n\nIf you use custom templates, we recommend forking this repository,\nso that you can integrate changes to the default templates in future\npandoc releases.\n")]
