/* Generated by re2c 0.13.5 on Thu Jun  7 17:37:03 2012 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2012 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yytext[0]) {                              \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len) {  \
	Z_STRVAL_P(retval) = zend_strndup(str, len); \
	Z_STRLEN_P(retval) = len;                    \
	Z_TYPE_P(retval) = IS_STRING;                \
}

#define RETURN_TOKEN(type, str, len) {           \
	zend_ini_copy_value(ini_lval, str, len);     \
	return type;                                 \
}

static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh TSRMLS_DC)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(TSRMLS_D)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(TSRMLS_D)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(TSRMLS_D)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode TSRMLS_DC)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh TSRMLS_CC) == FAILURE) {
		zend_file_handle_dtor(fh TSRMLS_CC);
		return FAILURE;
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode TSRMLS_DC)
{
	int len = strlen(str);

	if (init_ini_scanner(scanner_mode, NULL TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len TSRMLS_CC);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 337 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case '\t':	goto yy4;
		case '\n':	goto yy6;
		case '\r':	goto yy8;
		case ' ':	goto yy9;
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy10;
		case '#':	goto yy12;
		case '%':
		case '\'':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case ':':
		case '<':
		case '>':
		case '?':
		case '@':
		case ']':
		case '^':	goto yy13;
		case ';':	goto yy14;
		case '=':	goto yy16;
		case 'F':
		case 'f':	goto yy18;
		case 'N':
		case 'n':	goto yy19;
		case 'O':
		case 'o':	goto yy20;
		case 'T':
		case 't':	goto yy21;
		case 'Y':
		case 'y':	goto yy22;
		case '[':	goto yy23;
		default:	goto yy2;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy26;
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 429 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 476 "Zend/zend_ini_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy68;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 568 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 490 "Zend/zend_ini_scanner.c"
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 573 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 502 "Zend/zend_ini_scanner.c"
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy71;
		goto yy7;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy26;
				if (yych <= '\t') goto yy67;
				goto yy71;
			} else {
				if (yych == '\r') goto yy72;
				if (yych <= 0x1F) goto yy26;
				goto yy69;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy58;
				goto yy26;
			} else {
				if (yych <= ';') goto yy53;
				if (yych == '=') goto yy51;
				goto yy26;
			}
		}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 496 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 541 "Zend/zend_ini_scanner.c"
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy59;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy26;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy54;
		YYDEBUG(15, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 596 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 562 "Zend/zend_ini_scanner.c"
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy52;
yy17:
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 439 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_VALUE TSRMLS_CC);
	}
	return '=';
}
#line 580 "Zend/zend_ini_scanner.c"
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy48;
		if (yych == 'a') goto yy48;
		goto yy26;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy44;
			if (yych <= 'T') goto yy26;
			goto yy45;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy26;
				goto yy44;
			} else {
				if (yych == 'u') goto yy45;
				goto yy26;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy38;
			if (yych <= 'M') goto yy26;
			goto yy31;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy26;
				goto yy38;
			} else {
				if (yych == 'n') goto yy31;
				goto yy26;
			}
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy36;
		if (yych == 'r') goto yy36;
		goto yy26;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy27;
		if (yych == 'e') goto yy27;
		goto yy26;
yy23:
		YYDEBUG(23, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(24, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 358 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_SECTION_VALUE TSRMLS_CC);
	}
	return TC_SECTION;
}
#line 646 "Zend/zend_ini_scanner.c"
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy26:
		YYDEBUG(26, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy25;
		}
		if (yych == '[') goto yy28;
		goto yy3;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy31;
		if (yych == 's') goto yy31;
		goto yy26;
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy28;
		}
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 383 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();
	
	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET TSRMLS_CC);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 689 "Zend/zend_ini_scanner.c"
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy31;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy25;
					goto yy34;
				} else {
					if (yych <= '\n') goto yy33;
					if (yych <= '\f') goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy25;
					if (yych >= '#') goto yy25;
				} else {
					if (yych == '%') goto yy25;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= ')') {
					if (yych <= '\'') goto yy25;
				} else {
					if (yych != ';') goto yy25;
				}
			} else {
				if (yych <= '[') {
					if (yych <= '=') goto yy33;
					if (yych <= 'Z') goto yy25;
					goto yy28;
				} else {
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 421 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 741 "Zend/zend_ini_scanner.c"
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		if (yych == '\t') goto yy34;
		if (yych == ' ') goto yy34;
		goto yy33;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy37;
		if (yych != 'u') goto yy26;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy31;
		if (yych == 'e') goto yy31;
		goto yy26;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy39;
		if (yych != 'f') goto yy26;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(40, *YYCURSOR);
		if (yych <= '%') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy25;
					goto yy42;
				} else {
					if (yych <= '\n') goto yy41;
					if (yych <= '\f') goto yy25;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy25;
					if (yych <= ' ') goto yy39;
				} else {
					if (yych != '$') goto yy25;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= ')') {
					if (yych == '\'') goto yy25;
				} else {
					if (yych != ';') goto yy25;
				}
			} else {
				if (yych <= '[') {
					if (yych <= '=') goto yy41;
					if (yych <= 'Z') goto yy25;
					goto yy28;
				} else {
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 815 "Zend/zend_ini_scanner.c"
yy42:
		YYDEBUG(42, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(43, *YYCURSOR);
		if (yych == '\t') goto yy42;
		if (yych == ' ') goto yy42;
		goto yy41;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy42;
					goto yy41;
				} else {
					if (yych == '\r') goto yy41;
					goto yy26;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych <= '"') goto yy41;
					goto yy26;
				} else {
					if (yych == '%') goto yy26;
					goto yy41;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy26;
					if (yych <= ')') goto yy41;
					goto yy26;
				} else {
					if (yych == '<') goto yy26;
					goto yy41;
				}
			} else {
				if (yych <= 'm') {
					if (yych == 'N') goto yy47;
					goto yy26;
				} else {
					if (yych <= 'n') goto yy47;
					if (yych <= 'z') goto yy26;
					if (yych <= '~') goto yy41;
					goto yy26;
				}
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy46;
		if (yych != 'l') goto yy26;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy39;
		if (yych == 'l') goto yy39;
		goto yy26;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy26;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy49;
		if (yych != 'l') goto yy26;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy50;
		if (yych != 's') goto yy26;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy26;
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy52:
		YYDEBUG(52, *YYCURSOR);
		if (yych == '\t') goto yy51;
		if (yych == ' ') goto yy51;
		goto yy17;
yy53:
		YYDEBUG(53, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy54:
		YYDEBUG(54, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy53;
		}
		if (yych >= '\r') goto yy57;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 578 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 936 "Zend/zend_ini_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy55;
		goto yy56;
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy58;
				} else {
					if (yych <= '\n') goto yy64;
					if (yych <= '\f') goto yy58;
					goto yy66;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy58;
					if (yych >= '#') goto yy58;
				} else {
					if (yych == '%') goto yy58;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= ')') {
					if (yych <= '\'') goto yy58;
				} else {
					if (yych != ';') goto yy58;
				}
			} else {
				if (yych <= '[') {
					if (yych <= '=') goto yy60;
					if (yych <= 'Z') goto yy58;
					goto yy62;
				} else {
					if (yych <= 'z') goto yy58;
					if (yych >= 0x7F) goto yy58;
				}
			}
		}
yy60:
		YYDEBUG(60, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(61, *YYCURSOR);
		if (yych == '\n') goto yy64;
		if (yych == '\r') goto yy66;
		goto yy60;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(63, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy60;
			if (yych <= '\t') goto yy62;
			if (yych >= '\v') goto yy60;
		} else {
			if (yych <= '\r') goto yy66;
			if (yych == ' ') goto yy62;
			goto yy60;
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		++YYCURSOR;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 584 "Zend/zend_ini_scanner.l"
		{ /* #Comment */
	zend_error(E_DEPRECATED, "Comments starting with '#' are deprecated in %s on line %d", zend_ini_scanner_get_filename(TSRMLS_C), SCNG(lineno));
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1023 "Zend/zend_ini_scanner.c"
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy64;
		goto yy65;
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy68:
		YYDEBUG(68, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy5;
				if (yych <= '\t') goto yy67;
				goto yy71;
			} else {
				if (yych == '\r') goto yy72;
				if (yych <= 0x1F) goto yy5;
				goto yy67;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy60;
				goto yy5;
			} else {
				if (yych <= ';') goto yy53;
				if (yych == '=') goto yy51;
				goto yy5;
			}
		}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		if (yych <= '%') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy25;
					goto yy67;
				} else {
					if (yych <= '\n') goto yy71;
					if (yych <= '\f') goto yy25;
					goto yy72;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy25;
					if (yych <= ' ') goto yy69;
					goto yy3;
				} else {
					if (yych <= '#') goto yy58;
					if (yych <= '$') goto yy3;
					goto yy25;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= ')') {
					if (yych == '\'') goto yy25;
					goto yy3;
				} else {
					if (yych == ';') goto yy53;
					goto yy25;
				}
			} else {
				if (yych <= '[') {
					if (yych <= '=') goto yy51;
					if (yych <= 'Z') goto yy25;
					goto yy28;
				} else {
					if (yych <= 'z') goto yy25;
					if (yych <= '~') goto yy3;
					goto yy25;
				}
			}
		}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy7;
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy71;
		goto yy7;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(73, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy77;
		if (yych == '$') goto yy79;
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 528 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}
		
		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	
	zend_ini_escape_string(ini_lval, yytext, yyleng, '"' TSRMLS_CC);
	return TC_QUOTED_STRING;
}
#line 1199 "Zend/zend_ini_scanner.c"
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy83;
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 523 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state(TSRMLS_C);
	return '"';
}
#line 1213 "Zend/zend_ini_scanner.c"
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy76;
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 401 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1227 "Zend/zend_ini_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy83:
		YYDEBUG(83, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy82;
		}
		goto yy78;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66, 194,  64,  66,  66,  64,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			194,  66,  64,  66,  68,  66,  66,   0, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114,  66,  64,  66,  66,  66,  66, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  72,  64,  66,  82, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
		};
		YYDEBUG(84, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy86;
					if (yych <= '\t') goto yy88;
					goto yy89;
				} else {
					if (yych == '\r') goto yy89;
					if (yych >= ' ') goto yy88;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy91;
					if (yych >= '$') goto yy93;
				} else {
					if (yych == '\'') goto yy94;
					if (yych >= '-') goto yy95;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy96;
					if (yych >= '0') goto yy97;
				} else {
					if (yych == ';') goto yy89;
					if (yych >= 'A') goto yy99;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy86;
					if (yych <= '\\') goto yy101;
					if (yych <= ']') goto yy102;
				} else {
					if (yych == '`') goto yy86;
					if (yych <= 'z') goto yy99;
				}
			}
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy105;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 514 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1331 "Zend/zend_ini_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy131;
		}
		if (yych == '"') goto yy133;
		if (yych == ']') goto yy134;
		goto yy105;
yy89:
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 596 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1352 "Zend/zend_ini_scanner.c"
yy91:
		YYDEBUG(91, *YYCURSOR);
		++YYCURSOR;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 518 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 1364 "Zend/zend_ini_scanner.c"
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy90;
			if (yych <= '[') goto yy104;
			goto yy109;
		} else {
			if (yych == '{') goto yy129;
			goto yy104;
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy125;
		}
		goto yy90;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy105;
		if (yych <= '9') goto yy123;
		goto yy105;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy105;
		if (yych <= '9') goto yy121;
		goto yy105;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy98;
				if (yych <= '\f') goto yy105;
			} else {
				if (yych == '"') goto yy98;
				if (yych <= '&') goto yy105;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy117;
				if (yych <= '/') goto yy105;
				goto yy119;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy105;
				} else {
					if (yych != ']') goto yy105;
				}
			}
		}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 492 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1430 "Zend/zend_ini_scanner.c"
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy115;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy105;
			} else {
				if (yych <= '\r') goto yy100;
				if (yych <= '!') goto yy105;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy105;
			} else {
				if (yych <= ';') goto yy100;
				if (yych != ']') goto yy105;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 488 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1460 "Zend/zend_ini_scanner.c"
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy104;
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 396 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1476 "Zend/zend_ini_scanner.c"
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy105:
		YYDEBUG(105, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy104;
		}
		if (yych == '$') goto yy107;
		if (yych != '\\') goto yy87;
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy104;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy108;
			if (yych <= '[') goto yy104;
			goto yy109;
		} else {
			if (yych != '{') goto yy104;
		}
yy108:
		YYDEBUG(108, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy87;
			} else {
				goto yy90;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy98;
			} else {
				goto yy100;
			}
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy110;
		}
		if (yych == '\\') goto yy112;
		goto yy104;
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy110;
		}
		if (yych == '\\') goto yy114;
		goto yy104;
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy110;
		}
		if (yych == '\\') goto yy112;
		goto yy104;
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy110;
		}
		if (yych == '\\') goto yy112;
		goto yy104;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(116, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy115;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy100;
				if (yych <= '\f') goto yy104;
				goto yy100;
			} else {
				if (yych == '"') goto yy100;
				if (yych <= '#') goto yy104;
				goto yy107;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy100;
				if (yych <= ':') goto yy104;
				goto yy100;
			} else {
				if (yych <= '[') goto yy104;
				if (yych <= '\\') goto yy106;
				if (yych <= ']') goto yy100;
				goto yy104;
			}
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(118, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy117;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy98;
				if (yych <= '\f') goto yy104;
				goto yy98;
			} else {
				if (yych == '"') goto yy98;
				if (yych <= '#') goto yy104;
				goto yy107;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy98;
				if (yych <= ':') goto yy104;
				goto yy98;
			} else {
				if (yych <= '[') goto yy104;
				if (yych <= '\\') goto yy106;
				if (yych <= ']') goto yy98;
				goto yy104;
			}
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy104;
					goto yy98;
				} else {
					if (yych == '\r') goto yy98;
					goto yy104;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy98;
					goto yy104;
				} else {
					if (yych <= '$') goto yy107;
					if (yych <= '&') goto yy104;
					goto yy98;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy104;
					goto yy117;
				} else {
					if (yych <= '/') goto yy104;
					if (yych <= '9') goto yy119;
					goto yy104;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy98;
					goto yy104;
				} else {
					if (yych <= '\\') goto yy106;
					if (yych <= ']') goto yy98;
					goto yy104;
				}
			}
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy98;
				if (yych <= '\f') goto yy104;
				goto yy98;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy104;
					goto yy98;
				} else {
					if (yych == '$') goto yy107;
					goto yy104;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy98;
				if (yych <= '/') goto yy104;
				if (yych <= '9') goto yy121;
				goto yy104;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy98;
					goto yy104;
				} else {
					if (yych <= '\\') goto yy106;
					if (yych <= ']') goto yy98;
					goto yy104;
				}
			}
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy98;
				if (yych <= '\f') goto yy104;
				goto yy98;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy104;
					goto yy98;
				} else {
					if (yych == '$') goto yy107;
					goto yy104;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy98;
				if (yych <= '/') goto yy104;
				if (yych <= '9') goto yy123;
				goto yy104;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy98;
					goto yy104;
				} else {
					if (yych <= '\\') goto yy106;
					if (yych <= ']') goto yy98;
					goto yy104;
				}
			}
		}
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy125;
		}
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 368 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1775 "Zend/zend_ini_scanner.c"
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 401 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1786 "Zend/zend_ini_scanner.c"
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy131;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy87;
				if (yych <= '\f') goto yy104;
				goto yy87;
			} else {
				if (yych == '"') goto yy133;
				if (yych <= '#') goto yy104;
				goto yy107;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy87;
				if (yych <= ':') goto yy104;
				goto yy87;
			} else {
				if (yych <= '[') goto yy104;
				if (yych <= '\\') goto yy106;
				if (yych <= ']') goto yy134;
				goto yy104;
			}
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy92;
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy103;
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 32, 160, 160, 160, 160, 160, 160, 160, 
			160, 224,   0, 160, 160,   0, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			224, 160,  32, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160,  32, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
		};
		YYDEBUG(135, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy137;
				if (yych <= 0x08) goto yy139;
				goto yy141;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '\f') goto yy139;
				goto yy144;
			}
		} else {
			if (yych <= '!') {
				if (yych == ' ') goto yy141;
				goto yy139;
			} else {
				if (yych <= '"') goto yy145;
				if (yych == ';') goto yy147;
				goto yy139;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 591 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1899 "Zend/zend_ini_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy158;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 474 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1912 "Zend/zend_ini_scanner.c"
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy154;
		}
		if (yych <= '\f') {
			if (yych == '\n') goto yy153;
			goto yy158;
		} else {
			if (yych <= '\r') goto yy156;
			if (yych == ';') goto yy148;
			goto yy158;
		}
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 482 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1940 "Zend/zend_ini_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy153;
		goto yy143;
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\n':
				SCNG(lineno)++;
				break;
			case '\r':
				if (*YYCURSOR != '\n') {
					SCNG(lineno)++;
				}
				break;
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text) - 2;
				SCNG(yy_text)++;
				RETURN_TOKEN(TC_RAW, yytext, yyleng);
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				break;
		}
	}
	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1977 "Zend/zend_ini_scanner.c"
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy149;
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy149:
		YYDEBUG(149, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy148;
		}
		if (yych >= '\r') goto yy152;
yy150:
		YYDEBUG(150, *YYCURSOR);
		++YYCURSOR;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 578 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2006 "Zend/zend_ini_scanner.c"
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy150;
		goto yy151;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy143;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(155, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy154;
		}
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy140;
				goto yy157;
			} else {
				if (yych <= '\n') goto yy153;
				if (yych <= '\f') goto yy157;
			}
		} else {
			if (yych <= '"') {
				if (yych <= '!') goto yy157;
				goto yy140;
			} else {
				if (yych == ';') goto yy148;
				goto yy157;
			}
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy153;
		goto yy143;
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy158:
		YYDEBUG(158, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy157;
		}
		goto yy140;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(159, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\n') goto yy163;
		} else {
			if (yych <= '\r') goto yy163;
			if (yych == ']') goto yy165;
		}
		YYDEBUG(161, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy172;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 478 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2117 "Zend/zend_ini_scanner.c"
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(164, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 596 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2127 "Zend/zend_ini_scanner.c"
yy165:
		YYDEBUG(165, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy168;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 377 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2142 "Zend/zend_ini_scanner.c"
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy168:
		YYDEBUG(168, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy167;
		}
		if (yych == '\n') goto yy169;
		if (yych == '\r') goto yy170;
		goto yy166;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy166;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy169;
		goto yy166;
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy172:
		YYDEBUG(172, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy171;
		}
		goto yy162;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 134, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			134, 132, 128, 132, 136, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			228, 228, 228, 228, 228, 228, 228, 228, 
			228, 228, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 144, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(173, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy175;
					if (yych <= '\t') goto yy177;
					goto yy178;
				} else {
					if (yych == '\r') goto yy178;
					if (yych >= ' ') goto yy177;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy180;
					if (yych >= '$') goto yy182;
				} else {
					if (yych == '\'') goto yy183;
					if (yych >= '-') goto yy184;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy185;
					if (yych >= '0') goto yy186;
				} else {
					if (yych == ';') goto yy178;
					if (yych >= 'A') goto yy188;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy175;
					if (yych <= '\\') goto yy190;
					if (yych <= ']') goto yy191;
				} else {
					if (yych == '`') goto yy175;
					if (yych <= 'z') goto yy188;
				}
			}
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy198;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 514 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2268 "Zend/zend_ini_scanner.c"
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy224;
			goto yy198;
		} else {
			if (yych <= ' ') goto yy224;
			if (yych == '"') goto yy226;
			goto yy198;
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 596 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2291 "Zend/zend_ini_scanner.c"
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 518 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 2303 "Zend/zend_ini_scanner.c"
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy179;
			if (yych <= '[') goto yy197;
			goto yy202;
		} else {
			if (yych == '{') goto yy222;
			goto yy197;
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy218;
		}
		goto yy179;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy198;
		if (yych <= '9') goto yy216;
		goto yy198;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy198;
		if (yych <= '9') goto yy214;
		goto yy198;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy187;
				if (yych <= '\f') goto yy198;
			} else {
				if (yych == '"') goto yy187;
				if (yych <= '&') goto yy198;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy210;
				if (yych <= '/') goto yy198;
				goto yy212;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy198;
				} else {
					if (yych != ']') goto yy198;
				}
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 492 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2369 "Zend/zend_ini_scanner.c"
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy208;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy198;
			} else {
				if (yych <= '\r') goto yy189;
				if (yych <= '!') goto yy198;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy198;
			} else {
				if (yych <= ';') goto yy189;
				if (yych != ']') goto yy198;
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 488 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2399 "Zend/zend_ini_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy197;
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy194;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 377 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2418 "Zend/zend_ini_scanner.c"
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy194:
		YYDEBUG(194, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy193;
		}
		if (yych == '\n') goto yy195;
		if (yych == '\r') goto yy196;
		goto yy192;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy192;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy195;
		goto yy192;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy198:
		YYDEBUG(198, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy197;
		}
		if (yych == '$') goto yy200;
		if (yych != '\\') goto yy176;
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy197;
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy201;
			if (yych <= '[') goto yy197;
			goto yy202;
		} else {
			if (yych != '{') goto yy197;
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy176;
			} else {
				goto yy179;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy187;
			} else {
				goto yy189;
			}
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy203;
		}
		if (yych == '\\') goto yy205;
		goto yy197;
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy203;
		}
		if (yych == '\\') goto yy207;
		goto yy197;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy203;
		}
		if (yych == '\\') goto yy205;
		goto yy197;
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy203;
		}
		if (yych == '\\') goto yy205;
		goto yy197;
yy208:
		YYDEBUG(208, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy208;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy189;
				if (yych <= '\f') goto yy197;
				goto yy189;
			} else {
				if (yych == '"') goto yy189;
				if (yych <= '#') goto yy197;
				goto yy200;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy189;
				if (yych <= ':') goto yy197;
				goto yy189;
			} else {
				if (yych <= '[') goto yy197;
				if (yych <= '\\') goto yy199;
				if (yych <= ']') goto yy189;
				goto yy197;
			}
		}
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy187;
				if (yych <= '\f') goto yy197;
				goto yy187;
			} else {
				if (yych == '"') goto yy187;
				if (yych <= '#') goto yy197;
				goto yy200;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy187;
				if (yych <= ':') goto yy197;
				goto yy187;
			} else {
				if (yych <= '[') goto yy197;
				if (yych <= '\\') goto yy199;
				if (yych <= ']') goto yy187;
				goto yy197;
			}
		}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy197;
					goto yy187;
				} else {
					if (yych == '\r') goto yy187;
					goto yy197;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy187;
					goto yy197;
				} else {
					if (yych <= '$') goto yy200;
					if (yych <= '&') goto yy197;
					goto yy187;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy197;
					goto yy210;
				} else {
					if (yych <= '/') goto yy197;
					if (yych <= '9') goto yy212;
					goto yy197;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy187;
					goto yy197;
				} else {
					if (yych <= '\\') goto yy199;
					if (yych <= ']') goto yy187;
					goto yy197;
				}
			}
		}
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy187;
				if (yych <= '\f') goto yy197;
				goto yy187;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy197;
					goto yy187;
				} else {
					if (yych == '$') goto yy200;
					goto yy197;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy187;
				if (yych <= '/') goto yy197;
				if (yych <= '9') goto yy214;
				goto yy197;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy187;
					goto yy197;
				} else {
					if (yych <= '\\') goto yy199;
					if (yych <= ']') goto yy187;
					goto yy197;
				}
			}
		}
yy216:
		YYDEBUG(216, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy187;
				if (yych <= '\f') goto yy197;
				goto yy187;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy197;
					goto yy187;
				} else {
					if (yych == '$') goto yy200;
					goto yy197;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy187;
				if (yych <= '/') goto yy197;
				if (yych <= '9') goto yy216;
				goto yy197;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy187;
					goto yy197;
				} else {
					if (yych <= '\\') goto yy199;
					if (yych <= ']') goto yy187;
					goto yy197;
				}
			}
		}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy218;
		}
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 368 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2739 "Zend/zend_ini_scanner.c"
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 401 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 2750 "Zend/zend_ini_scanner.c"
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(225, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy197;
				if (yych <= '\t') goto yy224;
				if (yych <= '\n') goto yy176;
				goto yy197;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy176;
					goto yy197;
				} else {
					if (yych <= ' ') goto yy224;
					if (yych <= '!') goto yy197;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '$') {
					if (yych <= '#') goto yy197;
					goto yy200;
				} else {
					if (yych == '\'') goto yy176;
					goto yy197;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy176;
					goto yy197;
				} else {
					if (yych <= '\\') goto yy199;
					if (yych <= ']') goto yy176;
					goto yy197;
				}
			}
		}
yy226:
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy181;
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			160, 162, 162, 162, 162, 162, 162, 162, 
			162, 176, 128, 162, 162, 128, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			176, 160, 160, 162, 168, 162, 160,  32, 
			160, 160, 162, 162, 162, 162, 162, 162, 
			230, 230, 230, 230, 230, 230, 230, 230, 
			230, 230, 162, 160, 162, 160, 162, 162, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 162, 162, 162, 166, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 160, 162, 160, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
		};
		YYDEBUG(227, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:	goto yy229;
		case '\t':
		case ' ':	goto yy233;
		case '\n':	goto yy235;
		case '\r':	goto yy237;
		case '!':
		case '&':
		case '(':
		case ')':
		case '|':
		case '~':	goto yy238;
		case '"':	goto yy240;
		case '$':	goto yy242;
		case '\'':	goto yy243;
		case '-':	goto yy244;
		case '.':	goto yy245;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy246;
		case ';':	goto yy248;
		case '=':	goto yy249;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy251;
		case 'F':
		case 'f':	goto yy253;
		case 'N':
		case 'n':	goto yy254;
		case 'O':
		case 'o':	goto yy255;
		case 'T':
		case 't':	goto yy256;
		case 'Y':
		case 'y':	goto yy257;
		default:	goto yy231;
		}
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 591 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 2935 "Zend/zend_ini_scanner.c"
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy259;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 510 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2948 "Zend/zend_ini_scanner.c"
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy309;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 564 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 2961 "Zend/zend_ini_scanner.c"
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 482 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2974 "Zend/zend_ini_scanner.c"
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy307;
		goto yy236;
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy306;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 500 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 2992 "Zend/zend_ini_scanner.c"
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 518 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 3004 "Zend/zend_ini_scanner.c"
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy230;
			if (yych <= '[') goto yy258;
			goto yy265;
		} else {
			if (yych == '{') goto yy303;
			goto yy258;
		}
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy299;
		}
		goto yy230;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy259;
		if (yych <= '9') goto yy297;
		goto yy259;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy259;
		if (yych <= '9') goto yy295;
		goto yy259;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '.') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy259;
				} else {
					if (yych <= '\n') goto yy247;
					if (yych <= '\f') goto yy259;
				}
			} else {
				if (yych <= '%') {
					if (yych <= 0x1F) goto yy259;
					if (yych >= '#') goto yy259;
				} else {
					if (yych <= ')') goto yy247;
					if (yych <= '-') goto yy259;
					goto yy291;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '/') goto yy259;
					goto yy293;
				} else {
					if (yych != ';') goto yy259;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy247;
					if (yych <= '{') goto yy259;
				} else {
					if (yych != '~') goto yy259;
				}
			}
		}
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 492 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 3084 "Zend/zend_ini_scanner.c"
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy287;
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 504 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3101 "Zend/zend_ini_scanner.c"
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy260;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy252;
				if (yych <= 0x08) goto yy259;
				if (yych >= '\v') goto yy259;
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy259;
				} else {
					if (yych <= '"') goto yy252;
					if (yych <= '%') goto yy259;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych == ';') goto yy252;
				if (yych <= '<') goto yy259;
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy259;
				} else {
					if (yych != '~') goto yy259;
				}
			}
		}
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 488 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 3141 "Zend/zend_ini_scanner.c"
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					goto yy259;
				} else {
					if (yych <= '9') goto yy260;
					if (yych == ';') goto yy252;
					goto yy259;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy252;
					if (yych <= '@') goto yy259;
					goto yy283;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych <= 'a') goto yy283;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					if (yych <= '\n') goto yy252;
					goto yy259;
				} else {
					if (yych <= '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					if (yych <= '"') goto yy252;
					goto yy259;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					if (yych <= '9') goto yy260;
					goto yy259;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy252;
						goto yy259;
					} else {
						if (yych <= '=') goto yy252;
						if (yych <= '@') goto yy259;
						goto yy260;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy279;
					if (yych == 'U') goto yy280;
					goto yy260;
				} else {
					if (yych == '_') goto yy260;
					if (yych <= '`') goto yy259;
					goto yy260;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy279;
					if (yych == 'u') goto yy280;
					goto yy260;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy259;
						goto yy252;
					} else {
						if (yych == '~') goto yy252;
						goto yy259;
					}
				}
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					if (yych <= '\n') goto yy252;
					goto yy259;
				} else {
					if (yych <= '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					if (yych <= '"') goto yy252;
					goto yy259;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					if (yych <= '9') goto yy260;
					goto yy259;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy252;
						goto yy259;
					} else {
						if (yych <= '=') goto yy252;
						if (yych <= '@') goto yy259;
						goto yy260;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy274;
					if (yych == 'N') goto yy268;
					goto yy260;
				} else {
					if (yych == '_') goto yy260;
					if (yych <= '`') goto yy259;
					goto yy260;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy274;
					if (yych == 'n') goto yy268;
					goto yy260;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy259;
						goto yy252;
					} else {
						if (yych == '~') goto yy252;
						goto yy259;
					}
				}
			}
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'R') {
					if (yych <= '@') goto yy259;
					if (yych <= 'Q') goto yy260;
					goto yy272;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy272;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy259;
					if (yych <= 'D') goto yy260;
					goto yy262;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy262;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy259:
		YYDEBUG(259, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy258;
		}
		if (yych == '$') goto yy263;
		goto yy232;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(261, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy260;
		}
		if (yych <= '%') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy252;
					goto yy258;
				} else {
					if (yych <= '\n') goto yy252;
					if (yych <= '\f') goto yy258;
					goto yy252;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy258;
					goto yy252;
				} else {
					if (yych == '$') goto yy263;
					goto yy258;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= ')') goto yy252;
					goto yy258;
				} else {
					if (yych == '<') goto yy258;
					goto yy252;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy258;
					goto yy252;
				} else {
					if (yych == '~') goto yy252;
					goto yy258;
				}
			}
		}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'S') {
					if (yych <= '@') goto yy259;
					if (yych <= 'R') goto yy260;
					goto yy268;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy268;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy263:
		YYDEBUG(263, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy264;
			if (yych <= '[') goto yy258;
			goto yy265;
		} else {
			if (yych != '{') goto yy258;
		}
yy264:
		YYDEBUG(264, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy232;
				} else {
					goto yy234;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy230;
				} else {
					goto yy247;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy252;
				} else {
					goto yy269;
				}
			} else {
				goto yy276;
			}
		}
yy265:
		YYDEBUG(265, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy266;
		}
		goto yy258;
yy266:
		YYDEBUG(266, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(267, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy266;
		}
		if (yych <= 0x00) goto yy232;
		if (yych == '\\') goto yy265;
		goto yy258;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy270;
		}
		if (yych <= ';') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy269;
					if (yych <= '\t') goto yy259;
				} else {
					if (yych != '\r') goto yy259;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy269;
					if (yych <= '%') goto yy259;
				} else {
					if (yych <= '/') goto yy259;
					if (yych <= '9') goto yy260;
					if (yych <= ':') goto yy259;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') {
					if (yych != '=') goto yy259;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych <= '^') goto yy259;
					goto yy260;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy259;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych >= 0x7F) goto yy259;
				}
			}
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 421 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 3637 "Zend/zend_ini_scanner.c"
yy270:
		YYDEBUG(270, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(271, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy270;
		}
		goto yy269;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'U') {
					if (yych <= '@') goto yy259;
					if (yych <= 'T') goto yy260;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy273;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy259;
					if (yych <= 'D') goto yy260;
					goto yy268;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy268;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'F') {
					if (yych <= '@') goto yy259;
					if (yych <= 'E') goto yy260;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy275;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy260;
		}
		if (yych <= '%') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy259;
				} else {
					if (yych <= '\t') goto yy277;
					if (yych >= '\v') goto yy259;
				}
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy259;
				} else {
					if (yych <= ' ') goto yy277;
					if (yych >= '#') goto yy259;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych >= '*') goto yy259;
				} else {
					if (yych == '<') goto yy259;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy259;
				} else {
					if (yych != '~') goto yy259;
				}
			}
		}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 3841 "Zend/zend_ini_scanner.c"
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(278, *YYCURSOR);
		if (yych == '\t') goto yy277;
		if (yych == ' ') goto yy277;
		goto yy276;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy276;
					if (yych <= 0x08) goto yy259;
					if (yych <= '\t') goto yy277;
					goto yy276;
				} else {
					if (yych == '\r') goto yy276;
					if (yych <= 0x1F) goto yy259;
					goto yy277;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy276;
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy276;
					goto yy259;
				} else {
					if (yych <= '9') goto yy260;
					if (yych == ';') goto yy276;
					goto yy259;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy276;
					if (yych <= '@') goto yy259;
					if (yych <= 'M') goto yy260;
					goto yy282;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'n') goto yy282;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy276;
					goto yy259;
				}
			}
		}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'L') {
					if (yych <= '@') goto yy259;
					if (yych <= 'K') goto yy260;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy281;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'L') {
					if (yych <= '@') goto yy259;
					if (yych <= 'K') goto yy260;
					goto yy275;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy275;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy259;
					if (yych <= 'D') goto yy260;
					goto yy275;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy275;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'L') {
					if (yych <= '@') goto yy259;
					if (yych <= 'K') goto yy260;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy284;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'S') {
					if (yych <= '@') goto yy259;
					if (yych <= 'R') goto yy260;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy285;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy252;
					if (yych <= 0x08) goto yy259;
					goto yy252;
				} else {
					if (yych == '\r') goto yy252;
					if (yych <= 0x1F) goto yy259;
					goto yy252;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy259;
					if (yych <= ')') goto yy252;
					if (yych <= '/') goto yy259;
					goto yy260;
				} else {
					if (yych == ';') goto yy252;
					if (yych <= '<') goto yy259;
					goto yy252;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy259;
					if (yych <= 'D') goto yy260;
					goto yy275;
				} else {
					if (yych <= 'Z') goto yy260;
					if (yych == '_') goto yy260;
					goto yy259;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy275;
					if (yych <= 'z') goto yy260;
					goto yy259;
				} else {
					if (yych == '}') goto yy259;
					if (yych <= '~') goto yy252;
					goto yy259;
				}
			}
		}
yy286:
		YYDEBUG(286, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy287:
		YYDEBUG(287, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy286;
		}
		if (yych >= '\r') goto yy290;
yy288:
		YYDEBUG(288, *YYCURSOR);
		++YYCURSOR;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 578 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 4223 "Zend/zend_ini_scanner.c"
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy288;
		goto yy289;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(292, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy291;
		}
		if (yych <= '%') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy247;
					goto yy258;
				} else {
					if (yych <= '\n') goto yy247;
					if (yych <= '\f') goto yy258;
					goto yy247;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy258;
					goto yy247;
				} else {
					if (yych == '$') goto yy263;
					goto yy258;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= ')') goto yy247;
					goto yy258;
				} else {
					if (yych == '<') goto yy258;
					goto yy247;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy258;
					goto yy247;
				} else {
					if (yych == '~') goto yy247;
					goto yy258;
				}
			}
		}
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(294, *YYCURSOR);
		if (yych <= '-') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy247;
					if (yych <= 0x08) goto yy258;
					goto yy247;
				} else {
					if (yych == '\r') goto yy247;
					goto yy258;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy247;
					if (yych <= '#') goto yy258;
					goto yy263;
				} else {
					if (yych <= '%') goto yy258;
					if (yych <= ')') goto yy247;
					goto yy258;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '.') goto yy291;
					if (yych <= '/') goto yy258;
					goto yy293;
				} else {
					if (yych == ';') goto yy247;
					goto yy258;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy247;
					if (yych <= '{') goto yy258;
					goto yy247;
				} else {
					if (yych == '~') goto yy247;
					goto yy258;
				}
			}
		}
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(296, *YYCURSOR);
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy247;
					goto yy258;
				} else {
					if (yych <= '\n') goto yy247;
					if (yych <= '\f') goto yy258;
					goto yy247;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy258;
					if (yych <= '"') goto yy247;
					goto yy258;
				} else {
					if (yych <= '$') goto yy263;
					if (yych <= '%') goto yy258;
					goto yy247;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '/') goto yy258;
					goto yy295;
				} else {
					if (yych == ';') goto yy247;
					goto yy258;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy247;
					if (yych <= '{') goto yy258;
					goto yy247;
				} else {
					if (yych == '~') goto yy247;
					goto yy258;
				}
			}
		}
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(298, *YYCURSOR);
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy247;
					goto yy258;
				} else {
					if (yych <= '\n') goto yy247;
					if (yych <= '\f') goto yy258;
					goto yy247;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy258;
					if (yych <= '"') goto yy247;
					goto yy258;
				} else {
					if (yych <= '$') goto yy263;
					if (yych <= '%') goto yy258;
					goto yy247;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '/') goto yy258;
					goto yy297;
				} else {
					if (yych == ';') goto yy247;
					goto yy258;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy247;
					if (yych <= '{') goto yy258;
					goto yy247;
				} else {
					if (yych == '~') goto yy247;
					goto yy258;
				}
			}
		}
yy299:
		YYDEBUG(299, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(300, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy299;
		}
		YYDEBUG(301, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(302, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 368 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 4444 "Zend/zend_ini_scanner.c"
yy303:
		YYDEBUG(303, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(304, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 401 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 4455 "Zend/zend_ini_scanner.c"
yy305:
		YYDEBUG(305, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy306:
		YYDEBUG(306, *YYCURSOR);
		if (yych == '\t') goto yy305;
		if (yych == ' ') goto yy305;
		goto yy239;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy236;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy309:
		YYDEBUG(309, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy234;
				if (yych <= '\t') goto yy308;
				goto yy307;
			} else {
				if (yych == '\r') goto yy311;
				goto yy234;
			}
		} else {
			if (yych <= '"') {
				if (yych <= ' ') goto yy308;
				if (yych <= '!') goto yy234;
			} else {
				if (yych == ';') goto yy286;
				goto yy234;
			}
		}
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy241;
yy311:
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy307;
		goto yy236;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(312, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych >= '\t') goto yy316;
				} else {
					if (yych == '\r') goto yy316;
				}
			} else {
				if (yych <= '$') {
					if (yych != '#') goto yy316;
				} else {
					if (yych == '&') goto yy316;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy316;
					if (yych >= ';') goto yy316;
				} else {
					if (yych == '=') goto yy316;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '[') goto yy316;
					if (yych >= '{') goto yy316;
				} else {
					if (yych <= '}') goto yy318;
					if (yych <= '~') goto yy316;
				}
			}
		}
		YYDEBUG(314, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy321;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 406 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 4594 "Zend/zend_ini_scanner.c"
yy316:
		YYDEBUG(316, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(317, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 596 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 4604 "Zend/zend_ini_scanner.c"
yy318:
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(319, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 416 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state(TSRMLS_C);
	return '}';
}
#line 4615 "Zend/zend_ini_scanner.c"
yy320:
		YYDEBUG(320, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy321:
		YYDEBUG(321, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy320;
		}
		goto yy315;
	}
}
#line 600 "Zend/zend_ini_scanner.l"

}
