%define name    piklab-prog-qt4
%define version 0.15.9
%define release %mkrel 1

Summary:       Command-line programmer and debugger for PIC and dsPIC microcontrollers
Name:          %{name}
Version:       %{version}
Release:       %{release}
Source0:       piklab-%{version}.tar.bz2
License:       GPL
Group:         Development/Other
Url:           http://piklab.sourceforge.net/

BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: qt3-devel
BuildRequires: libusb-devel libreadline-devel ncurses-devel
BuildRequires: cmake

Conflicts:     piklab piklab-prog-qt3
Packager:      hadacek@kde.org
Provides:      piklab-prog piklab-hex

%description
"piklab-prog" is a command-line programmer and debugger for PIC and dsPIC
microcontrollers. It supports GPSim, and several Microchip and direct
programmers.
"piklab-hex" is a command-line utility to manipulate hex files.
"piklab-coff" is a command-line utility to view COFF and library files.

%prep
%setup -q -n piklab-%{version}

%build
export QTDIR=%_prefix/%{_lib}/qt4
export LD_LIBRARY_PATH=$QTDIR/%{_lib}:$LD_LIBRARY_PATH
export PATH=$QTDIR/bin:$PATH
export QTLIB=$QTDIR/%{_lib}
cmake -DQT_ONLY=1 -DCMAKE_INSTALL_PREFIX=%{buildroot}/usr/.
%make

%install
rm -rf %{buildroot}
%makeinstall
%find_lang piklab

%clean
rm -rf %{buildroot}

%files -f piklab.lang
%defattr(755,root,root)
%{_bindir}/*
%defattr(644,root,root,755)
%{_mandir}/man1/*
%{_docdir}/piklab/*

%changelog
* Tue Jun 22 2010 Nicolas Hadacek <hadacek@kde.org> 0.15.9-1mdv2008.0
- new upstream release
* Sat May 1 2010 Nicolas Hadacek <hadacek@kde.org> 0.15.8-1mdv2008.0
- new upstream release
* Sat Oct 24 2009 Nicolas Hadacek <hadacek@kde.org> 0.15.7-1mdv2008.0
- new upstream release
* Tue Sep 29 2009 Nicolas Hadacek <hadacek@kde.org> 0.15.6-1mdv2008.0
- new upstream release
* Wed Sep 9 2009 Nicolas Hadacek <hadacek@kde.org> 0.15.5-1mdv2008.0
- new upstream release
* Sat Nov 22 2008 Nicolas Hadacek <hadacek@kde.org> 0.15.4-1mdv2008.0
- new upstream release
* Sun Mar 23 2008 Nicolas Hadacek <hadacek@kde.org> 0.15.3-1mdv2008.0
- new upstream release
* Sun Nov 25 2007 Nicolas Hadacek <hadacek@kde.org> 0.15.2-1mdv2008.0
- new upstream release
* Sun Nov 11 2007 Nicolas Hadacek <hadacek@kde.org> 0.15.1-1mdv2008.0
- fixes
* Sat Oct 20 2007 Nicolas Hadacek <hadacek@kde.org> 0.15.0-1mdv2007.0
- new release
* Fri Aug 17 2007 Nicolas Hadacek <hadacek@kde.org> 0.14.5-1mdv2007.0
- fix
* Sun Aug 5 2007 Nicolas Hadacek <hadacek@kde.org> 0.14.4-1mdv2007.0
- fixes
* Fri Jul 27 2007 Nicolas Hadacek <hadacek@kde.org> 0.14.3-1mdk
- fixes + new features
* Mon Apr 9 2007 Nicolas Hadacek <hadacek@kde.org> 0.14.2-1mdk
- fixes + new features
* Sun Mar 11 2007 Nicolas Hadacek <hadacek@kde.org> 0.14.1-1mdk
- fixes + new feature
* Sun Mar 4 2007 Nicolas Hadacek <hadacek@kde.org> 0.14.0-1mdk
- new version
* Thu Feb 8 2007 Nicolas Hadacek <hadacek@kde.org> 0.13.3-1mdk
- fixes
* Wed Jan 31 2007 Nicolas Hadacek <hadacek@kde.org> 0.13.2-1mdk
- fixes
* Sun Jan 28 2007 Nicolas Hadacek <hadacek@kde.org> 0.13.1-1mdk
- fixes
* Fri Jan 19 2007 Nicolas Hadacek <hadacek@kde.org> 0.13.0-1mdk
- new version
* Mon Oct 16 2006 Nicolas Hadacek <hadacek@kde.org> 0.12.2-1mdk
- fixes
* Sun Oct 15 2006 Nicolas Hadacek <hadacek@kde.org> 0.12.1-1mdk
- fixes
* Sun Oct 1 2006 Nicolas Hadacek <hadacek@kde.org> 0.12.0-1mdk
- new version
* Tue Sep 5 2006 Nicolas Hadacek <hadacek@kde.org> 0.11.2-1mdk
- more fixes
* Wed Aug 23 2006 Nicolas Hadacek <hadacek@kde.org> 0.11.1-1mdk
- some fixes
* Sun Aug 20 2006 Nicolas Hadacek <hadacek@kde.org> 0.11.0-1mdk
- new version
