#!/bin/sh

BASEDIR="../src/" # root of translatable sources
PROJECT="piklab" # project name
BUGADDR="http://sourceforge.net/tracker/?group_id=138852&atid=743140" # MSGID-Bugs
WDIR=`pwd` # working dir

echo "Preparing rc files"
cd ${BASEDIR}
# we use simple sorting to make sure the lines do not jump around too much from system to system
find . -name '*.rc' -o -name '*.ui' -o -name '*.kcfg' | sort > ${WDIR}/rcfiles.list
xargs --arg-file=${WDIR}/rcfiles.list extractrc > ${WDIR}/rc.cpp
# additional string for KAboutData
echo 'i18n("_: NAME OF TRANSLATORS\\n"\n"Your names");' >> ${WDIR}/rc.cpp
echo 'i18n("_: EMAIL OF TRANSLATORS\\n"\n"Your emails");' >> ${WDIR}/rc.cpp
cd ${WDIR}
echo "Done preparing rc files"

echo "Extracting messages"
cd ${BASEDIR}
# see above on sorting
find . -name '*.cpp' -o -name '*.h' -o -name '*.c' | sort > ${WDIR}/infiles.list
echo "rc.cpp" >> ${WDIR}/infiles.list
kdepotpath=${includedir:-`kde-config --expandvars --install include`}/kde.pot
if ! test -f $kdepotpath; then
    kdepotpath=`kde-config --expandvars --prefix`/include/kde.pot
fi
cd ${WDIR}
xgettext --foreign-user -C -ci18n -ki18n -ktr2i18n -kI18N_NOOP -kI18N_NOOP2 -kaliasLocale -x ${kdepotpath} -s \
         --msgid-bugs-address="${BUGADDR}" \
         --files-from=infiles.list -D ${BASEDIR} -D ${WDIR} -o ${PROJECT}.pot || { echo "error while calling xgettext. aborting."; exit 1; }
echo "Done extracting messages"

echo "Merging translations"
catalogs=`find . -name '*.po'`
for cat in $catalogs; do
  echo $cat
  msgmerge -o $cat.new $cat ${PROJECT}.pot
  mv $cat.new $cat
done
echo "Done merging translations"

echo "Cleaning up"
cd ${WDIR}
rm rcfiles.list
rm infiles.list
rm rc.cpp
echo "Done"
