/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef GLOBAL_H
#define GLOBAL_H

#include <memory>
#include <map>
#include <vector>

#include <qglobal.h>
#include <qdatastream.h>
#include <qstringlist.h>
#include <qobject.h>
#include <qdir.h>

#if defined(NO_KDE)
#  include <QCoreApplication>
#  include <QPointer>

#  include <Q3ValueVector>
#  include <Q3ValueList>
#  include <Q3MemArray>
#  include <Q3Url>
#  include <Q3MimeSourceFactory>

#  define QValueVector Q3ValueVector
#  define QValueList Q3ValueList
#  define QMemArray Q3MemArray

#  include "common/nokde/nokde_kurl.h"
#  include "common/nokde/nokde_klocale.h"
#  include "common/nokde/nokde_kcmdlineargs.h"
#  include "common/nokde/nokde_kaboutdata.h"
#else
#  include <qapplication.h>
#  include <qvaluevector.h>
#  include <qvaluelist.h>
#  include <qmemarray.h>
#  include <qurl.h>
#  include <qguardedptr.h>

   typedef QUrl Q3Url;

#  define qMax QMAX
#  define qMin QMIN
#  define qSort qHeapSort
#  define QPointer QGuardedPtr
#  define Q3StrList QStrList
#  define Q3PtrList QPtrList
#  define Q3PtrListIterator QPtrListIterator
#  define qobject_cast qt_cast

#  include <kapplication.h>
#  include <kglobal.h>
#  include <klocale.h>
#  include <kcmdlineargs.h>
#  include <ktempfile.h>
#  include <kconfigbackend.h>
#  include <kaboutdata.h>

#  include "common/common/qflags.h"
#endif

#if defined(Q_OS_WIN)
#  include <windows.h>
#endif

#include "config.h"

#endif
