/***************************************************************************
 *   Copyright (C) 2006-2010 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef DIALOG_H
#define DIALOG_H

#include "global_ui.h"
#include "misc_gui.h"
#include "list_view.h"
#include "common/global/process.h"

#ifdef NO_KDE
#  include "common/nokde_gui/nokde_dialog.h"
#else
#  include <kdialogbase.h>
#endif

//-----------------------------------------------------------------------------
class Dialog : public KDialogBase
{
Q_OBJECT
public:
  Dialog(QWidget *parent, const char *name, bool modal,
         const QString &caption, int buttonMask, ButtonCode defaultButton, bool separator,
         const QSize &defaultSize = QSize());
  Dialog(DialogType type, const QString &caption,
         int buttonMask, ButtonCode defaultButton, QWidget *parent, const char *name,
         bool modal, bool separator, const QSize &defaultSize = QSize());
  virtual ~Dialog();

  static int spacingHint();

private slots:
  void updateSize();

private:
  QSize                       _defaultSize;
  std::auto_ptr<BusyCursorStarter> _busyCursor;
};

//-----------------------------------------------------------------------------
class TreeListDialog : public Dialog
{
Q_OBJECT
public:
  TreeListDialog(QWidget *parent, const char *name, bool modal,
                 const QString &caption, int buttonMask, ButtonCode defaultButton, bool separator);
  QWidget *addPage(const QStringList &labels);
  void showPage(QWidget *page);
  int activePageIndex() const;
  int pageIndex(QWidget *page) const;

private slots:
  virtual void currentChanged(Q3ListViewItem *item);
  void pageDestroyed(QObject *page);

protected:
  QFrame        *_frame;
  ListView      *_listView;
  QHBoxLayout   *_titleBox;
  QLabel        *_label;
  Q3WidgetStack *_stack;

 class Item : public KListViewItem {
  public:
    Item(const QString &label, QWidget *page, const QString &title, Q3ListView *listview);
    Item(const QString &label, QWidget *page, const QString &title, Q3ListViewItem *item);
    QWidget *_page;
    QString  _title;
  };
};

//-----------------------------------------------------------------------------
class TextEditorDialog : public Dialog
{
Q_OBJECT
public:
  TextEditorDialog(const QString &text, const QString &caption,
                   bool wrapAtWidgetWidth, QWidget *parent);
};

//-----------------------------------------------------------------------------
namespace Process
{

class SynchronousDialog : public Dialog
{
Q_OBJECT
public:
    SynchronousDialog(const QString& msg);

public slots:
  void finished();
};

extern State runSynchronouslyDialog(Base &process, RunActions actions, const QString& msg);

} // namespace

#endif
