/***************************************************************************
 *   Copyright (C) 2009 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef GLOBAL_UI_H
#define GLOBAL_UI_H

#include "common/common/global.h"

#include <qvalidator.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qpainter.h>
#include <qradiobutton.h>

#ifdef NO_KDE

#  include <QLineEdit>
#  include <QTabBar>
#  include <QTabWidget>
#  include <QComboBox>
#  include <QPushButton>
#  include <QMessageBox>
#  include <QWheelEvent>
#  include <QApplication>
#  include <QPainter>
#  include <QMetaObject>
#  include <QMetaProperty>
#  include <QToolButton>
#  include <QStatusBar>

#  include <Q3ListView>
#  include <Q3WidgetStack>
#  include <Q3Frame>
#  include <Q3Header>
#  include <Q3TextEdit>
#  include <Q3PopupMenu>
#  include <Q3VGroupBox>
#  include <Q3Grid>
#  include <Q3VButtonGroup>
#  include <Q3PointArray>
#  include <Q3TextBrowser>
#  include <Q3ScrollView>
#  include <Q3Wizard>
#  include <Q3StrList>
#  include <Q3UriDrag>
#  include <Q3ProgressBar>

   typedef QTabBar KTabBar;
   typedef QTabWidget KTabWidget;
   typedef QComboBox KComboBox;
   typedef Q3CheckListItem KCheckListItem;
   typedef Q3TextEdit KTextEdit;
   typedef Qt::Alignment Q3Alignment;
   typedef Q3TextBrowser KTextBrowser;
   typedef Q3Wizard KWizard;
   class KAction;
   class KActionCollection;

#else // NO_KDE

#  include <qwidgetstack.h>
#  include <qframe.h>
#  include <qheader.h>
#  include <qvgroupbox.h>
#  include <qgrid.h>
#  include <qvbuttongroup.h>
#  include <qtooltip.h>
#  include <qtoolbutton.h>
#  include <qpointarray.h>
#  include <qscrollview.h>
#  include <qprogressbar.h>
#  include <qdragobject.h>
#  include <qstyle.h>

#  include <klineedit.h>
#  include <ktabbar.h>
#  include <ktabwidget.h>
#  include <kcombobox.h>
#  include <kpushbutton.h>
#  include <kcursor.h>
#  include <klistview.h>
#  include <ktextedit.h>
#  include <kmessagebox.h>
#  include <kpopupmenu.h>
#  include <kiconloader.h>
#  include <ktextbrowser.h>
#  include <kurlrequester.h>
#  include <kurllabel.h>
#  include <knuminput.h>
#  include <kfiledialog.h>
#  include <ktextbrowser.h>
#  include <kactionclasses.h>
#  include <kwizard.h>
#  include <kstatusbar.h>
#  include <kmenubar.h>
#  include <kedittoolbar.h>

   typedef QListView Q3ListView;
   typedef QListViewItem Q3ListViewItem;
   typedef QCheckListItem Q3CheckListItem;
   typedef QListViewItemIterator Q3ListViewItemIterator;
   typedef QWidgetStack Q3WidgetStack;
   typedef QFrame Q3Frame;
   typedef QPopupMenu Q3PopupMenu;
   typedef int Q3Alignment;
   typedef QVGroupBox Q3VGroupBox;
   typedef QGroupBox Q3GroupBox;
   typedef QGrid Q3Grid;
   typedef QButtonGroup Q3ButtonGroup;
   typedef QVButtonGroup Q3VButtonGroup;
   typedef QDragObject Q3DragObject;
   typedef QUriDrag Q3UriDrag;
   typedef QPointArray Q3PointArray;
   typedef QTextEdit Q3TextEdit;
   typedef QTextBrowser Q3TextBrowser;
   typedef QScrollView Q3ScrollView;
   typedef QProgressBar Q3ProgressBar;
   typedef QMimeSourceFactory Q3MimeSourceFactory;

#endif // NO_KDE

#endif
