/***************************************************************************
 *   Copyright (C) 2010 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "kde_listview.h"
#include "kde_listview.moc"

//-----------------------------------------------------------------------------
ListViewBase::ListViewBase(QWidget *parent, const char *name )
: KListView(parent, name)
{
  connect(this, SIGNAL(clicked(QListViewItem*)),
          SLOT(clickedSlot(QListViewItem*)));
  connect(this, SIGNAL(clicked(QListViewItem*, const QPoint&, int)),
          SLOT(clickedSlot(QListViewItem*, const QPoint&, int)));
  connect(this, SIGNAL(currentChanged(QListViewItem*)),
          SLOT(currentChangedSlot(QListViewItem*)));
  connect(this, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)),
          SLOT(contextMenuRequestedSlot(QListViewItem*, const QPoint&, int)));
  connect(this, SIGNAL(mouseButtonClicked(int, QListViewItem*, const QPoint&, int)),
          SLOT(mouseButtonClickedSlot(int, QListViewItem*, const QPoint&, int)));
  connect(this, SIGNAL(itemRenamed(QListViewItem*, int, const QString&)),
          SLOT(itemRenamedSlot(QListViewItem*, int, const QString&)));
  connect(this, SIGNAL(doubleClicked(QListViewItem*, const QPoint&, int)),
          SLOT(doubleClickedSlot(QListViewItem*, const QPoint&, int)));
}

void ListViewBase::clickedSlot(QListViewItem* item)
{
  emit clicked(static_cast<Q3ListViewItem*>(item));
}

void ListViewBase::clickedSlot(QListViewItem* item, const QPoint& pos, int column)
{
  emit clicked(static_cast<Q3ListViewItem*>(item), pos, column);
}

void ListViewBase::currentChangedSlot(QListViewItem* item)
{
  emit currentChanged(static_cast<Q3ListViewItem*>(item));
}

void ListViewBase::contextMenuRequestedSlot(QListViewItem *item, const QPoint &pos, int column)
{
  emit contextMenuRequested(static_cast<Q3ListViewItem*>(item), pos, column);
}

void ListViewBase::mouseButtonClickedSlot(int button, QListViewItem *item, const QPoint &pos, int column)
{
  emit mouseButtonClicked(button, static_cast<Q3ListViewItem*>(item), pos, column);
}

void ListViewBase::itemRenamedSlot(QListViewItem *item, int column, const QString& text)
{
  emit itemRenamed(static_cast<Q3ListViewItem*>(item), column, text);
}

void ListViewBase::doubleClickedSlot(QListViewItem *item, const QPoint &pos, int column)
{
  emit doubleClicked(static_cast<Q3ListViewItem*>(item), pos, column);
}
