/***************************************************************************
 *   Copyright (C) 2010 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef KDE_LISTVIEW_H
#define KDE_LISTVIEW_H

#include <klistview.h>

#include "common/gui/global_ui.h"

//-----------------------------------------------------------------------------
// this is a bridge class to map signals on QListViewItem to Q3ListViewItem
class ListViewBase : public KListView
{
Q_OBJECT
public:
  ListViewBase(QWidget *parent = NULL, const char *name = NULL);

signals:
  void clicked(Q3ListViewItem* item);
  void clicked(Q3ListViewItem* item, const QPoint &pos, int column);
  void currentChanged(Q3ListViewItem* item);
  void contextMenuRequested(Q3ListViewItem *item, const QPoint &pos, int column);
  void mouseButtonClicked(int button, Q3ListViewItem *item, const QPoint &pos, int column);
  void itemRenamed(Q3ListViewItem *item, int column, const QString &text);
  void doubleClicked(Q3ListViewItem *item, const QPoint &pos, int column);

private slots:
  void clickedSlot(QListViewItem* item);
  void clickedSlot(QListViewItem* item, const QPoint &pos, int column);
  void currentChangedSlot(QListViewItem *item);
  void contextMenuRequestedSlot(QListViewItem *item, const QPoint &pos, int column);
  void mouseButtonClickedSlot(int button, QListViewItem *item, const QPoint &pos, int column);
  void itemRenamedSlot(QListViewItem *item, int column, const QString &text);
  void doubleClickedSlot(QListViewItem *item, const QPoint &pos, int column);
};

#endif
