#ifndef _KURL_H_
#define _KURL_H_

#include <qfile.h>
#include <qtemporaryfile.h>

#include "common/common/global.h"

class KURL : public Q3Url
{
public:
  KURL() {}
  KURL(const QString &s) : Q3Url(s) {}
  void cleanPath() {}
  bool isEmpty() const { return toString(false, false).isEmpty(); }
  QString fileName(bool b) const { Q_UNUSED(b); Q_ASSERT(!b); return Q3Url::fileName(); }
  QString htmlURL() const { return toString(); }
  QString url() { return encodedPathAndQuery(); }
  QString prettyURL() const { return toString(false, false); }
  static KURL fromPathOrURL(const QString &s) { return KURL(s); }
  bool operator <(const KURL &url) const { return path()<url.path(); }
  bool operator ==(const KURL &url) const { return path()==url.path(); }
  bool operator !=(const KURL &url) const { return path()!=url.path(); }
};

class KTempFile
{
public:
  const QFile *file() const { return &_file; }
  QFile *file() { return &_file; }

private:
  QTemporaryFile _file;
};

#endif
